/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.app.formula.function;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.kscript.IFunctionProvider;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.eas.scm.framework.bizflow.WBFunctionException;
import com.kingdee.eas.scm.framework.bizflow.WriteBackFunctionCollection;
import com.kingdee.eas.scm.framework.bizflow.WriteBackFunctionFactory;
import com.kingdee.eas.scm.framework.bizflow.WriteBackFunctionInfo;
import com.kingdee.eas.scm.framework.bizflow.app.formula.function.IBatchCustomerFunction;
import com.kingdee.eas.scm.framework.bizflow.app.formula.function.ICustomerFunction;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomerFunctionProvider
implements IFunctionProvider {
    private Map<String, ICustomerFunction> functionCache = new HashMap<String, ICustomerFunction>();

    public CustomerFunctionProvider(Context ctx) throws BOSException {
        WriteBackFunctionCollection coll = WriteBackFunctionFactory.getLocalInstance(ctx).getWriteBackFunctionCollection();
        WriteBackFunctionInfo function = null;
        try {
            for (int i = 0; i < coll.size(); ++i) {
                function = coll.get(i);
                this.functionCache.put(function.getName(), this.getFunctionExecutor(function));
            }
        }
        catch (WBFunctionException e) {
            throw new BOSException(e.getMessage());
        }
    }

    public Object evalFunction(String funcName, List paramList) throws KScriptException {
        Context ctx = (Context)paramList.get(0);
        paramList.remove(0);
        try {
            ICustomerFunction executor = this.functionCache.get(funcName);
            return executor.execFunction(ctx, paramList);
        }
        catch (Exception e) {
            throw new KScriptException(e.getMessage(), e.getCause());
        }
    }

    private ICustomerFunction getFunctionExecutor(WriteBackFunctionInfo function) throws WBFunctionException {
        if (function == null) {
            return null;
        }
        String className = function.getClassName();
        if (StringUtil.isEmpty((String)className)) {
            return null;
        }
        ICustomerFunction executor = null;
        try {
            Class<?> clazz = Class.forName(className);
            Object handler = clazz.newInstance();
            if (!(handler instanceof ICustomerFunction) && !(handler instanceof IBatchCustomerFunction)) {
                throw new WBFunctionException(WBFunctionException.CLASSNOTIMPLINTERFACE);
            }
            executor = (ICustomerFunction)handler;
        }
        catch (ClassNotFoundException e) {
            throw new WBFunctionException(WBFunctionException.CLASSNOTFOUNT, new String[]{className});
        }
        catch (InstantiationException e1) {
            throw new WBFunctionException(WBFunctionException.CLASSNEWINSTANCEERROR, new String[]{e1.getMessage()});
        }
        catch (IllegalAccessException e2) {
            throw new WBFunctionException(WBFunctionException.CLASSNEWINSTANCEERROR, new String[]{e2.getMessage()});
        }
        return executor;
    }

    public boolean existFunction(String funcName) {
        return this.functionCache.containsKey(funcName);
    }
}

