/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.condition.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.framework.condition.ConditionEngineFacadeFactory;
import com.kingdee.eas.scm.framework.condition.ConditionException;
import com.kingdee.eas.scm.framework.condition.ConditionFieldInfo;
import com.kingdee.eas.scm.framework.condition.ConditionResultInfo;
import com.kingdee.eas.scm.framework.condition.DetermineParamInfo;
import com.kingdee.eas.scm.framework.condition.DetermineResultInfo;
import com.kingdee.eas.scm.framework.condition.FieldTypeEnum;
import com.kingdee.eas.scm.framework.condition.KeyValue;
import com.kingdee.eas.scm.framework.condition.ProcedureDeterminationCollection;
import com.kingdee.eas.scm.framework.condition.ProcedureDeterminationFactory;
import com.kingdee.eas.scm.framework.condition.ProcedureDeterminationInfo;
import com.kingdee.eas.scm.framework.condition.ProcedureDeterminationItemCollection;
import com.kingdee.eas.scm.framework.condition.ProcedureInfo;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeInfo;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeMappingCollection;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeMappingFactory;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeMappingInfo;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeMappingItemCollection;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeMappingItemInfo;
import com.kingdee.eas.scm.framework.condition.SourceTypeEnum;
import com.kingdee.eas.scm.framework.condition.app.AbstractConditionEngineServiceFacadeControllerBean;
import com.kingdee.eas.scm.framework.condition.model.BillProcedureInfo;
import com.kingdee.eas.scm.framework.condition.util.ConditionUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConditionEngineServiceFacadeControllerBean
extends AbstractConditionEngineServiceFacadeControllerBean {
    private static final long serialVersionUID = -3377595887974114L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.framework.condition.app.ConditionEngineServiceFacadeControllerBean");
    boolean hasInitCondtion = false;
    private Map<String, List<String>> ptid2BillPropertyMap4All = new HashMap<String, List<String>>();
    private Map<String, ProcedureTypeMappingInfo> id2ProcedureTypeMappingMap = new HashMap<String, ProcedureTypeMappingInfo>();
    private Map<String, ProcedureDeterminationInfo> determId2ProcedureDeterminationMap = new HashMap<String, ProcedureDeterminationInfo>();
    private Map<String, List<BillProcedureInfo>> billProcedureMap = new HashMap<String, List<BillProcedureInfo>>();
    private Map<String, List<BillProcedureInfo>> billProcedureType2ProcedureMap = new HashMap<String, List<BillProcedureInfo>>();
    private Map<String, Map<String, String>> ptid2BillPropertyMap4Determ = new HashMap<String, Map<String, String>>();
    private Map<String, ProcedureTypeInfo> determin2ProcedureTypeMap = new HashMap<String, ProcedureTypeInfo>();

    @Override
    protected List _initConditionEngine(Context ctx, String billType) throws BOSException, EASBizException {
        this.hasInitCondtion = false;
        this.ptid2BillPropertyMap4All = new HashMap<String, List<String>>();
        this.id2ProcedureTypeMappingMap = new HashMap<String, ProcedureTypeMappingInfo>();
        this.determId2ProcedureDeterminationMap = new HashMap<String, ProcedureDeterminationInfo>();
        this.billProcedureMap = new HashMap<String, List<BillProcedureInfo>>();
        this.billProcedureType2ProcedureMap = new HashMap<String, List<BillProcedureInfo>>();
        this.ptid2BillPropertyMap4Determ = new HashMap<String, Map<String, String>>();
        this.determin2ProcedureTypeMap = new HashMap<String, ProcedureTypeInfo>();
        this.initCondition(ctx, billType);
        return null;
    }

    @Override
    protected List _executeConditionEngine(Context ctx, IObjectValue billModel) throws BOSException, EASBizException {
        ArrayList list = new ArrayList();
        if (billModel == null) {
            return list;
        }
        String billType = billModel.getBOSType().toString();
        this.initCondition(ctx, billType);
        this.determineProcedure(ctx, billModel);
        this.determineConditionValue(ctx, billModel);
        return list;
    }

    private void initCondition(Context ctx, String billType) throws EASBizException, BOSException {
        if (this.hasInitCondtion) {
            return;
        }
        this.initProcedureTypeMapping(ctx, billType);
        this.initProcedureDeterm(ctx, billType);
        this.hasInitCondtion = true;
    }

    private void initProcedureTypeMapping(Context ctx, String billType) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billType", (Object)billType, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("items.*"));
        sic.add(new SelectorItemInfo("items.conditionField.*"));
        sic.add(new SelectorItemInfo("procedureType.*"));
        view.setSelector(sic);
        ProcedureTypeMappingCollection col = ProcedureTypeMappingFactory.getLocalInstance(ctx).getProcedureTypeMappingCollection(view);
        ProcedureTypeMappingInfo info = null;
        List<Object> allMappingList = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            info = col.get(i);
            String procedureTypeId = info.getProcedureType().getId().toString();
            allMappingList = this.ptid2BillPropertyMap4All.containsKey(procedureTypeId) ? this.ptid2BillPropertyMap4All.get(procedureTypeId) : new ArrayList();
            this.id2ProcedureTypeMappingMap.put(procedureTypeId, info);
            ProcedureTypeMappingItemCollection itemCol = info.getItems();
            int len = itemCol.size();
            for (int index = 0; index < len; ++index) {
                ProcedureTypeMappingItemInfo item = itemCol.get(index);
                allMappingList.add(item.getFieldExpr());
            }
            this.ptid2BillPropertyMap4All.put(procedureTypeId, allMappingList);
        }
    }

    private void initProcedureDeterm(Context ctx, String billType) throws EASBizException, BOSException {
        ProcedureDeterminationCollection col = ConditionEngineFacadeFactory.getLocalInstance(ctx).getProDeterminationCollection(billType);
        ProcedureDeterminationInfo determInfo = null;
        String procedureTypeId = "";
        String procedureDetermId = "";
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            determInfo = col.get(i);
            this.determId2ProcedureDeterminationMap.put(determInfo.getId().toString(), determInfo);
            procedureTypeId = determInfo.getProcedureType().getId().toString();
            procedureDetermId = determInfo.getId().toString();
            ProcedureTypeMappingInfo procedureTypeMapping = this.id2ProcedureTypeMappingMap.get(procedureTypeId);
            ProcedureTypeMappingItemCollection mappingItems = procedureTypeMapping.getItems();
            ProcedureDeterminationItemCollection determItems = determInfo.getItems();
            int jsize = determItems.size();
            for (int j = 0; j < jsize; ++j) {
                Map<Object, Object> determMappingMap = null;
                determMappingMap = this.ptid2BillPropertyMap4Determ.containsKey(procedureDetermId) ? this.ptid2BillPropertyMap4Determ.get(procedureDetermId) : new HashMap<String, String>();
                determMappingMap.put("FBillType", billType);
                int nsize = mappingItems.size();
                for (int n = 0; n < nsize; ++n) {
                    if (!mappingItems.get(n).getConditionField().getId().toString().equals(determItems.get(j).getConditionField().getId().toString())) continue;
                    determMappingMap.put(mappingItems.get(n).getConditionField().getNumber(), mappingItems.get(n).getFieldExpr());
                    this.ptid2BillPropertyMap4Determ.put(procedureDetermId, determMappingMap);
                }
            }
        }
    }

    private void determineProcedure(Context ctx, IObjectValue billModel) throws EASBizException, BOSException {
        if (billModel == null) {
            return;
        }
        String billType = billModel.getBOSType().toString();
        IObjectCollection entries = null;
        entries = (IObjectCollection)billModel.get("entry");
        if (entries == null) {
            entries = (IObjectCollection)billModel.get("entries");
        }
        if (entries == null) {
            String entryPropertyName = "";
            entryPropertyName = ConditionUtil.getBillEntryPropertyName(billType);
            entries = (IObjectCollection)billModel.get(entryPropertyName);
        }
        ArrayList<DetermineParamInfo> paramList = new ArrayList<DetermineParamInfo>();
        Iterator<Map.Entry<String, Map<String, String>>> it = this.ptid2BillPropertyMap4Determ.entrySet().iterator();
        String billPropertyName = "";
        while (it.hasNext()) {
            paramList.clear();
            Map.Entry<String, Map<String, String>> entry = it.next();
            String determId = entry.getKey();
            Map<String, String> billPropertyMap = entry.getValue();
            ProcedureDeterminationInfo determProcedureInfo = this.determId2ProcedureDeterminationMap.get(determId);
            String procedureTypeId = determProcedureInfo.getProcedureType().getId().toString();
            boolean hasEntry = ConditionUtil.isDeterminContainsEntry(ctx, determProcedureInfo, billType.toString());
            if (hasEntry) {
                if (CollectionUtil.isEmpty((IObjectCollection)entries)) continue;
                int size = entries.size();
                for (int i = 0; i < size; ++i) {
                    IObjectValue entryModel = entries.getObject(i);
                    DetermineParamInfo paramInfo = new DetermineParamInfo();
                    paramInfo.setEntryMatchProcedure(hasEntry);
                    paramInfo.setDetermineId(determId);
                    paramInfo.setBillID(billModel.get("ID") != null ? billModel.get("ID").toString() : null);
                    paramInfo.setEntryID(entryModel.get("ID") != null ? entryModel.get("ID").toString() : null);
                    paramInfo.setBillModel(billModel);
                    paramInfo.setEntryModel(entryModel);
                    paramInfo.setSeq(entryModel.getInt("seq"));
                    billPropertyName = "";
                    paramInfo.setEntryMatchProcedure(hasEntry);
                    paramInfo.setDetermineId(determId);
                    String key = "";
                    for (Map.Entry<String, String> entry1 : billPropertyMap.entrySet()) {
                        KeyValue keyVal;
                        key = entry1.getKey();
                        billPropertyName = entry1.getValue();
                        if ("FBillType".equalsIgnoreCase(key)) {
                            KeyValue keyVal2 = new KeyValue(key, billType);
                            paramInfo.addFieldVal(keyVal2);
                            continue;
                        }
                        Object compValue = null;
                        if (billModel.get(billPropertyName) != null) {
                            compValue = billModel.get(billPropertyName);
                        } else {
                            String entryPropertyName = billPropertyName.substring(billPropertyName.indexOf(".") + 1);
                            if (entryModel.get(entryPropertyName) != null) {
                                compValue = entryModel.get(entryPropertyName);
                            }
                        }
                        if (compValue instanceof IObjectValue) {
                            keyVal = new KeyValue(key, ((IObjectValue)compValue).get("id").toString());
                            paramInfo.addFieldVal(keyVal);
                            continue;
                        }
                        keyVal = new KeyValue(key, compValue);
                        paramInfo.addFieldVal(keyVal);
                    }
                    paramList.add(paramInfo);
                }
            } else {
                DetermineParamInfo paramInfo = new DetermineParamInfo();
                paramInfo.setEntryMatchProcedure(hasEntry);
                paramInfo.setDetermineId(determId);
                String key = "";
                for (Map.Entry<String, String> entry1 : billPropertyMap.entrySet()) {
                    KeyValue keyVal;
                    key = entry1.getKey();
                    billPropertyName = entry1.getValue();
                    if ("FBillType".equalsIgnoreCase(key)) {
                        KeyValue keyVal3 = new KeyValue(key, billType);
                        paramInfo.addFieldVal(keyVal3);
                        continue;
                    }
                    Object compValue = null;
                    if (billModel.get(billPropertyName) != null) {
                        compValue = billModel.get(billPropertyName);
                    }
                    if (compValue instanceof IObjectValue) {
                        keyVal = new KeyValue(key, ((IObjectValue)compValue).get("id").toString());
                        paramInfo.addFieldVal(keyVal);
                        continue;
                    }
                    keyVal = new KeyValue(key, compValue);
                    paramInfo.addFieldVal(keyVal);
                }
                paramList.add(paramInfo);
            }
            DetermineResultInfo resultInfo = ConditionEngineFacadeFactory.getLocalInstance(ctx).determineProcedure(billModel.getBOSType(), paramList);
            this.billProcedureMap = resultInfo.getBillProcedureMap();
            this.initBillProceduereType2ProcedureMap(ctx);
        }
    }

    private void initBillProceduereType2ProcedureMap(Context ctx) {
        try {
            this.initBillProcedureTypeByDeterm(ctx);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Map.Entry<String, List<BillProcedureInfo>> entry : this.billProcedureMap.entrySet()) {
            String determineId = entry.getKey();
            if (!this.determin2ProcedureTypeMap.containsKey(determineId)) continue;
            ProcedureTypeInfo procedureType = this.determin2ProcedureTypeMap.get(determineId);
            String procedureTypeID = procedureType.getId().toString();
            List<Object> list = new ArrayList();
            if (this.billProcedureType2ProcedureMap.get(procedureTypeID) != null) {
                list = this.billProcedureType2ProcedureMap.get(procedureTypeID);
            }
            list.addAll(entry.getValue());
            this.billProcedureType2ProcedureMap.put(procedureTypeID, list);
        }
    }

    private void initBillProcedureTypeByDeterm(Context ctx) throws Exception {
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<String, List<BillProcedureInfo>> entry : this.billProcedureMap.entrySet()) {
            String determineId = entry.getKey();
            set.add(determineId);
        }
        if (CollectionUtil.isEmpty(set)) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("procedureType.*"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        ProcedureDeterminationCollection col = ProcedureDeterminationFactory.getLocalInstance(ctx).getProcedureDeterminationCollection(view);
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return;
        }
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            ProcedureDeterminationInfo info = col.get(i);
            this.determin2ProcedureTypeMap.put(info.getId().toString(), info.getProcedureType());
        }
    }

    private void determineConditionValue(Context ctx, IObjectValue billModel) throws EASBizException, BOSException {
        for (Map.Entry<String, ProcedureTypeMappingInfo> entry : this.id2ProcedureTypeMappingMap.entrySet()) {
            this.determineConditionValue(ctx, entry.getKey(), billModel);
        }
        System.out.println(billModel);
    }

    private void determineConditionValue(Context ctx, String procedureTypeId, IObjectValue billModel) throws EASBizException, BOSException {
        if (StringUtil.isEmpty((String)procedureTypeId) || billModel == null) {
            return;
        }
        String billType = billModel.getBOSType().toString();
        ProcedureTypeMappingInfo mappingInfo = this.id2ProcedureTypeMappingMap.get(procedureTypeId);
        if (mappingInfo == null) {
            return;
        }
        ProcedureTypeMappingItemCollection mappingItemCol = mappingInfo.getItems();
        List<BillProcedureInfo> billProcedureList = this.billProcedureType2ProcedureMap.get(procedureTypeId);
        if (CollectionUtil.isEmpty(billProcedureList)) {
            return;
        }
        BillProcedureInfo billProcedureInfo = null;
        ProcedureInfo procedureInfo = null;
        IObjectCollection entries = null;
        entries = (IObjectCollection)billModel.get("entry");
        if (entries == null) {
            entries = (IObjectCollection)billModel.get("entries");
        }
        if (entries == null) {
            String entryPropertyName = "";
            entryPropertyName = ConditionUtil.getBillEntryPropertyName(billType);
            entries = (IObjectCollection)billModel.get(entryPropertyName);
        }
        int nsize = billProcedureList.size();
        for (int n = 0; n < nsize; ++n) {
            billProcedureInfo = billProcedureList.get(n);
            procedureInfo = billProcedureInfo.getProcedureInfo();
            int msize = entries.size();
            for (int m = 0; m < msize; ++m) {
                IObjectValue entryModel = entries.getObject(m);
                if (billProcedureInfo.getSeq() != -1 && billProcedureInfo.getSeq() != entryModel.getInt("seq")) continue;
                DetermineParamInfo paramInfo = new DetermineParamInfo();
                paramInfo.setBillModel(billModel);
                paramInfo.setEntryModel(entryModel);
                paramInfo.setDetermineId(procedureInfo.getId().toString());
                HashSet<ProcedureTypeMappingItemInfo> outputField = new HashSet<ProcedureTypeMappingItemInfo>();
                Object val = null;
                Object compValue = null;
                int size = mappingItemCol.size();
                block6: for (int i = 0; i < size; ++i) {
                    compValue = null;
                    ProcedureTypeMappingItemInfo mappingItem = mappingItemCol.get(i);
                    ConditionFieldInfo conFieldInfo = mappingItem.getConditionField();
                    switch (conFieldInfo.getIoType().getValue()) {
                        case 2: {
                            outputField.add(mappingItem);
                        }
                        case 3: {
                            continue block6;
                        }
                        default: {
                            SourceTypeEnum mappingType = mappingItem.getMappingType();
                            String fieldExpr = mappingItem.getFieldExpr();
                            if (SourceTypeEnum.CONTEXT.equals((Object)mappingType)) {
                                val = this.getContextValue(ctx, fieldExpr);
                            } else if (SourceTypeEnum.CONSTANT.equals((Object)mappingType)) {
                                val = this.getConstantValue(billType, conFieldInfo, fieldExpr);
                            } else if (SourceTypeEnum.MAPPING.equals((Object)mappingType)) {
                                String billPropertyName = mappingItem.getFieldExpr();
                                if (billModel.get(billPropertyName) != null) {
                                    val = billModel.get(billPropertyName);
                                } else {
                                    String entryPropertyName = billPropertyName.substring(billPropertyName.indexOf(".") + 1);
                                    if (entryModel.get(entryPropertyName) != null) {
                                        val = entryModel.get(entryPropertyName);
                                    }
                                }
                            }
                            if (this.isEmpty(val) && mappingItem.isRequired()) {
                                throw new ConditionException(ConditionException.CONDITION_CONFIG_VALUE_ISNULL, new Object[]{fieldExpr});
                            }
                            compValue = val instanceof IObjectValue ? ((IObjectValue)val).get("id").toString() : val;
                            paramInfo.addFieldVal(new KeyValue(mappingItem.getConditionField().getId().toString(), compValue));
                        }
                    }
                }
                ConditionResultInfo result = ConditionEngineFacadeFactory.getLocalInstance(ctx).queryResult(billModel.getBOSType(), paramInfo);
                for (ProcedureTypeMappingItemInfo itemInfo : outputField) {
                    Object value = result.getResult(itemInfo.getConditionField().getNumber());
                    this.setConditionValue2Bill(billModel, entryModel, itemInfo.getFieldExpr(), itemInfo.isReplace(), value);
                }
            }
        }
    }

    private void setConditionValue2Bill(IObjectValue billModel, IObjectValue entryModel, String configProperty, boolean isReplace, Object conditionValue) {
        boolean isBillProperty;
        BigDecimal num;
        if (conditionValue == null) {
            return;
        }
        if (conditionValue instanceof BigDecimal && !NumericUtil.isGreaterthanZero((BigDecimal)(num = (BigDecimal)conditionValue))) {
            return;
        }
        boolean bl = isBillProperty = configProperty.indexOf(".") < 0;
        if (isBillProperty) {
            if (billModel.get(configProperty) == null || isReplace) {
                billModel.put(configProperty, conditionValue);
            }
        } else {
            String entryPropertyName = configProperty.substring(configProperty.indexOf(".") + 1);
            if (entryModel.get(entryPropertyName) == null || isReplace) {
                entryModel.put(entryPropertyName, conditionValue);
            }
        }
    }

    private Object getContextValue(Context ctx, String key) throws EASBizException, BOSException {
        AdminOrgUnitInfo val = null;
        if ("admin".equals(key)) {
            val = ContextUtil.getCurrentAdminUnit((Context)ctx);
        } else if ("company".equals(key)) {
            val = ContextUtil.getCurrentFIUnit((Context)ctx);
        } else if ("costCenter".equals(key)) {
            val = ContextUtil.getCurrentCostUnit((Context)ctx);
        } else if ("cu".equals(key)) {
            val = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        } else if ("hro".equals(key)) {
            val = ContextUtil.getCurrentHRUnit((Context)ctx);
        } else if ("purchase".equals(key)) {
            val = ContextUtil.getCurrentPurchaseUnit((Context)ctx);
        } else if ("quality".equals(key)) {
            val = ContextUtil.getCurrentQualityUnit((Context)ctx);
        } else if ("sale".equals(key)) {
            val = ContextUtil.getCurrentSaleUnit((Context)ctx);
        } else if ("storage".equals(key)) {
            val = ContextUtil.getCurrentStorageUnit((Context)ctx);
        } else if ("transport".equals(key)) {
            val = ContextUtil.getCurrentTransportUnit((Context)ctx);
        } else if ("user".equals(key)) {
            val = ContextUtil.getCurrentUserInfo((Context)ctx);
        } else {
            throw new ConditionException(ConditionException.CONDITION_CONTEXT_CONFIG_ERR, new Object[]{key});
        }
        return val;
    }

    private Object getConstantValue(String billType, ConditionFieldInfo conFieldInfo, String fieldExpr) throws EASBizException, BOSException {
        if (fieldExpr.equals(billType)) {
            return fieldExpr;
        }
        FieldTypeEnum fieldType = conFieldInfo.getType();
        Comparable<BigDecimal> val = null;
        if (FieldTypeEnum.NUMERIC.equals((Object)fieldType)) {
            val = new BigDecimal(fieldExpr);
        } else {
            if (FieldTypeEnum.DATE.equals((Object)fieldType) || FieldTypeEnum.DATETIME.equals((Object)fieldType) || FieldTypeEnum.TIME.equals((Object)fieldType)) {
                try {
                    val = new SimpleDateFormat("yyyy-mm-dd HH:MM:ss").parse(fieldExpr);
                }
                catch (ParseException e) {
                    throw new ConditionException(ConditionException.CONDITION_CONSTANT_CONFIG_DATE_ERR, new Object[]{fieldExpr});
                }
            }
            if (FieldTypeEnum.ENUM.equals((Object)fieldType)) {
                String number = conFieldInfo.getNumber();
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(number);
                }
                catch (ClassNotFoundException e) {
                    throw new ConditionException(ConditionException.CONDITION_CONSTANT_CONFIG_ENUM_ERR, new Object[]{number});
                }
                if (IntEnum.class.isAssignableFrom(clazz)) {
                    val = EnumUtils.getEnum(clazz, (int)Integer.parseInt(fieldExpr));
                } else if (FloatEnum.class.isAssignableFrom(clazz)) {
                    val = EnumUtils.getEnum(clazz, (float)Float.parseFloat(fieldExpr));
                } else if (DoubleEnum.class.isAssignableFrom(clazz)) {
                    val = EnumUtils.getEnum(clazz, (double)Double.parseDouble(fieldExpr));
                } else if (LongEnum.class.isAssignableFrom(clazz)) {
                    val = EnumUtils.getEnum(clazz, (long)Long.parseLong(fieldExpr));
                } else if (StringEnum.class.isAssignableFrom(clazz)) {
                    val = EnumUtils.getEnum(clazz, (String)fieldExpr);
                }
            } else if (FieldTypeEnum.ENTITY.equals((Object)fieldType)) {
                String number = conFieldInfo.getNumber();
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(number);
                }
                catch (ClassNotFoundException e) {
                    throw new ConditionException(ConditionException.CONDITION_CONSTANT_CONFIG_ENTITY_ERR, new Object[]{number});
                }
                CoreBaseInfo info = null;
                try {
                    info = (CoreBaseInfo)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new ConditionException(ConditionException.CONDITION_CONSTANT_CONFIG_ENTITY_INIT_ERR, new Object[]{number});
                }
                info.setId(BOSUuid.read((String)fieldExpr));
                val = info;
            } else {
                throw new ConditionException(ConditionException.CONDITION_CONSTANT_CONFIG_VALUE_ERR, new Object[]{fieldType, fieldExpr});
            }
        }
        return val;
    }

    private boolean isEmpty(Object value) {
        return null == value || "".equals(value);
    }
}

