/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.condition.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.scm.framework.UseStatusEnum;
import com.kingdee.eas.scm.framework.condition.AccessSequenceCollection;
import com.kingdee.eas.scm.framework.condition.AccessSequenceFactory;
import com.kingdee.eas.scm.framework.condition.AccessesCollection;
import com.kingdee.eas.scm.framework.condition.AccessesFactory;
import com.kingdee.eas.scm.framework.condition.ConTableTypeEnum;
import com.kingdee.eas.scm.framework.condition.ConditionException;
import com.kingdee.eas.scm.framework.condition.ConditionFieldInfo;
import com.kingdee.eas.scm.framework.condition.ConditionTableCollection;
import com.kingdee.eas.scm.framework.condition.ConditionTableInfo;
import com.kingdee.eas.scm.framework.condition.IAccessSequence;
import com.kingdee.eas.scm.framework.condition.IAccesses;
import com.kingdee.eas.scm.framework.condition.IOType;
import com.kingdee.eas.scm.framework.condition.SelectedFieldCollection;
import com.kingdee.eas.scm.framework.condition.app.AbstractConditionTableControllerBean;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class ConditionTableControllerBean
extends AbstractConditionTableControllerBean {
    private static final long serialVersionUID = -3613294533554642593L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.framework.condition.app.ConditionTableControllerBean");

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("selectedFields.*");
        selector.add("selectedFields.conditionField.*");
        ConditionTableInfo info = this.getConditionTableInfo(ctx, pk, selector);
        if (UseStatusEnum.INACTIVE.equals((Object)info.getStatus())) {
            throw new EASBizException(ConditionException.CONDITIONTABLE_ISINACTIVED, new Object[]{info.getNumber()});
        }
        this.updateConditionTableStatus(ctx, pk, UseStatusEnum.INACTIVE);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("selectedFields.*");
        selector.add("selectedFields.conditionField.*");
        ConditionTableInfo info = this.getConditionTableInfo(ctx, pk, selector);
        if (UseStatusEnum.ACTIVE.equals((Object)info.getStatus())) {
            throw new EASBizException(ConditionException.CONDITIONTABLE_ISACTIVED, new Object[]{info.getNumber()});
        }
        if (StringUtils.isEmpty((String)info.getTableName())) {
            this.generateConditionRecordTable(ctx, info);
        } else if (UseStatusEnum.INACTIVE.equals((Object)info.getStatus())) {
            this.modifyConditionRecordTable(ctx, info);
        }
        this.updateConditionTableStatus(ctx, pk, UseStatusEnum.ACTIVE);
    }

    private void cancelCancelTable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("selectedFields.*");
        selector.add("selectedFields.conditionField.*");
        ConditionTableInfo info = this.getConditionTableInfo(ctx, pk, selector);
        if (StringUtils.isEmpty((String)info.getTableName())) {
            this.generateConditionRecordTable(ctx, info);
        } else if (UseStatusEnum.INACTIVE.equals((Object)info.getStatus())) {
            this.modifyConditionRecordTable(ctx, info);
        }
    }

    private void cancelTable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("selectedFields.*");
        selector.add("selectedFields.conditionField.*");
        ConditionTableInfo info = this.getConditionTableInfo(ctx, pk, selector);
        this.dropConditionRecordTable(ctx, info);
    }

    private void generateConditionRecordTable(Context ctx, ConditionTableInfo info) throws EASBizException, BOSException {
        if (info == null) {
            return;
        }
        SelectedFieldCollection fieldCol = info.getSelectedFields();
        String tableName = "T_CT_" + info.getNumber();
        this.createDBTable(ctx, fieldCol, tableName);
        String sql = "update t_ct_conditiontable set FtableName = ? where fid = ?";
        Object[] params = new Object[]{tableName, info.getId().toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    private void dropConditionRecordTable(Context ctx, ConditionTableInfo info) throws BOSException {
        if (info == null) {
            return;
        }
        if (!StringUtil.isEmpty((String)info.getTableName()) && info.getType() == ConTableTypeEnum.New) {
            String sql = "drop table " + info.getTableName();
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "update t_ct_conditiontable set FtableName = ? where fid = ?";
            Object[] params = new Object[]{null, info.getId().toString()};
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
    }

    private void modifyConditionRecordTable(Context ctx, ConditionTableInfo info) throws BOSException {
        if (ConTableTypeEnum.New != info.getType()) {
            return;
        }
        Connection conn = null;
        ResultSet rs = null;
        HashMap columnMap = new HashMap();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            DatabaseMetaData metaData = conn.getMetaData();
            rs = metaData.getColumns(null, "%", info.getTableName(), "%");
            while (rs.next()) {
                columnMap.put(rs.getString("COLUMN_NAME").toUpperCase(), null);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)conn);
        SelectedFieldCollection fieldCol = info.getSelectedFields();
        ArrayList<TableColumn> columnList = new ArrayList<TableColumn>();
        int size = fieldCol.size();
        for (int i = 0; i < size; ++i) {
            ConditionFieldInfo fieldInfo = fieldCol.get(i).getConditionField();
            String columnName = fieldInfo.getNumber().toUpperCase();
            if (fieldInfo.isRangeMatch() ? columnMap.containsKey(columnName + "FROM") || columnMap.containsKey(columnName + "TO") : columnMap.containsKey(columnName)) continue;
            TableColumn tabColumn = this.getTableColumn(fieldInfo);
            if (IOType.INPUT.equals((Object)fieldInfo.getIoType()) && fieldInfo.isRangeMatch()) {
                tabColumn.setName(tabColumn.getName() + "FROM");
                columnList.add(tabColumn);
                tabColumn = this.getTableColumn(fieldInfo);
                tabColumn.setName(tabColumn.getName() + "TO");
            }
            columnList.add(tabColumn);
        }
        this.alterDBTable(ctx, columnList, info.getTableName());
    }

    private void alterDBTable(Context ctx, List<TableColumn> columnList, String tableName) throws BOSException {
        String[] sqls = new String[columnList.size()];
        int size = columnList.size();
        for (int i = 0; i < size; ++i) {
            TableColumn column = columnList.get(i);
            StringBuilder sb = new StringBuilder();
            sb.append("if not exists (select * from ksql_usercolumns where ksql_col_tabname='" + tableName + "' and ksql_col_name='" + column.getName() + "')\n");
            sb.append("ALTER TABLE ").append(tableName).append(" ADD ").append(column.getName()).append(column.getType());
            if (column.isNotNull()) {
                sb.append(" NOT NULL ");
            }
            if (!StringUtils.isEmpty((String)column.getDefaultVal())) {
                sb.append(" default ").append(column.getDefaultVal());
            }
            sb.append(";");
            sqls[i] = sb.toString();
        }
        DBUtil.executeBatch((Context)ctx, (String[])sqls);
    }

    private void createDBTable(Context ctx, SelectedFieldCollection fieldCol, String tableName) throws EASBizException, BOSException {
        ArrayList<TableColumn> columnList = new ArrayList<TableColumn>(fieldCol.size());
        int size = fieldCol.size();
        for (int i = 0; i < size; ++i) {
            ConditionFieldInfo field = fieldCol.get(i).getConditionField();
            TableColumn column = this.getTableColumn(field);
            if (field.isRangeMatch()) {
                column.setName(column.getName() + "From");
                columnList.add(column);
                column = this.getTableColumn(field);
                column.setName(column.getName() + "To");
            }
            columnList.add(column);
        }
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ").append(tableName).append("( FID VARCHAR(44) DEFAULT '' NOT NULL PRIMARY KEY , ");
        for (TableColumn col : columnList) {
            sql.append(col.getName()).append(col.getType());
            if (col.isNotNull()) {
                // empty if block
            }
            if (!StringUtils.isEmpty((String)col.getDefaultVal())) {
                sql.append(" default ").append(col.getDefaultVal());
            }
            sql.append(",");
        }
        sql.setLength(sql.length() - 1);
        sql.append(" ); ");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            throw new ConditionException(ConditionException.CONDITIONTABLE_NAME_INVALID, new Object[]{tableName});
        }
    }

    private TableColumn getTableColumn(ConditionFieldInfo conFieldInfo) {
        TableColumn dbTableField = new TableColumn();
        dbTableField.setName(conFieldInfo.getNumber());
        dbTableField.setNotNull(true);
        switch (conFieldInfo.getType().getValue()) {
            case 9: {
                dbTableField.setType(" NUMERIC(" + conFieldInfo.getPrecision() + "," + conFieldInfo.getFraction() + ") ");
                dbTableField.setDefaultVal(" 0 ");
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                dbTableField.setType(" DateTime ");
                break;
            }
            case 1: {
                dbTableField.setType(" VARCHAR(44) ");
                dbTableField.setDefaultVal(" '' ");
                break;
            }
            case 8: {
                dbTableField.setType(" varchar(20) ");
                break;
            }
            case 10: {
                int len = conFieldInfo.getPrecision() == 0 ? 255 : conFieldInfo.getPrecision();
                dbTableField.setType(" varchar(" + len + ") ");
                break;
            }
        }
        return dbTableField;
    }

    private void updateConditionTableStatus(Context ctx, IObjectPK pk, UseStatusEnum status) throws BOSException {
        String sql = "update T_CT_ConditionTable set fstatus = ? , fauditorid = ? , faudittime = ? where fid = ? ";
        Object[] params = new Object[4];
        params[0] = status.getValue();
        if (UseStatusEnum.ACTIVE.equals((Object)status)) {
            params[1] = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            params[2] = new Timestamp(System.currentTimeMillis());
        } else {
            params[1] = null;
            params[2] = null;
        }
        params[3] = pk.toString();
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    @Override
    protected List _setState(Context ctx, List pkList, UseStatusEnum status) throws BOSException, EASBizException {
        int i;
        ArrayList<ConditionException> list = new ArrayList<ConditionException>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet set = new HashSet(pkList);
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        ConditionTableCollection col = this.getConditionTableCollection(ctx, view);
        if (col == null || col.size() == 0) {
            return list;
        }
        ArrayList<String> allowList = new ArrayList<String>();
        StringBuffer errors = new StringBuffer(20);
        ConditionTableInfo conditionTable = null;
        int size = col.size();
        for (i = 0; i < size; ++i) {
            conditionTable = col.get(i);
            if (2 == status.getValue() && 2 == conditionTable.getStatus().getValue()) {
                errors.append("," + conditionTable.getNumber());
                list.add(new ConditionException(ConditionException.CONDITIONTABLE_ISINACTIVED, new Object[]{conditionTable.getNumber()}));
                continue;
            }
            if (1 == status.getValue() && 1 == conditionTable.getStatus().getValue()) {
                errors.append("," + conditionTable.getNumber());
                list.add(new ConditionException(ConditionException.CONDITIONTABLE_ISACTIVED, new Object[]{conditionTable.getNumber()}));
                continue;
            }
            allowList.add(conditionTable.getId().toString());
            conditionTable.setStatus(status);
        }
        if (allowList.size() > 0) {
            String sql = "update T_CT_ConditionTable set fstatus=" + status.getValue() + " where fid in(" + CollectionUtil.convertList2String(allowList) + ")";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        size = allowList.size();
        for (i = 0; i < size; ++i) {
            String id = (String)allowList.get(i);
            ObjectUuidPK pk = new ObjectUuidPK(id);
            if (1 == status.getValue()) {
                this.cancelCancelTable(ctx, (IObjectPK)pk);
                continue;
            }
            this.cancelTable(ctx, (IObjectPK)pk);
        }
        return list;
    }

    @Override
    protected void _checkHasReferenced(Context ctx, List idList) throws BOSException, EASBizException {
        if (CollectionUtil.isEmpty((Collection)idList)) {
            return;
        }
        ConditionTableInfo conditionTable = null;
        IAccesses iAccesses = AccessesFactory.getLocalInstance(ctx);
        IAccessSequence iAccessSeq = AccessSequenceFactory.getLocalInstance(ctx);
        ArrayList<ConditionException> exList = new ArrayList<ConditionException>();
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            String id = "";
            id = (String)idList.get(i);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("conditiontable.id", (Object)id, CompareType.EQUALS));
            view.setFilter(filter);
            AccessesCollection col = iAccesses.getAccessesCollection(view);
            if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) continue;
            HashSet<String> ids = new HashSet<String>();
            int nsize = col.size();
            for (int n = 0; n < nsize; ++n) {
                ids.add(col.get(n).getParent().getId().toString());
            }
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            view.setFilter(filter);
            AccessSequenceCollection col1 = iAccessSeq.getAccessSequenceCollection(view);
            StringBuilder sb = new StringBuilder();
            int nsize2 = col1.size();
            for (int n = 0; n < nsize2; ++n) {
                sb.append(",\u3010" + col1.get(n).getNumber() + "\u3011");
            }
            sb.delete(0, 1);
            conditionTable = this.getConditionTableInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
            exList.add(new ConditionException(ConditionException.CONDITIONTABLE_HASREFERENCED, new Object[]{conditionTable.getNumber(), sb.toString()}));
        }
        if (CollectionUtil.isEmpty(exList)) {
            return;
        }
        StringBuilder exsb = new StringBuilder();
        int size2 = exList.size();
        for (int i = 0; i < size2; ++i) {
            exsb.append(((ConditionException)((Object)exList.get(i))).getMessage());
            exsb.append("\n");
        }
        throw new BOSException(exsb.toString());
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ConditionTableInfo cTInfo = (ConditionTableInfo)this._getValue(ctx, pk);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("conditionTable.id", (Object)cTInfo.getId().toString()));
        view.setFilter(filterInfo);
        AccessesCollection accessCollection = AccessesFactory.getLocalInstance(ctx).getAccessesCollection(view);
        if (accessCollection != null && !accessCollection.isEmpty()) {
            throw new ConditionException(ConditionException.CONDITIONTABLE_NOT_DELETE, new Object[]{cTInfo.getNumber()});
        }
        super._delete(ctx, pk);
    }

    private class TableColumn {
        private String name;
        private String type;
        private boolean notNull;
        private String defaultVal;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean isNotNull() {
            return this.notNull;
        }

        public void setNotNull(boolean notNull) {
            this.notNull = notNull;
        }

        public String getDefaultVal() {
            return this.defaultVal;
        }

        public void setDefaultVal(String defaultVal) {
            this.defaultVal = defaultVal;
        }

        TableColumn() {
        }
    }
}

