/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.condition.app.formula.engine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.parser.Token;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.scm.framework.condition.app.formula.engine.ConditionInterpreter;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConditionExceptionMsgInterpreter {
    private EntityObjectInfo srcEntity;
    private EntityObjectInfo destEntity;
    private ConditionInterpreter interpreter;

    public ConditionExceptionMsgInterpreter(EntityObjectInfo srcEntity, EntityObjectInfo destEntity, ConditionInterpreter interpreter) {
        this.srcEntity = srcEntity;
        this.destEntity = destEntity;
        this.interpreter = interpreter;
    }

    public String eval(Map ctx, String exceptionMsg) throws BOSException {
        StringBuffer expMessage = new StringBuffer();
        List<Token> tokenList = this.getTokenList(exceptionMsg);
        for (Token token : tokenList) {
            if (token.type == 2) {
                expMessage.append(this.evalExpression(ctx, token.value));
                continue;
            }
            expMessage.append(token.value);
        }
        return expMessage.toString();
    }

    public String evalExpression(Map ctx, String exprAlias) throws BOSException {
        String expr = this.getFormualExprByAlias(exprAlias);
        Object value = this.interpreter.eval(expr, ctx);
        if (value != null) {
            if (value instanceof BigDecimal) {
                return StringUtil.subZeroAndDot((String)((BigDecimal)value).toPlainString());
            }
            return value.toString();
        }
        return "ExpressionError";
    }

    private List<Token> getTokenList(String exceptionMsg) throws ParserException {
        ArrayList<Token> tokenList = new ArrayList<Token>();
        return tokenList;
    }

    private String getFormualExprByAlias(String formualAlias) throws ParserException {
        return "";
    }
}

