/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.condition.app.formula.engine;

import com.kingdee.bos.Context;
import com.kingdee.bos.kscript.IFunctionProvider;
import com.kingdee.bos.kscript.IObjectLoaderProvider;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.TypeUtils;
import com.kingdee.bos.kscript.debug.DebugStopException;
import com.kingdee.bos.kscript.dom.CodeObject;
import com.kingdee.bos.kscript.dom.expr.ArrayIndexerExpr;
import com.kingdee.bos.kscript.dom.expr.BigDecimalExpr;
import com.kingdee.bos.kscript.dom.expr.BinaryOpExpr;
import com.kingdee.bos.kscript.dom.expr.BoolExpr;
import com.kingdee.bos.kscript.dom.expr.CharExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.ConditionExpr;
import com.kingdee.bos.kscript.dom.expr.DoubleExpr;
import com.kingdee.bos.kscript.dom.expr.FloatExpr;
import com.kingdee.bos.kscript.dom.expr.IdentifierExpr;
import com.kingdee.bos.kscript.dom.expr.IntExpr;
import com.kingdee.bos.kscript.dom.expr.LongExpr;
import com.kingdee.bos.kscript.dom.expr.MethodInvokeExpr;
import com.kingdee.bos.kscript.dom.expr.NullExpr;
import com.kingdee.bos.kscript.dom.expr.PropertyExpr;
import com.kingdee.bos.kscript.dom.expr.StringExpr;
import com.kingdee.bos.kscript.dom.expr.UnaryExpr;
import com.kingdee.bos.kscript.dom.stmt.BlockStmt;
import com.kingdee.bos.kscript.dom.stmt.CodeStmt;
import com.kingdee.bos.kscript.dom.stmt.ElseIfItem;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.bos.kscript.dom.stmt.IfStmt;
import com.kingdee.bos.kscript.dom.stmt.ReturnStmt;
import com.kingdee.bos.kscript.parser.ExprParser;
import com.kingdee.bos.kscript.parser.KScriptParser;
import com.kingdee.bos.kscript.parser.Source;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.kscript.runtime.InterpreterException;
import com.kingdee.bos.kscript.runtime.KScriptUtil;
import com.kingdee.bos.kscript.runtime.PrimitiveBoolean;
import com.kingdee.bos.kscript.runtime.PrimitiveCharacter;
import com.kingdee.bos.kscript.runtime.PrimitiveDouble;
import com.kingdee.bos.kscript.runtime.PrimitiveFloat;
import com.kingdee.bos.kscript.runtime.PrimitiveInt;
import com.kingdee.bos.kscript.runtime.PrimitiveLong;
import com.kingdee.bos.kscript.runtime.PrimitiveValue;
import com.kingdee.bos.kscript.runtime.ReflectionUtils;
import com.kingdee.bos.kscript.runtime.ToString;
import com.kingdee.eas.scm.framework.condition.app.formula.function.CustomerFunctionProvider;
import com.kingdee.util.TODOException;
import com.kingdee.util.Uuid;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import org.apache.log4j.Logger;

public class ConditionInterpreter {
    private static Logger log = Logger.getLogger((String)"com.kingdee.eas.scm.framework.bizflow.app.fomula.engine.WriteBackInterpreter");
    public static final String KS_COLLECT_VALUE = "_KS_VALUE";
    public static final String KS_COLLECT_SIZE = "_KS_SIZE";
    public static final String BOS_CONTEXT_KEY = "__bosContext";
    private static List<String> internalFunctionList = new ArrayList<String>();
    public static final List<IFunctionProvider> publicFuncProviderList = new ArrayList<IFunctionProvider>();
    private Source source = null;
    private Object _defaultObject;
    public List<String> namespaces = new ArrayList<String>();
    public List<IFunctionProvider> funcProviderList = new ArrayList<IFunctionProvider>();
    private Map<String, Object> classMap = new HashMap<String, Object>();
    private boolean synchronizedCallMethod = false;
    private boolean properyExprOwnerNullIgore = true;
    private IObjectLoaderProvider bizObjectProvider = null;
    private Map<String, KScriptParser> parserCache = new HashMap<String, KScriptParser>();

    public ConditionInterpreter(Object bosContext) {
        this(bosContext, false);
    }

    public ConditionInterpreter(Context bosContext) {
        this(bosContext, false);
    }

    public ConditionInterpreter() {
        this(null, false);
    }

    public ConditionInterpreter(Object context, boolean supportDebug) {
        this.namespaces.add("java.lang");
        this.namespaces.add("java.util");
        this.classMap.put("boolean", Boolean.TYPE);
        this.classMap.put("boolean[]", boolean[].class);
        this.classMap.put("char", Character.TYPE);
        this.classMap.put("char[]", char[].class);
        this.classMap.put("[C", char[].class);
        this.classMap.put("byte", Byte.TYPE);
        this.classMap.put("byte[]", byte[].class);
        this.classMap.put("[B", byte[].class);
        this.classMap.put("short", Short.TYPE);
        this.classMap.put("short[]", short[].class);
        this.classMap.put("[S", short[].class);
        this.classMap.put("int", Integer.TYPE);
        this.classMap.put("int[]", int[].class);
        this.classMap.put("[I", int[].class);
        this.classMap.put("long", Long.TYPE);
        this.classMap.put("long[]", long[].class);
        this.classMap.put("[J", long[].class);
        this.classMap.put("float", Float.TYPE);
        this.classMap.put("float[]", float[].class);
        this.classMap.put("[F", float[].class);
        this.classMap.put("double", Double.TYPE);
        this.classMap.put("double[]", double[].class);
        this.classMap.put("[D", double[].class);
        try {
            this.bizObjectProvider = (IObjectLoaderProvider)Class.forName("com.kingdee.bos.dao.ormapping.KscriptObjectLoaderProvider").newInstance();
        }
        catch (InstantiationException e) {
            log.warn((Object)"cannot registe defaultObjectLoaderProvider[com.kingdee.bos.dao.ormapping.KscriptObjectLoaderProvider]. Because : InstantiationException");
        }
        catch (IllegalAccessException e) {
            log.warn((Object)"cannot registe defaultObjectLoaderProvider[com.kingdee.bos.dao.ormapping.KscriptObjectLoaderProvider]. Because : IllegalAccessException");
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)"cannot registe defaultObjectLoaderProvider[com.kingdee.bos.dao.ormapping.KscriptObjectLoaderProvider]. Because : ClassNotFoundException");
        }
        int publicFuncProviderListSize = publicFuncProviderList.size();
        for (int i = 0; i < publicFuncProviderListSize; ++i) {
            this.funcProviderList.add(publicFuncProviderList.get(i));
        }
        this.setBOSContext(context);
    }

    public void setBOSContext(Context ctx) {
        this.setBOSContext((Object)ctx);
    }

    public void setBOSContext(Object ctx) {
        if (this.bizObjectProvider != null) {
            this.bizObjectProvider.setContext(ctx);
        }
    }

    public Object getBOSContext() {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.getContext();
        }
        return null;
    }

    public void setBizObjectProvider(IObjectLoaderProvider bizObjectProvider) {
        this.bizObjectProvider = bizObjectProvider;
    }

    public IObjectLoaderProvider getBizObjectProvider() {
        return this.bizObjectProvider;
    }

    public void addFunctionProvider(IFunctionProvider funcProvider) {
        this.funcProviderList.add(funcProvider);
    }

    public Source getSource() {
        return this.source;
    }

    private String getContext(Map context) {
        return "Context:=" + ToString.toString((Object)context);
    }

    public Object eval(String text, Map context) throws InterpreterException, ParserException {
        return this.eval(text, context, true);
    }

    public synchronized Object eval(String text, Map context, boolean unboxValue) throws InterpreterException, ParserException {
        Object rtnValue = null;
        if (context == null) {
            context = new HashMap();
        }
        KScriptParser parser = this.getParser(text);
        this.source = parser.source;
        List stmtList = parser.stmtList;
        if (stmtList.size() == 1) {
            CodeExpr expr = null;
            if (stmtList.get(0) instanceof ExprStmt) {
                expr = ((ExprStmt)stmtList.get((int)0)).expr;
                rtnValue = this.evalExprInternal(expr, context);
            } else if (stmtList.get(0) instanceof ReturnStmt) {
                expr = ((ReturnStmt)stmtList.get((int)0)).expr;
                rtnValue = this.evalExprInternal(expr, context);
            } else {
                rtnValue = this.evalBlockStmtList(stmtList, context);
            }
        }
        if (unboxValue) {
            if (rtnValue instanceof PrimitiveValue) {
                rtnValue = ((PrimitiveValue)rtnValue).getBoxValue();
            }
            Object[] keyArray = context.keySet().toArray();
            for (int i = 0; i < keyArray.length; ++i) {
                Object val = context.get(keyArray[i]);
                if (!(val instanceof PrimitiveValue)) continue;
                val = ((PrimitiveValue)val).getBoxValue();
                context.put(keyArray[i], val);
            }
        }
        return rtnValue;
    }

    private KScriptParser getParser(String text) throws ParserException {
        String key = ConditionInterpreter.mkCRC(text);
        KScriptParser result = this.parserCache.get(key);
        if (result == null) {
            result = new KScriptParser(text, this.namespaces, this.classMap);
            result.parse();
            this.parserCache.put(key, result);
        }
        return result;
    }

    private static String mkCRC(String string) {
        CRC32 crc32 = new CRC32();
        crc32.update(string.getBytes());
        return Long.toHexString(crc32.getValue());
    }

    private Object evalBlockStmtList(List stmtList, Map context) throws InterpreterException {
        CodeStmt stmt;
        Object rtnValue = NoneReturnValue.NoneReturn;
        Iterator iter = stmtList.iterator();
        while (iter.hasNext() && (rtnValue = this.evalStmt(stmt = (CodeStmt)iter.next(), context)) == NoneReturnValue.NoneReturn) {
        }
        return rtnValue;
    }

    private Object evalStmt(CodeStmt stmt, Map context) throws InterpreterException {
        Object rtnValue = null;
        if (stmt != null) {
            if (stmt instanceof ExprStmt) {
                ExprStmt exprStmt = (ExprStmt)stmt;
                rtnValue = this.evalExprInternal(exprStmt.expr, context);
            } else if (stmt instanceof ReturnStmt) {
                ReturnStmt rtnStmt = (ReturnStmt)stmt;
                rtnValue = this.evalExprInternal(rtnStmt.expr, context);
            } else if (stmt instanceof IfStmt) {
                IfStmt ifStmt = (IfStmt)stmt;
                Object testValue = this.evalExprInternal(ifStmt.testExpr, context);
                if (testValue instanceof PrimitiveValue) {
                    testValue = ((PrimitiveValue)testValue).getBoxValue();
                }
                boolean flag = false;
                if (testValue.equals(Boolean.TRUE)) {
                    rtnValue = this.evalBlockStmtList(ifStmt.trueStmtList, context);
                    flag = true;
                } else {
                    for (ElseIfItem elseIf : ifStmt.elseIfList) {
                        testValue = this.evalExprInternal(elseIf.testExpr, context);
                        if (testValue instanceof PrimitiveValue) {
                            testValue = ((PrimitiveValue)testValue).getBoxValue();
                        }
                        if (!testValue.equals(Boolean.TRUE)) continue;
                        rtnValue = this.evalBlockStmtList(elseIf.stmtList, context);
                        flag = true;
                    }
                    if (!flag) {
                        rtnValue = this.evalBlockStmtList(ifStmt.elseStmtList, context);
                    }
                }
            } else if (stmt instanceof BlockStmt) {
                BlockStmt blockStmt = (BlockStmt)stmt;
                rtnValue = this.evalBlockStmtList(blockStmt.stmtList, context);
            } else {
                throw (InterpreterException)new InterpreterException("UNSUPPORT. stmt's class is : " + stmt.getClass().getName(), (CodeObject)stmt).setInfoId("UNSUPPORTED_STATEMENT").addArg((Object)stmt.getClass().getName()).addArg((Object)stmt.toString()).setErrorLineCode(this.getSource());
            }
        }
        return rtnValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object evalExprInternal(CodeExpr expr, Map context) throws InterpreterException {
        if (expr == null) {
            throw new IllegalArgumentException();
        }
        try {
            Object rtnValue = null;
            if (expr instanceof BinaryOpExpr) {
                try {
                    return this.evalBinaryOpExpr((BinaryOpExpr)expr, context);
                }
                catch (Exception ex) {
                    if (!(ex instanceof InterpreterException)) return rtnValue;
                    throw ex;
                }
            }
            if (expr instanceof IdentifierExpr) {
                return this.evalIndentExpr((IdentifierExpr)expr, context);
            }
            if (expr instanceof PropertyExpr) {
                return this.evalPropExpr((PropertyExpr)expr, context);
            }
            if (expr instanceof ConditionExpr) {
                return this.evalConditionExpr((ConditionExpr)expr, context);
            }
            if (expr instanceof MethodInvokeExpr) {
                return this.evalMethodInvokeExpr((MethodInvokeExpr)expr, context);
            }
            if (expr instanceof BoolExpr) {
                return ((BoolExpr)expr).val ? PrimitiveBoolean.TRUE : PrimitiveBoolean.FALSE;
            }
            if (expr instanceof CharExpr) {
                return new PrimitiveCharacter(((CharExpr)expr).val);
            }
            if (expr instanceof NullExpr) {
                return null;
            }
            if (expr instanceof IntExpr) {
                return new PrimitiveInt(((IntExpr)expr).intValue());
            }
            if (expr instanceof LongExpr) {
                return new PrimitiveLong(((LongExpr)expr).longValue());
            }
            if (expr instanceof FloatExpr) {
                return new PrimitiveFloat(((FloatExpr)expr).floatValue());
            }
            if (expr instanceof DoubleExpr) {
                return new PrimitiveDouble(((DoubleExpr)expr).doubleValue());
            }
            if (expr instanceof BigDecimalExpr) {
                return ((BigDecimalExpr)expr).value;
            }
            if (expr instanceof StringExpr) {
                return ((StringExpr)expr).getJavaString();
            }
            if (!(expr instanceof UnaryExpr)) throw (InterpreterException)new InterpreterException("UNSUPPORT, expr class : " + expr.getClass().getName(), (CodeObject)expr).setInfoId("UNSUPPORTED_STATEMENT").addArg((Object)expr.getClass().getName()).addArg((Object)expr.toString()).setErrorLineCode(this.getSource());
            return this.evalUnaryExpr((UnaryExpr)expr, context);
        }
        catch (Throwable ex) {
            if (ex instanceof DebugStopException) {
                throw (DebugStopException)ex;
            }
            if (!(ex instanceof InterpreterException)) throw (InterpreterException)new InterpreterException(ex.toString(), (CodeObject)expr, ex).setErrorLineCode(this.getSource());
            if (((InterpreterException)ex).getErrorLineNum() != 0) throw (InterpreterException)ex;
            if (expr == null) throw (InterpreterException)ex;
            if (expr.position == null) throw (InterpreterException)ex;
            ((InterpreterException)ex).setErrorLineNum(expr.position.beginLine);
            ((InterpreterException)ex).setErrorLineCode(this.getSource());
            throw (InterpreterException)ex;
        }
    }

    private Object evalBinaryOpExpr(BinaryOpExpr expr, Map context) throws InterpreterException {
        Object rtnVal;
        if (expr.operator == 2) {
            return this.assign(expr.left, expr.right, context);
        }
        if (expr.operator == 28) {
            BinaryOpExpr addExpr = new BinaryOpExpr(expr.position);
            addExpr.left = expr.left;
            addExpr.operator = 0;
            addExpr.right = expr.right;
            return this.assign(expr.left, (CodeExpr)addExpr, context);
        }
        if (expr.operator == 29) {
            BinaryOpExpr subExpr = new BinaryOpExpr(expr.position);
            subExpr.left = expr.left;
            subExpr.operator = 26;
            subExpr.right = expr.right;
            return this.assign(expr.left, (CodeExpr)subExpr, context);
        }
        if (expr.operator == 30) {
            BinaryOpExpr mulExpr = new BinaryOpExpr(expr.position);
            mulExpr.left = expr.left;
            mulExpr.operator = 22;
            mulExpr.right = expr.right;
            return this.assign(expr.left, (CodeExpr)mulExpr, context);
        }
        if (expr.operator == 31) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 9;
            divExpr.right = expr.right;
            return this.assign(expr.left, (CodeExpr)divExpr, context);
        }
        if (expr.operator == 32) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 21;
            divExpr.right = expr.right;
            return this.assign(expr.left, (CodeExpr)divExpr, context);
        }
        if (expr.operator == 33) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 17;
            divExpr.right = expr.right;
            return this.assign(expr.left, (CodeExpr)divExpr, context);
        }
        if (expr.operator == 34) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 19;
            divExpr.right = expr.right;
            return this.assign(expr.left, (CodeExpr)divExpr, context);
        }
        if (expr.operator == 35) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 27;
            divExpr.right = expr.right;
            return this.assign(expr.left, (CodeExpr)divExpr, context);
        }
        if (expr.operator == 36) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 3;
            divExpr.right = expr.right;
            return this.assign(expr.left, (CodeExpr)divExpr, context);
        }
        if (expr.operator == 37) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 5;
            divExpr.right = expr.right;
            return this.assign(expr.left, (CodeExpr)divExpr, context);
        }
        if (expr.operator == 38) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 6;
            divExpr.right = expr.right;
            return this.assign(expr.left, (CodeExpr)divExpr, context);
        }
        Object leftValue = this.evalExprInternal(expr.left, context);
        if (expr.operator == 7) {
            if (leftValue instanceof Boolean && !((Boolean)leftValue).booleanValue()) {
                return PrimitiveBoolean.FALSE;
            }
            if (leftValue instanceof PrimitiveBoolean && !((PrimitiveBoolean)leftValue).getValue()) {
                return PrimitiveBoolean.FALSE;
            }
        } else if (expr.operator == 8) {
            if (leftValue instanceof Boolean && ((Boolean)leftValue).booleanValue()) {
                return PrimitiveBoolean.TRUE;
            }
            if (leftValue instanceof PrimitiveBoolean && ((PrimitiveBoolean)leftValue).getValue()) {
                return PrimitiveBoolean.TRUE;
            }
        }
        Object rightValue = this.evalExprInternal(expr.right, context);
        switch (expr.operator) {
            case 0: {
                rtnVal = TypeUtils.add((Object)leftValue, (Object)rightValue);
                break;
            }
            case 9: {
                rtnVal = TypeUtils.div((Object)leftValue, (Object)rightValue);
                break;
            }
            case 11: {
                boolean boolVal = TypeUtils.greaterThan((Object)leftValue, (Object)rightValue);
                rtnVal = PrimitiveBoolean.getPrimitiveBoolean((boolean)boolVal);
                break;
            }
            case 12: {
                boolean boolVal = TypeUtils.greaterThanOrEqual((Object)leftValue, (Object)rightValue);
                rtnVal = PrimitiveBoolean.getPrimitiveBoolean((boolean)boolVal);
                break;
            }
            case 14: {
                boolean boolVal = TypeUtils.lessThan((Object)leftValue, (Object)rightValue);
                rtnVal = PrimitiveBoolean.getPrimitiveBoolean((boolean)boolVal);
                break;
            }
            case 15: {
                boolean boolVal = TypeUtils.lessThanOrEqual((Object)leftValue, (Object)rightValue);
                rtnVal = PrimitiveBoolean.getPrimitiveBoolean((boolean)boolVal);
                break;
            }
            case 10: {
                boolean boolVal = TypeUtils.equal((Object)leftValue, (Object)rightValue);
                rtnVal = PrimitiveBoolean.getPrimitiveBoolean((boolean)boolVal);
                break;
            }
            case 23: {
                boolean boolVal = TypeUtils.equal((Object)leftValue, (Object)rightValue);
                rtnVal = PrimitiveBoolean.getPrimitiveBoolean((!boolVal ? 1 : 0) != 0);
                break;
            }
            case 22: {
                rtnVal = TypeUtils.multi((Object)leftValue, (Object)rightValue);
                break;
            }
            case 26: {
                rtnVal = TypeUtils.sub((Object)leftValue, (Object)rightValue);
                break;
            }
            case 13: {
                rtnVal = TypeUtils.evalInstanceOf((Object)leftValue, (Object)rightValue);
                break;
            }
            case 3: {
                rtnVal = TypeUtils.bitwiseAnd((Object)leftValue, (Object)rightValue);
                break;
            }
            case 5: {
                rtnVal = TypeUtils.bitwiseOr((Object)leftValue, (Object)rightValue);
                break;
            }
            case 6: {
                rtnVal = TypeUtils.bitwiseXor((Object)leftValue, (Object)rightValue);
                break;
            }
            case 17: {
                rtnVal = TypeUtils.leftShift((Object)leftValue, (Object)rightValue);
                break;
            }
            case 19: {
                rtnVal = TypeUtils.rightShift((Object)leftValue, (Object)rightValue);
                break;
            }
            case 27: {
                rtnVal = TypeUtils.rightUnsignShift((Object)leftValue, (Object)rightValue);
                break;
            }
            case 21: {
                rtnVal = TypeUtils.mod((Object)leftValue, (Object)rightValue);
                break;
            }
            case 7: {
                rtnVal = TypeUtils.booleanAnd((Object)leftValue, (Object)rightValue);
                break;
            }
            case 8: {
                rtnVal = TypeUtils.booleanOr((Object)leftValue, (Object)rightValue);
                break;
            }
            default: {
                throw (InterpreterException)new InterpreterException("no suport. operator is : " + expr.operator, (CodeObject)expr).setErrorLineCode(this.getSource());
            }
        }
        return rtnVal;
    }

    private Object evalConditionExpr(ConditionExpr expr, Map context) throws InterpreterException {
        Object rtnValue = this.evalExprInternal(expr.testExpr, context);
        if (rtnValue instanceof Boolean) {
            if (rtnValue.equals(Boolean.TRUE)) {
                return this.evalExprInternal(expr.trueExpr, context);
            }
            return this.evalExprInternal(expr.falseExpr, context);
        }
        if (rtnValue instanceof PrimitiveBoolean) {
            if (rtnValue.equals(PrimitiveBoolean.TRUE)) {
                return this.evalExprInternal(expr.trueExpr, context);
            }
            return this.evalExprInternal(expr.falseExpr, context);
        }
        throw (InterpreterException)new InterpreterException("expr result is not boolean, it's :" + expr != null ? expr.getClass().getName() : "null", (CodeObject)expr).setErrorLineCode(this.getSource());
    }

    private Object evalIndentExpr(IdentifierExpr expr, Map context) throws InterpreterException {
        Object rtnValue = null;
        String ident = expr.value;
        if (context.containsKey(ident)) {
            rtnValue = context.get(expr.value);
        } else {
            rtnValue = TypeUtils.classForName(this.namespaces, this.classMap, (String)ident);
            if (rtnValue == null && this._defaultObject != null) {
                PropertyExpr propExpr = new PropertyExpr(expr.position);
                propExpr.propName = expr.value;
                propExpr.owner = new IdentifierExpr(expr.position.nullStart(), "__defaultObject__");
                HashMap<String, Object> tempContext = new HashMap<String, Object>(1);
                tempContext.put("__defaultObject__", this._defaultObject);
                rtnValue = this.evalPropExpr(propExpr, tempContext);
            }
        }
        return rtnValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object evalPropExpr(PropertyExpr propExpr, Map context) throws InterpreterException {
        if (context.containsKey(propExpr.toString())) {
            return context.get(propExpr.toString());
        }
        Object rtnValue = null;
        String ownerExprStr = propExpr.owner.toString();
        Object ownerValue = TypeUtils.classForName(this.namespaces, this.classMap, (String)ownerExprStr);
        if (ownerValue == null) {
            ownerValue = this.evalExprInternal(propExpr.owner, context);
        }
        if (ownerValue == null) {
            if (this.properyExprOwnerNullIgore) return null;
            log.error((Object)("properExpr's owner is null. expr is : " + propExpr.toString()));
            throw (InterpreterException)new InterpreterException("properExpr's owner is null. expr is : " + propExpr.toString(), (CodeObject)propExpr).setInfoId("EVAL_PROP_OWNER_NULL").addArg((Object)ownerExprStr).addArg((Object)propExpr).setErrorLineCode(this.getSource());
        }
        Class<?> type = ownerValue instanceof Class ? (Class<?>)ownerValue : ownerValue.getClass();
        if (type.isArray() && propExpr.propName.equals("length")) {
            return new PrimitiveInt(Array.getLength(ownerValue));
        }
        if (ownerValue instanceof List) {
            List ownerList = (List)ownerValue;
            HashMap tmpContext = new HashMap();
            tmpContext.putAll(context);
            Object tmpResult = null;
            int i = 0;
            while (i < ownerList.size()) {
                tmpContext.put(propExpr.owner.toString(), ownerList.get(i));
                tmpResult = this.evalPropExpr(propExpr, tmpContext);
                if (tmpResult == null) return tmpResult;
                if (!(tmpResult instanceof BigDecimal)) {
                    return tmpResult;
                }
                if (rtnValue == null) {
                    rtnValue = new BigDecimal("0");
                }
                rtnValue = ((BigDecimal)rtnValue).add((BigDecimal)tmpResult);
                ++i;
            }
            return rtnValue;
        }
        this.lazyLoadGetProperty(ownerValue, propExpr.propName, propExpr);
        Field field = TypeUtils.findField(type, (String)propExpr.propName);
        Throwable ex = null;
        if (field == null) {
            Method method = KScriptUtil.findGetMethod(type, (String)propExpr.propName);
            if (method != null) {
                return this.invokeMethod(ownerValue, method, null);
            }
            if (this.isObjectValue(ownerValue)) {
                if (!this.isObjectValueContainPropName(ownerValue, propExpr.propName)) return this.lazyLoadGetProperty(ownerValue, propExpr.propName, propExpr);
                return this.getObjectValuePropValueByName(ownerValue, propExpr.propName);
            }
            if (!this.isObjectCollection(ownerValue)) throw (InterpreterException)new InterpreterException("expr is : " + propExpr.toString(), (CodeObject)propExpr, ex).setErrorLineCode(this.getSource());
            if (this.getObjectCollectionSize(ownerValue) <= 0) {
                return null;
            }
            if ((ownerValue = this.getObjectCollectionChildByIndex(ownerValue, 0)) == null) {
                throw new NullPointerException("properExpr's owner is null.");
            }
            type = ownerValue instanceof Class ? (Class<?>)ownerValue : ownerValue.getClass();
            this.lazyLoadGetProperty(ownerValue, propExpr.propName, propExpr);
            field = TypeUtils.findField(type, (String)propExpr.propName);
            if (field == null) {
                method = KScriptUtil.findGetMethod(type, (String)propExpr.propName);
                if (method != null) {
                    return this.invokeMethod(ownerValue, method, null);
                }
                if (!this.isObjectValue(ownerValue)) throw (InterpreterException)new InterpreterException("eval properExpr error. not such field or getMethod.", (CodeObject)propExpr).setInfoId("EVAL_PROP_NO_PROP").addArg(ownerValue).addArg(ownerValue.getClass()).addArg((Object)propExpr).addArg((Object)this.getContext(context)).setErrorLineCode(this.getSource());
                PropertyExpr itemPropExpr = new PropertyExpr(propExpr.position);
                itemPropExpr.owner = new IdentifierExpr(propExpr.position.nullStart(), "item");
                itemPropExpr.propName = propExpr.propName;
                HashMap<String, Object> itemCtx = new HashMap<String, Object>();
                itemCtx.put("item", ownerValue);
                return this.evalPropExpr(itemPropExpr, itemCtx);
            }
            try {
                return field.get(ownerValue);
            }
            catch (Exception e) {
                this.doWitdInvokeException(e, ownerValue, propExpr.propName, null, context);
                return rtnValue;
            }
        } else {
            try {
                field.setAccessible(true);
                return field.get(ownerValue);
            }
            catch (Exception e) {
                this.doWitdInvokeException(e, ownerValue, propExpr.propName, null, context);
            }
        }
        return rtnValue;
    }

    private Object evalMethodInvokeExpr(MethodInvokeExpr methodInvokeExpr, Map context) throws InterpreterException {
        if (this.isInternalFunction(methodInvokeExpr)) {
            HashMap tempCont = new HashMap();
            tempCont.putAll(context);
            return this.evalInternalFunction(methodInvokeExpr, tempCont);
        }
        long t = System.currentTimeMillis();
        Object ownerValue = null;
        if (methodInvokeExpr.owner != null) {
            if (methodInvokeExpr.owner instanceof PropertyExpr) {
                String ownerExprStr = methodInvokeExpr.owner.toString();
                ownerValue = TypeUtils.classForName(this.namespaces, this.classMap, (String)ownerExprStr);
            }
            if (ownerValue == null) {
                ownerValue = this.evalExprInternal(methodInvokeExpr.owner, context);
            }
        }
        if (ownerValue == null) {
            for (IFunctionProvider funcProvider : this.funcProviderList) {
                if (!funcProvider.existFunction(methodInvokeExpr.methodName)) continue;
                ArrayList<Object> pramList = new ArrayList<Object>(methodInvokeExpr.paramList.size());
                int len = methodInvokeExpr.paramList.size();
                if (funcProvider instanceof CustomerFunctionProvider) {
                    pramList.add(this.getBOSContext());
                }
                for (int i = 0; i < len; ++i) {
                    CodeExpr pramExpr = (CodeExpr)methodInvokeExpr.paramList.get(i);
                    Object pramVal = this.evalExprInternal(pramExpr, context);
                    if (pramVal instanceof PrimitiveValue) {
                        pramVal = ((PrimitiveValue)pramVal).getBoxValue();
                    }
                    pramList.add(pramVal);
                }
                try {
                    Object obj = funcProvider.evalFunction(methodInvokeExpr.methodName, pramList);
                    log.debug((Object)("[evalFunction] MethodName:" + methodInvokeExpr.methodName + " COST:" + (System.currentTimeMillis() - t)));
                    return obj;
                }
                catch (Throwable e) {
                    throw (InterpreterException)new InterpreterException("eval function provider error. " + methodInvokeExpr.toString(), (CodeObject)methodInvokeExpr, e).setInfoId("EXEC_PROVIDER_ERROR").addArg(funcProvider.getClass()).addArg((Object)methodInvokeExpr.methodName).addArg((Object)e.getMessage()).addArg((Object)this.getContext(context)).setErrorLineCode(this.getSource());
                }
            }
            if (this._defaultObject != null) {
                MethodInvokeExpr defaultMethodInvokeExpr = new MethodInvokeExpr(methodInvokeExpr.position);
                defaultMethodInvokeExpr.methodName = methodInvokeExpr.methodName;
                defaultMethodInvokeExpr.paramList = new ArrayList(methodInvokeExpr.paramList);
                defaultMethodInvokeExpr.owner = new IdentifierExpr(methodInvokeExpr.position.nullStart(), "__defaultObject__");
                context.put("__defaultObject__", this._defaultObject);
                Object rtnValue = this.evalMethodInvokeExpr(defaultMethodInvokeExpr, context);
                context.remove("__defaultObject__");
                log.debug((Object)("[evalFunction] MethodName:" + methodInvokeExpr.methodName + " COST:" + (System.currentTimeMillis() - t)));
                return rtnValue;
            }
            String msg = "MethodInvokeExpr's owner is null. method name is : '" + methodInvokeExpr.methodName + "'";
            InterpreterException ex = (InterpreterException)new InterpreterException(msg, (CodeObject)methodInvokeExpr).setErrorLineCode(this.getSource());
            if (this.isProperyExprOwnerNullIgore()) {
                log.error((Object)(msg + " ,but the option(properyExprOwnerNullIgore) set ignore current error. "), (Throwable)ex);
                return null;
            }
            throw ex;
        }
        Object[] pramValueArray = new Object[methodInvokeExpr.paramList.size()];
        Class[] pramClassArray = new Class[pramValueArray.length];
        for (int i = 0; i < pramValueArray.length; ++i) {
            pramValueArray[i] = this.evalExprInternal((CodeExpr)methodInvokeExpr.paramList.get(i), context);
            if (pramValueArray[i] instanceof PrimitiveValue) {
                pramClassArray[i] = ((PrimitiveValue)pramValueArray[i]).getUnBoxType();
                pramValueArray[i] = ((PrimitiveValue)pramValueArray[i]).getBoxValue();
                continue;
            }
            if (pramValueArray[i] == null) continue;
            pramClassArray[i] = pramValueArray[i].getClass();
        }
        Class<?> type = ownerValue instanceof Class ? (Class<?>)ownerValue : ownerValue.getClass();
        Method method = this.findMethod(type, methodInvokeExpr.methodName, pramClassArray);
        if (method == null) {
            throw (InterpreterException)new InterpreterException("method not found. method name is: " + methodInvokeExpr.methodName, (CodeObject)methodInvokeExpr).setInfoId("EXEC_METHOD_NotFound").addArg(type).addArg((Object)methodInvokeExpr.methodName).addArg((Object)pramClassArray).addArg((Object)this.getContext(context)).setErrorLineCode(this.getSource());
        }
        Object rtnVal = this.invokMethod(method, ownerValue, pramValueArray);
        log.debug((Object)("[evalFunction] MethodName:" + methodInvokeExpr.methodName + " COST:" + (System.currentTimeMillis() - t)));
        return rtnVal;
    }

    private Object evalUnaryExpr(UnaryExpr unaryExpr, Map context) throws InterpreterException {
        if (unaryExpr.operator == 1) {
            return this.evalExprInternal(unaryExpr.expr, context);
        }
        if (unaryExpr.operator == 3) {
            IdentifierExpr identExpr;
            Object rtnValue = this.evalExprInternal(unaryExpr.expr, context);
            rtnValue = TypeUtils.add((Object)rtnValue, (Object)new PrimitiveInt(1));
            if (unaryExpr.expr instanceof IdentifierExpr) {
                identExpr = (IdentifierExpr)unaryExpr.expr;
                if (!context.containsKey(identExpr.value)) {
                    throw (InterpreterException)new InterpreterException("Systax Err.Can't find indentifier in context.", (CodeObject)identExpr).setInfoId("SELFIncrement_NO_IDENTIFIER").addArg((Object)unaryExpr.toString()).addArg((Object)identExpr.toString()).addArg((Object)this.getContext(context)).setErrorLineCode(this.getSource());
                }
            } else {
                throw (InterpreterException)new InterpreterException("Systax Err. The expression is not an Identifier.", (CodeObject)unaryExpr.expr).setInfoId("SELFIncrement_NOT_IDENTIFIER").addArg((Object)unaryExpr.toString()).addArg((Object)unaryExpr.expr.toString()).setErrorLineCode(this.getSource());
            }
            context.put(identExpr.value, rtnValue);
            return rtnValue;
        }
        if (unaryExpr.operator == 4) {
            IdentifierExpr identExpr;
            Object rtnValue = this.evalExprInternal(unaryExpr.expr, context);
            Object postValue = TypeUtils.add((Object)rtnValue, (Object)new PrimitiveInt(1));
            if (unaryExpr.expr instanceof IdentifierExpr) {
                identExpr = (IdentifierExpr)unaryExpr.expr;
                if (!context.containsKey(identExpr.value)) {
                    throw (InterpreterException)new InterpreterException("Systax Err.Can't find indentifier in context.", (CodeObject)identExpr).setInfoId("SELFIncrement_NO_IDENTIFIER").addArg((Object)unaryExpr.toString()).addArg((Object)identExpr.toString()).addArg((Object)this.getContext(context)).setErrorLineCode(this.getSource());
                }
            } else {
                throw (InterpreterException)new InterpreterException("Systax Err. The expression is not an Identifier.", (CodeObject)unaryExpr.expr).setInfoId("SELFIncrement_NOT_IDENTIFIER").addArg((Object)unaryExpr.toString()).addArg((Object)unaryExpr.expr.toString()).setErrorLineCode(this.getSource());
            }
            context.put(identExpr.value, postValue);
            return rtnValue;
        }
        if (unaryExpr.operator == 5) {
            IdentifierExpr identExpr;
            Object rtnValue = this.evalExprInternal(unaryExpr.expr, context);
            rtnValue = TypeUtils.sub((Object)rtnValue, (Object)new PrimitiveInt(1));
            if (unaryExpr.expr instanceof IdentifierExpr) {
                identExpr = (IdentifierExpr)unaryExpr.expr;
                if (!context.containsKey(identExpr.value)) {
                    throw (InterpreterException)new InterpreterException("Systax Err.Can't find indentifier in context.", (CodeObject)identExpr).setInfoId("SELFDecrement_NO_IDENTIFIER").addArg((Object)unaryExpr.toString()).addArg((Object)identExpr.toString()).addArg((Object)this.getContext(context)).setErrorLineCode(this.getSource());
                }
            } else {
                throw (InterpreterException)new InterpreterException("Systax Err. The expression is not an Identifier.", (CodeObject)unaryExpr.expr).setInfoId("SELFDecrement_NOT_IDENTIFIER").addArg((Object)unaryExpr.toString()).addArg((Object)unaryExpr.expr.toString()).setErrorLineCode(this.getSource());
            }
            context.put(identExpr.value, rtnValue);
            return rtnValue;
        }
        if (unaryExpr.operator == 6) {
            IdentifierExpr identExpr;
            Object rtnValue = this.evalExprInternal(unaryExpr.expr, context);
            Object postValue = TypeUtils.sub((Object)rtnValue, (Object)new PrimitiveInt(1));
            if (unaryExpr.expr instanceof IdentifierExpr) {
                identExpr = (IdentifierExpr)unaryExpr.expr;
                if (!context.containsKey(identExpr.value)) {
                    throw (InterpreterException)new InterpreterException("Systax Err.Can't find indentifier in context.", (CodeObject)identExpr).setInfoId("SELFDecrement_NO_IDENTIFIER").addArg((Object)unaryExpr.toString()).addArg((Object)identExpr.toString()).addArg((Object)this.getContext(context)).setErrorLineCode(this.getSource());
                }
            } else {
                throw (InterpreterException)new InterpreterException("Systax Err. The expression is not an Identifier.", (CodeObject)unaryExpr.expr).setInfoId("SELFDecrement_NOT_IDENTIFIER").addArg((Object)unaryExpr.toString()).addArg((Object)unaryExpr.expr.toString()).setErrorLineCode(this.getSource());
            }
            context.put(identExpr.value, postValue);
            return rtnValue;
        }
        if (unaryExpr.operator == 7) {
            Object exprVal = this.evalExprInternal(unaryExpr.expr, context);
            if (exprVal instanceof Number) {
                return new PrimitiveInt(~((Number)exprVal).intValue());
            }
            throw (InterpreterException)new InterpreterException("Systax Err. operator ~ only use for integer.", (CodeObject)unaryExpr.expr).setInfoId("Tilde_EXPR_ERROR").addArg((Object)unaryExpr.toString()).addArg((Object)exprVal.toString()).addArg((Object)exprVal.getClass().getName()).addArg((Object)this.getContext(context)).setErrorLineCode(this.getSource());
        }
        if (unaryExpr.operator == 0) {
            Object tempValue = this.evalExprInternal(unaryExpr.expr, context);
            if (tempValue instanceof Boolean) {
                return (Boolean)tempValue != false ? PrimitiveBoolean.FALSE : PrimitiveBoolean.TRUE;
            }
            if (tempValue instanceof PrimitiveBoolean) {
                return ((PrimitiveBoolean)tempValue).getValue() ? PrimitiveBoolean.FALSE : PrimitiveBoolean.TRUE;
            }
            throw (InterpreterException)new InterpreterException("Systax Err. operator ~ only use for integer.", (CodeObject)unaryExpr.expr).setInfoId("Not_EXPR_ERROR").addArg((Object)unaryExpr.toString()).addArg((Object)tempValue.toString()).addArg((Object)tempValue.getClass().getName()).addArg((Object)this.getContext(context)).setErrorLineCode(this.getSource());
        }
        throw (InterpreterException)new InterpreterException("UNSUPPORT", (CodeObject)unaryExpr).setInfoId("UNSUPPORTED_STATEMENT").addArg((Object)unaryExpr.getExprClass().getName()).addArg((Object)unaryExpr.toString()).setErrorLineCode(this.getSource());
    }

    private boolean isInternalFunction(MethodInvokeExpr methodInvokeExpr) {
        CodeExpr ownerExpr = methodInvokeExpr.owner;
        String methodName = methodInvokeExpr.methodName;
        String ownerStr = null;
        if (ownerExpr instanceof IdentifierExpr) {
            ownerStr = ((IdentifierExpr)ownerExpr).value;
        }
        if (ownerStr == null) {
            return internalFunctionList.contains(methodName);
        }
        return ownerStr.equals("Math") && methodName.endsWith("abs");
    }

    private Object evalInternalFunction(MethodInvokeExpr methodInvokeExpr, Map context) throws InterpreterException {
        String methodName = methodInvokeExpr.methodName;
        if (methodName.equals("eval")) {
            CodeExpr pramExpr = (CodeExpr)methodInvokeExpr.paramList.get(0);
            if (pramExpr instanceof StringExpr) {
                String pramExprStr = ((StringExpr)pramExpr).text;
                try {
                    return this.eval(pramExprStr, context);
                }
                catch (ParserException e) {
                    throw (InterpreterException)new InterpreterException("Sytax Error.", (CodeObject)pramExpr, (Throwable)e).setInfoId("PARSE_ERROR").addArg((Object)pramExpr.toString()).addArg((Object)e.getMessage()).setErrorLineCode(this.getSource());
                }
            }
            throw (InterpreterException)new InterpreterException("Sytax Error. expression must be a String", (CodeObject)pramExpr).setInfoId("EVAL_PARAM_NOT_STRING").addArg((Object)methodInvokeExpr.toString()).addArg((Object)(pramExpr == null ? "null" : pramExpr.toString())).setErrorLineCode(this.getSource());
        }
        if (methodName.equals("abs")) {
            CodeExpr pramExpr = (CodeExpr)methodInvokeExpr.paramList.get(0);
            Object pram = this.evalExprInternal(pramExpr, context);
            if (pram != null && pram instanceof Number) {
                Number num = (Number)pram;
                if (num.doubleValue() >= 0.0) {
                    return num;
                }
                return TypeUtils.multi((Object)num, (Object)-1);
            }
            throw (InterpreterException)new InterpreterException("abs's parameter must be Number, but it is" + pram, (CodeObject)methodInvokeExpr).setInfoId("ABS_PARAM_NOT_NUM").addArg((Object)methodInvokeExpr.toString()).addArg((Object)(pram == null ? "null" : pram.toString())).addArg((Object)(pram == null ? "null" : pram.getClass().getName())).setErrorLineCode(this.getSource());
        }
        if (methodName.equals("len")) {
            CodeExpr pramExpr = (CodeExpr)methodInvokeExpr.paramList.get(0);
            Object pram = this.evalExprInternal(pramExpr, context);
            if (pram instanceof Collection) {
                return new PrimitiveInt(((Collection)pram).size());
            }
            if (pram.getClass().isArray()) {
                return new PrimitiveInt(Array.getLength(pram));
            }
            if (pram instanceof String) {
                return new PrimitiveInt(((String)pram).length());
            }
            throw (InterpreterException)new InterpreterException("len function err. parameter type not support. it should be a collection or array or String, but find" + pram.getClass().getName(), (CodeObject)methodInvokeExpr).setInfoId("LEN_PARAM_NOT_SUIT").addArg((Object)methodInvokeExpr.toString()).addArg((Object)pram.toString()).addArg((Object)pram.getClass().getName()).setErrorLineCode(this.getSource());
        }
        if (methodName.equals("newid")) {
            return Uuid.create();
        }
        if (methodName.equals("parseInt")) {
            CodeExpr pramExpr = (CodeExpr)methodInvokeExpr.paramList.get(0);
            Object pram = this.evalExprInternal(pramExpr, context);
            if (pram instanceof String) {
                return new PrimitiveInt(Integer.parseInt((String)pram));
            }
            if (pram instanceof Number) {
                return new PrimitiveInt(((Number)pram).intValue());
            }
            return new PrimitiveInt(Integer.parseInt(pram.toString()));
        }
        if (methodName.equals("parseFloat")) {
            CodeExpr pramExpr = (CodeExpr)methodInvokeExpr.paramList.get(0);
            Object pram = this.evalExprInternal(pramExpr, context);
            if (pram instanceof String) {
                return new PrimitiveFloat(Float.parseFloat((String)pram));
            }
            if (pram instanceof Number) {
                return new PrimitiveFloat(((Number)pram).floatValue());
            }
            return new PrimitiveFloat(Float.parseFloat(pram.toString()));
        }
        if (methodName.equals("Set")) {
            HashSet<Object> set = new HashSet<Object>();
            for (CodeExpr pramExpr : methodInvokeExpr.paramList) {
                Object pram = this.evalExprInternal(pramExpr, context);
                set.add(pram);
            }
            return set;
        }
        if (methodName.equals("List")) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (CodeExpr pramExpr : methodInvokeExpr.paramList) {
                Object pram = this.evalExprInternal(pramExpr, context);
                list.add(pram);
            }
            return list;
        }
        if (methodName.equalsIgnoreCase("sum")) {
            return this.evalIMSum(methodInvokeExpr, context, null);
        }
        if (methodName.equalsIgnoreCase("first")) {
            return this.evalIMFirst(methodInvokeExpr, context, null);
        }
        if (methodName.equalsIgnoreCase("last")) {
            return this.evalIMLast(methodInvokeExpr, context, null);
        }
        if (methodName.equalsIgnoreCase("all")) {
            return this.evalIMAll(methodInvokeExpr, context, null);
        }
        if (methodName.equals("uniqueAll")) {
            return this.evalIMUniqueAll(methodInvokeExpr, context, null);
        }
        if (methodName.equalsIgnoreCase("avg")) {
            return this.evalIMAvg(methodInvokeExpr, context, null);
        }
        if (methodName.equalsIgnoreCase("count")) {
            return this.evalIMCount(methodInvokeExpr, context, null);
        }
        if (methodName.equals("max")) {
            return this.evalIMMax(methodInvokeExpr, context, null);
        }
        if (methodName.equals("min")) {
            return this.evalIMMin(methodInvokeExpr, context, null);
        }
        if (methodName.startsWith("conditional_")) {
            CodeExpr connExpr;
            if (methodInvokeExpr.paramList.size() < 2) {
                throw (InterpreterException)new InterpreterException("syntax error 'conditional_sum', there must be 2 parameters", (CodeObject)methodInvokeExpr).setErrorLineCode(this.getSource());
            }
            CodeExpr connStrExpr = (CodeExpr)methodInvokeExpr.paramList.remove(methodInvokeExpr.paramList.size() - 1);
            if (!(connStrExpr instanceof StringExpr)) {
                throw new TODOException("conditional_sum");
            }
            String connStr = ((StringExpr)connStrExpr).text;
            try {
                ExprParser parser = new ExprParser(connStr);
                connExpr = parser.expr();
            }
            catch (ParserException e) {
                e.printStackTrace();
                throw (InterpreterException)new InterpreterException("syntax error 'conditional_sum'", (CodeObject)connStrExpr, (Throwable)e).setInfoId("PARSE_ERROR").addArg((Object)connStrExpr.toString()).addArg((Object)e.toString()).setErrorLineCode(this.getSource());
            }
            if (methodName.equalsIgnoreCase("conditional_sum")) {
                return this.evalIMSum(methodInvokeExpr, context, connExpr);
            }
            if (methodName.equalsIgnoreCase("conditional_avg")) {
                return this.evalIMAvg(methodInvokeExpr, context, connExpr);
            }
            if (methodName.equalsIgnoreCase("conditional_max")) {
                return this.evalIMMax(methodInvokeExpr, context, connExpr);
            }
            if (methodName.equalsIgnoreCase("conditional_min")) {
                return this.evalIMMin(methodInvokeExpr, context, connExpr);
            }
            if (methodName.equalsIgnoreCase("conditional_count")) {
                return this.evalIMCount(methodInvokeExpr, context, connExpr);
            }
            throw (InterpreterException)new InterpreterException("method name must be 'conditional_sum' or 'conditional_avg' or 'conditional_max' or 'conditional_min' or 'conditional_count'", (CodeObject)connStrExpr).setErrorLineCode(this.getSource());
        }
        throw new InterpreterException("UNSUPPORT, unkonw method.methodName is" + methodName, (CodeObject)methodInvokeExpr);
    }

    private Object evalIMSum(MethodInvokeExpr methodInvokeExpr, Map context, CodeExpr criteria) throws InterpreterException {
        List list = this.evalIMAll(methodInvokeExpr, context, criteria);
        if (list.isEmpty()) {
            return 0;
        }
        Object sumVal = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            sumVal = TypeUtils.add(sumVal, list.get(i));
        }
        return sumVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object assign(CodeExpr left, CodeExpr right, Map context) throws InterpreterException {
        Object rightValue = this.evalExprInternal(right, context);
        if (left instanceof IdentifierExpr) {
            IdentifierExpr identExpr = (IdentifierExpr)left;
            String ident = identExpr.value;
            context.put(ident, rightValue);
            return rightValue;
        } else if (left instanceof ArrayIndexerExpr) {
            ArrayIndexerExpr arrayIndexerExpr = (ArrayIndexerExpr)left;
            Object targetObj = this.evalExprInternal(arrayIndexerExpr.targetObjExpr, context);
            Object indexerObj = this.evalExprInternal(arrayIndexerExpr.indexExpr, context);
            int index = ((Number)indexerObj).intValue();
            Object value = rightValue instanceof PrimitiveValue ? ((PrimitiveValue)rightValue).getBoxValue() : rightValue;
            if (targetObj.getClass().isArray()) {
                Array.set(targetObj, index, value);
                return rightValue;
            } else {
                if (!(targetObj instanceof List)) throw (InterpreterException)new InterpreterException("assign to array error. target object is not an array or a list", (CodeObject)left).setInfoId("ASSIGN_ARRAY_TO_NO_ARRAY").addArg((Object)left.toString()).addArg((Object)right.toString()).addArg((Object)this.getContext(context)).setErrorLineCode(this.getSource());
                ((List)targetObj).set(index, value);
            }
            return rightValue;
        } else {
            if (!(left instanceof PropertyExpr)) return rightValue;
            PropertyExpr propExpr = (PropertyExpr)left;
            Object ownerValue = this.evalExprInternal(propExpr.owner, context);
            Throwable ex = null;
            Class<?> type = ownerValue.getClass();
            Field field = TypeUtils.findField(type, (String)propExpr.propName);
            if (rightValue instanceof PrimitiveValue) {
                rightValue = ((PrimitiveValue)rightValue).getBoxValue();
            }
            if (field != null) {
                try {
                    field.set(ownerValue, rightValue);
                    return rightValue;
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)"IllegalArgumentException", (Throwable)e);
                    throw (InterpreterException)new InterpreterException("IllegalArgumentException", (CodeObject)propExpr, (Throwable)e).setErrorLineCode(this.getSource());
                }
                catch (IllegalAccessException e) {
                    log.error((Object)"IllegalArgumentException", (Throwable)e);
                    throw (InterpreterException)new InterpreterException("IllegalAccessException", (CodeObject)propExpr, (Throwable)e).setErrorLineCode(this.getSource());
                }
            } else {
                Method method = KScriptUtil.findSetMethod(type, (String)propExpr.propName);
                if (method != null) {
                    this.invokeMethod(ownerValue, method, new Object[]{rightValue});
                    return rightValue;
                } else if (this.isObjectValue(ownerValue)) {
                    this.setObjectValuePropValue(ownerValue, propExpr.propName, rightValue);
                    return rightValue;
                } else {
                    if (ex == null) throw (InterpreterException)new InterpreterException("assign error.", (CodeObject)left).setErrorLineCode(this.getSource());
                    log.error((Object)"An error occur.", ex);
                    throw (InterpreterException)new InterpreterException("An error occur." + ex.getMessage(), (CodeObject)left, ex).setErrorLineCode(this.getSource());
                }
            }
        }
    }

    private Method findMethod(Class c, String methodName, Class[] pramClassArray) throws InterpreterException {
        Method[] methodArray = c.getMethods();
        ArrayList<Method> list_byName = new ArrayList<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(methodName)) continue;
            list_byName.add(methodArray[i]);
        }
        if (list_byName.size() == 0) {
            return null;
        }
        if (list_byName.size() == 1) {
            return (Method)list_byName.get(0);
        }
        ArrayList<Method> list_byLength = new ArrayList<Method>(list_byName.size());
        for (int i = 0; i < list_byName.size(); ++i) {
            Method method = (Method)list_byName.get(i);
            Class<?>[] pramTypeArray = method.getParameterTypes();
            if (pramTypeArray.length != pramClassArray.length) continue;
            list_byLength.add(method);
        }
        if (list_byLength.size() == 0) {
            return null;
        }
        if (list_byLength.size() == 1) {
            return (Method)list_byLength.get(0);
        }
        Method rtnValue = ReflectionUtils.getMethod((Class)c, (String)methodName, (Class[])pramClassArray);
        if (rtnValue != null) {
            return rtnValue;
        }
        return ConditionInterpreter.findMethod(methodName, list_byLength, pramClassArray);
    }

    private static Method findMethod(String methodName, List methodList, Class[] pramClassArray) throws InterpreterException {
        Method method;
        int i;
        ArrayList<Method> resultList = new ArrayList<Method>();
        for (i = 0; i < methodList.size(); ++i) {
            method = (Method)methodList.get(i);
            boolean flag = true;
            for (int j = 0; j < pramClassArray.length; ++j) {
                Class<?> methodPramType = method.getParameterTypes()[j];
                if (pramClassArray[j] == null || methodPramType.isAssignableFrom(pramClassArray[j])) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            resultList.add(method);
        }
        if (resultList.size() == 1) {
            return (Method)resultList.get(0);
        }
        if (resultList.size() == 0) {
            if (pramClassArray.length == 1) {
                for (i = 0; i < methodList.size(); ++i) {
                    method = (Method)methodList.get(i);
                    if (!method.getParameterTypes()[0].equals(String.class)) continue;
                    return method;
                }
            }
            throw (InterpreterException)new InterpreterException("method not found. method is : " + methodName).setInfoId("EXEC_METHOD_NotFound").addArg((Object)methodName).addArg((Object)"...").addArg((Object)pramClassArray).addArg((Object)"...");
        }
        ArrayList<Method> fList = new ArrayList<Method>();
        block3: for (int mi = 0; mi < resultList.size(); ++mi) {
            Class tCls;
            Method m = (Method)resultList.get(mi);
            for (int pi = 0; pi < pramClassArray.length && (tCls = pramClassArray[pi]) != null; ++pi) {
                if (tCls != m.getParameterTypes()[pi]) continue;
                fList.add(m);
                continue block3;
            }
        }
        if (fList.size() == 1) {
            return (Method)fList.get(0);
        }
        if (fList.size() == 0) {
            fList = resultList;
        }
        for (int pi = 0; pi < pramClassArray.length; ++pi) {
            boolean breakMethod = false;
            Method method2 = null;
            for (int mio = 0; mio < fList.size() - 1; ++mio) {
                Class<?> cls = ((Method)fList.get(mio)).getParameterTypes()[pi];
                method2 = (Method)fList.get(mio);
                for (int mi = mio + 1; mi < fList.size(); ++mi) {
                    Class<?> aCls = ((Method)fList.get(mi)).getParameterTypes()[pi];
                    if (cls == aCls) continue;
                    if (cls.isAssignableFrom(aCls)) {
                        cls = aCls;
                        method2 = (Method)fList.get(mi);
                        continue;
                    }
                    if (aCls.isAssignableFrom(cls)) continue;
                    breakMethod = true;
                    method2 = null;
                    break;
                }
                if (breakMethod) break;
            }
            if (method2 == null) continue;
            return method2;
        }
        throw (InterpreterException)new InterpreterException("multi method found. method is : " + methodName).setInfoId("EXEC_METHOD_FoundMulti").addArg((Object)"...").addArg((Object)methodName).addArg((Object)pramClassArray).addArg((Object)"...");
    }

    private Object invokMethod(Method method, Object ownerObj, Object[] pramValueArray) throws InterpreterException {
        Class<?>[] pramClassArray = method.getParameterTypes();
        Object[] objArray = new Object[pramClassArray.length];
        for (int i = 0; i < pramClassArray.length; ++i) {
            objArray[i] = i >= pramValueArray.length || pramValueArray[i] == null ? null : (pramClassArray[i].isInstance(pramValueArray[i]) ? pramValueArray[i] : TypeUtils.castObject(pramClassArray[i], (Object)pramValueArray[i]));
        }
        return this.invokeMethod(ownerObj, method, objArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeMethod(Object ownerObj, Method method, Object[] params) throws InterpreterException {
        Object rtnObj;
        block12: {
            rtnObj = null;
            try {
                if (Modifier.isStatic(method.getModifiers())) {
                    rtnObj = KScriptUtil.evalJavaMethod(null, (Method)method, (Object[])params);
                    break block12;
                }
                if (method.getName().equals("notify") || method.getName().equals("notifyAll") || method.getName().equals("wait")) {
                    Object object = ownerObj;
                    synchronized (object) {
                        rtnObj = KScriptUtil.evalJavaMethod((Object)ownerObj, (Method)method, (Object[])params);
                        break block12;
                    }
                }
                if (this.synchronizedCallMethod) {
                    Object object = ownerObj;
                    synchronized (object) {
                        rtnObj = KScriptUtil.evalJavaMethod((Object)ownerObj, (Method)method, (Object[])params);
                    }
                } else {
                    rtnObj = KScriptUtil.evalJavaMethod((Object)ownerObj, (Method)method, (Object[])params);
                }
                this.lazyLoadFileValue(rtnObj);
            }
            catch (Exception e) {
                this.doWitdInvokeException(e, ownerObj, method.getName(), params, null);
            }
        }
        return rtnObj;
    }

    private void doWitdInvokeException(Throwable ex, Object ownerObj, String methodName, Object objArray, Map context) throws InterpreterException {
        Throwable ex1 = ex;
        if (ex instanceof InvocationTargetException) {
            ex1 = ((InvocationTargetException)ex).getTargetException();
        }
        if (ex1 instanceof DebugStopException) {
            throw (DebugStopException)ex1;
        }
        if (ex1 instanceof InterpreterException) {
            throw (InterpreterException)ex1;
        }
        String infoId = null;
        if (ex instanceof IllegalArgumentException) {
            infoId = "EXEC_METHOD_IllegalArgument";
        } else if (ex instanceof IllegalAccessException) {
            infoId = "EXEC_METHOD_IllegalAccess";
        } else if (ex instanceof InvocationTargetException) {
            infoId = "EXEC_METHOD_InvocationTarget";
        }
        InterpreterException ne = (InterpreterException)new InterpreterException("invoke method error", ex).setInfoId(infoId).addArg(ownerObj).addArg((Object)methodName).addArg(objArray).addArg((Object)this.getContext(context)).addArg((Object)ex.getMessage()).setErrorLineCode(this.getSource());
        if (ex instanceof InvocationTargetException && ne.getOrigException() == null) {
            InvocationTargetException ite = (InvocationTargetException)ex;
            ne.setOrigException(ite.getCause());
        }
        throw ne;
    }

    private Object evalIMFirst(MethodInvokeExpr methodInvokeExpr, Map context, CodeExpr criteria) throws InterpreterException {
        List list = this.fetchAllElements(methodInvokeExpr, context, criteria, 1);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private Object evalIMLast(MethodInvokeExpr methodInvokeExpr, Map context, CodeExpr criteria) throws InterpreterException {
        List list = this.fetchAllElements(methodInvokeExpr, context, criteria, 1);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    private List evalIMAll(MethodInvokeExpr methodInvokeExpr, Map context, CodeExpr criteria) throws InterpreterException {
        return this.fetchAllElements(methodInvokeExpr, context, criteria, 0);
    }

    private List fetchAllElements(MethodInvokeExpr methodInvokeExpr, Map context, CodeExpr criteria, int minSize) throws InterpreterException {
        ArrayList list = new ArrayList();
        for (CodeExpr expr : methodInvokeExpr.paramList) {
            list.addAll(this.fetchElements(expr, context, criteria));
            if (minSize <= 0 || list.size() < minSize) continue;
            break;
        }
        return list;
    }

    private List fetchElements(CodeExpr paramExpr, Map context, CodeExpr criteria) throws InterpreterException {
        Interpreter botInter = criteria == null ? null : new Interpreter();
        ArrayList<Object> list = new ArrayList<Object>();
        if (paramExpr instanceof PropertyExpr) {
            PropertyExpr propExpr = (PropertyExpr)paramExpr;
            Object param = this.evalExprInternal(propExpr.owner, context);
            if (KScriptUtil.isCollection((Object)param)) {
                Iterator valIter = KScriptUtil.getIterator((Object)param);
                while (valIter.hasNext()) {
                    Object value = this.getProperty(valIter.next(), propExpr.propName);
                    if (value == null) continue;
                    if (botInter != null) {
                        context.put(KS_COLLECT_VALUE, value);
                        Object cond = botInter.evalExpr(criteria, context);
                        if (!Boolean.TRUE.equals(cond)) continue;
                        list.add(value);
                        continue;
                    }
                    list.add(value);
                }
            } else {
                param = this.getProperty(param, propExpr.propName);
                Iterator valIter = KScriptUtil.getIterator((Object)param);
                while (valIter.hasNext()) {
                    Object value = valIter.next();
                    if (value == null) continue;
                    if (botInter != null) {
                        context.put(KS_COLLECT_VALUE, value);
                        Object cond = botInter.evalExpr(criteria, context);
                        if (!Boolean.TRUE.equals(cond)) continue;
                        list.add(value);
                        continue;
                    }
                    list.add(value);
                }
            }
        } else {
            Object param = this.evalExprInternal(paramExpr, context);
            Iterator valIter = KScriptUtil.getIterator((Object)param);
            while (valIter.hasNext()) {
                Object value = valIter.next();
                if (value == null) continue;
                if (botInter != null) {
                    context.put(KS_COLLECT_VALUE, value);
                    Object cond = botInter.evalExpr(criteria, context);
                    if (!Boolean.TRUE.equals(cond)) continue;
                    list.add(value);
                    continue;
                }
                list.add(value);
            }
        }
        return list;
    }

    private List evalIMUniqueAll(MethodInvokeExpr methodInvokeExpr, Map context, CodeExpr criteria) throws InterpreterException {
        List list = this.evalIMAll(methodInvokeExpr, context, criteria);
        if (list.isEmpty()) {
            return list;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            Object value = list.remove(i);
            if (!list.contains(value)) {
                list.add(i, value);
                continue;
            }
            --i;
        }
        return list;
    }

    private Object evalIMMin(MethodInvokeExpr methodInvokeExpr, Map context, CodeExpr criteria) throws InterpreterException {
        List list = this.evalIMAll(methodInvokeExpr, context, criteria);
        if (list.isEmpty()) {
            return 0;
        }
        Object minVal = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            if (!TypeUtils.lessThan(list.get(i), minVal)) continue;
            minVal = list.get(i);
        }
        return minVal;
    }

    private Object evalIMMax(MethodInvokeExpr methodInvokeExpr, Map context, CodeExpr criteria) throws InterpreterException {
        List list = this.evalIMAll(methodInvokeExpr, context, criteria);
        if (list.isEmpty()) {
            return 0;
        }
        Object maxValue = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            if (!TypeUtils.greaterThan(list.get(i), maxValue)) continue;
            maxValue = list.get(i);
        }
        return maxValue;
    }

    private Object evalIMCount(MethodInvokeExpr methodInvokeExpr, Map context, CodeExpr criteria) throws InterpreterException {
        List list = this.evalIMAll(methodInvokeExpr, context, criteria);
        return list.size();
    }

    private Object evalIMAvg(MethodInvokeExpr methodInvokeExpr, Map context, CodeExpr criteria) throws InterpreterException {
        List list = this.evalIMAll(methodInvokeExpr, context, criteria);
        if (list.isEmpty()) {
            return 0;
        }
        Object sumValue = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            sumValue = TypeUtils.add(list.get(i), sumValue);
        }
        Object avgValue = TypeUtils.div(sumValue, (Object)list.size());
        return avgValue == null ? Integer.valueOf(0) : avgValue;
    }

    private Object getProperty(Object ownerValue, String property) throws InterpreterException {
        if (ownerValue == null) {
            return null;
        }
        Class<?> type = ownerValue instanceof Class ? (Class<?>)ownerValue : ownerValue.getClass();
        if (type.isArray() && property.equals("length")) {
            return new PrimitiveInt(Array.getLength(ownerValue));
        }
        this.lazyLoadGetProperty(ownerValue, property, null);
        Field field = TypeUtils.findField(type, (String)property);
        Throwable ex = null;
        if (field == null) {
            Method method = KScriptUtil.findGetMethod(type, (String)property);
            if (method != null) {
                return this.invokeMethod(ownerValue, method, null);
            }
            if (this.isObjectValue(ownerValue)) {
                if (this.isObjectValueContainPropName(ownerValue, property)) {
                    return this.getObjectValuePropValueByName(ownerValue, property);
                }
                return this.lazyLoadGetProperty(ownerValue, property, null);
            }
            if (this.isObjectCollection(ownerValue)) {
                if (this.getObjectCollectionSize(ownerValue) <= 0) {
                    return null;
                }
                if ((ownerValue = this.getObjectCollectionChildByIndex(ownerValue, 0)) == null) {
                    throw new NullPointerException("properExpr's owner is null.");
                }
                type = ownerValue instanceof Class ? (Class<?>)ownerValue : ownerValue.getClass();
                this.lazyLoadGetProperty(ownerValue, property, null);
                field = TypeUtils.findField(type, (String)property);
                if (field == null) {
                    method = KScriptUtil.findGetMethod(type, (String)property);
                    if (method != null) {
                        return this.invokeMethod(ownerValue, method, null);
                    }
                    if (this.isObjectValue(ownerValue)) {
                        PropertyExpr itemPropExpr = new PropertyExpr(null);
                        itemPropExpr.owner = new IdentifierExpr(null, "item");
                        itemPropExpr.propName = property;
                        HashMap<String, Object> itemCtx = new HashMap<String, Object>();
                        itemCtx.put("item", ownerValue);
                        return this.evalPropExpr(itemPropExpr, itemCtx);
                    }
                    throw (InterpreterException)new InterpreterException("eval properExpr error. not such field or getMethod.").setErrorLineCode(this.getSource());
                }
                try {
                    return field.get(ownerValue);
                }
                catch (Exception e) {
                    throw (InterpreterException)new InterpreterException("get property " + property + " error", (Throwable)e).setErrorLineCode(this.getSource());
                }
            }
            throw (InterpreterException)new InterpreterException("expr is : " + property, ex).setErrorLineCode(this.getSource());
        }
        try {
            field.setAccessible(true);
            return field.get(ownerValue);
        }
        catch (Exception e) {
            throw (InterpreterException)new InterpreterException("get property " + property + " error", (Throwable)e).setErrorLineCode(this.getSource());
        }
    }

    private void lazyLoadFileValue(Object value) throws InterpreterException {
        if (this.bizObjectProvider != null) {
            this.bizObjectProvider.lazyLoadFillValue(value);
        }
    }

    private boolean isObjectValue(Object value) {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.isObjectValue(value);
        }
        return false;
    }

    private boolean isObjectCollection(Object value) {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.isObjectCollection(value);
        }
        return false;
    }

    private Object lazyLoadGetProperty(Object objValue, String propName, PropertyExpr propExpr) throws InterpreterException {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.lazyLoadGetProperty(objValue, propName, propExpr);
        }
        return null;
    }

    private boolean isObjectValueContainPropName(Object value, String propName) {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.isObjectValueContainPropName(value, propName);
        }
        return false;
    }

    private Object getObjectValuePropValueByName(Object value, String propName) {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.getObjectValuePropValueByName(value, propName);
        }
        return null;
    }

    private Object getObjectCollectionChildByIndex(Object value, int index) {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.getObjectCollectionChildByIndex(value, index);
        }
        return null;
    }

    private int getObjectCollectionSize(Object value) {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.getObjectCollectionSize(value);
        }
        return -1;
    }

    private void setObjectValuePropValue(Object value, String propName, Object val) {
        if (this.bizObjectProvider != null) {
            this.bizObjectProvider.setObjectValuePropValue(value, propName, val);
        }
    }

    public boolean isProperyExprOwnerNullIgore() {
        return this.properyExprOwnerNullIgore;
    }

    public void setProperyExprOwnerNullIgore(boolean properyExprOwnerNullIgore) {
        this.properyExprOwnerNullIgore = properyExprOwnerNullIgore;
    }

    public boolean isSynchronizedCallMethod() {
        return this.synchronizedCallMethod;
    }

    public void setSynchronizedCallMethod(boolean synchronizedCallMethod) {
        this.synchronizedCallMethod = synchronizedCallMethod;
    }

    static {
        internalFunctionList.add("abs");
        internalFunctionList.add("avg");
        internalFunctionList.add("count");
        internalFunctionList.add("eval");
        internalFunctionList.add("len");
        internalFunctionList.add("max");
        internalFunctionList.add("min");
        internalFunctionList.add("newid");
        internalFunctionList.add("parseInt");
        internalFunctionList.add("parseFloat");
        internalFunctionList.add("print");
        internalFunctionList.add("println");
        internalFunctionList.add("Set");
        internalFunctionList.add("List");
        internalFunctionList.add("sum");
        internalFunctionList.add("first");
        internalFunctionList.add("last");
        internalFunctionList.add("uniqueAll");
        internalFunctionList.add("all");
        internalFunctionList.add("getByIndex");
        internalFunctionList.add("conditional_sum");
        internalFunctionList.add("conditional_avg");
        internalFunctionList.add("conditional_max");
        internalFunctionList.add("conditional_min");
        internalFunctionList.add("conditional_count");
        try {
            IFunctionProvider defaultFuncProvider = (IFunctionProvider)Class.forName("com.kingdee.eas.scm.framework.bizflow.app.formula.function.BaseFormulaFunctions").newInstance();
            publicFuncProviderList.add(defaultFuncProvider);
        }
        catch (InstantiationException e) {
            log.warn((Object)"cannot registe defaultFuncProvider[com.kingdee.eas.scm.framework.bizflow.app.formula.function.BaseFormulaFunctions]. Because : InstantiationException");
        }
        catch (IllegalAccessException e) {
            log.warn((Object)"cannot registe defaultFuncProvider[com.kingdee.eas.scm.framework.bizflow.app.formula.function.BaseFormulaFunctions]. Because : IllegalAccessException");
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)"cannot registe defaultFuncProvider[com.kingdee.eas.scm.framework.bizflow.app.formula.function.BaseFormulaFunctions]. Because : ClassNotFoundException");
        }
    }

    private static class NoneReturnValue {
        private String name;
        static NoneReturnValue NoneReturn = new NoneReturnValue("NoneReturn");

        private NoneReturnValue(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

