/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.condition.formula;

import com.kingdee.bos.kscript.ParserException;
import com.kingdee.eas.scm.framework.condition.ProcedureTypeInfo;
import com.kingdee.eas.scm.framework.condition.formula.RequirementFormulaTransformer;
import com.kingdee.eas.scm.framework.condition.model.ProcedureItemTreeInfo;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class RequiremenFormula {
    public static final String FORMULA_SRC = "Formula_Src:";
    public static final String FORMULA_DEST = "Formula_Dest:";
    public static final String FORMULA_EXPR = "Formula_Expr:";
    ProcedureTypeInfo procedureTypeInfo;
    private String valueExpression;
    private String formulaStr;
    List<ProcedureItemTreeInfo> stepList = new ArrayList<ProcedureItemTreeInfo>();

    public RequiremenFormula(String formualStr) throws Exception {
        this.formulaStr = formualStr;
        this.parse();
    }

    public RequiremenFormula(ProcedureTypeInfo procedureTypeInfo, String valueExpression) {
        this.procedureTypeInfo = procedureTypeInfo;
        this.valueExpression = valueExpression;
    }

    public RequiremenFormula(ProcedureTypeInfo procedureTypeInfo, String valueExpression, List<ProcedureItemTreeInfo> stepList) {
        this(procedureTypeInfo, valueExpression);
        this.stepList = stepList;
    }

    private void parse() throws Exception {
        LineNumberReader lnr = new LineNumberReader(new StringReader(this.formulaStr));
        String srcEntityName = null;
        String destEntityName = null;
        String line = lnr.readLine();
        while (line != null) {
            int pos = line.indexOf(FORMULA_SRC);
            if (pos >= 0) {
                pos = line.indexOf(":");
                srcEntityName = line.substring(pos + 1);
            }
            if ((pos = line.indexOf(FORMULA_DEST)) >= 0) {
                pos = line.indexOf(":");
                destEntityName = line.substring(pos + 1);
            }
            if ((pos = line.indexOf(FORMULA_EXPR)) >= 0) {
                pos = line.indexOf(":");
                this.valueExpression = line.substring(pos + 1);
            }
            line = lnr.readLine();
        }
    }

    public String getFormulaStr() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(FORMULA_SRC);
        if (this.procedureTypeInfo != null) {
            buffer.append(this.procedureTypeInfo.getName());
        }
        buffer.append("\r\n");
        buffer.append("\r\n");
        buffer.append(FORMULA_EXPR);
        if (StringUtil.isEmpty((String)this.valueExpression)) {
            buffer.append(this.valueExpression);
        }
        buffer.append("\r\n");
        this.formulaStr = buffer.toString();
        return this.formulaStr;
    }

    public String getFormualExprByAlias(String formulaAlias) throws ParserException {
        return this.getFormualExprByAlias(formulaAlias, false);
    }

    public String getFormualExprByAlias(String formulaAlias, boolean isProcedureFormula) throws ParserException {
        RequirementFormulaTransformer transfrmer = new RequirementFormulaTransformer(this.procedureTypeInfo);
        this.valueExpression = transfrmer.transforme(formulaAlias, isProcedureFormula);
        return this.valueExpression;
    }

    public String getFormualAlias() throws ParserException {
        if (StringUtil.isEmpty((String)this.valueExpression)) {
            return null;
        }
        RequirementFormulaTransformer transfrmer = new RequirementFormulaTransformer(this.procedureTypeInfo);
        String formulaAlias = transfrmer.reverseTransform(this.valueExpression);
        return formulaAlias;
    }

    public String getFormualAlias(boolean isProcedureFormula) throws ParserException {
        if (StringUtil.isEmpty((String)this.valueExpression)) {
            return null;
        }
        RequirementFormulaTransformer transfrmer = new RequirementFormulaTransformer(this.procedureTypeInfo);
        String formulaAlias = transfrmer.reverseTransform(this.valueExpression, isProcedureFormula);
        return formulaAlias;
    }

    protected Vector getEntityVarInfo() {
        Vector<Object> result = new Vector<Object>(2);
        result.add(null);
        result.add(null);
        return result;
    }

    public String getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(String valueExpression) {
        this.valueExpression = valueExpression;
    }

    public String toString() {
        String alias = "";
        try {
            alias = this.getFormualAlias();
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return alias;
    }
}

