/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.log.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.UseStatusEnum;
import com.kingdee.eas.scm.framework.log.LogConfigCollection;
import com.kingdee.eas.scm.framework.log.LogConfigEntryCollection;
import com.kingdee.eas.scm.framework.log.LogConfigEntryInfo;
import com.kingdee.eas.scm.framework.log.LogConfigInfo;
import com.kingdee.eas.scm.framework.log.SCMBizLogCache;
import com.kingdee.eas.scm.framework.log.SCMLogException;
import com.kingdee.eas.scm.framework.log.app.AbstractLogConfigControllerBean;
import com.kingdee.eas.scm.framework.log.listener.SCMBizLogAdapter;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LogConfigControllerBean
extends AbstractLogConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.framework.log.app.LogConfigControllerBean");
    private String RESOURCE = "com.kingdee.eas.scm.framework.log.SCMLogResource";
    public static final String HAS_ERROR = "hasError";
    public static final String ERROR_MSG = "errorMsg";
    Map resultMap = new HashMap();
    Map<String, Map> isRelationFieldMap = new HashMap<String, Map>();

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SCMBizLogCache.clearLogConfig();
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SCMBizLogCache.clearLogConfig();
        super._update(ctx, pk, model);
    }

    @Override
    protected void _updatePartial(Context ctx, IObjectValue model, SelectorItemCollection selector) throws BOSException, EASBizException {
        SCMBizLogCache.clearLogConfig();
        super._updatePartial(ctx, model, selector);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LogConfigInfo info = (LogConfigInfo)model;
        this.checkBeforeSubmit(ctx, info);
        if (info.getStatus().getValue() != 2) {
            info.setStatus(UseStatusEnum.SAVED);
        }
        LogConfigEntryCollection coll = info.getEntry();
        this.setRelationField(ctx, coll);
        LogConfigEntryInfo entryInfo = null;
        String field = null;
        String bosType = null;
        for (int i = 0; i < coll.size(); ++i) {
            entryInfo = coll.get(i);
            bosType = entryInfo.getBillBosType();
            field = entryInfo.getField();
            if (field == null) continue;
            entryInfo.setIsRelationField((Boolean)this.isRelationFieldMap.get(bosType).get(field));
        }
        return super._submit(ctx, (IObjectValue)info);
    }

    private void setRelationField(Context ctx, LogConfigEntryCollection coll) throws BOSException, EASBizException {
        String field = null;
        String bosType = null;
        List<String> list = null;
        HashMap<String, List<String>> fieldsMap = new HashMap<String, List<String>>();
        for (int i = 0; i < coll.size(); ++i) {
            LogConfigEntryInfo entryInfo = coll.get(i);
            bosType = entryInfo.getBillBosType();
            field = entryInfo.getField();
            if (field == null) continue;
            if (fieldsMap.containsKey(bosType)) {
                list = (List)fieldsMap.get(bosType);
                list.add(field);
                continue;
            }
            list = new ArrayList();
            list.add(field);
            fieldsMap.put(bosType, list);
        }
        this.getRelationFieldMap(ctx, fieldsMap);
    }

    private void getRelationFieldMap(Context ctx, Map<String, List<String>> fieldsMap) throws BOSException, EASBizException {
        if (fieldsMap != null) {
            Set<String> set = fieldsMap.keySet();
            String bosType = null;
            Iterator<String> iterator = set.iterator();
            HashMap<String, Boolean> map = null;
            while (iterator.hasNext()) {
                bosType = iterator.next();
                map = new HashMap<String, Boolean>();
                List<String> thisFieldsList = fieldsMap.get(bosType.toString());
                if (thisFieldsList != null) {
                    Map<String, List<String>> fieldMap = SCMBizLogAdapter.getFieldMap(thisFieldsList);
                    EntityObjectInfo bo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(BOSObjectType.create((String)bosType));
                    if (bo.getCompositions() != null) {
                        List childBoMapping = bo.getCompositions().one2many;
                        for (EntityObjectInfo.Prop2ChildBoMapping p2 : childBoMapping) {
                            EntityObjectInfo entry = p2.childBO;
                            String entryName = p2.prop.getName();
                            if (fieldMap.get(entryName) == null) continue;
                            List Name2PropList = entry.getCompositions().allInstProp;
                            for (EntityObjectInfo.Name2PropMapping name2PropMapping : Name2PropList) {
                                if (!fieldMap.get(entryName).contains(name2PropMapping.prop.getName())) continue;
                                map.put(entryName + "." + name2PropMapping.prop.getName(), name2PropMapping.prop.get("relationship") != null);
                            }
                        }
                        if (fieldMap.get("bill") != null) {
                            List Name2PropList = bo.getCompositions().allInstProp;
                            for (EntityObjectInfo.Name2PropMapping name2PropMapping : Name2PropList) {
                                if (!fieldMap.get("bill").contains(name2PropMapping.prop.getName())) continue;
                                map.put(name2PropMapping.prop.getName(), name2PropMapping.prop.get("relationship") != null);
                            }
                        }
                    }
                }
                this.isRelationFieldMap.put(bosType, map);
            }
        }
    }

    @Override
    protected Map _batchEnable(Context ctx, List idList) throws BOSException, EASBizException {
        return this.batchEnbleOrDisable(ctx, idList, true);
    }

    @Override
    protected Map _batchDisable(Context ctx, List idList) throws BOSException, EASBizException {
        return this.batchEnbleOrDisable(ctx, idList, false);
    }

    private Map batchEnbleOrDisable(Context ctx, List idList, boolean isEnble) throws BOSException, EASBizException {
        LogConfigCollection logConfigCollection = this.getLogConfigCollByIds(ctx, idList);
        String msg = null;
        boolean hasError = false;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        StringBuilder result = new StringBuilder();
        HashSet<String> validateIdSet = new HashSet<String>();
        LogConfigInfo logConfigInfo = null;
        HashMap checkMap = new HashMap();
        int size = logConfigCollection.size();
        for (int i = 0; i < size; ++i) {
            logConfigInfo = logConfigCollection.get(i);
            msg = isEnble ? this.checkBeforeEnable(ctx, (IObjectValue)logConfigInfo, false) : this.checkBeforeDisable(ctx, (IObjectValue)logConfigInfo, false);
            if (!StringUtils.isEmpty((String)msg)) {
                hasError = true;
                result.append(msg).append("\n");
                continue;
            }
            validateIdSet.add(logConfigCollection.get(i).getId().toString());
        }
        resultMap.put(HAS_ERROR, hasError);
        resultMap.put(ERROR_MSG, result.toString());
        this.updateStatus(ctx, validateIdSet, isEnble ? 1 : 2);
        SCMBizLogCache.clearLogConfig();
        return resultMap;
    }

    private void updateStatus(Context ctx, Set idSet, int stateValue) throws BOSException {
        if (idSet == null || idSet.isEmpty()) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" update T_SCM_LogConfig set FStatus = ").append(stateValue).append(" ");
        sql.append(" where fid in (").append(ArrayUtil.getKeyIdStr((Object[])idSet.toArray())).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private LogConfigCollection getLogConfigCollByIds(Context ctx, List idList) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet idSet = new HashSet();
        idSet.addAll(idList);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelectorItemCollection());
        LogConfigCollection logConfigCollection = this.getLogConfigCollection(ctx, view);
        return logConfigCollection;
    }

    private void checkBeforeSubmit(Context ctx, LogConfigInfo info) throws EASBizException, BOSException {
        LogConfigInfo model;
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new SCMLogException(SCMLogException.NUMBER_NOTNULL);
        }
        if (StringUtils.isEmpty((String)info.getName())) {
            throw new SCMLogException(SCMLogException.NAME_NOTNULL);
        }
        if (info.getLogType() == null) {
            throw new SCMLogException(SCMLogException.LOGTYPE_NOTNULL);
        }
        LogConfigEntryCollection entryColl = info.getEntry();
        if (entryColl == null || entryColl.size() <= 0) {
            throw new SCMLogException(SCMLogException.ENTRY_NOTNULL);
        }
        LogConfigEntryInfo entryInfo = null;
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryColl.get(i);
            if (entryInfo.getBillName() == null) {
                throw new SCMLogException(SCMLogException.BILLTYPE_NOTNULL, new String[]{String.valueOf(i + 1)});
            }
            if (entryInfo.getField() != null || info.getLogType().getValue() != 1) continue;
            throw new SCMLogException(SCMLogException.FIELD_NOTNULL, new String[]{String.valueOf(i + 1)});
        }
        if (info.getId() != null && (model = this.getLogConfigInfo(ctx, info.getId().toString())).getStatus() == UseStatusEnum.ACTIVE) {
            throw new SCMLogException(SCMLogException.BILL_ACTIVE);
        }
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        LogConfigInfo info = this.getLogConfigInfo(ctx, pk.toString());
        this.checkBeforeEnable(ctx, (IObjectValue)info, true);
        info.setStatus(UseStatusEnum.ACTIVE);
        super._cancelCancel(ctx, pk, (IObjectValue)info);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        LogConfigInfo info = this.getLogConfigInfo(ctx, pk.toString());
        this.checkBeforeDisable(ctx, (IObjectValue)info, true);
        info.setStatus(UseStatusEnum.INACTIVE);
        super._cancel(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LogConfigInfo info = this.getLogConfigInfo(ctx, pk.toString());
        this.checkBeforeDelete(ctx, info);
        super._delete(ctx, pk);
        SCMBizLogCache.clearLogConfig();
    }

    public void checkBeforeDelete(Context ctx, LogConfigInfo info) throws EASBizException, BOSException {
        if (!UseStatusEnum.SAVED.equals((Object)info.getStatus())) {
            throw new SCMLogException(SCMLogException.BILL_DELETE);
        }
        LogConfigEntryCollection coll = info.getEntry();
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                LogConfigEntryInfo entryInfo = coll.get(i);
                if (!entryInfo.isIsSystem()) continue;
                throw new SCMLogException(SCMLogException.BILL_ISSYSTEM);
            }
        }
    }

    private String checkBeforeDisable(Context ctx, IObjectValue model, boolean needThrowEx) throws EASBizException, BOSException {
        LogConfigInfo logConfigInfo = (LogConfigInfo)model;
        StringBuilder checkMsg = new StringBuilder();
        String logConfig = ResourceBase.getString((String)this.RESOURCE, (String)"logConfig", (Locale)ctx.getLocale());
        if (logConfigInfo.getStatus() != UseStatusEnum.ACTIVE) {
            checkMsg.append(ResourceBase.getString((String)this.RESOURCE, (String)"not_Active_not_Disable", (Locale)ContextUtils.getLocaleFromEnv(), (Object[])new String[]{logConfig + logConfigInfo.getNumber()}));
        }
        if (!StringUtils.isEmpty((String)checkMsg.toString()) && needThrowEx) {
            throw new SCMLogException(SCMLogException.EMPTYEXCEPTION, new String[]{checkMsg.toString()});
        }
        return checkMsg.toString();
    }

    private String checkBeforeEnable(Context ctx, IObjectValue model, boolean needThrowEx) throws EASBizException, BOSException {
        LogConfigInfo logConfigInfo = (LogConfigInfo)model;
        StringBuilder checkMsg = new StringBuilder();
        String logConfig = ResourceBase.getString((String)this.RESOURCE, (String)"logConfig", (Locale)ctx.getLocale());
        if (logConfigInfo.getStatus() == UseStatusEnum.ACTIVE) {
            checkMsg.append(ResourceBase.getString((String)this.RESOURCE, (String)"statu_Active", (Locale)ctx.getLocale(), (Object[])new String[]{logConfig + logConfigInfo.getNumber()}));
        } else if (this.isHasEnableLogType(ctx, logConfigInfo)) {
            checkMsg.append(ResourceBase.getString((String)this.RESOURCE, (String)"hasBillActive", (Locale)ctx.getLocale(), (Object[])new String[]{logConfig + logConfigInfo.getNumber()}));
        }
        if (!StringUtils.isEmpty((String)checkMsg.toString()) && needThrowEx) {
            throw new SCMLogException(SCMLogException.EMPTYEXCEPTION, new String[]{checkMsg.toString()});
        }
        return checkMsg.toString();
    }

    private boolean isHasEnableLogType(Context ctx, LogConfigInfo logConfigInfo) throws BOSException {
        String key = logConfigInfo.getCU().getId() + logConfigInfo.getLogType().getName();
        if (this.resultMap.containsKey(key)) {
            return true;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cu", (Object)logConfigInfo.getCU().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("logType", (Object)logConfigInfo.getLogType().getValue(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("id"));
        view.setFilter(filter);
        view.setSelector(sics);
        LogConfigCollection logConfigCollection = this.getLogConfigCollection(ctx, view);
        this.resultMap.put(key, logConfigInfo);
        return logConfigCollection.size() > 0;
    }

    @Override
    public LogConfigInfo getLogConfigInfo(Context ctx, String id) throws EASBizException, BOSException {
        this.checkExist(ctx, (IObjectPK)new ObjectUuidPK(id));
        return this.getLogConfigInfo(ctx, (IObjectPK)new ObjectUuidPK(id), this.getSelectorItemCollection());
    }

    private SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("number"));
        sics.add(new SelectorItemInfo("name"));
        sics.add(new SelectorItemInfo("logType"));
        sics.add(new SelectorItemInfo("CU.id"));
        sics.add(new SelectorItemInfo("status"));
        sics.add(new SelectorItemInfo("entry.billType"));
        sics.add(new SelectorItemInfo("entry.field"));
        sics.add(new SelectorItemInfo("entry.isSystem"));
        return sics;
    }

    private void checkExist(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (!this.exists(ctx, pk)) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.scm.common.ActionResource", (String)"BILL_NOT_FOUND", (Locale)ctx.getLocale());
            throw new SCMLogException(SCMLogException.EMPTYEXCEPTION, new String[]{msg});
        }
    }
}

