/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.portrait.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.framework.UseStatusEnum;
import com.kingdee.eas.scm.framework.portrait.CreditBalanceIndexInfo;
import com.kingdee.eas.scm.framework.portrait.SCMPortraitCollection;
import com.kingdee.eas.scm.framework.portrait.SCMPortraitEntryCollection;
import com.kingdee.eas.scm.framework.portrait.SCMPortraitEntryInfo;
import com.kingdee.eas.scm.framework.portrait.SCMPortraitException;
import com.kingdee.eas.scm.framework.portrait.SCMPortraitFeildInfo;
import com.kingdee.eas.scm.framework.portrait.SCMPortraitIndexInfo;
import com.kingdee.eas.scm.framework.portrait.SCMPortraitInfo;
import com.kingdee.eas.scm.framework.portrait.app.AbstractSCMPortraitControllerBean;
import com.kingdee.eas.scm.framework.portrait.util.SCMPortraitUtil;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SCMPortraitControllerBean
extends AbstractSCMPortraitControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.framework.portrait.app.SCMPortraitControllerBean");
    private String RESOURCE = "com.kingdee.eas.scm.framework.portrait.SCMPortraitResource";
    public static final String PREFIX = "%";
    public static final String SELECT = "select";
    public static final String AS = " as ";
    public static final String AND = " AND ";
    private CreditBalanceIndexInfo creditBalance = null;

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (!UseStatusEnum.INACTIVE.equals((Object)((SCMPortraitInfo)model).getStatus())) {
            this.setState(model, UseStatusEnum.SAVED);
        }
        this.checkBeforeSubmit(ctx, model);
        return super._submit(ctx, model);
    }

    private void checkBeforeSubmit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        SCMPortraitInfo scmPortraitInfo;
        SCMPortraitInfo info = (SCMPortraitInfo)model;
        if (StringUtils.isEmpty((String)info.getNumber())) {
            this.throwException("numberCantBeNull", ctx);
        }
        if (StringUtils.isEmpty((String)info.getName())) {
            this.throwException("nameCantBeNull", ctx);
        }
        if (info.getCU() == null) {
            this.throwException("CUCantBeNull", ctx);
        }
        if (StringUtils.isEmpty((String)info.getBillName())) {
            this.throwException("billCantBeNull", ctx);
        }
        SCMPortraitEntryCollection entryColl = info.getEntry();
        SCMPortraitEntryInfo entryInfo = null;
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryColl.get(i);
            if (entryInfo.getPortraitIndex() == null) {
                this.throwException("indexBeNull", ctx);
            }
            if (entryInfo.getIndexItem() != null) continue;
            this.throwException("resultFieldBeNull", ctx);
        }
        if (info.getId() != null && (scmPortraitInfo = this.getNewestStatusInfo4Check(ctx, info.getId().toString())).getStatus() == UseStatusEnum.ACTIVE) {
            throw new SCMPortraitException(SCMPortraitException.STATUSERROR4SAVE);
        }
        this.checkNumberDup(ctx, info);
        this.checkNameDup(ctx, info);
    }

    private SCMPortraitInfo getNewestStatusInfo4Check(Context ctx, String id) throws EASBizException, BOSException {
        this.checkExist(ctx, (IObjectPK)new ObjectUuidPK(id));
        return this.getSCMPortraitInfo(ctx, (IObjectPK)new ObjectUuidPK(id), this.getSelectorItemCollection());
    }

    private void checkExist(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (!this.exists(ctx, pk)) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.scm.common.ActionResource", (String)"BILL_NOT_FOUND", (Locale)ctx.getLocale());
            throw new SCMPortraitException(SCMPortraitException.EMPTYEXCEPTION, new String[]{msg});
        }
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SCMPortraitInfo info = this.getNewestStatusInfo4Check(ctx, pk.toString());
        this.checkBeforeDisable(ctx, (IObjectValue)info, true);
        this.setState((IObjectValue)info, UseStatusEnum.INACTIVE);
        super._cancel(ctx, pk, (IObjectValue)info);
    }

    private String checkBeforeDisable(Context ctx, IObjectValue model, boolean needThrowEx) throws EASBizException, BOSException {
        SCMPortraitInfo scmPortraitInfo = (SCMPortraitInfo)model;
        StringBuilder checkMsg = new StringBuilder();
        String scmPortrait = ResourceBase.getString((String)this.RESOURCE, (String)"scmPortrait", (Locale)ctx.getLocale());
        if (scmPortraitInfo.getStatus() == UseStatusEnum.INACTIVE) {
            checkMsg.append(ResourceBase.getString((String)this.RESOURCE, (String)"badState2Disable", (Locale)ContextUtils.getLocaleFromEnv(), (Object[])new String[]{scmPortrait + scmPortraitInfo.getNumber()}));
        } else if (scmPortraitInfo.getStatus() != UseStatusEnum.ACTIVE) {
            checkMsg.append(ResourceBase.getString((String)this.RESOURCE, (String)"saveState2Disable", (Locale)ContextUtils.getLocaleFromEnv(), (Object[])new String[]{scmPortrait + scmPortraitInfo.getNumber()}));
        }
        if (!StringUtils.isEmpty((String)checkMsg.toString()) && needThrowEx) {
            throw new SCMPortraitException(SCMPortraitException.EMPTYEXCEPTION, new String[]{checkMsg.toString()});
        }
        return checkMsg.toString();
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SCMPortraitInfo info = this.getNewestStatusInfo4Check(ctx, pk.toString());
        this.checkBeforeEnable(ctx, (IObjectValue)info, true);
        this.setState((IObjectValue)info, UseStatusEnum.ACTIVE);
        super._cancelCancel(ctx, pk, (IObjectValue)info);
    }

    private void setState(IObjectValue model, UseStatusEnum state) {
        SCMPortraitInfo info = (SCMPortraitInfo)model;
        info.setStatus(state);
    }

    private String checkBeforeEnable(Context ctx, IObjectValue model, boolean needThrowEx) throws EASBizException, BOSException {
        SCMPortraitInfo scmPortraitInfo = (SCMPortraitInfo)model;
        StringBuilder checkMsg = new StringBuilder();
        String scmPortrait = ResourceBase.getString((String)this.RESOURCE, (String)"scmPortrait", (Locale)ctx.getLocale());
        if (scmPortraitInfo.getStatus() == UseStatusEnum.ACTIVE) {
            checkMsg.append(ResourceBase.getString((String)this.RESOURCE, (String)"badState2Eanble", (Locale)ctx.getLocale(), (Object[])new String[]{scmPortrait + scmPortraitInfo.getNumber()}));
        } else if (needThrowEx && this.isHasEnablePortrait(ctx, scmPortraitInfo)) {
            checkMsg.append(ResourceBase.getString((String)this.RESOURCE, (String)"hasBillActive", (Locale)ctx.getLocale(), (Object[])new String[]{scmPortrait + scmPortraitInfo.getNumber()}));
        }
        if (!StringUtils.isEmpty((String)checkMsg.toString()) && needThrowEx) {
            throw new SCMPortraitException(SCMPortraitException.EMPTYEXCEPTION, new String[]{checkMsg.toString()});
        }
        return checkMsg.toString();
    }

    private boolean isHasEnablePortrait(Context ctx, SCMPortraitInfo scmPortraitInfo) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cu", (Object)scmPortraitInfo.getCU().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("portraitType", (Object)scmPortraitInfo.getPortraitType().getValue(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("billBosType", (Object)scmPortraitInfo.getBillBosType(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("id"));
        view.setFilter(filter);
        view.setSelector(sics);
        SCMPortraitCollection scmPortraitCollection = this.getSCMPortraitCollection(ctx, view);
        return scmPortraitCollection.size() > 0;
    }

    private SCMPortraitCollection getSCMPortraitCollByIds(Context ctx, List idList) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet idSet = new HashSet();
        idSet.addAll(idList);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelectorItemCollection());
        SCMPortraitCollection scmPortraitCollection = this.getSCMPortraitCollection(ctx, view);
        if (scmPortraitCollection.size() != idSet.size()) {
            throw new SCMPortraitException(SCMPortraitException.EMPTYEXCEPTION, new String[]{ResourceBase.getString((String)this.RESOURCE, (String)"billNotExists", (Locale)ctx.getLocale())});
        }
        return scmPortraitCollection;
    }

    private SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("status"));
        sics.add(new SelectorItemInfo("isSystem"));
        sics.add(new SelectorItemInfo("number"));
        sics.add(new SelectorItemInfo("name"));
        sics.add(new SelectorItemInfo("billBosType"));
        sics.add(new SelectorItemInfo("portraitType"));
        sics.add(new SelectorItemInfo("CU.id"));
        return sics;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SCMPortraitInfo info = this.getNewestStatusInfo4Check(ctx, pk.toString());
        this.checkBeforeDelete(ctx, info);
        super._delete(ctx, pk);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        super._delete(ctx, arrayPK);
    }

    private void checkBeforeDelete(Context ctx, SCMPortraitInfo info) throws EASBizException, BOSException {
        String permission = SCMPortraitUtil.checkFunctionPermissionStr(ctx, null, info.getCU().getId().toString(), "portrait_delete");
        if (permission != null) {
            throw new SCMPortraitException(SCMPortraitException.EMPTYEXCEPTION, new String[]{permission});
        }
        if (!UseStatusEnum.SAVED.equals((Object)info.getStatus())) {
            throw new SCMPortraitException(SCMPortraitException.STATUSERROR4DELETE);
        }
        if (info.isIsSystem()) {
            this.throwException("systemNotDelete", ctx);
        }
    }

    private void throwException(String resourceKey, Context ctx) throws EASBizException {
        throw new SCMPortraitException(SCMPortraitException.EMPTYEXCEPTION, new String[]{EASResource.getString((String)this.RESOURCE, (String)resourceKey, (Locale)ctx.getLocale())});
    }

    @Override
    protected Map _batchEnable(Context ctx, List idList) throws BOSException, EASBizException {
        return this.batchEnbleOrDisable(ctx, idList, true);
    }

    @Override
    protected Map _batchDisable(Context ctx, List idList) throws BOSException, EASBizException {
        return this.batchEnbleOrDisable(ctx, idList, false);
    }

    private Map batchEnbleOrDisable(Context ctx, List idList, boolean isEnble) throws BOSException, EASBizException {
        SCMPortraitCollection scmPortraitCollection = this.getSCMPortraitCollByIds(ctx, idList);
        String operation = null;
        String method = null;
        if (isEnble) {
            operation = "portrait_enable";
            method = "batchEnable";
        } else {
            operation = "portrait_disable";
            method = "batchDisable";
        }
        String msg = null;
        boolean hasError = false;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        StringBuilder result = new StringBuilder();
        HashSet<String> validateIdSet = new HashSet<String>();
        SCMPortraitInfo scmPortraitInfo = null;
        HashMap<String, String> permission = new HashMap<String, String>();
        String cuId = null;
        String permissionStr = null;
        String scmPortrait = ResourceBase.getString((String)this.RESOURCE, (String)"scmPortrait", (Locale)ctx.getLocale());
        Set keySet = null;
        if (isEnble) {
            keySet = this.getEnablePortraitKeySet(ctx, scmPortraitCollection);
        }
        int size = scmPortraitCollection.size();
        for (int i = 0; i < size; ++i) {
            scmPortraitInfo = scmPortraitCollection.get(i);
            cuId = scmPortraitInfo.getCU().getId().toString();
            if (!permission.containsKey(cuId)) {
                permissionStr = SCMPortraitUtil.checkFunctionPermissionStr(ctx, null, cuId, operation);
                permission.put(cuId, permissionStr);
            }
            if (!StringUtils.isEmpty((String)(msg = permission.get(cuId) == null ? (isEnble ? this.checkBeforeEnable(ctx, (IObjectValue)scmPortraitInfo, false) : this.checkBeforeDisable(ctx, (IObjectValue)scmPortraitInfo, false)) : scmPortraitInfo.getNumber() + " " + permission.get(cuId)))) {
                hasError = true;
                result.append(msg).append("\n");
                continue;
            }
            if (isEnble) {
                String key = scmPortraitInfo.getBillBosType() + cuId + scmPortraitInfo.getPortraitType().getValue();
                if (keySet.add(key)) {
                    validateIdSet.add(scmPortraitInfo.getId().toString());
                    continue;
                }
                hasError = true;
                result.append(ResourceBase.getString((String)this.RESOURCE, (String)"hasBillActive", (Locale)ctx.getLocale(), (Object[])new String[]{scmPortrait + scmPortraitInfo.getNumber()})).append("\n");
                continue;
            }
            validateIdSet.add(scmPortraitInfo.getId().toString());
        }
        resultMap.put("hasError", hasError);
        resultMap.put("errorMsg", result.toString());
        this.updateStatus(ctx, validateIdSet, isEnble ? 1 : 2);
        SCMPortraitUtil.buildLogInfo(ctx, (IObjectCollection)scmPortraitCollection, validateIdSet, operation, method, this.getBOSType());
        return resultMap;
    }

    private Set getEnablePortraitKeySet(Context ctx, SCMPortraitCollection scmPortraitCollection) throws BOSException {
        HashSet<String> set = new HashSet<String>();
        HashSet<String> cuSet = new HashSet<String>();
        for (int i = 0; i < scmPortraitCollection.size(); ++i) {
            cuSet.add(scmPortraitCollection.get(i).getCU().getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cu", cuSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("id"));
        sics.add(new SelectorItemInfo("cu"));
        sics.add(new SelectorItemInfo("portraitType"));
        sics.add(new SelectorItemInfo("billBosType"));
        view.setFilter(filter);
        view.setSelector(sics);
        SCMPortraitCollection coll = this.getSCMPortraitCollection(ctx, view);
        for (int i = 0; i < coll.size(); ++i) {
            SCMPortraitInfo scmPortraitInfo = coll.get(i);
            String key = scmPortraitInfo.getBillBosType() + scmPortraitInfo.getCU().getId().toString() + scmPortraitInfo.getPortraitType().getValue();
            set.add(key);
        }
        return set;
    }

    private void updateStatus(Context ctx, Set idSet, int stateValue) throws BOSException {
        if (idSet == null || idSet.isEmpty()) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" update T_SCM_SCMPortrait set FStatus = ").append(stateValue).append(" ");
        sql.append(" where fid in (").append(ArrayUtil.getKeyIdStr((Object[])idSet.toArray())).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected Map _getPortraitData(Context ctx, IObjectValue model, int portraitType, int rowIndex) throws BOSException, EASBizException {
        if (model.getBOSType() == null || model.get("id") == null) {
            return null;
        }
        CtrlUnitInfo cu = (CtrlUnitInfo)model.get("CU");
        PermItemInfo permItemInfo = SCMPortraitUtil.getPortraitPermission(ctx, model.getBOSType().toString());
        OrgUnitInfo org = null;
        CoreBillBaseInfo info = (CoreBillBaseInfo)model;
        if (info.getBizOrgPropertyName() != null) {
            org = (OrgUnitInfo)info.get(info.getBizOrgPropertyName());
            if (cu == null) {
                if (org.getCU() == null) {
                    org = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(org.getId().toString()));
                }
                cu = org.getCU();
            }
        }
        if (cu == null) {
            return null;
        }
        if (permItemInfo != null && org != null && !SCMPortraitUtil.checkFunctionPermission(ctx, null, org.getId().toString(), permItemInfo.getNumber())) {
            return null;
        }
        Map resultMap = new HashMap();
        SCMPortraitInfo scmPortraitInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billBosType", (Object)model.getBOSType().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("portraitType", (Object)portraitType, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("CU", (Object)cu.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("color"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.portraitindex.*"));
        viewInfo.setSelector(sic);
        SCMPortraitCollection scmPortraitCollection = this.getSCMPortraitCollection(ctx, viewInfo);
        if (scmPortraitCollection.size() == 0) {
            return null;
        }
        scmPortraitInfo = scmPortraitCollection.get(0);
        if (!this.checkBillFilter(ctx, model, scmPortraitInfo.getBillQueryPk(), scmPortraitInfo.getBillFilterString())) {
            return null;
        }
        resultMap = this.batchExecuteSql(ctx, model, scmPortraitInfo.getEntry(), rowIndex, scmPortraitInfo.getColor());
        return resultMap;
    }

    private Map batchExecuteSql(Context ctx, IObjectValue model, SCMPortraitEntryCollection entry, int rowIndex, String color) throws BOSException, SCMPortraitException {
        HashMap resultMap = new HashMap();
        HashMap<String, IRowSet> rowSetCache = new HashMap<String, IRowSet>();
        ArrayList<SCMPortraitFeildInfo> resultList = new ArrayList<SCMPortraitFeildInfo>();
        SCMPortraitEntryInfo entryInfo = null;
        SCMPortraitIndexInfo portraitIndex = null;
        String sql = null;
        IRowSet rowSet = null;
        String matchString = null;
        String rowSetKey = null;
        Object feildArr = null;
        Object rowValue = null;
        try {
            entry.sort("indexSeq");
            for (int i = 0; i < entry.size(); ++i) {
                entryInfo = entry.get(i);
                portraitIndex = entryInfo.getPortraitIndex();
                if (!portraitIndex.getState().equals((Object)UseStatusEnum.ACTIVE) || !this.isExistPortraitIndex(portraitIndex.getResultField(), entryInfo.getIndexItem())) continue;
                matchString = entryInfo.getMatchString();
                rowSetKey = portraitIndex.getId().toString() + matchString;
                if (rowSetCache.containsKey(rowSetKey)) {
                    rowSet = (IRowSet)rowSetCache.get(rowSetKey);
                    resultList.add(this.getValue(entryInfo.getIndexItem(), rowSet, entryInfo.getWarnMaxValue(), entryInfo.getWarnMinValue(), color));
                    continue;
                }
                sql = portraitIndex.getSqlText();
                this.checkCreditBalanceIndex(ctx, sql);
                sql = this.appendMatchSql(model, sql, matchString, rowIndex);
                if (this.creditBalance != null) {
                    sql = sql.replace("creditTempTable", this.creditBalance.getCreditTempTable());
                }
                sql = SCMPortraitUtil.evalFunction(sql);
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                resultList.add(this.getValue(entryInfo.getIndexItem(), rowSet, entryInfo.getWarnMaxValue(), entryInfo.getWarnMinValue(), color));
                rowSetCache.put(rowSetKey, rowSet);
                if (this.creditBalance == null) continue;
                this.creditBalance.releaseTempTable();
                this.creditBalance = null;
            }
            resultMap.put("resultList", resultList);
        }
        catch (EASBizException | SQLException e) {
            throw new BOSException(e);
        }
        finally {
            if (this.creditBalance != null) {
                this.creditBalance.releaseTempTable();
                this.creditBalance = null;
            }
        }
        return resultMap;
    }

    private void checkCreditBalanceIndex(Context ctx, String sql) {
        if (sql.contains("creditTempTable")) {
            this.creditBalance = new CreditBalanceIndexInfo(ctx);
        }
    }

    private SCMPortraitFeildInfo getValue(String indexItem, IRowSet rowSet, BigDecimal maxValue, BigDecimal minValue, String color) throws SQLException {
        rowSet.beforeFirst();
        HashSet<Object> set = new HashSet<Object>();
        SCMPortraitFeildInfo info = new SCMPortraitFeildInfo(indexItem);
        while (rowSet.next()) {
            set.add(rowSet.getObject(indexItem));
        }
        if (set.size() == 0) {
            return info;
        }
        Iterator iterator = set.iterator();
        if (set.size() == 1) {
            Object value = iterator.next();
            info.setValue(value);
            if (value instanceof BigDecimal && (maxValue != null || minValue != null)) {
                BigDecimal value1 = (BigDecimal)value;
                if (maxValue != null && minValue != null) {
                    info.setUp(value1.compareTo(maxValue) > 0);
                    info.setDowm(value1.compareTo(minValue) < 0);
                } else if (maxValue != null) {
                    info.setUp(value1.compareTo(maxValue) > 0);
                } else if (minValue != null) {
                    info.setDowm(value1.compareTo(minValue) < 0);
                }
                info.setColor(color != null ? new Color(Integer.parseInt(color)) : Color.RED);
            }
            return info;
        }
        StringBuilder value = new StringBuilder();
        Object object = null;
        while (iterator.hasNext()) {
            value.append(iterator.next().toString()).append(";");
        }
        info.setValue(value.substring(0, value.length() - 1));
        return info;
    }

    private boolean isExistPortraitIndex(String resultField, String indexItem) {
        String[] feildArr;
        for (String s : feildArr = SCMPortraitUtil.getFeildArr(resultField)) {
            if (!s.equals(indexItem)) continue;
            return true;
        }
        return false;
    }

    private String appendMatchSql(IObjectValue model, String sql, String matchString, int rowIndex) throws BOSException {
        if (matchString == null) {
            return sql;
        }
        StringBuffer whereSql = new StringBuffer("WHERE 1=1 ");
        try {
            FilterInfo filterInfo = new FilterInfo(matchString);
            FilterItemCollection filterItems = filterInfo.getFilterItems();
            String columnName = null;
            FilterItemInfo itemInfo = null;
            String value = null;
            for (int i = 0; i < filterItems.size(); ++i) {
                itemInfo = filterItems.get(i);
                columnName = "T." + itemInfo.getPropertyName();
                value = this.findModelValue(model, (String)itemInfo.getCompareValue(), rowIndex);
                if (value.contains("'null'")) {
                    columnName = "isnull(" + columnName + ",'null')";
                }
                whereSql.append(AND).append(columnName).append(" in (").append(value).append(") ");
            }
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        sql = SCMPortraitUtil.addShellSql(sql, whereSql.toString());
        return sql;
    }

    private String findModelValue(IObjectValue model, String property, int rowIndex) {
        String[] propertyName = property.split("\\.");
        if (propertyName.length == 1) {
            return this.getObjToSqlString(model.get(property));
        }
        IObjectValue objectValue = model;
        Object obj = null;
        if (propertyName.length == 2) {
            StringBuffer values = new StringBuffer();
            IObjectCollection coll = (IObjectCollection)objectValue.get(propertyName[0]);
            if (rowIndex != -1) {
                objectValue = coll.getObject(rowIndex);
                values.append(this.getObjToSqlString(objectValue.get(propertyName[1])));
            } else {
                for (int i = 0; i < coll.size(); ++i) {
                    if (i > 0) {
                        values.append(",");
                    }
                    objectValue = coll.getObject(i);
                    values.append(this.getObjToSqlString(objectValue.get(propertyName[1])));
                }
            }
            return values.toString();
        }
        return "";
    }

    private String getObjToSqlString(Object obj) {
        if (obj == null) {
            return "'null'";
        }
        StringBuffer sql = new StringBuffer();
        if (obj instanceof IObjectValue) {
            IObjectValue value = (IObjectValue)obj;
            sql.append("'").append(value.get("id")).append("',");
            sql.append("'").append(value.get("number")).append("'");
            if (this.creditBalance != null) {
                if (obj instanceof CompanyOrgUnitInfo) {
                    this.creditBalance.setCompanyId(((CompanyOrgUnitInfo)obj).getId());
                } else if (obj instanceof CustomerInfo) {
                    this.creditBalance.setCustomerId(((CustomerInfo)obj).getId());
                }
            }
        } else {
            sql.append("'").append(obj.toString()).append("'");
        }
        return sql.toString();
    }

    private boolean checkBillFilter(Context ctx, IObjectValue model, String billQueryPk, String billFilterString) throws BOSException {
        if (model.get("id") == null) {
            return false;
        }
        if (StringUtils.isEmpty((String)billFilterString)) {
            return true;
        }
        try {
            FilterInfo filterInfo = new FilterInfo(billFilterString);
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)model.get("id").toString(), CompareType.EQUALS));
            filterInfo.setMaskString(filterInfo.getMaskString() + " AND #" + (filterInfo.getFilterItems().size() - 1));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filterInfo);
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)billQueryPk));
            exec.option().isIgnorePermissionCheck = true;
            exec.setObjectView(view);
            return exec.getRowCount() != 0;
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

