/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.robot.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.framework.robot.ISCMRobotExecuteAccount;
import com.kingdee.eas.scm.framework.robot.SCMRobotExecuteAccountFactory;
import com.kingdee.eas.scm.framework.robot.SCMRobotExecuteAccountInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaEntryInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaOrgEntryInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SCMRobotExecuteAccountRecoder {
    public String addNewReport(Context ctx, SCMRobotSchemaInfo schema, SCMRobotSchemaEntryInfo entryInfo, SCMRobotSchemaOrgEntryInfo orgEntryInfo, UserInfo exeUser, String uuid, int seq, SCMRobotSchemaStateEnum state) throws BOSException, EASBizException {
        SCMRobotExecuteAccountInfo reportInfo = new SCMRobotExecuteAccountInfo();
        reportInfo.setBusinessName(entryInfo.getOperation().getBussinessName());
        reportInfo.setOperationNumber(entryInfo.getOperation().getOperationNumber());
        reportInfo.setOperationName(entryInfo.getOperation().getOperationName());
        reportInfo.setOperationId(entryInfo.getOperation().getId().toString());
        String orgID = null;
        if (orgEntryInfo != null && orgEntryInfo.getOrgUnit() != null) {
            orgID = orgEntryInfo.getOrgUnit().getId().toString();
        }
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String strDate = sdf.format(date);
        try {
            date = sdf.parse(strDate);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (state == null) {
            state = SCMRobotSchemaStateEnum.STATE_WAITING;
        }
        reportInfo.setSchemaName(schema.getName());
        reportInfo.setNumber(schema.getNumber());
        reportInfo.setState(state);
        reportInfo.setStartTime(date);
        reportInfo.setSchema(schema);
        reportInfo.setSchemaEntry(entryInfo);
        reportInfo.setSchemaOrgEntry(orgEntryInfo);
        if (orgID != null) {
            reportInfo.setOrgUnit(orgEntryInfo.getOrgUnit());
        }
        reportInfo.setExecutor(exeUser);
        reportInfo.setGuuID(uuid);
        reportInfo.setSeq(seq);
        IObjectPK reportPK = SCMRobotExecuteAccountFactory.getLocalInstance(ctx).submit((CoreBaseInfo)reportInfo);
        return reportPK.toString();
    }

    public void updateStartSate(Context ctx, String reportId) throws EASBizException, BOSException {
        ISCMRobotExecuteAccount iSCMRobotExecuteAccount = SCMRobotExecuteAccountFactory.getLocalInstance(ctx);
        SCMRobotExecuteAccountInfo reportInfo = iSCMRobotExecuteAccount.getSCMRobotExecuteAccountInfo((IObjectPK)new ObjectUuidPK(reportId));
        reportInfo.setState(SCMRobotSchemaStateEnum.STATE_PROCESS);
        reportInfo.setStartTime(new Date());
        iSCMRobotExecuteAccount.submit((CoreBaseInfo)reportInfo);
    }

    public String updateFinishState(Context ctx, String reportId, String result, int sucessCount, int failureCount) throws EASBizException, BOSException {
        ISCMRobotExecuteAccount iSCMRobotExecuteAccount = SCMRobotExecuteAccountFactory.getLocalInstance(ctx);
        SCMRobotExecuteAccountInfo reportInfo = iSCMRobotExecuteAccount.getSCMRobotExecuteAccountInfo((IObjectPK)new ObjectUuidPK(reportId));
        reportInfo.setState(SCMRobotSchemaStateEnum.STATE_FINISHED);
        reportInfo.setEndTime(new Date());
        reportInfo.setSuccessCount(sucessCount);
        reportInfo.setFailedCount(failureCount);
        if (StringUtils.isEmpty((CharSequence)result)) {
            result = EASResource.getString((String)"com.kingdee.eas.scm.framework.SCMRobotResource", (String)"oprtSucess");
        }
        reportInfo.setResult(result);
        IObjectPK reportPK = iSCMRobotExecuteAccount.submit((CoreBaseInfo)reportInfo);
        return reportPK.toString();
    }

    public String updateFinishStateWithNewTrans(Context ctx, String reportId, String result, int sucessCount, int failureCount) throws EASBizException, BOSException {
        return (String)EJBTransactionProxy.invokeByManual((Object)this, (String)"updateFinishStateBySql", (Class[])new Class[]{Context.class, String.class, String.class, Integer.TYPE, Integer.TYPE}, (Object[])new Object[]{ctx, reportId, result, sucessCount, failureCount}, (int)4);
    }

    public String updateFinishStateBySql(Context ctx, String reportId, String result, int sucessCount, int failureCount) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_SCM_SCMRobotExecuteAccount set fstate = ?,fresult =?,fsuccesscount=?,failedcount=? where fid = ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{2, result, sucessCount, failureCount, reportId});
        return null;
    }
}

