/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.robot.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.server.QueryContext;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.UseStatusEnum;
import com.kingdee.eas.scm.framework.balance.util.BalanceUtil;
import com.kingdee.eas.scm.framework.robot.OperationTypeEnum;
import com.kingdee.eas.scm.framework.robot.SCMRobotException;
import com.kingdee.eas.scm.framework.robot.SCMRobotOperationCollection;
import com.kingdee.eas.scm.framework.robot.SCMRobotOperationFactory;
import com.kingdee.eas.scm.framework.robot.SCMRobotOperationInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaEntryCollection;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaEntryFactory;
import com.kingdee.eas.scm.framework.robot.app.AbstractSCMRobotOperationControllerBean;
import com.kingdee.eas.scm.framework.robot.app.impl.ISCMRobotBillOperationProcessor;
import com.kingdee.eas.scm.framework.robot.app.impl.ISCMRobotBillTransProcessor;
import com.kingdee.eas.scm.framework.robot.app.impl.ISCMRobotOtherOprtProcessor;
import com.kingdee.eas.scm.framework.robot.app.impl.ISCMRobotVoucherOperationProcessor;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SCMRobotOperationControllerBean
extends AbstractSCMRobotOperationControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.framework.robot.app.SCMRobotOperationControllerBean");
    private static final String VOUCHERINTERFACE = "com.kingdee.eas.scm.framework.robot.app.impl.ISCMRobotVoucherOperationProcessor";
    private static final String BILLTRANSRINTERFACE = "com.kingdee.eas.scm.framework.robot.app.impl.ISCMRobotBillTransProcessor";
    private static final String BILLOPRTINTERFACE = "com.kingdee.eas.scm.framework.robot.app.impl.ISCMRobotBillOperationProcessor";
    private static final String OTHEROPRTINTERFACE = "com.kingdee.eas.scm.framework.robot.app.impl.ISCMRobotOtherOprtProcessor";

    @Override
    protected void _enable(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        IPermission permission = PermissionFactory.getRemoteInstance();
        IObjectPK userPk = ctx.getCaller();
        permission.checkFunctionPermission(userPk, null, "scmrobotop_enable");
        SCMRobotOperationInfo scmRobotOperationInfo = SCMRobotOperationFactory.getLocalInstance(ctx).getSCMRobotOperationInfo(id);
        if (scmRobotOperationInfo.getStatus() == UseStatusEnum.ACTIVE) {
            throw new SCMRobotException(SCMRobotException.ENABLEDAREADY);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_SCM_SCMRobotOperation set FStatus = 1 where fid = ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{id.toString()});
    }

    @Override
    protected void _disable(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        IPermission permission = PermissionFactory.getRemoteInstance();
        IObjectPK userPk = ctx.getCaller();
        permission.checkFunctionPermission(userPk, null, "scmrobotop_disable");
        SCMRobotOperationInfo scmRobotOperationInfo = SCMRobotOperationFactory.getLocalInstance(ctx).getSCMRobotOperationInfo(id);
        if (scmRobotOperationInfo.getStatus() == UseStatusEnum.INACTIVE) {
            throw new SCMRobotException(SCMRobotException.OPERATIONDISABLED);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("parent.number"));
        viewInfo.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("operation", (Object)id, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.status", (Object)1, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        SCMRobotSchemaEntryCollection schemaCollection = SCMRobotSchemaEntryFactory.getLocalInstance(ctx).getSCMRobotSchemaEntryCollection(viewInfo);
        if (schemaCollection.size() > 0) {
            HashSet<String> numberSet = new HashSet<String>();
            for (int i = 0; i < schemaCollection.size(); ++i) {
                numberSet.add(schemaCollection.get(i).getParent().getNumber());
            }
            throw new SCMRobotException(SCMRobotException.ISUSEDCANTDISABLE, new String[]{StringUtils.join(numberSet.iterator(), (String)"\uff0c")});
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_SCM_SCMRobotOperation set FStatus = 2 where fid = ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{id.toString()});
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IPermission permission = PermissionFactory.getRemoteInstance();
        IObjectPK userPk = ctx.getCaller();
        permission.checkFunctionPermission(userPk, null, "scmrobotop_delete");
        SCMRobotOperationInfo scmRobotOperationInfo = SCMRobotOperationFactory.getLocalInstance(ctx).getSCMRobotOperationInfo(pk);
        if (UseStatusEnum.SAVED != scmRobotOperationInfo.getStatus()) {
            throw new SCMRobotException(SCMRobotException.NOTSAVE2DELETE);
        }
        if (scmRobotOperationInfo.isIsSystem()) {
            throw new SCMRobotException(SCMRobotException.SYSTEMNODELETE);
        }
        super._delete(ctx, pk);
    }

    public IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SCMRobotOperationInfo info = (SCMRobotOperationInfo)model;
        this.checkBeforeSave(ctx, info);
        return super._save(ctx, model);
    }

    private void checkBeforeSave(Context ctx, SCMRobotOperationInfo info) throws EASBizException, BOSException {
        Object oprtObj;
        String queryInfo = info.getQueryInfo();
        if (queryInfo != null) {
            IMetaDataPK queryPk = MetaDataPKFactory.getMetaDataPK((String)queryInfo);
            QueryExecuteOption option = new QueryExecuteOption();
            QueryContext queryCtx = QueryContext.getInstance((QueryExecuteOption)option);
            try {
                queryCtx.init(ctx, null, queryPk, MetaDataTypeList.BASEQUERY);
            }
            catch (Exception e) {
                throw new SCMRobotException(SCMRobotException.QUERYNOTFIND, new String[]{queryInfo});
            }
        }
        try {
            oprtObj = Class.forName(info.getClassNameFull()).newInstance();
        }
        catch (Exception e) {
            throw new SCMRobotException(SCMRobotException.CLASSNOTFIND, new String[]{info.getClassNameFull()});
        }
        String interFaceName = null;
        if (OperationTypeEnum.voucher == info.getOperationType() && !(oprtObj instanceof ISCMRobotVoucherOperationProcessor)) {
            interFaceName = VOUCHERINTERFACE;
        }
        if (OperationTypeEnum.billTrans == info.getOperationType() && !(oprtObj instanceof ISCMRobotBillTransProcessor)) {
            interFaceName = BILLTRANSRINTERFACE;
        }
        if (OperationTypeEnum.billOperation == info.getOperationType() && !(oprtObj instanceof ISCMRobotBillOperationProcessor)) {
            interFaceName = BILLOPRTINTERFACE;
        }
        if (OperationTypeEnum.otherOperation == info.getOperationType() && !(oprtObj instanceof ISCMRobotOtherOprtProcessor)) {
            interFaceName = OTHEROPRTINTERFACE;
        }
        if (interFaceName != null) {
            throw new SCMRobotException(SCMRobotException.CLASSERROR, new String[]{interFaceName});
        }
        String uniqueKey = this.calUniqueKey(info);
        info.setUniqueKey(uniqueKey);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("uniqueKey", (Object)uniqueKey, CompareType.EQUALS));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        ev.setFilter(filter);
        SCMRobotOperationCollection collection = this.getSCMRobotOperationCollection(ctx, ev);
        if (collection.size() != 0) {
            throw new SCMRobotException(SCMRobotException.DUPLICATEOPERATION);
        }
    }

    private String calUniqueKey(SCMRobotOperationInfo entity) throws BOSException {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("businessNumber", (Object)(StringUtils.isBlank((String)entity.getBusinessNumber()) ? null : entity.getBusinessNumber()));
            jsonObject.put("operationType", entity.getOperationType().getValue());
            jsonObject.put("operationNumber", (Object)(StringUtils.isBlank((String)entity.getOperationNumber()) ? null : entity.getOperationNumber()));
            jsonObject.put("classNameFull", (Object)(StringUtils.isBlank((String)entity.getClassNameFull()) ? null : entity.getClassNameFull()));
            jsonObject.put("orgType", (Object)entity.getOrgType());
            jsonObject.put("hasParam", entity.isHasParam());
            jsonObject.put("desBillBosType", (Object)(StringUtils.isBlank((String)entity.getDesBillBosType()) ? null : entity.getDesBillBosType()));
            jsonObject.put("queryInfo", (Object)(StringUtils.isBlank((String)entity.getQueryInfo()) ? null : entity.getQueryInfo()));
            jsonObject.put("subSystem", (Object)entity.getSubSystem());
            return BalanceUtil.getMd5(jsonObject.toString());
        }
        catch (Exception e) {
            throw new BOSException(e.getCause());
        }
    }
}

