/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.robot.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.app.BOTMappingHelper;
import com.kingdee.bos.metadata.bot.app.BOTRuleFilterTools;
import com.kingdee.bos.metadata.bot.runtime.BotUtil;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.botp.BotpExtConfigHelper;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.base.dap.app.DAPAppTools;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.scm.common.tools.SQLUtils;
import com.kingdee.eas.scm.framework.robot.SCMRobotExecuteAccountFactory;
import com.kingdee.eas.scm.framework.robot.SCMRobotExecuteAccountInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaEntryCollection;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaEntryInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaFactory;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaOrgEntryCollection;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaOrgEntryInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaStateEnum;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SCMRobotServerUtil {
    public static List getSchemaAllTaskInfo(Context ctx, String schemaID) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        int seq = 1;
        if (schemaID == null) {
            return null;
        }
        SCMRobotSchemaInfo schemaInfo = SCMRobotSchemaFactory.getLocalInstance(ctx).getSCMRobotSchemaInfo((IObjectPK)new ObjectUuidPK(schemaID));
        if (schemaInfo != null) {
            SCMRobotSchemaEntryCollection entrys = schemaInfo.getEntry();
            SCMRobotSchemaEntryInfo entry = null;
            SCMRobotSchemaOrgEntryCollection orgEntrys = null;
            SCMRobotSchemaOrgEntryInfo orgEntry = null;
            HashMap<String, Serializable> temp = null;
            int size = entrys.size();
            for (int i = 0; i < size; ++i) {
                entry = entrys.get(i);
                orgEntrys = entry.getOrgEntry();
                int orgSize = orgEntrys.size();
                for (int j = 0; j < orgSize; ++j) {
                    orgEntry = orgEntrys.get(j);
                    temp = new HashMap<String, Serializable>();
                    temp.put("schema", schemaInfo);
                    temp.put("businessEntry", entry);
                    temp.put("companyEntry", orgEntry);
                    temp.put("seq", Integer.valueOf(seq++));
                    result.add(temp);
                }
            }
        }
        return result;
    }

    public static String getFirstReportIDByGuuid(Context ctx, String guuid) throws BOSException, EASBizException, SQLException {
        String reportID = null;
        String sql = " select top 1 fid from T_SCM_SCMRobotExecuteAccount where FGuuID= ? and fstate = 0 order by fseq ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, guuid);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                reportID = rs.getString("fid");
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return reportID;
    }

    public static String record(Context ctx, SCMRobotSchemaInfo schema, SCMRobotSchemaEntryInfo entryInfo, SCMRobotSchemaOrgEntryInfo orgEntryInfo, int status, String result, int sucessCount, int failureCount, UserInfo exeUser, String reportID, String uuid, int seq) throws BOSException, EASBizException {
        SCMRobotExecuteAccountInfo reportInfo = null;
        CoreBaseCollection reportCollection = null;
        String schemaID = schema.getId().toString();
        String businessID = entryInfo.getId().toString();
        String orgID = null;
        if (orgEntryInfo != null && orgEntryInfo.getOrgUnit() != null) {
            orgID = orgEntryInfo.getOrgUnit().getId().toString();
        }
        if (reportID != null) {
            EntityViewInfo evi = SCMRobotServerUtil.getReportEntityViewParam(schemaID, businessID, orgID, reportID);
            reportCollection = SCMRobotExecuteAccountFactory.getLocalInstance(ctx).getCollection(evi);
            if (reportCollection.size() > 0) {
                SCMRobotExecuteAccountInfo info = (SCMRobotExecuteAccountInfo)reportCollection.get(0);
                if (status == 1) {
                    info.setState(SCMRobotSchemaStateEnum.STATE_PROCESS);
                    info.setStartTime(new Date());
                } else if (status == 2) {
                    info.setState(SCMRobotSchemaStateEnum.STATE_FINISHED);
                    info.setEndTime(new Date());
                    if (sucessCount != 0) {
                        info.setSuccessCount(sucessCount);
                    }
                    if (failureCount != 0) {
                        info.setFailedCount(failureCount);
                    }
                    info.setResult(result);
                }
                reportInfo = info;
            } else {
                reportInfo = new SCMRobotExecuteAccountInfo();
                reportInfo.setBusinessName(entryInfo.getOperation().getBussinessName());
                reportInfo.setOperationNumber(entryInfo.getOperation().getOperationNumber());
                reportInfo.setOperationName(entryInfo.getOperation().getOperationName());
                reportInfo.setOperationId(entryInfo.getOperation().getId().toString());
                Date date = new Date();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String strDate = sdf.format(date);
                try {
                    date = sdf.parse(strDate);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
                if (status == 1) {
                    reportInfo.setState(SCMRobotSchemaStateEnum.STATE_PROCESS);
                    reportInfo.setStartTime(new Date());
                } else if (status == 2) {
                    reportInfo.setState(SCMRobotSchemaStateEnum.STATE_FINISHED);
                    reportInfo.setEndTime(new Date());
                }
                reportInfo.setStartTime(date);
                reportInfo.setSchema(schema);
                reportInfo.setSchemaEntry(entryInfo);
                if (orgID != null) {
                    reportInfo.setOrgUnit(orgEntryInfo.getOrgUnit());
                }
                reportInfo.setExecutor(exeUser);
                reportInfo.setGuuID(uuid);
                reportInfo.setSeq(seq);
            }
        } else {
            reportInfo = new SCMRobotExecuteAccountInfo();
            reportInfo.setBusinessName(entryInfo.getOperation().getBussinessName());
            reportInfo.setOperationNumber(entryInfo.getOperation().getOperationNumber());
            reportInfo.setOperationName(entryInfo.getOperation().getOperationName());
            reportInfo.setOperationId(entryInfo.getOperation().getId().toString());
            Date date = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String strDate = sdf.format(date);
            try {
                date = sdf.parse(strDate);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            reportInfo.setState(SCMRobotSchemaStateEnum.STATE_WAITING);
            reportInfo.setStartTime(date);
            reportInfo.setSchema(schema);
            reportInfo.setSchemaEntry(entryInfo);
            if (orgID != null) {
                reportInfo.setOrgUnit(orgEntryInfo.getOrgUnit());
            }
            reportInfo.setExecutor(exeUser);
            reportInfo.setGuuID(uuid);
            reportInfo.setSeq(seq);
        }
        IObjectPK reportPK = null;
        try {
            if (reportInfo != null) {
                reportPK = SCMRobotExecuteAccountFactory.getLocalInstance(ctx).submit((CoreBaseInfo)reportInfo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String rs = null;
        if (null != reportPK) {
            rs = reportPK.toString();
        }
        return rs;
    }

    public static EntityViewInfo getReportEntityViewParam(String schemaID, String businessID, String orgID, String reportID) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("schemaId", (Object)schemaID, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("schemaEntryId", (Object)businessID, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)orgID, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)reportID, CompareType.EQUALS));
        evi.setFilter(fi);
        return evi;
    }

    public static BOTMappingCollection getBotpsByCompanyAndDesType(Context ctx, String companyId, String srcBosType, String desBosType, DefineSysEnum defineSys) throws EASBizException, BOSException {
        String[] orgIDs;
        OrgUnitInfo org = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo("select id, CU.id where id='" + companyId + "'");
        String curCuId = org.getCU().getId().toString();
        if (!BOTPTools.isCtrlUintAuthor((Context)ctx)) {
            orgIDs = new String[]{curCuId, "00000000-0000-0000-0000-000000000000CCE7AED4"};
        } else {
            try {
                CtrlUnitInfo orgCu = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo("select id,longNumber where id ='" + curCuId + "'");
                String orglongNumber = orgCu.getLongNumber().toString();
                String[] orgNumbers = orglongNumber.split("!");
                orgIDs = new String[orgNumbers.length];
                HashSet<String> orgNumset = new HashSet<String>();
                orgNumset.addAll(Arrays.asList(orgNumbers));
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("number", orgNumset, CompareType.INCLUDE));
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
                entityViewInfo.setFilter(filterInfo);
                SorterItemCollection sorts = new SorterItemCollection();
                SorterItemInfo sortInfo = new SorterItemInfo("longnumber");
                sortInfo.setSortType(SortType.DESCEND);
                sorts.add(sortInfo);
                entityViewInfo.setSorter(sorts);
                CtrlUnitCollection cucol = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitCollection(entityViewInfo);
                for (int i = 0; i < orgIDs.length; ++i) {
                    if (cucol.get(i) == null || cucol.get(i).getId() == null) continue;
                    orgIDs[i] = cucol.get(i).getId().toString();
                }
            }
            catch (EASBizException e) {
                throw new BOSException(e.getMessage());
            }
        }
        BOTMappingCollection retBotMappingCols = new BOTMappingCollection();
        BOTMappingCollection botMappingCols = null;
        for (int i = 0; i < orgIDs.length; ++i) {
            botMappingCols = BOTMappingHelper.getMappingForSelectByCU((Context)ctx, (String)srcBosType, (String)desBosType, (DefineSysEnum)defineSys, (String)orgIDs[i]);
            if (botMappingCols == null || botMappingCols.size() <= 0) continue;
            for (int j = 0; j < botMappingCols.size(); ++j) {
                botMappingCols.get(j).put("dapLevel", (Object)(i + 1));
                retBotMappingCols.add(botMappingCols.get(j));
            }
        }
        return retBotMappingCols;
    }

    public static CoreBillBaseCollection filterByRule(Context ctx, BOSObjectType bosType, String[] srcBillIDs, BOTMappingInfo mappingInfo) throws BOSException {
        int iTotal = srcBillIDs.length;
        int iStep = 800;
        int iMax = iTotal % iStep == 0 ? iTotal / iStep : iTotal / iStep + 1;
        boolean bAllEmptyViewFilter = true;
        CoreBillBaseCollection realObjectCols = null;
        EntityViewInfo view = BOTRuleFilterTools.getBOTRuleFilterByMapping((BOTMappingInfo)mappingInfo);
        boolean hasEntryFilter = false;
        if (view.getEntryFilters() != null && view.getEntryFilters().size() > 0) {
            hasEntryFilter = true;
        }
        for (int i = 0; i < iMax; ++i) {
            int iTempTotal = iStep;
            if (i == iMax - 1 && iMax * iStep != iTotal) {
                iTempTotal = iTotal % iStep;
            }
            int iStart = i * iStep;
            String[] newIDs = new String[iTempTotal];
            for (int j = 0; j < iTempTotal; ++j) {
                newIDs[j] = srcBillIDs[iStart + j];
            }
            EntityViewInfo stepView = BOTRuleFilterTools.getRuleFilter((String[])newIDs, (BOTMappingInfo)mappingInfo);
            if (stepView == null) continue;
            bAllEmptyViewFilter = false;
            CoreBillBaseCollection filteredCols = SCMRobotServerUtil.getBillCollection(ctx, bosType.toString(), stepView);
            if (filteredCols == null || filteredCols.size() <= 0) continue;
            if (realObjectCols == null) {
                realObjectCols = filteredCols;
                continue;
            }
            realObjectCols.addObjectCollection((IObjectCollection)filteredCols);
        }
        if (bAllEmptyViewFilter) {
            HashSet<String> s = new HashSet<String>();
            int size = srcBillIDs.length;
            for (int i = 0; i < size; ++i) {
                s.add(srcBillIDs[i]);
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", s, CompareType.INCLUDE));
            evi.setFilter(fi);
            realObjectCols = SCMRobotServerUtil.getBillCollection(ctx, bosType.toString(), evi);
        }
        if (realObjectCols == null || realObjectCols.size() == 0) {
            return null;
        }
        if (hasEntryFilter) {
            int n = view.getEntryFilters().size();
            for (int j = 0; j < n; ++j) {
                String entryName = view.getEntryFilters().get(j).getEntryName();
                for (int i = realObjectCols.size() - 1; i >= 0; --i) {
                    IObjectValue filteredInfo = realObjectCols.getObject(i);
                    Object objColl = filteredInfo.get(entryName);
                    if (objColl != null && objColl instanceof IObjectCollection && ((IObjectCollection)objColl).size() > 0) continue;
                    realObjectCols.removeObject(i);
                }
            }
        }
        DAPAppTools.execDataFilterMultiEntry((Context)ctx, realObjectCols, (BOTMappingInfo)mappingInfo);
        return realObjectCols;
    }

    public static CoreBillBaseCollection getBillCollection(Context ctx, String billType, EntityViewInfo evi) throws BOSException {
        BOSObjectType bosType = BOSObjectType.create((String)billType);
        ICoreBillBase bizCtrl = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
        CoreBillBaseCollection sourceBillCollection = null;
        try {
            sourceBillCollection = bizCtrl.getCoreBillBaseCollection(evi);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return sourceBillCollection;
    }

    public static Set getIdSetByRuleFilter(Context ctx, String bosType, Set billIds, BOTMappingInfo botMappingInfo) throws BOSException {
        if (BOTRuleFilterTools.isShowBOTPWithRuleFilter((Context)ctx) && BOTRuleFilterTools.isExistBOTRuleFilter((BOTMappingInfo)botMappingInfo)) {
            BOSObjectType type = BOSObjectType.create((String)bosType);
            CoreBillBaseCollection billCol = SCMRobotServerUtil.filterByRule(ctx, type, billIds.toArray(new String[0]), botMappingInfo);
            if (billCol == null) {
                return billIds;
            }
            HashSet<String> idSet = new HashSet<String>();
            int size = billCol.size();
            for (int i = 0; i < size; ++i) {
                idSet.add(billCol.get(i).getId().toString());
            }
            return idSet;
        }
        return billIds;
    }

    public static SelectorItemCollection getBOTPSelectors(BOTMappingInfo mappingInfo) throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        if (mappingInfo == null) {
            return sic;
        }
        List autoSelectors = new ArrayList();
        ArrayList<String> sysSelectors = new ArrayList<String>();
        ArrayList<String> userSelectors = new ArrayList<String>();
        HashSet<String> goodSelectors = new HashSet<String>();
        BotpExtConfigHelper.ExtConfigInfo info = mappingInfo.getExtConfigInfo();
        autoSelectors = BotUtil.getSrcBillPropList((BOTMappingInfo)mappingInfo);
        if (info != null) {
            String selectorsString = info.getSelectors();
            String userSelectorsString = info.getUserSelectors();
            if (selectorsString == null || selectorsString.equals("")) {
                Collections.sort(autoSelectors);
                if (autoSelectors != null && autoSelectors.size() > 0) {
                    for (int i = 0; i < autoSelectors.size(); ++i) {
                        sic.add(autoSelectors.get(i).toString());
                    }
                }
                return sic;
            }
            String[] selectorsArray = selectorsString.split(",");
            for (int j = 0; j < selectorsArray.length; ++j) {
                sysSelectors.add(selectorsArray[j]);
            }
            if (userSelectorsString != null && !userSelectorsString.equals("")) {
                String[] userSelectorsArray = userSelectorsString.split(",");
                for (int j = 0; j < userSelectorsArray.length; ++j) {
                    userSelectors.add(userSelectorsArray[j]);
                }
            }
            goodSelectors.addAll(sysSelectors);
            goodSelectors.addAll(userSelectors);
            goodSelectors.addAll(autoSelectors);
            for (String property : goodSelectors) {
                sic.add(property);
            }
        } else {
            Collections.sort(autoSelectors);
            if (autoSelectors != null && autoSelectors.size() > 0) {
                for (int i = 0; i < autoSelectors.size(); ++i) {
                    sic.add(autoSelectors.get(i).toString());
                }
            }
            return sic;
        }
        return sic;
    }

    public static List getSelectEntryIDs(CoreBillBaseCollection srcBills, String entryName) {
        ArrayList<String> entryids = new ArrayList<String>();
        if (StringUtils.isEmpty((String)entryName)) {
            return entryids;
        }
        for (int i = 0; i < srcBills.size(); ++i) {
            CoreBillBaseInfo bills = srcBills.get(i);
            IObjectCollection entries = (IObjectCollection)bills.get(entryName);
            if (entries == null) {
                return entryids;
            }
            for (CoreBaseInfo cInfo : entries) {
                String ss = cInfo.getId().toString();
                entryids.add(ss);
            }
        }
        return entryids;
    }
}

