/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.robot.app.executor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotDetailStateEnum;
import com.kingdee.eas.scm.framework.robot.SCMRobotExecuteAccountInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotOperationInfo;
import com.kingdee.eas.scm.framework.robot.app.SCMRobotExecuteDetailRecoder;
import com.kingdee.eas.scm.framework.robot.app.SCMRobotServerUtil;
import com.kingdee.eas.scm.framework.robot.app.executor.AbstractSCMRobotExecutor;
import com.kingdee.eas.scm.framework.robot.app.executor.SCMRobotTask;
import com.kingdee.eas.scm.framework.robot.app.impl.ISCMRobotBillOperationProcessor;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SCMRobotBillOprtExecutor
extends AbstractSCMRobotExecutor {
    @Override
    public Map excute(Context ctx, SCMRobotTask task) throws EASBizException, BOSException {
        ISCMRobotBillOperationProcessor newInstance;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set operationBillSet = this.getOperationBillSet(ctx, task);
        if (operationBillSet == null || operationBillSet.size() <= 0) {
            String errorString = EASResource.getString((String)"com.kingdee.eas.scm.framework.SCMRobotResource", (String)"noBillOprt");
            result.put("errorString", errorString);
            return result;
        }
        SCMRobotOperationInfo operation = task.getOperation();
        String className = operation.getClassNameFull();
        try {
            newInstance = (ISCMRobotBillOperationProcessor)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        SCMRobotExecuteDetailRecoder reroder = new SCMRobotExecuteDetailRecoder();
        CoreBillBaseCollection billColl = this.getBillColl(ctx, operationBillSet, operation.getBillBosType());
        SCMRobotExecuteAccountInfo reportInfo = task.getReportInfo();
        CoreBillBaseInfo billInfo = null;
        String resultInfo = null;
        SCMRobotDetailStateEnum state = null;
        int successCount = 0;
        int failCount = 0;
        Map detailResult = null;
        HashMap<String, String> params = new HashMap<String, String>();
        int size = billColl.size();
        for (int i = 0; i < size; ++i) {
            billInfo = billColl.get(i);
            String billId = billInfo.getId().toString();
            params.put("billID", billId);
            detailResult = this.processBill(ctx, newInstance, params);
            if (detailResult.get("error") != null && !StringUtils.isEmpty((String)((String)detailResult.get("error")))) {
                resultInfo = (String)detailResult.get("error");
                state = SCMRobotDetailStateEnum.FAIL;
                ++failCount;
            } else {
                resultInfo = EASResource.getString((String)"com.kingdee.eas.scm.framework.SCMRobotResource", (String)"oprtSucess");
                state = SCMRobotDetailStateEnum.SUCCESS;
                ++successCount;
            }
            reroder.addOneDetailReport(ctx, billInfo.getNumber(), resultInfo, state, reportInfo);
        }
        result.put("successCount", successCount);
        result.put("failCount", failCount);
        return result;
    }

    CoreBillBaseCollection getBillColl(Context ctx, Set idSet, String bosType) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("id"));
        sics.add(new SelectorItemInfo("number"));
        view.setSelector(sics);
        return SCMRobotServerUtil.getBillCollection(ctx, bosType, view);
    }

    private Map processBill(Context ctx, ISCMRobotBillOperationProcessor implInstance, Map params) {
        Map<String, String> detailResult = new HashMap<String, String>();
        try {
            detailResult = (Map)EJBTransactionProxy.invokeByManual((Object)implInstance, (String)"process", (Class[])new Class[]{Context.class, Map.class}, (Object[])new Object[]{ctx, params}, (int)3);
        }
        catch (Exception e) {
            detailResult.put("error", e.getMessage());
        }
        return detailResult;
    }

    @Override
    public String getBillFilter(Context ctx, OrgUnitInfo orgInfo, PeriodInfo periodInfo, String className) throws BOSException {
        String billIDFilter = "";
        try {
            billIDFilter = ((ISCMRobotBillOperationProcessor)Class.forName(className).newInstance()).getBillFilter(ctx, orgInfo, periodInfo);
        }
        catch (Exception e) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.scm.framework.SCMRobotResource", (String)"SCMRobot_GetFilter_Error", (Object[])new Object[]{className}), (Throwable)e);
        }
        return billIDFilter;
    }
}

