/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.robot.app.executor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.botp.util.MappingCache;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotDetailStateEnum;
import com.kingdee.eas.scm.framework.robot.SCMRobotException;
import com.kingdee.eas.scm.framework.robot.SCMRobotExecuteAccountInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotOperationInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaEntryInfo;
import com.kingdee.eas.scm.framework.robot.app.SCMRobotExecuteDetailRecoder;
import com.kingdee.eas.scm.framework.robot.app.SCMRobotServerUtil;
import com.kingdee.eas.scm.framework.robot.app.executor.AbstractSCMRobotExecutor;
import com.kingdee.eas.scm.framework.robot.app.executor.SCMRobotTask;
import com.kingdee.eas.scm.framework.robot.app.impl.ISCMRobotBillTransProcessor;
import com.kingdee.eas.scm.framework.util.CommonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class SCMRobotBillTransExecutor
extends AbstractSCMRobotExecutor {
    @Override
    public Map excute(Context ctx, SCMRobotTask task) throws EASBizException, BOSException {
        Set operationBillList = this.getOperationBillSet(ctx, task);
        Map result = this.process(ctx, task, operationBillList);
        return result;
    }

    public Map process(Context ctx, SCMRobotTask task, Set billIdSet) throws BOSException, EASBizException {
        Map<String, String> result = new HashMap<String, String>();
        String errorString = null;
        if (billIdSet == null || billIdSet.size() <= 0) {
            errorString = EASResource.getString((String)"com.kingdee.eas.scm.framework.SCMRobotResource", (String)"notBillToTrans", (Locale)ctx.getOriginLocale());
            result.put("errorString", errorString);
            return result;
        }
        String companyID = task.getCompanyId();
        SCMRobotSchemaEntryInfo entryInfo = task.getEntryInfo();
        SCMRobotOperationInfo operation = task.getOperation();
        String srcBosType = operation.getBillBosType();
        String desBosType = operation.getDesBillBosType();
        SCMRobotExecuteAccountInfo reportInfo = task.getReportInfo();
        BOTMappingCollection botpCol = SCMRobotServerUtil.getBotpsByCompanyAndDesType(ctx, companyID, srcBosType, desBosType, DefineSysEnum.BTP);
        String botpIDs = entryInfo.getBotp();
        HashSet<String> idSet = new HashSet<String>();
        BOTMappingCollection selectBotCol = new BOTMappingCollection();
        if (botpIDs != null) {
            idSet.addAll(Arrays.asList(botpIDs.split(",")));
        }
        int size = botpCol.size();
        for (int i = 0; i < size; ++i) {
            if (!idSet.contains(botpCol.get(i).getId().toString())) continue;
            selectBotCol.add(botpCol.get(i));
        }
        Map detailResultMap = null;
        SCMRobotExecuteDetailRecoder detailReport = new SCMRobotExecuteDetailRecoder();
        if (selectBotCol == null || selectBotCol.size() == 0) {
            detailReport.addBatchNullRuleDetailReport(ctx, billIdSet, reportInfo);
        } else if (selectBotCol.size() == 1) {
            BOTMappingInfo botMappingInfo = selectBotCol.get(0);
            Set filterBillIdSet = SCMRobotServerUtil.getIdSetByRuleFilter(ctx, srcBosType, billIdSet, botMappingInfo);
            if (filterBillIdSet == null || filterBillIdSet.size() <= 0) {
                errorString = EASResource.getString((String)"com.kingdee.eas.scm.framework.SCMRobotResource", (String)"notBillToTrans", (Locale)ctx.getOriginLocale());
                result.put("errorString", errorString);
                return result;
            }
            List splitIdList = this.getSplitidList(ctx, srcBosType, filterBillIdSet, desBosType, botpIDs);
            ObjectUuidPK rulePk = new ObjectUuidPK(botMappingInfo.getId());
            BOSObjectType srcType = BOSObjectType.create((String)srcBosType);
            BOSObjectType desType = BOSObjectType.create((String)desBosType);
            HashSet<IObjectPK> splitSet = null;
            int size2 = splitIdList.size();
            for (int i = 0; i < size2; ++i) {
                IObjectPK[] srcBillPks = (IObjectPK[])splitIdList.get(i);
                detailResultMap = this.transBillWithnewTrans(ctx, srcType, desType, srcBillPks, (IObjectPK)rulePk);
                splitSet = new HashSet<IObjectPK>();
                splitSet.addAll(Arrays.asList(srcBillPks));
                this.doRecord(ctx, detailResultMap, splitSet, reportInfo);
            }
        }
        result = this.getProcessResultCount(ctx, reportInfo.getId().toString());
        return result;
    }

    public void doRecord(Context ctx, Map result, Set splitSet, SCMRobotExecuteAccountInfo reportInfo) throws EASBizException, BOSException {
        SCMRobotExecuteDetailRecoder detailReport = new SCMRobotExecuteDetailRecoder();
        SCMRobotDetailStateEnum state = (SCMRobotDetailStateEnum)((Object)result.get("state"));
        if (state == SCMRobotDetailStateEnum.SUCCESS) {
            Map infoMap = (Map)result.get("infoMap");
            detailReport.addBatchSucessDetailReport(ctx, splitSet, infoMap, reportInfo);
        } else {
            String errorStr = (String)result.get("error");
            detailReport.addBatchFailDetailReport(ctx, splitSet, errorStr, reportInfo);
        }
    }

    public Map transBillWithnewTrans(Context ctx, BOSObjectType srcbosType, BOSObjectType desbosType, IObjectPK[] srcBillPks, IObjectPK rulePk) throws EASBizException, BOSException {
        return (Map)EJBTransactionProxy.invokeByManual((Object)this, (String)"doTransForm", (Class[])new Class[]{Context.class, BOSObjectType.class, BOSObjectType.class, IObjectPK[].class, IObjectPK.class}, (Object[])new Object[]{ctx, srcbosType, desbosType, srcBillPks, rulePk}, (int)3);
    }

    public Map doTransForm(Context ctx, BOSObjectType bosType, BOSObjectType desBosType, IObjectPK[] srcBillPks, IObjectPK rulePk) throws BOSException {
        IBOTMapping iBOTMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
        BTPTransformResult btpResult = null;
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            ArrayList<String> srcIdList = new ArrayList<String>();
            for (int i = 0; i < srcBillPks.length; ++i) {
                if (srcBillPks[i] == null) continue;
                srcIdList.add(srcBillPks[i].toString());
            }
            String[] idArr = srcIdList.toArray(new String[0]);
            boolean isReBuild = this.checkRebuild(ctx, srcIdList, null, rulePk.toString());
            if (!isReBuild) {
                throw new SCMRobotException(SCMRobotException.BILLHASBUILDED);
            }
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EntityObjectInfo entity = loader.getEntity(bosType);
            String[] entrieNames = new String[]{CommonUtils.getBillEntryPropertyName(entity)};
            CoreBillBaseCollection srcBillCollection = iBOTMapping.getNewBillCollectionByType(bosType.toString(), idArr, entrieNames, new ArrayList(), null);
            List entriesKeys = SCMRobotServerUtil.getSelectEntryIDs(srcBillCollection, entrieNames[0]);
            IBTPManager btp = BTPManagerFactory.getLocalInstance((Context)ctx);
            BOTMappingInfo mappingInfo = MappingCache.getInstance((Context)ctx).getMappingInfo(rulePk, ctx);
            if (1 != mappingInfo.getIsTempSave()) {
                result.put("state", (Object)SCMRobotDetailStateEnum.FAIL);
                result.put("error", EASResource.getString((String)"com.kingdee.eas.scm.framework.SCMRobotResource", (String)"ruleNotSave"));
                return result;
            }
            btpResult = BTPManagerFactory.getLocalInstance((Context)ctx).transformForBotp(idArr, entrieNames, entriesKeys, SCMRobotServerUtil.getBOTPSelectors(mappingInfo), desBosType.toString(), rulePk, mappingInfo.getSrcEntityName());
            IObjectCollection destBills = btpResult.getBills();
            BOTRelationCollection relationCollection = btpResult.getBOTRelationCollection();
            BOTRelationInfo botRelationInfo = null;
            CoreBillBaseInfo billInfo = null;
            HashMap<String, String> billNumMap = new HashMap<String, String>();
            int size = destBills.size();
            for (int i = 0; i < size; ++i) {
                billInfo = (CoreBillBaseInfo)destBills.getObject(i);
                billNumMap.put(billInfo.getId().toString(), billInfo.getNumber());
            }
            HashMap billMap = new HashMap();
            int size2 = relationCollection.size();
            for (int i = 0; i < size2; ++i) {
                botRelationInfo = relationCollection.get(i);
                billMap.put(botRelationInfo.getSrcObjectID(), billNumMap.get(botRelationInfo.getDestObjectID()));
            }
            result.put("state", (Object)SCMRobotDetailStateEnum.SUCCESS);
            result.put("infoMap", billMap);
        }
        catch (Exception e) {
            String failMsg = "";
            if (e instanceof BOSException && e.getCause() != null) {
                failMsg = e.getCause().getMessage();
                if (failMsg == null) {
                    failMsg = e.getMessage() == null ? EASResource.getString((String)"com.kingdee.eas.scm.framework.SCMRobotResource", (String)"unhnownErr") : e.getMessage();
                }
            } else {
                failMsg = e.getMessage();
            }
            if (failMsg != null && failMsg.length() > 1000) {
                failMsg = failMsg.substring(0, 990) + "...";
            }
            result.put("state", (Object)SCMRobotDetailStateEnum.FAIL);
            result.put("error", failMsg);
        }
        return result;
    }

    @Override
    public String getBillFilter(Context ctx, OrgUnitInfo orgInfo, PeriodInfo periodInfo, String className) throws BOSException {
        String billIDFilter = "";
        try {
            billIDFilter = ((ISCMRobotBillTransProcessor)Class.forName(className).newInstance()).getSouceBillFilter(ctx, orgInfo, periodInfo);
        }
        catch (Exception e) {
            throw new BOSException(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.framework.SCMRobotResource", (String)"SCMRobot_GetFilter_Error", (Object[])new Object[]{className}), (Throwable)e);
        }
        return billIDFilter;
    }
}

