/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.robot.app.executor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.botp.BotpHelper;
import com.kingdee.eas.base.botp.util.MappingCache;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.dap.DAPTransformerFactory;
import com.kingdee.eas.base.dap.DAPVoucherTypeEnum;
import com.kingdee.eas.base.dap.IDAPTransformer;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.pca.PcVoucherCollection;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.robot.OperationTypeEnum;
import com.kingdee.eas.scm.framework.robot.SCMRobotDetailStateEnum;
import com.kingdee.eas.scm.framework.robot.SCMRobotException;
import com.kingdee.eas.scm.framework.robot.SCMRobotExecuteAccountInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotOperationInfo;
import com.kingdee.eas.scm.framework.robot.SCMRobotSchemaEntryInfo;
import com.kingdee.eas.scm.framework.robot.app.SCMRobotExecuteDetailRecoder;
import com.kingdee.eas.scm.framework.robot.app.SCMRobotServerUtil;
import com.kingdee.eas.scm.framework.robot.app.executor.AbstractSCMRobotExecutor;
import com.kingdee.eas.scm.framework.robot.app.executor.SCMRobotTask;
import com.kingdee.eas.scm.framework.robot.app.impl.AbstractSCMRobotVoucherProcessor;
import com.kingdee.eas.scm.framework.robot.app.impl.ISCMRobotVoucherOperationProcessor;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SCMRobotVoucherExecutor
extends AbstractSCMRobotExecutor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.framework.robot.app.executor.SCMRobotVoucherExecutor");

    @Override
    public Map excute(Context ctx, SCMRobotTask task) throws EASBizException, BOSException {
        int result = this.checkIsSystemConstractGL(ctx, task);
        Map<String, Boolean> geneVoucherMap = new HashMap<String, String>();
        if (result == 0) {
            Set voucherBillSet = this.getOperationBillSet(ctx, task);
            geneVoucherMap = this.processVoucher(ctx, task, voucherBillSet);
        } else {
            String msg = result == 1 ? SCMUtils.getResource((String)"com.kingdee.eas.scm.framework.SCMRobotResource", (String)"SubSystemNotConstractGL", (Context)ctx) : SCMUtils.getResource((String)"com.kingdee.eas.scm.framework.SCMRobotResource", (String)"GLIsNotStar", (Context)ctx);
            geneVoucherMap.put("errorString", (Boolean)((Object)msg));
            geneVoucherMap.put("isError", true);
        }
        return geneVoucherMap;
    }

    private int checkIsSystemConstractGL(Context ctx, SCMRobotTask task) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company;
        SystemEnum subSystem = task.getOperation().getSubSystem();
        if (subSystem != SystemEnum.ACCOUNTSRECEIVABLE && subSystem != SystemEnum.ACCOUNTSPAYABLE) {
            subSystem = SystemEnum.INVENTORYMANAGEMENT;
        }
        if (task.getOperation().getOrgType() != OrgType.Company) {
            IOrgUnitRelation iRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            String orgUnitID = task.getOrgEntryInfo().getOrgUnit().getId().toString();
            OrgUnitCollection orgCol = iRelation.getToUnit(orgUnitID, task.getOperation().getOrgType().getValue(), 1);
            String compantID = null;
            if (orgCol != null && orgCol.size() > 0) {
                compantID = orgCol.get(0).getId().toString();
            }
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(compantID));
        } else {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(task.getOrgEntryInfo().getOrgUnit().getId().toString()));
        }
        boolean isConsGL = SystemStatusCtrolUtils.isRelAccount((Context)ctx, (SystemEnum)subSystem, (CompanyOrgUnitInfo)company);
        if (!isConsGL) {
            return 1;
        }
        boolean isGLStart = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
        if (!isGLStart) {
            return 2;
        }
        return 0;
    }

    private Map processVoucher(Context ctx, SCMRobotTask task, Set billIds) throws EASBizException, BOSException {
        SCMRobotSchemaEntryInfo entryInfo = task.getEntryInfo();
        SCMRobotOperationInfo operation = task.getOperation();
        String className = operation.getClassNameFull();
        String reportID = task.getReportId();
        SCMRobotExecuteAccountInfo reportInfo = task.getReportInfo();
        String companyID = task.getCompanyId();
        String bosType = operation.getBillBosType();
        String errorString = null;
        boolean isError = false;
        HashMap result = new HashMap();
        if (billIds == null || billIds.size() <= 0) {
            errorString = EASResource.getString((String)"com.kingdee.eas.scm.framework.SCMRobotResource", (String)"noBillToVoucher", (Locale)ctx.getOriginLocale());
        } else {
            String botpId = entryInfo.getBotp();
            try {
                Map resultMap;
                ISCMRobotVoucherOperationProcessor voucherIntstance = (ISCMRobotVoucherOperationProcessor)Class.forName(className).newInstance();
                if (voucherIntstance != null && voucherIntstance instanceof AbstractSCMRobotVoucherProcessor) {
                    ((AbstractSCMRobotVoucherProcessor)voucherIntstance).dealBeforeGenVoucher(ctx, billIds);
                }
                OperationTypeEnum operationType = operation.getOperationType();
                String destType = "";
                if (operationType == OperationTypeEnum.voucher) {
                    destType = "GL";
                }
                if (operationType == OperationTypeEnum.pcVoucher) {
                    destType = "PCA";
                }
                if ((resultMap = this.doVoucher(ctx, companyID, bosType, billIds, botpId, reportInfo, destType)).get("errorString") != null) {
                    result.put("errorString", resultMap.get("errorString"));
                }
                if (voucherIntstance != null && voucherIntstance instanceof AbstractSCMRobotVoucherProcessor) {
                    ((AbstractSCMRobotVoucherProcessor)voucherIntstance).dealEndGenVoucher(ctx, billIds);
                }
            }
            catch (Exception e) {
                errorString = e.getMessage();
                isError = true;
            }
            Map processResult = this.getProcessResultCount(ctx, reportID);
            result.putAll(processResult);
        }
        if (!StringUtils.isEmpty((String)errorString)) {
            result.put("errorString", errorString);
        }
        result.put("isError", isError);
        return result;
    }

    protected Map doVoucher(Context ctx, String companyId, String bosType, Set billIds, String botpRuleId, SCMRobotExecuteAccountInfo reportInfo, String desType) throws BOSException, EASBizException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String desBosType = "2652E01E";
        DefineSysEnum sysEnum = DefineSysEnum.DAP;
        if (desType != null && desType.equals("PCA")) {
            desBosType = "D6952559";
            sysEnum = DefineSysEnum.DAPPC;
        }
        BOTMappingCollection dapRulesSelected = SCMRobotServerUtil.getBotpsByCompanyAndDesType(ctx, companyId, bosType, desBosType, sysEnum);
        BOTMappingInfo botMappingInfo = null;
        if (!StringUtils.isEmpty((String)botpRuleId)) {
            for (int j = 0; j < dapRulesSelected.size(); ++j) {
                if (!dapRulesSelected.get(j).getId().toString().equals(botpRuleId)) continue;
                botMappingInfo = dapRulesSelected.get(j);
                break;
            }
        }
        SCMRobotExecuteDetailRecoder detailRecoder = new SCMRobotExecuteDetailRecoder();
        if (botMappingInfo == null) {
            logger.error((Object)"\u751f\u6210\u51ed\u8bc1\uff0c\u83b7\u53d6\u5230\u7684dap\u89c4\u5219\u4e3a\u7a7a\uff0c\u8bb0\u5f55\u65e0dap\u89c4\u5219\u65e5\u5fd7");
            detailRecoder.addBatchNullRuleDetailReport(ctx, billIds, reportInfo);
        } else {
            Set idSet = SCMRobotServerUtil.getIdSetByRuleFilter(ctx, bosType, billIds, botMappingInfo);
            if (idSet == null || idSet.size() <= 0) {
                resultMap.put("errorString", EASResource.getString((String)"com.kingdee.eas.scm.framework.SCMRobotResource", (String)"notBillToTrans", (Locale)ctx.getOriginLocale()));
                return resultMap;
            }
            int size = idSet.size();
            Object[] srcBillPks = new IObjectPK[size];
            Iterator iterator = idSet.iterator();
            for (int i = 0; i < size; ++i) {
                String id = (String)iterator.next();
                srcBillPks[i] = new ObjectUuidPK(id);
            }
            BOSObjectType billBosType = BOSObjectType.create((String)bosType);
            ObjectUuidPK rulePk = new ObjectUuidPK(botpRuleId);
            SCMRobotExecuteDetailRecoder detailReport = new SCMRobotExecuteDetailRecoder();
            HashSet splitSet = new HashSet();
            splitSet.addAll(Arrays.asList((Object[])srcBillPks));
            Map result = this.generateVoucherWithnewTrans(ctx, billBosType, (IObjectPK[])srcBillPks, (IObjectPK)rulePk, desType);
            SCMRobotDetailStateEnum state = (SCMRobotDetailStateEnum)((Object)result.get("state"));
            if (state == SCMRobotDetailStateEnum.SUCCESS) {
                Map infoMap = (Map)result.get("infoMap");
                detailReport.addBatchSucessDetailReport(ctx, splitSet, infoMap, reportInfo);
            } else {
                String errorStr = (String)result.get("error");
                detailReport.addBatchFailDetailReport(ctx, splitSet, errorStr, reportInfo);
            }
        }
        return resultMap;
    }

    public Map generateVoucherWithnewTrans(Context ctx, BOSObjectType bosType, IObjectPK[] srcBillPks, IObjectPK rulePk, String desType) throws BOSException {
        if ("GL".equals(desType)) {
            return (Map)EJBTransactionProxy.invokeByManual((Object)this, (String)"generateGLVoucher", (Class[])new Class[]{Context.class, BOSObjectType.class, IObjectPK[].class, IObjectPK.class}, (Object[])new Object[]{ctx, bosType, srcBillPks, rulePk}, (int)3);
        }
        if ("PCA".equals(desType)) {
            return (Map)EJBTransactionProxy.invokeByManual((Object)this, (String)"generatePCAVoucher", (Class[])new Class[]{Context.class, BOSObjectType.class, IObjectPK[].class, IObjectPK.class}, (Object[])new Object[]{ctx, bosType, srcBillPks, rulePk}, (int)3);
        }
        return null;
    }

    public Map generateGLVoucher(Context ctx, BOSObjectType bosType, IObjectPK[] srcBillPks, IObjectPK rulePk) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            List idList = Arrays.asList((Object[])srcBillPks);
            boolean isReBuild = this.checkRebuild(ctx, idList, null, rulePk.toString());
            if (!isReBuild) {
                throw new SCMRobotException(SCMRobotException.BILLHASBUILDED);
            }
            BOTMappingInfo mappingInfo = MappingCache.getInstance((Context)ctx).getMappingInfo(rulePk, ctx);
            SelectorItemCollection botpSelector = BotpHelper.getBOTPSelectors((BOTMappingInfo)mappingInfo);
            ICoreBillBase bizCtrl = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
            DAPTransformResult result = bizCtrl.generateVoucher(srcBillPks, rulePk, botpSelector);
            VoucherCollection voucherCol = (VoucherCollection)result.getVoucherCollection();
            BOTRelationCollection relationCollection = result.getRelationCollection();
            BOTRelationInfo botRelationInfo = null;
            VoucherInfo voucherInfo = null;
            HashMap<String, String> voucherMap = new HashMap<String, String>();
            int size = voucherCol.size();
            for (int i = 0; i < size; ++i) {
                voucherInfo = voucherCol.get(i);
                voucherMap.put(voucherInfo.getId().toString(), voucherInfo.getNumber());
            }
            HashMap billMap = new HashMap();
            int size2 = relationCollection.size();
            for (int i = 0; i < size2; ++i) {
                botRelationInfo = relationCollection.get(i);
                billMap.put(botRelationInfo.getSrcObjectID(), voucherMap.get(botRelationInfo.getDestObjectID()));
            }
            resultMap.put("state", (Object)SCMRobotDetailStateEnum.SUCCESS);
            resultMap.put("infoMap", billMap);
        }
        catch (Exception e) {
            resultMap.put("state", (Object)SCMRobotDetailStateEnum.FAIL);
            HashSet<List> idSet = new HashSet<List>();
            idSet.add(Arrays.asList((Object[])srcBillPks));
            resultMap.put("idSet", idSet);
            String failMsg = null;
            if (e instanceof BOSException && e.getCause() != null) {
                failMsg = e.getCause().getMessage();
                if (failMsg == null) {
                    failMsg = e.getMessage() == null ? EASResource.getString((String)"com.kingdee.eas.scm.framework.SCMRobotResource", (String)"unhnownErr") : e.getMessage();
                }
            } else {
                failMsg = e.getMessage();
            }
            if (failMsg.length() > 1000) {
                failMsg = failMsg.substring(0, 990) + "...";
            }
            resultMap.put("error", failMsg);
        }
        return resultMap;
    }

    public Map generatePCAVoucher(Context ctx, BOSObjectType bosType, IObjectPK[] srcBillPks, IObjectPK rulePk) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            List idList = Arrays.asList((Object[])srcBillPks);
            boolean isReBuild = this.checkRebuild(ctx, idList, null, rulePk.toString());
            if (!isReBuild) {
                throw new SCMRobotException(SCMRobotException.BILLHASBUILDED);
            }
            BOTMappingInfo mappingInfo = MappingCache.getInstance((Context)ctx).getMappingInfo(rulePk, ctx);
            SelectorItemCollection botpSelector = BotpHelper.getBOTPSelectors((BOTMappingInfo)mappingInfo);
            ICoreBillBase bizCtrl = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            HashSet idSet = new HashSet();
            idSet.addAll(idList);
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            view.setSelector(botpSelector);
            CoreBillBaseCollection sourceBillCollection = bizCtrl.getCoreBillBaseCollection(view);
            IDAPTransformer wrapper = DAPTransformerFactory.getLocalInstance((Context)ctx);
            DAPTransformResult result = wrapper.transform(sourceBillCollection, DAPVoucherTypeEnum.PCVoucher, rulePk);
            PcVoucherCollection voucherCol = (PcVoucherCollection)result.getVoucherCollection();
            BOTRelationCollection relationCollection = result.getRelationCollection();
            BOTRelationInfo botRelationInfo = null;
            PcVoucherInfo voucherInfo = null;
            HashMap<String, String> voucherMap = new HashMap<String, String>();
            int size = voucherCol.size();
            for (int i = 0; i < size; ++i) {
                voucherInfo = voucherCol.get(i);
                voucherMap.put(voucherInfo.getId().toString(), voucherInfo.getNumber());
            }
            HashMap billMap = new HashMap();
            int size2 = relationCollection.size();
            for (int i = 0; i < size2; ++i) {
                botRelationInfo = relationCollection.get(i);
                billMap.put(botRelationInfo.getSrcObjectID(), voucherMap.get(botRelationInfo.getDestObjectID()));
            }
            resultMap.put("state", (Object)SCMRobotDetailStateEnum.SUCCESS);
            resultMap.put("infoMap", billMap);
        }
        catch (Exception e) {
            resultMap.put("state", (Object)SCMRobotDetailStateEnum.FAIL);
            HashSet<List> idSet = new HashSet<List>();
            idSet.add(Arrays.asList((Object[])srcBillPks));
            resultMap.put("idSet", idSet);
            String failMsg = null;
            if (e instanceof BOSException && e.getCause() != null) {
                failMsg = e.getCause().getMessage();
                if (failMsg == null) {
                    failMsg = e.getMessage() == null ? EASResource.getString((String)"com.kingdee.eas.scm.framework.SCMRobotResource", (String)"unhnownErr") : e.getMessage();
                }
            } else {
                failMsg = e.getMessage();
            }
            if (failMsg.length() > 1000) {
                failMsg = failMsg.substring(0, 990) + "...";
            }
            resultMap.put("error", failMsg);
        }
        return resultMap;
    }

    @Override
    public String getBillFilter(Context ctx, OrgUnitInfo orgInfo, PeriodInfo periodInfo, String className) throws BOSException {
        String billIDFilter = null;
        try {
            billIDFilter = ((ISCMRobotVoucherOperationProcessor)Class.forName(className).newInstance()).getVoucheredBillFilter(ctx, orgInfo, periodInfo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return billIDFilter;
    }
}

