/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.robot.app.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.scm.framework.robot.app.impl.ISCMRobotBillOperationProcessor;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;

public abstract class SCMRobotBillOprtImpl
implements ISCMRobotBillOperationProcessor {
    @Override
    public String getBillFilter(Context ctx, OrgUnitInfo orgInfo, PeriodInfo periodInfo) throws Exception {
        String tableAlis = this.getBillTableAlis();
        String entryTableAlis = this.getBillEntryTableAlis();
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct {0}.fid from ").append(this.getBillTableName()).append(" {0} \n");
        sql.append(" left  join ").append(this.getBillEntryTableName()).append(" {1} on {0}.fid = {1}.fparentid \n");
        sql.append(" where {0}.").append(this.getMainBizOrgField());
        sql.append(" = ''").append(orgInfo.getId().toString()).append("'' \n");
        Boolean isBack = (Boolean)ctx.get((Object)"isBack");
        if (isBack == null || !isBack.booleanValue()) {
            if (this.usePeriodNumber()) {
                sql.append(" and {0}.fyear = ").append(periodInfo.getPeriodYear()).append(" \n");
                sql.append(" and {0}.fperiod = ").append(periodInfo.getPeriodNumber()).append(" \n");
            } else {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                String beginDate = dateFormat.format(periodInfo.getBeginDate());
                String endDate = dateFormat.format(periodInfo.getEndDate());
                sql.append(" and {0}.fbizdate >= to_date(''").append(beginDate).append("'') \n");
                sql.append(" and {0}.fbizdate <= to_date(''").append(endDate).append("'') \n");
            }
        }
        if (!StringUtils.isEmpty((String)this.getExtendFilter())) {
            sql.append(" and ").append(this.getExtendFilter());
        }
        return MessageFormat.format(sql.toString(), tableAlis, entryTableAlis);
    }

    public String getBillTableAlis() {
        return "bill";
    }

    public String getBillEntryTableAlis() {
        return "entry";
    }

    public boolean usePeriodNumber() {
        return true;
    }

    public abstract String getExtendFilter();

    public abstract String getBillEntryTableName();

    public abstract String getMainBizOrgField();

    public abstract String getBillTableName();
}

