/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.secure.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MathRandom {
    private static final String DEFAULT_ALGORITHM = "SHA1PRNG";
    private static Map<String, SecureRandom> instanceMap = new ConcurrentHashMap<String, SecureRandom>();

    private MathRandom() {
    }

    public static synchronized SecureRandom initSecureRandom(String algorithm) {
        SecureRandom secureRandom = null;
        try {
            secureRandom = SecureRandom.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            secureRandom = new SecureRandom();
        }
        return secureRandom;
    }

    public static final boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static double nextDouble() {
        return MathRandom.nextDouble(DEFAULT_ALGORITHM);
    }

    public static double nextDouble(String algorithm) {
        SecureRandom secureRandom = instanceMap.get(algorithm);
        if (null == secureRandom) {
            secureRandom = MathRandom.initSecureRandom(algorithm);
            instanceMap.put(algorithm, secureRandom);
        }
        return secureRandom.nextDouble();
    }

    public static long nextLong() {
        return MathRandom.nextLong(DEFAULT_ALGORITHM);
    }

    public static long nextLong(String algorithm) {
        SecureRandom secureRandom = instanceMap.get(algorithm);
        if (null == secureRandom) {
            secureRandom = MathRandom.initSecureRandom(algorithm);
            instanceMap.put(algorithm, secureRandom);
        }
        return secureRandom.nextLong();
    }
}

