/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.solutionmgr.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.ServerEnvironment;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.scm.framework.solutionmgr.ExportSolutionMgrCollection;
import com.kingdee.eas.scm.framework.solutionmgr.ExportSolutionMgrException;
import com.kingdee.eas.scm.framework.solutionmgr.ExportSolutionMgrFactory;
import com.kingdee.eas.scm.framework.solutionmgr.ExportSolutionMgrInfo;
import com.kingdee.eas.scm.framework.solutionmgr.ExportSolutionSubTabCollection;
import com.kingdee.eas.scm.framework.solutionmgr.ExportSolutionSubTabInfo;
import com.kingdee.eas.scm.framework.solutionmgr.JoinTypeEnum;
import com.kingdee.eas.scm.framework.solutionmgr.app.AbstractSolutionMgrFacadeControllerBean;
import com.kingdee.eas.scm.framework.solutionmgr.tools.KSQDataExport;
import com.kingdee.eas.scm.framework.solutionmgr.tools.SolutionMgrConditionInfo;
import com.kingdee.eas.scm.framework.util.RSAUtil;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SolutionMgrFacadeControllerBean
extends AbstractSolutionMgrFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.framework.solutionmgr.app.SolutionMgrFacadeControllerBean");
    private static final String CHAR_SEPERATOR = ";";

    @Override
    protected List _exportData(Context ctx, IObjectCollection solutionInfoConn, Map conditionMap) throws BOSException, EASBizException {
        ExportSolutionMgrCollection infoConn = (ExportSolutionMgrCollection)solutionInfoConn;
        if (infoConn == null || infoConn.size() < 1) {
            return null;
        }
        String tempFilePath = ServerEnvironment.getInstanceConfigPath() + File.separator + "tempsql_imp.ksql";
        File tempFile = new File(tempFilePath);
        if (tempFile.exists()) {
            tempFile.delete();
        }
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile, true), "utf-8"));
            out.newLine();
            out.write(this.getResName("waring_str"));
            out.flush();
            ExportSolutionMgrInfo info = null;
            String strWhere = null;
            for (int i = 0; i < infoConn.size(); ++i) {
                info = infoConn.get(i);
                out.newLine();
                out.write(this.getResName("expSolution_name_number") + info.getName() + "(" + info.getNumber() + ")," + this.getResName("sqlInfo_str"));
                out.newLine();
                out.newLine();
                out.write("--SchemaNumber:" + info.getNumber());
                out.flush();
                strWhere = (String)conditionMap.get(info.getNumber());
                this.innerExportData(ctx, info, strWhere, out);
            }
            List<byte[]> list = RSAUtil.encryptFileOS(RSAUtil.publicKey, tempFile, this._checkIfEncrypt(ctx));
            return list;
        }
        catch (UnsupportedEncodingException e) {
            throw new BOSException(e.getMessage());
        }
        catch (FileNotFoundException e) {
            throw new BOSException(e.getMessage());
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        catch (IOException e) {
            throw new BOSException(e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                    tempFile.delete();
                }
                catch (IOException e) {
                    throw new BOSException(e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _checkIfEncrypt(Context ctx) {
        boolean encrypt = true;
        String filePath = ServerEnvironment.getInstanceConfigPath() + File.separator + "expEncrypt.txt";
        File myFile = new File(filePath);
        if (!myFile.exists()) {
            return true;
        }
        String tempFilePath = ServerEnvironment.getInstanceConfigPath() + File.separator + "tempTxt.txt";
        File tempFile = new File(tempFilePath);
        if (tempFile.exists()) {
            tempFile.delete();
        }
        RSAUtil.decryptFile(RSAUtil.privateKey, myFile, tempFile);
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(tempFile));
            String str = null;
            while ((str = in.readLine()) != null) {
                if (StringUtil.isEmpty((String)str) || str.indexOf("encrypt=false") <= -1) continue;
                encrypt = false;
                break;
            }
        }
        catch (IOException e) {
            logger.info((Object)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (tempFile != null && tempFile.exists()) {
                    tempFile.delete();
                }
            }
            catch (IOException e) {
                logger.info((Object)e);
            }
        }
        return encrypt;
    }

    private void innerExportData(Context ctx, ExportSolutionMgrInfo info, String strWhere, BufferedWriter out) throws BOSException, SQLException {
        StringBuffer selectSql = new StringBuffer();
        String mainTable = info.getMainTable();
        selectSql.append("select ").append(mainTable).append(".* from ");
        selectSql.append(info.getMainTable()).append(" AS ").append(mainTable);
        this.writeMainTableRecordId(ctx, selectSql.toString(), strWhere, out);
        this.genInsertData(ctx, selectSql.toString(), mainTable, strWhere, out);
        String subTableName = null;
        String joinType = null;
        String relationStr = null;
        String joinRelationStr = null;
        String associalMainTable = null;
        ExportSolutionSubTabInfo subTableInfo = null;
        HashMap<String, String> joinRelationMap = new HashMap<String, String>();
        StringBuffer subTabSelectSql = new StringBuffer();
        ExportSolutionSubTabCollection subTableConn = info.getSolutionSubTab();
        for (int i = 0; i < subTableConn.size(); ++i) {
            subTabSelectSql.setLength(0);
            subTableInfo = subTableConn.get(i);
            subTableName = subTableInfo.getSubTable();
            associalMainTable = subTableInfo.getAssocialTable();
            joinType = subTableInfo.getJoinType().getName();
            relationStr = subTableInfo.getRelationStr();
            joinRelationStr = this.formatRelationStr(joinType, relationStr, subTableName);
            joinRelationMap.put(subTableName, joinRelationStr);
            subTabSelectSql.append(" select ").append(subTableName).append(".* from ");
            subTabSelectSql.append(mainTable).append(" AS ").append(mainTable).append(" \r\n ");
            if (associalMainTable.equals(mainTable)) {
                subTabSelectSql.append(joinRelationStr);
            } else {
                subTabSelectSql.append((String)joinRelationMap.get(associalMainTable)).append(" \r\n ");
                subTabSelectSql.append(joinRelationStr);
                joinRelationMap.put(subTableName, (String)joinRelationMap.get(associalMainTable) + joinRelationStr);
            }
            this.genInsertData(ctx, subTabSelectSql.toString(), subTableName, strWhere, out);
        }
    }

    private void writeMainTableRecordId(Context ctx, String selectSql, String tableWhere, BufferedWriter out) throws BOSException {
        StringBuffer selectSQL = new StringBuffer(selectSql);
        if (!StringUtil.isEmpty((String)tableWhere)) {
            selectSQL.append(tableWhere);
        }
        StringBuffer idStr = new StringBuffer();
        IRowSet rs = KsqlUtil.executeQuery((Context)ctx, (String)selectSQL.toString());
        try {
            while (rs.next()) {
                if (idStr.length() > 0) {
                    idStr.append(",");
                }
                idStr.append("'").append(rs.getString("FID")).append("'");
            }
            out.newLine();
            out.write("--MainTableId:[" + idStr.toString() + "]");
            out.newLine();
            out.flush();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String formatRelationStr(String joinType, String relationStr, String subTable) {
        StringBuffer joinRelationBuff = new StringBuffer();
        String joinTypeStr = null;
        joinTypeStr = joinType.equals(JoinTypeEnum.RIGHT_JOIN.getName()) ? " RIGHT OUTER JOIN " : (joinType.equals(JoinTypeEnum.LEFT_JOIN.getName()) ? " LEFT OUTER JOIN " : " INNER JOIN ");
        joinRelationBuff.append(joinTypeStr).append(subTable);
        joinRelationBuff.append(" AS ").append(subTable).append(" \r\n ");
        joinRelationBuff.append(" ON ").append(relationStr).append(" \r\n ");
        return joinRelationBuff.toString();
    }

    @Override
    protected void _importData(Context ctx, String schemaNumber, List resourceDataList, int importType) throws BOSException, EASBizException {
        if (resourceDataList == null || resourceDataList.size() == 0) {
            return;
        }
        for (int i = 0; i < resourceDataList.size(); ++i) {
            this.importOneResource(ctx, schemaNumber, (byte[])resourceDataList.get(i), importType);
        }
    }

    private void importOneResource(Context ctx, String schemaNumber, byte[] data, int importType) throws BOSException, EASBizException {
        File tempFile = null;
        FileOutputStream fos = null;
        String tempFilePath = ServerEnvironment.getInstanceConfigPath() + File.separator + "tempsql.ksql";
        try {
            fos = new FileOutputStream(tempFilePath);
            fos.write(data);
            fos.flush();
            tempFile = new File(tempFilePath);
            this.executeImport(ctx, tempFile, schemaNumber, importType);
        }
        catch (FileNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.delete();
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
    }

    @Override
    protected Object[] _getColunmsByTable(Context ctx, String tableName) throws BOSException {
        SolutionMgrConditionInfo[] conditionInfoArray = null;
        if (!StringUtil.isEmpty((String)tableName)) {
            StringBuffer sql = new StringBuffer("select KSQL_COL_NAME, KSQL_COL_TYPE from KSQL_USERCOLUMNS where  KSQL_COL_TABNAME = '");
            sql.append(tableName).append("'").append(" and KSQL_COL_TYPE !='sysname'");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            int size = rowSet.size();
            conditionInfoArray = new SolutionMgrConditionInfo[size];
            SolutionMgrConditionInfo conditionInfo = null;
            try {
                String fieldStr = null;
                String fieldType = null;
                int i = 0;
                while (rowSet.next()) {
                    fieldStr = rowSet.getString("KSQL_COL_NAME");
                    fieldType = rowSet.getString("KSQL_COL_TYPE");
                    conditionInfoArray[i] = conditionInfo = new SolutionMgrConditionInfo(fieldStr, fieldType);
                    ++i;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return conditionInfoArray;
    }

    private void executeImport(Context ctx, File myFile, String inSchemaNumber, int importType) throws BOSException, EASBizException {
        if (!myFile.exists()) {
            return;
        }
        String tempFilePath = ServerEnvironment.getInstanceConfigPath() + File.separator + "tempsql_imp.ksql";
        File newFile = new File(tempFilePath);
        if (newFile.exists()) {
            newFile.delete();
        }
        RSAUtil.decryptFile(RSAUtil.privateKey, myFile, newFile);
        StringBuffer tempBuf = new StringBuffer();
        BufferedReader in = null;
        String str = null;
        String schemaNumber = null;
        String mainTableId = null;
        ArrayList<String> schemaNumberList = new ArrayList<String>();
        ArrayList<String> mainTableIdList = new ArrayList<String>();
        try {
            in = new BufferedReader(new FileReader(newFile));
            while ((str = in.readLine()) != null) {
                if (str.length() == 0) continue;
                if (!str.startsWith("--")) {
                    tempBuf.append(str);
                    continue;
                }
                if (str.startsWith("--SchemaNumber:")) {
                    schemaNumberList.add(str.substring("--SchemaNumber:".length()));
                    continue;
                }
                if (!str.startsWith("--MainTableId:")) continue;
                mainTableIdList.add(str.substring("--MainTableId:".length()));
            }
            if (schemaNumberList.size() > 0) {
                schemaNumber = (String)schemaNumberList.get(0);
            }
            if (!"ALL_SCHEMA".equals(inSchemaNumber) && !inSchemaNumber.equals(schemaNumber)) {
                throw new ExportSolutionMgrException(ExportSolutionMgrException.IMPDATANOTVALID);
            }
            if (1 == importType) {
                for (int i = 0; i < schemaNumberList.size(); ++i) {
                    schemaNumber = (String)schemaNumberList.get(i);
                    mainTableId = (String)mainTableIdList.get(i);
                    String oql = "select *, solutionSubTab.* where number = '" + schemaNumber + "'";
                    ExportSolutionMgrInfo info = ExportSolutionMgrFactory.getLocalInstance(ctx).getExportSolutionMgrInfo(oql);
                    if (info == null) {
                        throw new ExportSolutionMgrException(ExportSolutionMgrException.EXPSCHEMANOTEXIST);
                    }
                    mainTableId = mainTableId.replace("[", "(").replace("]", ")");
                    this.deleteOldData(ctx, info, mainTableId);
                }
            }
            FMIsqlFacadeFactory.getLocalInstance((Context)ctx).executeSql(tempBuf.toString());
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (newFile.exists()) {
                    newFile.delete();
                }
            }
            catch (IOException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void deleteOldData(Context ctx, ExportSolutionMgrInfo info, String mainTableId) throws BOSException, EASBizException {
        String subTableName = null;
        String mainTable = info.getMainTable();
        String joinType = null;
        String relationStr = null;
        String joinRelationStr = null;
        String associalMainTable = null;
        ExportSolutionSubTabInfo subTableInfo = null;
        HashMap<String, String> joinRelationMap = new HashMap<String, String>();
        StringBuffer subTabSelectSql = new StringBuffer();
        ExportSolutionSubTabCollection subTableConn = info.getSolutionSubTab();
        for (int i = 0; i < subTableConn.size(); ++i) {
            subTableInfo = subTableConn.get(i);
            subTableName = subTableInfo.getSubTable();
            associalMainTable = subTableInfo.getAssocialTable();
            joinType = subTableInfo.getJoinType().getName();
            relationStr = subTableInfo.getRelationStr();
            joinRelationStr = this.formatRelationStr(joinType, relationStr, subTableName);
            joinRelationMap.put(subTableName, joinRelationStr);
            subTabSelectSql.append("Delete from ").append(subTableName).append(" Where FID IN (");
            subTabSelectSql.append(" select ").append(subTableName).append(".FID from ");
            subTabSelectSql.append(mainTable).append(" AS ").append(mainTable).append(" \r\n ");
            if (associalMainTable.equals(mainTable)) {
                subTabSelectSql.append(joinRelationStr);
            } else {
                subTabSelectSql.append((String)joinRelationMap.get(associalMainTable)).append(" \r\n ");
                subTabSelectSql.append(joinRelationStr);
                joinRelationMap.put(subTableName, (String)joinRelationMap.get(associalMainTable) + joinRelationStr);
            }
            subTabSelectSql.append(" Where ").append(mainTable).append(".FID IN ").append(mainTableId);
            subTabSelectSql.append(");");
        }
        StringBuffer deleteSQL = new StringBuffer();
        if (subTabSelectSql.length() > 0) {
            String[] sqlArray = subTabSelectSql.toString().split(CHAR_SEPERATOR);
            for (int i = sqlArray.length - 1; i >= 0; --i) {
                deleteSQL.append(sqlArray[i]).append(CHAR_SEPERATOR);
            }
        }
        deleteSQL.append("Delete from ").append(info.getMainTable());
        deleteSQL.append(" Where FID IN ").append(mainTableId).append(CHAR_SEPERATOR);
        KsqlUtil.execute((Context)ctx, (String[])deleteSQL.toString().split(CHAR_SEPERATOR));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void genInsertData(Context ctx, String selectSql, String tableName, String tableWhere, BufferedWriter out) throws BOSException, SQLException {
        String sqlForClounm = " select top 1 * from " + tableName;
        StringBuffer selectSqlBuf = new StringBuffer();
        if (null != selectSql) {
            selectSqlBuf.append(selectSql);
        } else {
            selectSqlBuf.append(" select * from ").append(tableName);
        }
        StringBuffer conditionBuff = new StringBuffer(" if not exists (select 1 from ");
        conditionBuff.append(tableName).append(" where fid ='");
        String fidValue = null;
        if (!StringUtil.isEmpty((String)tableWhere)) {
            selectSqlBuf.append(tableWhere);
        }
        StringBuffer insertSqlBuff = null;
        Connection conn = null;
        ResultSet result = null;
        Statement statement = null;
        Statement statement1 = null;
        ResultSetMetaData restmd1 = null;
        int incidx = -1;
        try {
            out.newLine();
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            statement1 = conn.createStatement();
            result = statement.executeQuery(selectSqlBuf.toString());
            restmd1 = statement1.executeQuery(sqlForClounm).getMetaData();
            int numberOfColumns = restmd1.getColumnCount();
            for (int i = 1; i <= numberOfColumns; ++i) {
                if (!restmd1.isAutoIncrement(i)) continue;
                incidx = i;
            }
            int iAllRow = 0;
            String colunms = this.getColunmFields(numberOfColumns, incidx, restmd1);
            String filedValues = null;
            while (result.next()) {
                String conditionStr = null;
                fidValue = result.getString("FID");
                if (StringUtil.isEmpty((String)fidValue)) continue;
                conditionStr = conditionBuff.toString() + fidValue + "') ";
                ++iAllRow;
                out.newLine();
                insertSqlBuff = new StringBuffer(" insert into ").append(tableName);
                insertSqlBuff.append("(");
                insertSqlBuff.append(colunms).append(") values (");
                filedValues = this.getColunmValues(conn, tableName, result, restmd1, numberOfColumns, incidx);
                insertSqlBuff.append(filedValues).append(")").append(CHAR_SEPERATOR);
                out.write(conditionStr);
                out.flush();
                out.newLine();
                out.write(insertSqlBuff.toString());
                out.flush();
                out.newLine();
                out.flush();
            }
            out.flush();
            out.newLine();
            out.flush();
            if (iAllRow > 0) {
                out.write("--" + tableName + ":RowCount=" + iAllRow + CHAR_SEPERATOR);
                out.flush();
                out.newLine();
                out.flush();
            }
        }
        catch (IOException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (SQLException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                KsqlUtil.cleanup(statement1);
                KsqlUtil.cleanup(result, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        KsqlUtil.cleanup((Statement)statement1);
        KsqlUtil.cleanup((ResultSet)result, (Statement)statement, (Connection)conn);
    }

    private String getColunmFields(int numberOfColumns, int incidx, ResultSetMetaData restmd) throws SQLException {
        StringBuffer colunmFieldBuff = new StringBuffer("");
        for (int i = 1; i <= numberOfColumns; ++i) {
            if (i == incidx) continue;
            if (i > 1 && i - 1 != incidx) {
                colunmFieldBuff.append(",");
            }
            colunmFieldBuff.append(restmd.getColumnName(i));
        }
        return colunmFieldBuff.toString();
    }

    private String getColunmValues(Connection con, String tableName, ResultSet result, ResultSetMetaData restmd, int numberOfColumns, int incidx) throws SQLException, BOSException {
        StringBuffer valuesBuff = new StringBuffer();
        String value = null;
        for (int i = 1; i <= numberOfColumns; ++i) {
            if (i == incidx) continue;
            if (i > 1 && i - 1 != incidx) {
                valuesBuff.append(",");
            }
            if ((value = KSQDataExport.dealData(result, restmd, i)) == null) {
                value = "null";
            } else {
                int isNullable = restmd.isNullable(i);
                if (value.equals("null") && isNullable == 0) {
                    value = this.getDefaultValue(con, tableName, restmd, i);
                }
            }
            valuesBuff.append(value);
        }
        return valuesBuff.toString();
    }

    private String getDefaultValue(Connection con, String tableName, ResultSetMetaData restmd, int colunmIndx) throws SQLException, BOSException {
        String defalutValue = null;
        int dbType = KSqlUtil.getDbType((Connection)con);
        String fieldName = restmd.getColumnName(colunmIndx);
        defalutValue = 2 == dbType ? this.getDefaultValueForOracle(con, tableName, fieldName) : (3 == dbType ? this.getDefaultValueForMsSqlServer(con, tableName, fieldName) : this.getDefaultValueForKSQL(con, tableName, fieldName));
        return defalutValue;
    }

    private String getDefaultValueForOracle(Connection con, String tableName, String fieldName) throws SQLException, BOSException {
        String defaultValue = null;
        StringBuffer sql = new StringBuffer("select KSQL_COL_DEFAULT from KSQL_USERCOLUMNS where  KSQL_COL_TABNAME =?");
        sql.append(" and  KSQL_COL_NAME =? ");
        Object[] paramValue = new Object[]{tableName, fieldName};
        IRowSet result = this.executeQuery(con, sql.toString(), paramValue);
        if (result.next()) {
            defaultValue = result.getString("KSQL_COL_DEFAULT");
        }
        return defaultValue;
    }

    private String getDefaultValueForMsSqlServer(Connection con, String tableName, String fieldName) throws SQLException, BOSException {
        String defaultValue = null;
        StringBuffer sql = new StringBuffer("select m.text as DEFAULTVALUE from KSQL_USERCOLUMNS ");
        sql.append(" left join syscomments m on KSQL_COL_DEFAULT=m.id  ");
        sql.append(" where  KSQL_COL_TABNAME =? and  KSQL_COL_NAME =? ");
        Object[] paramValue = new Object[]{tableName, fieldName};
        IRowSet result = this.executeQuery(con, sql.toString(), paramValue);
        if (result.next() && !StringUtil.isEmpty((String)(defaultValue = result.getString("DEFAULTVALUE")))) {
            defaultValue = defaultValue.substring(2, defaultValue.length() - 2);
        }
        return defaultValue;
    }

    private String getDefaultValueForKSQL(Connection con, String tableName, String fieldName) throws SQLException, BOSException {
        String defaultValue = null;
        StringBuffer sql = new StringBuffer("select KSQL_COL_DEFAULT from KSQL_USERCOLUMNS where  KSQL_COL_TABNAME =?");
        sql.append(" and  KSQL_COL_NAME =? ");
        Object[] paramValue = new Object[]{tableName, fieldName};
        IRowSet result = this.executeQuery(con, sql.toString(), paramValue);
        if (result.next()) {
            defaultValue = result.getString("KSQL_COL_DEFAULT");
        }
        return defaultValue;
    }

    private IRowSet executeQuery(Connection conn, String sql, Object[] params) throws BOSException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            return rowset;
        }
        catch (SQLException exc) {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < params.length; ++i) {
                sb.append("param ").append(i).append(" is:").append(params[i]);
            }
            logger.error((Object)("sql is:" + sql + " param is:" + sb.toString()));
            logger.error((Object)"sql error!", (Throwable)exc);
            throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
        }
    }

    private String getResName(String resKey) {
        return EASCommonResource.getString((String)"com.kingdee.eas.scm.framework.solutionmgr.ExpSolutionMgrResource", (String)resKey, (Locale)this.getLocale());
    }

    private Locale getLocale() {
        try {
            return SysContext.getSysContext().getLocale();
        }
        catch (Throwable e) {
            logger.error((Object)("Get Locale fail!" + e.getMessage()));
            return new Locale("L2");
        }
    }
}

