/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.solutionmgr.tools;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class KSQDataExport {
    private static final DateFormat FORMAT_TIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String dealData(ResultSet resut, ResultSetMetaData restmd, int colunmIdx) throws SQLException {
        String value = "";
        int typeCode = restmd.getColumnType(colunmIdx);
        switch (typeCode) {
            case 3: {
                value = KSQDataExport.getDataKsqlData(resut, colunmIdx, "double");
                break;
            }
            case 4: {
                value = KSQDataExport.getDataKsqlData(resut, colunmIdx, "int");
                break;
            }
            case 5: {
                value = KSQDataExport.getDataKsqlData(resut, colunmIdx, "int");
                break;
            }
            case 6: {
                value = KSQDataExport.getDataKsqlData(resut, colunmIdx, "float");
                break;
            }
            case -6: {
                value = KSQDataExport.getDataKsqlData(resut, colunmIdx, "int");
                break;
            }
            case 7: {
                value = KSQDataExport.getDataKsqlData(resut, colunmIdx, "double");
                break;
            }
            case -7: {
                value = KSQDataExport.getDataKsqlData(resut, colunmIdx, "int");
                break;
            }
            case 8: {
                value = KSQDataExport.getDataKsqlData(resut, colunmIdx, "double");
                break;
            }
            case 93: {
                value = KSQDataExport.getDataKsqlData(resut, colunmIdx, "datetime");
                break;
            }
            case -2: {
                value = KSQDataExport.getDataKsqlData(resut, colunmIdx, "timestamp");
                break;
            }
            case 92: {
                value = KSQDataExport.getDataKsqlData(resut, colunmIdx, "timestamp");
                break;
            }
            case 12: {
                value = KSQDataExport.getDataKsqlData(resut, colunmIdx, "string");
                break;
            }
            case 1: {
                value = KSQDataExport.getDataKsqlData(resut, colunmIdx, "string");
                break;
            }
            case 2: {
                value = KSQDataExport.getDataKsqlData(resut, colunmIdx, "int");
                break;
            }
            case 91: {
                value = KSQDataExport.getDataKsqlData(resut, colunmIdx, "date");
                break;
            }
            case -1: {
                value = KSQDataExport.getDataKsqlData(resut, colunmIdx, "string");
                break;
            }
            case 2005: {
                value = KSQDataExport.getDataKsqlData(resut, colunmIdx, "string");
                break;
            }
            case 2004: {
                value = null;
                break;
            }
            case -9: {
                value = KSQDataExport.getDataKsqlData(resut, colunmIdx, "string");
                break;
            }
            default: {
                value = KSQDataExport.getDataKsqlData(resut, colunmIdx, "string");
            }
        }
        return value;
    }

    private static String getDataKsqlData(ResultSet resut, int colunmIdx, String colunmType) throws SQLException {
        String value = "";
        if (colunmType == "int") {
            value = value + resut.getInt(colunmIdx);
        }
        if (colunmType == "float") {
            value = resut.wasNull() ? value + "null" : value + resut.getFloat(colunmIdx);
        }
        if (colunmType == "double") {
            value = resut.wasNull() ? value + "null" : value + resut.getDouble(colunmIdx);
        }
        if (colunmType == "string") {
            String tempStr = resut.getString(colunmIdx);
            if (tempStr == null) {
                value = value + "null";
            } else {
                if (KSQDataExport.isIncludeChinese(tempStr)) {
                    value = value + "N";
                }
                value = value + "'" + KSQDataExport.getString(KSQDataExport.parseString(tempStr)) + "'";
            }
        }
        if (colunmType == "datetime") {
            Timestamp tmpdate = resut.getTimestamp(colunmIdx);
            value = tmpdate == null ? value + "null" : value + "{ts'" + FORMAT_TIME.format(tmpdate) + "'}";
        }
        return value;
    }

    private static boolean isIncludeChinese(String str) {
        boolean isIncludeChinese = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if ('\u4e00' >= c || c >= '\u9fbb') continue;
            isIncludeChinese = true;
            break;
        }
        return isIncludeChinese;
    }

    private static String parseString(String str) {
        if (str == null) {
            return "";
        }
        int len = 0;
        String tmp = "";
        len = str.length();
        for (int i = 0; i < len; ++i) {
            tmp = String.valueOf(str.charAt(i)).equals("'") ? tmp + "''" : tmp + str.charAt(i);
        }
        return tmp;
    }

    private static String getString(String str) {
        if (str == null) {
            return "null";
        }
        return str;
    }
}

