/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout.hierarchical.stage;

import com.mxgraph.layout.hierarchical.model.mxGraphAbstractHierarchyCell;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyModel;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyRank;
import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.layout.hierarchical.stage.mxHierarchicalLayoutStage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class mxMedianHybridCrossingReduction
implements mxHierarchicalLayoutStage {
    protected mxHierarchicalLayout layout;
    protected int maxIterations = 24;
    protected mxGraphAbstractHierarchyCell[][] nestedBestRanks = null;
    protected int currentBestCrossings = 0;
    protected int iterationsWithoutImprovement = 0;
    protected int maxNoImprovementIterations = 2;

    public mxMedianHybridCrossingReduction(mxHierarchicalLayout layout) {
        this.layout = layout;
    }

    @Override
    public void execute(Object parent) {
        int i;
        int i2;
        mxGraphHierarchyModel model = this.layout.getModel();
        this.nestedBestRanks = new mxGraphAbstractHierarchyCell[model.ranks.size()][];
        for (i2 = 0; i2 < this.nestedBestRanks.length; ++i2) {
            mxGraphHierarchyRank rank = model.ranks.get(new Integer(i2));
            this.nestedBestRanks[i2] = new mxGraphAbstractHierarchyCell[rank.size()];
            rank.toArray(this.nestedBestRanks[i2]);
        }
        this.iterationsWithoutImprovement = 0;
        this.currentBestCrossings = this.calculateCrossings(model);
        for (i2 = 0; i2 < this.maxIterations && this.iterationsWithoutImprovement < this.maxNoImprovementIterations; ++i2) {
            mxGraphAbstractHierarchyCell cell;
            int k;
            Iterator iter;
            mxGraphHierarchyRank rank;
            int j;
            this.weightedMedian(i2, model);
            this.transpose(i2, model);
            int candidateCrossings = this.calculateCrossings(model);
            if (candidateCrossings < this.currentBestCrossings) {
                this.currentBestCrossings = candidateCrossings;
                this.iterationsWithoutImprovement = 0;
                for (j = 0; j < this.nestedBestRanks.length; ++j) {
                    rank = model.ranks.get(new Integer(j));
                    iter = rank.iterator();
                    for (k = 0; k < rank.size(); ++k) {
                        this.nestedBestRanks[j][cell.getGeneralPurposeVariable((int)j)] = cell = (mxGraphAbstractHierarchyCell)iter.next();
                    }
                }
            } else {
                ++this.iterationsWithoutImprovement;
                for (j = 0; j < this.nestedBestRanks.length; ++j) {
                    rank = model.ranks.get(new Integer(j));
                    iter = rank.iterator();
                    for (k = 0; k < rank.size(); ++k) {
                        cell = (mxGraphAbstractHierarchyCell)iter.next();
                        cell.setGeneralPurposeVariable(j, k);
                    }
                }
            }
            if (this.currentBestCrossings == 0) break;
        }
        LinkedHashMap<Integer, mxGraphHierarchyRank> ranks = new LinkedHashMap<Integer, mxGraphHierarchyRank>(model.maxRank + 1);
        mxGraphHierarchyRank[] rankList = new mxGraphHierarchyRank[model.maxRank + 1];
        for (i = 0; i < model.maxRank + 1; ++i) {
            rankList[i] = new mxGraphHierarchyRank();
            ranks.put(new Integer(i), rankList[i]);
        }
        for (i = 0; i < this.nestedBestRanks.length; ++i) {
            for (int j = 0; j < this.nestedBestRanks[i].length; ++j) {
                rankList[i].add(this.nestedBestRanks[i][j]);
            }
        }
        model.ranks = ranks;
    }

    private int calculateCrossings(mxGraphHierarchyModel model) {
        int numRanks = model.ranks.size();
        int totalCrossings = 0;
        for (int i = 1; i < numRanks; ++i) {
            totalCrossings += this.calculateRankCrossing(i, model);
        }
        return totalCrossings;
    }

    protected int calculateRankCrossing(int i, mxGraphHierarchyModel model) {
        int totalCrossings = 0;
        mxGraphHierarchyRank rank = model.ranks.get(new Integer(i));
        mxGraphHierarchyRank previousRank = model.ranks.get(new Integer(i - 1));
        int currentRankSize = rank.size();
        int previousRankSize = previousRank.size();
        int[][] connections = new int[currentRankSize][previousRankSize];
        for (mxGraphAbstractHierarchyCell cell : rank) {
            int rankPosition = cell.getGeneralPurposeVariable(i);
            List<mxGraphAbstractHierarchyCell> connectedCells = cell.getPreviousLayerConnectedCells(i);
            for (mxGraphAbstractHierarchyCell connectedCell : connectedCells) {
                int otherCellRankPosition = connectedCell.getGeneralPurposeVariable(i - 1);
                connections[rankPosition][otherCellRankPosition] = 201207;
            }
        }
        for (int j = 0; j < currentRankSize; ++j) {
            for (int k = 0; k < previousRankSize; ++k) {
                int j2;
                if (connections[j][k] != 201207) continue;
                for (j2 = j + 1; j2 < currentRankSize; ++j2) {
                    for (int k2 = 0; k2 < k; ++k2) {
                        if (connections[j2][k2] != 201207) continue;
                        ++totalCrossings;
                    }
                }
                for (j2 = 0; j2 < j; ++j2) {
                    for (int k2 = k + 1; k2 < previousRankSize; ++k2) {
                        if (connections[j2][k2] != 201207) continue;
                        ++totalCrossings;
                    }
                }
            }
        }
        return totalCrossings / 2;
    }

    private void transpose(int mainLoopIteration, mxGraphHierarchyModel model) {
        boolean improved = true;
        int count = 0;
        int maxCount = 10;
        while (improved && count++ < maxCount) {
            boolean nudge = mainLoopIteration % 2 == 1 && count % 2 == 1;
            improved = false;
            for (int i = 0; i < model.ranks.size(); ++i) {
                mxGraphHierarchyRank rank = model.ranks.get(new Integer(i));
                mxGraphAbstractHierarchyCell[] orderedCells = new mxGraphAbstractHierarchyCell[rank.size()];
                Iterator iter = rank.iterator();
                for (int j = 0; j < orderedCells.length; ++j) {
                    mxGraphAbstractHierarchyCell cell;
                    orderedCells[cell.getGeneralPurposeVariable((int)i)] = cell = (mxGraphAbstractHierarchyCell)iter.next();
                }
                List<mxGraphAbstractHierarchyCell> leftCellAboveConnections = null;
                List<mxGraphAbstractHierarchyCell> leftCellBelowConnections = null;
                List<mxGraphAbstractHierarchyCell> rightCellAboveConnections = null;
                List<mxGraphAbstractHierarchyCell> rightCellBelowConnections = null;
                int[] leftAbovePositions = null;
                int[] leftBelowPositions = null;
                int[] rightAbovePositions = null;
                int[] rightBelowPositions = null;
                mxGraphAbstractHierarchyCell leftCell = null;
                mxGraphAbstractHierarchyCell rightCell = null;
                for (int j = 0; j < rank.size() - 1; ++j) {
                    int ik;
                    int k;
                    int k2;
                    if (j == 0) {
                        leftCell = orderedCells[j];
                        leftCellAboveConnections = leftCell.getNextLayerConnectedCells(i);
                        leftCellBelowConnections = leftCell.getPreviousLayerConnectedCells(i);
                        leftAbovePositions = new int[leftCellAboveConnections.size()];
                        leftBelowPositions = new int[leftCellBelowConnections.size()];
                        for (k2 = 0; k2 < leftAbovePositions.length; ++k2) {
                            leftAbovePositions[k2] = leftCellAboveConnections.get(k2).getGeneralPurposeVariable(i + 1);
                        }
                        for (k2 = 0; k2 < leftBelowPositions.length; ++k2) {
                            leftBelowPositions[k2] = leftCellBelowConnections.get(k2).getGeneralPurposeVariable(i - 1);
                        }
                    } else {
                        leftCellAboveConnections = rightCellAboveConnections;
                        leftCellBelowConnections = rightCellBelowConnections;
                        leftAbovePositions = rightAbovePositions;
                        leftBelowPositions = rightBelowPositions;
                        leftCell = rightCell;
                    }
                    rightCell = orderedCells[j + 1];
                    rightCellAboveConnections = rightCell.getNextLayerConnectedCells(i);
                    rightCellBelowConnections = rightCell.getPreviousLayerConnectedCells(i);
                    rightAbovePositions = new int[rightCellAboveConnections.size()];
                    rightBelowPositions = new int[rightCellBelowConnections.size()];
                    for (k2 = 0; k2 < rightAbovePositions.length; ++k2) {
                        rightAbovePositions[k2] = rightCellAboveConnections.get(k2).getGeneralPurposeVariable(i + 1);
                    }
                    for (k2 = 0; k2 < rightBelowPositions.length; ++k2) {
                        rightBelowPositions[k2] = rightCellBelowConnections.get(k2).getGeneralPurposeVariable(i - 1);
                    }
                    int totalCurrentCrossings = 0;
                    int totalSwitchedCrossings = 0;
                    for (k = 0; k < leftAbovePositions.length; ++k) {
                        for (ik = 0; ik < rightAbovePositions.length; ++ik) {
                            if (leftAbovePositions[k] > rightAbovePositions[ik]) {
                                ++totalCurrentCrossings;
                            }
                            if (leftAbovePositions[k] >= rightAbovePositions[ik]) continue;
                            ++totalSwitchedCrossings;
                        }
                    }
                    for (k = 0; k < leftBelowPositions.length; ++k) {
                        for (ik = 0; ik < rightBelowPositions.length; ++ik) {
                            if (leftBelowPositions[k] > rightBelowPositions[ik]) {
                                ++totalCurrentCrossings;
                            }
                            if (leftBelowPositions[k] >= rightBelowPositions[ik]) continue;
                            ++totalSwitchedCrossings;
                        }
                    }
                    if (totalSwitchedCrossings >= totalCurrentCrossings && (totalSwitchedCrossings != totalCurrentCrossings || !nudge)) continue;
                    int temp = leftCell.getGeneralPurposeVariable(i);
                    leftCell.setGeneralPurposeVariable(i, rightCell.getGeneralPurposeVariable(i));
                    rightCell.setGeneralPurposeVariable(i, temp);
                    rightCellAboveConnections = leftCellAboveConnections;
                    rightCellBelowConnections = leftCellBelowConnections;
                    rightAbovePositions = leftAbovePositions;
                    rightBelowPositions = leftBelowPositions;
                    rightCell = leftCell;
                    if (nudge) continue;
                    improved = true;
                }
            }
        }
    }

    private void weightedMedian(int iteration, mxGraphHierarchyModel model) {
        boolean downwardSweep;
        boolean bl = downwardSweep = iteration % 2 == 0;
        if (downwardSweep) {
            for (int j = model.maxRank - 1; j >= 0; --j) {
                this.medianRank(j, downwardSweep);
            }
        } else {
            for (int j = 1; j < model.maxRank; ++j) {
                this.medianRank(j, downwardSweep);
            }
        }
    }

    private void medianRank(int rankValue, boolean downwardSweep) {
        int numCellsForRank = this.nestedBestRanks[rankValue].length;
        ArrayList<MedianCellSorter> medianValues = new ArrayList<MedianCellSorter>(numCellsForRank);
        boolean[] reservedPositions = new boolean[numCellsForRank];
        for (int i = 0; i < numCellsForRank; ++i) {
            mxGraphAbstractHierarchyCell cell = this.nestedBestRanks[rankValue][i];
            MedianCellSorter sorterEntry = new MedianCellSorter();
            sorterEntry.cell = cell;
            List<mxGraphAbstractHierarchyCell> nextLevelConnectedCells = downwardSweep ? cell.getNextLayerConnectedCells(rankValue) : cell.getPreviousLayerConnectedCells(rankValue);
            int nextRankValue = downwardSweep ? rankValue + 1 : rankValue - 1;
            if (nextLevelConnectedCells != null && nextLevelConnectedCells.size() != 0) {
                sorterEntry.medianValue = this.medianValue(nextLevelConnectedCells, nextRankValue);
                medianValues.add(sorterEntry);
                continue;
            }
            reservedPositions[cell.getGeneralPurposeVariable((int)rankValue)] = true;
        }
        Object[] medianArray = medianValues.toArray(new MedianCellSorter[medianValues.size()]);
        Arrays.sort(medianArray);
        int index = 0;
        for (int i = 0; i < numCellsForRank; ++i) {
            if (reservedPositions[i]) continue;
            Object wrapper = medianArray[index++];
            ((MedianCellSorter)wrapper).cell.setGeneralPurposeVariable(rankValue, i);
        }
    }

    private double medianValue(Collection<mxGraphAbstractHierarchyCell> connectedCells, int rankValue) {
        double[] medianValues = new double[connectedCells.size()];
        int arrayCount = 0;
        Iterator<mxGraphAbstractHierarchyCell> iter = connectedCells.iterator();
        while (iter.hasNext()) {
            medianValues[arrayCount++] = iter.next().getGeneralPurposeVariable(rankValue);
        }
        Arrays.sort(medianValues);
        if (arrayCount % 2 == 1) {
            return medianValues[arrayCount / 2];
        }
        if (arrayCount == 2) {
            return (medianValues[0] + medianValues[1]) / 2.0;
        }
        int medianPoint = arrayCount / 2;
        double leftMedian = medianValues[medianPoint - 1] - medianValues[0];
        double rightMedian = medianValues[arrayCount - 1] - medianValues[medianPoint];
        return (medianValues[medianPoint - 1] * rightMedian + medianValues[medianPoint] * leftMedian) / (leftMedian + rightMedian);
    }

    protected class MedianCellSorter
    implements Comparable<Object> {
        public double medianValue = 0.0;
        mxGraphAbstractHierarchyCell cell = null;

        protected MedianCellSorter() {
        }

        @Override
        public int compareTo(Object arg0) {
            if (arg0 instanceof MedianCellSorter) {
                if (this.medianValue < ((MedianCellSorter)arg0).medianValue) {
                    return -1;
                }
                if (this.medianValue > ((MedianCellSorter)arg0).medianValue) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
    }
}

