/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.util;

import com.mxgraph.io.mxCodecRegistry;
import com.mxgraph.model.mxCellPath;
import com.mxgraph.model.mxICell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxBase64;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxDomUtils;
import com.mxgraph.util.mxHtmlColor;
import com.mxgraph.util.mxLightweightLabel;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxStyleUtils;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.view.mxCellState;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.text.html.HTMLDocument;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class mxUtils {
    public static boolean IS_MAC = System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
    public static boolean IS_LINUX = System.getProperty("os.name").toLowerCase().indexOf("linux") >= 0;
    protected static transient Graphics fontGraphics;

    public static mxRectangle getLabelSize(String label, Map<String, Object> style, boolean isHtml, double scale) {
        return mxUtils.getLabelSize(label, style, isHtml, scale, 0.0);
    }

    public static mxRectangle getLabelSize(String label, Map<String, Object> style, boolean isHtml, double scale, double htmlWrapWidth) {
        mxRectangle size = isHtml ? mxUtils.getSizeForHtml(mxUtils.getBodyMarkup(label, true), style, scale, htmlWrapWidth) : mxUtils.getSizeForString(label, mxUtils.getFont(style), scale);
        return size;
    }

    public static String getBodyMarkup(String markup, boolean replaceLinefeeds) {
        int bodyEnd;
        String lowerCase = markup.toLowerCase();
        int bodyStart = lowerCase.indexOf("<body>");
        if (bodyStart >= 0 && (bodyEnd = lowerCase.lastIndexOf("</body>")) > (bodyStart += 7)) {
            markup = markup.substring(bodyStart, bodyEnd).trim();
        }
        if (replaceLinefeeds) {
            markup = markup.replaceAll("\n", "<br>");
        }
        return markup;
    }

    public static mxRectangle getLabelPaintBounds(String label, Map<String, Object> style, boolean isHtml, mxPoint offset, mxRectangle vertexBounds, double scale) {
        double wrapWidth = 0.0;
        if (isHtml && vertexBounds != null && mxUtils.getString(style, mxConstants.STYLE_WHITE_SPACE, "nowrap").equals("wrap")) {
            wrapWidth = vertexBounds.getWidth();
        }
        mxRectangle size = mxUtils.getLabelSize(label, style, isHtml, scale, wrapWidth);
        size.setWidth(size.getWidth() / scale);
        size.setHeight(size.getHeight() / scale);
        double x = offset.getX();
        double y = offset.getY();
        double width = 0.0;
        double height = 0.0;
        if (vertexBounds != null) {
            x += vertexBounds.getX();
            y += vertexBounds.getY();
            if (mxUtils.getString(style, mxConstants.STYLE_SHAPE, "").equals("swimlane")) {
                boolean horizontal = mxUtils.isTrue(style, mxConstants.STYLE_HORIZONTAL, true);
                double start = mxUtils.getDouble(style, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_STARTSIZE) * scale;
                if (horizontal) {
                    width += vertexBounds.getWidth();
                    height += start;
                } else {
                    width += start;
                    height += vertexBounds.getHeight();
                }
            } else {
                width += vertexBounds.getWidth();
                height += vertexBounds.getHeight();
            }
        }
        return mxUtils.getScaledLabelBounds(x, y, size, width, height, style, scale);
    }

    public static mxRectangle getScaledLabelBounds(double x, double y, mxRectangle size, double outerWidth, double outerHeight, Map<String, Object> style, double scale) {
        double inset = (double)mxConstants.LABEL_INSET * scale;
        double width = size.getWidth() * scale + 2.0 * inset;
        double height = size.getHeight() * scale + 2.0 * inset;
        boolean horizontal = mxUtils.isTrue(style, mxConstants.STYLE_HORIZONTAL, true);
        int spacing = (int)((double)mxUtils.getInt(style, mxConstants.STYLE_SPACING) * scale);
        String align = mxUtils.getString(style, mxConstants.STYLE_ALIGN, "center");
        String valign = mxUtils.getString(style, mxConstants.STYLE_VERTICAL_ALIGN, "middle");
        int top = (int)((double)mxUtils.getInt(style, mxConstants.STYLE_SPACING_TOP) * scale);
        int bottom = (int)((double)mxUtils.getInt(style, mxConstants.STYLE_SPACING_BOTTOM) * scale);
        int left = (int)((double)mxUtils.getInt(style, mxConstants.STYLE_SPACING_LEFT) * scale);
        int right = (int)((double)mxUtils.getInt(style, mxConstants.STYLE_SPACING_RIGHT) * scale);
        if (!horizontal) {
            int tmp = top;
            top = right;
            right = bottom;
            bottom = left;
            left = tmp;
            double tmp2 = width;
            width = height;
            height = tmp2;
        }
        x = horizontal && align.equals("center") || !horizontal && valign.equals("middle") ? (x += (outerWidth - width) / 2.0 + (double)left - (double)right) : (horizontal && align.equals("right") || !horizontal && valign.equals("bottom") ? (x += outerWidth - width - (double)spacing - (double)right) : (x += (double)(spacing + left)));
        y = !horizontal && align.equals("center") || horizontal && valign.equals("middle") ? (y += (outerHeight - height) / 2.0 + (double)top - (double)bottom) : (!horizontal && align.equals("left") || horizontal && valign.equals("bottom") ? (y += outerHeight - height - (double)spacing - (double)bottom) : (y += (double)(spacing + top)));
        return new mxRectangle(x, y, width, height);
    }

    public static FontMetrics getFontMetrics(Font font) {
        if (fontGraphics != null) {
            return fontGraphics.getFontMetrics(font);
        }
        return null;
    }

    public static mxRectangle getSizeForString(String text, Font font, double scale) {
        FontRenderContext frc = new FontRenderContext(null, false, false);
        font = font.deriveFont((float)((double)font.getSize2D() * scale));
        FontMetrics metrics = null;
        if (fontGraphics != null) {
            metrics = fontGraphics.getFontMetrics(font);
        }
        double lineHeight = mxConstants.LINESPACING;
        lineHeight = metrics != null ? (lineHeight += (double)metrics.getHeight()) : (lineHeight += (double)font.getSize2D() * 1.27);
        String[] lines = text.split("\n");
        Rectangle2D boundingBox = null;
        if (lines.length == 0) {
            boundingBox = font.getStringBounds("", frc);
        } else {
            for (int i = 0; i < lines.length; ++i) {
                Rectangle2D bounds = font.getStringBounds(lines[i], frc);
                if (boundingBox == null) {
                    boundingBox = bounds;
                    continue;
                }
                boundingBox.setFrame(0.0, 0.0, Math.max(boundingBox.getWidth(), bounds.getWidth()), boundingBox.getHeight() + lineHeight);
            }
        }
        return new mxRectangle(boundingBox);
    }

    public static String[] wordWrap(String text, FontMetrics metrics, double width) {
        ArrayList<String> result = new ArrayList<String>();
        String[] lines = text.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            int lineWidth = 0;
            int charCount = 0;
            StringBuilder currentLine = new StringBuilder();
            String[] words = lines[i].split("\\s+");
            Stack<String> wordStack = new Stack<String>();
            for (int j = words.length - 1; j >= 0; --j) {
                wordStack.push(words[j]);
            }
            block2: while (!wordStack.isEmpty()) {
                double wordLength;
                String word = (String)wordStack.pop();
                int whitespaceCount = 0;
                if (word.length() > 0) {
                    char firstWordLetter = word.charAt(0);
                    int letterIndex = lines[i].indexOf(firstWordLetter, charCount);
                    String whitespace = lines[i].substring(charCount, letterIndex);
                    whitespaceCount = whitespace.length();
                    word = whitespace.concat(word);
                }
                if ((double)lineWidth + (wordLength = lineWidth > 0 ? (double)metrics.stringWidth(word) : (double)metrics.stringWidth(word.trim())) > width) {
                    if (lineWidth > 0) {
                        result.add(currentLine.toString());
                        currentLine = new StringBuilder();
                        wordStack.push(word.trim());
                        lineWidth = 0;
                        continue;
                    }
                    if (mxConstants.SPLIT_WORDS) {
                        word = word.trim();
                        for (int j = 1; j <= word.length(); ++j) {
                            wordLength = metrics.stringWidth(word.substring(0, j));
                            if (!((double)lineWidth + wordLength > width)) continue;
                            j = j > 1 ? j - 1 : j;
                            String chars = word.substring(0, j);
                            currentLine = currentLine.append(chars);
                            wordStack.push(word.substring(j, word.length()));
                            result.add(currentLine.toString());
                            currentLine = new StringBuilder();
                            lineWidth = 0;
                            charCount = charCount + chars.length() + whitespaceCount;
                            continue block2;
                        }
                        continue;
                    }
                    word = word.trim();
                    result.add(word);
                    currentLine = new StringBuilder();
                    lineWidth = 0;
                    charCount = word.length() + whitespaceCount;
                    continue;
                }
                currentLine = lineWidth > 0 ? currentLine.append(word) : currentLine.append(word.trim());
                lineWidth = (int)((double)lineWidth + wordLength);
                charCount += word.length();
            }
            result.add(currentLine.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    public static mxRectangle getSizeForHtml(String markup, Map<String, Object> style, double scale, double wrapWidth) {
        mxLightweightLabel textRenderer = mxLightweightLabel.getSharedInstance();
        if (textRenderer != null) {
            textRenderer.setText(mxUtils.createHtmlDocument(style, markup));
            Dimension size = textRenderer.getPreferredSize();
            if (wrapWidth > 0.0) {
                textRenderer.setText(mxUtils.createHtmlDocument(style, markup, 1.0, (int)Math.ceil(wrapWidth * mxConstants.PX_PER_PIXEL - (double)mxConstants.LABEL_INSET * scale)));
                Dimension size2 = textRenderer.getPreferredSize();
                if (size2.width < size.width) {
                    size = size2;
                }
            }
            return new mxRectangle(0.0, 0.0, (double)size.width * scale, (double)size.height * scale);
        }
        return mxUtils.getSizeForString(markup, mxUtils.getFont(style), scale);
    }

    public static double[] arcToCurves(double x0, double y0, double r1, double r2, double angle, double largeArcFlag, double sweepFlag, double x, double y) {
        double dr;
        double sds;
        double r2y;
        double ryd;
        double rydd;
        double r1x;
        double spsi;
        x -= x0;
        y -= y0;
        if (r1 == 0.0 || r2 == 0.0) {
            return new double[0];
        }
        double fS = sweepFlag;
        double psai = angle;
        r1 = Math.abs(r1);
        r2 = Math.abs(r2);
        double ctx = -x / 2.0;
        double cty = -y / 2.0;
        double cpsi = Math.cos(psai * Math.PI / 180.0);
        double rxd = cpsi * ctx + (spsi = Math.sin(psai * Math.PI / 180.0)) * cty;
        double rxdd = rxd * rxd;
        double lamda = rxdd / (r1x = r1 * r1) + (rydd = (ryd = -1.0 * spsi * ctx + cpsi * cty) * ryd) / (r2y = r2 * r2);
        if (lamda > 1.0) {
            r1 = Math.sqrt(lamda) * r1;
            r2 = Math.sqrt(lamda) * r2;
            sds = 0.0;
        } else {
            double seif = 1.0;
            if (largeArcFlag == fS) {
                seif = -1.0;
            }
            sds = seif * Math.sqrt((r1x * r2y - r1x * rydd - r2y * rxdd) / (r1x * rydd + r2y * rxdd));
        }
        double txd = sds * r1 * ryd / r2;
        double tyd = -1.0 * sds * r2 * rxd / r1;
        double tx = cpsi * txd - spsi * tyd + x / 2.0;
        double ty = spsi * txd + cpsi * tyd + y / 2.0;
        double rad = Math.atan2((ryd - tyd) / r2, (rxd - txd) / r1) - Math.atan2(0.0, 1.0);
        double s1 = rad >= 0.0 ? rad : Math.PI * 2 + rad;
        rad = Math.atan2((-ryd - tyd) / r2, (-rxd - txd) / r1) - Math.atan2((ryd - tyd) / r2, (rxd - txd) / r1);
        double d = dr = rad >= 0.0 ? rad : Math.PI * 2 + rad;
        if (fS == 0.0 && dr > 0.0) {
            dr -= Math.PI * 2;
        } else if (fS != 0.0 && dr < 0.0) {
            dr += Math.PI * 2;
        }
        double sse = dr * 2.0 / Math.PI;
        int seg = (int)Math.ceil(sse < 0.0 ? -1.0 * sse : sse);
        double segr = dr / (double)seg;
        double t = 2.0 * Math.sin(segr / 4.0) * Math.sin(segr / 4.0) / Math.sin(segr / 2.0);
        double cpsir1 = cpsi * r1;
        double cpsir2 = cpsi * r2;
        double spsir1 = spsi * r1;
        double spsir2 = spsi * r2;
        double mc = Math.cos(s1);
        double ms = Math.sin(s1);
        double x2 = -t * (cpsir1 * ms + spsir2 * mc);
        double y2 = -t * (spsir1 * ms - cpsir2 * mc);
        double x3 = 0.0;
        double y3 = 0.0;
        double[] result = new double[seg * 6];
        for (int n = 0; n < seg; ++n) {
            mc = Math.cos(s1 += segr);
            ms = Math.sin(s1);
            x3 = cpsir1 * mc - spsir2 * ms + tx;
            y3 = spsir1 * mc + cpsir2 * ms + ty;
            double dx = -t * (cpsir1 * ms + spsir2 * mc);
            double dy = -t * (spsir1 * ms - cpsir2 * mc);
            int index = n * 6;
            result[index] = x2 + x0;
            result[index + 1] = y2 + y0;
            result[index + 2] = x3 - dx + x0;
            result[index + 3] = y3 - dy + y0;
            result[index + 4] = x3 + x0;
            result[index + 5] = y3 + y0;
            x2 = x3 + dx;
            y2 = y3 + dy;
        }
        return result;
    }

    public static mxRectangle getBoundingBox(mxRectangle rect, double rotation) {
        mxRectangle result = null;
        if (rect != null && rotation != 0.0) {
            double rad = Math.toRadians(rotation);
            double cos = Math.cos(rad);
            double sin = Math.sin(rad);
            mxPoint cx = new mxPoint(rect.getX() + rect.getWidth() / 2.0, rect.getY() + rect.getHeight() / 2.0);
            mxPoint p1 = new mxPoint(rect.getX(), rect.getY());
            mxPoint p2 = new mxPoint(rect.getX() + rect.getWidth(), rect.getY());
            mxPoint p3 = new mxPoint(p2.getX(), rect.getY() + rect.getHeight());
            mxPoint p4 = new mxPoint(rect.getX(), p3.getY());
            p1 = mxUtils.getRotatedPoint(p1, cos, sin, cx);
            p2 = mxUtils.getRotatedPoint(p2, cos, sin, cx);
            p3 = mxUtils.getRotatedPoint(p3, cos, sin, cx);
            p4 = mxUtils.getRotatedPoint(p4, cos, sin, cx);
            Rectangle tmp = new Rectangle((int)p1.getX(), (int)p1.getY(), 0, 0);
            tmp.add(p2.getPoint());
            tmp.add(p3.getPoint());
            tmp.add(p4.getPoint());
            result = new mxRectangle(tmp);
        } else if (rect != null) {
            result = (mxRectangle)rect.clone();
        }
        return result;
    }

    public static int firstCharAt(String text, int inputChar, int fromIndex) {
        int result = 0;
        while (result >= 0) {
            result = text.indexOf(inputChar, fromIndex);
            if (result == 0) {
                return result;
            }
            if (result <= 0) continue;
            if (Character.isLetter(text.codePointAt(result - 1))) {
                if (++fromIndex >= text.length()) {
                    return -1;
                }
                result = text.indexOf(inputChar, fromIndex);
                continue;
            }
            return result;
        }
        return result;
    }

    public static mxPoint getRotatedPoint(mxPoint pt, double cos, double sin) {
        return mxUtils.getRotatedPoint(pt, cos, sin, new mxPoint());
    }

    public static int findNearestSegment(mxCellState state, double x, double y) {
        int index = -1;
        if (state.getAbsolutePointCount() > 0) {
            mxPoint last = state.getAbsolutePoint(0);
            double min = Double.MAX_VALUE;
            for (int i = 1; i < state.getAbsolutePointCount(); ++i) {
                mxPoint current = state.getAbsolutePoint(i);
                double dist = new Line2D.Double(last.x, last.y, current.x, current.y).ptSegDistSq(x, y);
                if (dist < min) {
                    min = dist;
                    index = i - 1;
                }
                last = current;
            }
        }
        return index;
    }

    public static mxPoint getRotatedPoint(mxPoint pt, double cos, double sin, mxPoint c) {
        double x = pt.getX() - c.getX();
        double y = pt.getY() - c.getY();
        double x1 = x * cos - y * sin;
        double y1 = y * cos + x * sin;
        return new mxPoint(x1 + c.getX(), y1 + c.getY());
    }

    public static int getPortConstraints(mxCellState terminal, mxCellState edge, boolean source) {
        return mxUtils.getPortConstraints(terminal, edge, source, 15);
    }

    public static int getPortConstraints(mxCellState terminal, mxCellState edge, boolean source, int defaultValue) {
        Object value = terminal.getStyle().get(mxConstants.STYLE_PORT_CONSTRAINT);
        if (value == null) {
            return defaultValue;
        }
        String directions = value.toString();
        int returnValue = 0;
        if (directions.indexOf("north") >= 0) {
            returnValue |= 2;
        }
        if (directions.indexOf("west") >= 0) {
            returnValue |= 1;
        }
        if (directions.indexOf("south") >= 0) {
            returnValue |= 4;
        }
        if (directions.indexOf("east") >= 0) {
            returnValue |= 8;
        }
        return returnValue;
    }

    public static int reversePortConstraints(int constraint) {
        int result = 0;
        result = (constraint & 1) << 3;
        result |= (constraint & 2) << 1;
        result |= (constraint & 4) >> 1;
        return result |= (constraint & 8) >> 3;
    }

    public static void drawImageClip(Graphics g, BufferedImage image, ImageObserver observer) {
        Rectangle clip = g.getClipBounds();
        if (clip != null) {
            int w = image.getWidth();
            int h = image.getHeight();
            int x = Math.max(0, Math.min(clip.x, w));
            int y = Math.max(0, Math.min(clip.y, h));
            w = Math.min(clip.width, w - x);
            h = Math.min(clip.height, h - y);
            if (w > 0 && h > 0) {
                g.drawImage(image.getSubimage(x, y, w, h), clip.x, clip.y, observer);
            }
        } else {
            g.drawImage(image, 0, 0, observer);
        }
    }

    public static void fillClippedRect(Graphics g, int x, int y, int width, int height) {
        Rectangle bg = new Rectangle(x, y, width, height);
        try {
            if (g.getClipBounds() != null) {
                bg = bg.intersection(g.getClipBounds());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        g.fillRect(bg.x, bg.y, bg.width, bg.height);
    }

    public static List<mxPoint> translatePoints(List<mxPoint> pts, double dx, double dy) {
        ArrayList<mxPoint> result = null;
        if (pts != null) {
            result = new ArrayList<mxPoint>(pts.size());
            Iterator<mxPoint> it = pts.iterator();
            while (it.hasNext()) {
                mxPoint point = (mxPoint)it.next().clone();
                point.setX(point.getX() + dx);
                point.setY(point.getY() + dy);
                result.add(point);
            }
        }
        return result;
    }

    public static mxPoint intersection(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        double denom = (y3 - y2) * (x1 - x0) - (x3 - x2) * (y1 - y0);
        double nume_a = (x3 - x2) * (y0 - y2) - (y3 - y2) * (x0 - x2);
        double nume_b = (x1 - x0) * (y0 - y2) - (y1 - y0) * (x0 - x2);
        double ua = nume_a / denom;
        double ub = nume_b / denom;
        if (ua >= 0.0 && ua <= 1.0 && ub >= 0.0 && ub <= 1.0) {
            double intersectionX = x0 + ua * (x1 - x0);
            double intersectionY = y0 + ua * (y1 - y0);
            return new mxPoint(intersectionX, intersectionY);
        }
        return null;
    }

    public static Object[] sortCells(Object[] cells, boolean ascending) {
        return mxUtils.sortCells(Arrays.asList(cells), ascending).toArray();
    }

    public static Collection<Object> sortCells(Collection<Object> cells, final boolean ascending) {
        TreeSet<Object> result = new TreeSet<Object>(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int comp = mxCellPath.compare(mxCellPath.create((mxICell)o1), mxCellPath.create((mxICell)o2));
                return comp == 0 ? 0 : (comp > 0 == ascending ? 1 : -1);
            }
        });
        result.addAll(cells);
        return result;
    }

    public static boolean contains(Object[] array, Object obj) {
        return mxUtils.indexOf(array, obj) >= 0;
    }

    public static int indexOf(Object[] array, Object obj) {
        if (obj != null && array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != obj) continue;
                return i;
            }
        }
        return -1;
    }

    public static String getStylename(String style) {
        return mxStyleUtils.getStylename(style);
    }

    public static String[] getStylenames(String style) {
        return mxStyleUtils.getStylenames(style);
    }

    public static int indexOfStylename(String style, String stylename) {
        return mxStyleUtils.indexOfStylename(style, stylename);
    }

    public static String removeAllStylenames(String style) {
        return mxStyleUtils.removeAllStylenames(style);
    }

    public static void setCellStyles(mxIGraphModel model, Object[] cells, String key, String value) {
        mxStyleUtils.setCellStyles(model, cells, key, value);
    }

    public static String setStyle(String style, String key, String value) {
        return mxStyleUtils.setStyle(style, key, value);
    }

    public static void setCellStyleFlags(mxIGraphModel model, Object[] cells, String key, int flag, Boolean value) {
        mxStyleUtils.setCellStyleFlags(model, cells, key, flag, value);
    }

    public static String setStyleFlag(String style, String key, int flag, Boolean value) {
        return mxStyleUtils.setStyleFlag(style, key, flag, value);
    }

    public static boolean intersectsHotspot(mxCellState state, int x, int y, double hotspot) {
        return mxUtils.intersectsHotspot(state, x, y, hotspot, 0, 0);
    }

    public static boolean intersectsHotspot(mxCellState state, int x, int y, double hotspot, int min, int max) {
        if (hotspot > 0.0) {
            int cx = (int)Math.round(state.getCenterX());
            int cy = (int)Math.round(state.getCenterY());
            int width = (int)Math.round(state.getWidth());
            int height = (int)Math.round(state.getHeight());
            if (mxUtils.getString(state.getStyle(), mxConstants.STYLE_SHAPE, "").equals("swimlane")) {
                int start = mxUtils.getInt(state.getStyle(), mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_STARTSIZE);
                if (mxUtils.isTrue(state.getStyle(), mxConstants.STYLE_HORIZONTAL, true)) {
                    cy = (int)Math.round(state.getY() + (double)(start / 2));
                    height = start;
                } else {
                    cx = (int)Math.round(state.getX() + (double)(start / 2));
                    width = start;
                }
            }
            int w = (int)Math.max((double)min, (double)width * hotspot);
            int h = (int)Math.max((double)min, (double)height * hotspot);
            if (max > 0) {
                w = Math.min(w, max);
                h = Math.min(h, max);
            }
            Rectangle rect = new Rectangle(Math.round(cx - w / 2), Math.round(cy - h / 2), w, h);
            return rect.contains(x, y);
        }
        return true;
    }

    public static boolean isTrue(Map<String, Object> dict, String key) {
        return mxUtils.isTrue(dict, key, false);
    }

    public static boolean isTrue(Map<String, Object> dict, String key, boolean defaultValue) {
        Object value = dict.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value.equals("1") || value.toString().equalsIgnoreCase("true");
    }

    public static int getInt(Map<String, Object> dict, String key) {
        return mxUtils.getInt(dict, key, 0);
    }

    public static int getInt(Map<String, Object> dict, String key, int defaultValue) {
        Object value = dict.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (int)Float.parseFloat(value.toString());
    }

    public static float getFloat(Map<String, Object> dict, String key) {
        return mxUtils.getFloat(dict, key, 0.0f);
    }

    public static float getFloat(Map<String, Object> dict, String key, float defaultValue) {
        Object value = dict.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Float.parseFloat(value.toString());
    }

    public static float[] getFloatArray(Map<String, Object> dict, String key, float[] defaultValue) {
        return mxUtils.getFloatArray(dict, key, defaultValue, ",");
    }

    public static float[] getFloatArray(Map<String, Object> dict, String key, float[] defaultValue, String separator) {
        Object value = dict.get(key);
        if (value == null) {
            return defaultValue;
        }
        String[] floatChars = value.toString().split(separator);
        float[] result = new float[floatChars.length];
        for (int i = 0; i < floatChars.length; ++i) {
            result[i] = Float.parseFloat(floatChars[i]);
        }
        return result;
    }

    public static double getDouble(Map<String, Object> dict, String key) {
        return mxUtils.getDouble(dict, key, 0.0);
    }

    public static double getDouble(Map<String, Object> dict, String key, double defaultValue) {
        Object value = dict.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Double.parseDouble(value.toString());
    }

    public static String getString(Map<String, Object> dict, String key) {
        return mxUtils.getString(dict, key, null);
    }

    public static String getString(Map<String, Object> dict, String key, String defaultValue) {
        Object value = dict.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    public static Color getColor(Map<String, Object> dict, String key) {
        return mxUtils.getColor(dict, key, null);
    }

    public static Color getColor(Map<String, Object> dict, String key, Color defaultValue) {
        Object value = dict.get(key);
        if (value == null) {
            return defaultValue;
        }
        return mxUtils.parseColor(value.toString());
    }

    public static Font getFont(Map<String, Object> style) {
        return mxUtils.getFont(style, 1.0);
    }

    public static Font getFont(Map<String, Object> style, double scale) {
        String fontFamily = mxUtils.getString(style, mxConstants.STYLE_FONTFAMILY, mxConstants.DEFAULT_FONTFAMILY);
        int fontSize = mxUtils.getInt(style, mxConstants.STYLE_FONTSIZE, mxConstants.DEFAULT_FONTSIZE);
        int fontStyle = mxUtils.getInt(style, mxConstants.STYLE_FONTSTYLE);
        int swingFontStyle = (fontStyle & 1) == 1 ? 1 : 0;
        return new Font(fontFamily, swingFontStyle += (fontStyle & 2) == 2 ? 2 : 0, (int)((double)fontSize * scale));
    }

    public static String hexString(Color color) {
        return mxHtmlColor.hexString(color);
    }

    public static Color parseColor(String colorString) throws NumberFormatException {
        return mxHtmlColor.parseColor(colorString);
    }

    public static String getHexColorString(Color color) {
        return mxHtmlColor.getHexColorString(color);
    }

    public static String readFile(String filename) throws IOException {
        return mxUtils.readInputStream(new FileInputStream(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readInputStream(InputStream stream) throws IOException {
        StringBuffer result = new StringBuffer();
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new InputStreamReader(stream));
            String tmp = reader.readLine();
            while (tmp != null) {
                result.append(tmp + "\n");
                tmp = reader.readLine();
            }
        }
        return result.toString();
    }

    public static void writeFile(String contents, String filename) throws IOException {
        try (OutputStreamWriter fw = null;){
            fw = new FileWriter(filename);
            fw.write(contents);
            fw.flush();
        }
    }

    public static String getMd5Hash(String text) {
        StringBuffer result = new StringBuffer(32);
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(text.getBytes());
            Formatter f = new Formatter(result);
            byte[] digest = md5.digest();
            for (int i = 0; i < digest.length; ++i) {
                f.format("%02x", new Byte(digest[i]));
            }
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
        return result.toString();
    }

    public static boolean isNode(Object value, String nodeName) {
        return mxUtils.isNode(value, nodeName, null, null);
    }

    public static boolean isNode(Object value, String nodeName, String attributeName, String attributeValue) {
        if (value instanceof Element) {
            Element element = (Element)value;
            if (nodeName == null || element.getNodeName().equalsIgnoreCase(nodeName)) {
                String tmp = attributeName != null ? element.getAttribute(attributeName) : null;
                return attributeName == null || tmp != null && tmp.equals(attributeValue);
            }
        }
        return false;
    }

    public static void setAntiAlias(Graphics2D g, boolean antiAlias, boolean textAntiAlias) {
        g.setRenderingHint(RenderingHints.KEY_RENDERING, antiAlias ? RenderingHints.VALUE_RENDER_QUALITY : RenderingHints.VALUE_RENDER_SPEED);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antiAlias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, textAntiAlias ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    public static void clearRect(Graphics2D g, Rectangle rect, Color background) {
        if (background != null) {
            g.setColor(background);
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        } else {
            g.setComposite(AlphaComposite.getInstance(1, 0.0f));
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            g.setComposite(AlphaComposite.SrcOver);
        }
    }

    public static BufferedImage createBufferedImage(int w, int h, Color background) {
        BufferedImage result = null;
        if (w > 0 && h > 0) {
            int type = background != null ? 1 : 2;
            result = new BufferedImage(w, h, type);
            if (background != null) {
                Graphics2D g2 = result.createGraphics();
                mxUtils.clearRect(g2, new Rectangle(w, h), background);
                g2.dispose();
            }
        }
        return result;
    }

    public static BufferedImage loadImage(String url) {
        BufferedImage img = null;
        if (url != null) {
            if (url.startsWith("data:image/")) {
                try {
                    int comma = url.indexOf(44);
                    byte[] data = mxBase64.decode(url.substring(comma + 1));
                    ByteArrayInputStream is = new ByteArrayInputStream(data);
                    img = ImageIO.read(is);
                }
                catch (Exception comma) {}
            } else {
                URL realUrl = null;
                try {
                    realUrl = new URL(url);
                }
                catch (Exception e) {
                    realUrl = mxUtils.class.getResource(url);
                }
                if (realUrl != null) {
                    try {
                        img = ImageIO.read(realUrl);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        return img;
    }

    public static Element createTable(Document document, String text, int x, int y, int w, int h, double scale, Map<String, Object> style) {
        Element table = document.createElement("table");
        if (text != null && text.length() > 0) {
            float opacity;
            String border;
            String background;
            Element tr = document.createElement("tr");
            Element td = document.createElement("td");
            table.setAttribute("cellspacing", "0");
            table.setAttribute("border", "0");
            td.setAttribute("align", mxUtils.getString(style, mxConstants.STYLE_ALIGN, "center"));
            String fontColor = mxUtils.getString(style, mxConstants.STYLE_FONTCOLOR, "black");
            String fontFamily = mxUtils.getString(style, mxConstants.STYLE_FONTFAMILY, mxConstants.DEFAULT_FONTFAMILIES);
            int fontSize = (int)((double)mxUtils.getInt(style, mxConstants.STYLE_FONTSIZE, mxConstants.DEFAULT_FONTSIZE) * scale);
            String s = "position:absolute;left:" + String.valueOf(x) + "px;top:" + String.valueOf(y) + "px;width:" + String.valueOf(w) + "px;height:" + String.valueOf(h) + "px;font-size:" + String.valueOf(fontSize) + "px;font-family:" + fontFamily + ";color:" + fontColor + ";";
            if (mxUtils.getString(style, mxConstants.STYLE_WHITE_SPACE, "nowrap").equals("wrap")) {
                s = s + "whiteSpace:wrap;";
            }
            if ((background = mxUtils.getString(style, mxConstants.STYLE_LABEL_BACKGROUNDCOLOR)) != null) {
                s = s + "background:" + background + ";";
            }
            if ((border = mxUtils.getString(style, mxConstants.STYLE_LABEL_BORDERCOLOR)) != null) {
                s = s + "border:" + border + " solid 1pt;";
            }
            if ((opacity = mxUtils.getFloat(style, mxConstants.STYLE_TEXT_OPACITY, 100.0f)) < 100.0f) {
                s = s + "filter:alpha(opacity=" + opacity + ");";
                s = s + "opacity:" + opacity / 100.0f + ";";
            }
            td.setAttribute("style", s);
            String[] lines = text.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                td.appendChild(document.createTextNode(lines[i]));
                td.appendChild(document.createElement("br"));
            }
            tr.appendChild(td);
            table.appendChild(tr);
        }
        return table;
    }

    public static Document createDocument() {
        return mxDomUtils.createDocument();
    }

    public static Document createSvgDocument(int width, int height) {
        return mxDomUtils.createSvgDocument(width, height);
    }

    public static Document createVmlDocument() {
        return mxDomUtils.createVmlDocument();
    }

    public static Document createHtmlDocument() {
        return mxDomUtils.createHtmlDocument();
    }

    public static String createHtmlDocument(Map<String, Object> style, String text) {
        return mxUtils.createHtmlDocument(style, text, 1.0, 0);
    }

    public static String createHtmlDocument(Map<String, Object> style, String text, double scale) {
        return mxUtils.createHtmlDocument(style, text, scale, 0);
    }

    public static String createHtmlDocument(Map<String, Object> style, String text, double scale, int width) {
        return mxUtils.createHtmlDocument(style, text, scale, width, null);
    }

    public static String createHtmlDocument(Map<String, Object> style, String text, double scale, int width, String head) {
        String align;
        int fontStyle;
        StringBuffer css = new StringBuffer();
        css.append("font-family:" + mxUtils.getString(style, mxConstants.STYLE_FONTFAMILY, mxConstants.DEFAULT_FONTFAMILIES) + ";");
        css.append("font-size:" + (int)((double)mxUtils.getInt(style, mxConstants.STYLE_FONTSIZE, mxConstants.DEFAULT_FONTSIZE) * scale) + " pt;");
        String color = mxUtils.getString(style, mxConstants.STYLE_FONTCOLOR);
        if (color != null) {
            css.append("color:" + color + ";");
        }
        if (((fontStyle = mxUtils.getInt(style, mxConstants.STYLE_FONTSTYLE)) & 1) == 1) {
            css.append("font-weight:bold;");
        }
        if ((fontStyle & 2) == 2) {
            css.append("font-style:italic;");
        }
        if ((fontStyle & 4) == 4) {
            css.append("text-decoration:underline;");
        }
        if ((align = mxUtils.getString(style, mxConstants.STYLE_ALIGN, "left")).equals("center")) {
            css.append("text-align:center;");
        } else if (align.equals("right")) {
            css.append("text-align:right;");
        }
        if (width > 0) {
            css.append("width:" + width + "px;");
        }
        String result = "<html>";
        if (head != null) {
            result = result + "<head>" + head + "</head>";
        }
        return result + "<body style=\"" + css.toString() + "\">" + text + "</body></html>";
    }

    public static HTMLDocument createHtmlDocumentObject(Map<String, Object> style, double scale) {
        String align;
        int fontStyle;
        HTMLDocument document = new HTMLDocument();
        StringBuffer rule = new StringBuffer("body {");
        rule.append(" font-family: " + mxUtils.getString(style, mxConstants.STYLE_FONTFAMILY, mxConstants.DEFAULT_FONTFAMILIES) + " ; ");
        rule.append(" font-size: " + (int)((double)mxUtils.getInt(style, mxConstants.STYLE_FONTSIZE, mxConstants.DEFAULT_FONTSIZE) * scale) + " pt ;");
        String color = mxUtils.getString(style, mxConstants.STYLE_FONTCOLOR);
        if (color != null) {
            rule.append("color: " + color + " ; ");
        }
        if (((fontStyle = mxUtils.getInt(style, mxConstants.STYLE_FONTSTYLE)) & 1) == 1) {
            rule.append(" font-weight: bold ; ");
        }
        if ((fontStyle & 2) == 2) {
            rule.append(" font-style: italic ; ");
        }
        if ((fontStyle & 4) == 4) {
            rule.append(" text-decoration: underline ; ");
        }
        if ((align = mxUtils.getString(style, mxConstants.STYLE_ALIGN, "left")).equals("center")) {
            rule.append(" text-align: center ; ");
        } else if (align.equals("right")) {
            rule.append(" text-align: right ; ");
        }
        rule.append(" } ");
        document.getStyleSheet().addRule(rule.toString());
        return document;
    }

    public static Document loadDocument(String uri) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setExpandEntityReferences(false);
            docBuilderFactory.setXIncludeAware(false);
            docBuilderFactory.setValidating(false);
            docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            return docBuilder.parse(uri);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document parseXml(String xml) {
        return mxXmlUtils.parseXml(xml);
    }

    public static Object eval(String expression) {
        Class<?> clazz;
        int dot = expression.lastIndexOf(".");
        if (dot > 0 && (clazz = mxCodecRegistry.getClassForName(expression.substring(0, dot))) != null) {
            try {
                return clazz.getField(expression.substring(dot + 1)).get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return expression;
    }

    public static Node findNode(Node node, String attr, String value) {
        String tmp;
        String string = tmp = node instanceof Element ? ((Element)node).getAttribute(attr) : null;
        if (tmp != null && tmp.equals(value)) {
            return node;
        }
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node result = mxUtils.findNode(node, attr, value);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Node selectSingleNode(Document doc, String expression) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            return (Node)xpath.evaluate(expression, doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    public static String htmlEntities(String text) {
        return text.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("'", "&prime;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String getXml(Node node) {
        return mxXmlUtils.getXml(node);
    }

    public static String getPrettyXml(Node node) {
        return mxUtils.getPrettyXml(node, "  ", "");
    }

    public static String getPrettyXml(Node node, String tab, String indent) {
        StringBuffer result = new StringBuffer();
        if (node != null) {
            if (node.getNodeType() == 3) {
                result.append(node.getNodeValue());
            } else {
                Node tmp;
                result.append(indent + "<" + node.getNodeName());
                NamedNodeMap attrs = node.getAttributes();
                if (attrs != null) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        String value = attrs.item(i).getNodeValue();
                        value = mxUtils.htmlEntities(value);
                        result.append(" " + attrs.item(i).getNodeName() + "=\"" + value + "\"");
                    }
                }
                if ((tmp = node.getFirstChild()) != null) {
                    result.append(">\n");
                    while (tmp != null) {
                        result.append(mxUtils.getPrettyXml(tmp, tab, indent + tab));
                        tmp = tmp.getNextSibling();
                    }
                    result.append(indent + "</" + node.getNodeName() + ">\n");
                } else {
                    result.append("/>\n");
                }
            }
        }
        return result.toString();
    }

    static {
        try {
            fontGraphics = new BufferedImage(1, 1, 1).getGraphics();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

