/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.bizflow.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.scm.framework.bizflow.util.ArrayUtil;
import com.kingdee.eas.scm.framework.bizflow.util.CollectionUtil;
import com.kingdee.eas.scm.framework.bizflow.util.CommonUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.Null;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BizBillValueChangeUtil {
    private static final String MATCH_PROPERTY_ID = "id";
    private static final String MATCH_PROPERTY_OLDID = "oldID";
    public static final String COMMON_BILL_VERSION_NAME = "version";
    public static final String COMMON_BILL_OLDID_NAME = "oldID";
    public static final String COMMON_ENTRY_OLDID_NAME = "oldID";
    public static final String TO_BILL_OLDID_NAME = "oldBillID";
    public static final String TO_ENTRY_OLDID_NAME = "oldBillEntryID";
    public static final String IS_NULL_INFO = "isNullInfo";
    private static IDynamicObject iDynamicObject = null;
    static Map<String, Object> diffPropertyMap = new HashMap<String, Object>();
    private static Map<String, PropertyInfo> propertyMap = new HashMap<String, PropertyInfo>();
    private static Map<String, Map<String, PropertyInfo>> entityPropertyMap = new HashMap<String, Map<String, PropertyInfo>>();
    private static Map<String, EntityObjectInfo> entiytyMap = new HashMap<String, EntityObjectInfo>();
    private static final String PROPERTY_FULLNAME_KEY = "fullName";
    private static final String PROPERTY_FULLALIAS_KEY = "fullAlias";
    private static final String PROPERTY_LINKEDBOSTYPE = "linkedBosType";
    public static Map entityMap = new HashMap();
    public static IMetaDataLoader loader = null;
    public static final String UICTX_KEY_ALTERBILLOLDENTRY = "ALTERBILLOLDENTRY";

    private static void initDynamicObject(Context ctx) {
        try {
            iDynamicObject = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
    }

    public static void handleBillSubmit(Context ctx, IObjectValue oldValue, IObjectValue newValue) throws Exception {
        BizBillValueChangeUtil.handleBillChange(ctx, oldValue, newValue, MATCH_PROPERTY_ID);
    }

    public static void resetBillChange(Context ctx, IObjectValue newValue) throws Exception {
        BizBillValueChangeUtil.resetBillChange(ctx, newValue, MATCH_PROPERTY_ID);
    }

    public static void handleBillAlter(Context ctx, IObjectValue oldValue, IObjectValue newValue) throws Exception {
        BizBillValueChangeUtil.handleBillAlter(ctx, oldValue, newValue, "oldID");
    }

    public static void handleBillAlter(Context ctx, IObjectValue oldValue, IObjectValue newValue, String matchPropertyName) throws Exception {
        BizBillValueChangeUtil.handleBillChange(ctx, oldValue, newValue, matchPropertyName);
    }

    public static void handleBillAlter(Context ctx, IObjectValue newValue, String billVersionName, String oldBillIdName, String oldEntryIdName) {
        if (newValue == null || StringUtils.isEmpty((String)billVersionName) || StringUtils.isEmpty((String)oldBillIdName)) {
            return;
        }
        if (newValue.get(MATCH_PROPERTY_ID) == null) {
            return;
        }
        BizBillValueChangeUtil.initDynamicObject(ctx);
        int newVersion = newValue.get(billVersionName) == null ? 0 : newValue.getInt(billVersionName);
        int oldVersion = newVersion == 0 ? 0 : newVersion - 1;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(oldBillIdName, (Object)newValue.get(MATCH_PROPERTY_ID).toString(), CompareType.EQUALS));
        if (newValue.get(billVersionName) != null) {
            filter.getFilterItems().add(new FilterItemInfo(billVersionName, (Object)oldVersion, CompareType.EQUALS));
        }
        view.setFilter(filter);
        try {
            IObjectCollection colOld = iDynamicObject.getCollection(newValue.getBOSType(), view);
            IObjectValue oldValue = null;
            if (!CollectionUtil.isEmpty(colOld)) {
                oldValue = colOld.getObject(0);
            }
            BizBillValueChangeUtil.handleBillAlter(ctx, oldValue, newValue, oldEntryIdName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void handleBillChange(Context ctx, IObjectValue oldValue, IObjectValue newValue) throws Exception {
        BizBillValueChangeUtil.handleBillChange(ctx, oldValue, newValue, MATCH_PROPERTY_ID);
    }

    public static void handleBillChange(Context ctx, IObjectValue oldValue, IObjectValue newValue, String matchPropertyName) throws Exception {
        if (oldValue == null || newValue == null) {
            return;
        }
        if (oldValue.getBOSType() == null || newValue.getBOSType() == null) {
            return;
        }
        String bosType = oldValue.getBOSType().toString();
        if (!bosType.equals(newValue.getBOSType().toString())) {
            return;
        }
        Map<String, PropertyInfo> map = BizBillValueChangeUtil.getEntityProperty(ctx, bosType);
        Map<String, PropertyInfo> numericMap = BizBillValueChangeUtil.filterModelNumericProperty(map);
        Iterator<Map.Entry<String, PropertyInfo>> it = numericMap.entrySet().iterator();
        String propertyName = null;
        while (it.hasNext()) {
            Map.Entry<String, PropertyInfo> entry = it.next();
            propertyName = entry.getKey();
            BizBillValueChangeUtil.dealDiffNumeric(ctx, oldValue, newValue, propertyName, matchPropertyName);
        }
    }

    public static void resetBillChange(Context ctx, IObjectValue newValue, String matchPropertyName) throws Exception {
        IObjectCollection coll;
        if (newValue == null || newValue.getBOSType() == null) {
            return;
        }
        String bosType = newValue.getBOSType().toString();
        if (!bosType.equals(newValue.getBOSType().toString())) {
            return;
        }
        if (diffPropertyMap == null || diffPropertyMap.size() == 0) {
            return;
        }
        Map<String, PropertyInfo> map = BizBillValueChangeUtil.getEntityProperty(ctx, bosType);
        Map<String, PropertyInfo> numericMap = BizBillValueChangeUtil.filterModelNumericProperty(map);
        Iterator<Map.Entry<String, PropertyInfo>> it = numericMap.entrySet().iterator();
        String propertyName = null;
        EntityObjectInfo entityInfo = CommonUtils.getEntityByBosType(bosType);
        String entryName = CommonUtils.getBillEntryPropertyName(entityInfo);
        if (entryName != null && (coll = (IObjectCollection)newValue.get(entryName)) != null) {
            int size = coll.size();
            for (int i = size - 1; i >= 0; --i) {
                if (!coll.getObject(i).containsKey(IS_NULL_INFO)) continue;
                coll.removeObject(i);
            }
        }
        while (it.hasNext()) {
            Map.Entry<String, PropertyInfo> entry = it.next();
            propertyName = entry.getKey();
            BizBillValueChangeUtil.resetNewModelNumeric(ctx, newValue, propertyName, matchPropertyName);
        }
        diffPropertyMap.clear();
    }

    public static void resetBillChange(Context ctx, IObjectValue newValue, String billVersionName, String oldBillIdName, String oldEntryIdName) throws Exception {
        if (newValue == null || newValue.getBOSType() == null) {
            return;
        }
        String bosType = newValue.getBOSType().toString();
        if (!bosType.equals(newValue.getBOSType().toString())) {
            return;
        }
        if (diffPropertyMap == null || diffPropertyMap.size() == 0) {
            return;
        }
        Map<String, PropertyInfo> map = BizBillValueChangeUtil.getEntityProperty(ctx, bosType);
        Map<String, PropertyInfo> numericMap = BizBillValueChangeUtil.filterModelNumericProperty(map);
        Iterator<Map.Entry<String, PropertyInfo>> it = numericMap.entrySet().iterator();
        String propertyName = null;
        if (newValue.get(MATCH_PROPERTY_ID) == null) {
            return;
        }
        BizBillValueChangeUtil.initDynamicObject(ctx);
        int newVersion = newValue.get(billVersionName) == null ? 0 : newValue.getInt(billVersionName);
        int oldVersion = newVersion == 0 ? 0 : newVersion - 1;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(oldBillIdName, (Object)newValue.get(MATCH_PROPERTY_ID).toString(), CompareType.EQUALS));
        if (newValue.get(billVersionName) != null) {
            filter.getFilterItems().add(new FilterItemInfo(billVersionName, (Object)oldVersion, CompareType.EQUALS));
        }
        view.setFilter(filter);
        try {
            IObjectCollection colOld = iDynamicObject.getCollection(newValue.getBOSType(), view);
            IObjectValue oldValue = null;
            if (!CollectionUtil.isEmpty(colOld)) {
                oldValue = colOld.getObject(0);
            }
            while (it.hasNext()) {
                Map.Entry<String, PropertyInfo> entry = it.next();
                propertyName = entry.getKey();
                BizBillValueChangeUtil.resetNewModelNumeric(ctx, newValue, oldValue, propertyName, oldEntryIdName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        diffPropertyMap.clear();
    }

    private static Map<String, PropertyInfo> filterModelNumericProperty(Map<String, PropertyInfo> map) {
        HashMap<String, PropertyInfo> numericMap = new HashMap<String, PropertyInfo>();
        for (Map.Entry<String, PropertyInfo> entry : map.entrySet()) {
            PropertyInfo propertyInfo = entry.getValue();
            String dataType = (String)propertyInfo.get("dataType");
            if (!"BigDecimal".equalsIgnoreCase(dataType) && !"Integer".equalsIgnoreCase(dataType)) continue;
            numericMap.put(entry.getKey(), entry.getValue());
        }
        return numericMap;
    }

    private static Map fetchModelPropertyValue(String propertyName, IObjectValue model) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        String[] arr = BizBillValueChangeUtil.spliteProperty(propertyName);
        ArrayList<Object> list = null;
        Object head = model.get(arr[0]);
        if (head instanceof IObjectCollection) {
            IObjectCollection col = (IObjectCollection)head;
            list = new ArrayList<Object>();
            int size = col.size();
            for (int n = 0; n < size; ++n) {
                list.add(col.getObject(n));
            }
            valueMap.put(arr[0], list);
        } else {
            valueMap.put(arr[0], model.get(arr[0]));
        }
        int len = arr.length;
        for (int i = 1; i < len; ++i) {
            String curPropertyName = BizBillValueChangeUtil.getPrePropertyName(arr, i + 1);
            String prePropertyName = BizBillValueChangeUtil.getPrePropertyName(arr, i);
            Object prePropertyObj = valueMap.get(prePropertyName);
            if (prePropertyObj instanceof List) {
                list = new ArrayList();
                List prePropertyList = (List)prePropertyObj;
                Object prePropertyObj1 = null;
                IObjectValue prePropertyModel = null;
                int size = prePropertyList.size();
                for (int n = 0; n < size; ++n) {
                    prePropertyObj1 = prePropertyList.get(n);
                    if (prePropertyObj1 instanceof IObjectCollection) {
                        IObjectCollection prePropertyCol1 = prePropertyObj1;
                        int nn = 0;
                        int nsize = prePropertyCol1.size();
                        while (nn < nsize) {
                            prePropertyModel = prePropertyCol1.getObject(nn);
                            Object curPropertyObj = prePropertyModel.get(arr[i]);
                            if (curPropertyObj instanceof IObjectCollection) {
                                IObjectCollection curPropertyCol = (IObjectCollection)curPropertyObj;
                                IObjectValue curPropertyModel = null;
                                int jsize = curPropertyCol.size();
                                for (int j = 0; j < jsize; ++j) {
                                    curPropertyModel = curPropertyCol.getObject(j);
                                    list.add(curPropertyCol.getObject(j));
                                }
                            } else {
                                list.add(curPropertyObj);
                            }
                            ++n;
                        }
                        continue;
                    }
                    prePropertyModel = (IObjectValue)prePropertyList.get(n);
                    Object curPropertyObj = prePropertyModel.get(arr[i]);
                    if (curPropertyObj instanceof IObjectCollection) {
                        IObjectCollection curPropertyCol = (IObjectCollection)curPropertyObj;
                        IObjectValue curPropertyModel = null;
                        int jsize = curPropertyCol.size();
                        for (int j = 0; j < jsize; ++j) {
                            curPropertyModel = curPropertyCol.getObject(j);
                            list.add(curPropertyModel);
                        }
                        continue;
                    }
                    list.add(curPropertyObj);
                }
                valueMap.put(curPropertyName, list);
                continue;
            }
            valueMap.put(curPropertyName, model.get(arr[i]));
        }
        valueMap.size();
        return valueMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void dealDiffNumeric(Context ctx, IObjectValue oldValue, IObjectValue newValue, String propertyName, String matchPropertyName) {
        Map oldValueMap = BizBillValueChangeUtil.fetchModelPropertyValue(propertyName, oldValue);
        Map newValueMap = BizBillValueChangeUtil.fetchModelPropertyValue(propertyName, newValue);
        String[] arr = BizBillValueChangeUtil.spliteProperty(propertyName);
        String prePropertyName = BizBillValueChangeUtil.getPrePropertyName(arr, arr.length - 1);
        String curPropertyName = arr[arr.length - 1];
        if (StringUtils.isEmpty((String)prePropertyName)) {
            Object obj = oldValueMap.get(curPropertyName);
            if (!(obj instanceof List) && !(obj instanceof IObjectValue) && !(obj instanceof BigDecimal)) return;
        }
        Object oldObj = oldValueMap.get(prePropertyName);
        Object newObj = newValueMap.get(prePropertyName);
        if (oldObj == null || newObj == null) {
            return;
        }
        if (oldObj instanceof List) {
            List oldList = (List)oldObj;
            List newList = (List)newObj;
            int size = oldList.size();
            for (int i = 0; i < size; ++i) {
                Object old;
                if (oldList.get(i) == null || !((old = oldList.get(i)) instanceof IObjectValue)) continue;
                IObjectValue oldModel = (IObjectValue)old;
                IObjectValue newModel = null;
                if (oldModel.get(matchPropertyName) != null) {
                    newModel = BizBillValueChangeUtil.matchNewModel(newList, oldModel.get(matchPropertyName).toString());
                }
                if (newModel == null) {
                    try {
                        newModel = (IObjectValue)ObjectUtils.createCopy((Object)oldModel);
                        newModel.put(IS_NULL_INFO, (Object)true);
                        newList.add(newModel);
                        if (prePropertyName != null) {
                            ((IObjectCollection)newValue.get(prePropertyName)).addObject(newModel);
                        }
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        // empty catch block
                    }
                }
                if (newModel == null) continue;
                if (newModel.containsKey(IS_NULL_INFO)) {
                    newModel.put(curPropertyName, null);
                }
                if (oldModel.get(curPropertyName) instanceof BigDecimal) {
                    BigDecimal newBig;
                    BigDecimal oldBig = (BigDecimal)oldModel.get(curPropertyName);
                    if (oldBig == null) {
                        oldBig = BigDecimal.ZERO;
                    }
                    if ((newBig = (BigDecimal)newModel.get(curPropertyName)) == null) {
                        newBig = BigDecimal.ZERO;
                    }
                    newModel.put(curPropertyName, (Object)newBig.subtract(oldBig));
                    diffPropertyMap.put(oldModel.get(matchPropertyName).toString() + "@@" + curPropertyName, newBig);
                }
                if (!(oldModel.get(curPropertyName) instanceof Integer)) continue;
                int newInt = newModel.get(curPropertyName) == null ? 0 : (Integer)newModel.get(curPropertyName);
                int oldInt = oldModel.get(curPropertyName) == null ? 0 : (Integer)oldModel.get(curPropertyName);
                newModel.put(curPropertyName, (Object)(newInt - oldInt));
                diffPropertyMap.put(oldModel.get(matchPropertyName).toString() + "@@" + curPropertyName, newInt);
            }
            return;
        }
        if (!(oldObj instanceof IObjectValue)) return;
        IObjectValue oldModel = (IObjectValue)oldObj;
        IObjectValue newModel = (IObjectValue)newObj;
        if (oldModel.get(curPropertyName) instanceof BigDecimal) {
            BigDecimal newBig;
            BigDecimal oldBig = (BigDecimal)oldModel.get(curPropertyName);
            if (oldBig == null) {
                oldBig = BigDecimal.ZERO;
            }
            if ((newBig = (BigDecimal)newModel.get(curPropertyName)) == null) {
                newBig = BigDecimal.ZERO;
            }
            newModel.put(curPropertyName, (Object)newBig.subtract(oldBig));
            diffPropertyMap.put(curPropertyName, newBig);
        }
        if (!(oldModel.get(curPropertyName) instanceof Integer)) return;
        int newInt = newModel.get(curPropertyName) == null ? 0 : (Integer)newModel.get(curPropertyName);
        int oldInt = oldModel.get(curPropertyName) == null ? 0 : (Integer)oldModel.get(curPropertyName);
        newModel.put(curPropertyName, (Object)(newInt - oldInt));
        diffPropertyMap.put(curPropertyName, newInt);
    }

    private static final void dealDiffNumeric(Context ctx, IObjectValue oldValue, IObjectValue newValue, String propertyName) {
        BizBillValueChangeUtil.dealDiffNumeric(ctx, oldValue, newValue, propertyName, MATCH_PROPERTY_ID);
    }

    private static final void resetNewModelNumeric(Context ctx, IObjectValue newValue, String propertyName) {
        BizBillValueChangeUtil.resetNewModelNumeric(ctx, newValue, propertyName, MATCH_PROPERTY_ID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void resetNewModelNumeric(Context ctx, IObjectValue newValue, String propertyName, String matchPropertyName) {
        Map newValueMap = BizBillValueChangeUtil.fetchModelPropertyValue(propertyName, newValue);
        String[] arr = BizBillValueChangeUtil.spliteProperty(propertyName);
        String prePropertyName = BizBillValueChangeUtil.getPrePropertyName(arr, arr.length - 1);
        String curPropertyName = arr[arr.length - 1];
        if (StringUtils.isEmpty((String)prePropertyName)) {
            Object obj = newValueMap.get(curPropertyName);
            if (!(obj instanceof List) && !(obj instanceof IObjectValue) && !(obj instanceof BigDecimal)) return;
        }
        Object newObj = newValueMap.get(prePropertyName);
        if (newObj == null) {
            return;
        }
        if (newObj instanceof List) {
            List newList = (List)newObj;
            int size = newList.size();
            for (int i = 0; i < size; ++i) {
                if (newList.get(i) == null || !(newList.get(i) instanceof IObjectValue)) continue;
                IObjectValue newModel = null;
                newModel = (IObjectValue)newList.get(i);
                if (newModel == null) continue;
                String key = newModel.get(matchPropertyName).toString() + "@@" + curPropertyName;
                if (newModel.get(curPropertyName) instanceof BigDecimal) {
                    BigDecimal newBig = BigDecimal.ZERO;
                    if (!diffPropertyMap.containsKey(key)) continue;
                    newBig = (BigDecimal)diffPropertyMap.get(key);
                    newModel.put(curPropertyName, (Object)newBig);
                }
                if (!(newModel.get(curPropertyName) instanceof Integer)) continue;
                Integer newInt = Integer.valueOf("0");
                if (!diffPropertyMap.containsKey(key)) continue;
                newInt = (Integer)diffPropertyMap.get(key);
                newModel.put(curPropertyName, (Object)newInt);
            }
            return;
        } else {
            if (!(newObj instanceof IObjectValue)) return;
            IObjectValue newModel = (IObjectValue)newObj;
            String key = curPropertyName;
            if (newModel.get(curPropertyName) instanceof BigDecimal) {
                BigDecimal newBig = BigDecimal.ZERO;
                if (diffPropertyMap.containsKey(key)) {
                    newBig = (BigDecimal)diffPropertyMap.get(key);
                }
                newModel.put(curPropertyName, (Object)newBig);
            }
            if (!(newModel.get(curPropertyName) instanceof Integer)) return;
            Integer newInt = Integer.valueOf("0");
            if (diffPropertyMap.containsKey(key)) {
                newInt = (Integer)diffPropertyMap.get(key);
            }
            newModel.put(curPropertyName, (Object)newInt);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void resetNewModelNumeric(Context ctx, IObjectValue newValue, IObjectValue oldValue, String propertyName, String matchPropertyName) {
        Map newValueMap = BizBillValueChangeUtil.fetchModelPropertyValue(propertyName, newValue);
        Map oldValueMap = BizBillValueChangeUtil.fetchModelPropertyValue(propertyName, oldValue);
        String[] arr = BizBillValueChangeUtil.spliteProperty(propertyName);
        String prePropertyName = BizBillValueChangeUtil.getPrePropertyName(arr, arr.length - 1);
        String curPropertyName = arr[arr.length - 1];
        if (StringUtils.isEmpty((String)prePropertyName)) {
            Object obj = newValueMap.get(curPropertyName);
            if (!(obj instanceof List) && !(obj instanceof IObjectValue) && !(obj instanceof BigDecimal)) return;
        }
        Object newObj = newValueMap.get(prePropertyName);
        Object oldObj = oldValueMap.get(prePropertyName);
        if (newObj == null) {
            return;
        }
        if (newObj instanceof List) {
            List newList = (List)newObj;
            int size = newList.size();
            for (int i = 0; i < size; ++i) {
                if (!(newList.get(i) instanceof IObjectValue)) continue;
                IObjectValue newModel = null;
                newModel = (IObjectValue)newList.get(i);
                if (newModel == null || newModel.get(MATCH_PROPERTY_ID) == null) continue;
                String key = newModel.get(MATCH_PROPERTY_ID).toString() + "@@" + curPropertyName;
                if (newModel.get(curPropertyName) instanceof BigDecimal) {
                    BigDecimal newBig = BigDecimal.ZERO;
                    if (!diffPropertyMap.containsKey(key)) continue;
                    newBig = (BigDecimal)diffPropertyMap.get(key);
                    newModel.put(curPropertyName, (Object)newBig);
                }
                if (!(newModel.get(curPropertyName) instanceof Integer)) continue;
                Integer newInt = Integer.valueOf("0");
                if (!diffPropertyMap.containsKey(key)) continue;
                newInt = (Integer)diffPropertyMap.get(key);
                newModel.put(curPropertyName, (Object)newInt);
            }
            return;
        } else {
            if (!(newObj instanceof IObjectValue)) return;
            IObjectValue newModel = (IObjectValue)newObj;
            String key = curPropertyName;
            if (newModel.get(curPropertyName) instanceof BigDecimal) {
                BigDecimal newBig = BigDecimal.ZERO;
                if (diffPropertyMap.containsKey(key)) {
                    newBig = (BigDecimal)diffPropertyMap.get(key);
                }
                newModel.put(curPropertyName, (Object)newBig);
            }
            if (!(newModel.get(curPropertyName) instanceof Integer)) return;
            Integer newInt = Integer.valueOf("0");
            if (diffPropertyMap.containsKey(key)) {
                newInt = (Integer)diffPropertyMap.get(key);
            }
            newModel.put(curPropertyName, (Object)newInt);
        }
    }

    private static IObjectValue matchNewModel(List list, String id) {
        IObjectValue model = null;
        if (CollectionUtil.isEmpty(list) || StringUtils.isEmpty((String)id)) {
            return null;
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue entry;
            if (!(list.get(i) instanceof IObjectValue) || (entry = (IObjectValue)list.get(i)).get(MATCH_PROPERTY_ID) == null || !id.equals(entry.get(MATCH_PROPERTY_ID).toString())) continue;
            return entry;
        }
        return model;
    }

    private static String[] spliteProperty(String propertyName) {
        String[] stringArray;
        if (StringUtils.isEmpty((String)propertyName)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = propertyName.split("\\.");
        }
        return stringArray;
    }

    private static String getPrePropertyName(String[] arr, int index) {
        StringBuffer sb = new StringBuffer(64);
        if (ArrayUtil.isEmpty(arr)) {
            return "";
        }
        if (index > arr.length) {
            index = arr.length;
        }
        for (int i = 0; i < index; ++i) {
            sb.append("." + arr[i]);
        }
        if (sb.length() > 0) {
            sb.delete(0, 1);
        }
        return sb.toString();
    }

    public static Map<String, PropertyInfo> getEntityProperty(Context ctx, String bosType) {
        if (entityPropertyMap.containsKey(bosType)) {
            return entityPropertyMap.get(bosType);
        }
        EntityObjectInfo entity = BizBillValueChangeUtil.getEntityObjectInfo(ctx, bosType);
        entityPropertyMap.put(bosType, BizBillValueChangeUtil.getEntityProperty(entity));
        return entityPropertyMap.get(bosType);
    }

    private static Map<String, PropertyInfo> getEntityProperty(EntityObjectInfo entity) {
        propertyMap.clear();
        BizBillValueChangeUtil.getEntityProperty(entity, null);
        HashMap<String, PropertyInfo> map = new HashMap<String, PropertyInfo>();
        map.putAll(propertyMap);
        return map;
    }

    private static void getEntityProperty(EntityObjectInfo entity, PropertyInfo parent) {
        if (entity == null) {
            return;
        }
        String parentName = "";
        String parentAlias = "";
        if (parent != null) {
            parentName = parent.get(PROPERTY_FULLNAME_KEY).toString();
            parentAlias = parent.get(PROPERTY_FULLALIAS_KEY).toString();
        } else {
            parentAlias = entity.getAlias();
        }
        PropertyCollection coll = entity.getEntityProperties();
        PropertyInfo property = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            property = coll.get(i);
            if (property instanceof LinkPropertyInfo) {
                RelationshipInfo relation = ((LinkPropertyInfo)property).getRelationship();
                EntityObjectInfo linkEntity = relation.getSupplierObject();
                if (StringUtils.isEmpty((String)parentName)) {
                    property.put(PROPERTY_FULLNAME_KEY, (Object)property.getName());
                } else {
                    property.put(PROPERTY_FULLNAME_KEY, (Object)(parentName + "." + property.getName()));
                }
                if (StringUtils.isEmpty((String)parentAlias)) {
                    property.put(PROPERTY_FULLALIAS_KEY, (Object)property.getAlias());
                } else {
                    property.put(PROPERTY_FULLALIAS_KEY, (Object)(parentAlias + "." + property.getAlias()));
                }
                property.put(PROPERTY_LINKEDBOSTYPE, (Object)linkEntity.getType().toString());
                propertyMap.put(property.get(PROPERTY_FULLNAME_KEY).toString(), property);
                if (!BizBillValueChangeUtil.isEntryProperty(entity, property)) continue;
                EntityObjectInfo entryEntity = relation.getSupplierObject();
                BizBillValueChangeUtil.getEntityProperty(entryEntity, property);
                continue;
            }
            if (StringUtils.isEmpty((String)parentName)) {
                property.put(PROPERTY_FULLNAME_KEY, (Object)property.getName());
            } else {
                property.put(PROPERTY_FULLNAME_KEY, (Object)(parentName + "." + property.getName()));
            }
            propertyMap.put(property.get(PROPERTY_FULLNAME_KEY).toString(), property);
        }
    }

    private static boolean isEntryProperty(EntityObjectInfo parent, PropertyInfo property) {
        RelationshipInfo relation;
        return !(parent == null || property == null || !(property instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)property).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries")) || !relation.getClientObject().getFullName().equals(parent.getFullName()) || relation.getSupplierCardinality() != CardinalityType.ONE_TO_UNBOUNDED && relation.getSupplierCardinality() != CardinalityType.ZERO_TO_UNBOUNDED);
    }

    private static EntityObjectInfo getEntityObjectInfo(Context ctx, String bosTypeID) {
        if (StringUtils.isEmpty((String)bosTypeID)) {
            return null;
        }
        if (entiytyMap.containsKey(bosTypeID)) {
            return entiytyMap.get(bosTypeID);
        }
        BOSObjectType bosType = BOSObjectType.create((String)bosTypeID);
        IMetaDataLoader iMeta = null;
        iMeta = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = iMeta.getEntity(bosType);
        if (entity != null) {
            entiytyMap.put(bosTypeID, entity);
        }
        return entity;
    }

    private static boolean isEmptyObject(Object s) {
        if (s instanceof String) {
            return ((String)s).trim().length() == 0;
        }
        return s == null || s == Null.NULL;
    }

    private static boolean compareValue(Object value1, Object value2) {
        if (value1 instanceof Boolean || value2 instanceof Boolean) {
            Boolean bool1 = value1 == null ? Boolean.FALSE : (Boolean)value1;
            Boolean bool2 = value2 == null ? Boolean.FALSE : (Boolean)value2;
            return bool1.booleanValue() == bool2.booleanValue();
        }
        if (BizBillValueChangeUtil.isEmptyObject(value1) && BizBillValueChangeUtil.isEmptyObject(value2)) {
            return true;
        }
        if (BizBillValueChangeUtil.isEmptyObject(value1) || BizBillValueChangeUtil.isEmptyObject(value2)) {
            return false;
        }
        if (value1 instanceof Byte) {
            return ((Byte)value1).compareTo((Byte)value2) == 0;
        }
        if (value1 instanceof Short) {
            return ((Short)value1).compareTo((Short)value2) == 0;
        }
        if (value1 instanceof Integer) {
            return ((Integer)value1).compareTo((Integer)value2) == 0;
        }
        if (value1 instanceof Long) {
            return ((Long)value1).compareTo((Long)value2) == 0;
        }
        if (value1 instanceof Float) {
            return ((Float)value1).compareTo((Float)value2) == 0;
        }
        if (value1 instanceof Double) {
            return ((Double)value1).compareTo((Double)value2) == 0;
        }
        if (value1 instanceof BigDecimal) {
            return ((BigDecimal)value1).compareTo((BigDecimal)value2) == 0;
        }
        if (value1 instanceof String) {
            return ((String)value1).equals((String)value2);
        }
        if (value1 instanceof Date) {
            return DateTimeUtils.dayEquals((Date)((Date)value1), (Date)((Date)value2));
        }
        if (value1 instanceof Time) {
            return ((Time)value1).compareTo((Time)value2) == 0;
        }
        if (value1 instanceof Timestamp) {
            return DateTimeUtils.dayEquals((Date)((Date)value1), (Date)((Date)value2));
        }
        if (value1 instanceof Object[]) {
            Object[] arrValue1 = (Object[])value1;
            Object[] arrValue2 = (Object[])value2;
            if (arrValue1.length != arrValue2.length) {
                return false;
            }
            boolean retValue = true;
            for (int i = 0; i < arrValue1.length && retValue; ++i) {
                retValue = BizBillValueChangeUtil.compareValue(arrValue1[i], arrValue2[i]);
            }
            return retValue;
        }
        if (value1 instanceof AbstractObjectValue) {
            AbstractObjectValue objectValue1 = (AbstractObjectValue)value1;
            AbstractObjectValue objectValue2 = (AbstractObjectValue)value2;
            String pkField1 = objectValue1.getPKField();
            String pkField2 = objectValue1.getPKField();
            if (pkField1 != null && pkField2 != null) {
                if (pkField1.equals(pkField2)) {
                    return BizBillValueChangeUtil.compareValue(objectValue1.get(pkField1), objectValue2.get(pkField2));
                }
                return false;
            }
        }
        return value1.equals(value2);
    }

    public static void initLoader(Context ctx) {
        loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
    }

    public static EntityObjectInfo getEntityByBosType(Context ctx, String bosType) {
        if (entityMap.get(bosType) != null) {
            return (EntityObjectInfo)entityMap.get(bosType);
        }
        BizBillValueChangeUtil.initLoader(ctx);
        EntityObjectInfo entity = loader.getEntity(BOSObjectType.create((String)bosType));
        if (entity != null) {
            entityMap.put(bosType, entity);
            return entity;
        }
        return null;
    }
}

