/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.dt.CarryBillEntryCollection;
import com.kingdee.eas.scm.im.dt.CarryBillEntryInfo;
import com.kingdee.eas.scm.im.dt.CarryBillException;
import com.kingdee.eas.scm.im.dt.CarryBillFeeEntryCollection;
import com.kingdee.eas.scm.im.dt.CarryBillFeeEntryInfo;
import com.kingdee.eas.scm.im.dt.CarryBillInfo;
import com.kingdee.eas.scm.im.dt.DTException;
import com.kingdee.eas.scm.im.dt.DeliveryLineInfo;
import com.kingdee.eas.scm.im.dt.DistributionTypeEnum;
import com.kingdee.eas.scm.im.dt.IRoadCostBill;
import com.kingdee.eas.scm.im.dt.RoadCostBillFactory;
import com.kingdee.eas.scm.im.dt.RoadCostBillInfo;
import com.kingdee.eas.scm.im.dt.app.AbstractCarryBillControllerBean;
import com.kingdee.eas.scm.im.dt.util.DtUtils;
import com.kingdee.eas.scm.util.SCMUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class CarryBillControllerBean
extends AbstractCarryBillControllerBean {
    private static final String CARRY_BILL_RESOURCE = "com.kingdee.eas.scm.im.dt.CarryBillResource";

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CarryBillInfo info = (CarryBillInfo)model;
        CarryBillEntryCollection entries = info.getEntry();
        if (info != null && entries != null) {
            for (int i = 0; i < entries.size(); ++i) {
                CarryBillEntryInfo entry = info.getEntry().get(i);
                entry.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
            }
        }
        return super._save(ctx, model);
    }

    protected void _submit(Context ctx, String id) throws BOSException, EASBizException {
        this.submit(ctx, (CoreBaseInfo)this.getCarryBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id)));
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CarryBillInfo info = (CarryBillInfo)model;
        this.checkInfo4Submit(ctx, info);
        this.checkEntry4Submit(ctx, info);
        this.setDefaultValue4Submit(ctx, info);
        SCMUtil.succeedSourceBillReservationInfo((Context)ctx, (IObjectValue)model);
        return super._submit(ctx, model);
    }

    @Override
    protected String[] _getSendLineIDs(Context ctx, Object object) throws BOSException {
        String[] ids = null;
        DeliveryLineInfo lineInfo = (DeliveryLineInfo)object;
        if (lineInfo != null) {
            IRowSet rs = null;
            try {
                StringBuffer sql = new StringBuffer();
                sql.append("select distinct FDetailLineID from T_DT_DeliveryLineEntry where FParentID = '");
                sql.append(lineInfo.getId().toString());
                sql.append("' order by FDetailLineID ");
                String sqlString = sql.toString();
                rs = DbUtil.executeQuery((Context)ctx, (String)sqlString);
                boolean bResult = false;
                ArrayList<String> idList = new ArrayList<String>();
                while (rs.next()) {
                    if (rs.getString(1) == null) continue;
                    bResult = true;
                    idList.add(rs.getString(1));
                }
                if (bResult) {
                    ids = new String[idList.size()];
                    idList.toArray(ids);
                }
            }
            catch (SQLException e1) {
                throw new BOSException((Throwable)e1);
            }
        }
        return ids;
    }

    @Override
    protected void setNullToDefault(Context ctx, IObjectValue model) {
        super.setNullToDefault(ctx, model);
        if (model == null) {
            return;
        }
        IObjectCollection entrys = (IObjectCollection)model.get("entry");
        if (entrys == null) {
            return;
        }
        String[] entryDecimalFields = new String[]{"arAssociateQty"};
        int n = entrys.size();
        for (int i = 0; i < n; ++i) {
            IObjectValue entry = entrys.getObject(i);
            for (int j = 0; j < entryDecimalFields.length; ++j) {
                if (entry.get(entryDecimalFields[j]) != null) continue;
                entry.put(entryDecimalFields[j], (Object)DtUtils.ZERO);
            }
        }
        IObjectCollection feeEntrys = (IObjectCollection)model.get("feeEntry");
        if (feeEntrys == null) {
            return;
        }
        entryDecimalFields = new String[]{"feeQty", "feePrice", "feeAmount", "agreePrice", "agressAmount", "balancedQty", "balancedAmount", "unbalancedQty"};
        int n2 = feeEntrys.size();
        for (int i = 0; i < n2; ++i) {
            IObjectValue entry = feeEntrys.getObject(i);
            for (int j = 0; j < entryDecimalFields.length; ++j) {
                if (entry.get(entryDecimalFields[j]) != null) continue;
                entry.put(entryDecimalFields[j], (Object)DtUtils.ZERO);
            }
        }
        CarryBillInfo info = (CarryBillInfo)model;
        if (info.getCompanyOrgUnit() == null) {
            TransportOrgUnitInfo tou = info.getTransportOrgUnit();
            info.setCompanyOrgUnit(DtUtils.getCompanyInfo(ctx, tou));
        }
    }

    @Override
    protected void initBotpData(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        CarryBillInfo info = (CarryBillInfo)model;
        info.setBillType(SCMServerUtils.getBillType((String)"18b7FpLNSrmaD8V9SPcOhkY+1VI="));
        if (info.getEntry() == null) {
            return;
        }
        for (int i = 0; i < info.getEntry().size(); ++i) {
            CarryBillEntryInfo entry = info.getEntry().get(i);
            MaterialInfo material = entry.getMaterial();
            if (material == null) continue;
            MeasureUnitInfo unit = entry.getUnit();
            MeasureUnitInfo baseUnit = entry.getBaseUnit();
            MeasureUnitInfo asstUnit = entry.getAssistUnit();
            BigDecimal baseQty = entry.getBaseQty();
            if (baseQty == null) {
                entry.setBaseQty(DtUtils.ZERO);
            }
            BigDecimal qty = SCMServerUtils.getUnitQty((Context)ctx, (BigDecimal)baseQty, (String)material.getId().toString(), (String)baseUnit.getId().toString(), (String)unit.getId().toString());
            entry.setQty(qty);
            if (asstUnit == null) continue;
            BigDecimal asstQty = SCMServerUtils.getUnitQty((Context)ctx, (BigDecimal)baseQty, (String)material.getId().toString(), (String)baseUnit.getId().toString(), (String)asstUnit.getId().toString());
            entry.setAssistQty(asstQty);
        }
    }

    @Override
    protected String[] getEntryDecimalFields() {
        return new String[]{"qty", "outQtyActual", "qtyActual", "qtyLoss", "obeyQty", "receivedQty", "receivedLostQty", "receiveAssoBaseQty", "baseQty", "assistQty"};
    }

    @Override
    protected void updateMe(Context ctx, IObjectPK pk, IObjectValue model, BizActionEnum action) throws EASBizException, BOSException {
        super.updateMe(ctx, pk, model, action);
        if (model == null) {
            return;
        }
        CarryBillInfo bill = (CarryBillInfo)model;
        if (BizActionEnum.AUDIT.equals((Object)action)) {
            String sql;
            if (DistributionTypeEnum.SALE_TRANSPORTATION.equals((Object)bill.getDistributionType())) {
                // empty if block
            }
            if (DistributionTypeEnum.TRANSFER_TRANSPORTATION.equals((Object)bill.getDistributionType())) {
                sql = "UPDATE T_DT_CarryBillEntry SET FReceiveAssoBaseQty = FBaseQty WHERE FParentID = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{bill.getId().toString()});
            }
            if (DistributionTypeEnum.PUR_SELF_TRANSPORTATION.equals((Object)bill.getDistributionType())) {
                sql = "UPDATE T_DT_CarryBillEntry SET FReceiveAssoBaseQty = FBaseQty WHERE FParentID = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{bill.getId().toString()});
            }
            if (DistributionTypeEnum.SALERETURNS_TRANSPORTATION.equals((Object)bill.getDistributionType())) {
                // empty if block
            }
            sql = "UPDATE T_DT_CarryBillFeeEntry SET FUnBalancedQty = FFeeQty WHERE FParentID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{bill.getId().toString()});
        } else {
            String sql_carrybill = "update t_dt_carrybillentry set fqtyActual = 0 ,fobeyQty = 0,freceivedQty = 0 ,fqtyLoss = 0,freceivedLostQty = 0 ,farAssociateQty = 0,FOutQtyActual =0,FReceiveAssoBaseQty=0,FCheckInDate=null,FCheckInRemark=null where fparentid ='" + bill.getId().toString() + "'";
            String sql_CarryBillFee = "UPDATE T_DT_CarryBillFeeEntry SET FUnBalancedQty = 0 WHERE FParentID ='" + bill.getId().toString() + "'";
            String[] updateSql = new String[]{sql_carrybill, sql_CarryBillFee};
            DBUtil.executeBatch((Context)ctx, (String[])updateSql);
        }
    }

    @Override
    protected void _checkIn(Context ctx, String[] sqls) throws BOSException, EASBizException {
        if (sqls == null) {
            return;
        }
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            for (int i = 0; i < sqls.length; ++i) {
                if (StringUtils.isEmpty((String)sqls[i])) continue;
                stmt.addBatch(sqls[i]);
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    @Override
    protected void _close(Context ctx, String pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        String carryParam = "CARRY003";
        String destBosType = "0B95954B";
        CarryBillInfo info = this.getCarryBillInfo(ctx, (IObjectPK)new ObjectUuidPK(pk));
        if (!BillBaseStatusEnum.AUDITED.equals((Object)info.getBaseStatus())) {
            throw new DTException(DTException.BILLNOTAUDIT);
        }
        this.checkBeforeClose(info);
        StringBuffer sqlHead = new StringBuffer();
        sqlHead.append("UPDATE T_DT_CarryBill SET FBaseStatus = ").append(7);
        sqlHead.append("WHERE FID = '").append(pk).append("'");
        StringBuffer sqlEntry = new StringBuffer();
        sqlEntry.append("UPDATE T_DT_CarryBillEntry SET FBaseStatus = ").append(7);
        sqlEntry.append("WHERE FParentID = '").append(pk).append("'");
        String[] updateSql = new String[]{sqlHead.toString(), sqlEntry.toString()};
        DBUtil.executeBatch((Context)ctx, (String[])updateSql);
        TransportOrgUnitInfo OrgUnitInfo2 = info.getTransportOrgUnit();
        ObjectUuidPK orgPk = new ObjectUuidPK(OrgUnitInfo2.getId());
        String param = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)orgPk, carryParam);
        if (Boolean.valueOf(param).booleanValue()) {
            this.CreateTo(ctx, info, destBosType);
        }
    }

    public void CreateTo(Context ctx, CarryBillInfo bill, String destBillType) throws BOSException, EASBizException {
        CoreBillBaseCollection srcBillInfos = new CoreBillBaseCollection();
        srcBillInfos.add((CoreBillBaseInfo)bill);
        String botpIdSign = "jjtu6wEVEADgAAnWwKgSggRRIsQ=";
        String botpIdReceipt = "836uMgEWEADgAj6BwKg9EgRRIsQ=";
        IBOTMapping iBOTMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BOTMappingInfo botMappingSignInfo = iBOTMapping.getBOTMappingInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)botpIdSign)));
        BOTMappingInfo botMappingReceiptInfo = iBOTMapping.getBOTMappingInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)botpIdReceipt)));
        CarryBillEntryInfo entryInfo = null;
        Boolean signFlag = false;
        Boolean receivedFlag = false;
        for (int i = 0; i < bill.getEntry().size(); ++i) {
            entryInfo = bill.getEntry().get(i);
            if (entryInfo.getQtyLoss().compareTo(BigDecimal.ZERO) != 0) {
                signFlag = true;
            }
            if (entryInfo.getReceivedLostQty().compareTo(BigDecimal.ZERO) == 0) continue;
            receivedFlag = true;
        }
        if (botMappingSignInfo != null && botMappingSignInfo.getExtRule().isIsEffected() && signFlag.booleanValue()) {
            iBTPManager.transformForBotp(srcBillInfos, destBillType, (IObjectPK)new ObjectUuidPK(botMappingSignInfo.getId().toString()));
        }
        if (botMappingReceiptInfo != null && botMappingReceiptInfo.getExtRule().isIsEffected() && receivedFlag.booleanValue()) {
            iBTPManager.transformForBotp(srcBillInfos, destBillType, (IObjectPK)new ObjectUuidPK(botMappingReceiptInfo.getId().toString()));
        }
    }

    protected void checkBeforeClose(CarryBillInfo info) throws BOSException, EASBizException {
        StringBuffer errorSeq = new StringBuffer();
        StringBuffer errorSeq1 = new StringBuffer();
        StringBuffer errorSeq2 = new StringBuffer();
        StringBuffer errorSeq3 = new StringBuffer();
        StringBuffer errorSeq4 = new StringBuffer();
        int n = info.getEntry().size();
        for (int i = 0; i < n; ++i) {
            CarryBillEntryInfo entry = info.getEntry().get(i);
            BigDecimal outQtyActual = entry.getOutQtyActual();
            outQtyActual = outQtyActual == null ? DtUtils.ZERO : outQtyActual;
            BigDecimal qtyActual = entry.getQtyActual();
            qtyActual = qtyActual == null ? DtUtils.ZERO : qtyActual;
            BigDecimal obeyQty = entry.getObeyQty();
            obeyQty = obeyQty == null ? DtUtils.ZERO : obeyQty;
            BigDecimal qtyLoss = entry.getQtyLoss();
            qtyLoss = qtyLoss == null ? DtUtils.ZERO : qtyLoss;
            BigDecimal receivedQty = entry.getReceivedQty();
            receivedQty = receivedQty == null ? DtUtils.ZERO : receivedQty;
            BigDecimal receivedLostQty = entry.getReceivedLostQty();
            BigDecimal bigDecimal = receivedLostQty = receivedLostQty == null ? DtUtils.ZERO : receivedLostQty;
            if (entry.getCheckInDate() == null && outQtyActual.compareTo(DtUtils.ZERO) != 0 && qtyActual.compareTo(DtUtils.ZERO) != 0) {
                errorSeq.append(entry.getSeq()).append(" ");
            }
            if (outQtyActual.subtract(qtyActual).subtract(obeyQty).subtract(qtyLoss).compareTo(DtUtils.ZERO) != 0) {
                errorSeq1.append(entry.getSeq()).append(" ");
            }
            if (qtyActual.subtract(receivedQty).subtract(receivedLostQty).compareTo(DtUtils.ZERO) != 0) {
                errorSeq2.append(entry.getSeq()).append(" ");
            }
            if (outQtyActual.subtract(receivedQty).subtract(receivedLostQty).compareTo(DtUtils.ZERO) != 0) {
                errorSeq3.append(entry.getSeq()).append(" ");
            }
            if (outQtyActual.subtract(receivedQty).subtract(receivedLostQty).compareTo(DtUtils.ZERO) == 0) continue;
            errorSeq4.append(entry.getSeq()).append(" ");
        }
        if (errorSeq.length() > 0) {
            throw new DTException(DTException.PLEASECHECKIN, new Object[]{errorSeq.toString()});
        }
        DistributionTypeEnum distributionType = info.getDistributionType();
        if (DistributionTypeEnum.TRANSFER_TRANSPORTATION.equals((Object)distributionType)) {
            if (errorSeq1.length() > 0) {
                throw new DTException(DTException.QTYSNOTMATCH, new Object[]{errorSeq1.toString()});
            }
            if (errorSeq2.length() > 0) {
                throw new DTException(DTException.RECEIVEDQTYSNOTMATCH, new Object[]{errorSeq2.toString()});
            }
        } else if (DistributionTypeEnum.SALE_TRANSPORTATION.equals((Object)distributionType)) {
            if (errorSeq1.length() > 0) {
                throw new DTException(DTException.QTYSNOTMATCH, new Object[]{errorSeq1.toString()});
            }
        } else if (DistributionTypeEnum.PUR_SELF_TRANSPORTATION.equals((Object)distributionType)) {
            if (errorSeq4.length() > 0) {
                throw new DTException(DTException.RECEIVEDQTYSNOTMATCH, new Object[]{errorSeq4.toString()});
            }
        } else if (DistributionTypeEnum.SALERETURNS_TRANSPORTATION.equals((Object)distributionType) && errorSeq3.length() > 0) {
            throw new DTException(DTException.RECEIVEDQTYLOSTNOTMATCH, new Object[]{errorSeq3.toString()});
        }
    }

    @Override
    protected void _unClose(Context ctx, String pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        CarryBillInfo info = this.getCarryBillInfo(ctx, (IObjectPK)new ObjectUuidPK(pk));
        if (!BillBaseStatusEnum.CLOSED.equals((Object)info.getBaseStatus())) {
            throw new DTException(DTException.BILLNOTCLOSED);
        }
        IBOTRelation iBTPRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)pk));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)"0B95954B"));
        viewInfo.setFilter(filter);
        BOTRelationCollection relations = iBTPRelation.getCollection(viewInfo);
        if (relations != null && relations.size() > 0) {
            try {
                DtUtils.checkIsHaveDestBills(ctx, pk);
            }
            catch (Exception e1) {
                throw new DTException(DTException.HASDESTROADCOSTNOTCLOSE);
            }
            StringBuffer ids = new StringBuffer();
            int size = relations.size();
            for (int i = 0; i < size; ++i) {
                ids.append(relations.get(i).getDestObjectID() + ",");
            }
            viewInfo = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids.substring(0, ids.length() - 1), CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("baseStatus");
            viewInfo.setSelector(sic);
            IRoadCostBill iRoadCostBill = RoadCostBillFactory.getLocalInstance(ctx);
            CoreBaseCollection collection = iRoadCostBill.getCollection(viewInfo);
            int size2 = collection.size();
            for (int i = 0; i < size2; ++i) {
                RoadCostBillInfo destInfo = (RoadCostBillInfo)collection.get(i);
                if (BillBaseStatusEnum.AUDITED.equals((Object)destInfo.getBaseStatus())) {
                    throw new CarryBillException(CarryBillException.HASDESTRC);
                }
                iRoadCostBill.delete((IObjectPK)new ObjectUuidPK(destInfo.getId()));
            }
        }
        StringBuffer sqlHead = new StringBuffer();
        sqlHead.append("UPDATE T_DT_CarryBill SET FBaseStatus = ").append(4);
        sqlHead.append("WHERE FID = '").append(pk).append("'");
        StringBuffer sqlEntry = new StringBuffer();
        sqlEntry.append("UPDATE T_DT_CarryBillEntry SET FBaseStatus = ").append(4);
        sqlEntry.append("WHERE FParentID = '").append(pk).append("'");
        String[] updateSql = new String[]{sqlHead.toString(), sqlEntry.toString()};
        DBUtil.executeBatch((Context)ctx, (String[])updateSql);
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectValue objectValue) throws EASBizException, BOSException {
        CarryBillInfo info = (CarryBillInfo)objectValue;
        CarryBillEntryInfo entry = null;
        int n = info.getEntry().size();
        for (int i = 0; i < n; ++i) {
            entry = info.getEntry().get(i);
            entry.setApproWasBaseNum(DtUtils.ZERO);
            entry.setApproWasNum(DtUtils.ZERO);
            entry.setApproWasRatio(DtUtils.ZERO);
        }
        super._handleAfterTransform(ctx, action, objectValue);
    }

    @Override
    protected boolean _isRoadCost(Context ctx, String billId) throws BOSException, DTException {
        StringBuffer sbSql = new StringBuffer();
        sbSql.append(" select fid  from T_BOT_Relation where fdestobjectid = '").append(billId).append("'");
        sbSql.append(" and  fbotMappingid in ('jjtu6wEVEADgAAnWwKgSggRRIsQ=','836uMgEWEADgAj6BwKg9EgRRIsQ=')");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString());
        return rowSet.size() <= 0;
    }

    @Override
    protected Map _getApproveWasteRatio(Context ctx, MaterialInfo[] materials, DeliveryLineInfo[] deliveryLineInfo, SupplierInfo[] carrierInfo, TransportOrgUnitInfo transportOrgUnitInfo) throws BOSException, EASBizException {
        int size = materials.length;
        HashMap<String, BigDecimal> approveWasteRatioMap = new HashMap<String, BigDecimal>();
        if (transportOrgUnitInfo == null) {
            return approveWasteRatioMap;
        }
        String transportOrgUnitID = transportOrgUnitInfo.getId().toString();
        String[] groupIds = new String[size];
        for (int i = 0; i < size; ++i) {
            if (materials[i] == null || materials[i].getMaterialGroup() == null) continue;
            groupIds[i] = materials[i].getMaterialGroup().getId().toString();
        }
        String str1 = " select top 1 * from T_IN_ApprovedWasteRatio where FMaterialID = {0} and FTransportOrgID = {1} and FDeliveryLineID = {2} and FCarrierID = {3} and FIsUseable = 1 order by FAuditDate asc ";
        String str2 = " select top 1 * from T_IN_ApprovedWasteRatio where FMaterialID = {0} and FTransportOrgID = {1} and FDeliveryLineID = {2} and FCarrierID is null and FIsUseable = 1 order by FAuditDate asc ";
        String str3 = " select top 1 * from T_IN_ApprovedWasteRatio where FMaterialGroupId = {0} and FTransportOrgID = {1} and FDeliveryLineID = {2} and FCarrierID = {3} and FIsUseable = 1 order by FAuditDate asc ";
        String str4 = " select top 1 * from T_IN_ApprovedWasteRatio where FMaterialGroupId = {0} and FTransportOrgID = {1} and FDeliveryLineID = {2} and FCarrierID is null and FIsUseable = 1 order by FAuditDate asc ";
        ArrayList<String> sqlList = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            if (materials[i] != null && deliveryLineInfo[i] != null && carrierInfo[i] != null) {
                sqlList.add(MessageFormat.format(str1, "'" + materials[i].getId().toString() + "'", "'" + transportOrgUnitID + "'", "'" + deliveryLineInfo[i].getId().toString() + "'", "'" + carrierInfo[i].getId().toString() + "'"));
            }
            if (materials[i] != null && deliveryLineInfo[i] != null) {
                sqlList.add(MessageFormat.format(str2, "'" + materials[i].getId().toString() + "'", "'" + transportOrgUnitID + "'", "'" + deliveryLineInfo[i].getId().toString() + "'"));
            }
            if (groupIds[i] != null && deliveryLineInfo[i] != null && carrierInfo[i] != null) {
                sqlList.add(MessageFormat.format(str3, "'" + groupIds[i] + "'", "'" + transportOrgUnitID + "'", "'" + deliveryLineInfo[i].getId().toString() + "'", "'" + carrierInfo[i].getId().toString() + "'"));
            }
            if (groupIds[i] == null || deliveryLineInfo[i] == null) continue;
            sqlList.add(MessageFormat.format(str4, "'" + groupIds[i] + "'", "'" + transportOrgUnitID + "'", "'" + deliveryLineInfo[i].getId().toString() + "'"));
        }
        String materialID = "";
        String transportOrgID = "";
        String deliveryLineID = "";
        String carrierID = "";
        String materialGroupId = "";
        BigDecimal approWasRatio = DtUtils.ZERO;
        String id1 = "";
        String id2 = "";
        String id3 = "";
        String id4 = "";
        for (int i = 0; i < sqlList.size(); ++i) {
            id1 = "";
            id2 = "";
            id3 = "";
            id4 = "";
            materialID = "";
            transportOrgID = "";
            deliveryLineID = "";
            carrierID = "";
            materialGroupId = "";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlList.get(i).toString());
            try {
                while (rs.next()) {
                    if (rs.getString("FMaterialID") != null) {
                        materialID = rs.getString("FMaterialID");
                    }
                    if (rs.getString("FTransportOrgID") != null) {
                        transportOrgID = rs.getString("FTransportOrgID");
                    }
                    if (rs.getString("FDeliveryLineID") != null) {
                        deliveryLineID = rs.getString("FDeliveryLineID");
                    }
                    if (rs.getString("FCarrierID") != null) {
                        carrierID = rs.getString("FCarrierID");
                    }
                    if (rs.getString("FMaterialGroupId") != null) {
                        materialGroupId = rs.getString("FMaterialGroupId");
                    }
                    approWasRatio = rs.getBigDecimal("FApproWasRatio");
                    id1 = materialID + transportOrgID + deliveryLineID + carrierID;
                    id2 = materialID + transportOrgID + deliveryLineID;
                    id3 = materialGroupId + transportOrgID + deliveryLineID + carrierID;
                    id4 = materialGroupId + transportOrgID + deliveryLineID;
                    if (!approveWasteRatioMap.containsKey(id1)) {
                        approveWasteRatioMap.put(id1, approWasRatio);
                    }
                    if (!approveWasteRatioMap.containsKey(id2)) {
                        approveWasteRatioMap.put(id2, approWasRatio);
                    }
                    if (!approveWasteRatioMap.containsKey(id3)) {
                        approveWasteRatioMap.put(id3, approWasRatio);
                    }
                    if (approveWasteRatioMap.containsKey(id4)) continue;
                    approveWasteRatioMap.put(id4, approWasRatio);
                }
                continue;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return approveWasteRatioMap;
    }

    protected String getBatchMethodName(Context ctx, String name) throws BaseException {
        return name;
    }

    private void checkInfo4Submit(Context ctx, CarryBillInfo info) throws EASBizException {
        if (info == null) {
            return;
        }
        Locale locale = ctx.getLocale();
        if (info.getTransportOrgUnit() == null) {
            String errorMsg = ResourceBase.getString((String)CARRY_BILL_RESOURCE, (String)"transportOrgUnitCantNull", (Locale)locale);
            throw new CarryBillException(CarryBillException.COMMON, new Object[]{errorMsg});
        }
        if (info.getDistributionType() == null) {
            String errorMsg = ResourceBase.getString((String)CARRY_BILL_RESOURCE, (String)"DISTRIBUTION_TYPE_CANT_NULL", (Locale)locale);
            throw new CarryBillException(CarryBillException.COMMON, new Object[]{errorMsg});
        }
        if (info.getTransportType() == null) {
            String errorMsg = ResourceBase.getString((String)CARRY_BILL_RESOURCE, (String)"transportTypeCantNull", (Locale)locale);
            throw new CarryBillException(CarryBillException.COMMON, new Object[]{errorMsg});
        }
        if (info.getSendLine() == null) {
            String errorMsg = ResourceBase.getString((String)CARRY_BILL_RESOURCE, (String)"sendLineCantNull", (Locale)locale);
            throw new CarryBillException(CarryBillException.COMMON, new Object[]{errorMsg});
        }
    }

    private void checkEntry4Submit(Context ctx, CarryBillInfo info) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrg;
        MaterialInfo material;
        CarryBillEntryInfo entry;
        CarryBillEntryCollection entryColl = info.getEntry();
        Locale locale = ctx.getLocale();
        boolean isBotp = info.getSourceBillType() != null;
        boolean fromEditUi = Boolean.parseBoolean(info.get("FROM_EDIT_UI") == null ? null : info.get("FROM_EDIT_UI").toString());
        info.remove("FROM_EDIT_UI");
        if (entryColl == null || entryColl.size() == 0) {
            String errorMsg = ResourceBase.getString((String)CARRY_BILL_RESOURCE, (String)"entryCountMustPositive", (Locale)locale);
            throw new CarryBillException(CarryBillException.COMMON, new Object[]{errorMsg});
        }
        HashSet<String> storageIdSet = new HashSet<String>();
        HashSet<String> materialIdSet = new HashSet<String>();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            entry = entryColl.get(i);
            if (entry == null || entry.getMaterial() == null) {
                entryColl.remove(entry);
                --i;
                --size;
                continue;
            }
            material = entry.getMaterial();
            if (material.getId() != null) {
                materialIdSet.add(material.getId().toString());
            }
            if ((storageOrg = entry.getSendStorage()) == null || storageOrg.getId() == null) continue;
            storageIdSet.add(storageOrg.getId().toString());
        }
        if (entryColl.size() == 0) {
            String errorMsg = ResourceBase.getString((String)CARRY_BILL_RESOURCE, (String)"entryCountMustPositive", (Locale)locale);
            throw new CarryBillException(CarryBillException.COMMON, new Object[]{errorMsg});
        }
        Map materialPlanMap = SCMServerUtils.getMaterialPlanCollec((Context)ctx, materialIdSet, storageIdSet);
        for (int i = 0; i < entryColl.size(); ++i) {
            MaterialPlanInfo materialPlanInfo;
            entry = entryColl.get(i);
            if (entry == null) continue;
            int seq = entry.getSeq();
            if (entry.getUnit() == null) {
                String errorMsg = ResourceBase.getString((String)CARRY_BILL_RESOURCE, (String)"unitCantNull", (Locale)locale, (Object[])new Object[]{seq});
                throw new CarryBillException(CarryBillException.COMMON, new Object[]{errorMsg});
            }
            if (entry.getCarrier() == null) {
                String errorMsg = ResourceBase.getString((String)CARRY_BILL_RESOURCE, (String)"carrierCantNull", (Locale)locale, (Object[])new Object[]{seq});
                throw new CarryBillException(CarryBillException.COMMON, new Object[]{errorMsg});
            }
            if (!(fromEditUi || entry.getQty() != null && BigDecimal.ZERO.compareTo(entry.getQty()) != 0)) {
                String errorMsg = ResourceBase.getString((String)CARRY_BILL_RESOURCE, (String)"qtyMustPositive", (Locale)locale, (Object[])new Object[]{seq});
                throw new CarryBillException(CarryBillException.COMMON, new Object[]{errorMsg});
            }
            if (entry.getDetailLine() == null) {
                String errorMsg = ResourceBase.getString((String)CARRY_BILL_RESOURCE, (String)"detailLineCantNull", (Locale)locale, (Object[])new Object[]{seq});
                throw new CarryBillException(CarryBillException.COMMON, new Object[]{errorMsg});
            }
            DistributionTypeEnum distributionType = info.getDistributionType();
            if ((DistributionTypeEnum.PUR_SELF_TRANSPORTATION.equals((Object)distributionType) || DistributionTypeEnum.TRANSFER_TRANSPORTATION.equals((Object)distributionType)) && entry.getReceiveStorage() == null) {
                String errorMsg = ResourceBase.getString((String)CARRY_BILL_RESOURCE, (String)"RECEIVESTORAGECantNull", (Locale)locale, (Object[])new Object[]{seq});
                throw new CarryBillException(CarryBillException.COMMON, new Object[]{errorMsg});
            }
            if ((DistributionTypeEnum.SALE_TRANSPORTATION.equals((Object)distributionType) || DistributionTypeEnum.SALERETURNS_TRANSPORTATION.equals((Object)distributionType) || DistributionTypeEnum.TRANSFER_TRANSPORTATION.equals((Object)distributionType)) && entry.getSendStorage() == null) {
                String errorMsg = ResourceBase.getString((String)CARRY_BILL_RESOURCE, (String)"SENDSTOREORGCantNull", (Locale)locale, (Object[])new Object[]{seq});
                throw new CarryBillException(CarryBillException.COMMON, new Object[]{errorMsg});
            }
            material = entry.getMaterial();
            storageOrg = entry.getSendStorage();
            if (storageOrg == null || storageOrg.getId() == null || material.getId() == null || (materialPlanInfo = (MaterialPlanInfo)materialPlanMap.get(material.getId().toString() + storageOrg.getId().toString())) == null) continue;
            SCMServerUtils.checkProjectTrackIsNotNull((Context)ctx, (boolean)isBotp, (int)(i + 1), (MaterialPlanInfo)materialPlanInfo, (ProjectInfo)entry.getProject(), (TrackNumberInfo)entry.getTrackNumber());
        }
        CarryBillFeeEntryCollection feeEntryColl = info.getFeeEntry();
        if (feeEntryColl != null) {
            for (int i = feeEntryColl.size() - 1; i >= 0; --i) {
                CarryBillFeeEntryInfo feeEntryInfo = feeEntryColl.get(i);
                if (feeEntryInfo == null) continue;
                if (feeEntryInfo.getFeeItem() == null) {
                    throw new DTException(DTException.FEEITEMISNULL);
                }
                material = feeEntryInfo.getFeeMaterial();
                if (material == null || !materialIdSet.contains(material.getId().toString())) {
                    String errorMsg = ResourceBase.getString((String)CARRY_BILL_RESOURCE, (String)"MaterialIsNotInclude", (Locale)locale);
                    throw new CarryBillException(CarryBillException.COMMON, new Object[]{errorMsg});
                }
                if (feeEntryInfo.getFeeUnit() == null) {
                    String errorMsg = ResourceBase.getString((String)CARRY_BILL_RESOURCE, (String)"feeUnitCantNull", (Locale)locale);
                    throw new CarryBillException(CarryBillException.COMMON, new Object[]{errorMsg});
                }
                if (feeEntryInfo.getFeeQty() == null || BigDecimal.ZERO.compareTo(feeEntryInfo.getFeeQty()) == 0) {
                    String errorMsg = ResourceBase.getString((String)CARRY_BILL_RESOURCE, (String)"feeQtyMustPositive", (Locale)locale);
                    throw new CarryBillException(CarryBillException.COMMON, new Object[]{errorMsg});
                }
                if (feeEntryInfo.getFeePrice() == null || BigDecimal.ZERO.compareTo(feeEntryInfo.getFeePrice()) == 0) {
                    String errorMsg = ResourceBase.getString((String)CARRY_BILL_RESOURCE, (String)"feePriceMustPositive", (Locale)locale);
                    throw new CarryBillException(CarryBillException.COMMON, new Object[]{errorMsg});
                }
                if (feeEntryInfo.getFeeAmount() == null || BigDecimal.ZERO.compareTo(feeEntryInfo.getFeeAmount()) == 0) {
                    String errorMsg = ResourceBase.getString((String)CARRY_BILL_RESOURCE, (String)"feeAmountMustPositive", (Locale)locale);
                    throw new CarryBillException(CarryBillException.COMMON, new Object[]{errorMsg});
                }
                if (feeEntryInfo.getAgreePrice() == null || BigDecimal.ZERO.compareTo(feeEntryInfo.getAgreePrice()) == 0) {
                    String errorMsg = ResourceBase.getString((String)CARRY_BILL_RESOURCE, (String)"feeAgreePriceMustPositive", (Locale)locale);
                    throw new CarryBillException(CarryBillException.COMMON, new Object[]{errorMsg});
                }
                if (feeEntryInfo.getAgressAmount() == null || BigDecimal.ZERO.compareTo(feeEntryInfo.getAgressAmount()) == 0) {
                    String errorMsg = ResourceBase.getString((String)CARRY_BILL_RESOURCE, (String)"feeAgreeAmountMustPositive", (Locale)locale);
                    throw new CarryBillException(CarryBillException.COMMON, new Object[]{errorMsg});
                }
                if (feeEntryInfo.getFeeCarrier() != null) continue;
                String errorMsg = ResourceBase.getString((String)CARRY_BILL_RESOURCE, (String)"feeCarrierCantNull", (Locale)locale);
                throw new CarryBillException(CarryBillException.COMMON, new Object[]{errorMsg});
            }
        }
    }

    private void setDefaultValue4Submit(Context ctx, CarryBillInfo info) {
        CarryBillEntryCollection entryColl = info.getEntry();
        for (int i = 0; i < entryColl.size(); ++i) {
            CarryBillEntryInfo entry = entryColl.get(i);
            if (entry == null) continue;
            entry.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
            if (entry.getApproWasBaseNum() == null) {
                entry.setApproWasBaseNum(DtUtils.ZERO);
            }
            if (entry.getApproWasNum() == null) {
                entry.setApproWasNum(DtUtils.ZERO);
            }
            if (entry.getApproWasRatio() == null) {
                entry.setApproWasRatio(DtUtils.ZERO);
            }
            if (entry.getLot() != null) continue;
            entry.setMfg(null);
            entry.setExp(null);
        }
    }
}

