/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.IWriteBackHandler;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.WriteBackHandlerFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.dt.DtBillBaseInfo;
import com.kingdee.eas.scm.im.dt.app.AbstractDtBillBaseControllerBean;
import com.kingdee.eas.scm.im.dt.util.DtUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class DtBillBaseControllerBean
extends AbstractDtBillBaseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.dt.app.DtBillBaseControllerBean");

    protected OrgUnitInfo getMainBizOrgUnit(Context ctx, CoreBillBaseInfo model) {
        if (model == null) {
            return null;
        }
        DtBillBaseInfo info = (DtBillBaseInfo)model;
        return info.getTransportOrgUnit();
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.setNullToDefault(ctx, model);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DtBillBaseInfo info = (DtBillBaseInfo)model;
        this.setNullToDefault(ctx, model);
        IObjectPK pk = super._submit(ctx, model);
        String orgUnitID = info.getTransportOrgUnit().getId().toString();
        String billTypeID = info.getBillType().getId().toString();
        boolean isAutoAudit = false;
        ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
        String strAutoAudit = scmParam.getParamByBillTypeID("SCM_Submit_01", 24, orgUnitID, billTypeID);
        if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().equalsIgnoreCase("1")) {
            isAutoAudit = true;
        }
        if (isAutoAudit) {
            ServiceStateManager.LoopSnatpot ls = new ServiceStateManager.LoopSnatpot(ServiceStateManager.getInstance());
            ServiceStateManager.getInstance().reSetServiceState(ls);
            this.passAudit(ctx, pk, (CoreBillBaseInfo)info);
            ServiceStateManager.getInstance().reSetServiceState(ls);
        }
        return pk;
    }

    protected void initBotpData(Context ctx, IObjectValue model) throws EASBizException, BOSException {
    }

    protected void setNullToDefault(Context ctx, IObjectValue model) {
        IObjectCollection entrys;
        if (model == null) {
            return;
        }
        String[] headDecimalFields = this.getHeadDecimalFields();
        if (headDecimalFields != null) {
            for (int i = 0; i < headDecimalFields.length; ++i) {
                if (model.get(headDecimalFields[i]) != null) continue;
                model.put(headDecimalFields[i], (Object)DtUtils.ZERO);
            }
        }
        if ((entrys = (IObjectCollection)model.get("entry")) == null) {
            return;
        }
        String[] entryDecimalFields = this.getEntryDecimalFields();
        if (entryDecimalFields != null) {
            int n = entrys.size();
            for (int i = 0; i < n; ++i) {
                IObjectValue entry = entrys.getObject(i);
                for (int j = 0; j < entryDecimalFields.length; ++j) {
                    if (entry.get(entryDecimalFields[j]) != null) continue;
                    entry.put(entryDecimalFields[j], (Object)DtUtils.ZERO);
                }
            }
        }
    }

    protected String[] getHeadDecimalFields() {
        return null;
    }

    protected String[] getEntryDecimalFields() {
        return null;
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._audit(ctx, pk);
        this.passAudit(ctx, pk, null);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        DtBillBaseInfo info = (DtBillBaseInfo)this._getValue(ctx, pk);
        this.checkPassAduit(ctx, info);
        this.isSamePerson4Audit(ctx, info);
        super._passAudit(ctx, pk, (IObjectValue)info);
        this.updateAuditStatus(ctx, (IObjectValue)info);
        this.afterPassAudit(ctx, pk, (IObjectValue)info);
        SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)model, (BatchActionEnum)BatchActionEnum.AUDIT);
    }

    protected void checkPassAduit(Context ctx, DtBillBaseInfo dtBill) throws EASBizException, BOSException {
        if (dtBill.getBaseStatus() != null && dtBill.getBaseStatus().getValue() != 2) {
            throw new SCMBillException(SCMBillException.CHECKSUBMITNOTOK, new Object[]{dtBill.getNumber(), ""});
        }
    }

    public void updateAuditStatus(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        String mainTable = this.getMainTableName(ctx, model);
        if (mainTable == null) {
            throw new BOSException("main table name is null!");
        }
        String detailTable = this.getDetailTableName(ctx, model);
        if (detailTable == null) {
            throw new BOSException("detail table name is null!");
        }
        DtBillBaseInfo dtBill = (DtBillBaseInfo)model;
        Connection conn = null;
        PreparedStatement stmtHead = null;
        PreparedStatement stmtEntry = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE ");
            sql.append(mainTable);
            sql.append(" SET FAuditTime = ?, FAuditorID = ? , FBaseStatus = ? WHERE FID = ? ");
            stmtHead = conn.prepareStatement(sql.toString());
            Date now = new Date();
            stmtHead.setTimestamp(1, new Timestamp(now.getTime()));
            UserInfo aUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            stmtHead.setString(2, aUserInfo.getId().toString());
            stmtHead.setInt(3, 4);
            stmtHead.setString(4, dtBill.getId().toString());
            stmtHead.execute();
            sql = new StringBuffer();
            sql.append("UPDATE ");
            sql.append(detailTable);
            sql.append(" SET FAssociateQty = FBaseQty, FBaseStatus = ? WHERE FParentID = ? ");
            stmtEntry = conn.prepareStatement(sql.toString());
            stmtEntry.setInt(1, 4);
            stmtEntry.setString(2, dtBill.getId().toString());
            stmtEntry.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmtHead);
                SQLUtils.cleanup(stmtEntry, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmtHead);
        SQLUtils.cleanup((Statement)stmtEntry, (Connection)conn);
    }

    protected void afterPassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        this.updateMe(ctx, pk, model, BizActionEnum.AUDIT);
        this.writeBack(ctx, pk, model, BizActionEnum.AUDIT);
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._unAudit(ctx, pk);
        this._unpassAudit(ctx, pk, null);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        DtBillBaseInfo info = (DtBillBaseInfo)this._getValue(ctx, pk);
        this.checkUnPassAduit(ctx, info);
        this.isSamePerson4UnAudit(ctx, info);
        SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)model, (BatchActionEnum)BatchActionEnum.UNAUDIT);
        this.updateUnAuditStatus(ctx, (IObjectValue)info);
        this.afterUnPassAudit(ctx, pk, (IObjectValue)info);
    }

    protected void checkUnPassAduit(Context ctx, DtBillBaseInfo dtBill) throws EASBizException, BOSException {
        if (dtBill.getBaseStatus() != null && dtBill.getBaseStatus().getValue() != 4) {
            throw new SCMBillException(SCMBillException.CHECK_UNAUDIT, new Object[]{dtBill.getNumber(), ""});
        }
        this.checkParamCanUnAudit(ctx, dtBill);
        DtUtils.checkIsHaveDestBills(ctx, dtBill.getId().toString());
    }

    protected void checkParamCanUnAudit(Context ctx, DtBillBaseInfo info) throws SCMBillException, EASBizException, BOSException {
        int orgType;
        String orgUnitID = info.getTransportOrgUnit().getId().toString();
        if (!SCMServerUtils.isUnAuditInParam((Context)ctx, (SCMBillBaseInfo)info, (String)orgUnitID, (int)(orgType = 24))) {
            throw new SCMBillException(SCMBillException.ISUNAUDITINPARAM);
        }
    }

    public void updateUnAuditStatus(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        String tableName = this.getMainTableName(ctx, model);
        String detailTable = this.getDetailTableName(ctx, model);
        if (tableName == null) {
            throw new BOSException("table name is null!");
        }
        if (detailTable == null) {
            throw new BOSException("detail table name is null!");
        }
        DtBillBaseInfo dtBill = (DtBillBaseInfo)model;
        Connection conn = null;
        PreparedStatement stmtHead = null;
        PreparedStatement stmtEntry = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE ");
            sql.append(tableName);
            sql.append(" SET FAuditTime = ?, FAuditorID = ?, FBaseStatus = ? WHERE FID = ?");
            stmtHead = conn.prepareStatement(sql.toString());
            stmtHead.setTimestamp(1, null);
            stmtHead.setString(2, null);
            stmtHead.setInt(3, 1);
            stmtHead.setString(4, dtBill.getId().toString());
            stmtHead.execute();
            sql = new StringBuffer();
            sql.append("UPDATE ");
            sql.append(detailTable);
            sql.append(" SET FAssociateQty = 0, FBaseStatus = ? WHERE FParentID = ? ");
            stmtEntry = conn.prepareStatement(sql.toString());
            stmtEntry.setInt(1, 1);
            stmtEntry.setString(2, dtBill.getId().toString());
            stmtEntry.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmtHead);
                SQLUtils.cleanup(stmtEntry, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmtHead);
        SQLUtils.cleanup((Statement)stmtEntry, (Connection)conn);
    }

    protected void afterUnPassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        this.updateMe(ctx, pk, model, BizActionEnum.UNAUDIT);
        this.writeBack(ctx, pk, model, BizActionEnum.UNAUDIT);
    }

    protected void updateMe(Context ctx, IObjectPK pk, IObjectValue model, BizActionEnum action) throws EASBizException, BOSException {
    }

    protected void writeBack(Context ctx, IObjectPK pk, IObjectValue model, BizActionEnum action) throws EASBizException, BOSException {
        DtBillBaseInfo info = (DtBillBaseInfo)model;
        try {
            String entryTableName = this.getDetailTableName(ctx, model);
            StringBuffer sql = new StringBuffer();
            sql.append("select FSourceBillId, FCoreBillId from ");
            sql.append(entryTableName);
            sql.append(" where FParentID = ? group by FSourceBillId, FCoreBillId");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pk.toString()});
            int rsSize = rs.size();
            String[] srcIdArr = new String[rsSize];
            String[][] idList = new String[rsSize][2];
            int i = 0;
            while (rs.next()) {
                idList[i][0] = rs.getString(1);
                idList[i][1] = rs.getString(2);
                srcIdArr[i] = idList[i][0];
                ++i;
            }
            IWriteBackHandler[] handlers = WriteBackHandlerFactory.getInstance((BOSObjectType)info.getBOSType(), (String[])srcIdArr);
            for (int j = 0; j < handlers.length && handlers[j] != null; ++j) {
                handlers[j].handle(ctx, action, new String[]{pk.toString()}, idList);
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ObjectUuidPK pk2 = new ObjectUuidPK(BOSUuid.read((String)pk.toString()));
        DtBillBaseInfo objVal = (DtBillBaseInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(pk2.getObjectType(), pk);
        if (objVal != null) {
            DtBillBaseInfo aDtBillBaseInfo = objVal;
            ICompanyOrgUnit icou = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            if (aDtBillBaseInfo.getCompanyOrgUnit() != null) {
                CompanyOrgUnitInfo aCompanyOrgUnitInfo = icou.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(aDtBillBaseInfo.getCompanyOrgUnit().getId()));
                return aCompanyOrgUnitInfo;
            }
        }
        return null;
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        if (collection == null || collection.size() == 0) {
            return;
        }
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            IObjectValue model = collection.getObject(i);
            this.initBotpData(ctx, model);
        }
    }

    public String getParamCon4Audit() {
        return "CARRY004";
    }

    public String getParamCon4UnAudit() {
        return "CARRY005";
    }
}

