/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.dt.BillStatusEnum;
import com.kingdee.eas.scm.im.dt.TransportTypeEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.util.enums.Enum;
import java.util.List;
import java.util.Locale;

public class DtDataImportUtils {
    private static final String Locale_en = "l1";
    private static final String Locale_zh = "l2";
    private static final String Locale_tw = "l3";
    private static String WAREHSMANAGERESOURCE = "com.kingdee.eas.scm.im.inv.WarehsManageResource";
    private static String DTDATAIMPORTRESOURCE = "com.kingdee.eas.scm.im.dt.DTDataImportResource";

    public static String getWarehsManageResource(Context ctx, String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return SCMUtils.getResource((String)WAREHSMANAGERESOURCE, (String)strKey, (Context)ctx);
    }

    public static String getDTDataImportResource(Context ctx, String strKey) {
        if (StringUtil.isEmptyString((String)strKey)) {
            return null;
        }
        return SCMUtils.getResource((String)DTDATAIMPORTRESOURCE, (String)strKey, (Context)ctx);
    }

    public static EntityViewInfo getFilter(String number) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    public static BillStatusEnum getStatusEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "StatusNotNull"));
        }
        if (DtDataImportUtils.enumCompareByAlias(value, (Enum)BillStatusEnum.save)) {
            return BillStatusEnum.save;
        }
        if (DtDataImportUtils.enumCompareByAlias(value, (Enum)BillStatusEnum.enable)) {
            return BillStatusEnum.enable;
        }
        if (DtDataImportUtils.enumCompareByAlias(value, (Enum)BillStatusEnum.disable)) {
            return BillStatusEnum.disable;
        }
        throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "StatusError"));
    }

    public static TransportTypeEnum getTransportTypeEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "TransportTypeNotNull"));
        }
        List transportTypeEnums = TransportTypeEnum.getEnumList();
        for (TransportTypeEnum transportTypeEnum : transportTypeEnums) {
            if (!transportTypeEnum.getAlias(ctx.getLocale()).equals(value)) continue;
            return transportTypeEnum;
        }
        throw new TaskExternalException(DtDataImportUtils.getDTDataImportResource(ctx, "TransportTypeError"));
    }

    public static boolean enumCompareByAlias(String value, Enum enumValue) {
        return value.equals(enumValue.getAlias(new Locale(Locale_zh))) || value.equals(enumValue.getAlias(new Locale(Locale_tw)));
    }
}

