/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.dt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.dt.CarryBillEntryCollection;
import com.kingdee.eas.scm.im.dt.CarryBillEntryInfo;
import com.kingdee.eas.scm.im.dt.CarryBillFactory;
import com.kingdee.eas.scm.im.dt.CarryBillInfo;
import com.kingdee.eas.scm.im.dt.DTException;
import com.kingdee.eas.scm.im.dt.HandleModeEnum;
import com.kingdee.eas.scm.im.dt.RoadCostBillCollection;
import com.kingdee.eas.scm.im.dt.RoadCostBillEntryInfo;
import com.kingdee.eas.scm.im.dt.RoadCostBillFactory;
import com.kingdee.eas.scm.im.dt.RoadCostBillInfo;
import com.kingdee.eas.scm.im.dt.app.AbstractRoadCostBillControllerBean;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class RoadCostBillControllerBean
extends AbstractRoadCostBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.dt.app.RoadCostBillControllerBean");
    private static final BigDecimal zero = BigDecimal.ZERO;

    @Override
    protected void _audit(Context ctx, String[] ids) throws BOSException, EASBizException {
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        super._passAudit(ctx, pk, model);
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        super._unpassAudit(ctx, pk, model);
    }

    @Override
    protected void initBotpData(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        RoadCostBillInfo info = (RoadCostBillInfo)model;
        info.setBillType(SCMServerUtils.getBillType((String)"E4Anb3NGxUm/1BMRhRWcSEY+1VI="));
        if (info.getEntry() == null) {
            return;
        }
        RoadCostBillEntryInfo entry = null;
        MaterialInfo material = null;
        MeasureUnitInfo unit = null;
        MeasureUnitInfo baseUnit = null;
        MeasureUnitInfo asstUnit = null;
        HashMap<String, String> compensateDutyorMap = new HashMap<String, String>();
        StringBuffer carryBillEntryIds = new StringBuffer();
        for (int i = 0; i < info.getEntry().size(); ++i) {
            SelectorItemCollection sic;
            StockTransferBillEntryInfo coreEntryInfo;
            ObjectUuidPK pk;
            entry = info.getEntry().get(i);
            if (HandleModeEnum.TRANSPORTER_DUTY.equals((Object)entry.getHandleMode()) && entry.getCarryBillEntry() != null) {
                carryBillEntryIds.append("'").append(entry.getCarryBillEntry().getId().toString()).append("',");
            }
            if (entry.getCoreBillType() == null) continue;
            if ("50957179-0105-1000-e003-3152c0a812fd463ED552".equals(entry.getCoreBillType().getId().toString())) {
                pk = new ObjectUuidPK(entry.getCoreBillEntryId());
                coreEntryInfo = null;
                sic = new SelectorItemCollection();
                sic.add("price");
                coreEntryInfo = StockTransferBillEntryFactory.getLocalInstance(ctx).getStockTransferBillEntryInfo((IObjectPK)pk, sic);
                entry.setHandlePrice(coreEntryInfo.getPrice());
                entry.setHandleAmount(entry.getRoadCostQty().multiply(coreEntryInfo.getPrice()));
            }
            if (!"50957179-0105-1000-e008-8152c0a812fd463ED552".equals(entry.getCoreBillType().getId().toString())) continue;
            pk = new ObjectUuidPK(entry.getCoreBillEntryId());
            coreEntryInfo = null;
            sic = new SelectorItemCollection();
            sic.add("taxPrice");
            coreEntryInfo = SaleReturnsEntryFactory.getLocalInstance((Context)ctx).getSaleReturnsEntryInfo((IObjectPK)pk, sic);
            entry.setHandlePrice(coreEntryInfo.getTaxPrice());
            entry.setHandleAmount(entry.getRoadCostQty().multiply(coreEntryInfo.getTaxPrice()));
        }
        IRowSet rs = null;
        try {
            if (carryBillEntryIds.length() > 0) {
                StringBuffer sql = new StringBuffer();
                sql.append("select carryBillEntry.fid as carryBillEntry, customer.fid as customer from T_BD_Customer customer ");
                sql.append("inner join T_BD_Supplier supplier on customer.fbizanalysiscodeid = supplier.fbizanalysiscodeid ");
                sql.append("inner join T_DT_CarryBillEntry carryBillEntry on supplier.fid = carryBillEntry.fcarrierid ");
                sql.append("where carryBillEntry.fid in (").append(carryBillEntryIds.substring(0, carryBillEntryIds.length() - 1)).append(")");
                String sqlStr = sql.toString();
                rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
                while (rs.next()) {
                    compensateDutyorMap.put(rs.getString("carryBillEntry"), rs.getString("customer"));
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        StringBuffer lineMsg = new StringBuffer();
        for (int i = 0; i < info.getEntry().size(); ++i) {
            entry = info.getEntry().get(i);
            material = entry.getMaterial();
            if (material == null) continue;
            unit = entry.getUnit();
            baseUnit = entry.getBaseUnit();
            asstUnit = entry.getAssistUnit();
            BigDecimal roadCostQty = entry.getRoadCostQty();
            if (roadCostQty == null) {
                entry.setRoadCostQty(zero);
            }
            entry.setQty(roadCostQty);
            if (baseUnit != null) {
                BigDecimal baseQty = SCMServerUtils.getUnitQty((Context)ctx, (BigDecimal)roadCostQty, (String)material.getId().toString(), (String)unit.getId().toString(), (String)baseUnit.getId().toString());
                entry.setBaseQty(baseQty);
            }
            if (asstUnit != null) {
                BigDecimal asstQty = SCMServerUtils.getUnitQty((Context)ctx, (BigDecimal)roadCostQty, (String)material.getId().toString(), (String)unit.getId().toString(), (String)asstUnit.getId().toString());
                entry.setAssistQty(asstQty);
            }
            String sign = ResourceBase.getString((String)"com.kingdee.eas.scm.im.SCM_IMResource", (String)"Sign", (Locale)ctx.getLocale());
            if (!HandleModeEnum.TRANSPORTER_DUTY.equals((Object)entry.getHandleMode()) || entry.getRoadCostQty().compareTo(zero) <= 0) continue;
            String customerId = (String)compensateDutyorMap.get(entry.getCarryBillEntry().getId().toString());
            if (customerId != null) {
                CustomerInfo compensateDutyor = new CustomerInfo();
                compensateDutyor.setId(BOSUuid.read((String)customerId));
                entry.setCompensateDutyor(compensateDutyor);
                continue;
            }
            lineMsg.append(entry.getCarryBillEntry().getSeq()).append(sign);
        }
        if (lineMsg.length() > 0) {
            throw new InvBizException(InvBizException.SUPPLIER_NOT_CUSTOMER, new Object[]{lineMsg.substring(0, lineMsg.length() - 1)});
        }
    }

    @Override
    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            RoadCostBillInfo info = (RoadCostBillInfo)collection.getObject(i);
            if (!this.isBotpBill(info, "18b7FpLNSrmaD8V9SPcOhkY+1VI=")) continue;
            for (int j = 0; j < info.getEntry().size(); ++j) {
                RoadCostBillEntryInfo entry = info.getEntry().get(j);
                BigDecimal qty = entry.getQty();
                BigDecimal RoadCostQty = entry.getRoadCostQty();
                if (RoadCostQty.compareTo(qty) > 0) {
                    entry.setRoadCostQty(RoadCostQty.subtract(qty));
                } else if (RoadCostQty.compareTo(zero) < 0) {
                    entry.setRoadCostQty(RoadCostQty);
                } else {
                    info.getEntry().removeObject(j);
                    --j;
                }
                if (entry.getRoadCostQty() != null) {
                    if (entry.getHandlePrice() == null) {
                        entry.setHandlePrice(zero);
                    }
                    entry.setHandleAmount(entry.getRoadCostQty().multiply(entry.getHandlePrice()));
                }
                entry.setQty(null);
            }
        }
        super._handleAfterTransform(ctx, action, collection);
    }

    private void checkIsBuildedBill(Context ctx, IObjectCollection collection) throws BOSException, EASBizException {
        if (collection == null || collection.size() == 0) {
            return;
        }
        RoadCostBillInfo info = null;
        ArrayList<String> ids = new ArrayList<String>();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            info = (RoadCostBillInfo)collection.getObject(i);
            if (info.getSourceBillId() == null) continue;
            ids.add(info.getSourceBillId());
        }
        if (ids.size() <= 0) {
            return;
        }
        StringBuffer sb2 = new StringBuffer();
        sb2.append(" select t1.fnumber as number from t_dt_carrybill t1 inner join t_dt_carrybillentry t2 on t1.fid = t2.fparentid  ");
        sb2.append(" inner join T_BOT_Relation t3 on t1.fid = FSrcObjectID  ");
        sb2.append(" where t1.fid in ( " + InvServerUtils.getSqlIdsStrForColl(ids) + " ) and  t3.FDestEntityID='0B95954B' ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb2.toString());
        try {
            StringBuffer number = new StringBuffer();
            int i = 0;
            while (rowSet.next()) {
                if (i > 0) {
                    number.append(",");
                }
                number.append(rowSet.getString("number"));
                ++i;
            }
            if (number.length() > 0) {
                number.append(" ");
                throw new DTException(DTException.ISBUILDEDBILL, new Object[]{number.toString()});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void isRoadCost(String billId, RoadCostBillEntryInfo entry) throws BOSException, DTException {
        CarryBillInfo carryBillInfo = null;
        CarryBillEntryCollection entryColl = new CarryBillEntryCollection();
        CarryBillEntryInfo entryInfo = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            carryBillInfo = CarryBillFactory.getRemoteInstance().getCarryBillInfo(" select mainCarrier.id, distributionType, entry.material.id where id = '" + billId + "'");
            String billKey = carryBillInfo.getMainCarrier().getId().toString() + carryBillInfo.getDistributionType().toString();
            if (map.size() > 0 && !map.containsKey(billKey)) {
                throw new DTException(DTException.NOTTOSUM);
            }
            map.put(billKey, carryBillInfo);
            entryColl.addCollection(carryBillInfo.getEntry());
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        map.clear();
        for (int j = 0; j < entryColl.size(); ++j) {
            Set<CarryBillEntryInfo> set0;
            entryInfo = entryColl.get(j);
            if (entryInfo.getMaterial() == null) continue;
            String key = "";
            try {
                key = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(entryInfo.getMaterial().getId())).getBaseUnit().getId().toString() + entryInfo.getMaterial().getId().toString();
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            if (map.size() > 0 && map.containsKey(key)) {
                set0 = (Set)map.get(key);
                set0.add(entryInfo);
                map.put(key, set0);
                continue;
            }
            set0 = new HashSet<CarryBillEntryInfo>();
            set0.add(entryInfo);
            map.put(key, set0);
        }
        Set keySet = map.keySet();
        Iterator itr = keySet.iterator();
        while (itr.hasNext()) {
            Set valueSet = (Set)map.get(itr.next());
            Iterator it = valueSet.iterator();
            BigDecimal appwa = BigDecimal.ZERO;
            BigDecimal qtyLoss = BigDecimal.ZERO;
            BigDecimal receivedLostQty = BigDecimal.ZERO;
            while (it.hasNext()) {
                CarryBillEntryInfo carryEntryInfo = (CarryBillEntryInfo)it.next();
                qtyLoss = qtyLoss.add(carryEntryInfo.getQtyLoss() == null ? BigDecimal.ZERO : carryEntryInfo.getQtyLoss());
                receivedLostQty = receivedLostQty.add(carryEntryInfo.getReceivedLostQty() == null ? BigDecimal.ZERO : carryEntryInfo.getReceivedLostQty());
                appwa = appwa.add(carryEntryInfo.getApproWasNum());
            }
            if (qtyLoss.compareTo(zero) > 0 && qtyLoss.subtract(appwa).compareTo(zero) > 0) {
                entry.setQty(qtyLoss.subtract(appwa));
            }
            if (qtyLoss.compareTo(zero) >= 0) continue;
        }
    }

    @Override
    protected String[] getEntryDecimalFields() {
        return new String[]{"qty", "baseQty", "assistQty", "roadCostQty", "handlePrice", "handleAmount", "totalArQty", "totalArAmount"};
    }

    @Override
    protected void _close(Context ctx, String pk) throws BOSException, EASBizException {
    }

    protected void setNewNumberWhenBotpBill(Context ctx, SCMBillBaseInfo info) throws BOSException, EASBizException {
        if (info.getNumber() == null || info.getNumber().trim().length() == 0) {
            RoadCostBillInfo model = (RoadCostBillInfo)info;
            String soureBillNumber = model.getEntry().get(0).getSourceBillNumber();
            if (this.checkHasDupNumber(soureBillNumber + "*", ctx)) {
                info.setNumber(soureBillNumber + "**");
            } else {
                info.setNumber(soureBillNumber + "*");
            }
        }
    }

    private boolean checkHasDupNumber(String number, Context ctx) throws BOSException, EASBizException {
        RoadCostBillCollection collection = RoadCostBillFactory.getLocalInstance(ctx).getRoadCostBillCollection("where number ='" + number + "'");
        return collection != null && collection.size() > 0 && !StringUtil.isEmptyString((String)collection.get(0).getId().toString());
    }
}

