/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.etl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.scm.im.etl.AbstractETL_InvTrueOverReateFacadeControllerBean;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class ETL_InvTrueOverReateFacadeControllerBean
extends AbstractETL_InvTrueOverReateFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.etl.ETL_InvTrueOverReateFacadeControllerBean");

    @Override
    protected void _updateMaterial(Context ctx) throws BOSException {
        Connection con = null;
        Statement st = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            st = con.createStatement();
            StringBuffer buffer = new StringBuffer();
            buffer.append("TRUNCATE TABLE DW_Dim_BD_Material");
            st.addBatch(buffer.toString());
            buffer.setLength(0);
            buffer.append("INSERT DW_Dim_BD_Material(FID,FNUMBER,FMATERIALGROUPID,FName_L1,FName_L2,FName_L3,");
            buffer.append("FDescription_L1,FDescription_L2,FDescription_L3)");
            buffer.append("\n SELECT FID,FNUMBER,FMaterialGroupID,FName_L1,FName_L2,FName_L3,");
            buffer.append("FDescription_L1,FDescription_L2,FDescription_L3 ");
            buffer.append(" FROM T_BD_MATERIAL ");
            st.addBatch(buffer.toString());
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)con);
    }

    @Override
    protected void _updateMaterialGroup(Context ctx) throws BOSException {
        Connection con = null;
        Statement st = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            st = con.createStatement();
            StringBuffer buffer = new StringBuffer();
            buffer.append("TRUNCATE TABLE DW_Dim_BD_MaterialGroup");
            st.addBatch(buffer.toString());
            buffer.setLength(0);
            buffer.append("INSERT DW_Dim_BD_MaterialGroup(FID,FNUMBER,FName_L1,FName_L2,FName_L3,");
            buffer.append("FDescription_L1,FDescription_L2,FDescription_L3,FLongNumber)");
            buffer.append("\n SELECT FID,FNUMBER,FName_L1,FName_L2,FName_L3,");
            buffer.append("FDescription_L1,FDescription_L2,FDescription_L3,FLongNumber ");
            buffer.append(" FROM T_BD_MaterialGroup ");
            st.addBatch(buffer.toString());
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)con);
    }

    @Override
    protected void _updateStorage(Context ctx) throws BOSException {
        Connection con = null;
        Statement st = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            st = con.createStatement();
            StringBuffer buffer = new StringBuffer();
            buffer.append("TRUNCATE TABLE DW_DIM_ORG_STORAGE");
            st.addBatch(buffer.toString());
            buffer.setLength(0);
            buffer.append("INSERT DW_DIM_ORG_STORAGE(FID,FNUMBER,FName_L1,FName_L2,FName_L3,");
            buffer.append("FDescription_L1,FDescription_L2,FDescription_L3)");
            buffer.append("\n SELECT FID,FNUMBER,FName_L1,FName_L2,FName_L3,");
            buffer.append("FDescription_L1,FDescription_L2,FDescription_L3 ");
            buffer.append(" FROM T_ORG_STORAGE ");
            st.addBatch(buffer.toString());
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)con);
    }

    @Override
    protected void _updateTurnOverFactTable(Context ctx) throws BOSException {
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            st = con.createStatement();
            int updateStrategy = 0;
            int beginPeriod = 0;
            int beginYear = 0;
            StringBuffer buffer = new StringBuffer();
            buffer.append("TRUNCATE TABLE DW_FACT_TURNOVERRATE");
            st.execute(buffer.toString());
            String upateFactSql = this.getInsertFactTableSQL(updateStrategy, beginYear, beginPeriod);
            st.addBatch(upateFactSql);
            st.addBatch(this.getUpdateIssueSQL(updateStrategy, beginYear, beginPeriod));
            st.addBatch(this.getupdateTurnOverRateSql());
            st.addBatch(this.getUpdateMaterialGroup());
            st.addBatch(this.getUpdateIndustryID());
            st.executeBatch();
            st.clearBatch();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)st, (Connection)con);
        }
    }

    @Override
    protected void _updatePeriod(Context ctx) throws BOSException {
        Connection con = null;
        Statement st = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            st = con.createStatement();
            StringBuffer buffer = new StringBuffer();
            buffer.append("TRUNCATE TABLE DW_Dim_BD_Period");
            st.addBatch(buffer.toString());
            buffer.setLength(0);
            buffer.append("INSERT INTO DW_Dim_BD_Period(FID,FNUMBER,FYEAR,FPERIOD,FQUARTER,FBEGINDATE,FENDDATE,FIsAdjustPeriod,FTypeID,FDESCRIPTION_L2)");
            buffer.append("\n  SELECT FID,FNUMBER,FPERIODYEAR,FPERIODNUMBER,FPERIODQUARTER,FBeginDate,FENDDATE,FIsAdjustPeriod,FTypeID");
            buffer.append(",CONCAT(CONCAT(TOCHAR(FPERIODYEAR),CONCAT('" + EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"13_ETL_InvTrueOverReateFacadeControllerBean") + "',TOCHAR(FPERIODNUMBER))),'" + EASResource.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"13_ETL_InvTrueOverReateFacadeControllerBean_1") + "') FROM T_BD_PERIOD");
            st.addBatch(buffer.toString());
            st.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)con);
    }

    private String getUpdateStrategySQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT FUPDATASTRATEGY,FYEAR,FPERIOD FROM DW_PARAM_TURNOVERRATE");
        return buffer.toString();
    }

    private String getInsertFactTableSQL(int updateStrategy, int year, int period) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO DW_FACT_TURNOVERRATE(FCOMPANYORGUNITID,FSTORAGEORGUNITID,FMATERIALID,");
        buffer.append("FPERIODID,FPERIODBEGINAMOUNT,FPERIODENDAMOUNT)");
        buffer.append("\n  SELECT T1.FCOMPANYORGUNITID,T1.FSTORAGEORGUNITID,T1.FMATERIALID,T2.PERIODID ,SUM(FPeriodBeginBalance) as FPeriodBeginBalance,SUM(FPERIODENDBALANCE) FPERIODENDBALANCE");
        buffer.append("\n FROM T_IM_INVENTORYBALANCE T1 INNER JOIN ( ");
        buffer.append("\n SELECT T11.FID AS PERIODID,T11.FYEAR AS FPERIODYEAR ,T11.FPERIOD AS FPERIODNUMBER,T12.FID AS FCOMPNAYORGUNITID ");
        buffer.append("\n  FROM DW_Dim_BD_Period T11    INNER JOIN DW_DIM_ORG_Company T12 ON T11.FTYPEID = T12.FACCOUNTPERIODID");
        buffer.append("\n  )  T2 ");
        buffer.append("\n ON T1.FCOMPANYORGUNITID = T2.FCOMPNAYORGUNITID");
        buffer.append("\n AND T1.FYEAR = T2.FPERIODYEAR AND T1.FPERIOD = T2.FPERIODNUMBER");
        buffer.append("\n inner join T_BD_SystemStatusCtrol T_BD_SystemStatusCtrol");
        buffer.append("\n on T1.FCOMPANYORGUNITID = T_BD_SystemStatusCtrol.FCompanyID");
        buffer.append("\n inner join T_BD_Period currentPeriod");
        buffer.append("\n on T_BD_SystemStatusCtrol.FCURRENTPERIODID = currentPeriod.FID");
        buffer.append("\n where T1.FYEAR < currentPeriod.FPERIODYEAR or ");
        buffer.append("\n (T1.FYEAR = currentPeriod.FPERIODYEAR and T1.FPERIOD < currentPeriod.FPERIODNUMBER)");
        if (updateStrategy == 1) {
            buffer.append("\n WHERE (T1.FYEAR =" + year);
            buffer.append(" AND T1.FPERIOD > " + period);
            buffer.append(") OR T1.FYEAR >" + year);
        }
        buffer.append("\n GROUP BY FCOMPANYORGUNITID,FSTORAGEORGUNITID,FMATERIALID,T2.PERIODID");
        return buffer.toString();
    }

    private String getUpdateMaterialGroup() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE DW_FACT_TURNOVERRATE SET (FMATERIALGROUPID) = (");
        buffer.append("\n SELECT T1.FMATERIALGROUPID FROM DW_Dim_BD_Material AS T1");
        buffer.append("\n WHERE DW_FACT_TURNOVERRATE.FMATERIALID =T1.FID)");
        return buffer.toString();
    }

    private String getUpdateIndustryID() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE DW_FACT_TURNOVERRATE SET (FINDUSTERYID) = (");
        buffer.append("\n SELECT FIndustry FROM T_ORG_Company ");
        buffer.append("\n WHERE T_ORG_Company.FID =DW_FACT_TURNOVERRATE.FCOMPANYORGUNITID)");
        return buffer.toString();
    }

    private String getUpdateIssueSQL(int updateStrategy, int year, int period) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE DW_FACT_TURNOVERRATE AS T4 SET (FISSUEAMOUNT,FPERIODID) =(");
        buffer.append("SELECT T3.ISSUEAMOUNT AS ISSUEAMOUNT ,T3.PERIODID AS PERIODID FROM ");
        buffer.append("(SELECT T2.FMATERIALID,T2.FSTORAGEORGUNITID,T2.FCOMPANYORGUNITID,T6.PERIODID, SUM(T2.FLocalAmount ) AS ISSUEAMOUNT ");
        buffer.append("\n FROM T_IM_SALEISSUEBILL T1 INNER JOIN T_IM_SALEISSUEENTRY T2");
        buffer.append("\n ON T1.FID = T2.FPARENTID INNER JOIN (");
        buffer.append("\n SELECT T11.FID AS PERIODID,T11.FYEAR AS FPERIODYEAR ,T11.FPERIOD AS FPERIODNUMBER,T12.FID AS FCOMPANYORGUNITID ");
        buffer.append("\n  FROM DW_Dim_BD_Period T11    INNER JOIN DW_DIM_ORG_Company T12 ON T11.FTYPEID = T12.FACCOUNTPERIODID");
        buffer.append("\n  )  T6 ");
        buffer.append("\n ON T6.FCOMPANYORGUNITID = T2.FCOMPANYORGUNITID");
        buffer.append("\n AND T1.FYEAR = T6.FPERIODYEAR AND T1.FPERIOD = T6.FPERIODNUMBER");
        buffer.append("\n left outer join T_SCM_TransactionType T_SCM_TransactionType");
        buffer.append("\n on T1.FTRANSACTIONTYPEID = T_SCM_TransactionType.FID");
        buffer.append("\n WHERE T1.FBASESTATUS = 4 and T_SCM_TransactionType.FRIType = 40 ");
        if (updateStrategy == 1) {
            buffer.append("\n AND (T1.FYEAR =" + year);
            buffer.append(" AND T1.FPERIOD > " + period);
            buffer.append(") OR T1.FYEAR >" + year);
        }
        buffer.append("\n GROUP BY T2.FMATERIALID,T2.FSTORAGEORGUNITID,T2.FCOMPANYORGUNITID,T6.PERIODID) AS T3");
        buffer.append("\n WHERE T4.FMATERIALID = T3.FMATERIALID AND T4.FSTORAGEORGUNITID = T3.FSTORAGEORGUNITID");
        buffer.append("\n AND T4.FCOMPANYORGUNITID = T3.FCOMPANYORGUNITID AND T4.FPERIODID = T3.PERIODID");
        buffer.append(")");
        return buffer.toString();
    }

    private String getUpdateLastUpdateDate() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE DW_PARAM_TURNOVERRATE SET (FYEAR,FPERIOD,FBIZDATE)=");
        buffer.append("(SELECT TOP 1 FYEAR ,FPERIOD,now() FROM T_IM_SALEISSUEBILL ORDER BY FYEAR,FPERIOD)");
        return buffer.toString();
    }

    private String getupdateTurnOverRateSql() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE DW_FACT_TURNOVERRATE SET FTURNOVERRATE = decimal(FISSUEAMOUNT/decimal(((FPERIODBEGINAMOUNT+FPERIODENDAMOUNT)/2),21,8),21,8)");
        buffer.append("\n WHERE (FPERIODENDAMOUNT +FPERIODBEGINAMOUNT)>0");
        return buffer.toString();
    }
}

