/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.ITransactionType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.IMaterialStorageAssign;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignCollection;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignFactory;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.UnitSourceEnum;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.SCMCommonUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class InvAlgorithm {
    protected Context ctx = null;
    protected CompanyOrgUnitInfo cou = null;
    protected StorageOrgUnitInfo sou = null;
    private Map<String, MultiMeasureUnitInfo> mulUnitCache = null;
    private Map<String, MaterialInventoryInfo> materialId2InventoryMap = null;
    private Map<String, MaterialCompanyInfoInfo> materialId2CompanyMap = null;
    private Map<String, WarehouseInfo> warehouseMap = null;
    private Map<String, LocationInfo> materialId2Location = null;
    protected Map<String, IObjectValue> sourceBillEntryMap = new HashMap<String, IObjectValue>();
    protected boolean isUnitSource = false;

    public void calTotalFields() {
        this.calTotalAmount();
        this.calTotalTax();
        this.calTotalTaxAmount();
    }

    public boolean isNegativeBill() throws EASBizException, BOSException {
        return this.isIsReversed() ^ this.isReturnRIType(this.getTransactionType());
    }

    protected void calActualPrice(int i) {
        int scale = this.getPricePrecision(i);
        BigDecimal amount = this.getAmount(i);
        BigDecimal qty = this.getQty(i);
        BigDecimal discountRate = this.getDiscountRate(i);
        if (discountRate.compareTo(new BigDecimal(100)) == 0) {
            this.setActualPrice(BigDecimal.ZERO, i);
            return;
        }
        if (discountRate == null || SysConstant.BIGZERO.compareTo(discountRate) == 0) {
            BigDecimal price = this.getPrice(i);
            this.setActualPrice(price, i);
        } else if (amount != null && qty != null && SysConstant.BIGZERO.compareTo(qty) != 0) {
            BigDecimal actualPrice = amount.divide(qty, scale, 4);
            this.setActualPrice(actualPrice, i);
        }
    }

    protected void calActualTaxPrice(int i) {
        BigDecimal discountRate = this.getDiscountRate(i);
        int scale = this.getPricePrecision(i);
        if (discountRate.compareTo(new BigDecimal(100)) == 0) {
            this.setActualPrice(BigDecimal.ZERO, i);
            return;
        }
        if (SysConstant.BIGZERO.compareTo(discountRate) == 0) {
            BigDecimal taxPrice = this.getTaxPrice(i);
            this.setActualTaxPrice(taxPrice, i);
        } else {
            BigDecimal taxAmount = this.getTaxAmount(i);
            BigDecimal qty = this.getQty(i);
            BigDecimal actualTaxPrice = SysConstant.BIGZERO;
            if (taxAmount != null && qty != null && SysConstant.BIGZERO.compareTo(qty) != 0) {
                actualTaxPrice = taxAmount.divide(qty, scale, 4);
                this.setActualTaxPrice(actualTaxPrice, i);
            }
        }
    }

    protected void calAmount(int i) {
        int scale = this.getAmountPrecision();
        if (this.isInTax()) {
            BigDecimal taxAmount = this.getTaxAmount(i);
            BigDecimal tax = this.getTax(i);
            this.setAmount(SysConstant.BIGZERO, i);
            if (taxAmount != null && tax != null) {
                BigDecimal actualTaxPrice = taxAmount.subtract(tax);
                actualTaxPrice = actualTaxPrice.setScale(scale, 4);
                this.setAmount(actualTaxPrice, i);
            }
        } else {
            BigDecimal price = this.getPrice(i);
            BigDecimal discountRate = this.getDiscountRate(i);
            BigDecimal qty = this.getQty(i);
            BigDecimal amount = qty.multiply(price).multiply(SCMConstant.BIGDECIMAL_ONE.subtract(discountRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4)));
            amount = amount.setScale(scale, 4);
            this.setAmount(amount, i);
        }
    }

    protected void calAssistQtyByBaseQty(int i) {
        BigDecimal baseQty = this.getBaseQty(i);
        BigDecimal assistQty = SysConstant.BIGZERO;
        if (baseQty != null) {
            assistQty = baseQty;
        } else {
            baseQty = assistQty;
        }
        if (baseQty != null && baseQty.compareTo(SysConstant.BIGZERO) == 0) {
            this.setAssistQty(assistQty, i);
            return;
        }
        MultiMeasureUnitInfo mulUnit = null;
        try {
            mulUnit = this.getMulUnit(this.ctx, this.getAssistUnit(i), this.getMaterial(i));
        }
        catch (BaseException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (mulUnit != null) {
            BigDecimal coefficient = mulUnit.getBaseConvsRate();
            int precision = mulUnit.getQtyPrecision();
            if (coefficient != null && SysConstant.BIGZERO.compareTo(coefficient) != 0) {
                assistQty = baseQty.divide(coefficient, precision, 4);
            }
        } else {
            assistQty = null;
        }
        this.setAssistQty(assistQty, i);
    }

    protected void calBaseQtyByQty(int i) {
        BigDecimal qty = this.getQty(i);
        BigDecimal baseQty = SysConstant.BIGZERO;
        if (qty != null) {
            baseQty = qty;
        } else {
            qty = baseQty;
        }
        if (qty != null && qty.compareTo(SysConstant.BIGZERO) == 0) {
            this.setBaseQty(baseQty, i);
            return;
        }
        try {
            BigDecimal coefficient;
            MultiMeasureUnitInfo mulUnit = this.getMulUnit(this.ctx, this.getUnit(i), this.getMaterial(i));
            if (mulUnit != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
                baseQty = qty.multiply(coefficient);
                MeasureUnitInfo baseUnit = this.getMaterial(i).getBaseUnit();
                if (baseUnit == null) {
                    IMaterial im = null;
                    im = this.ctx == null ? MaterialFactory.getRemoteInstance() : MaterialFactory.getLocalInstance((Context)this.ctx);
                    baseUnit = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(this.getMaterial(i).getId())).getBaseUnit();
                }
                if ((mulUnit = this.getMulUnit(this.ctx, baseUnit, this.getMaterial(i))) == null) {
                    throw new SCMBillException(SCMBillException.BASEUNIT_ERROR, new Object[]{i + 1, this.getMaterial(i).getNumber()});
                }
                int precision = mulUnit.getQtyPrecision();
                baseQty = baseQty.setScale(precision, 4);
            }
            this.setBaseQty(baseQty, i);
        }
        catch (BaseException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected void calQtyByBaseQty(int i) {
        BigDecimal baseQty = this.getBaseQty(i);
        BigDecimal qty = SysConstant.BIGZERO;
        if (baseQty != null) {
            qty = baseQty;
        } else {
            baseQty = qty;
        }
        if (baseQty != null && baseQty.compareTo(SysConstant.BIGZERO) == 0) {
            this.setQty(qty, i);
            return;
        }
        try {
            BigDecimal coefficient;
            MultiMeasureUnitInfo mulUnit = this.getMulUnit(this.ctx, this.getUnit(i), this.getMaterial(i));
            if (mulUnit != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
                int precision = mulUnit.getQtyPrecision();
                qty = baseQty.divide(coefficient, precision, 4);
            }
            this.setQty(qty, i);
        }
        catch (BaseException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected abstract void calByAmount(int var1);

    protected abstract void calByPrice(int var1);

    protected void calByPrice4UnitSource(int i) {
    }

    protected abstract void calByTaxAmount(int var1);

    protected abstract void calByTaxPrice(int var1);

    protected void calByTaxPrice4UnitSource(int i) {
    }

    protected void calDiscountAmount(int i) {
        int scale = this.getAmountPrecision();
        BigDecimal taxPrice = this.getTaxPrice(i);
        BigDecimal qty = this.getQty(i);
        BigDecimal discountRate = this.getDiscountRate(i);
        BigDecimal discountAmount = taxPrice.multiply(qty).multiply(discountRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4)).setScale(scale, 4);
        this.setDiscountAmount(discountAmount, i);
    }

    protected void calLocalAmount(int i) {
        int scale = this.getLocalAmountPrecision();
        BigDecimal amount = this.getAmount(i);
        BigDecimal exchangerate = this.getExchangeRate();
        if (SysConstant.BIGZERO.compareTo(exchangerate) != 0) {
            if (this.getConvertMode() != null && this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                this.setLocalAmount(amount.multiply(exchangerate).setScale(scale, 4), i);
            } else if (SysConstant.BIGZERO.compareTo(exchangerate) != 0) {
                this.setLocalAmount(amount.divide(exchangerate, scale, 4), i);
            }
        } else {
            this.setLocalAmount(amount, i);
        }
    }

    protected void calLocalTax(int i) {
        int scale = this.getLocalAmountPrecision();
        BigDecimal tax = this.getTax(i);
        BigDecimal exchangerate = this.getExchangeRate();
        if (SysConstant.BIGZERO.compareTo(exchangerate) != 0) {
            if (this.getConvertMode() != null && this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                this.setLocalTax(tax.multiply(exchangerate).setScale(scale, 4), i);
            } else if (SysConstant.BIGZERO.compareTo(exchangerate) != 0) {
                this.setLocalTax(tax.divide(exchangerate, scale, 4), i);
            }
        } else {
            this.setLocalTax(tax, i);
        }
    }

    protected void calLocalTaxAmount(int i) {
        int scale = this.getLocalAmountPrecision();
        BigDecimal taxAmount = this.getTaxAmount(i);
        BigDecimal exchangerate = this.getExchangeRate();
        if (SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
            if (this.getConvertMode() != null && this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                this.setLocalTaxAmount(taxAmount.multiply(exchangerate).setScale(scale, 4), i);
            } else if (SysConstant.BIGZERO.compareTo(exchangerate) != 0) {
                this.setLocalTaxAmount(taxAmount.divide(exchangerate, scale, 4), i);
            }
        } else {
            this.setLocalTaxAmount(taxAmount, i);
        }
    }

    protected void calPriceByAmount(int i) {
        BigDecimal amount = this.getAmount(i);
        BigDecimal qty = this.getQty(i);
        BigDecimal discountRate = this.getDiscountRate(i);
        int scale = this.getPricePrecision(i);
        BigDecimal price = CalculateUtils.calPrice((BigDecimal)amount, (BigDecimal)qty, (BigDecimal)discountRate, (int)scale);
        this.setPrice(price, i);
    }

    protected void calPriceByTaxPrice(int i) {
        BigDecimal taxPrice = this.getTaxPrice(i);
        BigDecimal taxRate = this.getTaxRate(i);
        int scale = this.getPricePrecision(i);
        BigDecimal price = SysConstant.BIGZERO;
        price = this.isPriceInTax() ? CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)scale) : CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate, (BigDecimal)taxPrice, (int)scale);
        this.setPrice(price, i);
    }

    protected void calTax(int i) {
        int scale = this.getAmountPrecision();
        if (this.isInTax()) {
            BigDecimal taxAmount = this.getTaxAmount(i);
            BigDecimal taxRate = this.getTaxRate(i);
            BigDecimal tax = SysConstant.BIGZERO;
            if (taxAmount != null && taxRate != null) {
                taxRate = taxRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4);
                tax = taxAmount.divide(taxRate.add(SCMConstant.BIGDECIMAL_ONE), 10, 4).multiply(taxRate);
                if (!this.isPriceInTax()) {
                    tax = taxAmount.multiply(taxRate);
                }
                tax = tax.setScale(scale, 4);
            }
            this.setTax(tax, i);
        } else {
            BigDecimal taxRate;
            BigDecimal tax;
            BigDecimal amount = this.getAmount(i);
            if (amount == null) {
                amount = SysConstant.BIGZERO;
            }
            if ((tax = CalculateUtils.calTax((BigDecimal)amount, (BigDecimal)(taxRate = this.getTaxRate(i)), (int)scale)) != null) {
                this.setTax(tax, i);
            } else {
                this.setTax(SysConstant.BIGZERO, i);
            }
        }
    }

    protected void calTaxAmount(int i) {
        if (this.getDiscountRate(i).compareTo(new BigDecimal(100)) == 0) {
            this.setTaxAmount(BigDecimal.ZERO, i);
            return;
        }
        int scale = this.getAmountPrecision();
        if (this.isInTax()) {
            BigDecimal taxPrice = this.getTaxPrice(i);
            BigDecimal qty = this.getQty(i);
            BigDecimal discountAmount = this.getDiscountAmount(i);
            BigDecimal taxAmount = taxPrice.multiply(qty).subtract(discountAmount);
            taxAmount = taxAmount.setScale(scale, 4);
            this.setTaxAmount(taxAmount, i);
        } else {
            BigDecimal amount = this.getAmount(i);
            BigDecimal tax = this.getTax(i);
            BigDecimal taxAmount = amount.add(tax);
            taxAmount = taxAmount.setScale(scale, 4);
            this.setTaxAmount(taxAmount, i);
        }
    }

    protected void calTaxPrice(int i) {
        if (this.isInTax()) {
            BigDecimal discountRate = this.getDiscountRate(i);
            BigDecimal qty = this.getQty(i);
            BigDecimal taxAmount = this.getTaxAmount(i);
            int scale = this.getPricePrecision(i);
            BigDecimal taxPrice = null;
            if (qty != null && qty.compareTo(SysConstant.BIGZERO) != 0) {
                if (discountRate == null) {
                    discountRate = SysConstant.BIGZERO;
                }
                discountRate = SCMConstant.BIGDECIMAL_ONE.subtract(discountRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4));
                if (taxAmount != null && qty != null && SysConstant.BIGZERO.compareTo(qty) != 0 && SysConstant.BIGZERO.compareTo(discountRate) != 0) {
                    taxPrice = taxAmount.divide(qty, 10, 4);
                    taxPrice = taxPrice.divide(discountRate, scale, 4);
                }
                this.setTaxPrice(taxPrice, i);
            }
        } else {
            BigDecimal price = this.getPrice(i);
            BigDecimal taxRate = this.getTaxRate(i);
            int scale = this.getPricePrecision(i);
            BigDecimal taxPrice = CalculateUtils.calTaxPrice((BigDecimal)price, (BigDecimal)taxRate, (int)scale);
            this.setTaxPrice(taxPrice, i);
        }
    }

    protected void calTaxPricebyPrice(int i) {
        BigDecimal price = this.getPrice(i);
        BigDecimal taxRate = this.getTaxRate(i);
        int scale = this.getPricePrecision(i);
        BigDecimal taxPrice = CalculateUtils.calTaxPrice((BigDecimal)price, (BigDecimal)taxRate, (int)scale);
        if (!this.isPriceInTax()) {
            taxPrice = CalculateUtils.calTaxPriceByPurchaseCost((BigDecimal)price, (BigDecimal)taxRate, (int)scale);
        }
        this.setTaxPrice(taxPrice, i);
    }

    protected abstract void calTotalAmount();

    protected abstract void calTotalTax();

    protected abstract void calTotalTaxAmount();

    protected abstract BigDecimal getAmount(int var1);

    protected abstract int getAmountPrecision();

    protected abstract MeasureUnitInfo getAssistUnit(int var1);

    protected abstract BigDecimal getBaseQty(int var1);

    protected abstract ConvertModeEnum getConvertMode();

    protected abstract BigDecimal getDiscountAmount(int var1);

    protected abstract BigDecimal getDiscountRate(int var1);

    protected abstract int getEntrySize();

    protected abstract BigDecimal getExchangeRate();

    protected abstract int getLocalAmountPrecision();

    protected abstract MaterialInfo getMaterial(int var1);

    protected MultiMeasureUnitInfo getMulUnit(Context ctx, MeasureUnitInfo mui, MaterialInfo mi) throws EASBizException, BOSException {
        MultiMeasureUnitInfo mulUnit = null;
        if (this.mulUnitCache == null) {
            this.batchFetchMulUnit();
        }
        if (mui == null || mi == null) {
            return null;
        }
        String key = mi.getId().toString() + mui.getId().toString();
        mulUnit = this.mulUnitCache.get(key);
        if (mulUnit == null) {
            IMultiMeasureUnit immu = null;
            immu = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            if (mui != null && mi != null) {
                mulUnit = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString());
            }
            this.mulUnitCache.put(key, mulUnit);
        }
        return mulUnit;
    }

    protected void batchFetchMulUnit() throws EASBizException, BOSException {
        if (this.mulUnitCache == null) {
            this.mulUnitCache = new HashMap<String, MultiMeasureUnitInfo>();
        }
        HashSet<String> matIdSet = new HashSet<String>();
        HashSet<String> unitIdSet = new HashSet<String>();
        for (int i = 0; i < this.getEntrySize(); ++i) {
            if (this.getMaterial(i) == null) continue;
            matIdSet.add(this.getMaterial(i).getId().toString());
            if (this.getUnit(i) == null) continue;
            unitIdSet.add(this.getUnit(i).getId().toString());
            if (this.getAssistUnit(i) == null) continue;
            unitIdSet.add(this.getAssistUnit(i).getId().toString());
        }
        if (unitIdSet == null || unitIdSet.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", matIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", unitIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isBasicUnit", (Object)Boolean.TRUE));
        filter.setMaskString("#0 and (#1 or #2)");
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("material.id"));
        view.getSelector().add(new SelectorItemInfo("measureUnit.id"));
        view.getSelector().add(new SelectorItemInfo("isBasicUnit"));
        view.getSelector().add(new SelectorItemInfo("conversionRate"));
        view.getSelector().add(new SelectorItemInfo("baseConvsRate"));
        view.getSelector().add(new SelectorItemInfo("qtyPrecision"));
        IMultiMeasureUnit immu = null;
        immu = this.ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx);
        MultiMeasureUnitInfo mulUnit = null;
        MultiMeasureUnitCollection coll = immu.getMultiMeasureUnitCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            mulUnit = coll.get(i);
            String key = mulUnit.getMaterial().getId().toString() + mulUnit.getMeasureUnit().getId().toString();
            this.mulUnitCache.put(key, mulUnit);
        }
    }

    protected MaterialInventoryInfo getMaterialInventoryInfo(String materialId) throws EASBizException, BOSException {
        if (this.materialId2InventoryMap == null) {
            this.batchFetchMaterialInventoryMap();
        }
        if (materialId == null || materialId.length() == 0) {
            return null;
        }
        return this.materialId2InventoryMap.get(materialId);
    }

    protected Map<String, MaterialInventoryInfo> batchFetchMaterialInventoryMap() throws BOSException, EASBizException {
        this.materialId2InventoryMap = new HashMap<String, MaterialInventoryInfo>();
        if (null == this.sou || this.getEntrySize() == 0) {
            return this.materialId2InventoryMap;
        }
        HashSet<String> materialIdSet = new HashSet<String>();
        int size = this.getEntrySize();
        for (int i = 0; i < size; ++i) {
            MaterialInfo materialInfo = this.getMaterial(i);
            if (materialInfo == null) continue;
            materialIdSet.add(materialInfo.getId().toString());
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.sou.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("material.id", materialIdSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection si = new SelectorItemCollection();
        si.add(new SelectorItemInfo("*"));
        si.add(new SelectorItemInfo("defaultWarehouse.*"));
        entityViewInfo.setSelector(si);
        IMaterialInventory iMatInventory = this.ctx == null ? MaterialInventoryFactory.getRemoteInstance() : MaterialInventoryFactory.getLocalInstance((Context)this.ctx);
        MaterialInventoryCollection mic = iMatInventory.getMaterialInventoryCollection(entityViewInfo);
        if (null == mic || mic.size() == 0) {
            return this.materialId2InventoryMap;
        }
        int size2 = mic.size();
        for (int i = 0; i < size2; ++i) {
            MaterialInventoryInfo materialInventory = mic.get(i);
            this.materialId2InventoryMap.put(materialInventory.getMaterial().getId().toString(), materialInventory);
        }
        return this.materialId2InventoryMap;
    }

    protected MaterialCompanyInfoInfo getMaterialCompanyInfo(String materialId) throws EASBizException, BOSException {
        if (this.materialId2CompanyMap == null) {
            this.batchFetchMaterialCompanyMap();
        }
        if (materialId == null || materialId.length() == 0) {
            return null;
        }
        return this.materialId2CompanyMap.get(materialId);
    }

    protected Map<String, MaterialCompanyInfoInfo> batchFetchMaterialCompanyMap() throws EASBizException, BOSException {
        this.materialId2CompanyMap = new HashMap<String, MaterialCompanyInfoInfo>();
        if (null == this.cou || this.getEntrySize() == 0) {
            return this.materialId2CompanyMap;
        }
        HashSet<String> materialIdSet = new HashSet<String>();
        int size = this.getEntrySize();
        for (int i = 0; i < size; ++i) {
            MaterialInfo materialInfo = this.getMaterial(i);
            if (materialInfo == null) continue;
            materialIdSet.add(materialInfo.getId().toString());
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.cou.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("mateial.id", materialIdSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        IMaterialCompanyInfo iMatCompany = this.ctx == null ? MaterialCompanyInfoFactory.getRemoteInstance() : MaterialCompanyInfoFactory.getLocalInstance((Context)this.ctx);
        MaterialCompanyInfoCollection mic = iMatCompany.getMaterialCompanyInfoCollection(entityViewInfo);
        if (null == mic || mic.size() == 0) {
            return this.materialId2CompanyMap;
        }
        int size2 = mic.size();
        for (int i = 0; i < size2; ++i) {
            MaterialCompanyInfoInfo materialCompany = mic.get(i);
            this.materialId2CompanyMap.put(materialCompany.getMateial().getId().toString(), materialCompany);
        }
        return this.materialId2CompanyMap;
    }

    protected void resetEntryMaterialInfo() throws BOSException {
        int i;
        MaterialInfo materialInfo;
        HashSet<String> materialIdSet = new HashSet<String>();
        for (int i2 = 0; i2 < this.getEntrySize(); ++i2) {
            materialInfo = this.getMaterial(i2);
            if (materialInfo == null) continue;
            materialIdSet.add(materialInfo.getId().toString());
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", materialIdSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        MaterialCollection mCol = MaterialFactory.getLocalInstance((Context)this.ctx).getMaterialCollection(entityViewInfo);
        if (mCol == null || mCol.size() == 0) {
            return;
        }
        HashMap<String, MaterialInfo> materialId2Info = new HashMap<String, MaterialInfo>();
        int size = mCol.size();
        for (i = 0; i < size; ++i) {
            materialInfo = mCol.get(i);
            materialId2Info.put(materialInfo.getId().toString(), materialInfo);
        }
        for (i = 0; i < this.getEntrySize(); ++i) {
            materialInfo = this.getMaterial(i);
            if (materialInfo == null) continue;
            materialInfo = (MaterialInfo)materialId2Info.get(materialInfo.getId().toString());
            this.setMaterial(materialInfo, i);
        }
    }

    protected abstract BigDecimal getPrice(int var1);

    protected abstract int getPricePrecision(int var1);

    protected abstract BigDecimal getQty(int var1);

    protected BigDecimal getRealTaxRate(int i) {
        return this.getTaxRate(i).divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4);
    }

    protected abstract BigDecimal getTax(int var1);

    protected abstract BigDecimal getTaxAmount(int var1);

    protected abstract BigDecimal getTaxPrice(int var1);

    protected abstract BigDecimal getTaxRate(int var1);

    protected abstract TransactionTypeInfo getTransactionType();

    protected abstract MeasureUnitInfo getUnit(int var1);

    protected abstract WarehouseInfo getWarehouse(int var1);

    protected abstract boolean isInTax();

    protected abstract boolean isIsReversed();

    protected abstract boolean isPriceInTax();

    protected BigDecimal nullToZero(BigDecimal value) {
        if (value == null) {
            return SysConstant.BIGZERO;
        }
        return value;
    }

    protected void reCalEntryFields() throws EASBizException, BOSException {
        for (int i = 0; i < this.getEntrySize(); ++i) {
            if (this.isInTax()) {
                if (SysConstant.BIGZERO.compareTo(this.getTaxPrice(i)) != 0) {
                    this.setTaxPrice(this.getTaxPrice(i).abs().setScale(this.getPricePrecision(i), 4), i);
                    this.calByTaxPrice(i);
                    continue;
                }
                if (SysConstant.BIGZERO.compareTo(this.getTaxAmount(i)) != 0) {
                    BigDecimal taxAmount = this.isNegativeBill() ? this.getTaxAmount(i).abs().negate() : this.getTaxAmount(i).abs();
                    taxAmount = taxAmount.setScale(this.getAmountPrecision(), 4);
                    this.setTaxAmount(taxAmount, i);
                    this.calByTaxAmount(i);
                    continue;
                }
                this.setTaxPrice(SysConstant.BIGZERO.setScale(this.getPricePrecision(i)), i);
                this.calByTaxPrice(i);
                continue;
            }
            if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) != 0) {
                this.setPrice(this.getPrice(i).abs().setScale(this.getPricePrecision(i), 4), i);
                this.calByPrice(i);
                continue;
            }
            if (SysConstant.BIGZERO.compareTo(this.getAmount(i)) != 0) {
                BigDecimal amount = this.isNegativeBill() ? this.getAmount(i).abs().negate() : this.getAmount(i).abs();
                amount = amount.setScale(this.getAmountPrecision(), 4);
                this.setAmount(amount, i);
                this.calByAmount(i);
                continue;
            }
            this.setPrice(SysConstant.BIGZERO.setScale(this.getPricePrecision(i)), i);
            this.calByPrice(i);
        }
    }

    protected void reCalEntryFields4UnitSource(int i) throws EASBizException, BOSException {
        if (!this.isUnitSource) {
            return;
        }
        if (this.isInTax()) {
            if (SysConstant.BIGZERO.compareTo(this.getTaxPrice(i)) != 0) {
                this.setTaxPrice(this.getTaxPrice(i).abs().setScale(this.getPricePrecision(i), 4), i);
                this.calByTaxPrice4UnitSource(i);
            } else if (SysConstant.BIGZERO.compareTo(this.getTaxAmount(i)) != 0) {
                BigDecimal taxAmount = this.isNegativeBill() ? this.getTaxAmount(i).abs().negate() : this.getTaxAmount(i).abs();
                taxAmount = taxAmount.setScale(this.getAmountPrecision(), 4);
                this.setTaxAmount(taxAmount, i);
                this.calByTaxAmount(i);
            } else {
                this.setTaxPrice(SysConstant.BIGZERO.setScale(this.getPricePrecision(i)), i);
                this.calByTaxPrice4UnitSource(i);
            }
        } else if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) != 0) {
            this.setPrice(this.getPrice(i).abs().setScale(this.getPricePrecision(i), 4), i);
            this.calByPrice4UnitSource(i);
        } else if (SysConstant.BIGZERO.compareTo(this.getAmount(i)) != 0) {
            BigDecimal amount = this.isNegativeBill() ? this.getAmount(i).abs().negate() : this.getAmount(i).abs();
            amount = amount.setScale(this.getAmountPrecision(), 4);
            this.setAmount(amount, i);
            this.calByAmount(i);
        } else {
            this.setPrice(SysConstant.BIGZERO.setScale(this.getPricePrecision(i)), i);
            this.calByPrice4UnitSource(i);
        }
    }

    protected void reCalEntryFields(int i) throws EASBizException, BOSException {
        if (this.isInTax()) {
            if (SysConstant.BIGZERO.compareTo(this.getTaxPrice(i)) != 0) {
                this.setTaxPrice(this.getTaxPrice(i).abs().setScale(this.getPricePrecision(i), 4), i);
                this.calByTaxPrice(i);
            } else if (SysConstant.BIGZERO.compareTo(this.getTaxAmount(i)) != 0) {
                BigDecimal taxAmount = this.isNegativeBill() ? this.getTaxAmount(i).abs().negate() : this.getTaxAmount(i).abs();
                taxAmount = taxAmount.setScale(this.getAmountPrecision(), 4);
                this.setTaxAmount(taxAmount, i);
                this.calByTaxAmount(i);
            } else {
                this.setTaxPrice(SysConstant.BIGZERO.setScale(this.getPricePrecision(i)), i);
                this.calByTaxPrice(i);
            }
        } else if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) != 0) {
            this.setPrice(this.getPrice(i).abs().setScale(this.getPricePrecision(i), 4), i);
            this.calByPrice(i);
        } else if (SysConstant.BIGZERO.compareTo(this.getAmount(i)) != 0) {
            BigDecimal amount = this.isNegativeBill() ? this.getAmount(i).abs().negate() : this.getAmount(i).abs();
            amount = amount.setScale(this.getAmountPrecision(), 4);
            this.setAmount(amount, i);
            this.calByAmount(i);
        } else {
            this.setPrice(SysConstant.BIGZERO.setScale(this.getPricePrecision(i)), i);
            this.calByPrice(i);
        }
    }

    protected abstract void setMaterial(MaterialInfo var1, int var2);

    protected abstract void setActualPrice(BigDecimal var1, int var2);

    protected abstract void setActualTaxPrice(BigDecimal var1, int var2);

    protected abstract void setAmount(BigDecimal var1, int var2);

    protected abstract void setAssistQty(BigDecimal var1, int var2);

    protected abstract void setBaseQty(BigDecimal var1, int var2);

    protected abstract void setQty(BigDecimal var1, int var2);

    protected abstract void setDiscountAmount(BigDecimal var1, int var2);

    protected abstract void setLocalAmount(BigDecimal var1, int var2);

    protected abstract void setLocalTax(BigDecimal var1, int var2);

    protected abstract void setLocalTaxAmount(BigDecimal var1, int var2);

    protected abstract void setPrice(BigDecimal var1, int var2);

    protected abstract void setTax(BigDecimal var1, int var2);

    protected abstract void setTaxAmount(BigDecimal var1, int var2);

    protected abstract void setTaxPrice(BigDecimal var1, int var2);

    private boolean isReturnRIType(TransactionTypeInfo transType) throws EASBizException, BOSException {
        int bizDirection;
        if (transType == null) {
            return false;
        }
        if (transType.getRiType() == null || transType.getRiType().getBizDirection() == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("riType.id"));
            selector.add(new SelectorItemInfo("riType.bizDirection"));
            ITransactionType transactionType = this.ctx == null ? TransactionTypeFactory.getRemoteInstance() : TransactionTypeFactory.getLocalInstance((Context)this.ctx);
            transType = transactionType.getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(transType.getId()), selector);
        }
        return (bizDirection = transType.getRiType().getBizDirection().getValue()) == -1;
    }

    protected LocationInfo getDefaultLocation(String materialId, String warehsId, String souID) throws EASBizException, BOSException {
        if (materialId == null || warehsId == null || souID == null) {
            return null;
        }
        if (this.materialId2Location == null) {
            this.batchFetchDefaultLocation();
        }
        return this.materialId2Location.get(materialId + warehsId);
    }

    protected Map<String, LocationInfo> batchFetchDefaultLocation() throws EASBizException, BOSException {
        this.materialId2Location = new HashMap<String, LocationInfo>();
        if (null == this.cou || this.getEntrySize() == 0) {
            return this.materialId2Location;
        }
        HashSet<String> materialIdSet = new HashSet<String>();
        HashSet<String> warehsIdSet = new HashSet<String>();
        int size = this.getEntrySize();
        for (int i = 0; i < size; ++i) {
            MaterialInfo materialInfo = this.getMaterial(i);
            if (materialInfo != null) {
                materialIdSet.add(materialInfo.getId().toString());
            }
            if (this.getWarehouse(i) == null) continue;
            warehsIdSet.add(this.getWarehouse(i).getId().toString());
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrg", (Object)this.sou.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("ISDEFAULTLOCATION", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("material.id", materialIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("warehouse.id", warehsIdSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection si = new SelectorItemCollection();
        si.add(new SelectorItemInfo("id"));
        si.add(new SelectorItemInfo("material.id"));
        si.add(new SelectorItemInfo("storageOrg.id"));
        si.add(new SelectorItemInfo("warehouse.id"));
        si.add(new SelectorItemInfo("location.id"));
        si.add(new SelectorItemInfo("location.name"));
        si.add(new SelectorItemInfo("location.number"));
        entityViewInfo.setSelector(si);
        IMaterialStorageAssign iMatStoAssign = this.ctx == null ? MaterialStorageAssignFactory.getRemoteInstance() : MaterialStorageAssignFactory.getLocalInstance((Context)this.ctx);
        MaterialStorageAssignCollection mic = iMatStoAssign.getMaterialStorageAssignCollection(entityViewInfo);
        if (null == mic || mic.size() == 0) {
            return this.materialId2Location;
        }
        MaterialStorageAssignInfo info = null;
        int size2 = mic.size();
        for (int i = 0; i < size2; ++i) {
            info = mic.get(i);
            String key = info.getMaterial().getId().toString() + info.getWarehouse().getId().toString();
            this.materialId2Location.put(key, info.getLocation());
        }
        return this.materialId2Location;
    }

    protected WarehouseInfo getDefaultWarehouseByStorageUnit(Context ctx, String storageUnitId) throws BOSException {
        if (null == storageUnitId || "".equals(storageUnitId.trim())) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)storageUnitId, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        SorterItemCollection sorterCol = new SorterItemCollection();
        SorterItemInfo itemInfo = new SorterItemInfo("storageOrg.id");
        itemInfo.setSortType(SortType.ASCEND);
        sorterCol.add(itemInfo);
        SorterItemInfo itemInfo1 = new SorterItemInfo("number");
        itemInfo1.setSortType(SortType.ASCEND);
        sorterCol.add(itemInfo1);
        viewInfo.setSorter(sorterCol);
        WarehouseInfo warehouseInfo = null;
        IWarehouse iWarehouse = WarehouseFactory.getLocalInstance((Context)ctx);
        WarehouseCollection warehouseColl = iWarehouse.getWarehouseCollection(viewInfo);
        if (warehouseColl != null && warehouseColl.size() > 0) {
            warehouseInfo = warehouseColl.get(0);
        }
        if (warehouseInfo == null) {
            StringBuffer sql = new StringBuffer();
            sql.append(" Select FWarehouseID from T_DB_SOAccreditWH ");
            sql.append(" where FStatus = 1 and FStorageOrgID = '").append(storageUnitId).append("'");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.size() > 0) {
                HashSet<String> warehouseIdSet = new HashSet<String>();
                try {
                    while (rowSet.next()) {
                        warehouseIdSet.add(rowSet.getString("FWarehouseID"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", warehouseIdSet, CompareType.INCLUDE));
                viewInfo.setFilter(filterInfo);
                warehouseColl = iWarehouse.getWarehouseCollection(viewInfo);
                if (warehouseColl != null && warehouseColl.size() > 0) {
                    warehouseInfo = warehouseColl.get(0);
                }
            }
        }
        return warehouseInfo;
    }

    protected WarehouseInfo getWarehouseInfo(String warehouseId) throws BOSException {
        if (this.warehouseMap == null) {
            this.batchFetchWarehouse();
        }
        return this.warehouseMap.get(warehouseId);
    }

    protected Map<String, WarehouseInfo> batchFetchWarehouse() throws BOSException {
        WarehouseInfo wareHouseInfo;
        HashSet<String> wareHouseIdSet = new HashSet<String>();
        int n = this.getEntrySize();
        for (int i = 0; i < n; ++i) {
            wareHouseInfo = this.getWarehouse(i);
            if (null == wareHouseInfo) continue;
            wareHouseIdSet.add(wareHouseInfo.getId().toString());
        }
        this.warehouseMap = new HashMap<String, WarehouseInfo>();
        if (wareHouseIdSet.size() == 0) {
            return this.warehouseMap;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", wareHouseIdSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        WarehouseCollection wCol = WarehouseFactory.getLocalInstance((Context)this.ctx).getWarehouseCollection(entityViewInfo);
        if (wCol == null || wCol.size() == 0) {
            return this.warehouseMap;
        }
        int size = wCol.size();
        for (int i = 0; i < size; ++i) {
            wareHouseInfo = wCol.get(i);
            this.warehouseMap.put(wareHouseInfo.getId().toString(), wareHouseInfo);
        }
        return this.warehouseMap;
    }

    protected void calByUnitSource(Context ctx, InvBillBaseInfo invBillBaseInfo, IObjectCollection invBillEntryColl) throws BOSException, EASBizException {
        if (invBillBaseInfo.get("unitSource") == null || invBillBaseInfo.getUnitSource() == null || !UnitSourceEnum.DEFAULT.equals((Object)invBillBaseInfo.getUnitSource())) {
            this.isUnitSource = false;
            return;
        }
        this.isUnitSource = true;
        if (invBillBaseInfo.getSourceBillType() != null) {
            String billTypeId = invBillBaseInfo.getSourceBillType().getId().toString();
            this.sourceBillEntryMap = SCMCommonUtil.getSoueceBillEntryInfoMap((Context)ctx, (SCMBillBaseInfo)invBillBaseInfo, (IObjectCollection)invBillEntryColl, (String)this.getSourceBillEntryName(billTypeId));
            SCMCommonUtil.setUnitInfo((Context)ctx, (OrgUnitInfo)invBillBaseInfo.getStorageOrgUnit(), (IObjectCollection)invBillEntryColl);
            InvBillBaseEntryInfo invBillBaseEntryInfo = null;
            int size = invBillEntryColl.size();
            for (int i = 0; i < size; ++i) {
                invBillBaseEntryInfo = (InvBillBaseEntryInfo)invBillEntryColl.getObject(i);
                this.calByUnitSource(ctx, invBillBaseInfo, invBillBaseEntryInfo);
            }
        }
    }

    protected void calByUnitSource(Context ctx, InvBillBaseInfo invBillBaseInfo, InvBillBaseEntryInfo invBillBaseEntryInfo) throws BOSException, EASBizException {
    }

    protected String getSourceBillEntryName(String billTypeId) {
        if (SCMCommonUtil.isInvBill((String)billTypeId)) {
            return "entry";
        }
        return "entries";
    }
}

