/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.calculate.PropertyCalculator;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.InvAlgorithm;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;

public abstract class SaleIssueAlgorithm
extends InvAlgorithm {
    @Override
    public void calTotalFields() {
        super.calTotalFields();
        this.calTotalLocalTaxAmount();
        this.calTotalActualCost();
        this.calTotalStandardCost();
    }

    @Override
    protected void calByAmount(int i) {
        this.calPriceByAmount(i);
        this.calTaxPrice(i);
        this.calDiscountAmount(i);
        this.calLocalAmount(i);
        this.calTax(i);
        this.calLocalTax(i);
        this.calTaxAmount(i);
        this.calLocalTaxAmount(i);
        this.calActualPrice(i);
        this.calActualTaxPrice(i);
    }

    protected void calByAmount(int i, PropertyCalculator siCalculator) {
        if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            BigDecimal discountRate;
            BigDecimal bigDecimal = discountRate = null == this.getDiscountRate(i) ? new BigDecimal("0.0") : this.getDiscountRate(i);
            if (discountRate.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) >= 0) {
                siCalculator.evalForEntry("price=amount/qty", this.getPricePrecision(i));
                siCalculator.evalForEntry("discount=0", this.getPricePrecision(i));
            } else {
                siCalculator.evalForEntry("price=amount/qty/(1-discount/100)", this.getPricePrecision(i));
            }
        } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("price=amount/qty+discount", this.getPricePrecision(i));
        }
        if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) == 0 && !this.isInTax()) {
            siCalculator.evalForEntry("discount=0", this.getDiscountRate(i).scale());
        }
        siCalculator.evalForEntry("taxPrice=price*(1+taxRate/100)", this.getPricePrecision(i));
        if (SysConstant.BIGZERO.compareTo(this.getTaxPrice(i)) == 0 && this.isInTax()) {
            siCalculator.evalForEntry("discount=0", this.getDiscountRate(i).scale());
        }
        if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
        } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
        } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=discount*qty*(1+taxRate/100)", this.getAmountPrecision());
        }
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localAmount=amount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else if (this.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE && SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
            siCalculator.evalForEntry("localAmount=amount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
        siCalculator.evalForEntry("tax=amount*(taxRate/100)", this.getAmountPrecision());
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else if (this.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE && SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
            siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
        siCalculator.evalForEntry("taxAmount=amount+tax", this.getAmountPrecision());
        siCalculator.evalForEntry("localTaxAmount=localAmount+localTax", this.getLocalAmountPrecision());
        if (this.getDiscountRate(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscountRate(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
        }
    }

    @Override
    protected void calByPrice(int i) {
        this.calAmount(i);
        this.calTaxPricebyPrice(i);
        this.calDiscountAmount(i);
        this.calLocalAmount(i);
        this.calTax(i);
        this.calLocalTax(i);
        this.calTaxAmount(i);
        this.calActualTaxPrice(i);
        this.calActualPrice(i);
        this.calLocalTaxAmount(i);
    }

    protected void calByPrice(int i, PropertyCalculator siCalculator) {
        if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("amount=qty*price*(1-discount/100)", this.getAmountPrecision());
        } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) == 0) {
                siCalculator.evalForEntry("discount=0", this.getDiscountRatePrecision(i));
            }
            siCalculator.evalForEntry("amount=(price-discount)*qty", this.getAmountPrecision());
        }
        siCalculator.evalForEntry("taxPrice=price*(1+taxRate/100)", this.getPricePrecision(i));
        if (SysConstant.BIGZERO.compareTo(this.getTaxPrice(i)) == 0 && this.isInTax()) {
            siCalculator.evalForEntry("discount=0", this.getDiscountRate(i).scale());
        }
        if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
        } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
        } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=discount*qty*(1+taxRate/100)", this.getAmountPrecision());
        }
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localAmount=amount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else if (this.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE && SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
            siCalculator.evalForEntry("localAmount=amount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
        siCalculator.evalForEntry("tax=amount*(taxRate/100)", this.getAmountPrecision());
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else if (this.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE && SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
            siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
        siCalculator.evalForEntry("taxAmount=amount+tax", this.getAmountPrecision());
        if (this.getDiscountRate(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscountRate(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
        }
        siCalculator.evalForEntry("localTaxAmount=localAmount+localTax", this.getLocalAmountPrecision());
    }

    @Override
    protected void calByTaxAmount(int i) {
        if (this.isInTax()) {
            this.calTax(i);
            this.calAmount(i);
            this.calLocalTax(i);
            this.calLocalAmount(i);
            this.calTaxPrice(i);
            this.calPriceByTaxPrice(i);
            this.calDiscountAmount(i);
            this.calActualPrice(i);
            this.calActualTaxPrice(i);
            this.calLocalTaxAmount(i);
        }
    }

    protected void calByTaxAmount(int i, PropertyCalculator siCalculator) {
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localTaxAmount=taxAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else {
            siCalculator.evalForEntry("localTaxAmount=taxAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
        siCalculator.evalForEntry("tax=taxAmount/(1+taxRate/100)*(taxRate/100)", this.getAmountPrecision());
        siCalculator.evalForEntry("amount=taxAmount-tax", this.getAmountPrecision());
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else if (this.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE && SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
            siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
        siCalculator.evalForEntry("localAmount=localTaxAmount-localTax", this.getLocalAmountPrecision());
        if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            BigDecimal discountRate;
            BigDecimal bigDecimal = discountRate = null == this.getDiscountRate(i) ? new BigDecimal("0.0") : this.getDiscountRate(i);
            if (discountRate.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) >= 0) {
                siCalculator.evalForEntry("taxPrice=taxAmount/qty", this.getPricePrecision(i));
                siCalculator.evalForEntry("discount=0", this.getPricePrecision(i));
            } else {
                siCalculator.evalForEntry("taxPrice=taxAmount/qty/(1-discount/100)", this.getPricePrecision(i));
            }
        } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("taxPrice=taxAmount/qty+discount", this.getPricePrecision(i));
        }
        if (SysConstant.BIGZERO.compareTo(this.getTaxPrice(i)) == 0 && this.isInTax()) {
            siCalculator.evalForEntry("discount=0", this.getDiscountRate(i).scale());
        }
        siCalculator.evalForEntry("price=taxPrice/(1+taxRate/100)", this.getPricePrecision(i));
        if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) == 0 && !this.isInTax()) {
            siCalculator.evalForEntry("discount=0", this.getDiscountRate(i).scale());
        }
        if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
        } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
        } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=discount*qty", this.getAmountPrecision());
        }
        if (this.getDiscountRate(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscountRate(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
        }
    }

    @Override
    protected void calByTaxPrice(int i) {
        this.calDiscountAmount(i);
        this.calTaxAmount(i);
        this.calTax(i);
        this.calLocalTaxAmount(i);
        this.calLocalTax(i);
        this.calAmount(i);
        this.calLocalAmount(i);
        this.calPriceByTaxPrice(i);
        this.calActualPrice(i);
        this.calActualTaxPrice(i);
    }

    protected void calByTaxPrice(int i, PropertyCalculator siCalculator) {
        if (SysConstant.BIGZERO.compareTo(this.getTaxPrice(i)) == 0 && this.isInTax()) {
            siCalculator.evalForEntry("discount=0", this.getDiscountRate(i).scale());
        }
        if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
        } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
        } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=discount*qty", this.getAmountPrecision());
        }
        DiscountModeEnum discountMode = this.getDiscountType(i);
        if (null != discountMode && DiscountModeEnum.PERCENT.equals((Object)discountMode)) {
            siCalculator.evalForEntry("taxAmount=qty*taxPrice*(1-discount/100)", this.getAmountPrecision());
        } else {
            siCalculator.evalForEntry("taxAmount=qty*(taxPrice-discount)", this.getAmountPrecision());
        }
        siCalculator.evalForEntry("tax=taxAmount/(1+taxRate/100)*(taxRate/100)", this.getAmountPrecision());
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localTaxAmount=taxAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else {
            siCalculator.evalForEntry("localTaxAmount=taxAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else if (this.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE && SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
            siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
        siCalculator.evalForEntry("amount=taxAmount-tax", this.getAmountPrecision());
        siCalculator.evalForEntry("localAmount=localTaxAmount-localTax", this.getLocalAmountPrecision());
        siCalculator.evalForEntry("price=taxPrice/(1+taxRate/100)", this.getPricePrecision(i));
        if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) == 0 && !this.isInTax()) {
            siCalculator.evalForEntry("discount=0", this.getDiscountRate(i).scale());
        }
        if (this.getDiscountRate(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscountRate(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
        }
    }

    protected void calByActualTaxPrice(int i, PropertyCalculator siCalculator) {
        BigDecimal discountRate;
        int discountPrecision = this.getDiscountRatePrecision(i);
        if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discount=(taxPrice-actualTaxPrice)/taxPrice*100", discountPrecision);
        } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discount=taxPrice-actualTaxPrice", discountPrecision);
        }
        if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=taxPrice*qty*discount/100", this.getAmountPrecision());
        } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=qty*discount", this.getAmountPrecision());
        }
        if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("taxAmount=taxPrice*qty*(1-discount/100)", this.getAmountPrecision());
        } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("taxAmount=qty*(taxPrice-discount)", this.getAmountPrecision());
        }
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localTaxAmount=taxAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else if (this.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE && SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
            siCalculator.evalForEntry("localTaxAmount=taxAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
        siCalculator.evalForEntry("tax=taxAmount/(1+taxRate/100)*(taxRate/100)", this.getAmountPrecision());
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else if (this.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE && SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
            siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
        siCalculator.evalForEntry("amount=taxAmount-tax", this.getAmountPrecision());
        siCalculator.evalForEntry("localAmount=localTaxAmount-localTax", this.getLocalAmountPrecision());
        BigDecimal bigDecimal = discountRate = null == this.getDiscountRate(i) ? BigDecimal.ZERO : this.getDiscountRate(i);
        if (SysConstant.BIGZERO.compareTo(discountRate) == 0) {
            siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
        }
    }

    protected void calByActualPrice(int i, PropertyCalculator siCalculator) {
        BigDecimal discountRate;
        int discountPrecision = this.getDiscountRatePrecision(i);
        if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discount=(price-actualPrice)/price*100", discountPrecision);
        } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discount=price-actualPrice", discountPrecision);
        }
        if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=taxPrice*qty*discount/100", this.getAmountPrecision());
        } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=qty*discount*(1+taxRate/100)", this.getAmountPrecision());
        }
        if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("amount=qty*price*(1-discount/100)", this.getAmountPrecision());
        } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("amount=qty*(price-discount)", this.getAmountPrecision());
        }
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localAmount=amount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else if (this.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE && SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
            siCalculator.evalForEntry("localAmount=amount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
        siCalculator.evalForEntry("tax=amount*(taxRate/100)", this.getAmountPrecision());
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else if (this.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE && SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
            siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
        siCalculator.evalForEntry("taxAmount=amount+tax", this.getAmountPrecision());
        siCalculator.evalForEntry("localTaxAmount=localAmount+localTax", this.getLocalAmountPrecision());
        BigDecimal bigDecimal = discountRate = null == this.getDiscountRate(i) ? BigDecimal.ZERO : this.getDiscountRate(i);
        if (SysConstant.BIGZERO.compareTo(discountRate) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
        }
    }

    @Override
    protected void calDiscountAmount(int i) {
        if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
            this.setDiscountAmount(SysConstant.BIGZERO.setScale(this.getAmountPrecision()), i);
        } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            super.calDiscountAmount(i);
        } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            if (this.isInTax()) {
                this.setDiscountAmount(this.getDiscountRate(i).multiply(this.getQty(i)).setScale(this.getAmountPrecision(), 4), i);
            } else {
                BigDecimal discountAmount = this.getDiscountRate(i).multiply(this.getQty(i)).setScale(this.getAmountPrecision(), 4);
                discountAmount = discountAmount.multiply(SCMConstant.BIGDECIMAL_ONE.add(this.getRealTaxRate(i)));
                discountAmount = discountAmount.setScale(this.getAmountPrecision(), 4);
                this.setDiscountAmount(discountAmount, i);
            }
        }
    }

    @Override
    protected void calPriceByAmount(int i) {
        if (this.getQty(i).compareTo(SysConstant.BIGZERO) == 0) {
            return;
        }
        if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
            this.setPrice(SysConstant.BIGZERO.setScale(this.getPricePrecision(i)), i);
        } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            super.calPriceByAmount(i);
        } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            BigDecimal taxRate = this.getTaxRate(i).divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4);
            BigDecimal price = this.getAmount(i).divide(this.getQty(i), 10, 4).add(this.getDiscountRate(i).divide(SCMConstant.BIGDECIMAL_ONE.add(taxRate), 10, 4));
            this.setPrice(price.setScale(this.getPricePrecision(i), 4), i);
        }
    }

    protected void calQty(int i) throws BaseException {
        BigDecimal baseQty = this.getBaseQty(i);
        BigDecimal qty = SysConstant.BIGZERO;
        MultiMeasureUnitInfo mulUnit = this.getMulUnit(this.ctx, this.getUnit(i), this.getMaterial(i));
        if (mulUnit != null) {
            BigDecimal coefficient = mulUnit.getBaseConvsRate();
            int precision = mulUnit.getQtyPrecision();
            if (coefficient != null && SysConstant.BIGZERO.compareTo(coefficient) != 0) {
                qty = baseQty.divide(coefficient, precision, 4);
            }
        }
        this.setQty(qty, i);
    }

    @Override
    protected void calTaxPrice(int i) {
        if (this.getQty(i).compareTo(SysConstant.BIGZERO) == 0) {
            return;
        }
        if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
            this.setTaxPrice(SysConstant.BIGZERO.setScale(this.getPricePrecision(i), 4), i);
        } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            super.calTaxPrice(i);
        } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            if (this.isInTax()) {
                BigDecimal taxPrice = this.getTaxAmount(i).divide(this.getQty(i), 10, 4).add(this.getDiscountRate(i));
                this.setTaxPrice(taxPrice.setScale(this.getPricePrecision(i), 4), i);
            } else {
                BigDecimal taxPrice = CalculateUtils.calTaxPrice((BigDecimal)this.getPrice(i), (BigDecimal)this.getTaxRate(i), (int)this.getPricePrecision(i));
                this.setTaxPrice(taxPrice, i);
            }
        }
    }

    protected void calTotalActualCost() {
        BigDecimal totalActualCost = SysConstant.BIGZERO;
        for (int i = 0; i < this.getEntrySize(); ++i) {
            totalActualCost = totalActualCost.add(this.getActualCost(i));
        }
        this.setTotalActualCost(totalActualCost);
    }

    @Override
    protected void calTotalAmount() {
        BigDecimal totalAmount = SysConstant.BIGZERO;
        for (int i = 0; i < this.getEntrySize(); ++i) {
            totalAmount = totalAmount.add(this.getAmount(i));
        }
        this.setTotalAmount(totalAmount);
    }

    protected void calTotalLocalTaxAmount() {
        BigDecimal totalLocalAmount = SysConstant.BIGZERO;
        for (int i = 0; i < this.getEntrySize(); ++i) {
            totalLocalAmount = totalLocalAmount.add(this.getLocalTaxAmount(i));
        }
        this.setTotalLocalAmount(totalLocalAmount);
    }

    protected void calTotalStandardCost() {
        BigDecimal totalStandardCost = SysConstant.BIGZERO;
        for (int i = 0; i < this.getEntrySize(); ++i) {
            totalStandardCost = totalStandardCost.add(this.getStandardCost(i));
        }
        this.setTotalStandardCost(totalStandardCost);
    }

    @Override
    protected void calTotalTax() {
    }

    @Override
    protected void calTotalTaxAmount() {
        BigDecimal totalTaxAmount = SysConstant.BIGZERO;
        for (int i = 0; i < this.getEntrySize(); ++i) {
            totalTaxAmount = totalTaxAmount.add(this.getTaxAmount(i));
        }
        this.setTotalTaxAmount(totalTaxAmount);
    }

    protected void calUnitStandardCost(int i) throws BOSException, EASBizException {
        BigDecimal coefficient;
        MaterialCompanyInfoInfo aMaterialCompanyInfoInfo = null;
        BigDecimal baseUnitStandardCost = SysConstant.BIGZERO;
        if (this.getMaterial(i) != null && this.getMaterial(i).getId() != null && (aMaterialCompanyInfoInfo = this.getMaterialCompanyInfo(this.getMaterial(i).getId().toString())) != null && aMaterialCompanyInfoInfo.getStandardCost() != null) {
            baseUnitStandardCost = aMaterialCompanyInfoInfo.getStandardCost();
        }
        BigDecimal unitStandardCost = baseUnitStandardCost;
        MultiMeasureUnitInfo mulUnit = this.getMulUnit(this.ctx, this.getUnit(i), this.getMaterial(i));
        if (mulUnit != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
            unitStandardCost = unitStandardCost.multiply(coefficient);
        }
        this.setUnitStandardCost(unitStandardCost, i);
        if (aMaterialCompanyInfoInfo != null && AccountType.STANDARDCOST.equals((Object)aMaterialCompanyInfoInfo.getAccountType())) {
            this.setUnitActualCost(unitStandardCost, i);
            BigDecimal qty = this.getQty(i);
            BigDecimal standardCost = unitStandardCost.multiply(qty);
            standardCost = standardCost.setScale(this.getLocalAmountPrecision(), 4);
            this.setActualCost(standardCost, i);
        }
    }

    protected void calStandardCostByUnitStandardCost(int i) {
        BigDecimal qty = this.getQty(i);
        BigDecimal unitStandardCost = this.getUnitStandardCost(i);
        BigDecimal standardCost = unitStandardCost.multiply(qty);
        standardCost = standardCost.setScale(this.getLocalAmountPrecision(), 4);
        this.setStandardCost(standardCost, i);
    }

    protected void calUnitActualCost(int i) {
        if (this.getQty(i).compareTo(SysConstant.BIGZERO) != 0) {
            this.setUnitActualCost(this.getActualCost(i).divide(this.getQty(i), this.getPricePrecision(i), 4), i);
        }
    }

    protected abstract BigDecimal getActualCost(int var1);

    @Override
    protected abstract BigDecimal getAmount(int var1);

    protected abstract int getDiscountRatePrecision(int var1);

    protected abstract DiscountModeEnum getDiscountType(int var1);

    protected abstract BigDecimal getLocalAmount(int var1);

    protected abstract BigDecimal getLocalTaxAmount(int var1);

    @Override
    protected abstract BigDecimal getPrice(int var1);

    protected abstract BigDecimal getStandardCost(int var1);

    @Override
    protected abstract BigDecimal getTaxAmount(int var1);

    @Override
    protected final boolean isPriceInTax() {
        return true;
    }

    @Override
    protected abstract void setAmount(BigDecimal var1, int var2);

    @Override
    protected abstract void setLocalAmount(BigDecimal var1, int var2);

    @Override
    protected abstract void setLocalTaxAmount(BigDecimal var1, int var2);

    @Override
    protected abstract void setPrice(BigDecimal var1, int var2);

    @Override
    protected abstract void setQty(BigDecimal var1, int var2);

    @Override
    protected abstract void setTaxAmount(BigDecimal var1, int var2);

    protected abstract void setTotalActualCost(BigDecimal var1);

    protected abstract void setTotalAmount(BigDecimal var1);

    protected abstract void setTotalLocalAmount(BigDecimal var1);

    protected abstract void setTotalStandardCost(BigDecimal var1);

    protected abstract void setTotalTaxAmount(BigDecimal var1);

    protected abstract void setUnitActualCost(BigDecimal var1, int var2);

    protected abstract void setUnitStandardCost(BigDecimal var1, int var2);

    protected abstract void setActualCost(BigDecimal var1, int var2);

    protected abstract BigDecimal getUnitStandardCost(int var1);

    protected abstract void setStandardCost(BigDecimal var1, int var2);
}

