/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.InvException;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.cal.IManualWriteOffFacade;
import com.kingdee.eas.scm.cal.ManualWriteOffFacadeFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.im.inv.IInvBillBase;
import com.kingdee.eas.scm.im.inv.IInventoryUpdate;
import com.kingdee.eas.scm.im.inv.IPurInWarehsBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryCollection;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InventoryUpdateFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.app.ICreatePurInExecutor;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.inv.app.PurInAlgorithmForInfo;
import com.kingdee.eas.scm.im.inv.app.invupdate.engin.InventoryCheck4VMICalculator;
import com.kingdee.eas.scm.im.inv.util.AccountViewUtil;
import com.kingdee.eas.scm.im.inv.vmi.CreateTypeEnum;
import com.kingdee.eas.scm.im.inv.vmi.PurOrg4VMIParam;
import com.kingdee.eas.scm.im.inv.vmi.RecordTypeEnum;
import com.kingdee.eas.scm.im.inv.vmi.VMISettleCommonFacadeFactory;
import com.kingdee.eas.scm.im.inv.vmi.VMISettleGroupFactory;
import com.kingdee.eas.scm.im.inv.vmi.VMISettleGroupInfo;
import com.kingdee.eas.scm.im.inv.vmi.VMISettleRecordInfo;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractCreatePurInBillExecutor
implements ICreatePurInExecutor {
    protected Context ctx;
    protected InvBillBaseInfo invInfo;
    protected String billId;
    protected MaterialReqBillInfo matReqInfo;
    protected BizActionEnum bizAction;

    public AbstractCreatePurInBillExecutor(Context ctx, String billId, BizActionEnum bizAction) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.billId = billId;
        this.bizAction = bizAction;
        this.invInfo = this.getInstance().getInvBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
    }

    @Override
    public boolean check() throws BOSException, EASBizException {
        InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)this.invInfo.getEntries().getObject(0);
        if (entry != null && entry.getSourceBillType() != null && entry.getSourceBillType().getId().toString().equals("50957179-0105-1000-e000-0163c0a812fd463ED552")) {
            String id = entry.getSourceBillId();
            this.matReqInfo = MaterialReqBillFactory.getLocalInstance(this.ctx).getMaterialReqBillInfo((IObjectPK)new ObjectUuidPK(id));
            if (this.isJumpBiz(this.matReqInfo)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void execute() throws BOSException, EASBizException {
        if (BizActionEnum.AUDIT.equals((Object)this.bizAction)) {
            this.execute4Audit();
        } else {
            this.execute4UnAudit();
        }
    }

    public void execute4Audit() throws BOSException, EASBizException {
        HashMap<String, InvBillBaseEntryCollection> supplierMap = new HashMap<String, InvBillBaseEntryCollection>();
        InventoryCheck4VMICalculator calculator = InventoryCheck4VMICalculator.getInstance(this.ctx, this.getBillEntryTable());
        String bosType = new ObjectUuidPK(this.billId).getObjectType().toString();
        calculator.calculate(bosType, this.billId, OperationTypeEnum.Positive);
        if (calculator.isEnough() && calculator.getSupplierMap().size() > 0) {
            IObjectCollection entryCollection = this.invInfo.getEntries();
            HashMap<String, InvBillBaseEntryInfo> entryMap = new HashMap<String, InvBillBaseEntryInfo>();
            for (int i = 0; i < entryCollection.size(); ++i) {
                entryMap.put(((InvBillBaseEntryInfo)entryCollection.getObject(i)).getId().toString(), (InvBillBaseEntryInfo)entryCollection.getObject(i));
            }
            Map<String, Set<String>> supplierEntryIDMap = calculator.getSupplierMap();
            Set<String> supplierIdSet = supplierEntryIDMap.keySet();
            for (String supplierId : supplierIdSet) {
                Set<String> idSet = supplierEntryIDMap.get(supplierId);
                Iterator<String> idIT = idSet.iterator();
                InvBillBaseEntryCollection coll = new InvBillBaseEntryCollection();
                while (idIT.hasNext()) {
                    String entryId = idIT.next();
                    coll.add((InvBillBaseEntryInfo)entryMap.get(entryId));
                }
                supplierMap.put(supplierId, coll);
            }
        } else {
            return;
        }
        if (supplierMap.size() <= 0) {
            return;
        }
        Set set = supplierMap.keySet();
        Iterator it = set.iterator();
        int key = 1;
        while (it.hasNext()) {
            HashMap<String, InvBillBaseInfo> infoMap = new HashMap<String, InvBillBaseInfo>();
            InvBillBaseEntryCollection vmiRecordColl = new InvBillBaseEntryCollection();
            String supplierID = (String)it.next();
            InvBillBaseEntryCollection coll = (InvBillBaseEntryCollection)((Object)supplierMap.get(supplierID));
            InvBillBaseInfo newInfo = (InvBillBaseInfo)this.invInfo.clone();
            newInfo.getEntries().clear();
            newInfo.getEntries().addObjectCollection((IObjectCollection)coll);
            CoreBillBaseCollection coreBillBaseColl = new CoreBillBaseCollection();
            coreBillBaseColl.add((CoreBillBaseInfo)newInfo);
            vmiRecordColl.addObjectCollection((IObjectCollection)coll);
            for (int i = 0; i < coll.size(); ++i) {
                infoMap.put(coll.get(i).getId().toString(), this.invInfo);
            }
            BOTMappingInfo botMappingInfo = null;
            String botpName = this.getBotpNumber();
            try {
                botMappingInfo = BOTMappingFactory.getLocalInstance((Context)this.ctx).getBOTMappingInfo("where name = '" + botpName + "'");
            }
            catch (Exception e) {
                throw new InvException(InvException.BOTPERROR, (Object[])new String[]{botpName});
            }
            if (!botMappingInfo.getExtRule().isIsEffected()) {
                throw new InvException(InvException.BOTPERROR, (Object[])new String[]{botpName});
            }
            BTPTransformResult transformResult = BTPManagerFactory.getLocalInstance((Context)this.ctx).transform(coreBillBaseColl, botMappingInfo);
            IObjectCollection infos = transformResult.getBills();
            String numberSign = "*VMI";
            String srcNumber = this.invInfo.getNumber();
            String purInNumber = numberSign + srcNumber + "_" + key;
            for (int i = 0; i < infos.size(); ++i) {
                PurInWarehsBillInfo purInfo = (PurInWarehsBillInfo)infos.getObject(i);
                SupplierInfo supplierInfo = new SupplierInfo();
                supplierInfo.setId(BOSUuid.read((String)supplierID));
                purInfo.setNumber(purInNumber);
                purInfo.setSupplier(supplierInfo);
                purInfo.setIsInitBill(false);
                purInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)this.ctx));
                purInfo.setAuditTime(new Timestamp(new Date().getTime()));
                purInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
                purInfo.setIsReversed(false);
                purInfo.put("isSysBill", Boolean.TRUE);
                this.setEntryValue(this.invInfo, purInfo, this.ctx);
                CompanyOrgUnitInfo company = InvServerUtils.getCompanyInfoForStorage(this.ctx, purInfo.getStorageOrgUnit());
                PeriodInfo period = PeriodUtils.getPeriodInfo((Context)this.ctx, (Date)purInfo.getBizDate(), (CompanyOrgUnitInfo)company);
                if (period != null) {
                    purInfo.setYear(period.getPeriodYear());
                    purInfo.setPeriod(period.getPeriodNumber());
                }
                purInfo.setMonth(this.invInfo.getInt("month"));
                purInfo.setDay(this.invInfo.getInt("day"));
                IObjectPK pk = PurInWarehsBillFactory.getLocalInstance(this.ctx).addnew((CoreBaseInfo)purInfo);
                IInventoryUpdate iInventoryUpdate = InventoryUpdateFactory.getLocalInstance((Context)this.ctx);
                String transTypeID = null;
                if (purInfo.getTransactionType() != null) {
                    transTypeID = purInfo.getTransactionType().getId().toString();
                    iInventoryUpdate.updateInventory(BizActionEnum.AUDIT, pk.toString(), transTypeID);
                }
                SCMServerUtils.traceUpAndDown((Context)this.ctx, (String)this.invInfo.getId().toString(), (String)purInfo.getId().toString(), (String)this.invInfo.getBOSType().toString(), (String)purInfo.getBOSType().toString());
                vmiRecordColl.addObjectCollection(purInfo.getEntries());
                for (int j = 0; j < purInfo.getEntries().size(); ++j) {
                    infoMap.put(purInfo.getEntries().getObject(j).get("id").toString(), purInfo);
                }
            }
            AccountViewUtil.updateAccountView(this.ctx, infos);
            this.createSettleGroupInfo((IObjectCollection)vmiRecordColl, infoMap);
            ++key;
        }
    }

    public void execute4UnAudit() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FDestObjectID from t_bot_relation where FSrcEntityID = '").append(this.getBosType()).append("'");
        sql.append(" and FDestEntityID = '").append("783061E3").append("'");
        sql.append(" and FSrcObjectID = '").append(this.billId).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            HashSet<String> idSet = new HashSet<String>();
            while (rs.next()) {
                String id = rs.getString("FDestObjectID");
                idSet.add(id);
            }
            if (idSet.size() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                view.setFilter(filter);
                PurInWarehsBillCollection coll = PurInWarehsBillFactory.getLocalInstance(this.ctx).getPurInWarehsBillCollection(view);
                IPurInWarehsBill iPurInWarehsBill = PurInWarehsBillFactory.getLocalInstance(this.ctx);
                IManualWriteOffFacade iManualWriteOffFacade = ManualWriteOffFacadeFactory.getLocalInstance((Context)this.ctx);
                IInventoryUpdate iInventoryUpdate = InventoryUpdateFactory.getLocalInstance((Context)this.ctx);
                PurInWarehsBillInfo aPurInWarehsBillInfo = null;
                for (int i = 0; i < coll.size(); ++i) {
                    aPurInWarehsBillInfo = coll.get(i);
                    String transTypeID = null;
                    if (aPurInWarehsBillInfo.getTransactionType() != null) {
                        transTypeID = aPurInWarehsBillInfo.getTransactionType().getId().toString();
                        iInventoryUpdate.updateInventory(BizActionEnum.UNAUDIT, aPurInWarehsBillInfo.getId().toString(), transTypeID);
                    }
                    iManualWriteOffFacade.inverseWriteOff(new String[]{aPurInWarehsBillInfo.getId().toString()});
                    this.updateUnAuditStatus(this.ctx, aPurInWarehsBillInfo);
                    iPurInWarehsBill.delete((IObjectPK)new ObjectUuidPK(aPurInWarehsBillInfo.getId().toString()));
                }
                this.deleteSettleGroupInfo(idSet);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    private void updateUnAuditStatus(Context ctx, PurInWarehsBillInfo info) throws EASBizException, BOSException {
        String tableName = "T_IM_PURINWAREHSBILL";
        Connection conn = null;
        PreparedStatement preStmt = null;
        Statement sm = null;
        try {
            StringBuilder sqlBuff = new StringBuilder();
            sqlBuff.append("Update ");
            sqlBuff.append(tableName);
            sqlBuff.append(" SET FAuditTime = ?, FAuditorID = ? , FBaseStatus = ? ");
            sqlBuff.append(" WHERE FID = ? ");
            conn = EJBFactory.getConnection((Context)ctx);
            preStmt = conn.prepareStatement(sqlBuff.toString());
            preStmt.setTimestamp(1, null);
            preStmt.setString(2, null);
            preStmt.setInt(3, 1);
            preStmt.setString(4, info.getId().toString());
            preStmt.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sm);
                SQLUtils.cleanup(preStmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(sm);
        SQLUtils.cleanup((Statement)preStmt, (Connection)conn);
    }

    private void setEntryValue(InvBillBaseInfo invInfo, PurInWarehsBillInfo purInfo, Context ctx) throws BOSException, EASBizException {
        PurInWarehsEntryCollection coll = purInfo.getEntry();
        PurInWarehsEntryInfo purEntry = null;
        SupplierInfo supplierInfo = purInfo.getSupplier();
        PurOrg4VMIParam[] params = new PurOrg4VMIParam[coll.size()];
        String storageOrgID = purInfo.getStorageOrgUnit().getId().toString();
        String supplierID = supplierInfo.getId().toString();
        for (int i = 0; i < coll.size(); ++i) {
            purEntry = coll.get(i);
            params[i] = new PurOrg4VMIParam();
            params[i].setMaterialID(purEntry.getMaterial().getId().toString());
            params[i].setStorageOrgID(storageOrgID);
            params[i].setSupplierID(supplierID);
        }
        PurchaseOrgUnitInfo[] purOrgInfos = VMISettleCommonFacadeFactory.getLocalInstance(ctx).getPurOrg4VMI(params);
        InvUpdateTypeInfo invUpdateTypeInfo = InvUpdateTypeFactory.getLocalInstance((Context)ctx).getInvUpdateTypeInfo("where id = 'CeUAAAAIdBzC73rf'");
        for (int i = 0; i < coll.size(); ++i) {
            purEntry = coll.get(i);
            purEntry.setInvUpdateType(invUpdateTypeInfo);
            purEntry.setBalanceSupplier(supplierInfo);
            purEntry.setPurchaseOrgUnit(purOrgInfos[i]);
        }
        purInfo.put("IS_VMI_BIZ", true);
        new PurInAlgorithmForInfo(purInfo, ctx).revalue();
        purInfo.remove("IS_VMI_BIZ");
    }

    private VMISettleGroupInfo createSettleGroupInfo(IObjectCollection vmiRecordColl, Map<String, InvBillBaseInfo> infoMap) throws EASBizException, BOSException {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        Date date = new Date();
        InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)this.invInfo.getEntries().getObject(0);
        VMISettleGroupInfo groupInfo = new VMISettleGroupInfo();
        groupInfo.setId(BOSUuid.create((BOSObjectType)groupInfo.getBOSType()));
        groupInfo.setNumber(format.format(date) + "0");
        groupInfo.setCompanyOrgUnit(entry.getCompanyOrgUnit());
        groupInfo.setCreateTime(new Timestamp(date.getTime()));
        groupInfo.setSettleDate(this.invInfo.getBizDate());
        groupInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)this.ctx));
        groupInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)this.ctx));
        groupInfo.setCreateType(CreateTypeEnum.AutoSettle);
        this.createSettleRecordList(groupInfo, vmiRecordColl, infoMap);
        VMISettleGroupFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)groupInfo);
        this.writeBackVMIBaseQty(vmiRecordColl);
        return groupInfo;
    }

    private void deleteSettleGroupInfo(Set<String> idSet) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct grp.FID as FID from T_IM_VMISettleRecord record inner join T_IM_VMISettleGroup grp on grp.FID = record.FParentID");
        sql.append(" where record.FBillID in (").append(CollectionUtil.convertList2String(new ArrayList<String>(idSet))).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        if (rs.size() > 0) {
            ObjectUuidPK[] arrayPK = new ObjectUuidPK[rs.size()];
            int i = 0;
            try {
                while (rs.next()) {
                    arrayPK[i] = new ObjectUuidPK(rs.getString("FID"));
                    ++i;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs);
            }
            VMISettleGroupFactory.getLocalInstance(this.ctx).delete((IObjectPK[])arrayPK);
        }
    }

    private void writeBackVMIBaseQty(IObjectCollection vmiRecordColl) throws EASBizException, BOSException {
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < vmiRecordColl.size(); ++i) {
            idSet.add(vmiRecordColl.getObject(i).get("id").toString());
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update T_IM_PURINWAREHSENTRY set FUnVmiSettleBaseQty = 0,FTotalVmiSettleBaseQty = FBaseQty");
        sql.append(" where FID in (").append(CollectionUtil.convertList2String(new ArrayList(idSet))).append(")");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("update ").append(this.getBillEntryTable()).append(" set FUnVmiSettleBaseQty = 0,FTotalVmiSettleBaseQty = FBaseQty");
        sql.append(" where FID in (").append(CollectionUtil.convertList2String(new ArrayList(idSet))).append(")");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    private void createSettleRecordList(VMISettleGroupInfo groupInfo, IObjectCollection vmiRecordColl, Map<String, InvBillBaseInfo> infoMap) {
        int seq = 0;
        int groupNo = 0;
        InvBillBaseInfo info = null;
        InvBillBaseEntryInfo entryInfo = null;
        for (int i = 0; i < vmiRecordColl.size(); ++i) {
            entryInfo = (InvBillBaseEntryInfo)vmiRecordColl.getObject(i);
            info = infoMap.get(entryInfo.getId().toString());
            this.createSettleRecordInfo(groupInfo, info, entryInfo, seq++, groupNo);
        }
    }

    protected VMISettleRecordInfo createSettleRecordInfo(VMISettleGroupInfo groupInfo, InvBillBaseInfo info, InvBillBaseEntryInfo entryInfo, int seq, int groupNO) {
        VMISettleRecordInfo recordInfo = new VMISettleRecordInfo();
        recordInfo.setId(BOSUuid.create((BOSObjectType)recordInfo.getBOSType()));
        recordInfo.setGroupNO(groupNO);
        recordInfo.setSeq(seq);
        recordInfo.setBillType(info.getBillType());
        recordInfo.setBizType(info.getBizType());
        recordInfo.setTransactionType(info.getTransactionType());
        recordInfo.setBillID(info.getId().toString());
        recordInfo.setBillEntryID(entryInfo.getId().toString());
        recordInfo.setBillEntrySeq(entryInfo.getSeq());
        recordInfo.setBillNumber(info.getNumber());
        recordInfo.setBillDate(info.getBizDate());
        SupplierInfo supplierInfo = (SupplierInfo)info.get("supplier");
        if (supplierInfo == null) {
            supplierInfo = (SupplierInfo)entryInfo.get("supplier");
        }
        recordInfo.setSupplier(supplierInfo);
        recordInfo.setCompanyOrgUnit(entryInfo.getCompanyOrgUnit());
        recordInfo.setStorageOrgUnit(entryInfo.getStorageOrgUnit());
        recordInfo.setMaterial(entryInfo.getMaterial());
        recordInfo.setLot(entryInfo.getLot());
        recordInfo.setAssistProperty(entryInfo.getAssistProperty());
        recordInfo.setUnit(entryInfo.getUnit());
        recordInfo.setQty(entryInfo.getQty());
        recordInfo.setBaseUnit(entryInfo.getBaseUnit());
        recordInfo.setBaseQty(entryInfo.getBaseQty());
        recordInfo.setWarehouse(entryInfo.getWarehouse());
        recordInfo.setLocation(entryInfo.getLocation());
        recordInfo.setProject(entryInfo.getProject());
        recordInfo.setTrackNumber(entryInfo.getTrackNumber());
        recordInfo.setCalculator(ContextUtil.getCurrentUserInfo((Context)this.ctx));
        recordInfo.setCurrentVmiSettleBaseQty(entryInfo.getBaseQty());
        recordInfo.setUnVmiSettleBaseQty(BigDecimal.ZERO);
        recordInfo.setRecordType(RecordTypeEnum.Dest);
        groupInfo.getEntry().add(recordInfo);
        return recordInfo;
    }

    protected abstract IInvBillBase getInstance() throws EASBizException, BOSException;

    protected abstract boolean isJumpBiz(MaterialReqBillInfo var1) throws EASBizException, BOSException;

    protected abstract String getBillEntryTable() throws EASBizException, BOSException;

    protected abstract String getBotpNumber() throws EASBizException, BOSException;

    protected abstract String getBosType() throws EASBizException, BOSException;

    protected abstract SelectorItemCollection getSelector() throws EASBizException, BOSException;
}

