/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseCollection;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseFactory;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.DataCollectionTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractAutoBillProcessor;
import com.kingdee.eas.scm.im.inv.app.IAutoBillProcessor;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillFactory;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class AutoSaleIssueProcessor
extends AbstractAutoBillProcessor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.AutoCreateBill4SaleIssue");

    private AutoSaleIssueProcessor() {
    }

    public static IAutoBillProcessor getInstance() {
        return new AutoSaleIssueProcessor();
    }

    @Override
    public void _autoCreate(Context ctx, SCMBillBaseInfo billInfo) throws EASBizException, BOSException {
        this.createChannelInWarehsBill(ctx, (SaleIssueBillInfo)billInfo);
    }

    private void createChannelInWarehsBill(Context ctx, SaleIssueBillInfo siInfo) throws BOSException, EASBizException {
        try {
            if (!this.isAutoCreateInWarehs(ctx, siInfo)) {
                return;
            }
            BTPTransformResult result = this.createBillByBotp(ctx, siInfo);
            this.updateBillInfo(ctx, siInfo, result);
            this.saveBotpBill(result, ctx);
        }
        catch (SQLException e) {
            logger.info((Object)e);
        }
    }

    private boolean isAutoCreateInWarehs(Context ctx, SaleIssueBillInfo siInfo) throws EASBizException, BOSException {
        boolean flag = true;
        SaleIssueEntryInfo saleIssueEntryInfo = siInfo.getEntry().get(0);
        String sourceBillID = saleIssueEntryInfo.getSourceBillId();
        if (!"d8e80652-010e-1000-e000-04c5c0a812202407435C".equals(siInfo.getBizType().getId().toString())) {
            return false;
        }
        if (siInfo.isIsReversed()) {
            return false;
        }
        if (sourceBillID == null) {
            return true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID, FSOURCEBILLID FROM T_SD_SALERETURNSENTRY WHERE FPARENTID IN (");
        sql.append("SELECT FID FROM T_SD_SALERETURNS WHERE FID = '").append(sourceBillID).append("')");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs == null || rs != null && rs.size() < 1) {
            return true;
        }
        try {
            rs.next();
            sourceBillID = rs.getString("FSOURCEBILLID");
            if (sourceBillID == null || "".equals(sourceBillID)) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            return false;
        }
        sql.setLength(0);
        sql.append("SELECT FID FROM T_CHA_CHANNELINWAREHSBILL WHERE FID = '").append(sourceBillID).append("'");
        IRowSet rsiw = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rsiw == null || rsiw != null && rsiw.size() < 1) {
            return true;
        }
        flag = false;
        return flag;
    }

    @Override
    protected IObjectPK[] saveBotpBill(BTPTransformResult result, Context ctx) throws BOSException, EASBizException {
        if (result == null) {
            return null;
        }
        IBTPManager iBtpManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        IObjectCollection destBillCols = result.getBills();
        BOTRelationCollection botRelationCols = result.getBOTRelationCollection();
        IObjectPK[] pks = new IObjectPK[destBillCols.size()];
        int count = destBillCols.size();
        for (int i = 0; i < count; ++i) {
            CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)destBillCols.getObject(i);
            pks[i] = iBtpManager.submitRelations(destBillInfo, botRelationCols);
        }
        return pks;
    }

    @Override
    protected boolean shouldAutoCreate(Context ctx, SCMBillBaseInfo siInfo) throws BOSException {
        if (!this.hasSaleOrgUnit((SaleIssueBillInfo)siInfo)) {
            return false;
        }
        ChannelBaseInfo cbInfo = this.getChannelOfCustomer(ctx, (SaleIssueBillInfo)siInfo);
        return cbInfo != null && (cbInfo.getDataCollectionType() == DataCollectionTypeEnum.REPORTINSTORAGE || cbInfo.getDataCollectionType() == DataCollectionTypeEnum.REPORTINSALE);
    }

    private boolean hasSaleOrgUnit(SaleIssueBillInfo billInfo) {
        int size = billInfo.getEntry().size();
        for (int i = 0; i < size; ++i) {
            SaleIssueEntryInfo entryInfo = billInfo.getEntry().get(i);
            if (entryInfo.getSaleOrgUnit() == null) continue;
            return true;
        }
        return false;
    }

    private ChannelBaseInfo getChannelOfCustomer(Context ctx, SaleIssueBillInfo siInfo) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("customer.id", (Object)siInfo.getCustomer().getId().toString());
        filter.appendFilterItem("terminalChannelStatus", (Object)"0");
        view.setFilter(filter);
        view.getSelector().add("id");
        view.getSelector().add("dataCollectionType");
        view.getSelector().add("name");
        view.getSelector().add("number");
        ChannelBaseCollection cbCol = ChannelBaseFactory.getLocalInstance((Context)ctx).getChannelBaseCollection(view);
        ChannelBaseInfo cbInfo = null;
        if (cbCol.size() > 0) {
            cbInfo = cbCol.get(0);
        }
        return cbInfo;
    }

    private void updateBillInfo(Context ctx, SaleIssueBillInfo siInfo, BTPTransformResult result) throws EASBizException, BOSException {
        if (result == null) {
            return;
        }
        this.setHeadInfo(ctx, siInfo, result);
        this.setEntryPrecision(ctx, result);
    }

    private void setHeadInfo(Context ctx, SaleIssueBillInfo siInfo, BTPTransformResult result) throws EASBizException, BOSException {
        ICodingRuleManager manager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        Map currencyMap = this.getCurrencyMap(ctx, result);
        ChannelBaseInfo cbInfo = this.getChannelOfCustomer(ctx, siInfo);
        int size = result.getBills().size();
        for (int i = 0; i < size; ++i) {
            ChannelInWarehsBillInfo ciwBillInfo = (ChannelInWarehsBillInfo)result.getBills().getObject(i);
            if (manager.getCodingRule((IObjectValue)ciwBillInfo, ciwBillInfo.getSaleOrgUnit().getId().toString()) == null) {
                ciwBillInfo.setNumber("*" + siInfo.getNumber());
            }
            ciwBillInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
            ciwBillInfo.setChannel(cbInfo);
            ciwBillInfo.setLastUpdateTime(null);
            ciwBillInfo.setAuditTime(null);
            ciwBillInfo.setModificationTime(null);
            CurrencyInfo curInfo = (CurrencyInfo)currencyMap.get(ciwBillInfo.getCurrency().getId().toString());
            ciwBillInfo.setCurrencyPrecision(curInfo.getPrecision());
            curInfo = (CurrencyInfo)currencyMap.get(ciwBillInfo.get("baseCurId"));
            if (curInfo == null) continue;
            ciwBillInfo.setLocalCurPrecision(curInfo.getPrecision());
            ExchangeRateInfo rateInfo = SCMServerUtils.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)ciwBillInfo.get("couInfo")), (IObjectPK)new ObjectUuidPK(ciwBillInfo.getCurrency().getId()), (IObjectPK)new ObjectUuidPK(curInfo.getId().toString()));
            ciwBillInfo.setExchangeRate(rateInfo == null ? new BigDecimal("1.00") : rateInfo.getConvertRate());
            ciwBillInfo.setExRatePrecision(rateInfo == null ? 2 : rateInfo.getPrecision());
        }
    }

    public void setEntryPrecision(Context ctx, BTPTransformResult result) throws EASBizException, BOSException {
        Map mmuMap = this.getMultiMeasureUnitMap(ctx, result);
        Map matMap = this.getMateiralMap(ctx, result);
        int size = result.getBills().size();
        for (int i = 0; i < size; ++i) {
            ChannelInWarehsBillInfo ciwBillInfo = (ChannelInWarehsBillInfo)result.getBills().getObject(i);
            int entrySize = ciwBillInfo.getEntries().size();
            for (int k = 0; k < entrySize; ++k) {
                MultiMeasureUnitInfo mmuInfo;
                ChannelInWarehsBillEntryInfo entryInfo = ciwBillInfo.getEntries().get(k);
                if (entryInfo.getUnit() != null) {
                    mmuInfo = (MultiMeasureUnitInfo)mmuMap.get(entryInfo.getMaterial().getId().toString() + entryInfo.getUnit().getId().toString());
                    entryInfo.setUnitPrecision(mmuInfo == null ? 0 : mmuInfo.getQtyPrecision());
                }
                if (entryInfo.getBaseUnit() != null) {
                    mmuInfo = (MultiMeasureUnitInfo)mmuMap.get(entryInfo.getMaterial().getId().toString() + entryInfo.getBaseUnit().getId().toString());
                    entryInfo.setBaseUnitPrecision(mmuInfo == null ? 0 : mmuInfo.getQtyPrecision());
                }
                if (entryInfo.getAssistUnit() != null) {
                    mmuInfo = (MultiMeasureUnitInfo)mmuMap.get(entryInfo.getMaterial().getId().toString() + entryInfo.getAssistUnit().getId().toString());
                    entryInfo.setAssistUnitPrecision(mmuInfo == null ? 0 : mmuInfo.getQtyPrecision());
                }
                entryInfo.setPricePrecision(((MaterialInfo)matMap.get(entryInfo.getMaterial().getId().toString())).getPricePrecision());
                if (entryInfo.getAmount() == null || ciwBillInfo.getExchangeRate() == null) continue;
                BigDecimal localAmount = entryInfo.getAmount().multiply(ciwBillInfo.getExchangeRate());
                entryInfo.setLocalAmount(localAmount.setScale(ciwBillInfo.getLocalCurPrecision(), 4));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BTPTransformResult createBillByBotp(Context ctx, SaleIssueBillInfo siInfo) throws BOSException, BTPException, SQLException, BOTPException {
        String botpId;
        if (siInfo.getCU() == null) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FControlUnitID from T_IM_SaleIssueBill where FID = ?", (Object[])new Object[]{siInfo.getId().toString()});
            try {
                if (rs.next()) {
                    CtrlUnitInfo cuInfo = new CtrlUnitInfo();
                    cuInfo.setId(BOSUuid.read((String)rs.getString("FControlUnitID")));
                    siInfo.setCU(cuInfo);
                }
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        if ((botpId = this.getBotpId(ctx, SCMConstant.BOSTYPE_SALEISSUE, SCMConstant.BOSTYPE_CHANNELINWAREHS, siInfo.getCU(), "INM-SD-001")) == null) {
            return null;
        }
        ArrayList<String> entriesKeys = new ArrayList<String>(siInfo.getEntry().size());
        int size = siInfo.getEntry().size();
        for (int i = 0; i < size; ++i) {
            if (siInfo.getEntry().get(i).getSaleOrgUnit() == null) continue;
            entriesKeys.add(siInfo.getEntry().get(i).getId().toString());
        }
        return entriesKeys.size() == 0 ? null : BTPManagerFactory.getLocalInstance((Context)ctx).transformForBotp(new String[]{siInfo.getId().toString()}, new String[]{"entry"}, entriesKeys, null, SCMConstant.BOSTYPE_CHANNELINWAREHS, (IObjectPK)new ObjectUuidPK(botpId), SCMConstant.BOSTYPE_SALEISSUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _autoDelete(Context ctx, SCMBillBaseInfo billInfo) throws EASBizException, BOSException {
        SaleIssueBillInfo siInfo = (SaleIssueBillInfo)billInfo;
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct ciw.FSaleOrgUnitID as FSaleOrgUnitID, ciw.FID as fid from T_IM_SaleIssueEntry si ");
        sql.append("left join T_CHA_ChannelInWarehsBillEntry ciwe on ciwe.FSourceBillEntryId = si.FID ");
        sql.append("inner join T_CHA_ChannelInWarehsBill ciw on ciwe.FParentID = ciw.FID ");
        sql.append("where ciw.FBaseStatus not in(?,?) and si.FParentID=?");
        Object[] params = new Object[]{new Integer(4), new Integer(7), siInfo.getId().toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        try {
            while (rs.next()) {
                if (ctx.get((Object)OrgType.Sale) == null && rs.getObject("FSaleOrgUnitID") != null) {
                    SaleOrgUnitInfo saleOrg = new SaleOrgUnitInfo();
                    saleOrg.setId(BOSUuid.read((String)rs.getString("FSaleOrgUnitID")));
                    ctx.remove((Object)OrgType.Sale);
                    ctx.put((Object)OrgType.Sale, (Object)saleOrg);
                }
                ChannelInWarehsBillFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(rs.getString("fid")));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    private Map getMateiralMap(Context ctx, BTPTransformResult result) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        HashSet<BOSUuid> ids = new HashSet<BOSUuid>();
        int size = result.getBills().size();
        for (int i = 0; i < size; ++i) {
            ChannelInWarehsBillInfo ciwBillInfo = (ChannelInWarehsBillInfo)result.getBills().getObject(i);
            int entrySize = ciwBillInfo.getEntries().size();
            for (int j = 0; j < entrySize; ++j) {
                ChannelInWarehsBillEntryInfo entryInfo = ciwBillInfo.getEntries().get(j);
                ids.add(entryInfo.getMaterial().getId());
            }
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add("pricePrecision");
        MaterialCollection col = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(viewInfo);
        HashMap<String, MaterialInfo> map = new HashMap<String, MaterialInfo>(col.size() * 2);
        int size2 = col.size();
        for (int i = 0; i < size2; ++i) {
            map.put(col.get(i).getId().toString(), col.get(i));
        }
        return map;
    }

    protected Map getMultiMeasureUnitMap(Context ctx, BTPTransformResult result) throws BOSException {
        HashMap<String, MultiMeasureUnitInfo> hm = new HashMap<String, MultiMeasureUnitInfo>();
        if (result.getBills().size() > 0) {
            EntityViewInfo entityViewInfo = this.getMultiMeasureUnitEntityViewInfo(result);
            MultiMeasureUnitCollection collection = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(entityViewInfo);
            if (collection != null && collection.size() > 0) {
                int n = collection.size();
                for (int i = 0; i < n; ++i) {
                    MultiMeasureUnitInfo mmuInfo = collection.get(i);
                    String key = mmuInfo.getMaterial().getId().toString() + mmuInfo.getMeasureUnit().getId().toString();
                    hm.put(key, mmuInfo);
                }
            }
        }
        return hm;
    }

    private Map getCurrencyMap(Context ctx, BTPTransformResult result) throws BOSException, EASBizException {
        HashMap<String, CurrencyInfo> hm = null;
        CurrencyCollection col = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(this.getCurrencyEntityViewInfo(ctx, result));
        hm = new HashMap<String, CurrencyInfo>(col.size() * 2);
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            hm.put(col.get(i).getId().toString(), col.get(i));
        }
        return hm;
    }

    private EntityViewInfo getCurrencyEntityViewInfo(Context ctx, BTPTransformResult result) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        HashSet<BOSUuid> currencyIds = new HashSet<BOSUuid>();
        int size = result.getBills().size();
        for (int i = 0; i < size; ++i) {
            ChannelInWarehsBillInfo ciwBillInfo = (ChannelInWarehsBillInfo)result.getBills().getObject(i);
            CompanyOrgUnitInfo couInfo = InvServerUtils.getCompanyInfo(ctx, ciwBillInfo.getSaleOrgUnit());
            ciwBillInfo.put("couInfo", (Object)couInfo);
            if (couInfo.getBaseCurrency() != null) {
                currencyIds.add(couInfo.getBaseCurrency().getId());
                ciwBillInfo.put("baseCurId", (Object)couInfo.getBaseCurrency().getId().toString());
            }
            currencyIds.add(ciwBillInfo.getCurrency().getId());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", currencyIds, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add("precision");
        return viewInfo;
    }

    protected EntityViewInfo getMultiMeasureUnitEntityViewInfo(BTPTransformResult result) {
        int i;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer maskString = new StringBuffer();
        int size = result.getBills().size();
        for (i = 0; i < size; ++i) {
            ChannelInWarehsBillInfo ciwBillInfo = (ChannelInWarehsBillInfo)result.getBills().getObject(i);
            int entrySize = ciwBillInfo.getEntries().size();
            for (int j = 0; j < entrySize; ++j) {
                ChannelInWarehsBillEntryInfo entryInfo = ciwBillInfo.getEntries().get(j);
                if (entryInfo.getUnit() != null) {
                    filterInfo.appendFilterItem("material.id", (Object)entryInfo.getMaterial().getId());
                    filterInfo.appendFilterItem("measureUnit.id", (Object)entryInfo.getUnit().getId());
                }
                if (entryInfo.getBaseUnit() != null) {
                    filterInfo.appendFilterItem("material.id", (Object)entryInfo.getMaterial().getId());
                    filterInfo.appendFilterItem("measureUnit.id", (Object)entryInfo.getBaseUnit().getId());
                }
                if (entryInfo.getAssistUnit() == null) continue;
                filterInfo.appendFilterItem("material.id", (Object)entryInfo.getMaterial().getId());
                filterInfo.appendFilterItem("measureUnit.id", (Object)entryInfo.getAssistUnit().getId());
            }
        }
        size = filterInfo.getFilterItems().size() / 2;
        for (i = 0; i < size; ++i) {
            maskString.append("(#").append(i * 2).append(" and #").append(i * 2 + 1).append(")");
            if (i >= size - 1) continue;
            maskString.append(" or ");
        }
        entityViewInfo.setFilter(filterInfo);
        filterInfo.setMaskString(maskString.toString());
        entityViewInfo.getSelector().add("*");
        entityViewInfo.getSelector().add("material.id");
        entityViewInfo.getSelector().add("measureUnit.id");
        return entityViewInfo;
    }
}

