/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PriceCondition;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyEntryInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.inv.PriceInfo;
import com.kingdee.eas.scm.im.inv.PriceParamInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractBuildPrice;
import com.kingdee.eas.scm.im.inv.app.MultiSidesPriceBizDataVO;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class BuildPriceByPricePolicy
extends AbstractBuildPrice {
    public BuildPriceByPricePolicy(Context ctx, MultiSidesPriceBizDataVO dataVO) throws EASBizException, BOSException {
        super(ctx, dataVO);
    }

    private PriceCondition[] buildPriceCondition(PriceParamInfo[] paramInfos) throws EASBizException, BOSException {
        PriceCondition[] pcs = new PriceCondition[paramInfos.length];
        int length = pcs.length;
        for (int i = 0; i < length; ++i) {
            if (paramInfos[i] == null || this.getCustomer(paramInfos[i]) == null) continue;
            pcs[i] = new PriceCondition();
            pcs[i].setCustomerInfo(this.getCustomer(paramInfos[i]));
            pcs[i].setMaterialInfo(paramInfos[i].getMateial());
            pcs[i].setMeasureUnit(paramInfos[i].getUnit().getId().toString());
            pcs[i].setOrderQty(paramInfos[i].getQty());
            pcs[i].setCurrencyInfo(paramInfos[i].getCurrencyInfo());
            pcs[i].setAssiProperty(paramInfos[i].getAssistAttirute());
            pcs[i].setPriceTypeID("00000000-0000-0000-0000-0000000000036A61CE8D");
            pcs[i].setCurDate(paramInfos[i].getBizDate());
        }
        return pcs;
    }

    private String[] getPricePolicyIds(PriceParamInfo[] paramInfos) throws EASBizException, BOSException {
        String[] pps = new String[paramInfos.length];
        int length = pps.length;
        for (int i = 0; i < length; ++i) {
            if (paramInfos[i] == null) continue;
            PricePolicyInfo ppInfo = this.getPricePolicy(paramInfos[i]);
            pps[i] = ppInfo == null ? null : ppInfo.getId().toString();
        }
        return pps;
    }

    @Override
    public PriceInfo _getPrice(PriceParamInfo paramInfo) throws BOSException, EASBizException {
        PricePolicyInfo ppi = this.getPricePolicy(paramInfo);
        if (ppi == null) {
            return null;
        }
        if (ppi != null && ppi.getEffectiveDate() != null && ppi.getExpireDate() != null) {
            Calendar cal = Calendar.getInstance();
            Timestamp ts = new Timestamp(cal.getTimeInMillis());
            ts.setHours(0);
            ts.setMinutes(0);
            ts.setSeconds(0);
            ts.setNanos(0);
            Date sysDate = new Date(ts.getTime());
            if (ppi.getEffectiveDate().after(sysDate) || ppi.getExpireDate().before(sysDate)) {
                return null;
            }
        }
        Map map = PricePolicyFactory.getLocalInstance((Context)this.ctx).batchGetPricePolicyWithCM(this.buildPriceCondition(new PriceParamInfo[]{paramInfo}), new String[]{ppi.getId().toString()});
        return this.buildPriceInfo(map, paramInfo);
    }

    private PriceInfo buildPriceInfo(Map map, PriceParamInfo paramInfo) throws EASBizException, BOSException {
        BigDecimal price;
        PricePolicyEntryInfo ppe;
        CustomerInfo customerInfo = this.getCustomer(paramInfo);
        if (map != null && customerInfo != null && (ppe = (PricePolicyEntryInfo)map.get(customerInfo.getId().toString() + paramInfo.getMateial().getId().toString())) != null && (price = ppe.getPrice()) != null && price.compareTo(ZERO) > 0) {
            if (!paramInfo.getCurrencyInfo().getId().equals((Object)ppe.getCurrency().getId())) {
                return null;
            }
            String assistproperty = null;
            if (ppe.getAsistProperty() != null) {
                assistproperty = ppe.getAsistProperty().getId().toString();
            }
            if (paramInfo.getAssistAttirute() != null && assistproperty != null && !paramInfo.getAssistAttirute().getId().equals((Object)assistproperty)) {
                return null;
            }
            PriceInfo priceInfo = new PriceInfo();
            boolean isInTax = this.getIsInTax(paramInfo);
            if (isInTax) {
                priceInfo.setTaxPrice(price);
            } else {
                priceInfo.setPrice(price);
            }
            priceInfo.setDiscountType(ppe.getDiscountMode());
            if (ppe.getDiscount() == null) {
                priceInfo.setDiscountRate(BigDecimal.ZERO);
            } else if (ppe.getDiscount().compareTo(ZERO) > 0) {
                priceInfo.setDiscountRate(ppe.getDiscount());
            } else {
                priceInfo.setDiscountRate(ZERO);
            }
            return this.getPriceInfo(priceInfo, paramInfo, null, false, isInTax);
        }
        return null;
    }

    private BigDecimal transitionCurrency(Context ctx, String sourceId, String targetId, BigDecimal price) throws BOSException, EASBizException {
        BigDecimal value = null;
        CompanyOrgUnitInfo coui = ContextUtil.getCurrentFIUnit((Context)ctx);
        ExchangeTableInfo eti = coui.getReportExchangeTable();
        ObjectUuidPK etpk = new ObjectUuidPK(eti.getId().toString());
        ObjectUuidPK sourcepk = new ObjectUuidPK(sourceId);
        ObjectUuidPK targetpk = new ObjectUuidPK(targetId);
        IExchangeRate er = ExchangeRateFactory.getLocalInstance((Context)ctx);
        BigDecimal rate = er.getExchangeRateConvertValue((IObjectPK)etpk, (IObjectPK)sourcepk, (IObjectPK)targetpk, null);
        if (rate == null) {
            return null;
        }
        value = price.multiply(rate).setScale(price.scale(), 4);
        return value;
    }

    private PriceInfo[] buildPriceInfos(Map map, PriceParamInfo[] paramInfos) throws EASBizException, BOSException {
        PriceInfo[] priceInfos = new PriceInfo[paramInfos.length];
        int length = paramInfos.length;
        for (int i = 0; i < length; ++i) {
            priceInfos[i] = this.buildPriceInfo(map, paramInfos[i]);
        }
        return priceInfos;
    }

    @Override
    protected PriceInfo[] _getPrice(PriceParamInfo[] paramInfos) throws BOSException, EASBizException {
        Map map = PricePolicyFactory.getLocalInstance((Context)this.ctx).batchGetPricePolicyWithCM(this.buildPriceCondition(paramInfos), this.getPricePolicyIds(paramInfos));
        return this.buildPriceInfos(map, paramInfos);
    }
}

