/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.sd.sale.PriceCondition;
import com.kingdee.eas.basedata.scm.sd.sale.PriceProviderFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SalePriceTO;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.inv.PriceInfo;
import com.kingdee.eas.scm.im.inv.PriceParamInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractBuildPrice;
import com.kingdee.eas.scm.im.inv.app.MultiSidesPriceBizDataVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BuildPriceByPricePolicyExtend
extends AbstractBuildPrice {
    public BuildPriceByPricePolicyExtend(Context ctx, MultiSidesPriceBizDataVO dataVO) throws EASBizException, BOSException {
        super(ctx, dataVO);
    }

    private PriceCondition buildPriceCondition(PriceParamInfo paramInfo) throws EASBizException, BOSException {
        if (paramInfo == null) {
            return null;
        }
        SaleOrgUnitInfo soi = this.getSaleOrgUnitInfo(paramInfo);
        CustomerInfo ci = this.getCustomer(paramInfo);
        if (soi == null || ci == null) {
            return null;
        }
        PriceCondition pc = new PriceCondition();
        pc.setSaleOrg(soi);
        pc.setCustomerInfo(ci);
        pc.setMaterialInfo(paramInfo.getMateial());
        pc.setMeasureUnit(paramInfo.getUnit().getId().toString());
        pc.setOrderQty(paramInfo.getQty());
        pc.setCurrencyInfo(paramInfo.getCurrencyInfo());
        pc.setAssiProperty(paramInfo.getAssistAttirute());
        pc.setPriceTypeID("00000000-0000-0000-0000-0000000000036A61CE8D");
        pc.setCurDate(paramInfo.getBizDate());
        return pc;
    }

    @Override
    public PriceInfo _getPrice(PriceParamInfo paramInfo) throws BOSException, EASBizException {
        if (this.getCustomer(paramInfo) == null || this.getSaleOrgUnitInfo(paramInfo) == null) {
            return null;
        }
        PriceCondition pc = this.buildPriceCondition(paramInfo);
        List[] result = PriceProviderFactory.getLocalInstance((Context)this.ctx).getPrices(new PriceCondition[]{pc});
        if (result == null) {
            return null;
        }
        if (result[0] != null && result[0].size() > 0 && result[0].get(0) != null) {
            SalePriceTO priceInfo = (SalePriceTO)result[0].get(0);
            if (priceInfo.dateFrom != null) {
                if (priceInfo.dateFrom.after(paramInfo.getBizDate()) || priceInfo.dateTo.before(paramInfo.getBizDate())) {
                    return null;
                }
                return this.buildPriceInfo(result[0], paramInfo);
            }
            if ("basePrice".equals(priceInfo.priceType)) {
                return this.buildPriceInfo(result[0], paramInfo);
            }
            return null;
        }
        return null;
    }

    private PriceInfo buildPriceInfo(List list, PriceParamInfo paramInfo) throws EASBizException, BOSException {
        if (list != null && list.size() > 0 && list.get(0) != null) {
            SalePriceTO salePriceT0 = (SalePriceTO)list.get(0);
            BigDecimal price = salePriceT0.price;
            if (price != null && price.compareTo(ZERO) > 0) {
                String currency = salePriceT0.currency;
                if (!paramInfo.getCurrencyInfo().getId().toString().equals(currency)) {
                    return null;
                }
                String assistproperty = salePriceT0.assistProperty;
                if (paramInfo.getAssistAttirute() != null && assistproperty != null && !paramInfo.getAssistAttirute().getId().toString().equals(assistproperty)) {
                    return null;
                }
                PriceInfo priceInfo = new PriceInfo();
                boolean isInTax = this.getIsInTax(paramInfo);
                price = price.setScale(paramInfo.getPricePrecision(), 4);
                if (isInTax) {
                    priceInfo.setTaxPrice(price);
                } else {
                    priceInfo.setPrice(price);
                }
                if (salePriceT0.discountMode != null) {
                    DiscountModeEnum discountType = DiscountModeEnum.getEnum((int)salePriceT0.discountMode);
                    priceInfo.setDiscountType(discountType);
                }
                if (salePriceT0.discountValue != null) {
                    BigDecimal discountRate = salePriceT0.discountValue;
                    if (discountRate.compareTo(ZERO) > 0) {
                        priceInfo.setDiscountRate(discountRate);
                    } else {
                        priceInfo.setDiscountRate(ZERO);
                    }
                }
                return this.getPriceInfo(priceInfo, paramInfo, null, false, isInTax);
            }
        }
        return null;
    }

    @Override
    protected PriceInfo[] _getPrice(PriceParamInfo[] paramInfos) throws BOSException, EASBizException {
        PriceCondition[] priceConditions = new PriceCondition[paramInfos.length];
        List<E>[] retPrics = new ArrayList[paramInfos.length];
        PriceInfo[] priceInfos = new PriceInfo[paramInfos.length];
        int length = paramInfos.length;
        for (int i = 0; i < length; ++i) {
            if (paramInfos[i] == null) continue;
            priceConditions[i] = this.buildPriceCondition(paramInfos[i]);
        }
        boolean is4side = false;
        if (paramInfos != null && paramInfos.length > 0) {
            for (int i = 0; i < paramInfos.length; ++i) {
                String id;
                PriceParamInfo info = paramInfos[i];
                if (info == null || info.getBizTypeInfo() == null || info.getBizTypeInfo().getId() == null || !"LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(id = info.getBizTypeInfo().getId().toString()) && !"ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(id)) continue;
                is4side = true;
                break;
            }
        }
        if (is4side) {
            List<PriceCondition> list;
            HashMap soMap = new HashMap();
            for (int i = 0; i < priceConditions.length; ++i) {
                if (priceConditions[i] == null || priceConditions[i].getSaleOrg() == null || priceConditions[i].getSaleOrg().getId() == null) continue;
                String saleorgid = priceConditions[i].getSaleOrg().getId().toString();
                if (soMap.containsKey(saleorgid)) {
                    list = (List)soMap.get(saleorgid);
                    list.add(priceConditions[i]);
                    continue;
                }
                list = new ArrayList();
                list.add(priceConditions[i]);
                soMap.put(saleorgid, list);
            }
            if (soMap.keySet() == null) {
                return null;
            }
            for (String soid : soMap.keySet()) {
                list = (ArrayList)soMap.get(soid);
                Object[] objArray = list.toArray();
                PriceCondition[] tmpPC = new PriceCondition[objArray.length];
                for (int i = 0; i < tmpPC.length; ++i) {
                    tmpPC[i] = (PriceCondition)objArray[i];
                }
                List[] result = PriceProviderFactory.getLocalInstance((Context)this.ctx).getPrices(tmpPC);
                block5: for (int i = 0; i < priceConditions.length; ++i) {
                    if (priceConditions[i] == null) continue;
                    String srckey = priceConditions[i].toString();
                    for (int j = 0; j < tmpPC.length; ++j) {
                        String deskey = tmpPC[j].toString();
                        if (!srckey.equals(deskey)) continue;
                        retPrics[i] = result[j];
                        continue block5;
                    }
                }
            }
        } else {
            retPrics = PriceProviderFactory.getLocalInstance((Context)this.ctx).getPrices(priceConditions);
        }
        int length2 = priceConditions.length;
        for (int i = 0; i < length2; ++i) {
            priceInfos[i] = retPrics == null ? null : this.buildPriceInfo(retPrics[i], paramInfos[i]);
        }
        return priceInfos;
    }
}

