/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.scm.common.PriceRule4ProfitEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.inv.IInventoryBalance;
import com.kingdee.eas.scm.im.inv.InventoryBalanceCollection;
import com.kingdee.eas.scm.im.inv.InventoryBalanceFactory;
import com.kingdee.eas.scm.im.inv.InventoryBalanceInfo;
import com.kingdee.eas.scm.im.inv.PriceInfo;
import com.kingdee.eas.scm.im.inv.PriceParamInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractDiffPrice;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.RowSet;

public class CostPriceForDiffPrice
extends AbstractDiffPrice {
    private Map mapMAP = new HashMap();

    public CostPriceForDiffPrice(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public PriceInfo _getPrice(PriceParamInfo priceParamInfo) throws BOSException, EASBizException {
        this.cacheMoveAveragePrice(this.ctx, new PriceParamInfo[]{priceParamInfo});
        BigDecimal price = null;
        int pricePrecision = priceParamInfo.getMateial().getPricePrecision();
        if (priceParamInfo.isMoveAverage()) {
            price = this.getMoveAveragePrice(priceParamInfo);
        }
        if (price == null || price.compareTo(ZERO) <= 0) {
            EntityViewInfo evi = this.getEntityViewInfo(priceParamInfo);
            if (evi == null) {
                return null;
            }
            IInventoryBalance iib = InventoryBalanceFactory.getLocalInstance(this.ctx);
            InventoryBalanceCollection ibc = iib.getInventoryBalanceCollection(evi);
            if (ibc == null || ibc.size() <= 0) {
                return null;
            }
            BigDecimal totalQty = new BigDecimal("0.00");
            BigDecimal totalAmount = new BigDecimal("0.00");
            for (int i = 0; i < ibc.size(); ++i) {
                InventoryBalanceInfo ibi = ibc.get(i);
                totalQty = totalQty.add(ibi.getPeriodBeginQty());
                totalAmount = totalAmount.add(ibi.getPeriodBeginBalance());
            }
            if (totalQty.compareTo(ZERO) == 0) {
                return null;
            }
            price = totalAmount.divide(totalQty, pricePrecision, 4);
        }
        if (price == null) {
            return null;
        }
        ExchangeRateInfo exchangeRateInfo = priceParamInfo.getExchangeRageInfo();
        if (exchangeRateInfo != null && exchangeRateInfo.getConvertRate() != null && exchangeRateInfo.getConvertRate().compareTo(ZERO) > 0) {
            price = ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)exchangeRateInfo.getConvertMode()) ? price.multiply(exchangeRateInfo.getConvertRate()) : price.divide(exchangeRateInfo.getConvertRate(), 4);
        }
        price = price.setScale(pricePrecision, 4);
        price = this.addOrMinusPriceRate(priceParamInfo, price);
        PriceInfo priceInfo = new PriceInfo();
        priceInfo.setPrice(price);
        return priceInfo;
    }

    private void cacheMoveAveragePrice(Context ctx, PriceParamInfo[] priceParamInfos) throws EASBizException, BOSException {
        String calType;
        this.mapMAP = new HashMap();
        StringBuffer sql = new StringBuffer();
        sql.append("select FMaterialID,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FPrice from T_CL_RecentCost where ");
        HashMap<String, String> calTypeMap = new HashMap<String, String>();
        for (PriceParamInfo priceParamInfo : priceParamInfos) {
            if (priceParamInfo == null) continue;
            String compayId = this.getCompanyOrgId(priceParamInfo);
            String souId = this.getStorageOrgId(priceParamInfo);
            calType = priceParamInfo.getCalType();
            if (priceParamInfo == null || !priceParamInfo.isMoveAverage() || calType == null || !this.isValidCalType(calType) || calType.equals("2") && priceParamInfo.getIssueWarehsInfo() == null) continue;
            calTypeMap.put(compayId, calType);
            sql.append("(FMaterialID = '");
            sql.append(priceParamInfo.getMateial().getId().toString());
            sql.append("' and FCompanyOrgUnitID = '");
            sql.append(compayId);
            if (calType.equals("1")) {
                sql.append("' and FStorageOrgUnitID = '");
                sql.append(souId);
            } else if (calType.equals("2")) {
                sql.append("' and FStorageOrgUnitID = '");
                sql.append(souId);
                sql.append("' and FWarehouseID = '");
                sql.append(priceParamInfo.getIssueWarehsInfo().getId().toString());
            }
            sql.append("') or ");
        }
        if (calTypeMap.size() > 0) {
            sql.append("(0 = 1)");
            Connection conn = null;
            RowSet rowSet = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                rowSet = SQLUtils.getJdbcRowSet((Connection)conn, (String)sql.toString());
                while (rowSet.next()) {
                    calType = (String)calTypeMap.get(rowSet.getString("FCompanyOrgUnitID"));
                    String key = rowSet.getString("FMaterialID") + rowSet.getString("FCompanyOrgUnitID");
                    if (!"0".equals(calType)) {
                        if ("1".equals(calType)) {
                            key = key + rowSet.getString("FStorageOrgUnitID");
                        } else if ("2".equals(calType)) {
                            key = key + rowSet.getString("FStorageOrgUnitID") + rowSet.getString("FWarehouseID");
                        }
                    }
                    this.mapMAP.put(key, rowSet.getBigDecimal("FPrice"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
                try {
                    if (rowSet != null) {
                        rowSet.close();
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    private boolean isValidCalType(String calType) {
        return calType.equals("0") || calType.equals("1") || calType.equals("2");
    }

    private BigDecimal getMoveAveragePrice(PriceParamInfo paramInfo) throws BOSException, EASBizException {
        String calType = paramInfo.getCalType();
        if (calType == null || !this.isValidCalType(calType) || "2".equals(calType) && paramInfo.getIssueWarehsInfo() == null) {
            return null;
        }
        String companyId = this.getCompanyOrgId(paramInfo);
        String souId = this.getStorageOrgId(paramInfo);
        String materialId = paramInfo.getMateial().getId().toString();
        String key = materialId + companyId;
        if ("1".equals(calType)) {
            key = key + souId;
        } else if ("2".equals(calType)) {
            key = key + souId;
            key = key + paramInfo.getIssueWarehsInfo().getId().toString();
        }
        return (BigDecimal)this.mapMAP.get(key);
    }

    private EntityViewInfo getEntityViewInfo(PriceParamInfo paramInfo) throws BOSException, EASBizException {
        if (paramInfo == null) {
            return null;
        }
        if (this.getCompanyOrgId(paramInfo) == null) {
            return null;
        }
        String companyOrgUnitID = this.getCompanyOrgId(paramInfo);
        PeriodInfo curPeriodInfo = this.getCurPeriod(companyOrgUnitID);
        if (curPeriodInfo == null) {
            return null;
        }
        String materialID = paramInfo.getMateial().getId().toString();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.appendFilterItem("companyOrgUnit", (Object)companyOrgUnitID);
        fi.appendFilterItem("materialID", (Object)materialID);
        fi.appendFilterItem("period", (Object)new Integer(curPeriodInfo.getPeriodNumber()));
        fi.appendFilterItem("year", (Object)new Integer(curPeriodInfo.getPeriodYear()));
        if (paramInfo.isSpecialAcct()) {
            if (paramInfo.isLot()) {
                fi.appendFilterItem("lot", (Object)paramInfo.getLot());
            }
            if (paramInfo.isAssistProperty()) {
                fi.appendFilterItem("assistProperty.id", (Object)paramInfo.getAssistProperty());
            }
            if (paramInfo.isProject()) {
                fi.appendFilterItem("project.id", (Object)paramInfo.getProject());
            }
            if (paramInfo.isTrackNumber()) {
                fi.appendFilterItem("trackNumber.id", (Object)paramInfo.getTrackNumber());
            }
        }
        evi.setFilter(fi);
        return evi;
    }

    @Override
    protected PriceRule4ProfitEnum getPriceRuleEnum() throws BOSException, EASBizException {
        return PriceRule4ProfitEnum.CostPrice;
    }

    private String getCompanyOrgId(PriceParamInfo priceParamInfo) throws BOSException, EASBizException {
        String couId = this.settlementRuleEntryForPCInfo.getCompanyOrgUnit().getId().toString();
        if (this.isSystemRule()) {
            couId = priceParamInfo.getCompanyOrgUnit().getId().toString();
        }
        return couId;
    }

    private String getStorageOrgId(PriceParamInfo priceParamInfo) throws BOSException, EASBizException {
        String souId;
        String string = souId = this.settlementRuleEntryForPCInfo.getStorageOrgUnit() == null ? null : this.settlementRuleEntryForPCInfo.getStorageOrgUnit().getId().toString();
        if (this.isSystemRule()) {
            souId = priceParamInfo.getStorageOrgUnit().getId().toString();
        }
        return souId;
    }
}

