/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.freechart.util.Log;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IAsstAttrValue;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.im.inv.ILocation;
import com.kingdee.eas.basedata.scm.im.inv.ISOAccreditWH;
import com.kingdee.eas.basedata.scm.im.inv.IStoreState;
import com.kingdee.eas.basedata.scm.im.inv.IStoreType;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.LocationCollection;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateCollection;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WHStateEnum;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.IProject;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.CountingTableCollection;
import com.kingdee.eas.scm.im.inv.CountingTableEntryCollection;
import com.kingdee.eas.scm.im.inv.CountingTableEntryFactory;
import com.kingdee.eas.scm.im.inv.CountingTableEntryInfo;
import com.kingdee.eas.scm.im.inv.CountingTableFactory;
import com.kingdee.eas.scm.im.inv.CountingTableInfo;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sm.pur.util.DataImportUtils;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;

public class CountingTableImport
extends AbstractDataTransmission {
    public static final String Locale_en = "l1";
    public static final String Locale_zh = "l2";
    public static final String Locale_tw = "l3";
    private static final int ASSISTPROPERTY = 3;
    private static final int ASSISTUNIT = 4;
    private static String resources = "com.kingdee.eas.scm.im.inv.app.OtherBillDataImportResource";
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static final String DECIMAL_ENTRY_PROPERTY = "FEntry_CountingQty";
    private static final String DECIMAL_ENTRY_ADJUSTQTY = "FEntry_AdjustQty";
    private static final String DECIMAL_ENTRY_PROPERTY_ASSIST = "FEntry_CountingAssistQty";
    private static final String DECIMAL_ENTRY_ADJUSTASSISTQTY = "FEntry_AdjustAssistQty";
    private HashMap storeTypes = new HashMap();
    private HashMap storeStatuses = new HashMap();
    private HashMap customers = new HashMap();
    private HashMap suppliers = new HashMap();
    String[] DATE_BILL_PROPERTY = new String[]{"FTaskBeginTime", "FTaskEndTime"};
    String[] DATE_BILL_PROPERTY_ = new String[]{"taskBeginTime", "taskEndTime"};
    CountingTableInfo countingTableInfo = null;
    WarehouseInfo warehouseInfo = null;
    StorageOrgUnitInfo sou = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CountingTableFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    private static String getResource(Context ctx, String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return CountingTableImport.getResource(ctx, strKey, resources);
    }

    private static String getResource(Context ctx, String strKey, String resource) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return SCMUtils.getResource((String)resource, (String)strKey, (Context)ctx);
    }

    public int getSubmitType() {
        return 1;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null || !(coreBaseInfo instanceof CountingTableInfo)) {
            return;
        }
        try {
            CountingTableCollection collection;
            CountingTableInfo bill = (CountingTableInfo)coreBaseInfo;
            IObjectPK userPK = ctx.getCaller();
            ObjectUuidPK orgPK = new ObjectUuidPK(bill.getStorageOrgUnit().getId());
            SCMServerUtils.checkFunctionPermission((Context)ctx, (IObjectPK)userPK, (IObjectPK)orgPK, (String)"countingTableImport");
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("countingTask.id", (Object)bill.getCountingTask().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("warehouse.number", (Object)bill.getWarehouse().getNumber(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            try {
                collection = CountingTableFactory.getLocalInstance(ctx).getCountingTableCollection(viewInfo);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            this.submitMuilBill(collection, bill, ctx);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private void submitMuilBill(CountingTableCollection collection, CountingTableInfo bill, Context ctx) throws TaskExternalException {
        if (collection == null || collection.size() < 1) {
            return;
        }
        int len = collection.size();
        CountingTableEntryCollection entry = bill.getEntry();
        if (entry == null) {
            return;
        }
        CountingTableInfo old = null;
        CountingTableEntryCollection addentry = new CountingTableEntryCollection();
        boolean[] updateFor = new boolean[len];
        int temp = 0;
        block2: for (int i = 0; i < entry.size(); ++i) {
            if (entry.get(i).getId() != null) {
                for (int j = 0; j < len; ++j) {
                    old = collection.get(j);
                    if (old == null || old.getEntry() == null || old.getEntry().get(entry.get(i).getId()) == null) continue;
                    temp = collection.get(j).getEntry().indexOf(entry.get(i).getId());
                    collection.get(j).getEntry().removeObject(entry.get(i).getId());
                    collection.get(j).getEntry().addObject(temp, (IObjectValue)entry.get(i));
                    updateFor[j] = true;
                    continue block2;
                }
                continue;
            }
            addentry.add(entry.get(i));
        }
        if (addentry != null && addentry.size() > 0) {
            int postion = 0;
            int minSizecol = -1;
            int maxSizecol = -1;
            boolean firstTime = true;
            for (int i = 0; i < len; ++i) {
                if (collection.get(i) == null || collection.get(i).getEntry() == null) continue;
                int templen = collection.get(i).getEntry().size();
                if (firstTime) {
                    maxSizecol = minSizecol = templen;
                    postion = i;
                    firstTime = false;
                }
                if (minSizecol > templen) {
                    minSizecol = templen;
                    postion = i;
                    continue;
                }
                maxSizecol = templen;
            }
            if (maxSizecol >= minSizecol) {
                collection.get(postion).getEntry().addCollection(addentry);
                updateFor[postion] = true;
            }
        }
        try {
            CountingTableInfo info = null;
            for (int i = 0; i < collection.size(); ++i) {
                if (!updateFor[i]) continue;
                info = collection.get(i);
                this.getController(ctx).submit((CoreBaseInfo)info);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        this.countingTableInfo = null;
        int keyCursor = 0;
        TaskExternalException tex = new TaskExternalException("");
        for (int i = 0; i < hsData.size(); ++i) {
            Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
            if (keyCursor == 0) {
                try {
                    this.countingTableInfo = this.transmitHead(lineData, ctx);
                    if (this.countingTableInfo == null) {
                        return null;
                    }
                }
                catch (TaskExternalException e) {
                    tex.addEntryErrorReason(i, e.getMessage());
                    break;
                }
            }
            try {
                CountingTableEntryInfo entry = this.transmitEntry(lineData, ctx);
                this.countingTableInfo.getEntry().add(entry);
            }
            catch (TaskExternalException e) {
                tex.addEntryErrorReason(i, e.getMessage());
            }
            ++keyCursor;
        }
        if (tex.getEntryErrorReasons().size() > 0) {
            throw tex;
        }
        return this.countingTableInfo;
    }

    private CountingTableInfo transmitHead(Hashtable lineData, Context ctx) throws TaskExternalException {
        Object number;
        block16: {
            this.countingTableInfo = new CountingTableInfo();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = (FilterInfo)this.getContextParameter("filter");
            if (filterInfo == null) {
                return null;
            }
            viewInfo.setFilter(filterInfo);
            CountingTableCollection col = null;
            try {
                col = CountingTableFactory.getLocalInstance(ctx).getCountingTableCollection(viewInfo);
            }
            catch (BOSException e) {
                return null;
            }
            if (col == null) {
                return null;
            }
            this.countingTableInfo.setCountingTask(col.get(0).getCountingTask());
            this.countingTableInfo.setStorageOrgUnit(col.get(0).getStorageOrgUnit());
            this.countingTableInfo.setCountingBeginTime(col.get(0).getCountingBeginTime());
            this.sou = col.get(0).getStorageOrgUnit();
            number = ((DataToken)lineData.get((Object)"FWarehouse_Number")).data;
            try {
                if (number != null && number.toString() != null && number.toString().length() > 0) {
                    if ((number = number.toString()) == null) break block16;
                    IWarehouse iw = WarehouseFactory.getLocalInstance((Context)ctx);
                    WarehouseCollection collection = iw.getWarehouseCollection(this.getFilter(number.toString()));
                    if (collection != null && collection.size() > 0) {
                        WarehouseInfo info = collection.get(0);
                        if (info != null) {
                            if (!info.getWhState().equals((Object)WHStateEnum.ACTIVE)) {
                                throw new TaskExternalException(info.getNumber() + " " + CountingTableImport.getResource(ctx, "WarehouseNotActive"));
                            }
                            this.checkWarehouse(ctx, info, this.sou);
                            this.countingTableInfo.setWarehouse(info);
                            this.warehouseInfo = info;
                            break block16;
                        }
                        throw new TaskExternalException(number.toString() + " " + CountingTableImport.getResource(ctx, "WarehouseNotExists"));
                    }
                    throw new TaskExternalException(number.toString() + " " + CountingTableImport.getResource(ctx, "WarehouseNotExists"));
                }
                throw new TaskExternalException(CountingTableImport.getResource(ctx, "WarehouseNotExists"));
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        number = ((DataToken)lineData.get((Object)"FCountingPerson_number")).data;
        PersonInfo info = this.getPersonByString(number, ctx);
        if (info == null) {
            UserInfo userinfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            this.countingTableInfo.setCountingPerson(userinfo.getPerson());
        } else {
            this.countingTableInfo.setCountingPerson(info);
        }
        number = ((DataToken)lineData.get((Object)"FCountingAgainPerson_number")).data;
        info = this.getPersonByString(number, ctx);
        this.countingTableInfo.setCountingAgainPerson(info);
        number = ((DataToken)lineData.get((Object)"FCountingMonitorer_number")).data;
        info = this.getPersonByString(number, ctx);
        this.countingTableInfo.setCountingMonitorer(info);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < this.DATE_BILL_PROPERTY.length; ++i) {
            Object date = ((DataToken)lineData.get((Object)this.DATE_BILL_PROPERTY[i])).data;
            if (date != null && date.toString().length() > 0) {
                try {
                    date = df.parse(date.toString());
                }
                catch (ParseException e) {
                    Logger.error((Throwable)e);
                    throw new TaskExternalException(CountingTableImport.getResource(ctx, "InvalidDateFormat") + date.toString());
                }
                if (date == null || !(date instanceof Date)) continue;
                this.countingTableInfo.setDate(this.DATE_BILL_PROPERTY_[i], (Date)date);
                continue;
            }
            this.countingTableInfo.setDate(this.DATE_BILL_PROPERTY_[i], null);
        }
        return this.countingTableInfo;
    }

    private CountingTableEntryInfo transmitEntry(Hashtable lineData, Context ctx) throws TaskExternalException {
        BigDecimal value;
        CountingTableEntryInfo entryInfo = new CountingTableEntryInfo();
        MaterialInfo materialInfo = new MaterialInfo();
        Object number = null;
        try {
            this.loadMaterial(lineData, ctx, "number", "FMaterial_Number", entryInfo, materialInfo);
            materialInfo = entryInfo.getMaterial();
        }
        catch (Exception e_number) {
            try {
                this.loadMaterial(lineData, ctx, "name", "FMaterial_Name", entryInfo, materialInfo);
                materialInfo = entryInfo.getMaterial();
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
        try {
            Object data = ((DataToken)lineData.get((Object)"FEntry_Lot")).data;
            if (this.checkLotInfo(ctx, materialInfo, data, this.sou, entryInfo)) {
                entryInfo.setLot(null);
            } else {
                entryInfo.setLot(data.toString().trim());
            }
            if (data == null || data.toString() == null || data.toString().trim().length() == 0) {
                entryInfo.setLot(null);
            } else {
                entryInfo.setLot(data.toString().trim());
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        try {
            this.loadAsstAttr(lineData, ctx, "number", "FAssistProperty_Number", entryInfo, materialInfo);
        }
        catch (Exception e_number) {
            try {
                this.loadAsstAttr(lineData, ctx, "name", "FAssistProperty_Name", entryInfo, materialInfo);
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
        try {
            this.loadLocation(lineData, ctx, "number", "FLocation_Number", entryInfo);
        }
        catch (Exception e_number) {
            try {
                this.loadLocation(lineData, ctx, "name", "FLocation_Name", entryInfo);
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
        try {
            this.loadUnit(lineData, ctx, "number", "FUnit_Number", entryInfo, materialInfo);
        }
        catch (Exception e_number) {
            try {
                this.loadUnit(lineData, ctx, "name", "FUnit_Name", entryInfo, materialInfo);
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
        try {
            this.loadInvUnit(lineData, ctx, "number", "FInvUnit_Number", entryInfo, materialInfo);
        }
        catch (Exception e_number) {
            try {
                this.loadInvUnit(lineData, ctx, "name", "FInvUnit_Name", entryInfo, materialInfo);
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
        entryInfo.setBaseUnit(materialInfo.getBaseUnit());
        entryInfo.setAssistUnit(materialInfo.getAssistUnit());
        try {
            this.loadStoreType(lineData, ctx, "number", "FStoreType_Number", entryInfo);
        }
        catch (Exception e_number) {
            try {
                this.loadStoreType(lineData, ctx, "name", "FStoreType_Name", entryInfo);
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
        try {
            this.loadProject(lineData, ctx, "number", "FProjectNumber", entryInfo);
        }
        catch (Exception e_number) {
            throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
        }
        try {
            this.loadTrackNum(lineData, ctx, "number", "FTrackNumber", entryInfo);
        }
        catch (Exception e_number) {
            throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
        }
        try {
            this.loadCustomer(lineData, ctx, "number", "FCustomer_Number", entryInfo);
        }
        catch (Exception e_number) {
            try {
                this.loadCustomer(lineData, ctx, "name", "FCustomer_Name", entryInfo);
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
        try {
            this.loadSupplier(lineData, ctx, "number", "FSupplier_Number", entryInfo);
        }
        catch (Exception e_number) {
            try {
                this.loadSupplier(lineData, ctx, "name", "FSupplier_Name", entryInfo);
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
        try {
            this.loadStoreState(lineData, ctx, "number", "FStoreStatus_Number", entryInfo);
        }
        catch (Exception e_number) {
            try {
                this.loadStoreState(lineData, ctx, "name", "FStoreStatus_Name", entryInfo);
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.countingTask.id", (Object)this.countingTableInfo.getCountingTask().getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.warehouse.id", (Object)this.warehouseInfo.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit.id", (Object)this.sou.getId().toString(), CompareType.EQUALS));
        if (entryInfo.getMaterial() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)entryInfo.getMaterial().getId(), CompareType.EQUALS));
        }
        if (entryInfo.getLocation() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("location.id", (Object)entryInfo.getLocation().getId(), CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("location.id is null"));
        }
        if (entryInfo.getStoreType() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storeType.id", (Object)entryInfo.getStoreType().getId(), CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("storeType.id is null"));
        }
        if (entryInfo.getUnit() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("unit.id", (Object)entryInfo.getUnit().getId(), CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("unit.id is null"));
        }
        if (entryInfo.getLot() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("lot", (Object)entryInfo.getLot(), CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("lot is null"));
        }
        if (entryInfo.getAssistProperty() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("assistProperty.id", (Object)entryInfo.getAssistProperty().getId(), CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("assistProperty.id is null"));
        }
        if (entryInfo.getProject() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("project.number", (Object)entryInfo.getProject().getNumber(), CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("project.number is null"));
        }
        if (entryInfo.getTrackNumber() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("trackNumber.number", (Object)entryInfo.getTrackNumber().getNumber(), CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("trackNumber.number is null"));
        }
        if (entryInfo.getCustomer() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("customer.id", (Object)entryInfo.getCustomer().getId(), CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("customer.id is null"));
        }
        if (entryInfo.getSupplier() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)entryInfo.getSupplier().getId(), CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("supplier.id is null"));
        }
        if (entryInfo.getStoreStatus() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storeStatus.id", (Object)entryInfo.getStoreStatus().getId(), CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("storeStatus.id is null"));
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        CountingTableEntryCollection col = null;
        try {
            col = CountingTableEntryFactory.getLocalInstance(ctx).getCountingTableEntryCollection(viewInfo);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        MeasureUnitInfo invUnit = entryInfo.getInvUnit();
        MeasureUnitInfo unit = entryInfo.getUnit();
        Object o = ((DataToken)lineData.get((Object)DECIMAL_ENTRY_PROPERTY)).data;
        if (o != null && o.toString().trim().length() > 0) {
            value = new BigDecimal(o.toString());
            if ((value.compareTo(ZERO) == 0 || value.compareTo(ZERO) < 0) && invUnit != null && unit != null && entryInfo.getMaterial() != null) {
                this.getCountingQtyByInvCountingQty(lineData, invUnit, unit, entryInfo, ctx);
            }
            if (value.compareTo(ZERO) != 0 && invUnit != null && unit != null && entryInfo.getMaterial() != null) {
                BigDecimal invCountingQty = null;
                try {
                    invCountingQty = invUnit.getName().equals(unit.getName()) ? value : SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)unit, (MeasureUnitInfo)invUnit, (BigDecimal)value);
                }
                catch (Exception e) {
                    Log.error((Object)e);
                }
                entryInfo.setInvCountingQty(invCountingQty);
                entryInfo.setCountingQty(value);
            }
        } else {
            this.getCountingQtyByInvCountingQty(lineData, invUnit, unit, entryInfo, ctx);
        }
        o = ((DataToken)lineData.get((Object)DECIMAL_ENTRY_ADJUSTQTY)).data;
        if (o != null && o.toString().trim().length() > 0) {
            value = new BigDecimal(o.toString());
            entryInfo.setAdjustQty(value);
        } else {
            entryInfo.setAdjustQty(ZERO);
        }
        o = ((DataToken)lineData.get((Object)DECIMAL_ENTRY_ADJUSTASSISTQTY)).data;
        if (o != null && o.toString().trim().length() > 0) {
            value = new BigDecimal(o.toString());
            entryInfo.setAdjustAssistQty(value);
        } else {
            entryInfo.setAdjustAssistQty(ZERO);
        }
        if (entryInfo.getAssistUnit() != null) {
            o = ((DataToken)lineData.get((Object)DECIMAL_ENTRY_PROPERTY_ASSIST)).data;
            if (o != null && o.toString().trim().length() > 0) {
                value = new BigDecimal(o.toString());
                if (value.compareTo(ZERO) < 0) {
                    throw new TaskExternalException(CountingTableImport.getResource(ctx, "CountingAssistQty_Must_Positive"));
                }
                entryInfo.setCountingAssistQty(value);
            } else {
                entryInfo.setCountingAssistQty(ZERO);
            }
        }
        if (col != null && col.size() > 0) {
            entryInfo.setId(col.get(0).getId());
            entryInfo.setAccountQty(col.get(0).getAccountQty());
            entryInfo.setAcctAssistQty(col.get(0).getAcctAssistQty());
        } else {
            entryInfo.setAccountQty(ZERO);
            entryInfo.setAcctAssistQty(ZERO);
        }
        entryInfo.setDifferQty(entryInfo.getCountingQty().subtract(entryInfo.getAccountQty()).subtract(entryInfo.getAdjustQty()));
        if (entryInfo.getDifferQty() == null || ZERO.compareTo(entryInfo.getDifferQty()) == 0) {
            entryInfo.setBaseQty(ZERO);
        } else if (entryInfo.getBaseUnit() != null && entryInfo.getUnit() != null) {
            if (entryInfo.getUnit().getId().equals((Object)entryInfo.getBaseUnit().getId())) {
                entryInfo.setBaseQty(entryInfo.getDifferQty().abs());
            } else if (entryInfo.getMaterial() != null && entryInfo.getUnit() != null) {
                BigDecimal baseQty;
                try {
                    baseQty = InvServerUtils.getBaseUnitQty(ctx, entryInfo.getUnit(), entryInfo.getMaterial(), entryInfo.getDifferQty());
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                entryInfo.setBaseQty(baseQty.abs());
            }
        } else {
            entryInfo.setBaseQty(ZERO);
        }
        if (entryInfo.getAssistUnit() != null) {
            entryInfo.setDiffAssistQty(entryInfo.getCountingAssistQty().subtract(entryInfo.getAcctAssistQty()).subtract(entryInfo.getAdjustAssistQty()));
        }
        Object remark = ((DataToken)lineData.get((Object)"FEntry_Remark")).data;
        entryInfo.setRemark((String)remark);
        return entryInfo;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            result.put("FStorageOrgUnit_Number", DataImportUtils.transformValue((Object)rs.getString("storageOrgUnit.number")));
            result.put("FStorageOrgUnit_Name", DataImportUtils.transformValue((Object)rs.getString("storageOrgUnit.name")));
            result.put("FWarehouse_Number", DataImportUtils.transformValue((Object)rs.getString("warehouse.number")));
            result.put("FWarehouse_Name", DataImportUtils.transformValue((Object)rs.getString("warehouse.name")));
            result.put("FLocation_Number", DataImportUtils.transformValue((Object)rs.getString("location.number")));
            result.put("FLocation_Name", DataImportUtils.transformValue((Object)rs.getString("location.name")));
            result.put("FMaterial_Number", DataImportUtils.transformValue((Object)rs.getString("material.number")));
            result.put("FMaterial_Name", DataImportUtils.transformValue((Object)rs.getString("material.name")));
            result.put("FMaterial_Model", DataImportUtils.transformValue((Object)rs.getString("material.model")));
            result.put("FAssistProperty_Number", DataImportUtils.transformValue((Object)rs.getString("assistProperty.number")));
            result.put("FAssistProperty_Name", DataImportUtils.transformValue((Object)rs.getString("assistProperty.name")));
            result.put("FEntry_Lot", DataImportUtils.transformValue((Object)rs.getString("entry.lot")));
            result.put("FStoreType_Number", DataImportUtils.transformValue((Object)rs.getString("storeType.number")));
            result.put("FStoreType_Name", DataImportUtils.transformValue((Object)rs.getString("storeType.name")));
            result.put("FUnit_Number", DataImportUtils.transformValue((Object)rs.getString("unit.number")));
            result.put("FUnit_Name", DataImportUtils.transformValue((Object)rs.getString("unit.name")));
            result.put("FEntry_AccountQty", DataImportUtils.transformValue((Object)rs.getString("entry.accountQty")));
            result.put(DECIMAL_ENTRY_PROPERTY, DataImportUtils.transformValue((Object)rs.getString("entry.countingQty")));
            result.put(DECIMAL_ENTRY_ADJUSTQTY, DataImportUtils.transformValue((Object)rs.getString("entry.adjustQty")));
            result.put("FEntry_DifferQty", DataImportUtils.transformValue((Object)rs.getString("entry.differQty")));
            result.put("FInvUnit_Number", DataImportUtils.transformValue((Object)rs.getString("invUnit.number")));
            result.put("FInvUnit_Name", DataImportUtils.transformValue((Object)rs.getString("invUnit.name")));
            result.put("FEntry_InvAccountQty", DataImportUtils.transformValue((Object)rs.getString("entry.invAccountQty")));
            result.put("FEntry_InvCountingQty", DataImportUtils.transformValue((Object)rs.getString("entry.invCountingQty")));
            result.put("FAssistUnit_Number", DataImportUtils.transformValue((Object)rs.getString("assistUnit.number")));
            result.put("FAssistUnit_Name", DataImportUtils.transformValue((Object)rs.getString("assistUnit.name")));
            result.put("FEntry_AcctAssistQty", DataImportUtils.transformValue((Object)rs.getString("entry.acctAssistQty")));
            result.put(DECIMAL_ENTRY_PROPERTY_ASSIST, DataImportUtils.transformValue((Object)rs.getString("entry.countingAssistQty")));
            result.put(DECIMAL_ENTRY_ADJUSTASSISTQTY, DataImportUtils.transformValue((Object)rs.getString("entry.adjustAssistQty")));
            result.put("FEntry_DiffAssistQty", DataImportUtils.transformValue((Object)rs.getString("entry.diffAssistQty")));
            result.put("FEntry_Remark", DataImportUtils.transformValue((Object)rs.getString("entry.remark")));
            result.put("FCountingPerson_number", DataImportUtils.transformValue((Object)rs.getString("countingPerson.number")));
            result.put("FCountingAgainPerson_number", DataImportUtils.transformValue((Object)rs.getString("countingAgainPerson.number")));
            result.put("FCountingMonitorer_number", DataImportUtils.transformValue((Object)rs.getString("countingMonitorer.number")));
            result.put("FTaskBeginTime", DataImportUtils.transformValue((Object)rs.getString("taskBeginTime")));
            result.put("FTaskEndTime", DataImportUtils.transformValue((Object)rs.getString("taskEndTime")));
            result.put("FSupplier_Number", DataImportUtils.transformValue((Object)rs.getString("supplier.number")));
            result.put("FSupplier_Name", DataImportUtils.transformValue((Object)rs.getString("supplier.name")));
            result.put("FCustomer_Number", DataImportUtils.transformValue((Object)rs.getString("customer.number")));
            result.put("FCustomer_Name", DataImportUtils.transformValue((Object)rs.getString("customer.name")));
            result.put("FStoreStatus_Number", DataImportUtils.transformValue((Object)rs.getString("storeStatus.number")));
            result.put("FStoreStatus_Name", DataImportUtils.transformValue((Object)rs.getString("storeStatus.name")));
            result.put("FProjectNumber", DataImportUtils.transformValue((Object)rs.getString("project.number")));
            result.put("FTrackNumber", DataImportUtils.transformValue((Object)rs.getString("trackNumber.number")));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        OrgUnitCollection collection = null;
        try {
            collection = SCMGroupServerUtils.getAuthOrgByPermItem((Context)ctx, (OrgType)OrgType.Storage, (String)"countingTableExport");
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        FilterInfo filterInfo = (FilterInfo)this.getContextParameter("filter");
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.im.inv.CountingTableExportQuery";
    }

    private PersonInfo getPersonByString(Object number, Context ctx) throws TaskExternalException {
        String str;
        if (number != null && (str = number.toString()) != null && str.length() > 0) {
            try {
                PersonInfo info;
                IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
                PersonCollection collection = iPerson.getPersonCollection(this.getFilter(number.toString()));
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    return info;
                }
            }
            catch (Exception ex) {
                throw new TaskExternalException(CountingTableImport.getResource(ctx, ex.getMessage(), resources));
            }
        }
        return null;
    }

    private void loadLocation(Hashtable lineData, Context ctx, String byProperty, String propertyName, CountingTableEntryInfo entryInfo) throws TaskExternalException {
        block7: {
            try {
                Object data = ((DataToken)lineData.get((Object)propertyName)).data;
                if (this.warehouseInfo.isHasLocation() && (data == null || data.toString().length() <= 0)) {
                    throw new TaskExternalException(this.warehouseInfo.getNumber() + " " + CountingTableImport.getResource(ctx, "LocationMustNotBeNull"));
                }
                if (!this.warehouseInfo.isHasLocation() && data != null && data.toString().length() > 0 || data == null || data.toString() == null || data.toString().trim().length() <= 0) break block7;
                ILocation il = LocationFactory.getLocalInstance((Context)ctx);
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo(byProperty, (Object)data.toString().trim(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("Warehouse.id", (Object)this.warehouseInfo.getId().toString(), CompareType.EQUALS));
                viewInfo.setFilter(filter);
                LocationCollection collection = il.getLocationCollection(viewInfo);
                if (collection != null && collection.size() > 0) {
                    LocationInfo info = collection.get(0);
                    if (info != null) {
                        if (!info.getState().equals((Object)WHStateEnum.ACTIVE)) {
                            throw new TaskExternalException(info.getNumber() + " " + CountingTableImport.getResource(ctx, "LocationNotActive"));
                        }
                        if (!this.warehouseInfo.getId().toString().equals(info.getWarehouse().getId().toString())) {
                            throw new TaskExternalException(info.getNumber() + " " + CountingTableImport.getResource(ctx, "import_location_not_match_warehouse") + " " + this.warehouseInfo.getNumber());
                        }
                        entryInfo.setLocation(info);
                        break block7;
                    }
                    throw new TaskExternalException(data.toString() + " " + CountingTableImport.getResource(ctx, "LocationNotExists"));
                }
                throw new TaskExternalException(data.toString() + " " + CountingTableImport.getResource(ctx, "LocationNotExists"));
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadUnit(Hashtable lineData, Context ctx, String byProperty, String propertyName, CountingTableEntryInfo entryInfo, MaterialInfo materialInfo) throws TaskExternalException {
        try {
            Object data = ((DataToken)lineData.get((Object)propertyName)).data;
            if (data == null || data.toString() == null || data.toString().trim().length() <= 0) throw new TaskExternalException(CountingTableImport.getResource(ctx, "UnitCanNotBeNull"));
            IMeasureUnit imu = MeasureUnitFactory.getLocalInstance((Context)ctx);
            MeasureUnitCollection collection = imu.getMeasureUnitCollection(this.getFilter(data.toString().trim(), byProperty));
            if (collection == null || collection.size() <= 0) throw new TaskExternalException(data.toString() + " " + CountingTableImport.getResource(ctx, "UnitNotExists"));
            MeasureUnitInfo info = collection.get(0);
            this.checkUnit(ctx, materialInfo, info);
            if (info == null) {
                throw new TaskExternalException(data.toString() + " " + CountingTableImport.getResource(ctx, "UnitNotExists"));
            }
            entryInfo.setUnit(info);
            return;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadStoreType(Hashtable lineData, Context ctx, String byProperty, String propertyName, CountingTableEntryInfo entryInfo) throws TaskExternalException {
        try {
            Object data = ((DataToken)lineData.get((Object)propertyName)).data;
            if (data == null || data.toString() == null || data.toString().trim().length() <= 0) throw new TaskExternalException(CountingTableImport.getResource(ctx, "storeTypeNull"));
            StoreTypeInfo info = null;
            info = (StoreTypeInfo)this.storeTypes.get(data.toString().trim());
            if (info == null) {
                IStoreType iStoreType = StoreTypeFactory.getLocalInstance((Context)ctx);
                StoreTypeCollection collection = iStoreType.getStoreTypeCollection(this.getFilter(data.toString().trim(), byProperty));
                if (collection == null || collection.size() <= 0) throw new TaskExternalException(data.toString() + " " + CountingTableImport.getResource(ctx, "storeTypeNotExist"));
                info = collection.get(0);
                if (info == null) throw new TaskExternalException(data.toString() + " " + CountingTableImport.getResource(ctx, "storeTypeNotExist", resources));
                entryInfo.setStoreType(info);
                this.storeTypes.put(data.toString().trim(), info);
                return;
            } else {
                entryInfo.setStoreType(info);
            }
            return;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadCustomer(Hashtable lineData, Context ctx, String byProperty, String propertyName, CountingTableEntryInfo entryInfo) throws TaskExternalException {
        try {
            Object data = ((DataToken)lineData.get((Object)propertyName)).data;
            if (data == null || data.toString() == null || data.toString().trim().length() <= 0) return;
            CustomerInfo info = null;
            info = (CustomerInfo)this.customers.get(data.toString().trim());
            if (info == null) {
                ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
                CustomerCollection collection = iCustomer.getCustomerCollection(this.getFilter(data.toString().trim(), byProperty));
                if (collection == null || collection.size() <= 0) throw new TaskExternalException(data.toString() + " " + CountingTableImport.getResource(ctx, "CustomerNotExists"));
                info = collection.get(0);
                if (info == null) throw new TaskExternalException(data.toString() + " " + CountingTableImport.getResource(ctx, "CustomerNotExists", resources));
                entryInfo.setCustomer(info);
                this.customers.put(data.toString().trim(), info);
                return;
            } else {
                entryInfo.setCustomer(info);
            }
            return;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadSupplier(Hashtable lineData, Context ctx, String byProperty, String propertyName, CountingTableEntryInfo entryInfo) throws TaskExternalException {
        try {
            Object data = ((DataToken)lineData.get((Object)propertyName)).data;
            if (data == null || data.toString() == null || data.toString().trim().length() <= 0) return;
            SupplierInfo info = null;
            info = (SupplierInfo)this.suppliers.get(data.toString().trim());
            if (info == null) {
                ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
                SupplierCollection collection = iSupplier.getSupplierCollection(this.getFilter(data.toString().trim(), byProperty));
                if (collection == null || collection.size() <= 0) throw new TaskExternalException(data.toString() + " " + CountingTableImport.getResource(ctx, "SupplierNotExists"));
                info = collection.get(0);
                if (info == null) throw new TaskExternalException(data.toString() + " " + CountingTableImport.getResource(ctx, "SupplierNotExists", resources));
                entryInfo.setSupplier(info);
                this.suppliers.put(data.toString().trim(), info);
                return;
            } else {
                entryInfo.setSupplier(info);
            }
            return;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadStoreState(Hashtable lineData, Context ctx, String byProperty, String propertyName, CountingTableEntryInfo entryInfo) throws TaskExternalException {
        try {
            Object data = ((DataToken)lineData.get((Object)propertyName)).data;
            if (data == null || data.toString() == null || data.toString().trim().length() <= 0) return;
            StoreStateInfo info = null;
            info = (StoreStateInfo)this.storeStatuses.get(data.toString().trim());
            if (info == null) {
                IStoreState iStoreState = StoreStateFactory.getLocalInstance((Context)ctx);
                StoreStateCollection collection = iStoreState.getStoreStateCollection(this.getFilter(data.toString().trim(), byProperty));
                if (collection == null || collection.size() <= 0) throw new TaskExternalException(data.toString() + " " + CountingTableImport.getResource(ctx, "StoreStatusNotExists"));
                info = collection.get(0);
                if (info == null) throw new TaskExternalException(data.toString() + " " + CountingTableImport.getResource(ctx, "StoreStatusNotExists", resources));
                entryInfo.setStoreStatus(info);
                this.storeStatuses.put(data.toString().trim(), info);
                return;
            } else {
                entryInfo.setStoreStatus(info);
            }
            return;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage());
        }
    }

    private void loadAsstAttr(Hashtable lineData, Context ctx, String byProperty, String propertyName, CountingTableEntryInfo entryInfo, MaterialInfo materialInfo) throws TaskExternalException {
        block4: {
            try {
                Object data = ((DataToken)lineData.get((Object)propertyName)).data;
                this.checkMaterialInfo(ctx, materialInfo, data, 3);
                if (materialInfo.getAssistAttr() == null || data == null || data.toString() == null || data.toString().trim().length() <= 0) break block4;
                IAsstAttrValue iasstAttrValue = AsstAttrValueFactory.getLocalInstance((Context)ctx);
                EntityViewInfo viewInfo = new EntityViewInfo();
                viewInfo = materialInfo.getAssistAttr().getId() != null ? this.getAsstAttrFilter(data.toString().trim(), materialInfo.getAssistAttr().getId().toString(), byProperty) : this.getAsstAttrFilter(data.toString().trim(), null, byProperty);
                AsstAttrValueCollection collection = iasstAttrValue.getAsstAttrValueCollection(viewInfo);
                if (collection != null && collection.size() > 0) {
                    AsstAttrValueInfo info = collection.get(0);
                    if (info != null) {
                        entryInfo.setAssistProperty(info);
                    }
                    break block4;
                }
                throw new TaskExternalException(data.toString() + CountingTableImport.getResource(ctx, "AsstAttrValueExists"));
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage());
            }
        }
    }

    private void loadMaterial(Hashtable lineData, Context ctx, String byProperty, String propertyName, CountingTableEntryInfo entryInfo, MaterialInfo materialInfo) throws TaskExternalException {
        block7: {
            try {
                Object souData = ((DataToken)lineData.get((Object)propertyName)).data;
                if (souData != null && souData.toString().trim().length() > 0) {
                    IMaterial imaterial = MaterialFactory.getLocalInstance((Context)ctx);
                    MaterialCollection collection = imaterial.getMaterialCollection(this.getFilter(souData.toString().trim(), byProperty));
                    if (collection != null && collection.size() > 0) {
                        MaterialInfo info = collection.get(0);
                        if (info != null) {
                            entryInfo.setMaterial(info);
                            materialInfo = info;
                            MaterialInventoryInfo materialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(materialInfo.getId().toString(), this.sou.getId().toString());
                            if (materialInventory == null) {
                                throw new TaskExternalException(materialInfo.getNumber() + " " + this.sou.getNumber() + " " + CountingTableImport.getResource(ctx, "NO_INVENTORY_PROPERTY"));
                            }
                            break block7;
                        }
                        throw new TaskExternalException(souData.toString() + " " + CountingTableImport.getResource(ctx, "MaterialNotExists", resources));
                    }
                    throw new TaskExternalException(souData.toString() + " " + CountingTableImport.getResource(ctx, "MaterialNotExists", resources));
                }
                throw new TaskExternalException(CountingTableImport.getResource(ctx, "MaterialNotExists", resources));
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
    }

    private EntityViewInfo getFilter(String number) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private EntityViewInfo getFilter(String value, String byProperty) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(byProperty, (Object)value, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private EntityViewInfo getAsstAttrFilter(String number, String attrType, String byProperty) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(byProperty, (Object)number, CompareType.EQUALS));
        if (attrType != null) {
            filter.getFilterItems().add(new FilterItemInfo("basictype.id", (Object)attrType, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("compondingtype.id", (Object)attrType, CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("basictype.id is null"));
            filter.getFilterItems().add(new FilterItemInfo("compondingtype.id is null"));
        }
        filter.setMaskString("#0 and (#1 or #2 )");
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private BOSUuid getIdFromNumber(String countingtaskNumber, String warehouseNumber, Context ctx) throws TaskExternalException {
        CountingTableCollection collection;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("countingTask.number", (Object)countingtaskNumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("warehouse.number", (Object)warehouseNumber, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        try {
            collection = CountingTableFactory.getLocalInstance(ctx).getCountingTableCollection(viewInfo);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        if (collection != null && collection.size() > 0) {
            return collection.get(0).getId();
        }
        return null;
    }

    private boolean checkLotInfo(Context ctx, MaterialInfo materialInfo, Object data, StorageOrgUnitInfo sou, CountingTableEntryInfo entryInfo) throws TaskExternalException, BOSException, EASBizException {
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialInventoryInfo materialInventoryInfo = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(materialInfo.getId().toString(), sou.getId().toString());
        boolean isLotNumber = materialInventoryInfo.isIsLotNumber();
        if (!isLotNumber && data != null && data.toString().length() > 0) {
            return false;
        }
        if (isLotNumber && (data == null || data.toString().length() <= 0)) {
            throw new TaskExternalException(materialInfo.getNumber() + CountingTableImport.getResource(ctx, "LotManager"));
        }
        return true;
    }

    private void checkWarehouse(Context ctx, WarehouseInfo warehouseInfo, StorageOrgUnitInfo sou) throws TaskExternalException, BOSException, EASBizException {
        ISOAccreditWH iso = SOAccreditWHFactory.getLocalInstance((Context)ctx);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("WAREHOUSE", (Object)warehouseInfo.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("STORAGEORG", (Object)sou.getId().toString(), CompareType.EQUALS));
        if (!iso.exists(fi)) {
            throw new TaskExternalException(warehouseInfo.getNumber() + "," + sou.getNumber() + " " + CountingTableImport.getResource(ctx, "RelationNotExists"));
        }
    }

    private void checkMaterialInfo(Context ctx, MaterialInfo materialInfo, Object data, int type) throws TaskExternalException, BOSException {
        if (type == 3) {
            AsstAttrTypeInfo asstAttrTypeInfo = materialInfo.getAssistAttr();
            if (!(asstAttrTypeInfo == null && data != null && data.toString().length() > 0 || asstAttrTypeInfo == null || data != null && data.toString().length() > 0)) {
                throw new TaskExternalException(materialInfo.getNumber() + CountingTableImport.getResource(ctx, "SetAssistProperty"));
            }
        } else if (type == 4) {
            MeasureUnitInfo assistUnit = materialInfo.getAssistUnit();
            if (assistUnit == null && data != null && data.toString().length() > 0) {
                throw new TaskExternalException(materialInfo.getNumber() + CountingTableImport.getResource(ctx, "NotSetAssistUnit"));
            }
            if (assistUnit != null && (data == null || data.toString().length() <= 0)) {
                throw new TaskExternalException(materialInfo.getNumber() + CountingTableImport.getResource(ctx, "SetAssistUnit"));
            }
        }
    }

    private void checkUnit(Context ctx, MaterialInfo materialInfo, MeasureUnitInfo mui) throws TaskExternalException, BOSException, EASBizException {
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo mmui = immu.getMultiUnit(materialInfo.getId().toString(), mui.getId().toString());
        if (mmui == null) {
            throw new TaskExternalException(materialInfo.getNumber() + CountingTableImport.getResource(ctx, "UnitNotExists"));
        }
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        return firstNumber != null && currentNumber != null && firstNumber.data != null && !"".equals(firstNumber.data) && currentNumber.data != null && !"".equals(currentNumber.data) && firstNumber.equals((Object)currentNumber);
    }

    public String getMainField() {
        return "FWarehouse_Number";
    }

    private void loadProject(Hashtable lineData, Context ctx, String byProperty, String propertyName, CountingTableEntryInfo entryInfo) throws TaskExternalException {
        block7: {
            try {
                String number;
                EntityViewInfo viewInfo = new EntityViewInfo();
                Object data = ((DataToken)lineData.get((Object)"FProjectNumber")).data;
                if (data == null || (number = data.toString()) == null || number.trim().length() <= 0) break block7;
                IProject iProject = ProjectFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                HashSet<Integer> status = new HashSet<Integer>();
                status.add(new Integer(4));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("baseStatus", status, CompareType.INCLUDE));
                FilterInfo filter2 = new FilterInfo();
                CtrlUnitInfo cu = this.sou.getCU();
                ObjectUuidPK cuPK = null;
                cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
                try {
                    filter2 = iProject.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
                }
                catch (EASBizException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                if (filter2 != null) {
                    filter.mergeFilter(filter2, "and");
                }
                viewInfo.setFilter(filter);
                ProjectCollection coll = iProject.getProjectCollection(viewInfo);
                if (coll != null && coll.size() > 0) {
                    ProjectInfo projectInfo = coll.get(0);
                    entryInfo.setProject(projectInfo);
                    break block7;
                }
                throw new TaskExternalException(data.toString() + " " + CountingTableImport.getResource(ctx, "PROJECT_NUMBER_ERROR", resources));
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), ex.getCause());
            }
        }
    }

    private void loadTrackNum(Hashtable lineData, Context ctx, String byProperty, String propertyName, CountingTableEntryInfo entryInfo) throws TaskExternalException {
        block7: {
            try {
                String number;
                Object data = ((DataToken)lineData.get((Object)"FTrackNumber")).data;
                if (data == null || (number = data.toString()) == null || number.trim().length() <= 0) break block7;
                ITrackNumber iTrackNumber = TrackNumberFactory.getLocalInstance((Context)ctx);
                EntityViewInfo viewInfo = new EntityViewInfo();
                HashSet<Integer> status = new HashSet<Integer>();
                status.add(new Integer(10));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("status", status, CompareType.INCLUDE));
                FilterInfo filter2 = new FilterInfo();
                CtrlUnitInfo cu = this.sou.getCU();
                ObjectUuidPK cuPK = null;
                cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
                try {
                    filter2 = iTrackNumber.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
                }
                catch (EASBizException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                if (filter2 != null) {
                    filter.mergeFilter(filter2, "and");
                }
                viewInfo.setFilter(filter);
                TrackNumberCollection coll = iTrackNumber.getTrackNumberCollection(viewInfo);
                if (coll != null && coll.size() > 0) {
                    TrackNumberInfo trackNumberInfo = coll.get(0);
                    entryInfo.setTrackNumber(trackNumberInfo);
                    break block7;
                }
                throw new TaskExternalException(data.toString() + " " + CountingTableImport.getResource(ctx, "TRACK_NUMBER_ERROR", "com.kingdee.eas.scm.im.inv.app.OtherBillDataImportResource"));
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), ex.getCause());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadInvUnit(Hashtable lineData, Context ctx, String byProperty, String propertyName, CountingTableEntryInfo entryInfo, MaterialInfo materialInfo) throws TaskExternalException {
        try {
            Object data = ((DataToken)lineData.get((Object)propertyName)).data;
            if (data == null || data.toString() == null || data.toString().trim().length() <= 0) throw new TaskExternalException(CountingTableImport.getResource(ctx, "UnitCanNotBeNull"));
            IMeasureUnit imu = MeasureUnitFactory.getLocalInstance((Context)ctx);
            MeasureUnitCollection collection = imu.getMeasureUnitCollection(this.getFilter(data.toString().trim(), byProperty));
            if (collection == null || collection.size() <= 0) throw new TaskExternalException(data.toString() + " " + CountingTableImport.getResource(ctx, "UnitNotExists"));
            MeasureUnitInfo info = collection.get(0);
            this.checkUnit(ctx, materialInfo, info);
            if (info == null) {
                throw new TaskExternalException(data.toString() + " " + CountingTableImport.getResource(ctx, "UnitNotExists"));
            }
            entryInfo.setInvUnit(info);
            return;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private void getCountingQtyByInvCountingQty(Hashtable lineData, MeasureUnitInfo invUnit, MeasureUnitInfo unit, CountingTableEntryInfo entryInfo, Context ctx) throws TaskExternalException {
        Object o1 = ((DataToken)lineData.get((Object)"FEntry_InvCountingQty")).data;
        if (o1 != null && o1.toString().trim().length() > 0) {
            BigDecimal value1 = new BigDecimal(o1.toString());
            if (value1.compareTo(ZERO) < 0) {
                throw new TaskExternalException(CountingTableImport.getResource(ctx, "CountingQtyCannotBeNull"));
            }
            BigDecimal countingQty = ZERO;
            if (invUnit != null && unit != null && entryInfo.getMaterial() != null) {
                try {
                    countingQty = invUnit.getName().equals(unit.getName()) ? value1 : SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)invUnit, (MeasureUnitInfo)unit, (BigDecimal)value1);
                }
                catch (Exception e) {
                    Logger.error((Throwable)e);
                }
            }
            entryInfo.setCountingQty(countingQty);
            entryInfo.setInvCountingQty(value1);
            if (countingQty.compareTo(ZERO) == 0) {
                entryInfo.setZeroFlag(true);
            } else {
                entryInfo.setZeroFlag(false);
            }
        }
    }
}

