/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.ABCEnum;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.StoreType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeCollection;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.basedata.scm.im.inv.ISOAccreditWH;
import com.kingdee.eas.basedata.scm.im.inv.IStoreState;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationCollection;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHCollection;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateCollection;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.RecentCostInfo;
import com.kingdee.eas.scm.cal.app.help.RecentCostHelp;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.AbstractOtherInWarehsBillEntryInfo;
import com.kingdee.eas.scm.im.inv.AbstractOtherIssueBillEntryInfo;
import com.kingdee.eas.scm.im.inv.CountingException;
import com.kingdee.eas.scm.im.inv.CountingListLocationCollection;
import com.kingdee.eas.scm.im.inv.CountingListLocationInfo;
import com.kingdee.eas.scm.im.inv.CountingListMaterialCollection;
import com.kingdee.eas.scm.im.inv.CountingListMaterialInfo;
import com.kingdee.eas.scm.im.inv.CountingListWarehouseCollection;
import com.kingdee.eas.scm.im.inv.CountingListWarehouseInfo;
import com.kingdee.eas.scm.im.inv.CountingTableCollection;
import com.kingdee.eas.scm.im.inv.CountingTableEntryCollection;
import com.kingdee.eas.scm.im.inv.CountingTableEntryFactory;
import com.kingdee.eas.scm.im.inv.CountingTableEntryInfo;
import com.kingdee.eas.scm.im.inv.CountingTableFactory;
import com.kingdee.eas.scm.im.inv.CountingTableInfo;
import com.kingdee.eas.scm.im.inv.CountingTaskInfo;
import com.kingdee.eas.scm.im.inv.ICountingTable;
import com.kingdee.eas.scm.im.inv.ICountingTableEntry;
import com.kingdee.eas.scm.im.inv.IOtherInWarehsBill;
import com.kingdee.eas.scm.im.inv.IOtherIssueBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.InventoryUpdateFactory;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillEntryCollection;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillEntryInfo;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillEntryCollection;
import com.kingdee.eas.scm.im.inv.OtherIssueBillEntryInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillFactory;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.TaskStatusEnum;
import com.kingdee.eas.scm.im.inv.app.AbstractCountingTaskControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.inv.invconfig.app.CountingTableAppHelper;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.sql.RowSet;

public class CountingTaskControllerBean
extends AbstractCountingTaskControllerBean {
    private static final long serialVersionUID = 815678456778L;
    private static final int ONE = 1;
    protected static final String OUT_EFFECT = "OUT_EFFECT";
    protected static final String IN_EFFECT = "IN_EFFECT";
    private static final String PARAM_ISBASEUNITUPDATE = "INM004";
    private static final String PARAM_ISARUPDATE = "CONSIGNSALES";
    private static final String IS_BASEUNIT_UPDATE = "isBaseUpdate";
    private static final String IS_AR_UPDATE = "isArUpdate";
    private String[][] billPropertyID = new String[][]{{"FWarehouseID", "EgkAAABc3XG76fiu"}, {"FLocationID", "EgkAAABc3XMgX/hq"}, {"FLot", "YNi0IQEOEADgBT3mfwAAAcznrtQ="}, {"FSupplierID", "EgkAAABc3Xo3xn38"}, {"FCustomerID", "EgkAAABc3Xu/DAQO"}, {"FAssistUnitID", "EgkAAAA5EWFbglxX"}, {"FAssistPropertyID", "EgkAAAA5EWALxvQu"}, {"FProjectID", "EgkAAABc3Xza3gXu"}, {"FTrackNumberID", "EgkAAABc3X0Ibpg9"}};
    private String sort = "";
    private List<String> extendFields = null;
    private Map mapping = null;

    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        if (this.isSameNumber(ctx, pk, model)) {
            throw new CountingException(CountingException.NUMBERDUP);
        }
        return true;
    }

    protected boolean _checkSubmit(Context ctx, IObjectValue model, boolean isOk) throws EASBizException, BOSException {
        CountingTaskInfo billInfo = (CountingTaskInfo)model;
        if (billInfo.getTaskStatus() != null) {
            if (isOk) {
                if (billInfo.getTaskStatus().getValue() == 1) {
                    throw new SCMBillException(SCMBillException.CHECKSUBMITOK, new Object[]{billInfo.getString("number")});
                }
            } else if (billInfo.getTaskStatus().getValue() != 1) {
                throw new SCMBillException(SCMBillException.CHECKSUBMITNOTOK, new Object[]{billInfo.getString("number"), ""});
            }
        }
        return true;
    }

    protected boolean _saveOrSubmitCheckAudit(Context ctx, IObjectValue model, boolean isOk) throws EASBizException, BOSException {
        CountingTaskInfo billInfo = (CountingTaskInfo)model;
        if (billInfo.getTaskStatus() != null) {
            if (isOk) {
                if (billInfo.getTaskStatus().getValue() == 6) {
                    throw new SCMBillException(SCMBillException.CHECKAUDITEDOK, new Object[]{billInfo.getString("number"), ""});
                }
            } else if (billInfo.getTaskStatus().getValue() != 6) {
                throw new SCMBillException(SCMBillException.CHECKAUDITEDNOTOK, new Object[]{billInfo.getString("number"), ""});
            }
        }
        return true;
    }

    protected boolean _checkNumberBlank(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CountingTaskInfo billInfo = (CountingTaskInfo)model;
        String number = billInfo.getNumber();
        if (number == null || "".equals(number) || "".equals(number.trim())) {
            throw new CountingException(CountingException.NUMBERBLANK);
        }
        billInfo.setNumber(number.trim());
        return true;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CountingTaskInfo info = (CountingTaskInfo)model;
        if (info.getId() != null) {
            ObjectUuidPK pkNew = new ObjectUuidPK(info.getId());
            CountingTaskInfo billInfo = this.getCountingTaskInfo(ctx, (IObjectPK)pkNew);
            this._checkSubmit(ctx, (IObjectValue)billInfo, true);
            this._saveOrSubmitCheckAudit(ctx, (IObjectValue)billInfo, true);
        }
        if (info.getCU() == null) {
            info.setCU(super.getCU(ctx, (ObjectBaseInfo)info));
        }
        if (info.getNumber() == null) {
            this.setBillNewNumber(ctx, model);
        }
        this._checkNumberBlank(ctx, null, (IObjectValue)info);
        this._checkNumberDup(ctx, null, model);
        info.setTaskStatus(TaskStatusEnum.TEMPORARILYSAVED);
        ServiceStateManager.getInstance().enableNextCallServices();
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CountingTaskInfo info = (CountingTaskInfo)model;
        if (info.getCU() == null) {
            info.setCU(super.getCU(ctx, (ObjectBaseInfo)info));
        }
        if (info.getNumber() == null) {
            this.setBillNewNumber(ctx, model);
        }
        this._checkNumberBlank(ctx, null, (IObjectValue)info);
        this._checkNumberDup(ctx, null, model);
        if (info.getId() != null) {
            ICountingTable iCountingTable = CountingTableFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("countingTask", (Object)info.getId().toString()));
            iCountingTable.delete(filter);
            ObjectUuidPK pkNew = new ObjectUuidPK(info.getId());
            CountingTaskInfo billInfo = this.getCountingTaskInfo(ctx, (IObjectPK)pkNew);
            this._saveOrSubmitCheckAudit(ctx, (IObjectValue)billInfo, true);
        }
        info.setTaskStatus(TaskStatusEnum.MAKEBILL);
        IObjectPK pk = super._submit(ctx, model);
        boolean isAutoAudit = false;
        String billTypeId = "50957179-0105-1000-e004-4152c0a812fd463ED552";
        ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
        String strAutoAudit = scmParam.getParamByBillTypeID("SCM_Submit_01", 4, info.getStorageOrgUnit().getId().toString(), billTypeId);
        if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().equalsIgnoreCase("1")) {
            isAutoAudit = true;
        }
        if (isAutoAudit) {
            this._passAudit(ctx, pk, (IObjectValue)info);
        }
        return pk;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String billIdString = pk.toString();
        CountingTaskInfo billInfo = this.getCountingTaskInfo(ctx, pk);
        this._checkHasAudit(ctx, (IObjectValue)billInfo);
        this.rolbackNumber(ctx, (IObjectValue)billInfo);
        if (billIdString != null) {
            ICountingTable iCountingTable = CountingTableFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("countingTask", (Object)billIdString));
            iCountingTable.delete(filter);
        }
        super._delete(ctx, pk);
    }

    protected void setBillNewNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CountingTaskInfo billInfo = (CountingTaskInfo)model;
        String strCompanyID = this.getCompanyID(ctx, model);
        if (this.isAddNew(ctx, (IObjectValue)billInfo) && this.isRuleAutoNumber(ctx, billInfo, strCompanyID) && !this.isModifiable(ctx, billInfo, strCompanyID)) {
            billInfo = this._getNewNumber(ctx, (IObjectValue)billInfo, strCompanyID, "");
        }
    }

    private String getCompanyID(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        CountingTaskInfo billInfo = (CountingTaskInfo)model;
        if (billInfo == null) {
            return null;
        }
        String strCompanyID = null;
        StorageOrgUnitInfo storage = billInfo.getStorageOrgUnit();
        if (storage == null) {
            return null;
        }
        CompanyOrgUnitInfo CompanyInfo = InvServerUtils.getCompanyInfoForStorage(ctx, storage);
        if (CompanyInfo != null && CompanyInfo.getId() != null) {
            strCompanyID = CompanyInfo.getId().toString();
        }
        return strCompanyID;
    }

    protected boolean isAddNew(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        boolean ret = false;
        CountingTaskInfo billInfo = (CountingTaskInfo)model;
        ret = billInfo.getId() == null || billInfo.getId().toString().trim().length() == 0 || !this._exists(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()));
        return ret;
    }

    @Override
    protected void _viewStrategy(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    protected void buildCountTable(Context ctx, IObjectPK pk, boolean param) throws BOSException, EASBizException {
        String storageOrgID;
        String companyID;
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("countingListWarehouse.*"));
        sc.add(new SelectorItemInfo("locationGroups"));
        sc.add(new SelectorItemInfo("countingListLocation.*"));
        sc.add(new SelectorItemInfo("countingListMaterial.*"));
        CountingTaskInfo billInfo = this.getCountingTaskInfo(ctx, pk, sc);
        boolean isSelStoreType = false;
        if (billInfo.getFromStoreType() != StoreType.NULL || billInfo.getToStoreType() != StoreType.NULL) {
            isSelStoreType = true;
        }
        boolean isSelABCCode = false;
        if (billInfo.getFromABCCode() != ABCEnum.NOTSELECT || billInfo.getToABCCode() != ABCEnum.NOTSELECT) {
            isSelABCCode = true;
        }
        if ((companyID = this.getCompanyOrgID(ctx, storageOrgID = billInfo.getStorageOrgUnit().getId().toString())) == null) {
            throw new CountingException(CountingException.NOCOMPANYDEFINE);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.getInventorySQL(ctx, billInfo));
        sb.append(this.getJoinSQL(billInfo, isSelStoreType, isSelABCCode, storageOrgID, companyID));
        sb.append(this.getFilterSQL(ctx, billInfo, isSelStoreType, isSelABCCode, storageOrgID, companyID));
        boolean findData = this.creatCountTable(ctx, pk, billInfo, sb.toString());
        if (!findData) {
            throw new CountingException(CountingException.NOINVENTORYFIND);
        }
        SelectorItemCollection sc2 = new SelectorItemCollection();
        sc2.add(new SelectorItemInfo("id"));
        sc2.add(new SelectorItemInfo("number"));
        sc2.add(new SelectorItemInfo("taskStatus"));
        CountingTaskInfo bCountingTaskInfo = this.getCountingTaskInfo(ctx, pk, sc2);
        bCountingTaskInfo.setTaskStatus(TaskStatusEnum.BUILDTABLE);
        this.update(ctx, pk, (CoreBaseInfo)bCountingTaskInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _buildCountTable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("countingListWarehouse.*"));
        sc.add(new SelectorItemInfo("locationGroups"));
        sc.add(new SelectorItemInfo("countingListLocation.*"));
        sc.add(new SelectorItemInfo("countingListMaterial.*"));
        CountingTaskInfo billInfo = this.getCountingTaskInfo(ctx, pk, sc);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("countingTask", (Object)billInfo.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        boolean isSelStoreType = false;
        if (billInfo.getFromStoreType() != StoreType.NULL || billInfo.getToStoreType() != StoreType.NULL) {
            isSelStoreType = true;
        }
        boolean isSelABCCode = false;
        if (billInfo.getFromABCCode() != ABCEnum.NOTSELECT || billInfo.getToABCCode() != ABCEnum.NOTSELECT) {
            isSelABCCode = true;
        }
        boolean isInventory = billInfo.getIsInventory() == 1;
        String tempTableName = null;
        String tempTableBackup = null;
        String orgTempTable = null;
        try {
            boolean findData;
            String storageOrgID = billInfo.getStorageOrgUnit().getId().toString();
            String companyID = this.getCompanyOrgID(ctx, storageOrgID);
            if (companyID == null) {
                throw new CountingException(CountingException.NOCOMPANYDEFINE);
            }
            StringBuffer sb = new StringBuffer();
            this.mapping = CountingTableAppHelper.getExtendField4Inv(ctx);
            this.extendFields = (List)this.mapping.get("extendFieldList");
            if (isInventory) {
                sb.append(this.getInventorySQL(ctx, billInfo));
            } else {
                tempTableName = KsqlUtil.createTempTable((Context)ctx, (String)this.getCreateTempTableSql());
                tempTableBackup = KsqlUtil.createTempTable((Context)ctx, (String)this.getCreateTempTableSql());
                orgTempTable = KsqlUtil.createTempTable((Context)ctx, (String)this.getcreateOrgTempTable());
                this.buildStorageOrgTable(ctx, orgTempTable, billInfo);
                this.updateStorageOrgBeingDate(ctx, orgTempTable, billInfo);
                sb.append(this.getBizDateCountingSQL(ctx, billInfo, orgTempTable, tempTableName, tempTableBackup));
            }
            sb.append(this.getJoinSQL(billInfo, isSelStoreType, isSelABCCode, storageOrgID, companyID));
            String extJoinSql = this.getExtJoinSQL(billInfo);
            if (!StringUtils.isEmpty((String)extJoinSql)) {
                sb.append(extJoinSql);
            }
            sb.append(this.getFilterSQL(ctx, billInfo, isSelStoreType, isSelABCCode, storageOrgID, companyID));
            String extWhereSql = this.getExtFilterSQL(billInfo);
            if (!StringUtils.isEmpty((String)extWhereSql)) {
                sb.append(extWhereSql);
            }
            if (!(findData = this.creatCountTable(ctx, pk, billInfo, sb.toString()))) {
                throw new CountingException(CountingException.NOINVENTORYFIND);
            }
            SelectorItemCollection sc2 = new SelectorItemCollection();
            sc2.add(new SelectorItemInfo("id"));
            sc2.add(new SelectorItemInfo("number"));
            sc2.add(new SelectorItemInfo("taskStatus"));
            CountingTaskInfo bCountingTaskInfo = this.getCountingTaskInfo(ctx, pk, sc2);
            bCountingTaskInfo.setTaskStatus(TaskStatusEnum.BUILDTABLE);
            this.update(ctx, pk, (CoreBaseInfo)bCountingTaskInfo);
        }
        catch (Throwable throwable) {
            KsqlUtil.releaseTempTable((Context)ctx, tempTableName);
            KsqlUtil.releaseTempTable((Context)ctx, tempTableBackup);
            KsqlUtil.releaseTempTable((Context)ctx, orgTempTable);
            throw throwable;
        }
        KsqlUtil.releaseTempTable((Context)ctx, (String)tempTableName);
        KsqlUtil.releaseTempTable((Context)ctx, (String)tempTableBackup);
        KsqlUtil.releaseTempTable((Context)ctx, (String)orgTempTable);
    }

    private String getCompanyOrgID(Context ctx, String storageOrgID) throws BOSException, EASBizException {
        OrgUnitCollection orgCol;
        CompanyOrgUnitInfo companyInfo;
        String companyID = null;
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        if (storageOrgID != null && storageOrgID.length() > 0 && (companyInfo = (CompanyOrgUnitInfo)(orgCol = iUnitRel.getToUnit(storageOrgID, 4, 1)).get(0)) != null) {
            companyID = companyInfo.getId().toString();
        }
        return companyID;
    }

    private String getInventorySQL(Context ctx, CountingTaskInfo billInfo) {
        Locale loc = ctx.getLocale();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT A.FID,");
        sb.append("A.FCompanyOrgUnitID,A.FStorageOrgUnitID,\n ");
        sb.append("CASE WHEN A.FWarehouseID = '").append("EgkAAABc3XG76fiu");
        sb.append("' THEN NULL ELSE A.FWarehouseID END AS FWarehouseID,\n");
        sb.append("CASE WHEN A.FLocationID = '").append("EgkAAABc3XMgX/hq");
        sb.append("' THEN NULL ELSE A.FLocationID END AS FLocationID,\n");
        sb.append("C.FNUMBER,\n");
        sb.append("A.FStoreTypeID, \n");
        if (billInfo.getStorageTypes() != null && billInfo.getStorageTypes().trim().length() != 0) {
            sb.append("storetype.FNUMBER, \n");
        }
        sb.append("A.FStoreStatusID, \n");
        if (billInfo.getStoreStatus() != null && billInfo.getStoreStatus().trim().length() != 0) {
            sb.append("storetatus.FNUMBER, \n");
        }
        sb.append("CASE WHEN A.FLot = '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=");
        sb.append("' THEN NULL ELSE A.FLot END AS FLot, \n");
        sb.append("CASE WHEN A.FSupplierID = '").append("EgkAAABc3Xo3xn38");
        sb.append("' THEN NULL ELSE A.FSupplierID END AS FSupplierID, \n");
        sb.append("CASE WHEN A.FCustomerID = '").append("EgkAAABc3Xu/DAQO");
        sb.append("' THEN NULL ELSE A.FCustomerID END AS FCustomerID, \n");
        sb.append("A.FMaterialID,A.FUnitID,\n");
        sb.append(" decimal(isnull(A.FCurStoreQty,0) + isnull(A.FLockQty,0),28,10)as FCurStoreQty, \n");
        sb.append("CASE WHEN A.FAssistUnitID = '").append("EgkAAAA5EWFbglxX");
        sb.append("' THEN NULL ELSE A.FAssistUnitID END AS FAssistUnitID, \n");
        sb.append(" decimal(isnull(A.FCurStoreAssistQty,0) + isnull(A.FLOCKASSISTQTY,0),28,10) as FCurStoreAssistQty,\n");
        sb.append(" decimal(isnull(A.FBaseQty,0) + isnull(A.FLockBaseQty,0),28,10) as FBaseQty,\n");
        sb.append(" decimal(A.FAmount,28,10) as FAmount,A.FControlUnitID,A.FBaseUnitID,B.FNumber,D.FNumber, \n");
        sb.append("CASE WHEN A.FAssistPropertyID = '").append("EgkAAAA5EWALxvQu");
        sb.append("' THEN NULL ELSE A.FAssistPropertyID END AS FAssistPropertyID, \n");
        sb.append("B.FNAME_").append(loc).append(", D.FMODEL, D.FNAME_").append(loc).append(",MINV.FUnitID, \n");
        sb.append(" round(decimal((isnull(A.FBaseQty,0)+isnull(A.FLockBaseQty,0))/MuU.FBaseConvsRate,28,10),MuU.FQtyPrecision) FInvAccountQty,\n ");
        sb.append("CASE WHEN A.FProjectID = '").append("EgkAAABc3Xza3gXu");
        sb.append("' THEN NULL ELSE A.FProjectID END AS FProjectID, \n");
        sb.append("CASE WHEN A.FTrackNumberID = '").append("EgkAAABc3X0Ibpg9");
        sb.append("' THEN NULL ELSE A.FTrackNumberID END AS FTrackNumberID, \n");
        sb.append(" to_date(to_char(dates.fmfg,'YYYY-MM-DD')),to_date(to_char(dates.fexp,'YYYY-MM-DD')) ");
        for (int i = 0; i < this.extendFields.size(); ++i) {
            String billField = this.extendFields.get(i);
            String invField = this.mapping.get(billField).toString();
            sb.append(", A.").append(invField).append(" as ").append(invField).append(" \n");
        }
        sb.append("FROM T_IM_Inventory A \n");
        sb.append("INNER JOIN T_DB_WAREHOUSE B ON A.FWarehouseID = B.FID \n");
        sb.append("LEFT OUTER JOIN T_DB_LOCATION C ON A.FLocationID = C.FID \n");
        sb.append("INNER JOIN T_BD_Material D ON A.FMaterialID = D.FID \n");
        sb.append("INNER JOIN T_BD_MaterialInventory MINV ON A.FMaterialID = MINV.FMaterialID   AND A.FSTORAGEORGUNITID = MINV.FOrgUnit   \n");
        sb.append("INNER JOIN T_BD_MultiMeasureUnit   MuU ON MINV.FMaterialID = MuU.FMaterialID AND MINV.FUnitID = MuU.FMeasureUnitID  \n");
        return sb.toString();
    }

    private String getBizDateCountingSQL(Context ctx, CountingTaskInfo billInfo, String orgTempTable, String tempTableName, String tempTableBackup) throws BOSException, EASBizException {
        String storageOrgID = null;
        if (billInfo.getStorageOrgUnit() != null && billInfo.getStorageOrgUnit().getId() != null) {
            storageOrgID = billInfo.getStorageOrgUnit().getId().toString();
        }
        if (storageOrgID == null) {
            return null;
        }
        this.insertBalanceData(ctx, orgTempTable, tempTableName);
        this.insertBillData(ctx, orgTempTable, storageOrgID, tempTableName);
        StringBuffer updateSql = new StringBuffer();
        ArrayList<String> sqls = new ArrayList<String>();
        int len = this.billPropertyID.length;
        for (int i = 0; i < len; ++i) {
            updateSql.append("update ").append(tempTableName).append(" set ").append(this.billPropertyID[i][0]).append(" = null where ").append(this.billPropertyID[i][0]).append(" = '").append(this.billPropertyID[i][1]).append("' \t\n");
            sqls.add(updateSql.toString());
            updateSql.setLength(0);
        }
        DbUtil.executeBatch((Context)ctx, sqls);
        HashMap params = this.getParam(ctx, storageOrgID);
        Boolean isBaseUpdate = (Boolean)params.get(IS_BASEUNIT_UPDATE);
        StringBuffer groupByInv = this.getGroupBy(isBaseUpdate, tempTableName);
        StringBuffer sqlIn = new StringBuffer();
        sqlIn.append("insert into ").append(tempTableBackup).append(" ");
        sqlIn.append("(fid,fcompanyorgunitid,fstorageorgunitid,fmaterialid,funitid,fbaseunitid,");
        sqlIn.append("fassistunitid,fassistpropertyid,fstoretypeid,fstorestatusid,fsupplierid,fcustomerid,");
        sqlIn.append("fwarehouseid,flocationid,flot,fcurstoreqty,fbaseqty,fcurstoreassistqty,FProjectID,FTrackNumberID ");
        for (int i = 0; i < this.extendFields.size(); ++i) {
            sqlIn.append(",").append(this.extendFields.get(i));
        }
        sqlIn.append(")");
        StringBuffer finalSQL = new StringBuffer();
        finalSQL.setLength(0);
        finalSQL.append(sqlIn).append(groupByInv);
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)finalSQL.toString());
        finalSQL.setLength(0);
        finalSQL.append(" delete from ").append(tempTableName);
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)finalSQL.toString());
        finalSQL.setLength(0);
        finalSQL.append("SELECT A.FID,");
        finalSQL.append("A.FCompanyOrgUnitID,A.FStorageOrgUnitID,A.FWarehouseID,A.FLocationID, C.FNUMBER,");
        finalSQL.append("A.FStoreTypeID");
        if (billInfo.getStorageTypes() != null && billInfo.getStorageTypes().trim().length() != 0) {
            finalSQL.append(",storetype.FNUMBER");
        }
        finalSQL.append(",A.FStoreStatusID");
        if (billInfo.getStoreStatus() != null && billInfo.getStoreStatus().trim().length() != 0) {
            finalSQL.append(",storetatus.FNUMBER");
        }
        finalSQL.append(",A.FLot,A.FSupplierID,A.FCustomerID,A.FMaterialID,");
        finalSQL.append(" A.FUnitID,decimal(isnull(A.FCurStoreQty,0),28,10)as FCurStoreQty, ");
        finalSQL.append(" A.FAssistUnitID,decimal(isnull(A.FCurStoreAssistQty,0),28,10) as FCurStoreAssistQty,");
        finalSQL.append(" decimal(isnull(A.FBaseQty,0) ,28,10) as FBaseQty, ");
        finalSQL.append(" 0 as FAmount,null as FControlUnitID,A.FBaseUnitID,B.FNumber,D.FNumber, ");
        finalSQL.append(" A.FAssistPropertyID, B.FNAME_L2, D.FMODEL, D.FNAME_L2, ");
        finalSQL.append(" MINV.FUnitID, ");
        finalSQL.append(" round(decimal(A.FBaseQty/MuU.FBaseConvsRate,28,10),MuU.FQtyPrecision) FInvAccountQty ");
        finalSQL.append(" ,A.FProjectID, A.FTrackNumberID ,A.FMfg,A.FExp");
        for (int i = 0; i < this.extendFields.size(); ++i) {
            finalSQL.append(", A.").append(this.extendFields.get(i));
        }
        finalSQL.append(" FROM ").append(tempTableBackup).append(" A ");
        finalSQL.append("INNER JOIN T_DB_WAREHOUSE B ON A.FWarehouseID = B.FID ");
        finalSQL.append("LEFT OUTER JOIN T_DB_LOCATION C ON A.FLocationID = C.FID ");
        finalSQL.append("INNER JOIN T_BD_Material D ON A.FMaterialID = D.FID ");
        finalSQL.append("INNER JOIN T_BD_MaterialInventory MINV ON A.FMaterialID = MINV.FMaterialID   AND A.FSTORAGEORGUNITID = MINV.FOrgUnit   ");
        finalSQL.append("INNER JOIN T_BD_MultiMeasureUnit   MuU ON MINV.FMaterialID = MuU.FMaterialID AND MINV.FUnitID = MuU.FMeasureUnitID  ");
        return finalSQL.toString();
    }

    private String getJoinSQL(CountingTaskInfo billInfo, boolean isSelStoreType, boolean isSelABCCode, String storageOrgID, String companyID) {
        StringBuffer sb = new StringBuffer();
        if (billInfo.getStorageTypes() != null && billInfo.getStorageTypes().trim().length() != 0) {
            String strStoreType = billInfo.getStorageTypes();
            strStoreType = strStoreType == null ? "" : strStoreType.trim();
            strStoreType = strStoreType.replaceAll("; ", ",");
            FilterInfo storeTypeInfo = new FilterInfo();
            storeTypeInfo.getFilterItems().add(new FilterItemInfo("storetype.fnumber", (Object)strStoreType, CompareType.INCLUDE));
            sb.append("inner join t_im_storetype storetype on ").append("\r\n");
            sb.append("storetype.fid = A.FStoreTypeID and ").append("\r\n");
            sb.append(storeTypeInfo).append("\r\n");
        }
        if (billInfo.getStoreStatus() != null && billInfo.getStoreStatus().trim().length() != 0) {
            String strStoreStatus = billInfo.getStoreStatus();
            strStoreStatus = strStoreStatus == null ? "" : strStoreStatus.trim();
            strStoreStatus = strStoreStatus.replaceAll("; ", ",");
            FilterInfo stoureStatusFilter = new FilterInfo();
            stoureStatusFilter.getFilterItems().add(new FilterItemInfo("storetatus.fnumber", (Object)strStoreStatus, CompareType.INCLUDE));
            sb.append("inner join t_im_storestate storetatus on ").append("\r\n");
            sb.append("storetatus.fid = A.FStoreStatusID and ").append("\r\n");
            sb.append(stoureStatusFilter).append("\r\n");
        }
        if (isSelABCCode) {
            sb.append("LEFT OUTER JOIN T_BD_MaterialInventory E ON D.FID = E.FMaterialID AND E.Forgunit = '");
            sb.append(storageOrgID);
            sb.append("' ");
        }
        if (isSelStoreType) {
            sb.append("INNER JOIN T_BD_MaterialCost F ON D.FID = F.FMaterialID AND F.Forgunit = '");
            sb.append(companyID);
            sb.append("' ");
        }
        sb.append(" left join t_IM_DateOfMinDurability dates on a.FMaterialID = dates.FMaterialID  ");
        sb.append("  and a.flot = dates.flot and a.fstorageorgunitid = dates.fstorageorgunitid ");
        return sb.toString();
    }

    private String getFilterSQL(Context ctx, CountingTaskInfo billInfo, boolean isSelStoreType, boolean isSelABCCode, String storageOrgID, String companyID) throws BOSException {
        boolean isInventory;
        StringBuffer sb = new StringBuffer();
        Object cols = null;
        CountingListWarehouseCollection wareHouseColl = billInfo.getCountingListWarehouse();
        String locGroups = null;
        CountingListLocationCollection locationColl = billInfo.getCountingListLocation();
        CountingListMaterialCollection materialColl = billInfo.getCountingListMaterial();
        if (billInfo.getLocationGroups() != null && billInfo.getLocationGroups().trim().length() > 0) {
            locGroups = billInfo.getLocationGroups().replaceAll(";", ",");
        }
        sb.append("WHERE A.FStorageOrgUnitID ='");
        sb.append(storageOrgID);
        sb.append("' ");
        if (!billInfo.isIsAssignWarehouse()) {
            if (billInfo.getFromWarehouse() != null && billInfo.getFromWarehouse().trim().length() > 0) {
                sb.append("AND B.FNumber >= '");
                sb.append(billInfo.getFromWarehouse());
                sb.append("' ");
            }
            if (billInfo.getToWarehouse() != null && billInfo.getToWarehouse().trim().length() > 0) {
                sb.append("AND B.FNumber <= '");
                sb.append(billInfo.getToWarehouse());
                sb.append("' ");
            }
            if (locGroups != null) {
                this.addLocationFilter(this.getLocationListbyLocGroup(ctx, locGroups), sb, CompareType.INCLUDE);
            }
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrg", (Object)storageOrgID, CompareType.EQUALS));
            entityViewInfo.setFilter(filterInfo);
            ISOAccreditWH iSOAccreditWH = SOAccreditWHFactory.getLocalInstance((Context)ctx);
            SOAccreditWHCollection sOAWHcoll = iSOAccreditWH.getSOAccreditWHCollection(entityViewInfo);
            Vector<String> vecWareHouse = new Vector<String>(0);
            int size = sOAWHcoll.size();
            for (int i = 0; i < size; ++i) {
                SOAccreditWHInfo info = sOAWHcoll.get(i);
                vecWareHouse.add(info.getWarehouse().toString());
            }
            this.addWarehouseFilter(vecWareHouse, sb, CompareType.INCLUDE);
            this.addListWarehouseFilter(wareHouseColl, sb, CompareType.NOTINCLUDE);
        } else {
            this.addListWarehouseFilter(wareHouseColl, sb, CompareType.INCLUDE);
        }
        if (!billInfo.isIsAssignLocation()) {
            if (billInfo.getFromLocation() != null && billInfo.getFromLocation().trim().length() > 0) {
                sb.append("AND C.FNumber >= '");
                sb.append(billInfo.getFromLocation());
                sb.append("' ");
            }
            if (billInfo.getToLocation() != null && billInfo.getToLocation().trim().length() > 0) {
                sb.append("AND C.FNumber <= '");
                sb.append(billInfo.getToLocation());
                sb.append("' ");
            }
            this.addListLocationFilter(locationColl, sb, CompareType.NOTINCLUDE);
        } else {
            this.addListLocationFilter(locationColl, sb, CompareType.INCLUDE);
        }
        if (!billInfo.isIsAssignMaterial()) {
            if (billInfo.getFromMaterial() != null && billInfo.getFromMaterial().trim().length() > 0) {
                sb.append("AND D.FNumber >= '");
                sb.append(billInfo.getFromMaterial());
                sb.append("' ");
            }
            if (billInfo.getToMaterial() != null && billInfo.getToMaterial().trim().length() > 0) {
                sb.append("AND D.FNumber <= '");
                sb.append(billInfo.getToMaterial());
                sb.append("' ");
            }
            this.addListMaterialFilter(materialColl, sb, CompareType.NOTINCLUDE);
        } else {
            this.addListMaterialFilter(materialColl, sb, CompareType.INCLUDE);
        }
        if (isSelStoreType) {
            if (billInfo.getFromStoreType() != null && billInfo.getFromStoreType() != StoreType.NULL) {
                int stFrom = billInfo.getFromStoreType().getValue();
                sb.append("AND F.FStoreType >= ");
                sb.append(stFrom);
                sb.append(" ");
            }
            if (billInfo.getToStoreType() != null && billInfo.getToStoreType() != StoreType.NULL) {
                int stTo = billInfo.getToStoreType().getValue();
                sb.append("AND F.FStoreType <= ");
                sb.append(stTo);
                sb.append(" ");
            }
        }
        if (isSelABCCode) {
            if (billInfo.getFromABCCode() != null && billInfo.getFromABCCode() != ABCEnum.NOTSELECT) {
                int stFrom = billInfo.getFromABCCode().getValue();
                sb.append("AND E.FABCType >= ");
                sb.append(stFrom);
                sb.append(" ");
            }
            if (billInfo.getToStoreType() != null && billInfo.getToABCCode() != ABCEnum.NOTSELECT) {
                int stTo = billInfo.getToABCCode().getValue();
                sb.append("AND E.FABCType <= ");
                sb.append(stTo);
                sb.append(" ");
            }
        }
        boolean bl = isInventory = billInfo.getIsInventory() == 1;
        if (!billInfo.isIsGenCountingTableForZero()) {
            if (isInventory) {
                sb.append("AND (isnull(A.FCurStoreQty,0) + isnull(A.FLockQty,0)) != 0 ");
            } else {
                sb.append("AND isnull(A.FCurStoreQty,0)  != 0 ");
            }
        }
        return sb.toString();
    }

    protected String getCreateTempTableSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table T_IM_Inventory_temp (").append("FID VARCHAR(44) NOT NULL ,").append("FCompanyOrgUnitID VARCHAR(44),").append("FStorageOrgUnitID VARCHAR(44),").append("FWarehouseID VARCHAR(44),").append("FLocationID VARCHAR(44),").append("FStoreTypeID VARCHAR(44),").append("FStoreStatusID VARCHAR(44),").append("FLot NVARCHAR(80),").append("FMfg datetime,").append("FExp datetime,").append("FSupplierID VARCHAR(44),").append("FCustomerID VARCHAR(44),").append("FMaterialID VARCHAR(44),").append("FUnitID VARCHAR(44),").append("FCurStoreQty NUMERIC(28,16) DEFAULT 0,").append("FAssistUnitID VARCHAR(44),").append("FCurStoreAssistQty NUMERIC(28,16),").append("FBaseQty NUMERIC(28,16) DEFAULT 0,").append("FBaseUnitID VARCHAR(44),").append("FLockQty NUMERIC(28,16) DEFAULT 0,").append("FLockBaseQty NUMERIC(28,16) DEFAULT 0,").append("FLockAssistQty NUMERIC(28,16) DEFAULT 0,").append("FAssistPropertyID VARCHAR(44),").append("FProjectID VARCHAR(44), ").append("FTrackNumberID VARCHAR(44) ");
        for (int i = 0; i < this.extendFields.size(); ++i) {
            sql.append(",").append(this.extendFields.get(i)).append(" VARCHAR(44) ");
        }
        sql.append(");");
        return sql.toString();
    }

    private String getcreateOrgTempTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table OrgTempTable (");
        sql.append("fid varchar(44) not null  primary key ,");
        sql.append("fbegindate datetime,");
        sql.append("fenddate datetime,");
        sql.append("fbeginyear int,");
        sql.append("fbeginperiod int ");
        sql.append(")");
        return sql.toString();
    }

    private void buildStorageOrgTable(Context ctx, String orgTempTable, CountingTaskInfo billInfo) throws BOSException, EASBizException {
        String storageOrgID = null;
        if (billInfo.getStorageOrgUnit() != null && billInfo.getStorageOrgUnit().getId() != null) {
            storageOrgID = billInfo.getStorageOrgUnit().getId().toString();
        }
        if (storageOrgID == null) {
            return;
        }
        Date dateEnd = billInfo.getCountingOverBizDate();
        String endDate = IMRptUtils.getFilterBeginDate(dateEnd);
        String orgSql = "insert into " + orgTempTable + "(fid,fbegindate,fenddate,fbeginyear,fbeginperiod) values('" + storageOrgID + "',to_date('1999-01-01'),to_date('" + endDate + "'),1999,1)";
        try {
            com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)orgSql);
        }
        catch (Exception e) {
            throw new BOSException();
        }
    }

    private void updateStorageOrgBeingDate(Context ctx, String orgTempTable, CountingTaskInfo billInfo) throws BOSException, EASBizException {
        String periodTypeId;
        Date dateFrom = billInfo.getCountingOverBizDate();
        PeriodInfo periodInfo = IMRptUtils.getPeriodInfo(ctx, dateFrom, periodTypeId = this.getPeriodTypeId(ctx, orgTempTable));
        if (periodInfo == null) {
            return;
        }
        String periodBegin = IMRptUtils.getFilterBeginDate(periodInfo.getBeginDate());
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(orgTempTable).append(" as t set(fid,fbegindate,fbeginyear,fbeginperiod) = (");
        sql.append("select top 1 a.fid,");
        sql.append("case when g.fbegindate >= to_date('").append(periodBegin).append("') then g.fbegindate ");
        sql.append("when h.fbegindate <= to_date('").append(periodBegin).append("') then h.fbegindate ");
        sql.append("else to_date('").append(periodBegin).append("') end as fbegindate,");
        sql.append("case when g.fbegindate >= to_date('").append(periodBegin).append("') then g.fperiodyear ");
        sql.append("when h.fbegindate <= to_date('").append(periodBegin).append("') then h.fperiodyear ");
        sql.append("else ").append(periodInfo.getPeriodYear()).append(" end as fbeginyear,");
        sql.append("case when g.fbegindate >= to_date('").append(periodBegin).append("') then g.fperiodnumber ");
        sql.append("when h.fbegindate <= to_date('").append(periodBegin).append("') then h.fperiodnumber ");
        sql.append("else ").append(periodInfo.getPeriodNumber()).append(" end as fbeginperiod ");
        sql.append("from ").append(orgTempTable).append(" a ");
        sql.append("inner join T_ORG_UnitRelation b  on a.fid = b.ffromunitid ");
        sql.append("inner join T_ORG_TypeRelation c  on b.FTypeRelationID = c.FID ");
        sql.append("inner join t_org_company d on  b.ftounitid = d.fid ");
        sql.append("inner join T_BD_SystemStatusCtrol e on e.FCompanyID = d.fid ");
        sql.append("inner join T_BD_SystemStatus f on e.FSystemStatusID = f.fid ");
        sql.append("inner join t_bd_period g on e.fstartperiodid = g.fid ");
        sql.append("inner join t_bd_period h on e.fcurrentperiodid = h.fid ");
        sql.append("where  ");
        sql.append("c.FFromType = ").append(4).append(" ");
        sql.append("and c.FToType = ").append(1).append(" ");
        sql.append("and f.fname = ").append(2).append(" ");
        sql.append("and t.fid = a.fid )");
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected HashMap getParam(Context ctx, String storageOrgId) throws BOSException, EASBizException {
        String companyID = this.getCompanyOrgID(ctx, storageOrgId);
        boolean isBaseUpdate = this.isBaseUnitUpdate(ctx, storageOrgId);
        boolean isArUpdate = this.isUpdateByARBILL(ctx, companyID);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put(IS_BASEUNIT_UPDATE, isBaseUpdate);
        params.put(IS_AR_UPDATE, isArUpdate);
        return params;
    }

    private boolean isBaseUnitUpdate(Context ctx, String storageOrgId) throws BOSException, EASBizException {
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        String isBaseUpdate = ipc.getParamValue((IObjectPK)new ObjectUuidPK(storageOrgId), PARAM_ISBASEUNITUPDATE);
        if (isBaseUpdate != null) {
            return isBaseUpdate.trim().equals("true");
        }
        return false;
    }

    private boolean isUpdateByARBILL(Context ctx, String strCompanyID) throws BOSException, EASBizException {
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        String isUpdateByARBILL = ipc.getParamValue((IObjectPK)new ObjectUuidPK(strCompanyID), PARAM_ISARUPDATE);
        if (isUpdateByARBILL != null) {
            return isUpdateByARBILL.trim().equals("true");
        }
        return false;
    }

    private String getPeriodTypeId(Context ctx, String orgTempTable) throws BOSException {
        String result = null;
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct d.FAccountPeriodID from " + orgTempTable + " a ").append(" inner join T_ORG_UnitRelation b  on a.fid = b.ffromunitid").append(" inner join T_ORG_TypeRelation c  on b.FTypeRelationID = c.FID").append(" inner join t_org_company d on  b.ftounitid = d.fid ").append(" where c.FFromType = ").append(4).append(" and c.FToType = ").append(1);
        try {
            rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                result = rs.getString("FAccountPeriodID");
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return result;
    }

    private boolean creatCountTable(Context ctx, IObjectPK pk, CountingTaskInfo billInfo, String sql) throws BOSException, EASBizException {
        String tmpTableName;
        ResultSet rs;
        Statement stmt;
        PreparedStatement preStmt;
        Connection conn;
        block24: {
            conn = null;
            preStmt = null;
            PreparedStatement preInsSeqStmt = null;
            stmt = null;
            rs = null;
            tmpTableName = null;
            String seqnoTableName = null;
            try {
                tmpTableName = this.getTempTableName(ctx, "Counting temp Table");
                seqnoTableName = this.getTempTableName(ctx, "seqno temp Table");
                tmpTableName = KsqlUtil.createTempTable((Context)ctx, (String)this.getCreatTempTableSql(tmpTableName));
                seqnoTableName = KsqlUtil.createTempTable((Context)ctx, (String)this.getSeqnoTempTableSql(tmpTableName));
                StringBuffer sb = new StringBuffer();
                sb.append("INSERT INTO ");
                sb.append(tmpTableName);
                sb.append(" (FID,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FLocationID,FLocationNumber, FStoreTypeID");
                if (billInfo.getStorageTypes() != null && billInfo.getStorageTypes().trim().length() != 0) {
                    sb.append(" ,FStoreTypeNumber");
                }
                sb.append(" ,FStoreStatusID ");
                if (billInfo.getStoreStatus() != null && billInfo.getStoreStatus().trim().length() != 0) {
                    sb.append(" ,FStoreStatusNumber");
                }
                sb.append(" ,FLot,FSupplierID,FCustomerID,FMaterialID,");
                sb.append("FUnitID,FCurStoreQty,FAssistUnitID,FCurStoreAssistQty,FBaseQty,");
                sb.append("FAmount,FControlUnitID,FBaseUnitID,FWarehouseNumber,FMaterialNumber,FAssistPropertyID,");
                sb.append("FWarehouseName,FMaterialModel,FMaterialName,FInvUnitID, FInvAccountQty");
                sb.append(",FProjectID,FTrackNumberID,FMfg,FExp ");
                for (int i = 0; i < this.extendFields.size(); ++i) {
                    sb.append(",").append(this.extendFields.get(i));
                }
                sb.append(") ");
                sb.append(sql);
                conn = EJBFactory.getConnection((Context)ctx);
                preStmt = conn.prepareStatement(sb.toString());
                preStmt.executeUpdate();
                preInsSeqStmt = conn.prepareStatement(" insert into " + seqnoTableName + " values (?,?) ");
                StringBuffer strBuff = new StringBuffer();
                strBuff.append("SELECT newbosid('CF0E4015') AS NewFID,FWarehouseID,FMaterialID,FLocationID,");
                strBuff.append("FStoreTypeID,FAssistPropertyID,FLot,FUnitID,FAssistUnitID,FBaseUnitID,FID,");
                strBuff.append("FCurStoreQty,FCurStoreAssistQty,FBaseQty,FStoreStatusID,FCustomerID,FSupplierID,FInvUnitID, FInvAccountQty");
                strBuff.append(",FProjectID,FTrackNumberID ,fmfg,fexp");
                for (int i = 0; i < this.extendFields.size(); ++i) {
                    strBuff.append(",").append(this.extendFields.get(i));
                }
                strBuff.append(" From ");
                strBuff.append(tmpTableName);
                String orderby = " FWarehouseNumber,FLocationID,FMaterialNumber ";
                this.sort = this.replaceSortProperties(this.getCountingSort(ctx, pk));
                if (this.sort == null || this.sort.length() <= 0) {
                    strBuff.append(" ORDER BY ").append(orderby);
                } else {
                    strBuff.append(" ORDER BY FWarehouseNumber,").append(this.sort);
                }
                stmt = conn.createStatement();
                rs = stmt.executeQuery(strBuff.toString());
                AbstractList warehouseList = new ArrayList();
                if (billInfo.isIsGenCountingTableForZero()) {
                    RowSet warehouseRs = this.getWarehouseSet(ctx, billInfo);
                    warehouseList = new LinkedList();
                    while (warehouseRs.next()) {
                        warehouseList.add(warehouseRs.getString("FWarehouseId"));
                    }
                }
                String strWarehouseID = "";
                int i = 0;
                int pageNo = 0;
                CountingTableInfo ctInfo = null;
                ICountingTable iCountingTable = CountingTableFactory.getLocalInstance(ctx);
                pk = null;
                boolean bHaveNext = rs.next();
                if (!bHaveNext && warehouseList.size() == 0) {
                    throw new CountingException(CountingException.NOINVENTORYFIND);
                }
                if (bHaveNext) {
                    strWarehouseID = rs.getString("FWarehouseID");
                    warehouseList.remove(strWarehouseID);
                    ctInfo = this.createCountTableInfo(billInfo, pageNo, strWarehouseID);
                    ++pageNo;
                    pk = iCountingTable.submit((CoreBaseInfo)ctInfo);
                } else {
                    bHaveNext = false;
                }
                int j = 0;
                HashMap<String, String> idMap = new HashMap<String, String>();
                StringBuffer strSql = new StringBuffer();
                StringBuffer strNewInsert = new StringBuffer();
                strNewInsert.append("INSERT INTO T_IM_CountingTableEntry (");
                strNewInsert.append("FID,FSEQ,FParentID,FMaterialID,FLocationID,FStoreTypeID,");
                strNewInsert.append("FAssistPropertyID,FLot,FUnitID,FAccountQty,FCountingQty,");
                strNewInsert.append("FZeroFlag,FDifferQty,FAssistUnitID,FAcctAssistQty,FCountingAssistQty,");
                strNewInsert.append("FDiffAssistQty,FBaseUnit,FInventoryID,FBaseQty,FStoreStatusID,FCustomerID,FSupplierID, FInvUnitID, FInvAccountQty  ");
                strNewInsert.append(",FProjectID,FTrackNumberID ,fmfg,fexp");
                for (int index = 0; index < this.extendFields.size(); ++index) {
                    strNewInsert.append(",").append(this.extendFields.get(index));
                }
                strNewInsert.append(")");
                while (bHaveNext) {
                    if (rs.getString("FWarehouseID").compareTo(strWarehouseID) != 0) {
                        preInsSeqStmt.executeBatch();
                        preInsSeqStmt.clearBatch();
                        this.createNewTableSQL(ctx, pk, tmpTableName, strNewInsert.toString(), strSql, orderby, SCMUtils.getSqlFromHashSet(idMap.keySet()), seqnoTableName);
                        idMap = new HashMap();
                        strWarehouseID = rs.getString("FWarehouseID");
                        warehouseList.remove(strWarehouseID);
                        ctInfo = this.createCountTableInfo(billInfo, pageNo, strWarehouseID);
                        ++pageNo;
                        pk = iCountingTable.submit((CoreBaseInfo)ctInfo);
                        i = 0;
                    }
                    if (i >= this.getEntriesNum()) {
                        preInsSeqStmt.executeBatch();
                        preInsSeqStmt.clearBatch();
                        this.createNewTableSQL(ctx, pk, tmpTableName, strNewInsert.toString(), strSql, orderby, SCMUtils.getSqlFromHashSet(idMap.keySet()), seqnoTableName);
                        idMap = new HashMap();
                        strWarehouseID = rs.getString("FWarehouseID");
                        warehouseList.remove(strWarehouseID);
                        ctInfo = this.createCountTableInfo(billInfo, pageNo, strWarehouseID);
                        ++pageNo;
                        pk = iCountingTable.submit((CoreBaseInfo)ctInfo);
                        i = 0;
                    }
                    idMap.put(rs.getString("FID"), rs.getString("FID"));
                    preInsSeqStmt.setString(1, rs.getString("FID"));
                    preInsSeqStmt.setInt(2, i);
                    preInsSeqStmt.addBatch();
                    ++i;
                    bHaveNext = rs.next();
                    ++j;
                }
                if (idMap.size() > 0) {
                    preInsSeqStmt.executeBatch();
                    this.createNewTableSQL(ctx, pk, tmpTableName, strNewInsert.toString(), strSql, orderby, SCMUtils.getSqlFromHashSet(idMap.keySet()), seqnoTableName);
                }
                if (strSql.length() > 0) {
                    KsqlUtil.executeBatch((Context)ctx, (String[])strSql.toString().split(";"));
                }
                if (warehouseList.size() <= 0 || !billInfo.isIsGenCountingTableForZero()) break block24;
                CountingTableInfo countingInfo = null;
                CoreBaseCollection coll = new CoreBaseCollection();
                for (int k = 0; k < warehouseList.size(); ++k) {
                    countingInfo = this.createCountTableInfo(billInfo, pageNo++, (String)warehouseList.get(k));
                    coll.add((CoreBaseInfo)countingInfo);
                }
                iCountingTable.addnewBatchData(coll);
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, preStmt, conn);
                    SQLUtils.cleanup(stmt);
                    if (tmpTableName != null) {
                        KsqlUtil.releaseTempTable((Context)ctx, (String)tmpTableName);
                    }
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)preStmt, (Connection)conn);
        SQLUtils.cleanup((Statement)stmt);
        if (tmpTableName != null) {
            KsqlUtil.releaseTempTable((Context)ctx, (String)tmpTableName);
        }
        return true;
    }

    protected String getSeqnoTempTableSql(String strTableName) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb = sb.append("Create Table ");
        sb = sb.append(strTableName);
        sb = sb.append(" (FID VARCHAR(44) NOT NULL , ");
        sb = sb.append(" FSeqno INT DEFAULT 0 )");
        return sb.toString();
    }

    private void createNewTableSQL(Context ctx, IObjectPK pk, String tmpTableName, String strNewInsert, StringBuffer strSql, String orderBy, String ids, String seqnoTableName) {
        strSql.append(strNewInsert);
        strSql.append("select newbosid('CF0E4015'),");
        strSql.append("seqnoTable.FSeqno,");
        strSql.append("'").append(pk.toString()).append("',");
        strSql.append("FMaterialID,");
        strSql.append("FLocationID,");
        strSql.append("FStoreTypeID,");
        strSql.append("FAssistPropertyID,");
        strSql.append("FLot,");
        strSql.append("FUnitID,");
        strSql.append("FCurStoreQty,");
        strSql.append("0,");
        strSql.append("0,");
        strSql.append("0,");
        strSql.append("FAssistUnitID,");
        strSql.append("FCurStoreAssistQty,");
        strSql.append("0,");
        strSql.append("0,");
        strSql.append("FBaseUnitID,");
        strSql.append("tmpTable.FID,");
        strSql.append("0,");
        strSql.append("FStoreStatusID,");
        strSql.append("FCustomerID,");
        strSql.append("FSupplierID,");
        strSql.append("FInvUnitID, FInvAccountQty ");
        strSql.append(",FProjectID,FTrackNumberID,fmfg,fexp\t");
        for (int index = 0; index < this.extendFields.size(); ++index) {
            strSql.append(",").append(this.extendFields.get(index));
        }
        strSql.append(" from ");
        strSql.append(tmpTableName).append(" tmpTable inner join ").append(seqnoTableName).append(" seqnoTable  ");
        strSql.append(" on tmpTable.fid = seqnoTable.fid ");
        strSql.append(" WHERE tmpTable.FID IN (");
        strSql.append(ids);
        strSql.append(") ");
        if (this.sort == null || this.sort.length() <= 0) {
            strSql.append(" ORDER BY ").append(orderBy);
        } else {
            strSql.append(" ORDER BY FWarehouseNumber,").append(this.sort);
        }
        strSql.append(";");
    }

    protected void dropTable(Context ctx, String tableName) throws BOSException {
        if (tableName == null) {
            return;
        }
        ITableManagerFacade manager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        manager.releaseTableName(tableName);
    }

    protected String getTempTableName(Context ctx, String desc) throws BOSException {
        return TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName(desc);
    }

    protected String getCreatTempTableSql(String strTableName) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb = sb.append("Create Table ");
        sb = sb.append(strTableName);
        sb = sb.append(" (FID VARCHAR(44) NOT NULL , ");
        sb = sb.append("FCompanyOrgUnitID VARCHAR(44), ");
        sb = sb.append("FStorageOrgUnitID VARCHAR(44), ");
        sb = sb.append("FWarehouseID VARCHAR(44), ");
        sb = sb.append("FLocationID VARCHAR(44), ");
        sb = sb.append("FLocationNumber NVARCHAR(80), ");
        sb = sb.append("FStoreTypeID VARCHAR(44), ");
        sb = sb.append("FStoreTypeNumber NVARCHAR(80), ");
        sb = sb.append("FStoreStatusID VARCHAR(44), ");
        sb = sb.append("FStoreStatusNumber NVARCHAR(80), ");
        sb = sb.append("FLot NVARCHAR(80), ");
        sb = sb.append("FSupplierID VARCHAR(44), ");
        sb = sb.append("FCustomerID VARCHAR(44), ");
        sb = sb.append("FMaterialID VARCHAR(44), ");
        sb = sb.append("FUnitID VARCHAR(44), ");
        sb = sb.append("FCurStoreQty NUMERIC(28,10) DEFAULT 0, ");
        sb = sb.append("FAssistUnitID VARCHAR(44), ");
        sb = sb.append("FCurStoreAssistQty NUMERIC(28,10), ");
        sb = sb.append("FBaseQty NUMERIC(28,10) DEFAULT 0, ");
        sb = sb.append("FAmount NUMERIC(28,10) DEFAULT 0, ");
        sb = sb.append("FControlUnitID VARCHAR(44), ");
        sb = sb.append("FBaseUnitID VARCHAR(44), ");
        sb = sb.append("FMfg DateTime, ");
        sb = sb.append("FExp DateTime, ");
        sb = sb.append("FWarehouseNumber NVARCHAR(80), ");
        sb = sb.append("FMaterialNumber NVARCHAR(80), ");
        sb = sb.append("FAssistPropertyID VARCHAR(44), ");
        sb = sb.append("FWarehouseName NVARCHAR(255), ");
        sb = sb.append("FMaterialModel NVARCHAR(255), ");
        sb = sb.append("FMaterialName NVARCHAR(255), ");
        sb = sb.append("FInvUnitID VARCHAR(44), ");
        sb = sb.append("FInvAccountQty NUMERIC(28,10) DEFAULT 0, ");
        sb = sb.append("FProjectID VARCHAR(44), ");
        sb = sb.append("FTrackNumberID VARCHAR(44) ");
        for (int i = 0; i < this.extendFields.size(); ++i) {
            sb.append(",").append(this.extendFields.get(i)).append(" VARCHAR(44) ");
        }
        sb.append(" )");
        return sb.toString();
    }

    protected void creatTempTable(Context ctx, String strTableName) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb = sb.append("Create Table ");
        sb = sb.append(strTableName);
        sb = sb.append(" (FID VARCHAR(44) NOT NULL , ");
        sb = sb.append("FCompanyOrgUnitID VARCHAR(44), ");
        sb = sb.append("FStorageOrgUnitID VARCHAR(44), ");
        sb = sb.append("FWarehouseID VARCHAR(44), ");
        sb = sb.append("FLocationID VARCHAR(44), ");
        sb = sb.append("FStoreTypeID VARCHAR(44), ");
        sb = sb.append("FStoreStatusID VARCHAR(44), ");
        sb = sb.append("FLot NVARCHAR(80), ");
        sb = sb.append("FSupplierID VARCHAR(44), ");
        sb = sb.append("FCustomerID VARCHAR(44), ");
        sb = sb.append("FMaterialID VARCHAR(44), ");
        sb = sb.append("FUnitID VARCHAR(44), ");
        sb = sb.append("FCurStoreQty NUMERIC(28,10) DEFAULT 0, ");
        sb = sb.append("FAssistUnitID VARCHAR(44), ");
        sb = sb.append("FCurStoreAssistQty NUMERIC(28,10), ");
        sb = sb.append("FBaseQty NUMERIC(28,10) DEFAULT 0, ");
        sb = sb.append("FAmount NUMERIC(28,10) DEFAULT 0, ");
        sb = sb.append("FControlUnitID VARCHAR(44), ");
        sb = sb.append("FBaseUnitID VARCHAR(44), ");
        sb = sb.append("FExp DateTime, ");
        sb = sb.append("FWarehouseNumber NVARCHAR(80), ");
        sb = sb.append("FMaterialNumber NVARCHAR(80), ");
        sb = sb.append("FAssistPropertyID VARCHAR(44)) ");
        ITableManagerFacade manager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        manager.createTempTable(sb.toString());
    }

    private void addLocationFilter(LocationCollection cols, StringBuffer sb, CompareType compareType) {
        if (cols != null && cols.size() > 0) {
            if (compareType == CompareType.INCLUDE) {
                sb.append("AND A.FLocationID IN('");
            } else if (compareType == CompareType.NOTINCLUDE) {
                sb.append("AND A.FLocationID NOT IN('");
            }
            int size = cols.size();
            for (int k = 0; k < size; ++k) {
                String sLocationID = cols.get(k).getId().toString();
                sb.append(sLocationID);
                if (k == size - 1) {
                    sb.append("') ");
                    continue;
                }
                sb.append("','");
            }
        }
    }

    private LocationCollection getLocationListbyLocGroup(Context ctx, String numbers) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo info = new FilterItemInfo("locationGroup.number", (Object)numbers, CompareType.INCLUDE);
        filterInfo.getFilterItems().add(info);
        viewInfo.setFilter(filterInfo);
        LocationCollection collection = LocationFactory.getLocalInstance((Context)ctx).getLocationCollection(viewInfo);
        return collection;
    }

    protected CountingTableEntryInfo createCountTableEntiy(Context ctx, InventoryInfo aInventoryInfo) throws BOSException, EASBizException {
        CountingTableEntryInfo info = new CountingTableEntryInfo();
        BigDecimal zero = new BigDecimal("0.00");
        info.setInventoryID(aInventoryInfo.getId().toString());
        info.setLocation(aInventoryInfo.getLocation());
        info.setStoreType(aInventoryInfo.getStoretype());
        info.setMaterial(aInventoryInfo.getMaterial());
        info.setAssistProperty(aInventoryInfo.getAssistProperty());
        info.setLot(aInventoryInfo.getLot());
        info.setUnit(aInventoryInfo.getUnit());
        info.setAccountQty(zero);
        info.setCountingQty(zero);
        info.setZeroFlag(false);
        info.setDifferQty(zero);
        info.setAssistUnit(aInventoryInfo.getAssistUnit());
        info.setAcctAssistQty(zero);
        info.setCountingAssistQty(zero);
        info.setDiffAssistQty(zero);
        info.setBaseUnit(aInventoryInfo.getBaseUnit());
        info.setBaseQty(aInventoryInfo.getBaseQty());
        return info;
    }

    private void checkCountingTempExists(Context ctx) throws BOSException, CountingException {
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 from KSQL_USERTABLES where KSQL_TABNAME ='T_IM_COUNTINGTEMP'");
        try {
            rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (!rs.next()) {
                throw new CountingException(CountingException.COUNTINGTEMP_NOT_EXISTS);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }

    private void deleteCountingTempTask(Context ctx, IObjectPK pk) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM T_IM_COUNTINGTEMP WHERE FCOUNTINGTASKID = '").append(pk.toString()).append("'");
        try {
            com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            throw new BOSException();
        }
    }

    private void insertCountingTempTask(Context ctx, IObjectPK pk) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO T_IM_COUNTINGTEMP                                         ");
        sql.append("  (FID, FCOUNTINGTASKID, FSTORAGEORGUNITID, FWAREHOUSEID, FMATERIALID,");
        sql.append("    FSUPPLIERID,FCUSTOMERID,FSTORETYPEID,FCOUNTINGTIME)\t\t\t\t  ");
        sql.append("  SELECT newbosid('12345678') AS NewFID, countTask.*                  ");
        sql.append("    FROM (SELECT DISTINCT B.FCountingTaskID, B.FSTORAGEORGUNITID,     ");
        sql.append("            B.FWAREHOUSEID, A.FMATERIALID ,A.FSUPPLIERID,             ");
        sql.append("            A.FCUSTOMERID, A.FSTORETYPEID, B.FCOUNTINGBEGINTIME       ");
        sql.append("            FROM T_IM_CountingTableEntry A                            ");
        sql.append("            LEFT OUTER JOIN T_IM_CountingTable B                      ");
        sql.append("              ON A.FParentID = B.FID                                  ");
        sql.append("           WHERE 1=1\t\t\t\t\t\t                          ");
        sql.append("             AND B.FCountingTaskID = '").append(pk.toString()).append("') countTask");
        try {
            com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            throw new BOSException();
        }
    }

    private void updateCountingTempTask(Context ctx, IObjectPK pk) throws BOSException {
        Connection conn = null;
        PreparedStatement prestmtTime = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            Date now = new Date();
            Timestamp nowTimeStamp = new Timestamp(now.getTime());
            nowTimeStamp.setNanos(0);
            prestmtTime = conn.prepareStatement("UPDATE T_IM_COUNTINGTEMP SET FCOUNTINGTIME = ? WHERE FCountingTaskID = ?");
            prestmtTime.setTimestamp(1, nowTimeStamp);
            prestmtTime.setString(2, pk.toString());
            prestmtTime.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(prestmtTime, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)prestmtTime, (Connection)conn);
    }

    protected void lockInventoryRows(Context ctx, IObjectPK pk) throws BOSException {
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append("update t_im_inventory                                ");
        sqlBuff.append("   set FID = FID                                     ");
        sqlBuff.append(" where FID in (SELECT A.FInventoryID                 ");
        sqlBuff.append("                 FROM T_IM_CountingTableEntry A      ");
        sqlBuff.append("                 LEFT OUTER JOIN T_IM_CountingTable B");
        sqlBuff.append("                   ON A.FParentID = B.FID            ");
        sqlBuff.append("                 LEFT OUTER JOIN T_IM_Inventory C    ");
        sqlBuff.append("                   ON A.FInventoryID = C.FID         ");
        sqlBuff.append("                WHERE B.FCountingTaskID = '").append(pk.toString()).append("'");
        sqlBuff.append("                  AND A.FInventoryID IS NOT NULL     ");
        sqlBuff.append("                  AND C.FID IS NOT NULL)             ");
        try {
            com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sqlBuff.toString());
        }
        catch (Exception e) {
            throw new BOSException();
        }
    }

    @Override
    protected void _executeTask(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean IsInventory;
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("taskStatus"));
        sc.add(new SelectorItemInfo("isFreeMaterial"));
        sc.add(new SelectorItemInfo("isInventory"));
        this.checkCountingTempExists(ctx);
        this.deleteCountingTempTask(ctx, pk);
        CountingTaskInfo billInfo = this.getCountingTaskInfo(ctx, pk, sc);
        boolean bl = IsInventory = billInfo.getIsInventory() == 1;
        if (IsInventory) {
            this.getAccountQty(ctx, pk, true);
        }
        billInfo.setTaskStatus(TaskStatusEnum.BEGINCOUNTING);
        Date now = new Date();
        Timestamp nowTimeStamp = new Timestamp(now.getTime());
        nowTimeStamp.setNanos(0);
        billInfo.setCountingBeginTime(nowTimeStamp);
        this.update(ctx, pk, (CoreBaseInfo)billInfo);
        if (billInfo.isIsFreeMaterial()) {
            if (billInfo.getIsInventory() == 1) {
                this.insertCountingTempTask(ctx, pk);
            }
            this.updateCountingTempTask(ctx, pk);
        }
    }

    protected void getAccountQty(Context ctx, IObjectPK pk, boolean isClearCountingQty) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement preStmt = null;
        PreparedStatement prestmtTime = null;
        StringBuffer sqlBuff = new StringBuffer();
        IRowSet rs = null;
        boolean updateFlag = false;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            Date now = new Date();
            Timestamp nowTimeStamp = new Timestamp(now.getTime());
            nowTimeStamp.setNanos(0);
            prestmtTime = conn.prepareStatement("UPDATE T_IM_CountingTable SET FCountingBeginTime = ? WHERE FCountingTaskID = ?");
            prestmtTime.setTimestamp(1, nowTimeStamp);
            prestmtTime.setString(2, pk.toString());
            prestmtTime.executeUpdate();
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("UPDATE T_IM_CountingTableEntry SET FaccountQty = ?  , FAcctAssistQty = ? ,FInvAccountQty = ? , FInvCountingQty = 0");
            if (isClearCountingQty) {
                updateSql.append(", FCountingAssistQty = 0 , FCountingQty = 0 , FDifferQty = ? , FDiffAssistQty = ? ");
            }
            updateSql.append(" WHERE FID = ?");
            preStmt = conn.prepareStatement(updateSql.toString());
            sqlBuff.append("SELECT ");
            sqlBuff.append("decimal(isnull(C.FCurStoreQty,0) + isnull(C.FLockQty,0), 28, 10) as FCurStoreQty, decimal(isnull(C.FCurStoreAssistQty,0) + isnull(C.FLockAssistQty,0), 28, 10) as FCurStoreAssistQty , A.Fid, round(decimal((isnull(C.FBaseQty,0)+isnull(C.FLockBaseQty,0))/MuU.FBaseConvsRate,28,10),MuU.FQtyPrecision) FInvAccountQty  ");
            sqlBuff.append("FROM ");
            sqlBuff.append("T_IM_CountingTableEntry A LEFT OUTER JOIN T_IM_CountingTable B ON A.FParentID = B.FID ");
            sqlBuff.append("LEFT OUTER JOIN T_IM_Inventory C ON A.FInventoryID = C.FID ");
            sqlBuff.append("INNER JOIN T_BD_MaterialInventory MINV ON C.FMaterialID = MINV.FMaterialID AND C.FSTORAGEORGUNITID = MINV.FOrgUnit  ");
            sqlBuff.append("INNER JOIN T_BD_MultiMeasureUnit MuU ON MINV.FMaterialID = MuU.FMaterialID AND MINV.FUnitID = MuU.FMeasureUnitID  ");
            sqlBuff.append("WHERE B.FCountingTaskID = '");
            sqlBuff.append(pk.toString());
            sqlBuff.append("' AND A.FInventoryID IS NOT NULL ");
            String sqlStr = sqlBuff.toString();
            rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            BigDecimal tempA = new BigDecimal("0.00");
            BigDecimal tempB = new BigDecimal("0.00");
            BigDecimal tempOne = new BigDecimal("-1.0");
            BigDecimal zero = new BigDecimal("0.00");
            while (rs.next()) {
                tempA = rs.getBigDecimal(1);
                tempB = rs.getBigDecimal(2);
                preStmt.setBigDecimal(1, tempA);
                preStmt.setBigDecimal(2, tempB);
                preStmt.setBigDecimal(3, rs.getBigDecimal(4));
                if (isClearCountingQty) {
                    preStmt.setBigDecimal(4, zero.compareTo(tempA) == 0 ? zero : tempA.multiply(tempOne));
                    preStmt.setBigDecimal(5, zero.compareTo(tempB) == 0 ? zero : tempB.multiply(tempOne));
                    preStmt.setString(6, rs.getString(3));
                } else {
                    preStmt.setString(4, rs.getString(3));
                }
                preStmt.addBatch();
                updateFlag = true;
            }
            if (updateFlag) {
                preStmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)conn);
                SQLUtils.cleanup(preStmt);
                SQLUtils.cleanup(prestmtTime);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        SQLUtils.cleanup((Statement)preStmt);
        SQLUtils.cleanup((Statement)prestmtTime);
    }

    @Override
    protected IObjectCollection _countDispose(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return this.getCountingTable(ctx, pk);
    }

    @Override
    protected IObjectCollection _viewDifference(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo countingTaskItemInfo = new FilterItemInfo("parent.countingTask", (Object)pk.toString());
        filterInfo.getFilterItems().add(countingTaskItemInfo);
        FilterItemInfo countingQtyItemInfo = new FilterItemInfo("countingQty", (Object)new BigDecimal("0.00"));
        filterInfo.getFilterItems().add(countingQtyItemInfo);
        FilterItemInfo zeroFlagItemInfo = new FilterItemInfo("zeroFlag", (Object)Boolean.FALSE);
        filterInfo.getFilterItems().add(zeroFlagItemInfo);
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        ICountingTableEntry iCountingTableEntry = CountingTableEntryFactory.getLocalInstance(ctx);
        if (iCountingTableEntry.exists(filterInfo)) {
            throw new CountingException(CountingException.NOTVIEWCOUNTDIF);
        }
        return null;
    }

    protected void _countAdjust_old(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CountingTaskInfo billInfo = this.getCountingTaskInfo(ctx, pk);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo countingTaskItemInfo = new FilterItemInfo("countingTask.id", (Object)pk.toString());
        filterInfo.getFilterItems().add(countingTaskItemInfo);
        FilterInfo entryfilterInfo = new FilterInfo();
        FilterItemInfo differQtyItemInfo = new FilterItemInfo("differQty", (Object)new BigDecimal("0.00"), CompareType.NOTEQUALS);
        entryfilterInfo.getFilterItems().add(differQtyItemInfo);
        FilterItemInfo assistantQtyItemInfo = new FilterItemInfo("diffAssistQty", (Object)new BigDecimal("0.00"), CompareType.NOTEQUALS);
        entryfilterInfo.getFilterItems().add(assistantQtyItemInfo);
        entryfilterInfo.setEntryName("entry");
        entryfilterInfo.setMaskString("#1 or #2");
        filterInfo.setEntryilterType(EntryFilterType.NORMAL);
        viewInfo.setFilter(filterInfo);
        viewInfo.getEntryFilters().add(entryfilterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("entry.*"));
        ICountingTable iCountingTable = CountingTableFactory.getLocalInstance(ctx);
        CountingTableCollection coll = iCountingTable.getCountingTableCollection(viewInfo);
        BigDecimal ZERO = new BigDecimal("0.00");
        if (coll != null && coll.size() > 0) {
            OrgUnitCollection orgCol;
            UserInfo aUserInfo = new UserInfo();
            aUserInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
            String storageOrgID = billInfo.getStorageOrgUnit().getId().toString();
            CompanyOrgUnitInfo companyInfo = null;
            String companyID = null;
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            if (storageOrgID != null && storageOrgID.length() > 0 && (companyInfo = (CompanyOrgUnitInfo)(orgCol = iUnitRel.getToUnit(storageOrgID, 4, 1)).get(0)) != null && companyInfo.getId() != null) {
                companyID = companyInfo.getId().toString();
            }
            if (companyID == null) {
                throw new CountingException(CountingException.NOCOMPANYDEFINE);
            }
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (!iCodingRuleManager.isExist((IObjectValue)new OtherInWarehsBillInfo(), companyID)) {
                throw new CountingException(CountingException.NOINWAREHSNUMRUL);
            }
            if (!iCodingRuleManager.isExist((IObjectValue)new OtherIssueBillInfo(), companyID)) {
                throw new CountingException(CountingException.NOISSUENUMRUL);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterState = new FilterInfo();
            filterState.getFilterItems().add(new FilterItemInfo("Scheduled", (Object)true));
            filterState.getFilterItems().add(new FilterItemInfo("number", (Object)"1"));
            view.getSelector().add(new SelectorItemInfo("id"));
            view.setTopCount(1);
            view.setFilter(filterState);
            IStoreState iStoreState = StoreStateFactory.getLocalInstance((Context)ctx);
            StoreStateCollection storeStatecoll = iStoreState.getStoreStateCollection(view);
            if (storeStatecoll == null || storeStatecoll.size() <= 0) {
                throw new CountingException(CountingException.STORESTATUSNOTEXIST, new String[]{"number"});
            }
            Date today = new Date();
            OtherInWarehsBillInfo inWarehsBillInfo = new OtherInWarehsBillInfo();
            inWarehsBillInfo.setTotalStandardCost(ZERO);
            inWarehsBillInfo.setTotalActualCost(ZERO);
            inWarehsBillInfo.setTotalQty(ZERO);
            inWarehsBillInfo.setTotalAmount(ZERO);
            inWarehsBillInfo.setHasEffected(false);
            inWarehsBillInfo.setBizDate(today);
            inWarehsBillInfo.setIsReversed(false);
            inWarehsBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            inWarehsBillInfo.setCreateTime(new Timestamp(today.getTime()));
            inWarehsBillInfo.setCreator(aUserInfo);
            inWarehsBillInfo.setCU(this.getCU(ctx, (ObjectBaseInfo)inWarehsBillInfo));
            inWarehsBillInfo.setStorageOrgUnit(billInfo.getStorageOrgUnit());
            BigDecimal totalInWarehsQty = ZERO;
            BigDecimal totalInWarehsAmt = ZERO;
            OtherInWarehsBillEntryCollection inWarehsEntryColl = inWarehsBillInfo.getEntry();
            OtherIssueBillInfo issueBillInfo = new OtherIssueBillInfo();
            issueBillInfo.setTotalStandardCost(ZERO);
            issueBillInfo.setTotalActualCost(ZERO);
            issueBillInfo.setTotalQty(ZERO);
            issueBillInfo.setTotalAmount(ZERO);
            issueBillInfo.setHasEffected(false);
            issueBillInfo.setIsReversed(false);
            issueBillInfo.setBizDate(today);
            issueBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            issueBillInfo.setCreateTime(new Timestamp(today.getTime()));
            issueBillInfo.setCreator(aUserInfo);
            issueBillInfo.setCU(this.getCU(ctx, (ObjectBaseInfo)issueBillInfo));
            issueBillInfo.setStorageOrgUnit(billInfo.getStorageOrgUnit());
            BigDecimal totalIssueQty = ZERO;
            BigDecimal totalIssueAmt = ZERO;
            OtherIssueBillEntryCollection IssueEntryColl = issueBillInfo.getEntry();
            BigDecimal differQty = ZERO;
            BigDecimal temp = ZERO;
            BigDecimal unitStandardCost = ZERO;
            BigDecimal standardCost = ZERO;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                CountingTableInfo aCountingTableInfo = coll.get(i);
                CountingTableEntryCollection collEntry = aCountingTableInfo.getEntry();
                if (collEntry == null) continue;
                int eSize = collEntry.size();
                for (int j = 0; j < eSize; ++j) {
                    InvBillBaseEntryInfo entryInfo;
                    CountingTableEntryInfo aCountingTableEntryInfo = collEntry.get(j);
                    if (aCountingTableEntryInfo.getDifferQty() != null) {
                        differQty = aCountingTableEntryInfo.getDifferQty();
                    }
                    if (differQty.compareTo(ZERO) > 0) {
                        entryInfo = new OtherInWarehsBillEntryInfo();
                        entryInfo.setMaterial(aCountingTableEntryInfo.getMaterial());
                        entryInfo.setStorageOrgUnit(billInfo.getStorageOrgUnit());
                        entryInfo.setCompanyOrgUnit(companyInfo);
                        entryInfo.setWarehouse(aCountingTableInfo.getWarehouse());
                        entryInfo.setLocation(aCountingTableEntryInfo.getLocation());
                        entryInfo.setStocker(aCountingTableInfo.getCountingPerson());
                        entryInfo.setLot(aCountingTableEntryInfo.getLot());
                        entryInfo.setAssistProperty(aCountingTableEntryInfo.getAssistProperty());
                        entryInfo.setQty(aCountingTableEntryInfo.getDifferQty());
                        totalInWarehsQty = totalInWarehsQty.add(aCountingTableEntryInfo.getDifferQty());
                        entryInfo.setAssistQty(aCountingTableEntryInfo.getDiffAssistQty());
                        entryInfo.setUnit(aCountingTableEntryInfo.getUnit());
                        entryInfo.setBaseUnit(aCountingTableEntryInfo.getBaseUnit());
                        entryInfo.setBaseQty(aCountingTableEntryInfo.getBaseQty());
                        entryInfo.setReverseQty(ZERO);
                        entryInfo.setReturnsQty(ZERO);
                        ((AbstractOtherInWarehsBillEntryInfo)entryInfo).setPrice(ZERO);
                        temp = aCountingTableEntryInfo.getDifferQty().multiply(((AbstractOtherInWarehsBillEntryInfo)entryInfo).getPrice());
                        totalInWarehsAmt = totalInWarehsAmt.add(temp);
                        ((AbstractOtherInWarehsBillEntryInfo)entryInfo).setAmount(temp);
                        entryInfo.setActualCost(ZERO);
                        entryInfo.setUnitActualCost(ZERO);
                        unitStandardCost = this.getUnitStandardCost(ctx, aCountingTableEntryInfo.getUnit(), aCountingTableEntryInfo.getMaterial(), companyInfo);
                        entryInfo.setUnitStandardCost(unitStandardCost);
                        standardCost = unitStandardCost.multiply(entryInfo.getQty());
                        entryInfo.setStandardCost(standardCost);
                        entryInfo.setIsPresent(false);
                        inWarehsEntryColl.add((OtherInWarehsBillEntryInfo)entryInfo);
                        continue;
                    }
                    if (differQty.compareTo(ZERO) >= 0) continue;
                    entryInfo = new OtherIssueBillEntryInfo();
                    entryInfo.setMaterial(aCountingTableEntryInfo.getMaterial());
                    entryInfo.setMaterial(aCountingTableEntryInfo.getMaterial());
                    entryInfo.setStorageOrgUnit(billInfo.getStorageOrgUnit());
                    entryInfo.setCompanyOrgUnit(companyInfo);
                    entryInfo.setWarehouse(aCountingTableInfo.getWarehouse());
                    entryInfo.setLocation(aCountingTableEntryInfo.getLocation());
                    entryInfo.setStocker(aCountingTableInfo.getCountingPerson());
                    entryInfo.setLot(aCountingTableEntryInfo.getLot());
                    entryInfo.setAssistProperty(aCountingTableEntryInfo.getAssistProperty());
                    entryInfo.setQty(aCountingTableEntryInfo.getDifferQty().abs());
                    totalIssueQty = totalIssueQty.add(aCountingTableEntryInfo.getDifferQty().abs());
                    entryInfo.setAssistQty(aCountingTableEntryInfo.getDiffAssistQty().abs());
                    entryInfo.setUnit(aCountingTableEntryInfo.getUnit());
                    entryInfo.setBaseUnit(aCountingTableEntryInfo.getBaseUnit());
                    entryInfo.setBaseQty(aCountingTableEntryInfo.getBaseQty());
                    entryInfo.setReverseQty(ZERO);
                    entryInfo.setReturnsQty(ZERO);
                    ((AbstractOtherIssueBillEntryInfo)entryInfo).setPrice(ZERO);
                    temp = aCountingTableEntryInfo.getDifferQty().abs().multiply(((AbstractOtherIssueBillEntryInfo)entryInfo).getPrice());
                    totalIssueAmt = totalIssueAmt.add(temp);
                    ((AbstractOtherIssueBillEntryInfo)entryInfo).setAmount(temp);
                    entryInfo.setActualCost(ZERO);
                    entryInfo.setUnitActualCost(ZERO);
                    unitStandardCost = this.getUnitStandardCost(ctx, aCountingTableEntryInfo.getUnit(), aCountingTableEntryInfo.getMaterial(), companyInfo);
                    entryInfo.setUnitStandardCost(unitStandardCost);
                    standardCost = unitStandardCost.multiply(entryInfo.getQty());
                    entryInfo.setStandardCost(standardCost);
                    entryInfo.setIsPresent(false);
                    IssueEntryColl.add((OtherIssueBillEntryInfo)entryInfo);
                }
            }
            inWarehsBillInfo.setTotalQty(totalInWarehsQty);
            inWarehsBillInfo.setTotalAmount(totalInWarehsAmt);
            issueBillInfo.setTotalQty(totalInWarehsQty);
            issueBillInfo.setTotalAmount(totalInWarehsAmt);
            if (inWarehsEntryColl.size() > 0) {
                IOtherInWarehsBill iOtherInWarehsBill = OtherInWarehsBillFactory.getLocalInstance(ctx);
                if (!iCodingRuleManager.isUseIntermitNumber((IObjectValue)inWarehsBillInfo, companyID)) {
                    inWarehsBillInfo.setNumber(iCodingRuleManager.getNumber((IObjectValue)inWarehsBillInfo, companyID, ""));
                }
                iOtherInWarehsBill.submit((CoreBaseInfo)inWarehsBillInfo);
            }
            if (IssueEntryColl.size() > 0) {
                IOtherIssueBill iOtherIssueBill = OtherIssueBillFactory.getLocalInstance(ctx);
                if (!iCodingRuleManager.isUseIntermitNumber((IObjectValue)issueBillInfo, companyID)) {
                    issueBillInfo.setNumber(iCodingRuleManager.getNumber((IObjectValue)issueBillInfo, companyID, ""));
                }
                iOtherIssueBill.submit((CoreBaseInfo)issueBillInfo);
            }
        }
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("taskStatus"));
        sc.add(new SelectorItemInfo("isFreeMaterial"));
        CountingTaskInfo bCountingTaskInfo = this.getCountingTaskInfo(ctx, pk, sc);
        bCountingTaskInfo.setTaskStatus(TaskStatusEnum.COMPLETED);
        Date now = new Date();
        Timestamp nowTimeStamp = new Timestamp(now.getTime());
        nowTimeStamp.setNanos(0);
        bCountingTaskInfo.setCountingEndTime(nowTimeStamp);
        this.update(ctx, pk, (CoreBaseInfo)bCountingTaskInfo);
    }

    @Override
    protected Vector _countAdjust(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IRowSet rs;
        Statement prestmtCost;
        PreparedStatement prestmtOut;
        PreparedStatement preStmtIn;
        Statement stmtOut;
        Statement stmtIn;
        Statement stOut;
        Statement stIn;
        Connection conn;
        Vector<InvBillBaseInfo> vResult;
        CountingTaskInfo billInfo;
        block54: {
            billInfo = null;
            BigDecimal ZERO = new BigDecimal("0.00");
            vResult = new Vector<InvBillBaseInfo>(0);
            conn = null;
            stIn = null;
            stOut = null;
            stmtIn = null;
            stmtOut = null;
            preStmtIn = null;
            prestmtOut = null;
            prestmtCost = null;
            rs = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                billInfo = new CountingTaskInfo();
                String countTaskSql = "";
                countTaskSql = "select fid,fstorageorgunitid,fisfreematerial from t_im_countingtask where fid='" + pk.toString() + "'";
                rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)countTaskSql);
                while (rs.next()) {
                    StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
                    sou.setId(BOSUuid.read((String)rs.getString("fstorageorgunitid")));
                    billInfo.setStorageOrgUnit(sou);
                    billInfo.setIsFreeMaterial(rs.getInt("fisfreematerial") == 1);
                }
                String sqlDiff = "";
                sqlDiff = "select count(1) CNT from T_IM_CountingTable a,T_IM_CountingTableEntry b where b.fparentid=a.fid and a.fcountingtaskid='" + pk.toString() + "' and (b.fdifferqty <>0 or b.fdiffAssistQty<>0)";
                boolean hasDiff = false;
                rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlDiff);
                while (rs.next()) {
                    if (rs.getInt("CNT") <= 0) continue;
                    hasDiff = true;
                    break;
                }
                Map mapping = null;
                List extendFieldList = null;
                if (hasDiff) {
                    BigDecimal standardCostCount;
                    BigDecimal standardCost;
                    BigDecimal unitStandardCost;
                    String OtherBostypeID;
                    String taskBostypeID;
                    OrgUnitCollection orgCol;
                    mapping = CountingTableAppHelper.getExtendField4OtherBill(ctx, "A4D04D23", "F56602D6");
                    extendFieldList = (List)mapping.get("extendFieldList");
                    UserInfo aUserInfo = new UserInfo();
                    aUserInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
                    String storageOrgID = billInfo.getStorageOrgUnit().getId().toString();
                    CompanyOrgUnitInfo companyInfo = null;
                    String companyID = null;
                    IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                    if (storageOrgID != null && storageOrgID.length() > 0 && (companyInfo = (CompanyOrgUnitInfo)(orgCol = iUnitRel.getToUnit(storageOrgID, 4, 1)).get(0)) != null && companyInfo.getId() != null) {
                        companyID = companyInfo.getId().toString();
                    }
                    if (companyID == null) {
                        throw new CountingException(CountingException.NOCOMPANYDEFINE);
                    }
                    int precision = 2;
                    ICurrency ic = CurrencyFactory.getLocalInstance((Context)ctx);
                    CurrencyInfo ci = ic.getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyInfo.getBaseCurrency().getId()));
                    precision = ci.getPrecision();
                    ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                    if (!iCodingRuleManager.isExist((IObjectValue)new OtherInWarehsBillInfo(), storageOrgID)) {
                        throw new CountingException(CountingException.NOINWAREHSNUMRUL);
                    }
                    if (!iCodingRuleManager.isExist((IObjectValue)new OtherIssueBillInfo(), storageOrgID)) {
                        throw new CountingException(CountingException.NOISSUENUMRUL);
                    }
                    BigDecimal totalInWarehsQty = ZERO;
                    BigDecimal coefficient = new BigDecimal("1.00");
                    StringBuffer sqlBuff = new StringBuffer();
                    HashSet<String> idSet = new HashSet<String>();
                    idSet.add("50957179-0105-1000-e004-4152c0a812fd463ED552");
                    idSet.add("50957179-0105-1000-e000-017bc0a812fd463ED552");
                    idSet.add("50957179-0105-1000-e000-0177c0a812fd463ED552");
                    BillTypeCollection col = this.getBillTypeCollection(ctx, idSet);
                    Date today = new Date();
                    String tableSql = "T_IM_CountingTableEntry B LEFT OUTER JOIN T_IM_CountingTable A ON B.FParentID = A.FID ";
                    StringBuffer tableSqlAll = new StringBuffer();
                    tableSqlAll.append(tableSql);
                    tableSqlAll.append("LEFT OUTER JOIN T_BD_MaterialCompanyInfo C ON  C.FMaterialID = B.FMaterialID and C.FCompanyID = '");
                    tableSqlAll.append(companyID);
                    tableSqlAll.append("' ");
                    tableSqlAll.append("INNER JOIN T_BD_MultiMeasureUnit D ON  D.FMaterialID = B.FMaterialID and D.FMeasureUnitID = B.FUnitID ");
                    tableSqlAll.append("INNER JOIN T_BD_Material F ON  F.FID = B.FMaterialID ");
                    tableSqlAll.append("LEFT JOIN T_IM_DateOfMinDurability E ON E.FStorageOrgUnitID = A.FStorageOrgUnitID and E.FMaterialID = B.FMaterialID and E.FLot = B.FLot ");
                    String inWhereSql = " WHERE A.FCountingTaskID='" + pk.toString() + "' and (B.FDifferQty>0 or B.fdiffAssistQty>0) ";
                    String outWhereSql = " WHERE A.FCountingTaskID='" + pk.toString() + "' and (B.FDifferQty<0 or B.fdiffAssistQty<0) ";
                    sqlBuff.append("SELECT 1 as totalInWarehsQty from ");
                    sqlBuff.append(tableSql);
                    sqlBuff.append(inWhereSql);
                    rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
                    boolean hasData = false;
                    boolean isFirst = true;
                    if (rs.next()) {
                        hasData = true;
                    }
                    if (hasData) {
                        int i;
                        OtherInWarehsBillInfo inWarehsBillInfo = new OtherInWarehsBillInfo();
                        inWarehsBillInfo.setTotalStandardCost(ZERO);
                        inWarehsBillInfo.setTotalActualCost(ZERO);
                        inWarehsBillInfo.setTotalQty(ZERO);
                        inWarehsBillInfo.setTotalAmount(ZERO);
                        inWarehsBillInfo.setHasEffected(false);
                        inWarehsBillInfo.setBizDate(today);
                        inWarehsBillInfo.setIsReversed(false);
                        inWarehsBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                        inWarehsBillInfo.setBotpCallSave(false);
                        inWarehsBillInfo.setCreateTime(new Timestamp(today.getTime()));
                        inWarehsBillInfo.setCreator(aUserInfo);
                        BizTypeInfo inBizType = new BizTypeInfo();
                        inBizType.setId(BOSUuid.read((String)"Nz878AEgEADgAABGwKg/GiQHQ1w="));
                        inWarehsBillInfo.setBizType(inBizType);
                        inWarehsBillInfo.setCU(this.getCU(ctx, (ObjectBaseInfo)inWarehsBillInfo));
                        inWarehsBillInfo.setStorageOrgUnit(billInfo.getStorageOrgUnit());
                        inWarehsBillInfo.setSourceBillType(this.getBillTypeInfoFromCol(col, "50957179-0105-1000-e004-4152c0a812fd463ED552"));
                        inWarehsBillInfo.setBillType(this.getBillTypeInfoFromCol(col, "50957179-0105-1000-e000-017bc0a812fd463ED552"));
                        inWarehsBillInfo.setSourceBillId(pk.toString());
                        inWarehsBillInfo.setTotalQty(totalInWarehsQty);
                        inWarehsBillInfo.setTotalAmount(ZERO);
                        IOtherInWarehsBill iOtherInWarehsBill = OtherInWarehsBillFactory.getLocalInstance(ctx);
                        taskBostypeID = billInfo.getBOSType().toString();
                        OtherBostypeID = inWarehsBillInfo.getBOSType().toString();
                        unitStandardCost = ZERO;
                        standardCost = ZERO;
                        standardCostCount = ZERO;
                        sqlBuff = new StringBuffer();
                        sqlBuff.append("INSERT INTO T_IM_OtherInWarehsBillEntry (FID,FSeq,FMaterialID,FStorageOrgUnitID,FCompanyOrgUnitID,");
                        sqlBuff.append("FWarehouseID,FLocationID,FStockerID,FLot,FAssistPropertyID, ");
                        sqlBuff.append("FQty,FAssistQty,FUnitID,FBaseUnitID,FBaseQty,");
                        sqlBuff.append("FUnitStandardCost,FStandardCost,FIsPresent,FParentID,FAssistUnitID,");
                        sqlBuff.append("FSourceBillID,FAssociateQty,FMfg,FExp,FCustomerID,FSupplierID,FPrice,FActualCost,FUnitActualCost,FRemark,FBizDate ");
                        sqlBuff.append(",FSourceBillEntryID,FSourceBillTypeID ");
                        sqlBuff.append(",FProjectID,FTrackNumberID, FInvUpdateTypeID ");
                        for (i = 0; i < extendFieldList.size(); ++i) {
                            sqlBuff.append(",").append((String)extendFieldList.get(i));
                        }
                        sqlBuff.append(") ");
                        sqlBuff.append("VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? ");
                        for (i = 0; i < extendFieldList.size(); ++i) {
                            sqlBuff.append(",?");
                        }
                        sqlBuff.append(") ");
                        preStmtIn = conn.prepareStatement(sqlBuff.toString());
                        sqlBuff = new StringBuffer();
                        sqlBuff.append("SELECT ");
                        sqlBuff.append("newbosid('F56602D6') AS NewFID,B.FMaterialID,A.FWarehouseID,B.FLocationID,");
                        sqlBuff.append("A.FCountingPersonID,B.FLot,B.FAssistPropertyID,");
                        sqlBuff.append("(case when B.FDifferQty > 0 then B.FDifferQty else 0 end) FDifferQty,");
                        sqlBuff.append("(case when B.FDiffAssistQty > 0 then B.FDiffAssistQty else 0 end) FDiffAssistQty,");
                        sqlBuff.append("B.FUnitID,B.FBaseUnit,");
                        sqlBuff.append("(case when B.FDifferQty > 0 then B.FBaseQty else 0 end) FBaseQty,");
                        sqlBuff.append("B.FStoreTypeID,B.FAssistUnitID,C.FStandardCost,");
                        sqlBuff.append("D.FBaseConvsRate,F.FPricePrecision,B.FStoreStatusID,B.FCustomerID,B.FSupplierID,B.FRemark ");
                        sqlBuff.append(",case when B.FMfg is null then E.FMfg else B.FMfg end as FMfg,case when B.FExp is null then E.FExp else B.FExp end as FExp");
                        sqlBuff.append(" ,B.FID AS FSourceBillEntryID, '").append("50957179-0105-1000-e004-4152c0a812fd463ED552").append("' AS FSourceBillTypeID ");
                        sqlBuff.append(",B.FProjectID,B.FTrackNumberID ");
                        for (i = 0; i < extendFieldList.size(); ++i) {
                            sqlBuff.append(",").append(mapping.get(extendFieldList.get(i)));
                        }
                        sqlBuff.append(" From ");
                        sqlBuff.append(tableSqlAll.toString());
                        sqlBuff.append(inWhereSql);
                        sqlBuff.append(" order by B.FStoreTypeID ");
                        rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
                        StringBuffer maid = new StringBuffer();
                        int n = 0;
                        while (rs.next()) {
                            if (n > 0) {
                                maid.append(",");
                            }
                            maid.append(rs.getString("FMaterialID"));
                            ++n;
                        }
                        EntityViewInfo view = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("mateial.id"));
                        sic.add(new SelectorItemInfo("mateial.number"));
                        sic.add(new SelectorItemInfo("mateial.name"));
                        sic.add(new SelectorItemInfo("company.id"));
                        sic.add(new SelectorItemInfo("accountType"));
                        sic.add(new SelectorItemInfo("status"));
                        filter.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)maid.toString(), CompareType.INCLUDE));
                        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID));
                        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
                        view.setSelector(sic);
                        view.setFilter(filter);
                        IMaterialCompanyInfo imcom = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx);
                        MaterialCompanyInfoCollection macomcoll = imcom.getMaterialCompanyInfoCollection(view);
                        HashMap<String, MaterialCompanyInfoInfo> map = new HashMap<String, MaterialCompanyInfoInfo>();
                        MaterialCompanyInfoInfo macom = null;
                        int size = macomcoll.size();
                        for (int i2 = 0; i2 < size; ++i2) {
                            macom = macomcoll.get(i2);
                            if (macom == null || macom.getMateial() == null || macom.getMateial().getId() == null) continue;
                            map.put(macom.getMateial().getId().toString(), macom);
                        }
                        if (rs.isAfterLast()) {
                            rs.beforeFirst();
                        }
                        BigDecimal tempA = new BigDecimal("0.00");
                        int i3 = 0;
                        IObjectPK otherInWarehsPk = null;
                        MaterialCompanyInfoInfo mcominfo = null;
                        while (rs.next()) {
                            InvUpdateTypeInfo invUpdateType;
                            TransactionTypeInfo transactionType;
                            String transactionTypeID = null;
                            if (inWarehsBillInfo.getTransactionType() != null) {
                                transactionTypeID = inWarehsBillInfo.getTransactionType().getId().toString();
                            }
                            if (null == transactionTypeID && (transactionType = this.getTransaction(ctx, "50957179-0105-1000-e000-017bc0a812fd463ED552", "Nz878AEgEADgAABGwKg/GiQHQ1w=")) != null) {
                                transactionTypeID = transactionType.getId().toString();
                            }
                            String aStoreTypeID = rs.getString("FStoreTypeID");
                            String aStoreStateID = rs.getString("FStoreStatusID");
                            SelectorItemCollection selector = new SelectorItemCollection();
                            selector.add(new SelectorItemInfo("id"));
                            selector.add(new SelectorItemInfo("number"));
                            selector.add(new SelectorItemInfo("name"));
                            StoreTypeInfo storeType = StoreTypeFactory.getLocalInstance((Context)ctx).getStoreTypeInfo((IObjectPK)new ObjectUuidPK(aStoreTypeID), selector);
                            String aStoreTypeName = "";
                            if (storeType != null) {
                                aStoreTypeName = storeType.getName();
                            }
                            StoreStateInfo storeState = StoreStateFactory.getLocalInstance((Context)ctx).getStoreStateInfo((IObjectPK)new ObjectUuidPK(aStoreStateID), selector);
                            String aStoreStateName = "";
                            if (storeState != null) {
                                aStoreStateName = storeState.getName();
                            }
                            if ((invUpdateType = this.getInvUpdateType(ctx, aStoreTypeID, aStoreStateID, false)) == null) {
                                throw new InvBizException(InvBizException.IN_INVUPDATETYPE_ISNOT_EXIST, new String[]{aStoreTypeName, aStoreStateName});
                            }
                            if (i3 >= this.getEntriesNum() || isFirst) {
                                OtherInWarehsBillInfo newInWarehsBillInfo = (OtherInWarehsBillInfo)inWarehsBillInfo.clone();
                                newInWarehsBillInfo.setTransactionType(this.getTransaction(ctx, "50957179-0105-1000-e000-017bc0a812fd463ED552", "Nz878AEgEADgAABGwKg/GiQHQ1w="));
                                otherInWarehsPk = iOtherInWarehsBill.save((CoreBaseInfo)newInWarehsBillInfo);
                                SCMServerUtils.traceUpAndDown((Context)ctx, (String)pk.toString(), (String)otherInWarehsPk.toString(), (String)taskBostypeID, (String)OtherBostypeID);
                                vResult.add(newInWarehsBillInfo);
                                i3 = 0;
                                isFirst = false;
                            }
                            preStmtIn.setString(1, rs.getString("NewFID"));
                            preStmtIn.setInt(2, ++i3);
                            preStmtIn.setString(3, rs.getString("FMaterialID"));
                            preStmtIn.setString(4, storageOrgID);
                            preStmtIn.setString(5, companyID);
                            preStmtIn.setString(6, rs.getString("FWarehouseID"));
                            preStmtIn.setString(7, rs.getString("FLocationID"));
                            preStmtIn.setString(8, rs.getString("FCountingPersonID"));
                            preStmtIn.setString(9, rs.getString("FLot"));
                            preStmtIn.setString(10, rs.getString("FAssistPropertyID"));
                            tempA = rs.getBigDecimal("FDifferQty");
                            preStmtIn.setBigDecimal(11, tempA);
                            preStmtIn.setBigDecimal(12, rs.getBigDecimal("FDiffAssistQty"));
                            preStmtIn.setString(13, rs.getString("FUnitID"));
                            preStmtIn.setString(14, rs.getString("FBaseUnit"));
                            preStmtIn.setBigDecimal(15, rs.getBigDecimal("FBaseQty"));
                            coefficient = new BigDecimal("1.00");
                            BigDecimal baseConvsRate = rs.getBigDecimal("FBaseConvsRate");
                            if (baseConvsRate != null) {
                                coefficient = baseConvsRate;
                            }
                            unitStandardCost = ZERO;
                            BigDecimal thisStandardCost = rs.getBigDecimal("FStandardCost");
                            if (thisStandardCost != null) {
                                unitStandardCost = thisStandardCost;
                            }
                            int pricePrecision = rs.getInt("FPricePrecision");
                            unitStandardCost = unitStandardCost.multiply(coefficient);
                            unitStandardCost = unitStandardCost.setScale(pricePrecision, 4);
                            preStmtIn.setBigDecimal(16, unitStandardCost);
                            standardCost = unitStandardCost.multiply(tempA);
                            standardCost = standardCost.setScale(precision, 4);
                            standardCostCount = standardCostCount.add(standardCost);
                            preStmtIn.setBigDecimal(17, standardCost);
                            preStmtIn.setBoolean(18, false);
                            preStmtIn.setString(19, otherInWarehsPk.toString());
                            preStmtIn.setString(20, rs.getString("FAssistUnitID"));
                            preStmtIn.setString(21, pk.toString());
                            preStmtIn.setBigDecimal(22, ZERO);
                            preStmtIn.setDate(23, rs.getDate("FMfg"));
                            preStmtIn.setDate(24, rs.getDate("FExp"));
                            preStmtIn.setString(25, rs.getString("FCustomerID"));
                            preStmtIn.setString(26, rs.getString("FSupplierID"));
                            BigDecimal unitActualCost = CalculateUtil.ZERO;
                            BigDecimal actualCost = CalculateUtil.ZERO;
                            BigDecimal price = CalculateUtil.ZERO;
                            if (map.containsKey(rs.getString("FMaterialID"))) {
                                mcominfo = (MaterialCompanyInfoInfo)map.get(rs.getString("FMaterialID"));
                            }
                            if (mcominfo != null && AccountType.MOVE_ADD_AVERAGE.equals((Object)mcominfo.getAccountType())) {
                                RecentCostInfo recentCostInfo = RecentCostHelp.getMaterialRecentCost((Context)ctx, (BigDecimal)tempA, (BigDecimal)rs.getBigDecimal("FBaseQty"), (CalculateKindEnum)CalculateKindEnum.INPUT_WAREHOUSE, (String)rs.getString("FMaterialID"), (String)companyID, (String)storageOrgID, (String)rs.getString("FWarehouseID"));
                                if (recentCostInfo != null && recentCostInfo.getBigDecimal("FUnitActualCost") != null && recentCostInfo.getBigDecimal("FUnitActualCost").compareTo(CalculateUtil.ZERO) > 0) {
                                    unitActualCost = recentCostInfo.getBigDecimal("FUnitActualCost");
                                    price = recentCostInfo.getPrice();
                                } else {
                                    unitActualCost = this.getUnitActualCostFromPurin(conn, today, storageOrgID, rs.getString("FMaterialID"));
                                }
                            }
                            if (price == null || price.toString().trim().length() == 0) {
                                price = CalculateUtil.ZERO;
                            }
                            preStmtIn.setBigDecimal(27, price);
                            if (unitActualCost == null || unitActualCost.toString().trim().length() == 0) {
                                unitActualCost = CalculateUtil.ZERO;
                            }
                            actualCost = unitActualCost.multiply(tempA).setScale(precision, 4);
                            preStmtIn.setBigDecimal(28, actualCost);
                            preStmtIn.setBigDecimal(29, unitActualCost);
                            preStmtIn.setString(30, rs.getString("FRemark"));
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            preStmtIn.setDate(31, java.sql.Date.valueOf(sdf.format(today)));
                            preStmtIn.setString(32, rs.getString("FSourceBillEntryID"));
                            preStmtIn.setString(33, rs.getString("FSourceBillTypeID"));
                            preStmtIn.setString(34, rs.getString("FProjectID"));
                            preStmtIn.setString(35, rs.getString("FTrackNumberID"));
                            preStmtIn.setString(36, invUpdateType.getId().toString());
                            Object obj = null;
                            for (int index = 0; index < extendFieldList.size(); ++index) {
                                obj = rs.getObject(mapping.get(extendFieldList.get(index)).toString());
                                preStmtIn.setObject(37 + index, obj);
                            }
                            preStmtIn.addBatch();
                        }
                        if (i3 > 0) {
                            preStmtIn.executeBatch();
                        }
                    }
                    sqlBuff = new StringBuffer();
                    sqlBuff.append("SELECT 1 from ");
                    sqlBuff.append(tableSql);
                    sqlBuff.append(outWhereSql);
                    rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
                    hasData = false;
                    if (rs.next()) {
                        hasData = true;
                    }
                    if (hasData) {
                        int i;
                        mapping = CountingTableAppHelper.getExtendField4OtherBill(ctx, "A4D04D24", "F56602D7");
                        extendFieldList = (List)mapping.get("extendFieldList");
                        OtherIssueBillInfo issueBillInfo = new OtherIssueBillInfo();
                        issueBillInfo.setTotalStandardCost(ZERO);
                        issueBillInfo.setTotalActualCost(ZERO);
                        issueBillInfo.setTotalQty(ZERO);
                        issueBillInfo.setTotalAmount(ZERO);
                        issueBillInfo.setHasEffected(false);
                        issueBillInfo.setIsReversed(false);
                        issueBillInfo.setBizDate(today);
                        issueBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                        issueBillInfo.setBotpCallSave(false);
                        issueBillInfo.setCreateTime(new Timestamp(today.getTime()));
                        issueBillInfo.setCreator(aUserInfo);
                        BizTypeInfo issueBizType = new BizTypeInfo();
                        issueBizType.setId(BOSUuid.read((String)"N5d2igEgEADgAAB0wKg/GiQHQ1w="));
                        issueBillInfo.setBizType(issueBizType);
                        issueBillInfo.setCU(this.getCU(ctx, (ObjectBaseInfo)issueBillInfo));
                        issueBillInfo.setStorageOrgUnit(billInfo.getStorageOrgUnit());
                        issueBillInfo.setSourceBillType(this.getBillTypeInfoFromCol(col, "50957179-0105-1000-e004-4152c0a812fd463ED552"));
                        issueBillInfo.setBillType(this.getBillTypeInfoFromCol(col, "50957179-0105-1000-e000-0177c0a812fd463ED552"));
                        issueBillInfo.setSourceBillId(pk.toString());
                        issueBillInfo.setTotalQty(totalInWarehsQty);
                        issueBillInfo.setTotalAmount(ZERO);
                        IOtherIssueBill iOtherIssueBill = OtherIssueBillFactory.getLocalInstance(ctx);
                        taskBostypeID = billInfo.getBOSType().toString();
                        OtherBostypeID = issueBillInfo.getBOSType().toString();
                        unitStandardCost = ZERO;
                        standardCost = ZERO;
                        standardCostCount = ZERO;
                        sqlBuff = new StringBuffer();
                        sqlBuff.append("INSERT INTO T_IM_OtherIssueBillEntry (FID,FSeq,FMaterialID,FStorageOrgUnitID,FCompanyOrgUnitID,");
                        sqlBuff.append("FWarehouseID,FLocationID,FStockerID,FLot,FAssistPropertyID, ");
                        sqlBuff.append("FQty,FAssistQty,FUnitID,FBaseUnitID,FBaseQty,");
                        sqlBuff.append("FUnitStandardCost,FStandardCost,FIsPresent,FParentID,FAssistUnitID,");
                        sqlBuff.append("FSourceBillID,FAssociateQty,FMfg,FExp,FCustomerID,FSupplierID,FRemark,FBizDate ");
                        sqlBuff.append(",FSourceBillEntryID,FSourceBillTypeID ");
                        sqlBuff.append(",FProjectID,FTrackNumberID, FInvUpdateTypeID ");
                        for (i = 0; i < extendFieldList.size(); ++i) {
                            sqlBuff.append(",").append((String)extendFieldList.get(i));
                        }
                        sqlBuff.append(")");
                        sqlBuff.append("VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? ");
                        for (i = 0; i < extendFieldList.size(); ++i) {
                            sqlBuff.append(",?");
                        }
                        sqlBuff.append(")");
                        prestmtOut = conn.prepareStatement(sqlBuff.toString());
                        sqlBuff = new StringBuffer();
                        sqlBuff.append("SELECT ");
                        sqlBuff.append("newbosid('F56602D7') AS NewFID,");
                        sqlBuff.append("B.FMaterialID,A.FWarehouseID,B.FLocationID,A.FCountingPersonID,B.FLot,");
                        sqlBuff.append("B.FAssistPropertyID,");
                        sqlBuff.append("(case when B.FDifferQty < 0 then B.FDifferQty else 0 end) FDifferQty,");
                        sqlBuff.append("(case when B.FDiffAssistQty < 0 then B.FDiffAssistQty else 0 end) FDiffAssistQty,");
                        sqlBuff.append("B.FUnitID,B.FBaseUnit,");
                        sqlBuff.append("(case when B.FDifferQty < 0 then B.FBaseQty else 0 end) FBaseQty,");
                        sqlBuff.append("B.FStoreTypeID,B.FAssistUnitID,C.FStandardCost,D.FBaseConvsRate,");
                        sqlBuff.append("F.FPricePrecision,B.FStoreStatusID,B.FCustomerID,B.FSupplierID,B.FRemark ");
                        sqlBuff.append(",case when B.FMfg is null then E.FMfg else B.FMfg end as FMfg,case when B.FExp is null then E.FExp else B.FExp end as FExp");
                        sqlBuff.append(" ,B.FID AS FSourceBillEntryID, '").append("50957179-0105-1000-e004-4152c0a812fd463ED552").append("' AS FSourceBillTypeID ");
                        sqlBuff.append(",B.FProjectID,B.FTrackNumberID ");
                        for (i = 0; i < extendFieldList.size(); ++i) {
                            sqlBuff.append(",").append(mapping.get(extendFieldList.get(i)));
                        }
                        sqlBuff.append(" From ");
                        sqlBuff.append(tableSqlAll);
                        sqlBuff.append(outWhereSql);
                        sqlBuff.append(" order by B.FStoreTypeID ");
                        rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
                        BigDecimal tempA = new BigDecimal("0.00");
                        BigDecimal tempB = new BigDecimal("0.00");
                        int i4 = 0;
                        IObjectPK otherIssuePk = null;
                        isFirst = true;
                        while (rs.next()) {
                            InvUpdateTypeInfo invUpdateType;
                            TransactionTypeInfo transactionType;
                            String transactionTypeID = null;
                            if (issueBillInfo.getTransactionType() != null) {
                                transactionTypeID = issueBillInfo.getTransactionType().getId().toString();
                            }
                            if (null == transactionTypeID && (transactionType = this.getTransaction(ctx, "50957179-0105-1000-e000-0177c0a812fd463ED552", "N5d2igEgEADgAAB0wKg/GiQHQ1w=")) != null) {
                                transactionTypeID = transactionType.getId().toString();
                            }
                            String aStoreTypeID = rs.getString("FStoreTypeID");
                            String aStoreStateID = rs.getString("FStoreStatusID");
                            SelectorItemCollection selector = new SelectorItemCollection();
                            selector.add(new SelectorItemInfo("id"));
                            selector.add(new SelectorItemInfo("number"));
                            selector.add(new SelectorItemInfo("name"));
                            StoreTypeInfo storeType = StoreTypeFactory.getLocalInstance((Context)ctx).getStoreTypeInfo((IObjectPK)new ObjectUuidPK(aStoreTypeID), selector);
                            String aStoreTypeName = "";
                            if (storeType != null) {
                                aStoreTypeName = storeType.getName();
                            }
                            StoreStateInfo storeState = StoreStateFactory.getLocalInstance((Context)ctx).getStoreStateInfo((IObjectPK)new ObjectUuidPK(aStoreStateID), selector);
                            String aStoreStateName = "";
                            if (storeState != null) {
                                aStoreStateName = storeState.getName();
                            }
                            if ((invUpdateType = this.getInvUpdateType(ctx, aStoreTypeID, aStoreStateID, true)) == null) {
                                throw new InvBizException(InvBizException.ISSUE_INVUPDATETYPE_ISNOT_EXIST, new String[]{aStoreTypeName, aStoreStateName});
                            }
                            if (i4 >= this.getEntriesNum() || isFirst) {
                                OtherIssueBillInfo newIssueBillInfo = (OtherIssueBillInfo)issueBillInfo.clone();
                                newIssueBillInfo.setTransactionType(this.getTransaction(ctx, "50957179-0105-1000-e000-0177c0a812fd463ED552", "N5d2igEgEADgAAB0wKg/GiQHQ1w="));
                                otherIssuePk = iOtherIssueBill.save((CoreBaseInfo)newIssueBillInfo);
                                SCMServerUtils.traceUpAndDown((Context)ctx, (String)pk.toString(), (String)otherIssuePk.toString(), (String)taskBostypeID, (String)OtherBostypeID);
                                vResult.add(newIssueBillInfo);
                                i4 = 0;
                                isFirst = false;
                            }
                            prestmtOut.setString(1, rs.getString("NewFID"));
                            prestmtOut.setInt(2, ++i4);
                            prestmtOut.setString(3, rs.getString("FMaterialID"));
                            prestmtOut.setString(4, storageOrgID);
                            prestmtOut.setString(5, companyID);
                            prestmtOut.setString(6, rs.getString("FWarehouseID"));
                            prestmtOut.setString(7, rs.getString("FLocationID"));
                            prestmtOut.setString(8, rs.getString("FCountingPersonID"));
                            prestmtOut.setString(9, rs.getString("FLot"));
                            prestmtOut.setString(10, rs.getString("FAssistPropertyID"));
                            tempA = rs.getBigDecimal("FDifferQty");
                            tempA = tempA.abs();
                            prestmtOut.setBigDecimal(11, tempA);
                            tempB = rs.getBigDecimal("FDiffAssistQty");
                            tempB = tempB.abs();
                            prestmtOut.setBigDecimal(12, tempB);
                            prestmtOut.setString(13, rs.getString("FUnitID"));
                            prestmtOut.setString(14, rs.getString("FBaseUnit"));
                            prestmtOut.setBigDecimal(15, rs.getBigDecimal("FBaseQty"));
                            coefficient = new BigDecimal("1.00");
                            BigDecimal baseConvsRate = rs.getBigDecimal("FBaseConvsRate");
                            if (baseConvsRate != null) {
                                coefficient = baseConvsRate;
                            }
                            unitStandardCost = ZERO;
                            BigDecimal thisStandardCost = rs.getBigDecimal("FStandardCost");
                            if (thisStandardCost != null) {
                                unitStandardCost = thisStandardCost;
                            }
                            unitStandardCost = unitStandardCost.multiply(coefficient);
                            int pricePrecision = rs.getInt("FPricePrecision");
                            unitStandardCost = unitStandardCost.setScale(pricePrecision, 4);
                            prestmtOut.setBigDecimal(16, unitStandardCost);
                            standardCost = unitStandardCost.multiply(tempA);
                            standardCost = standardCost.setScale(precision, 4);
                            standardCostCount = standardCostCount.add(standardCost);
                            prestmtOut.setBigDecimal(17, standardCost);
                            prestmtOut.setBoolean(18, false);
                            prestmtOut.setString(19, otherIssuePk.toString());
                            prestmtOut.setString(20, rs.getString("FAssistUnitID"));
                            prestmtOut.setString(21, pk.toString());
                            prestmtOut.setBigDecimal(22, ZERO);
                            prestmtOut.setDate(23, rs.getDate("FMfg"));
                            prestmtOut.setDate(24, rs.getDate("FExp"));
                            prestmtOut.setString(25, rs.getString("FCustomerID"));
                            prestmtOut.setString(26, rs.getString("FSupplierID"));
                            prestmtOut.setString(27, rs.getString("FRemark"));
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            prestmtOut.setDate(28, java.sql.Date.valueOf(sdf.format(today)));
                            prestmtOut.setString(29, rs.getString("FSourceBillEntryID"));
                            prestmtOut.setString(30, rs.getString("FSourceBillTypeID"));
                            prestmtOut.setString(31, rs.getString("FProjectID"));
                            prestmtOut.setString(32, rs.getString("FTrackNumberID"));
                            prestmtOut.setString(33, invUpdateType.getId().toString());
                            Object obj = null;
                            for (int index = 0; index < extendFieldList.size(); ++index) {
                                obj = rs.getObject(mapping.get(extendFieldList.get(index)).toString());
                                prestmtOut.setObject(34 + index, obj);
                            }
                            prestmtOut.addBatch();
                        }
                        if (i4 > 0) {
                            prestmtOut.executeBatch();
                        }
                    }
                    String updateCountingTask = "";
                    updateCountingTask = "update T_IM_COUNTINGTASK  set ftaskstatus=?, fcountingendtime=?,flastupdateuserid=?,flastupdatetime=? where fid=?";
                    prestmtOut = conn.prepareStatement(updateCountingTask);
                    prestmtOut.setInt(1, TaskStatusEnum.COMPLETED.getValue());
                    prestmtOut.setTimestamp(2, new Timestamp(new Date().getTime()));
                    prestmtOut.setString(3, ctx.getCaller().toString());
                    prestmtOut.setTimestamp(4, new Timestamp(new Date().getTime()));
                    prestmtOut.setString(5, pk.toString());
                    prestmtOut.addBatch();
                    prestmtOut.executeBatch();
                    break block54;
                }
                String updateCountingTask = "";
                updateCountingTask = "update T_IM_COUNTINGTASK  set ftaskstatus=?, fcountingendtime=?,flastupdateuserid=?,flastupdatetime=? where fid=?";
                prestmtOut = conn.prepareStatement(updateCountingTask);
                prestmtOut.setInt(1, TaskStatusEnum.COMPLETED.getValue());
                prestmtOut.setTimestamp(2, new Timestamp(new Date().getTime()));
                prestmtOut.setString(3, ctx.getCaller().toString());
                prestmtOut.setTimestamp(4, new Timestamp(new Date().getTime()));
                prestmtOut.setString(5, pk.toString());
                prestmtOut.addBatch();
                prestmtOut.executeBatch();
            }
            catch (SQLException ex) {
                try {
                    Logger.error((Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmtIn, (Connection)conn);
                    SQLUtils.cleanup(stIn);
                    SQLUtils.cleanup(stOut);
                    SQLUtils.cleanup(stmtOut);
                    SQLUtils.cleanup(preStmtIn);
                    SQLUtils.cleanup(prestmtOut);
                    SQLUtils.cleanup(prestmtCost);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, stmtIn, (Connection)conn);
        SQLUtils.cleanup(stIn);
        SQLUtils.cleanup(stOut);
        SQLUtils.cleanup(stmtOut);
        SQLUtils.cleanup(preStmtIn);
        SQLUtils.cleanup((Statement)prestmtOut);
        SQLUtils.cleanup(prestmtCost);
        if (billInfo.isIsFreeMaterial()) {
            this.lockInventoryRows(ctx, pk);
            this.changeInventoryStatus(ctx, pk, false);
        }
        this.deleteCountingTempTask(ctx, pk);
        return vResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getUnitActualCostFromPurin(Connection conn, Date bizDate, String storageOrgID, String material) throws SQLException {
        BigDecimal bigDecimal;
        PreparedStatement preStmtIn = null;
        ResultSet rs = null;
        BigDecimal unitactualcost = new BigDecimal("0.00");
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT max(isnull(entry.funitactualcost,0)) as funitactualcost           ");
            sql.append("  From T_Im_PurinwarehsEntry entry,                                      ");
            sql.append("       T_Im_Purinwarehsbill bill,                                        ");
            sql.append("       T_SCM_TransactionType transtype                                   ");
            sql.append(" Where entry.fparentid = bill.fid                                        ");
            sql.append("   and bill.ftransactiontypeid = transtype.fid                           ");
            sql.append("   and transtype.fexistingqty = 1                                        ");
            sql.append("   and bill.fbasestatus = 4                                              ");
            sql.append("   and bill.fisreversed = 0                                              ");
            sql.append("   and bill.fbizdate =                                                   ");
            sql.append("       (SELECT max(bill.fbizdate)                                        ");
            sql.append("          From T_Im_PurinwarehsEntry entry,  T_Im_PurinwarehsBill bill, T_SCM_TransactionType transtype");
            sql.append("         Where entry.fparentid = bill.fid and bill.ftransactiontypeid = transtype.fid                  ");
            sql.append("           and transtype.fexistingqty = 1                                ");
            sql.append("           and bill.fisreversed = 0                                      ");
            sql.append("           and bill.fbasestatus = 4                                      ");
            sql.append("           and bill.fbizdate < ? and isnull(entry.fstorageorgunitid,'X') = isnull(?,'X') and entry.fmaterialid = ? )  ");
            sql.append("   and isnull(entry.fstorageorgunitid,'X') = isnull(?,'X') \t\t\t\t ");
            sql.append("   and entry.fmaterialid = ?             \t\t\t\t\t\t\t\t ");
            preStmtIn = conn.prepareStatement(sql.toString());
            preStmtIn.setDate(1, new java.sql.Date(bizDate.getTime()));
            preStmtIn.setString(2, storageOrgID);
            preStmtIn.setString(3, material);
            preStmtIn.setString(4, storageOrgID);
            preStmtIn.setString(5, material);
            rs = preStmtIn.executeQuery();
            if (rs.next()) {
                unitactualcost = rs.getBigDecimal("funitactualcost");
            }
            bigDecimal = unitactualcost;
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs);
            SQLUtils.cleanup(preStmtIn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)preStmtIn);
        return bigDecimal;
    }

    protected CountingTableCollection getCountingTable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CountingTableCollection coll = new CountingTableCollection();
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT FID  FROM  t_im_countingtable where FCOUNTINGTASKID  =  '" + pk.toString() + "' ");
        sb.append(" order by FPAGENO ");
        IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                String id = rs.getString("fid");
                CountingTableInfo info = new CountingTableInfo();
                info.setId(BOSUuid.read((String)id));
                coll.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return coll;
    }

    protected void changeInventoryStatus(Context ctx, IObjectPK pk, boolean lock) throws BOSException, EASBizException {
        String strLock = "181875d5-2105-1000-e000-013dc0a812fd62A73FA5";
        Connection conn = null;
        PreparedStatement preStmt = null;
        StringBuffer sqlBuff = new StringBuffer();
        IRowSet rs = null;
        boolean updateFlag = false;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append(" UPDATE T_IM_Inventory SET FStoreStatusID = ?,FLastUpdateTime = ? ");
            sql.append("  WHERE 1=1 ");
            sql.append("    AND FID = ? ");
            preStmt = conn.prepareStatement(sql.toString());
            sqlBuff.append("SELECT ");
            sqlBuff.append("A.FInventoryID,A.FStoreStatusID ");
            sqlBuff.append("FROM ");
            sqlBuff.append("T_IM_CountingTableEntry A LEFT OUTER JOIN T_IM_CountingTable B ON A.FParentID = B.FID ");
            sqlBuff.append("LEFT OUTER JOIN T_IM_Inventory C ON A.FInventoryID = C.FID ");
            sqlBuff.append("WHERE B.FCountingTaskID = '");
            sqlBuff.append(pk.toString());
            sqlBuff.append("' AND A.FInventoryID IS NOT NULL ");
            sqlBuff.append("  AND  C.FID IS NOT NULL ");
            String sqlStr = sqlBuff.toString();
            rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            HashSet<String> ids = new HashSet<String>();
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            while (rs.next()) {
                if (lock) {
                    preStmt.setString(1, strLock);
                } else {
                    preStmt.setString(1, rs.getString(2));
                }
                ids.add(rs.getString(1));
                preStmt.setTimestamp(2, timestamp);
                preStmt.setString(3, rs.getString(1));
                preStmt.addBatch();
                updateFlag = true;
            }
            if (updateFlag) {
                preStmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)conn);
                SQLUtils.cleanup(preStmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        SQLUtils.cleanup((Statement)preStmt);
    }

    private EntityViewInfo getSameInvEntityViewInfo(String invid, InventoryInfo inventoryInfo) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)invid, CompareType.NOTEQUALS));
        if (inventoryInfo.getStorageOrgUnit() != null) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit", (Object)inventoryInfo.getStorageOrgUnit().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit", null, CompareType.EQUALS));
        }
        if (inventoryInfo.getCompanyOrgUnit() != null) {
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit", (Object)inventoryInfo.getCompanyOrgUnit().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit", null, CompareType.EQUALS));
        }
        if (inventoryInfo.getWarehouse() != null) {
            filter.getFilterItems().add(new FilterItemInfo("warehouse", (Object)inventoryInfo.getWarehouse().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("warehouse", (Object)"EgkAAABc3XG76fiu", CompareType.EQUALS));
        }
        if (inventoryInfo.getMaterial() != null) {
            filter.getFilterItems().add(new FilterItemInfo("material", (Object)inventoryInfo.getMaterial().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("material", null, CompareType.EQUALS));
        }
        if (inventoryInfo.getLocation() != null) {
            filter.getFilterItems().add(new FilterItemInfo("location", (Object)inventoryInfo.getLocation().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("location", (Object)"EgkAAABc3XMgX/hq", CompareType.EQUALS));
        }
        if (inventoryInfo.getStoretype() != null) {
            filter.getFilterItems().add(new FilterItemInfo("storetype", (Object)inventoryInfo.getStoretype().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("storetype", null, CompareType.EQUALS));
        }
        if (inventoryInfo.getStorestatus() != null) {
            filter.getFilterItems().add(new FilterItemInfo("storestatus", (Object)inventoryInfo.getStorestatus().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("storestatus", null, CompareType.EQUALS));
        }
        if (inventoryInfo.getSupplier() != null) {
            filter.getFilterItems().add(new FilterItemInfo("supplier", (Object)inventoryInfo.getSupplier().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("supplier", (Object)"EgkAAABc3Xo3xn38", CompareType.EQUALS));
        }
        if (inventoryInfo.getCustomer() != null) {
            filter.getFilterItems().add(new FilterItemInfo("customer", (Object)inventoryInfo.getCustomer().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("customer", (Object)"EgkAAABc3Xu/DAQO", CompareType.EQUALS));
        }
        if (inventoryInfo.getLot() != null) {
            filter.getFilterItems().add(new FilterItemInfo("lot", (Object)inventoryInfo.getLot()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("lot", (Object)"YNi0IQEOEADgBT3mfwAAAcznrtQ=", CompareType.EQUALS));
        }
        if (inventoryInfo.getUnit() != null) {
            filter.getFilterItems().add(new FilterItemInfo("unit", (Object)inventoryInfo.getUnit().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("unit", null, CompareType.EQUALS));
        }
        if (inventoryInfo.getBaseUnit() != null) {
            filter.getFilterItems().add(new FilterItemInfo("baseUnit", (Object)inventoryInfo.getBaseUnit().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("baseUnit", null, CompareType.EQUALS));
        }
        if (inventoryInfo.getAssistUnit() != null) {
            filter.getFilterItems().add(new FilterItemInfo("assistUnit", (Object)inventoryInfo.getAssistUnit().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("assistUnit", (Object)"EgkAAAA5EWFbglxX", CompareType.EQUALS));
        }
        if (inventoryInfo.getAssistProperty() != null) {
            filter.getFilterItems().add(new FilterItemInfo("assistProperty", (Object)inventoryInfo.getAssistProperty().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("assistProperty", (Object)"EgkAAAA5EWALxvQu", CompareType.EQUALS));
        }
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        return ev;
    }

    public String getStatusID(Context ctx, String number) throws BOSException, EASBizException {
        String id = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterState = new FilterInfo();
        filterState.getFilterItems().add(new FilterItemInfo("Scheduled", (Object)true));
        filterState.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filterState);
        StoreStateCollection storeStatecoll = StoreStateFactory.getLocalInstance((Context)ctx).getStoreStateCollection(view);
        if (storeStatecoll != null && storeStatecoll.size() > 0) {
            StoreStateInfo aStoreStateInfo = storeStatecoll.get(0);
            id = aStoreStateInfo.getId().toString();
        }
        if (id == null) {
            throw new CountingException(CountingException.STORESTATUSNOTEXIST, new String[]{"number"});
        }
        return id;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CountingTaskInfo billInfo = (CountingTaskInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)billInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (billInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)billInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (billInfo.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)billInfo.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        int n = filter.getFilterItems().size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return super._exists(ctx, filter);
    }

    protected boolean isRuleAutoNumber(Context ctx, CountingTaskInfo billInfo, String strCompanyID) throws EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (strCompanyID == null || strCompanyID.trim().length() == 0) {
            strCompanyID = this.getCompanyID(ctx, (IObjectValue)billInfo);
        }
        return iCodingRuleManager.isExist((IObjectValue)billInfo, strCompanyID);
    }

    protected boolean isModifiable(Context ctx, CountingTaskInfo billInfo, String strCompanyID) throws EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (strCompanyID == null || strCompanyID.trim().length() == 0) {
            strCompanyID = this.getCompanyID(ctx, (IObjectValue)billInfo);
        }
        return iCodingRuleManager.isModifiable((IObjectValue)billInfo, strCompanyID);
    }

    protected CountingTaskInfo _getNewNumber(Context ctx, IObjectValue model, String strCompanyID, String customString) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CountingTaskInfo billInfo = (CountingTaskInfo)model;
        if (strCompanyID == null || strCompanyID.trim().length() == 0) {
            strCompanyID = this.getCompanyID(ctx, model);
        }
        String number = "";
        number = iCodingRuleManager.getNumber((IObjectValue)billInfo, strCompanyID, customString);
        billInfo.setNumber(number);
        ObjectUuidPK pk = new ObjectUuidPK(billInfo.getId());
        if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)billInfo)) {
            String newNumber = "";
            newNumber = iCodingRuleManager.getNumber((IObjectValue)billInfo, strCompanyID, customString);
            if (newNumber.equals(billInfo.getNumber())) {
                throw new SCMBillException(SCMBillException.NUMBERRULEERROR);
            }
            billInfo.setNumber(newNumber);
            if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)billInfo)) {
                return this._getNewNumber(ctx, (IObjectValue)billInfo, strCompanyID, customString);
            }
        }
        return billInfo;
    }

    protected boolean rolbackNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String strCompanyID;
        CountingTaskInfo billInfo = (CountingTaskInfo)model;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)billInfo, strCompanyID = this.getCompanyID(ctx, model)) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)billInfo, strCompanyID)) {
            return iCodingRuleManager.recycleNumber((IObjectValue)billInfo, strCompanyID, billInfo.getNumber());
        }
        return false;
    }

    private void addListWarehouseFilter(CountingListWarehouseCollection wareHouseColl, StringBuffer sb, CompareType compareType) {
        if (wareHouseColl != null && wareHouseColl.size() > 0) {
            ArrayList<String> warehouseList = new ArrayList<String>();
            int size = wareHouseColl.size();
            for (int k = 0; k < size; ++k) {
                CountingListWarehouseInfo cLWwareHouseInfo = wareHouseColl.get(k);
                if (cLWwareHouseInfo == null || cLWwareHouseInfo.getWarehouse() == null) continue;
                warehouseList.add(cLWwareHouseInfo.getWarehouse().getId().toString());
            }
            StringBuffer params = new StringBuffer();
            int c = warehouseList.size();
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    params.append(",");
                }
                params.append("'");
                params.append(warehouseList.get(i).toString());
                params.append("'");
            }
            if (params.length() > 0) {
                if (compareType == CompareType.INCLUDE) {
                    sb.append("AND A.FWarehouseID IN (").append(params.toString()).append(") ");
                } else if (compareType == CompareType.NOTINCLUDE) {
                    sb.append("AND A.FWarehouseID NOT IN (").append(params.toString()).append(") ");
                }
            }
        }
    }

    private void addWarehouseFilter(Vector vecwareHouse, StringBuffer sb, CompareType compareType) {
        if (vecwareHouse != null && vecwareHouse.size() > 0) {
            if (compareType == CompareType.INCLUDE) {
                sb.append("AND A.FWarehouseID IN('");
            } else if (compareType == CompareType.NOTINCLUDE) {
                sb.append("AND A.FWarehouseID NOT IN('");
            }
            int size = vecwareHouse.size();
            for (int k = 0; k < size; ++k) {
                String sWarehouseID = (String)vecwareHouse.get(k);
                sb.append(sWarehouseID);
                if (k == size - 1) {
                    sb.append("') ");
                    continue;
                }
                sb.append("','");
            }
        }
    }

    private void addListLocationFilter(CountingListLocationCollection locationColl, StringBuffer sb, CompareType compareType) {
        if (locationColl != null && locationColl.size() > 0) {
            ArrayList<String> locationList = new ArrayList<String>();
            int size = locationColl.size();
            for (int k = 0; k < size; ++k) {
                CountingListLocationInfo cLLocationInfo = locationColl.get(k);
                if (cLLocationInfo == null || cLLocationInfo.getLocation() == null) continue;
                locationList.add(cLLocationInfo.getLocation().getId().toString());
            }
            StringBuffer params = new StringBuffer();
            int c = locationList.size();
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    params.append(",");
                }
                params.append("'");
                params.append(locationList.get(i).toString());
                params.append("'");
            }
            if (compareType == CompareType.INCLUDE) {
                if (params.length() > 0) {
                    sb.append("AND ( A.FLocationID IN (").append(params.toString()).append(") ");
                    sb.append(" or A.FLocationID = '").append("EgkAAABc3XMgX/hq").append("' )");
                } else {
                    sb.append("AND A.FLocationID = '").append("EgkAAABc3XMgX/hq").append("' )");
                }
            } else if (compareType == CompareType.NOTINCLUDE && params.length() > 0) {
                sb.append("AND A.FLocationID NOT IN (").append(params.toString()).append(") ");
            }
        }
    }

    private void addListMaterialFilter(CountingListMaterialCollection materialColl, StringBuffer sb, CompareType compareType) {
        if (materialColl != null && materialColl.size() > 0) {
            ArrayList<String> materialList = new ArrayList<String>();
            int size = materialColl.size();
            for (int k = 0; k < size; ++k) {
                CountingListMaterialInfo cLMaterialInfo = materialColl.get(k);
                if (cLMaterialInfo == null || cLMaterialInfo.getMaterial() == null) continue;
                materialList.add(cLMaterialInfo.getMaterial().getId().toString());
            }
            StringBuffer params = new StringBuffer();
            int c = materialList.size();
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    params.append(",");
                }
                params.append("'");
                params.append(materialList.get(i).toString());
                params.append("'");
            }
            if (params.length() > 0) {
                if (compareType == CompareType.INCLUDE) {
                    sb.append("AND A.FMaterialID IN (").append(params.toString()).append(") ");
                } else if (compareType == CompareType.NOTINCLUDE) {
                    sb.append("AND A.FMaterialID NOT IN (").append(params.toString()).append(") ");
                }
            }
        }
    }

    private TransactionTypeInfo getTransaction(Context ctx, String billTypeID, String bizTypeID) throws EASBizException, BOSException {
        TransactionTypeCollection tic = TransactionTypeFactory.getLocalInstance((Context)ctx).getCollection(billTypeID, bizTypeID);
        TransactionTypeInfo transaction = tic.get(0);
        for (int i = 0; i < tic.size(); ++i) {
            if (UseStatusEnum.ACTIVE != tic.get(i).getStatus() || !tic.get(i).isScheduled()) continue;
            return tic.get(i);
        }
        return transaction;
    }

    private InvUpdateTypeInfo getInvUpdateType(Context ctx, String storeTypeID, String storeStateID, boolean isIssue) throws BOSException {
        FilterInfo filter = new FilterInfo();
        if (isIssue) {
            filter.getFilterItems().add(new FilterItemInfo("storeStatePre", (Object)storeStateID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("storeTypePre", (Object)storeTypeID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("existingQty", (Object)new Integer(0), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("storeState", (Object)storeStateID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("storeType", (Object)storeTypeID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("existingQtyPre", (Object)new Integer(0), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("isNotUpdateInv", (Object)new Integer(0), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        InvUpdateTypeCollection invCol = InvUpdateTypeFactory.getLocalInstance((Context)ctx).getInvUpdateTypeCollection(view);
        InvUpdateTypeInfo invUpdateInfo = invCol.get(0);
        int size = invCol.size();
        for (int i = 0; i < size; ++i) {
            if (!invCol.get(i).isScheduled()) continue;
            return invCol.get(i);
        }
        return invUpdateInfo;
    }

    private BillTypeCollection getBillTypeCollection(Context ctx, Set idSet) throws EASBizException, BOSException {
        BillTypeCollection col = null;
        IBillType itt = BillTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE);
        filterInfo.getFilterItems().add(filterItemInfo);
        view.setFilter(filterInfo);
        col = itt.getBillTypeCollection(view);
        return col;
    }

    private BillTypeInfo getBillTypeInfoFromCol(BillTypeCollection col, String id) {
        BillTypeInfo info = null;
        if (col != null && col.size() > 0) {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                info = col.get(i);
                if (!info.getId().toString().equals(id)) continue;
                return info;
            }
        }
        return null;
    }

    private BigDecimal getUnitStandardCost(Context ctx, MeasureUnitInfo mui, MaterialInfo aMaterialInfo, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        BigDecimal standardCost;
        BigDecimal unitStandardCost = standardCost = new BigDecimal("0.00");
        if (aMaterialInfo == null || aMaterialInfo.getId() == null || companyInfo == null || companyInfo.getId() == null) {
            return standardCost;
        }
        MaterialCompanyInfoInfo mcInfo = MaterialFactory.getLocalInstance((Context)ctx).getCompanyInfo(aMaterialInfo.getId().toString(), companyInfo.getId().toString());
        if (mcInfo == null) {
            return standardCost;
        }
        if (mcInfo.getStandardCost() != null) {
            standardCost = mcInfo.getStandardCost();
        }
        MultiMeasureUnitInfo mulUnit = null;
        if (mui != null) {
            mulUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiUnit(aMaterialInfo.getId().toString(), mui.getId().toString());
        }
        BigDecimal coefficient = new BigDecimal("1.00");
        if (mulUnit != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
            unitStandardCost = standardCost.multiply(coefficient);
        }
        return unitStandardCost;
    }

    @Override
    protected String[] _getOtherInWareID(Context ctx, IObjectPK pk) throws BOSException {
        if (pk == null) {
            return null;
        }
        IRowSet rs = null;
        StringBuffer strID = new StringBuffer();
        try {
            rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)"SELECT fid,FSourceBillID From T_IM_OtherInWarehsBill where FSourceBillID = ?", (Object[])new String[]{pk.toString()});
            while (rs.next()) {
                strID.append(",").append(rs.getString("FID"));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return strID.length() > 0 ? strID.substring(1).split(",") : null;
    }

    @Override
    protected String[] _getOtherIssueID(Context ctx, IObjectPK pk) throws BOSException {
        if (pk == null) {
            return null;
        }
        IRowSet rs = null;
        StringBuffer strID = new StringBuffer();
        try {
            rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)"SELECT fid ,FSourceBillID From T_IM_OtherIssueBill where FSourceBillID = ?", (Object[])new String[]{pk.toString()});
            while (rs.next()) {
                strID.append(",").append(rs.getString("FID"));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return strID.length() > 0 ? strID.substring(1).split(",") : null;
    }

    @Override
    protected void _cancelTask(Context ctx, String spk) throws BOSException, EASBizException {
        if (spk == null || spk.length() == 0) {
            return;
        }
        ObjectUuidPK ipk = new ObjectUuidPK(spk);
        CountingTaskInfo billInfo = this.getCountingTaskInfo(ctx, (IObjectPK)ipk);
        if (billInfo.getTaskStatus().equals((Object)TaskStatusEnum.BEGINCOUNTING) && billInfo.isIsFreeMaterial()) {
            this.lockInventoryRows(ctx, (IObjectPK)ipk);
            this.changeInventoryStatus(ctx, (IObjectPK)ipk, false);
        }
        this.deleteCountingTempTask(ctx, (IObjectPK)ipk);
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)"UPDATE T_IM_CountingTask SET FTaskStatus = 5 WHERE FID = ?", (Object[])new String[]{spk});
    }

    @Override
    protected void _countUnAdjust(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._countUnAdjust(ctx, pk, true);
    }

    @Override
    protected int[] _getOtherInWareStatus(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return new int[0];
        }
        IRowSet rs = null;
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FBaseStatus ,FSourceBillID From T_IM_OtherInWarehsBill ");
            sql.append("where FSourceBillID = ? ");
            rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pk.toString()});
            while (rs.next()) {
                statusList.add(new Integer(rs.getInt("FBaseStatus")));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        int[] status = new int[statusList.size()];
        int size = statusList.size();
        for (int i = 0; i < size; ++i) {
            status[i] = (Integer)statusList.get(i);
        }
        return status;
    }

    @Override
    protected int[] _getOtherIssueStatus(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return new int[0];
        }
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        IRowSet rs = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FBaseStatus ,FSourceBillID From T_IM_OtherIssueBill ");
            sql.append("where FSourceBillID = ?");
            rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pk.toString()});
            while (rs.next()) {
                statusList.add(new Integer(rs.getInt("FBaseStatus")));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        int[] status = new int[statusList.size()];
        int size = statusList.size();
        for (int i = 0; i < size; ++i) {
            status[i] = (Integer)statusList.get(i);
        }
        return status;
    }

    protected boolean _checkHasAudit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        CountingTaskInfo billInfo = (CountingTaskInfo)model;
        if (billInfo.getTaskStatus() != null && billInfo.getTaskStatus().getValue() == 6) {
            throw new CountingException(SCMBillException.CHECKAUDITEDOK, new Object[]{billInfo.getString("number"), ""});
        }
        return true;
    }

    protected boolean _checkAudit(Context ctx, IObjectValue model, boolean isPassAudit) throws EASBizException, BOSException {
        CountingTaskInfo billInfo = (CountingTaskInfo)model;
        if (billInfo.getTaskStatus() != null) {
            if (isPassAudit) {
                if (billInfo.getTaskStatus().getValue() != 1) {
                    throw new CountingException(CountingException.CHECKAUDITEDOK, new Object[]{billInfo.getString("number"), ""});
                }
            } else if (billInfo.getTaskStatus().getValue() != 6) {
                throw new CountingException(CountingException.CHECKAUDITEDNOTOK, new Object[]{billInfo.getString("number"), ""});
            }
        }
        return true;
    }

    protected boolean _checkUnAuditInParam(Context ctx, CountingTaskInfo billInfo) throws EASBizException, BOSException {
        String billTypeId = "50957179-0105-1000-e004-4152c0a812fd463ED552";
        String orgUnitID = billInfo.getStorageOrgUnit().getId().toString();
        boolean isCanUnAudit = false;
        ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
        String strCanUnAudit = scmParam.getParamByBillTypeID("SCM_UnAudit_01", 4, orgUnitID, billTypeId);
        if (strCanUnAudit != null && strCanUnAudit.trim().length() != 0 && strCanUnAudit.trim().equalsIgnoreCase("1")) {
            isCanUnAudit = true;
        }
        if (!isCanUnAudit) {
            throw new SCMBillException(SCMBillException.CHECK_UNAUDIT_PARAM);
        }
        return true;
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CountingTaskInfo billInfo = this.getCountingTaskInfo(ctx, pk);
        this._checkAudit(ctx, (IObjectValue)billInfo, true);
        this.isSamePerson4Audit(ctx, billInfo);
        this.updateAuditStatus(ctx, (IObjectValue)billInfo, TaskStatusEnum.AUDIT);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CountingTaskInfo billInfo = this.getCountingTaskInfo(ctx, pk);
        this._checkAudit(ctx, (IObjectValue)billInfo, false);
        this._checkUnAuditInParam(ctx, billInfo);
        this.isSamePerson4UnAudit(ctx, billInfo);
        this.updateAuditStatus(ctx, (IObjectValue)billInfo, TaskStatusEnum.TEMPORARILYSAVED);
    }

    public void updateAuditStatus(Context ctx, IObjectValue model, TaskStatusEnum statusEnum) throws EASBizException, BOSException {
        String tableName = "T_IM_CountingTask";
        CountingTaskInfo billInfo = (CountingTaskInfo)model;
        Connection conn = null;
        PreparedStatement preStmt = null;
        Statement sm = null;
        try {
            StringBuffer sqlBuff = new StringBuffer();
            sqlBuff.append("Update ");
            sqlBuff.append(tableName);
            sqlBuff.append(" SET FBizDate = ?, FAuditorID = ? , FTaskStatus = ? ");
            sqlBuff.append(" WHERE FID = ? ");
            conn = EJBFactory.getConnection((Context)ctx);
            preStmt = conn.prepareStatement(sqlBuff.toString());
            if (statusEnum.getValue() == 6) {
                Date now = new Date();
                preStmt.setTimestamp(1, new Timestamp(now.getTime()));
                UserInfo aUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                if (aUserInfo != null) {
                    preStmt.setString(2, aUserInfo.getId().toString());
                } else {
                    preStmt.setString(2, null);
                }
            } else if (statusEnum.getValue() == 0) {
                preStmt.setTimestamp(1, null);
                preStmt.setString(2, null);
            }
            preStmt.setInt(3, statusEnum.getValue());
            preStmt.setString(4, billInfo.getId().toString());
            preStmt.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(preStmt, conn);
                SQLUtils.cleanup(sm, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)preStmt, (Connection)conn);
        SQLUtils.cleanup(sm, (Connection)conn);
    }

    @Override
    protected void _insertCountingSort(Context ctx, IObjectPK pk, String sort) throws BOSException, EASBizException {
        String orderby = this.getCountingSort(ctx, pk);
        StringBuffer sql = new StringBuffer();
        if (orderby == null) {
            sql.append("INSERT INTO T_IM_COUNTINGTASKSORT(FID, FCOUNTINGTASKID, FSORT)");
            sql.append(" VALUES(newbosid('55555555'),'").append(pk.toString()).append("','").append(sort).append("')");
        } else {
            sql.append("UPDATE T_IM_COUNTINGTASKSORT SET FSORT = '").append(sort).append("' ");
            sql.append(" WHERE FCOUNTINGTASKID = '").append(pk.toString()).append("'");
        }
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCountingSort(Context ctx, IObjectPK pk) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FSORT FROM T_IM_COUNTINGTASKSORT WHERE FCOUNTINGTASKID = '").append(pk.toString()).append("'");
        IRowSet result = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (result.next()) {
                String string = result.getString("FSORT");
                return string;
            }
        }
        catch (SQLException e) {
            String string = null;
            return string;
        }
        finally {
            SQLUtils.cleanup((ResultSet)result);
        }
        return null;
    }

    private String replaceSortProperties(String sort) {
        if (sort == null || sort.length() == 0) {
            return null;
        }
        sort = sort.replaceAll("material.number", "FMaterialNumber");
        sort = sort.replaceAll("material.model", "FMaterialModel");
        sort = sort.replaceAll("material.name", "FMaterialName");
        sort = sort.replaceAll("unit.name", "FUnitID");
        sort = sort.replaceAll("baseUnit.name", "FBaseUnitID");
        sort = sort.replaceAll("entry.lot", "FLot");
        sort = sort.replaceAll("location.number", "FLocationNumber");
        sort = sort.replaceAll("assistProperty.id", "FAssistPropertyID");
        sort = sort.replaceAll("storeType.number", "FStoreTypeNumber");
        sort = sort.replaceAll("storeStatus.number", "FStoreStatusNumber");
        sort = sort.replaceAll("supplier.id", "FSupplierID");
        sort = sort.replaceAll("customer.id", "FCustomerID");
        return sort;
    }

    private String replaceSortPropertiesToEntry(String sort) {
        if (sort == null || sort.length() == 0) {
            return null;
        }
        sort = sort.replaceAll("material.number", "entry.material.number");
        sort = sort.replaceAll("material.model", "entry.material.model");
        sort = sort.replaceAll("material.name", "entry.material");
        sort = sort.replaceAll("unit.name", "entry.unit");
        sort = sort.replaceAll("baseUnit.name", "entry.unit");
        sort = sort.replaceAll("entry.lot", "entry.lot");
        sort = sort.replaceAll("location.number", "entry.location");
        sort = sort.replaceAll("assistProperty.id", "entry.assistProperty");
        sort = sort.replaceAll("storeType.number", "entry.storeType");
        sort = sort.replaceAll("storeStatus.number", "entry.storeStatus");
        sort = sort.replaceAll("supplier.id", "entry.supplier");
        sort = sort.replaceAll("customer.id", "entry.customer");
        return sort;
    }

    private String[][] getSortItem(String sort) {
        if (sort == null) {
            return null;
        }
        String[] sortItems = sort.split(",");
        int size = sortItems.length;
        String[][] items = new String[size][2];
        for (int i = 0; i < size; ++i) {
            items[i][0] = sortItems[i].substring(0, sortItems[i].indexOf(" "));
            items[i][1] = sortItems[i].substring(sortItems[i].indexOf(" ") + 1);
        }
        return items;
    }

    @Override
    protected String _getCountingTaskSorter(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String tableSorter = this.getCountingSort(ctx, pk);
        return tableSorter;
    }

    private void isSamePerson4Audit(Context ctx, CountingTaskInfo info) throws EASBizException, BOSException {
        UserInfo userInfo;
        Boolean isSysBill = (Boolean)info.get("isSysBill");
        if (isSysBill != null && isSysBill.toString().equals("true")) {
            return;
        }
        String creatorID = "";
        String currentUserId = "";
        if (info.getCreator() != null) {
            creatorID = info.getCreator().getId().toString();
        }
        if ((userInfo = ContextUtil.getCurrentUserInfo((Context)ctx)) != null) {
            currentUserId = userInfo.getId().toString();
        }
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        if (info.getStorageOrgUnit() == null || info.getStorageOrgUnit().getId() == null) {
            return;
        }
        String paramValue = ipc.getParamValue((IObjectPK)new ObjectUuidPK(info.getStorageOrgUnit().getId()), "INM103");
        if (paramValue != null && "true".equals(paramValue.trim()) && creatorID.equals(currentUserId)) {
            throw new SCMBillException(SCMBillException.AUDITOR_CREATOR_ISSAME);
        }
    }

    private void isSamePerson4UnAudit(Context ctx, CountingTaskInfo info) throws EASBizException, BOSException {
        UserInfo userInfo;
        Boolean isSysBill = (Boolean)info.get("isSysBill");
        if (isSysBill != null && isSysBill.toString().equals("true")) {
            return;
        }
        String auditorID = "";
        String currentUserId = "";
        if (info.getAuditor() != null) {
            auditorID = info.getAuditor().getId().toString();
        }
        if ((userInfo = ContextUtil.getCurrentUserInfo((Context)ctx)) != null) {
            currentUserId = userInfo.getId().toString();
        }
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        if (info.getStorageOrgUnit() == null || info.getStorageOrgUnit().getId() == null) {
            return;
        }
        String paramValue = ipc.getParamValue((IObjectPK)new ObjectUuidPK(info.getStorageOrgUnit().getId()), "INM104");
        if (paramValue != null && "true".equals(paramValue.trim()) && !auditorID.equals(currentUserId)) {
            throw new SCMBillException(SCMBillException.AUDITOR_UNAUDITOR_NOTSAME);
        }
    }

    private StringBuffer getGroupBy(Boolean isBaseUpdate, String tempTableName) {
        int i;
        StringBuffer groupByInv = new StringBuffer();
        String unit = isBaseUpdate != false ? "fbaseunitid" : "funitid";
        groupByInv.append("select ").append("newbosid('BA8AD747'),fcompanyorgunitid,fstorageorgunitid,fmaterialid, ").append(unit).append(" as funitid,fbaseunitid,");
        groupByInv.append("case when fassistunitid = '").append("EgkAAAA5EWFbglxX").append("' then null else fassistunitid end as fassistunitid,");
        groupByInv.append("case when fassistpropertyid = '").append("EgkAAAA5EWALxvQu").append("' then null else fassistpropertyid end as fassistpropertyid,");
        groupByInv.append("fstoretypeid,fstorestatusid, ");
        groupByInv.append("case when fsupplierid = '").append("EgkAAABc3Xo3xn38").append("' then null else fsupplierid end as fsupplierid,");
        groupByInv.append("case when fcustomerid = '").append("EgkAAABc3Xu/DAQO").append("' then null else fcustomerid end as fcustomerid,");
        groupByInv.append("case when fwarehouseid = '").append("EgkAAABc3XG76fiu").append("' then null else fwarehouseid end as fwarehouseid,");
        groupByInv.append(" case when flocationid = '").append("EgkAAABc3XMgX/hq").append("' then null else flocationid end as flocationid,");
        groupByInv.append(" case when flot = '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' then null else flot end as flot, sum(fbaseqty) as fcurstoreqty, ").append("sum(fbaseqty) as fbaseqty,sum(fcurstoreassistqty) as fcurstoreassistqty ,");
        groupByInv.append("case when FProjectID = '").append("EgkAAABc3Xza3gXu").append("' then null else FProjectID end as FProjectID,");
        groupByInv.append(" case when FTrackNumberID ='").append("EgkAAABc3X0Ibpg9").append("' then null else FTrackNumberID end as FTrackNumberID ");
        for (i = 0; i < this.extendFields.size(); ++i) {
            groupByInv.append(",").append(this.extendFields.get(i));
        }
        groupByInv.append(" from ").append(tempTableName).append(" ").append(" group by ").append(" fcompanyorgunitid,fstorageorgunitid,fmaterialid,").append(unit).append("  ,fbaseunitid,fassistunitid,fassistpropertyid, fstoretypeid,fstorestatusid,").append(" fsupplierid, fcustomerid,fwarehouseid,flocationid,flot ,FProjectID,FTrackNumberID ");
        for (i = 0; i < this.extendFields.size(); ++i) {
            groupByInv.append(",").append(this.extendFields.get(i));
        }
        return groupByInv;
    }

    private void insertBalanceData(Context ctx, String orgTempTable, String tempTableName) throws BOSException {
        int i;
        Map map = CountingTableAppHelper.getExtendField4Balance(ctx);
        StringBuffer sqlSel = new StringBuffer();
        sqlSel.append("SELECT newbosid('BA8AD747'), h.FCompanyOrgUnitID, h.FStorageOrgUnitID,  ");
        sqlSel.append("h.FMaterialID,D.Fbaseunit as FUnitID, D.fbaseunit as FBaseUnitID ,  ");
        sqlSel.append("D.FAssistUnit as FAssistUnitID, h.FAssistPropertyID, h.FStoreTypeid, h.FStoreStatusid,  ");
        sqlSel.append("h.FSupplierid, h.FCustomerid, h.FWarehouseID, h.FLocationID,h.FLot,  ");
        sqlSel.append("sum(h.FPeriodBeginQty) as FBeginQty,  ");
        sqlSel.append("sum(h.FPeriodBeginQty) as FBeginBaseQty, ");
        sqlSel.append("sum(h.FPeriodBeginAssistQty) as FBeginAssQty ");
        sqlSel.append(" ,h.FProjectID,h.FTrackNumberID ");
        sqlSel.append(" ,max(dates.fmfg),max(dates.fexp) ");
        String fieldName = null;
        for (i = 0; i < this.extendFields.size(); ++i) {
            fieldName = (String)map.get(this.extendFields.get(i));
            if (fieldName != null) {
                sqlSel.append(", h.").append(fieldName);
                continue;
            }
            sqlSel.append(", null");
        }
        sqlSel.append(" FROM t_im_inventorybalance h  ");
        sqlSel.append("inner join ").append(orgTempTable).append(" o  ");
        sqlSel.append("on h.fstorageorgunitid = o.fid  ");
        sqlSel.append("and h.fyear = o.fbeginyear and h.fperiod = o.fbeginperiod  ");
        sqlSel.append("inner join T_BD_MATERIAL D   ");
        sqlSel.append("on h.fmaterialid = D.fid  ");
        sqlSel.append(" left join t_IM_DateOfMinDurability dates on h.FMaterialID = dates.FMaterialID  ");
        sqlSel.append("  and h.flot = dates.flot and h.fstorageorgunitid = dates.fstorageorgunitid ");
        sqlSel.append("group by h.FCompanyOrgUnitID, h.FStorageOrgUnitID,h.FMaterialID,D.Fbaseunit , ");
        sqlSel.append("D.FAssistUnit , h.FAssistPropertyID, h.FStoreTypeid, h.FStoreStatusid,  ");
        sqlSel.append("h.FSupplierid, h.FCustomerid, h.FWarehouseID, h.FLocationID,h.FLot,h.FProjectID,h.FTrackNumberID");
        for (i = 0; i < this.extendFields.size(); ++i) {
            fieldName = (String)map.get(this.extendFields.get(i));
            if (fieldName == null) continue;
            sqlSel.append(", h.").append(fieldName);
        }
        StringBuffer sqlIn = new StringBuffer();
        sqlIn.append("insert into ").append(tempTableName).append(" ");
        sqlIn.append("(fid,fcompanyorgunitid,fstorageorgunitid,fmaterialid,funitid,fbaseunitid,");
        sqlIn.append("fassistunitid,fassistpropertyid,fstoretypeid,fstorestatusid,fsupplierid,fcustomerid,");
        sqlIn.append("fwarehouseid,flocationid,flot,fcurstoreqty,fbaseqty,fcurstoreassistqty,FProjectID,FTrackNumberID,FMfg,FExp ");
        for (int i2 = 0; i2 < this.extendFields.size(); ++i2) {
            fieldName = this.extendFields.get(i2);
            if (fieldName == null) continue;
            sqlIn.append(", ").append(fieldName);
        }
        sqlIn.append(")");
        StringBuffer sql = new StringBuffer();
        sql.append(sqlIn).append(sqlSel);
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void insertBillData(Context ctx, String orgTempTable, String storageOrgID, String tempTableName) throws BOSException, EASBizException {
        StringBuffer msDate = new StringBuffer();
        String beginDate = null;
        String endDate = null;
        msDate.append(" SELECT fbegindate, fenddate FROM ").append(orgTempTable);
        try {
            IRowSet rs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)msDate.toString());
            if (rs.next()) {
                beginDate = IMRptUtils.getFilterBeginDate(rs.getDate("fbegindate"));
                endDate = IMRptUtils.getFilterBeginDate(rs.getDate("fenddate"));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        HashMap params = this.getParam(ctx, storageOrgID);
        StringBuffer msWhere = new StringBuffer();
        msWhere.append(" WHERE b.fstorageorgunitid = '").append(storageOrgID).append("' ");
        msWhere.append("   and a.fbizdate >= to_date('").append(beginDate).append("') ");
        msWhere.append("   and a.fbizdate < to_date('").append(endDate).append("') ");
        ctx.put((Object)"BuildCountingTable", (Object)"BuildCountingTable");
        InventoryUpdateFactory.getLocalInstance((Context)ctx).getBillDataSQL((Map)params, tempTableName, msWhere);
    }

    public int getEntriesNum() {
        return 500;
    }

    @Override
    protected void _countUnAdjust(Context ctx, IObjectPK pk, boolean isClearCountingQty) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement preStmt = null;
        try {
            boolean IsInventory;
            ObjectUuidPK opk;
            int i;
            conn = EJBFactory.getConnection((Context)ctx);
            preStmt = conn.prepareStatement("UPDATE T_IM_CountingTask SET FTaskStatus = 3,FCountingEndTime = null WHERE FID = ?");
            preStmt.setString(1, pk.toString());
            preStmt.execute();
            String[] ids = this._getOtherInWareID(ctx, pk);
            if (ids != null) {
                IOtherInWarehsBill iOtherInWarehsBill = OtherInWarehsBillFactory.getLocalInstance(ctx);
                for (i = 0; i < ids.length; ++i) {
                    opk = new ObjectUuidPK(ids[i]);
                    iOtherInWarehsBill.deleteNocheck((IObjectPK)opk);
                }
            }
            if ((ids = this._getOtherIssueID(ctx, pk)) != null) {
                IOtherIssueBill iOtherIssueBill = OtherIssueBillFactory.getLocalInstance(ctx);
                for (i = 0; i < ids.length; ++i) {
                    opk = new ObjectUuidPK(ids[i]);
                    iOtherIssueBill.deleteNocheck((IObjectPK)opk);
                }
            }
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("id"));
            sc.add(new SelectorItemInfo("taskStatus"));
            sc.add(new SelectorItemInfo("isFreeMaterial"));
            sc.add(new SelectorItemInfo("isInventory"));
            CountingTaskInfo billInfo = this.getCountingTaskInfo(ctx, pk, sc);
            this.checkCountingTempExists(ctx);
            this.deleteCountingTempTask(ctx, pk);
            boolean bl = IsInventory = billInfo.getIsInventory() == 1;
            if (IsInventory) {
                this.getAccountQty(ctx, pk, isClearCountingQty);
            }
            if (billInfo.isIsFreeMaterial()) {
                if (billInfo.getIsInventory() == 1) {
                    this.insertCountingTempTask(ctx, pk);
                }
                this.updateCountingTempTask(ctx, pk);
            }
            billInfo.setTaskStatus(TaskStatusEnum.BEGINCOUNTING);
            Date now = new Date();
            Timestamp nowTimeStamp = new Timestamp(now.getTime());
            nowTimeStamp.setNanos(0);
            billInfo.setCountingBeginTime(nowTimeStamp);
            billInfo.setCountingEndTime(null);
            this.update(ctx, pk, (CoreBaseInfo)billInfo);
            if (billInfo.isIsFreeMaterial()) {
                this.changeInventoryStatus(ctx, pk, true);
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(stmt, (Connection)conn);
            SQLUtils.cleanup((Statement)preStmt);
        }
    }

    public String getExtFilterSQL(CountingTaskInfo taskInfo) {
        return null;
    }

    public String getExtJoinSQL(CountingTaskInfo taskInfo) {
        return null;
    }

    private RowSet getWarehouseSet(Context ctx, CountingTaskInfo billInfo) throws BOSException {
        StringBuffer warehouseSql = new StringBuffer("select A.FWarehouseId from T_DB_SOACCREDITWH A inner join T_DB_Warehouse B on B.FID = A.FWarehouseId where A.FSTORAGEORGID = '");
        warehouseSql.append(billInfo.getStorageOrgUnit().getId().toString()).append("' ");
        if (billInfo.isIsAssignWarehouse()) {
            this.addListWarehouseFilter(billInfo.getCountingListWarehouse(), warehouseSql, CompareType.INCLUDE);
        } else {
            if (billInfo.getFromWarehouse() != null && billInfo.getFromWarehouse().trim().length() > 0) {
                warehouseSql.append("AND B.FNumber >= '");
                warehouseSql.append(billInfo.getFromWarehouse());
                warehouseSql.append("' ");
            }
            if (billInfo.getToWarehouse() != null && billInfo.getToWarehouse().trim().length() > 0) {
                warehouseSql.append("AND B.FNumber <= '");
                warehouseSql.append(billInfo.getToWarehouse());
                warehouseSql.append("' ");
            }
        }
        IRowSet warehouseRs = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)warehouseSql.toString());
        return warehouseRs;
    }

    private CountingTableInfo createCountTableInfo(CountingTaskInfo billInfo, int pageNo, String warehouseId) {
        CountingTableInfo ctInfo = new CountingTableInfo();
        ctInfo.setCountingTask(billInfo);
        ctInfo.setStorageOrgUnit(billInfo.getStorageOrgUnit());
        WarehouseInfo whInfo = new WarehouseInfo();
        whInfo.setId(BOSUuid.read((String)warehouseId));
        ctInfo.setWarehouse(whInfo);
        ctInfo.setPageNo(pageNo);
        return ctInfo;
    }
}

