/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.scm.im.inv.ISOAccreditWH;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.cal.CalculateFacadeFactory;
import com.kingdee.eas.scm.cal.ICalculateFacade;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.IPurInWarehsBill;
import com.kingdee.eas.scm.im.inv.ISaleIssueBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public abstract class CreateVirtualBill {
    protected Map billMap = new HashMap();
    protected ArrayList sepBillArray = new ArrayList();
    protected static final String PARAM_EXCHANGERATE = "exchangeRate";
    protected static final String PARAM_CURRENCY = "currency";
    protected static final String PARAM_BIZTYPEID = "bizTypeID";
    protected static final String PARAM_INVCOMPANYORGUNIT = "invCompanyOrgUnit";
    protected static final String PARAM_ORDSTORAGEORGUNIT = "orderStorageOrgUnit";
    protected static final String PARAM_VIRTUALSALEORGUNIT = "virtualSaleOrgUnit";
    protected static final String PARAM_VIRTUALPURORGUNIT = "virtualPurOrgUnit";
    protected static final String PARAM_VIRTUALRECEIVEORGUNIT = "virtualReceiveOrgUnit";
    protected static final String PARAM_ORDCOMPANYORGUNIT = "orderCompanyOrgUnit";
    protected static final String PARAM_LOCALAMOUNTPRECISION = "localAmountPrecision";
    protected static final String PARAM_AMOUNTPRECISION = "amountPrecision";
    protected static final String PARAM_WAREHOUSE = "warehouse";
    protected static final String PARAM_STOCKER = "stocker";
    protected static final String PARAM_INVINBILLBOSTYPE = "invInBillBosType";
    protected static final String PARAM_INVOUTBILLBOSTYPE = "invOutBillBosType";
    protected static final String PARAM_INVINBILLENTRYBOSTYPE = "invInBillEntryBosType";
    protected static final String PARAM_INVOUTBILLENTRYBOSTYPE = "invOutBillEntryBosType";
    protected static final String PARAM_COSTINBILLID = "costInBillID";
    protected static final String PARAM_COSTOUTBILLID = "costOutBillID";
    protected static final String PARAM_ORGBILLNUMBER = "orgBillNumber";
    protected static final String PARAM_ORGBILLID = "orgBillID";
    protected static final String PARAM_SOURCEBILLTABLE = "sourceBillTable";
    protected static final String PARAM_SOURCEENTRYTABLE = "sourceEntryTable";
    protected static final String PARAM_COREBILLTABLE = "coreBillTable";
    protected static final String PARAM_COREBILLENTRYTABLE = "coreBillEntryTable";
    protected static final String PARAM_COREBILLIDFIELD = "coreBillIDField";
    protected static final String PARAM_COREBILLENTRYIDFIELD = "coreBillEntryIDField";
    protected static final String PARAM_COREBILLNUMBER = "coreBillNumber";
    protected static final String PARAM_COREBILLSEQNO = "coreBillSeqNo";
    protected static final String PARAM_SUPPLIERSQL = "supplierSql";
    protected static final String PARAM_CUSTOMERSQL = "customerSql";
    protected static final String PARAM_BALANCESUPPLIERSQL = "balanceSupplierSql";
    protected static final String PARAM_BALANCECUSTOMERSQL = "balanceCustomerSql";
    protected static final String PARAM_COSTINBILLNUMBER = "costInBillNumber";
    protected static final String PARAM_COSTOUTBILLNUMBER = "costOutBillNumber";
    protected static final String PARAM_STORAGEFIELD = "storageField";
    protected static final String TABLENAME_PURINENTRY = "t_im_purinwarehsentry";
    protected static final String TABLENAME_SALEISSUEENTRY = "t_im_saleissueentry";
    protected static final String TABLENAME_PURIN = "t_im_purinwarehsbill";
    protected static final String TABLENAME_SALEISSUE = "t_im_saleissuebill";
    protected static final String COSTINTRANSTYPE = "costInTransType";
    protected static final String COSTOUTTRANSTYPE = "costOutTransType";
    protected static final String ININV_COREBILLENTRYID_FIELD = "FPurOrderEntryID";
    protected static final String OUTINV_COREBILLENTRYID_FIELD = "FSaleOrderEntryID";
    protected static final String ININV_COREBILLID_FIELD = "FPurOrderID";
    protected static final String OUTINV_COREBILLID_FIELD = "FSaleOrderID";
    protected static final String COSTIN_PRICE = "costInPrice";
    protected static final String COSTIN_TAXPRICE = "costInTaxPrice";
    protected static final String COSTIN_TAXRATE = "costInTaxRate";
    protected static final String COSTIN_DISCOUNTRATE = "costInDiscountRate";
    protected static final String COSTIN_DISCOUNTAMOUNT = "costInDiscountAmount";
    protected static final String COSTIN_PURCHASEFEE = "costInPurchaseFee";
    protected static final String COSTIN_MATERIALCOST = "costInMaterialCost";
    protected static final String COSTIN_QTY = "costInQty";
    protected static final String COSTIN_CONVERTMODE = "costInConvertMode";
    protected static final String COSTIN_EXCHANGERATE = "costInExchangeRate";
    protected static final String COSTIN_TAXAMOUNT = "costInTaxAmount";
    protected static final String COSTIN_TAX = "costInTax";
    protected static final String COSTIN_LOCALTAXAMOUNT = "costInLocalTaxAmount";
    protected static final String COSTIN_AMOUNT = "costInAmount";
    protected static final String COSTIN_LOCALTAX = "costInLocalTax";
    protected static final String COSTIN_ACTUALTAXPRICE = "costInActualTaxPrice";
    protected static final String COSTIN_ACTUALPRICE = "costInActualPrice";
    protected static final String COSTIN_PURCHASECOST = "costInPurchaseCost";
    protected static final String COSTIN_UNITPURCHASECOST = "costInUnitPurchaseCost";
    protected static final String COSTOUT_PRICE = "costOutPrice";
    protected static final String COSTOUT_AMOUNT = "costOutAmount";
    protected static final String COSTIN_UNITACTUALCOST = "costInUnitActualCost";
    protected static final String COSTIN_ACTUALCOST = "costInActualCost";
    protected static final String COSTIN_UNWRITEOFFAMOUNT = "costInUnWriteOffAmount";
    protected static final String COSTOUT_UNITACTUALCOST = "costOutUnitActualCost";
    protected static final String COSTOUT_ACTUALCOST = "costOutActualCost";
    protected static final String COSTOUT_UNWRITEOFFAMOUNT = "costOutUnWriteOffAmount";

    protected void createVirtualBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (!this.checkCreateVirtualBill(ctx, model)) {
            return;
        }
        this.initBillMap(ctx, model);
        this.createBill(ctx);
        this.checkMatCompanyInfo(ctx);
        this.createRelation(ctx);
    }

    private void checkMatCompanyInfo(Context ctx) throws BOSException, EASBizException {
        SaleIssueBillInfo billInfo;
        FilterInfo costInFilter = new FilterInfo();
        FilterInfo costOutFilter = new FilterInfo();
        HashSet<String> inIdSet = new HashSet<String>(this.sepBillArray.size() * 2);
        HashSet<String> outIdSet = new HashSet<String>(this.sepBillArray.size() * 2);
        int size = this.sepBillArray.size();
        for (int i = 0; i < size; ++i) {
            HashMap map = (HashMap)this.sepBillArray.get(i);
            inIdSet.add(map.get(PARAM_COSTINBILLID).toString());
            outIdSet.add(map.get(PARAM_COSTOUTBILLID).toString());
        }
        costInFilter.getFilterItems().add(new FilterItemInfo("id", inIdSet, CompareType.INCLUDE));
        costOutFilter.getFilterItems().add(new FilterItemInfo("id", outIdSet, CompareType.INCLUDE));
        SelectorItemCollection itemCol = new SelectorItemCollection();
        itemCol.add("id");
        itemCol.add("isInitBill");
        itemCol.add("bizDate");
        itemCol.add("entry.material.id");
        itemCol.add("entry.material.name");
        itemCol.add("entry.companyOrgUnit.id");
        itemCol.add("entry.companyOrgUnit.name");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().addObjectCollection((IObjectCollection)itemCol);
        viewInfo.setFilter(costOutFilter);
        SaleIssueBillCollection siCol = SaleIssueBillFactory.getLocalInstance(ctx).getSaleIssueBillCollection(viewInfo);
        int size2 = siCol.size();
        for (int i = 0; i < size2; ++i) {
            billInfo = siCol.get(i);
            InvServerUtils.checkMatCompanyInfo(ctx, billInfo, InvBizException.MATERIAL_COMPANY_NULL_VIRTUAL);
            if (billInfo.isIsInitBill()) {
                SCMServerUtils.checkInitBizDate((Context)ctx, (SCMBillBaseInfo)billInfo, (CompanyOrgUnitInfo)this.getCompanyOrgUnit(billInfo), (boolean)true);
                continue;
            }
            SCMServerUtils.checkBizDate((Context)ctx, (IObjectValue)billInfo, (CompanyOrgUnitInfo)this.getCompanyOrgUnit(billInfo), (boolean)true);
        }
        viewInfo.setFilter(costInFilter);
        PurInWarehsBillCollection piwCol = PurInWarehsBillFactory.getLocalInstance(ctx).getPurInWarehsBillCollection(viewInfo);
        int size3 = piwCol.size();
        for (int i = 0; i < size3; ++i) {
            billInfo = siCol.get(i);
            InvServerUtils.checkMatCompanyInfo(ctx, billInfo, InvBizException.MATERIAL_COMPANY_NULL_VIRTUAL);
            if (billInfo.isIsInitBill()) {
                SCMServerUtils.checkInitBizDate((Context)ctx, (SCMBillBaseInfo)billInfo, (CompanyOrgUnitInfo)this.getCompanyOrgUnit(billInfo), (boolean)true);
                continue;
            }
            SCMServerUtils.checkBizDate((Context)ctx, (IObjectValue)billInfo, (CompanyOrgUnitInfo)this.getCompanyOrgUnit(billInfo), (boolean)true);
        }
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnit(InvBillBaseInfo billInfo) throws BOSException, EASBizException {
        IObjectCollection iObjectCollection = (IObjectCollection)billInfo.get("entry");
        if (iObjectCollection != null && iObjectCollection.size() > 0) {
            InvBillBaseEntryInfo aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(0);
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)aInvBillBaseEntryInfo.get("companyOrgUnit");
            return aCompanyOrgUnitInfo;
        }
        return null;
    }

    protected void updateVirtualBillForReversed(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (!this.checkUpdateVirtualBillForReversed(ctx, model)) {
            return;
        }
        this.initBillMap(ctx, model);
        this.checkRewriteVirtualBill(ctx, model);
        this.rewriteVirtualBill(ctx, model);
    }

    protected boolean checkCreateVirtualBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return false;
    }

    protected boolean checkUpdateVirtualBillForReversed(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return false;
    }

    protected void createRelation(Context ctx) throws BOSException, EASBizException {
        ObjectUuidPK costInOutPK = null;
        String orgBOSType = this.billMap.get(PARAM_INVINBILLBOSTYPE).toString();
        String desBOSType = this.billMap.get(PARAM_INVOUTBILLBOSTYPE).toString();
        String orgBillID = this.billMap.get(PARAM_ORGBILLID).toString();
        HashMap map = null;
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        String updateDischargeType = "update T_IM_PurinwarehsBill set FDischargeType = {0} where FId = ''{1}''";
        for (int i = 0; i < this.sepBillArray.size(); ++i) {
            map = (HashMap)this.sepBillArray.get(i);
            String costInFid = map.get(PARAM_COSTINBILLID).toString();
            costInOutPK = new ObjectUuidPK(costInFid);
            IPurInWarehsBill ip = PurInWarehsBillFactory.getLocalInstance(ctx);
            PurInWarehsBillInfo pi = ip.getPurInWarehsBillInfo((IObjectPK)costInOutPK);
            if (pi != null) {
                this.calculateBill(ctx, pi);
                CompanyOrgUnitInfo company = pi.getEntry().get(0).getCompanyOrgUnit();
                if (company != null) {
                    String dischargeType = ipc.getParamValue((IObjectPK)new ObjectUuidPK(company.getId()), "SCM_CAL_001");
                    if (dischargeType.equals("1") && pi.isIsInitBill()) {
                        dischargeType = "2";
                    }
                    String sSQL = MessageFormat.format(updateDischargeType, dischargeType, costInOutPK.toString());
                    DbUtil.execute((Context)ctx, (String)sSQL);
                }
                SCMServerUtils.traceUpAndDown((Context)ctx, (String)orgBillID, (String)costInFid, (String)orgBOSType, (String)orgBOSType);
            }
            String costOutFid = map.get(PARAM_COSTOUTBILLID).toString();
            costInOutPK = new ObjectUuidPK(costOutFid);
            ISaleIssueBill is = SaleIssueBillFactory.getLocalInstance(ctx);
            SaleIssueBillInfo si = is.getSaleIssueBillInfo((IObjectPK)costInOutPK);
            if (si == null) continue;
            this.calculateBill(ctx, si);
            SCMServerUtils.traceUpAndDown((Context)ctx, (String)orgBillID, (String)costOutFid, (String)orgBOSType, (String)desBOSType);
        }
    }

    protected void auditBill(Context ctx, SCMBillBaseInfo aSCMBillBaseInfo, String tableName) throws BOSException {
        Connection conn = null;
        PreparedStatement preStmt = null;
        Statement sm = null;
        try {
            StringBuffer sqlBuff = new StringBuffer();
            sqlBuff.append("Update ");
            sqlBuff.append(tableName);
            sqlBuff.append(" SET FAuditTime = ?, FAuditorID = ? , FBaseStatus = ? ");
            sqlBuff.append(" WHERE FID = ? ");
            conn = EJBFactory.getConnection((Context)ctx);
            preStmt = conn.prepareStatement(sqlBuff.toString());
            Date now = new Date();
            preStmt.setTimestamp(1, new Timestamp(now.getTime()));
            UserInfo aUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            preStmt.setString(2, aUserInfo.getId().toString());
            preStmt.setInt(3, 4);
            preStmt.setString(4, aSCMBillBaseInfo.getId().toString());
            preStmt.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(preStmt, conn);
                SQLUtils.cleanup(sm, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)preStmt, (Connection)conn);
        SQLUtils.cleanup(sm, (Connection)conn);
    }

    protected void calculateBill(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        ICalculateFacade icf = CalculateFacadeFactory.getLocalInstance((Context)ctx);
        icf.calculate((CoreBillBaseInfo)aInvBillBaseInfo);
    }

    protected void rewriteVirtualBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvBillBaseInfo ibi = (InvBillBaseInfo)model;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            for (int i = 0; i < this.sepBillArray.size(); ++i) {
                HashMap map = (HashMap)this.sepBillArray.get(i);
                String orderCompanyOrgUnitID = map.get(PARAM_ORDCOMPANYORGUNIT).toString();
                String orderStorageOrgUnitID = map.get(PARAM_ORDSTORAGEORGUNIT).toString();
                String coreBillTableName = (String)this.billMap.get(PARAM_COREBILLTABLE);
                ICompanyOrgUnit icou = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("baseCurrency.precision"));
                CompanyOrgUnitInfo cou = icou.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orderCompanyOrgUnitID)), sic);
                CurrencyInfo ci = cou.getBaseCurrency();
                int localAmountPrecision = ci.getPrecision();
                stmt.execute(this.getRewriteSQL(coreBillTableName, ININV_COREBILLID_FIELD, TABLENAME_PURINENTRY, TABLENAME_PURIN, ININV_COREBILLENTRYID_FIELD, ibi.getId().toString(), localAmountPrecision, orderStorageOrgUnitID));
                stmt.execute(this.getRewriteSQL(coreBillTableName, OUTINV_COREBILLID_FIELD, TABLENAME_SALEISSUEENTRY, TABLENAME_SALEISSUE, OUTINV_COREBILLENTRYID_FIELD, ibi.getId().toString(), localAmountPrecision, orderStorageOrgUnitID));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    protected void checkRewriteVirtualBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvBillBaseInfo ibi = (InvBillBaseInfo)model;
        String msg = "";
        String strUnWriteOffQty = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"UnWriteOffQty", (Locale)ctx.getOriginLocale());
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            BigDecimal zero = new BigDecimal("0.00");
            rs = stmt.executeQuery(this.getCheckRewriteSQL(TABLENAME_PURIN, TABLENAME_PURINENTRY, ININV_COREBILLENTRYID_FIELD, ibi.getId().toString()));
            while (rs.next()) {
                if (rs.getBigDecimal("validQty").compareTo(zero) >= 0) continue;
                msg = msg + "\n" + rs.getString("number") + strUnWriteOffQty + ": " + SCMServerUtils.toPlainString((BigDecimal)rs.getBigDecimal("FUnWriteOffQty").abs()).toString();
            }
            if (msg.length() > 0) {
                Object[] msgs = new String[]{msg};
                throw new InvUpdateException(InvUpdateException.VIRTUALINBILLREVERSE, msgs);
            }
            rs = stmt.executeQuery(this.getCheckRewriteSQL(TABLENAME_SALEISSUE, TABLENAME_SALEISSUEENTRY, OUTINV_COREBILLENTRYID_FIELD, ibi.getId().toString()));
            while (rs.next()) {
                if (rs.getBigDecimal("validQty").compareTo(zero) >= 0) continue;
                msg = msg + "\n" + rs.getString("number") + strUnWriteOffQty + ": " + rs.getBigDecimal("FUnWriteOffQty").abs().toString();
            }
            if (msg.length() > 0) {
                Object[] msgs = new String[]{msg};
                throw new InvUpdateException(InvUpdateException.VIRTUALOUTBILLREVERSE, msgs);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    private String getCheckRewriteSQL(String tableHeadName, String tableName, String coreBillEntryName, String billID) {
        String sourceBillEntryTable = (String)this.billMap.get(PARAM_SOURCEENTRYTABLE);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" select c.fnumber as number,a.FUnWriteOffQty as FUnWriteOffQty, (a.FUnWriteOffQty - abs(b.FQty)) as validQty from ");
        stringBuffer.append(" (select FUnWriteOffQty,fmaterialid,FSourceBillEntryID from " + tableName + " a");
        stringBuffer.append(" inner join " + tableHeadName + " b on a.fparentid = b.fid where b.fisreversed = 0 and b.fnumber like '*%' and a.fsourcebillid = ");
        stringBuffer.append(" (select top 1 fsourcebillid from " + sourceBillEntryTable + " where fparentid = '" + billID + "') and fispresent = 0) a ");
        stringBuffer.append(" inner join (select FQty,FSourceBillEntryID, fid from " + sourceBillEntryTable + " where fparentid = '" + billID + "' and fispresent = 0) b ");
        stringBuffer.append(" on b.FSourceBillEntryID = a.FSourceBillEntryID");
        stringBuffer.append(" inner join t_bd_material c on a.fmaterialid = c.fid;");
        return stringBuffer.toString();
    }

    private String getRewriteSQL(String coreTableName, String coreBillField, String tableName, String headTableName, String coreBillEntryName, String billID, int localAmountPrecision, String orderStorageOrgUnitID) {
        String sourceBillEntryTable = (String)this.billMap.get(PARAM_SOURCEENTRYTABLE);
        String storageField = (String)this.billMap.get(PARAM_STORAGEFIELD);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" update " + tableName + " set (FReverseQty, FReverseBaseQty, FUnWriteOffQty, FUnWriteOffBaseQty,FUnWriteOffAmount,fassociateqty,FWrittenOffBaseQty,FWrittenOffQty,FWrittenOffAmount) = ");
        stringBuffer.append(" (select m.FReverseQty, m.FReverseBaseQty, m.FUnWriteOffQty, m.FUnWriteOffBaseQty,m.FUnWriteOffAmount,m.fassociateqty,m.FWrittenOffBaseQty,m.FWrittenOffQty,m.FWrittenOffAmount from (select a.fseq, fentryid,");
        stringBuffer.append(" (a.FReverseQty + abs(b.FQty)) as FReverseQty,");
        stringBuffer.append(" (a.FReverseBaseQty + abs(b.FBaseQty)) as FReverseBaseQty,");
        stringBuffer.append(" a.FQty - (a.FWrittenOffQty + abs(b.FQty)) as FUnWriteOffQty,");
        stringBuffer.append(" a.FBaseQty - (a.FWrittenOffBaseQty + abs(b.FBaseQty)) as FUnWriteOffBaseQty,");
        stringBuffer.append(" CASE WHEN a.FReverseQty + abs(b.FQty) = a.FQty THEN 0 ELSE ");
        stringBuffer.append(" a.FActualCost - round(decimal(a.FWrittenOffQty + abs(b.FQty),21,8) * a.FUnitActualCost, " + localAmountPrecision + ") ");
        stringBuffer.append(" END as FUnWriteOffAmount, ");
        stringBuffer.append("(a.fassociateqty - ABS(b.FBaseQty))  fassociateqty,");
        stringBuffer.append(" (a.FWrittenOffQty + abs(b.FQty)) as FWrittenOffQty,");
        stringBuffer.append(" (a.FWrittenOffBaseQty + abs(b.FBaseQty)) as FWrittenOffBaseQty,");
        stringBuffer.append(" CASE WHEN a.FReverseQty + abs(b.FQty) = a.FQty THEN a.FActualCost ELSE ");
        stringBuffer.append(" round(decimal(a.FWrittenOffQty + abs(b.FQty),21,8) * a.FUnitActualCost, " + localAmountPrecision + ") ");
        stringBuffer.append(" END as FWrittenOffAmount ");
        stringBuffer.append(" from (select fseq, FActualCost, FUnitActualCost, fassociateqty,FReverseQty, FReverseBaseQty, FUnWriteOffQty,FUnWriteOffBaseQty,FWrittenOffBaseQty,FWrittenOffQty,FWrittenOffAmount,FQty,FBaseQty,FAmount,fmaterialid,a.fid as fentryid,FSourceBillEntryID as FSourceBillEntryID from " + tableName + " a");
        stringBuffer.append(" inner join ");
        stringBuffer.append(headTableName);
        stringBuffer.append(" b on a.fparentid = b.fid inner join " + coreTableName + " d on a." + coreBillField + " = d.fid ");
        stringBuffer.append(" where (b.fisreversed = 0 or b.fisreversed is null) and b.fnumber like '*%' and d." + storageField + " = '");
        stringBuffer.append(orderStorageOrgUnitID);
        stringBuffer.append("' and a.fsourcebillid = ");
        stringBuffer.append(" (select top 1 fsourcebillid from ");
        stringBuffer.append(sourceBillEntryTable);
        stringBuffer.append(" where fparentid = '");
        stringBuffer.append(billID);
        stringBuffer.append("')) a ");
        stringBuffer.append(" inner join (select fseq, FQty,FBaseQty, FSourceBillEntryID");
        stringBuffer.append(",FUnitActualCost, fid from ");
        stringBuffer.append(sourceBillEntryTable);
        stringBuffer.append(" where fparentid = '");
        stringBuffer.append(billID);
        stringBuffer.append("') b ");
        stringBuffer.append(" on b.FSourceBillEntryID");
        stringBuffer.append(" = a.FSourceBillEntryID inner join t_bd_material c on a.fmaterialid = c.fid) ");
        stringBuffer.append(" m where ");
        stringBuffer.append(tableName);
        stringBuffer.append(".FID = m.fentryid and " + tableName + ".FIsPresent = 0);");
        return stringBuffer.toString();
    }

    protected void initBillMap(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String purInWarehsBosType = new PurInWarehsBillInfo().getBOSType().toString();
        this.billMap.put(PARAM_INVINBILLBOSTYPE, purInWarehsBosType);
        String saleIssueBosType = new SaleIssueBillInfo().getBOSType().toString();
        this.billMap.put(PARAM_INVOUTBILLBOSTYPE, saleIssueBosType);
        String purInWarehsEntryBosType = new PurInWarehsEntryInfo().getBOSType().toString();
        this.billMap.put(PARAM_INVINBILLENTRYBOSTYPE, purInWarehsEntryBosType);
        String saleIssueEntryBosType = new SaleIssueEntryInfo().getBOSType().toString();
        this.billMap.put(PARAM_INVOUTBILLENTRYBOSTYPE, saleIssueEntryBosType);
        InvBillBaseInfo ibb = (InvBillBaseInfo)model;
        InvBillBaseEntryInfo ibbe = (InvBillBaseEntryInfo)((IObjectCollection)ibb.get("entry")).getObject(0);
        String companyOrgUnitID = "";
        if (ibbe.getCompanyOrgUnit() != null) {
            companyOrgUnitID = ibbe.getCompanyOrgUnit().getId().toString();
            this.billMap.put(PARAM_INVCOMPANYORGUNIT, companyOrgUnitID);
        }
        String orgBillNumber = ibb.getNumber();
        this.billMap.put(PARAM_ORGBILLNUMBER, orgBillNumber);
        String orgBillID = ibb.getId().toString();
        this.billMap.put(PARAM_ORGBILLID, orgBillID);
        String bizTypeID = ibb.getBizType().getId().toString();
        this.billMap.put(PARAM_BIZTYPEID, bizTypeID);
        for (int i = 0; i < this.sepBillArray.size(); ++i) {
            HashMap map = (HashMap)this.sepBillArray.get(i);
            ICompanyOrgUnit icou = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("baseCurrency.precision"));
            CompanyOrgUnitInfo cou = icou.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK((String)map.get(PARAM_ORDCOMPANYORGUNIT)), sic);
            CurrencyInfo ci = cou.getBaseCurrency();
            int localAmountPrecision = ci.getPrecision();
            map.put(PARAM_LOCALAMOUNTPRECISION, new Integer(localAmountPrecision));
            CurrencyInfo currency = (CurrencyInfo)map.get(PARAM_CURRENCY);
            map.put(PARAM_AMOUNTPRECISION, new Integer(currency.getPrecision()));
            if (map.get(PARAM_WAREHOUSE) == null) {
                String warehouseID = null;
                ISOAccreditWH iso = SOAccreditWHFactory.getLocalInstance((Context)ctx);
                WarehouseInfo warehouseInfo = iso.getDefaultWarehouse((String)map.get(PARAM_ORDSTORAGEORGUNIT), true, true);
                if (warehouseInfo == null) {
                    throw new InvBizException(InvBizException.NOWAREHOUSEINVIRTUALBILL);
                }
                warehouseID = warehouseInfo.getId().toString();
                map.put(PARAM_WAREHOUSE, warehouseID);
                String stockerID = "";
                if (warehouseInfo != null && warehouseInfo.getWhman() != null) {
                    stockerID = warehouseInfo.getWhman().getId().toString();
                }
                map.put(PARAM_STOCKER, stockerID);
            }
            String costInFid = BOSUuid.create((String)purInWarehsBosType).toString();
            map.put(PARAM_COSTINBILLID, costInFid);
            String costOutFid = BOSUuid.create((String)saleIssueBosType).toString();
            map.put(PARAM_COSTOUTBILLID, costOutFid);
            map.put(PARAM_COSTINBILLNUMBER, "*" + i + orgBillNumber);
            map.put(PARAM_COSTOUTBILLNUMBER, "**" + i + orgBillNumber);
            this.sepBillArray.set(i, map);
        }
    }

    protected String getUpdateStandardCostSQL(String virtualBillID, String tableName, Map map, boolean isInWhBill) {
        int localAmountPrecision = (Integer)map.get(PARAM_LOCALAMOUNTPRECISION);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" update " + tableName);
        stringBuffer.append(" set (FUnitStandardCost, FStandardCost ");
        if (!isInWhBill) {
            stringBuffer.append(", FUnitActualCost, FActualCost, FUnWriteOffAmount ");
        }
        stringBuffer.append(") =");
        stringBuffer.append(" (select m.FUnitStandardCost, m.FStandardCost");
        if (!isInWhBill) {
            stringBuffer.append(",m.FUnitStandardCost, m.FStandardCost, m.FStandardCost");
        }
        stringBuffer.append(" from (");
        stringBuffer.append(" SELECT e.fid as FEntryID,d.funitstandardcost as FUnitStandardCost,");
        stringBuffer.append(" round(decimal(d.funitstandardcost*e.fqty,17,4), " + localAmountPrecision + ") as FStandardCost");
        stringBuffer.append(" FROM (SELECT a.fmaterialid as fmaterialid, a.fcompanyid as fcompanyorgunitid, c.fmeasureunitid as fmeasureunitid, ");
        stringBuffer.append(" round(decimal(a.fstandardcost * c.fbaseconvsrate, 21,8),b.fpriceprecision) as funitstandardcost");
        stringBuffer.append(" FROM t_bd_materialcompanyinfo a, t_bd_material b, t_bd_multimeasureunit c ");
        stringBuffer.append(" WHERE (((a.fmaterialid = b.fid AND b.fid = c.fmaterialid) AND a.fmaterialid = c.fmaterialid) AND a.faccounttype = 2)) d ");
        stringBuffer.append(" inner JOIN (select fid,fmaterialid,fcompanyorgunitid,funitid,fqty from " + tableName);
        stringBuffer.append(" where fparentid = '" + virtualBillID + "') e ");
        stringBuffer.append(" ON d.fmaterialid = e.fmaterialid and d.fcompanyorgunitid = e.fcompanyorgunitid");
        stringBuffer.append(" and d.fmeasureunitid = e.funitid) m");
        stringBuffer.append(" where " + tableName + ".fid = m.FEntryID)");
        return stringBuffer.toString();
    }

    protected String getCostInHeadSql(Map map) {
        String orderStorageOrgUnitID = (String)map.get(PARAM_ORDSTORAGEORGUNIT);
        String costInFid = (String)map.get(PARAM_COSTINBILLID);
        String number = (String)map.get(PARAM_COSTINBILLNUMBER);
        String orgBillID = (String)this.billMap.get(PARAM_ORGBILLID);
        String transType = (String)this.billMap.get(COSTINTRANSTYPE);
        String bizTypeID = (String)this.billMap.get(PARAM_BIZTYPEID);
        String sourceBillTable = (String)this.billMap.get(PARAM_SOURCEBILLTABLE);
        String coreBillTable = (String)this.billMap.get(PARAM_COREBILLTABLE);
        String sourceBillEntryTable = (String)this.billMap.get(PARAM_SOURCEENTRYTABLE);
        String coreBillIDField = (String)this.billMap.get(PARAM_COREBILLIDFIELD);
        String supplierSql = (String)this.billMap.get(PARAM_SUPPLIERSQL);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" INSERT INTO T_IM_PurInWarehsBill (");
        stringBuffer.append(" FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, ");
        stringBuffer.append(" FNumber, ");
        stringBuffer.append(" FBizDate, FHandlerID, FDescription, FHasEffected, FAuditorID, ");
        stringBuffer.append(" FSourceBillID, FAuditTime, FBaseStatus, FBizTypeID, ");
        stringBuffer.append(" FSourceBillTypeID, FBillTypeID, FYear, FPeriod, ");
        stringBuffer.append(" FStorageOrgUnitID, ");
        stringBuffer.append(" FStockerID, FTotalQty, FTotalAmount,FTotalLocalAmount, ");
        stringBuffer.append(" FTotalStandardCost, FTotalActualCost, ");
        stringBuffer.append(" FTransactionTypeID, ");
        stringBuffer.append(" FSupplierID, FCurrencyID, FReceiptAmount, FExchangeRate, ");
        stringBuffer.append(" FPaymentTypeID, FConvertMode, ");
        stringBuffer.append(" FIsReversed, FFiVouchered, FIsSysBill");
        stringBuffer.append(" ,FPurchaseType");
        stringBuffer.append(" ,FIsInTax, FIsPriceInTax ");
        stringBuffer.append(" )");
        stringBuffer.append(" SELECT distinct ");
        stringBuffer.append("'" + costInFid + "' as fid, ");
        stringBuffer.append(" sbt.FAuditorID as FCreatorID, sbt.FAuditTime as FLastUpdateUserID, sbt.FLastUpdateUserID, sbt.FLastUpdateTime, sbt.FControlUnitID, ");
        stringBuffer.append("'" + number + "' as fnumber, ");
        stringBuffer.append(" sbt.FBizDate, sbt.FHandlerID, sbt.FDescription, sbt.FHasEffected, sbt.FAuditorID, ");
        stringBuffer.append(" sbt.FID as FSourceBillID, GETDATE() as FAuditTime, 4 as FBaseStatus, '" + bizTypeID + "' as FBizTypeID, ");
        stringBuffer.append(" sbt.FBillTypeID as FSourceBillTypeID, '");
        stringBuffer.append("50957179-0105-1000-e000-015fc0a812fd463ED552");
        stringBuffer.append("' as FBillTypeID, sbt.FYear, sbt.FPeriod, ");
        stringBuffer.append("'" + orderStorageOrgUnitID + "', ");
        stringBuffer.append(" sbt.FStockerID, sbt.FTotalQty, ");
        stringBuffer.append(" (SELECT ISNULL(SUM(FAmount),0) FROM t_im_purinwarehsentry WHERE FParentID = '" + costInFid + "'),");
        stringBuffer.append(" (SELECT ISNULL(SUM(FLocalAmount),0) FROM t_im_purinwarehsentry WHERE FParentID = '" + costInFid + "'),");
        stringBuffer.append(" (SELECT ISNULL(SUM(FStandardCost),0) FROM t_im_purinwarehsentry WHERE FParentID = '" + costInFid + "'),");
        stringBuffer.append(" (SELECT ISNULL(SUM(FActualCost),0) FROM t_im_purinwarehsentry WHERE FParentID = '" + costInFid + "'),");
        stringBuffer.append("'" + transType + "', ");
        if (supplierSql.length() < 15) {
            supplierSql = "sbt." + supplierSql;
        }
        stringBuffer.append(supplierSql);
        stringBuffer.append(", sbt.FCurrencyID, 0, d.FExchangeRate, ");
        stringBuffer.append(" sbt.FPaymentTypeID, sbt.FConvertMode, ");
        stringBuffer.append(" 0, 0, 1 ");
        stringBuffer.append(",0");
        if (TABLENAME_PURIN.equals(sourceBillTable)) {
            stringBuffer.append(" ,sbt.FIsInTax, sbt.FIsPriceInTax ");
        } else {
            stringBuffer.append(" ,1, 1 ");
        }
        stringBuffer.append(" FROM ").append(sourceBillTable);
        stringBuffer.append(" sbt inner join ").append(sourceBillEntryTable);
        stringBuffer.append(" entry on entry.fparentid = sbt.fid inner join ").append(coreBillTable);
        stringBuffer.append(" d on d.fid = entry.").append(coreBillIDField);
        stringBuffer.append(" WHERE sbt.FID = '").append(orgBillID).append("';");
        return stringBuffer.toString();
    }

    protected String getCostInEntrySql(Map map) {
        String pouId = (String)map.get(PARAM_VIRTUALPURORGUNIT);
        String orderStorageOrgUnitID = (String)map.get(PARAM_ORDSTORAGEORGUNIT);
        String orderCompanyOrgUnitID = (String)map.get(PARAM_ORDCOMPANYORGUNIT);
        String costInFid = (String)map.get(PARAM_COSTINBILLID);
        String warehouseID = (String)map.get(PARAM_WAREHOUSE);
        String stockerID = (String)map.get(PARAM_STOCKER);
        int localAmountPrecision = (Integer)map.get(PARAM_LOCALAMOUNTPRECISION);
        int amountPrecision = (Integer)map.get(PARAM_AMOUNTPRECISION);
        BigDecimal exchangeRate = (BigDecimal)this.billMap.get(PARAM_EXCHANGERATE);
        String orgBillNumber = (String)this.billMap.get(PARAM_ORGBILLNUMBER);
        String orgBillID = (String)this.billMap.get(PARAM_ORGBILLID);
        String InvInBillEntryBosType = (String)this.billMap.get(PARAM_INVINBILLENTRYBOSTYPE);
        String sourceBillEntryTable = (String)this.billMap.get(PARAM_SOURCEENTRYTABLE);
        String sourceBillTable = (String)this.billMap.get(PARAM_SOURCEBILLTABLE);
        String coreBillIDField = (String)this.billMap.get(PARAM_COREBILLIDFIELD);
        String coreBillEntryIDField = (String)this.billMap.get(PARAM_COREBILLENTRYIDFIELD);
        String coreBillNumber = (String)this.billMap.get(PARAM_COREBILLNUMBER);
        String coreBillSeqNo = (String)this.billMap.get(PARAM_COREBILLSEQNO);
        String coreBillTable = (String)this.billMap.get(PARAM_COREBILLTABLE);
        String coreBillEntryTable = (String)this.billMap.get(PARAM_COREBILLENTRYTABLE);
        String storageField = (String)this.billMap.get(PARAM_STORAGEFIELD);
        String balanceSupplierSql = (String)this.billMap.get(PARAM_BALANCESUPPLIERSQL);
        String receiveSouId = (String)this.billMap.get(PARAM_VIRTUALRECEIVEORGUNIT);
        String costInPrice = (String)this.billMap.get(COSTIN_PRICE);
        String costInTaxPrice = (String)this.billMap.get(COSTIN_TAXPRICE);
        String costInTaxRate = (String)this.billMap.get(COSTIN_TAXRATE);
        String costInDiscountRate = (String)this.billMap.get(COSTIN_DISCOUNTRATE);
        String costInAmount = (String)this.billMap.get(COSTIN_AMOUNT);
        String costInUnitActualCost = (String)this.billMap.get(COSTIN_UNITACTUALCOST);
        String costInActualCost = (String)this.billMap.get(COSTIN_ACTUALCOST);
        String costInUnWriteOffAmount = (String)this.billMap.get(COSTIN_UNWRITEOFFAMOUNT);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" INSERT INTO t_im_purinwarehsentry");
        stringBuffer.append(" (");
        stringBuffer.append(" FID, FSeq, FSourceBillId, FSourceBillNumber, FSourceBillTypeID, ");
        stringBuffer.append(" FSourceBillEntryId, FSourceBillEntrySeq, FAssCoefficient, FBaseStatus, FMaterialID, ");
        stringBuffer.append(" FUnitID, FBaseUnitID, FAssistUnitID, FReasonCodeID, ");
        stringBuffer.append(" FStorageOrgUnitID, FCompanyOrgUnitID, FPurchaseOrgUnitID,FReceiveStorageOrgUnitID, ");
        stringBuffer.append(" FLot, FQty, FAssistQty, FBaseQty, ");
        stringBuffer.append(" FPrice, ");
        stringBuffer.append(" FAmount, ");
        stringBuffer.append(" FUnitStandardCost, FStandardCost, ");
        stringBuffer.append(" FUnitActualCost, ");
        stringBuffer.append(" FActualCost, ");
        stringBuffer.append(" FIsPresent, FParentID, FPurOrderID, FPurOrderEntryID,");
        stringBuffer.append(" FUnWriteOffQty, ");
        stringBuffer.append(" FUnWriteOffAmount, ");
        stringBuffer.append(" FReceiveAmount, FPurOrderNumber, ");
        stringBuffer.append(" FPurOrderEntrySeq, FTaxRate, FTax, ");
        stringBuffer.append(" FLocalPrice, ");
        stringBuffer.append(" FAssistPropertyID, FMfg, FExp, FRemark, ");
        stringBuffer.append(" FUnWriteOffBaseQty, ");
        stringBuffer.append(" FCoreBillTypeID, FOrderPrice, FTaxPrice, FActualPrice, FWarehouseID, FStockerID, FAssociateQty,FReverseQty, FUnReturnedBaseQty, FBalanceSupplierID");
        stringBuffer.append(",FUnitPurchaseCost,FPurchaseCost,FPurchaseFee,FTaxAmount,FLocalTaxAmount,FActualTaxPrice,FDiscountRate,FDiscountAmount ");
        stringBuffer.append(" )");
        stringBuffer.append(" SELECT ");
        stringBuffer.append("NEWBOSID('" + InvInBillEntryBosType + "'),");
        stringBuffer.append(" a.FSeq, a.FParentID,");
        stringBuffer.append("'" + orgBillNumber + "', ");
        stringBuffer.append("'50957179-0105-1000-e000-015fc0a812fd463ED552', ");
        stringBuffer.append(" a.FID, a.FSeq, a.FAssCoefficient, a.FBaseStatus, a.FMaterialID, ");
        stringBuffer.append(" a.FUnitID, a.FBaseUnitID, a.FAssistUnitID, a.FReasonCodeID, ");
        stringBuffer.append("'" + orderStorageOrgUnitID + "',");
        stringBuffer.append("'" + orderCompanyOrgUnitID + "',");
        stringBuffer.append(pouId == null ? "null," : "'" + pouId + "',");
        stringBuffer.append(receiveSouId + ",");
        stringBuffer.append(" a.FLot, a.FQty, a.FAssistQty, a.FBaseQty, ");
        stringBuffer.append("isnull(" + costInPrice + ",0),");
        stringBuffer.append(" round(" + costInAmount + "," + amountPrecision + "), ");
        stringBuffer.append(" a.FUnitStandardCost, a.FStandardCost, ");
        stringBuffer.append("round(" + costInUnitActualCost + ",c.FPricePrecision),");
        stringBuffer.append("round(" + costInActualCost + "," + localAmountPrecision + "),");
        stringBuffer.append(" a.FIsPresent, ");
        stringBuffer.append("'" + costInFid + "', ");
        stringBuffer.append(" a." + coreBillIDField + ", a." + coreBillEntryIDField + ",");
        stringBuffer.append(" a.FQty, ");
        stringBuffer.append("round(" + costInUnWriteOffAmount + "," + localAmountPrecision + ")");
        stringBuffer.append(" ,0, a." + coreBillNumber + ", ");
        stringBuffer.append(" a." + coreBillSeqNo + "," + this.billMap.get(COSTIN_TAXRATE) + ",");
        stringBuffer.append(" round(" + this.billMap.get(COSTIN_TAX) + "," + amountPrecision + "), ");
        stringBuffer.append(" round(" + costInPrice + " * " + exchangeRate + ", c.FPricePrecision), ");
        stringBuffer.append(" a.FAssistPropertyID, a.FMfg, a.FExp, a.FRemark, ");
        stringBuffer.append(" a.FBaseQty, ");
        stringBuffer.append(" a.FCoreBillTypeID, a.FOrderPrice,");
        stringBuffer.append(" round(").append(costInTaxPrice).append(",c.FPricePrecision),");
        stringBuffer.append(" round(").append(this.billMap.get(COSTIN_ACTUALPRICE)).append(",c.FPricePrecision),");
        String warehouseSql = null;
        String stockerSql = null;
        warehouseSql = warehouseID.length() > 0 ? "'" + warehouseID + "'" : "null";
        stockerSql = stockerID.length() > 0 ? "'" + stockerID + "'" : "null";
        if (this.isTransferProcess()) {
            if (TABLENAME_PURIN.equalsIgnoreCase(sourceBillTable)) {
                stringBuffer.append("isnull(b.FRequireWarehouseID,").append(warehouseSql).append("),");
                stringBuffer.append("case b.FRequireWarehouseID when null then ").append(stockerSql).append(" else wh.FWhmanID end,");
            } else if (TABLENAME_SALEISSUE.equalsIgnoreCase(sourceBillTable)) {
                stringBuffer.append("isnull(b.FSupplyWarehouseID,").append(warehouseSql).append("),");
                stringBuffer.append("case b.FSupplyWarehouseID when null then ").append(stockerSql).append(" else wh.FWhmanID end,");
            } else {
                stringBuffer.append(warehouseSql).append(",");
                stringBuffer.append(stockerSql).append(",");
            }
        } else {
            stringBuffer.append(warehouseSql).append(",");
            stringBuffer.append(stockerSql).append(",");
        }
        stringBuffer.append("a.FAssociateQty,a.FReverseQty,a.FBaseQty,");
        stringBuffer.append(balanceSupplierSql);
        if (sourceBillEntryTable.equals(TABLENAME_SALEISSUEENTRY) || sourceBillEntryTable.equals(TABLENAME_PURINENTRY)) {
            stringBuffer.append(", round(").append(this.billMap.get(COSTIN_UNITPURCHASECOST)).append("\r\n");
            stringBuffer.append(",c.FPricePrecision),").append("\r\n");
            stringBuffer.append("round(").append(this.billMap.get(COSTIN_PURCHASECOST)).append("\r\n");
            stringBuffer.append(",").append(localAmountPrecision).append("\r\n");
            stringBuffer.append("),").append("\r\n");
            stringBuffer.append("round(").append(this.billMap.get(COSTIN_PURCHASEFEE)).append("\r\n");
            stringBuffer.append(",").append(localAmountPrecision).append("\r\n");
            stringBuffer.append(")").append("\r\n");
        } else {
            stringBuffer.append(",0.00,0.00,0.00 ");
        }
        stringBuffer.append(", round(" + this.billMap.get(COSTIN_TAXAMOUNT) + "," + amountPrecision + "), ");
        stringBuffer.append(" round(" + this.billMap.get(COSTIN_LOCALTAXAMOUNT) + "," + localAmountPrecision + "), ");
        stringBuffer.append("round(" + this.billMap.get(COSTIN_ACTUALTAXPRICE) + ",c.FPricePrecision),");
        stringBuffer.append(this.billMap.get(COSTIN_DISCOUNTRATE) + ",");
        stringBuffer.append(" round(" + this.billMap.get(COSTIN_DISCOUNTAMOUNT) + "," + amountPrecision + ") ");
        stringBuffer.append(" FROM " + sourceBillEntryTable + " a INNER JOIN " + coreBillEntryTable + " b ");
        stringBuffer.append(" ON a." + coreBillEntryIDField + " = b.FID");
        stringBuffer.append(" inner join " + coreBillTable + " d ");
        stringBuffer.append(" ON a." + coreBillIDField + " = d.FID");
        stringBuffer.append(" inner join " + sourceBillTable + " e");
        stringBuffer.append(" on a.fparentid = e.fid");
        stringBuffer.append(" INNER JOIN T_BD_Material c");
        stringBuffer.append(" ON a.FMaterialID = c.FID");
        stringBuffer.append(" inner join t_org_company comp on comp.FID='").append(orderCompanyOrgUnitID).append("'");
        stringBuffer.append(" inner join t_bd_currency lcur on lcur.FID=comp.FBaseCurrencyID");
        stringBuffer.append(" inner join t_bd_currency cur on cur.FID='").append(((CurrencyInfo)map.get(PARAM_CURRENCY)).getId().toString()).append("'");
        if (this.isTransferProcess()) {
            if (TABLENAME_PURIN.equalsIgnoreCase(sourceBillTable)) {
                stringBuffer.append(" left join T_DB_WAREHOUSE wh on wh.fid=b.FRequireWarehouseID");
            } else if (TABLENAME_SALEISSUE.equalsIgnoreCase(sourceBillTable)) {
                stringBuffer.append(" left join T_DB_WAREHOUSE wh on wh.fid=b.FSupplyWarehouseID");
            }
        }
        stringBuffer.append(" WHERE a.FParentID = '" + orgBillID + "'");
        stringBuffer.append(" and d." + storageField + " = '" + orderStorageOrgUnitID + "'");
        if (this.isTransferProcess()) {
            stringBuffer.append(";");
        } else {
            stringBuffer.append(" and (a.FISCENTERBALANCE = 1  and a.FISBETWEENCOMPANYSEND = 1);");
        }
        stringBuffer.append("update ").append(TABLENAME_PURINENTRY).append(" set ");
        stringBuffer.append(" FLocalTax=round(ftax*" + exchangeRate + "," + localAmountPrecision + "),");
        stringBuffer.append(" FLocalAmount=round(decimal(FPrice*fqty,17,4) * " + exchangeRate + ", " + localAmountPrecision + ") ");
        stringBuffer.append(" where fsourcebillentryid in (select fid from ").append(sourceBillEntryTable);
        stringBuffer.append(" where fparentid='" + orgBillID + "');");
        return stringBuffer.toString();
    }

    private boolean isTransferProcess() {
        return ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(this.billMap.get(PARAM_BIZTYPEID)) || "LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(this.billMap.get(PARAM_BIZTYPEID))) && "T_IM_TransferOrderBill".equalsIgnoreCase((String)this.billMap.get(PARAM_COREBILLTABLE));
    }

    private boolean isSaleIssueProcess() {
        return "T_IM_SaleIssueBill".equalsIgnoreCase((String)this.billMap.get(PARAM_SOURCEBILLTABLE));
    }

    protected String getCostOutHeadSql(Map map) {
        String costOutFid = (String)map.get(PARAM_COSTOUTBILLID);
        String orderStorageOrgUnitID = (String)map.get(PARAM_ORDSTORAGEORGUNIT);
        String number = (String)map.get(PARAM_COSTOUTBILLNUMBER);
        String transType = (String)this.billMap.get(COSTOUTTRANSTYPE);
        String orgBillID = (String)this.billMap.get(PARAM_ORGBILLID);
        String bizTypeID = (String)this.billMap.get(PARAM_BIZTYPEID);
        String sourceBillTable = (String)this.billMap.get(PARAM_SOURCEBILLTABLE);
        String coreBillTable = (String)this.billMap.get(PARAM_COREBILLTABLE);
        String coreBillIDField = (String)this.billMap.get(PARAM_COREBILLIDFIELD);
        String sourceBillEntryTable = (String)this.billMap.get(PARAM_SOURCEENTRYTABLE);
        String customerSql = (String)this.billMap.get(PARAM_CUSTOMERSQL);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" INSERT INTO T_IM_SaleIssueBill(");
        stringBuffer.append(" FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, ");
        stringBuffer.append(" FNumber, ");
        stringBuffer.append(" FActBizDate, ");
        stringBuffer.append(" FBizDate, FHandlerID, FDescription, FHasEffected, FAuditorID, ");
        stringBuffer.append(" FSourceBillID, FAuditTime, FBaseStatus, FBizTypeID, ");
        stringBuffer.append(" FSourceBillTypeID, ");
        stringBuffer.append(" FBillTypeID, ");
        stringBuffer.append(" FYear, FPeriod, ");
        stringBuffer.append(" FStorageOrgUnitID, ");
        stringBuffer.append(" FStockerID, ");
        stringBuffer.append(" FTotalQty, FTotalAmount,FTotalLocalAmount, FTotalStandardCost, ");
        stringBuffer.append(" FTotalActualCost,  ");
        stringBuffer.append(" FTransactionTypeID, ");
        stringBuffer.append(" FCustomerID, ");
        stringBuffer.append(" FCurrencyID, FExchangeRate, FPaymentTypeID, FConvertMode, ");
        stringBuffer.append(this.getCostOutHeadSql());
        stringBuffer.append(" FIsReversed, FFiVouchered, FIsSysBill");
        stringBuffer.append(" )");
        stringBuffer.append(" SELECT distinct ");
        stringBuffer.append("'" + costOutFid + "' ,");
        stringBuffer.append(" sbt.FAuditorID, sbt.FAuditTime, sbt.FLastUpdateUserID, sbt.FLastUpdateTime, sbt.FControlUnitID, ");
        stringBuffer.append("'" + number + "', ");
        if (this.isSaleIssueProcess()) {
            stringBuffer.append(" sbt.FActBizDate, ");
        } else {
            stringBuffer.append(" sbt.FBizDate, ");
        }
        stringBuffer.append(" sbt.FBizDate, sbt.FHandlerID, sbt.FDescription, sbt.FHasEffected, sbt.FAuditorID, ");
        stringBuffer.append(" sbt.FID, ADD_SECONDS(GETDate(), 5), 4, '" + bizTypeID + "', ");
        stringBuffer.append(" sbt.FBillTypeID, ");
        stringBuffer.append("'50957179-0105-1000-e000-015bc0a812fd463ED552', ");
        stringBuffer.append(" sbt.FYear, sbt.FPeriod, ");
        stringBuffer.append("'" + orderStorageOrgUnitID + "', ");
        stringBuffer.append(" sbt.FStockerID, ");
        stringBuffer.append(" sbt.FTotalQty, ");
        stringBuffer.append(" (SELECT ISNULL(SUM(FAmount),0) FROM t_im_saleissueentry WHERE FParentID = '" + costOutFid + "'),");
        stringBuffer.append(" (SELECT ISNULL(SUM(FLocalAmount),0) FROM t_im_saleissueentry WHERE FParentID = '" + costOutFid + "'),");
        stringBuffer.append(" (SELECT ISNULL(SUM(FStandardCost),0) FROM t_im_purinwarehsentry WHERE FParentID = '" + costOutFid + "'),");
        stringBuffer.append(" (SELECT ISNULL(SUM(FActualCost),0) FROM t_im_saleissueentry WHERE FParentID = '" + costOutFid + "'),");
        stringBuffer.append("'" + transType + "',  ");
        stringBuffer.append(customerSql + ",");
        stringBuffer.append(" sbt.FCurrencyID, d.FExchangeRate, sbt.FPaymentTypeID, sbt.FConvertMode, ");
        stringBuffer.append(this.getCostOutHeadSql());
        stringBuffer.append(" 0,0,1");
        stringBuffer.append(" FROM ").append(sourceBillTable);
        stringBuffer.append(" sbt inner join ").append(sourceBillEntryTable);
        stringBuffer.append(" entry on entry.fparentid = sbt.fid inner join ").append(coreBillTable);
        stringBuffer.append(" d on d.fid = entry.").append(coreBillIDField);
        stringBuffer.append(" WHERE sbt.FID = '").append(orgBillID).append("';");
        return stringBuffer.toString();
    }

    protected String getCostOutEntrySql(Map map) {
        String sourceBillTable = (String)this.billMap.get(PARAM_SOURCEBILLTABLE);
        String saleOrgUnitId = (String)map.get(PARAM_VIRTUALSALEORGUNIT);
        String orderStorageOrgUnitID = (String)map.get(PARAM_ORDSTORAGEORGUNIT);
        String orderCompanyOrgUnitID = (String)map.get(PARAM_ORDCOMPANYORGUNIT);
        String costOutFid = (String)map.get(PARAM_COSTOUTBILLID);
        String warehouseID = (String)map.get(PARAM_WAREHOUSE);
        String stockerID = (String)map.get(PARAM_STOCKER);
        int localAmountPrecision = (Integer)map.get(PARAM_LOCALAMOUNTPRECISION);
        int amountPrecision = (Integer)map.get(PARAM_AMOUNTPRECISION);
        BigDecimal exchangeRate = (BigDecimal)this.billMap.get(PARAM_EXCHANGERATE);
        String orgBillNumber = (String)this.billMap.get(PARAM_ORGBILLNUMBER);
        String orgBillID = (String)this.billMap.get(PARAM_ORGBILLID);
        String InvOutBillEntryBosType = (String)this.billMap.get(PARAM_INVOUTBILLENTRYBOSTYPE);
        String sourceBillEntryTable = (String)this.billMap.get(PARAM_SOURCEENTRYTABLE);
        String coreBillIDField = (String)this.billMap.get(PARAM_COREBILLIDFIELD);
        String coreBillEntryIDField = (String)this.billMap.get(PARAM_COREBILLENTRYIDFIELD);
        String coreBillNumber = (String)this.billMap.get(PARAM_COREBILLNUMBER);
        String coreBillSeqNo = (String)this.billMap.get(PARAM_COREBILLSEQNO);
        String coreBillTable = (String)this.billMap.get(PARAM_COREBILLTABLE);
        String coreBillEntryTable = (String)this.billMap.get(PARAM_COREBILLENTRYTABLE);
        String storageField = (String)this.billMap.get(PARAM_STORAGEFIELD);
        String balanceCustomerSql = (String)this.billMap.get(PARAM_BALANCECUSTOMERSQL);
        String costOutPrice = (String)this.billMap.get(COSTOUT_PRICE);
        String costOutAmount = (String)this.billMap.get(COSTOUT_AMOUNT);
        String costOutUnitActualCost = (String)this.billMap.get(COSTOUT_UNITACTUALCOST);
        String costOutActualCost = (String)this.billMap.get(COSTOUT_ACTUALCOST);
        String costOutUnWriteOffAmount = (String)this.billMap.get(COSTOUT_UNWRITEOFFAMOUNT);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" INSERT INTO t_im_saleissueentry(");
        stringBuffer.append(" FID, FSeq, FSourceBillId, FSourceBillNumber, FSourceBillTypeID, ");
        stringBuffer.append(" FSourceBillEntryId, FSourceBillEntrySeq, FAssCoefficient, FBaseStatus, FMaterialID, ");
        stringBuffer.append(" FUnitID, FBaseUnitID, FAssistUnitID, FReasonCodeID, FAssociateQty, ");
        stringBuffer.append(" FStorageOrgUnitID, FCompanyOrgUnitID, FSaleOrgUnitID, ");
        if (this.isTransferProcess()) {
            stringBuffer.append(" FQty, FAssistQty, FBaseQty,");
        } else {
            stringBuffer.append(" FLot, FQty, FAssistQty, FBaseQty,");
        }
        stringBuffer.append(" FReverseQty,FPrice, FAmount, ");
        stringBuffer.append(" FIsPresent, ");
        stringBuffer.append(" FParentID,");
        stringBuffer.append(" FUnWriteOffQty, ");
        stringBuffer.append(" FUnWriteOffAmount, ");
        stringBuffer.append(" FTaxRate, FTax, ");
        stringBuffer.append(" FLocalTax, FLocalPrice, FLocalAmount, FNonTaxAmount, FLocalNonTaxAmount, ");
        stringBuffer.append(" FAssistPropertyID, FMfg, FExp, FRemark, ");
        stringBuffer.append(" FUnWriteOffBaseQty, ");
        stringBuffer.append(" FCoreBillTypeID, FOrderPrice, FTaxPrice, FActualPrice, FWarehouseID, FStockerID,");
        stringBuffer.append(" FSaleOrderNumber, FSaleOrderEntrySeq, FSaleOrderID, FSaleOrderEntryID,");
        stringBuffer.append(" FUnitStandardCost, FStandardCost, ");
        stringBuffer.append(" FUnitActualCost, ");
        stringBuffer.append(" FActualCost, ");
        stringBuffer.append(this.getCostOutEntrySql());
        stringBuffer.append(" FBalanceCustomerID)");
        stringBuffer.append(" SELECT ");
        stringBuffer.append("NEWBOSID('" + InvOutBillEntryBosType + "'),");
        stringBuffer.append("a.FSeq, a.FParentID, ");
        stringBuffer.append("'" + orgBillNumber + "', ");
        stringBuffer.append("'50957179-0105-1000-e000-015bc0a812fd463ED552', ");
        stringBuffer.append(" a.FID, a.FSeq, a.FAssCoefficient, a.FBaseStatus, a.FMaterialID, ");
        stringBuffer.append(" a.FUnitID, a.FBaseUnitID, a.FAssistUnitID, a.FReasonCodeID, a.FAssociateQty, ");
        stringBuffer.append("'" + orderStorageOrgUnitID + "',");
        stringBuffer.append("'" + orderCompanyOrgUnitID + "',");
        stringBuffer.append(saleOrgUnitId == null ? "null," : "'" + saleOrgUnitId + "',");
        if (this.isTransferProcess()) {
            stringBuffer.append(" a.FQty, a.FAssistQty, a.FBaseQty,");
        } else {
            stringBuffer.append(" a.FLot, a.FQty, a.FAssistQty, a.FBaseQty,");
        }
        stringBuffer.append("0,round(" + costOutPrice + ",c.FPricePrecision),");
        stringBuffer.append("round(" + costOutAmount + "," + amountPrecision + "),");
        stringBuffer.append(" a.FIsPresent, ");
        stringBuffer.append("'" + costOutFid + "', ");
        stringBuffer.append(" a.FQty, ");
        stringBuffer.append("round(" + costOutUnWriteOffAmount + "," + localAmountPrecision + "),");
        stringBuffer.append(" a.FTaxRate, ");
        stringBuffer.append(" round(decimal(" + costOutAmount + ",17,4) * (decimal(a.FTaxRate/100,21,8)) /(1+ decimal(a.FTaxRate/100,21,8))," + amountPrecision + "),");
        stringBuffer.append(" round(decimal(" + costOutAmount + ",17,4) * " + exchangeRate + " * (decimal(a.FTaxRate/100,21,8))/(1+ decimal(a.FTaxRate/100,21,8)), " + localAmountPrecision + "), ");
        stringBuffer.append(" round(" + costOutPrice + " * " + exchangeRate + ", c.FPricePrecision), ");
        stringBuffer.append(" round(decimal(" + costOutAmount + ",17,4) * " + exchangeRate + ", " + localAmountPrecision + "), ");
        stringBuffer.append(" round(decimal(" + costOutAmount + ",17,4)/(1+ decimal(a.FTaxRate/100,21,8))," + amountPrecision + "),");
        stringBuffer.append(" round((decimal(" + costOutAmount + ",17,4) * " + exchangeRate + ")/(1+ decimal(a.FTaxRate/100,21,8)), " + localAmountPrecision + "), ");
        stringBuffer.append(" a.FAssistPropertyID, a.FMfg, a.FExp, a.FRemark, ");
        stringBuffer.append(" a.FBaseQty, ");
        stringBuffer.append(" a.FCoreBillTypeID, a.FOrderPrice, a.FTaxPrice, a.FActualPrice,");
        String warehouseSql = null;
        String stockerSql = null;
        warehouseSql = warehouseID.length() > 0 ? "'" + warehouseID + "'" : "null";
        stockerSql = stockerID.length() > 0 ? "'" + stockerID + "'" : "null";
        if (this.isTransferProcess()) {
            if (TABLENAME_PURIN.equalsIgnoreCase(sourceBillTable)) {
                stringBuffer.append("isnull(b.FRequireWarehouseID,").append(warehouseSql).append("),");
                stringBuffer.append(" case b.FRequireWarehouseID when null then ").append(stockerSql).append(" else wh.FWhmanID end,");
            } else if (TABLENAME_SALEISSUE.equalsIgnoreCase(sourceBillTable)) {
                stringBuffer.append("isnull(b.FSupplyWarehouseID,").append(warehouseSql).append("),");
                stringBuffer.append(" case b.FSupplyWarehouseID when null then ").append(stockerSql).append(" else wh.FWhmanID end,");
            } else {
                stringBuffer.append(warehouseSql).append(",");
                stringBuffer.append(stockerSql).append(",");
            }
        } else {
            stringBuffer.append(warehouseSql).append(",");
            stringBuffer.append(stockerSql).append(",");
        }
        stringBuffer.append(" a." + coreBillNumber + ", a." + coreBillSeqNo + ", a." + coreBillIDField + ", a." + coreBillEntryIDField + ",");
        stringBuffer.append(" a.FUnitStandardCost, a.FStandardCost, ");
        stringBuffer.append("round(" + costOutUnitActualCost + ",c.FPricePrecision), ");
        stringBuffer.append("round(" + costOutActualCost + "," + localAmountPrecision + "),");
        stringBuffer.append(this.getCostOutEntrySql());
        stringBuffer.append(balanceCustomerSql);
        stringBuffer.append(" FROM " + sourceBillEntryTable + " a INNER JOIN " + coreBillEntryTable + " b ");
        stringBuffer.append(" on a." + coreBillEntryIDField + " = b.FID");
        stringBuffer.append(" inner join " + coreBillTable + " d ");
        stringBuffer.append(" ON a." + coreBillIDField + " = d.FID");
        stringBuffer.append(" INNER JOIN T_BD_Material c");
        stringBuffer.append(" ON a.FMaterialID = c.FID");
        if (this.isTransferProcess()) {
            if (TABLENAME_PURIN.equalsIgnoreCase(sourceBillTable)) {
                stringBuffer.append(" left join T_DB_WAREHOUSE wh on wh.fid=b.FRequireWarehouseID");
            } else if (TABLENAME_SALEISSUE.equalsIgnoreCase(sourceBillTable)) {
                stringBuffer.append(" left join T_DB_WAREHOUSE wh on wh.fid=b.FSupplyWarehouseID");
            }
        }
        stringBuffer.append(" WHERE a.FParentID = '" + orgBillID + "'");
        stringBuffer.append(" and d." + storageField + " = '" + orderStorageOrgUnitID + "'");
        if (this.isTransferProcess()) {
            stringBuffer.append(";");
        } else {
            stringBuffer.append(" and (a.FISCENTERBALANCE = 1  and a.FISBETWEENCOMPANYSEND = 1);");
        }
        return stringBuffer.toString();
    }

    protected String[] getCostInHeadUpdateSqls(Map map) {
        String[] sqls = new String[]{this.getUpdateBalanceSupplierSql(map)};
        return sqls;
    }

    protected String[] getCostInEntryUpdateSqls(Map map) {
        String virtualBillID = (String)map.get(PARAM_COSTINBILLID);
        String[] sqls = new String[]{this.getUpdateStandardCostSQL(virtualBillID, TABLENAME_PURINENTRY, map, true), this.getCostInEntryUpdateWriteQtySql(map)};
        return sqls;
    }

    protected String[] getCostOutHeadUpdateSqls(Map map) {
        String[] sqls = this.getUpdateBalanceCustomerSql(map);
        return sqls;
    }

    protected String[] getCostOutEntryUpdateSqls(Map map) {
        String virtualBillID = (String)map.get(PARAM_COSTOUTBILLID);
        String[] sqls = new String[]{this.getUpdateStandardCostSQL(virtualBillID, TABLENAME_SALEISSUEENTRY, map, false), this.getCostOutEntryUpdateWriteQtySql(map)};
        return sqls;
    }

    protected String getUpdateBalanceSupplierSql(Map map) {
        String costInFid = (String)map.get(PARAM_COSTINBILLID);
        return "update t_im_purinwarehsentry set fbalancesupplierid = (select fsupplierid from t_im_purinwarehsbill where fid = '" + costInFid + "') where fparentid = '" + costInFid + "' and fbalancesupplierid is null;";
    }

    protected abstract String getBalanceSupplierSql(Map var1);

    protected abstract String getBalanceCustomerSql(Map var1);

    protected String getCostInEntryUpdateWriteQtySql(Map map) {
        String costInFid = (String)map.get(PARAM_COSTINBILLID);
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(TABLENAME_PURINENTRY).append(" set FUnWriteOffQty = 0, FUnWriteOffBaseQty = 0, FUnWriteOffAmount = 0, FWrittenOffQty = FQty, FWrittenOffBaseQty = FBaseQty, FWrittenOffAmount = FActualCost ").append(" where FIsPresent = 1 and FParentID = '").append(costInFid).append("';");
        return sql.toString();
    }

    protected String getCostOutEntryUpdateWriteQtySql(Map map) {
        String costOutFid = (String)map.get(PARAM_COSTOUTBILLID);
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(TABLENAME_SALEISSUEENTRY).append(" set FUnWriteOffQty = 0, FUnWriteOffBaseQty = 0, FUnWriteOffAmount = 0, FWrittenOffQty = FQty, FWrittenOffBaseQty = FBaseQty, FWrittenOffAmount = FActualCost ").append(" where FIsPresent = 1 and FParentID = '").append(costOutFid).append("';");
        return sql.toString();
    }

    protected String[] getUpdateBalanceCustomerSql(Map map) {
        String costOutFid = (String)map.get(PARAM_COSTOUTBILLID);
        StringBuffer[] sqls = new StringBuffer[5];
        int length = sqls.length;
        for (int i = 0; i < length; ++i) {
            sqls[i] = new StringBuffer();
        }
        sqls[0].append("update ").append(TABLENAME_SALEISSUEENTRY).append(" set fbalancecustomerid = (select fcustomerid from ");
        sqls[0].append(TABLENAME_SALEISSUE).append(" where fid = '").append(costOutFid).append("') where fparentid = '");
        sqls[0].append(costOutFid).append("' and fbalancecustomerid is null;");
        sqls[1].append("update ").append(TABLENAME_SALEISSUEENTRY);
        sqls[1].append(" set FPaymentCustomerID = FBalanceCustomerId where FPaymentCustomerID is null and FParentId = '");
        sqls[1].append(costOutFid).append("';");
        sqls[2].append("update ").append(TABLENAME_SALEISSUEENTRY).append(" set FOrderCustomerId = (select FCustomerId from ");
        sqls[2].append(TABLENAME_SALEISSUE).append(" where FId = '").append(costOutFid).append("') where FParentId = '");
        sqls[2].append(costOutFid).append("' and FOrderCustomerId is null;");
        sqls[3].append("update ").append(TABLENAME_SALEISSUEENTRY).append(" as sie set(FOrderCustomerId,FPaymentCustomerID,FBalanceCustomerId) = ");
        sqls[3].append("(select so.FOrderCustomerId,soe.FPaymentCustomerID,soe.FReceiveCustomerID from T_SD_SaleOrder so ");
        sqls[3].append("left join T_SD_SaleOrderEntry soe on so.FId = soe.FParentId where soe.FId = sie.FSaleOrderEntryId) where sie.FParentId = '");
        sqls[3].append(costOutFid).append("' and sie.FCoreBillTypeID = '").append("510b6503-0105-1000-e000-0113c0a812fd463ED552").append("'");
        sqls[4].append("update ").append(TABLENAME_SALEISSUEENTRY).append(" as sie set(FPaymentCustomerID,FBalanceCustomerId) = ");
        sqls[4].append("(select soe.FPaymentCustomerID,soe.FReceiveCustomerID from T_SD_SaleReturns so ");
        sqls[4].append("left join T_SD_SaleReturnsEntry soe on so.FId = soe.FParentId where soe.FId = sie.FSaleOrderEntryId) where sie.FParentId = '");
        sqls[4].append(costOutFid).append("' and sie.FCoreBillTypeID = '").append("50957179-0105-1000-e008-8152c0a812fd463ED552").append("'");
        return new String[]{sqls[0].toString(), sqls[1].toString(), sqls[2].toString(), sqls[3].toString(), sqls[4].toString()};
    }

    protected void createBill(Context ctx) throws BOSException {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            for (int i = 0; i < this.sepBillArray.size(); ++i) {
                HashMap map = (HashMap)this.sepBillArray.get(i);
                stmt.execute(this.getCostInEntrySql(map).toString().split(";")[0]);
                stmt.execute(this.getCostInEntrySql(map).toString().split(";")[1]);
                String[] costInEntryUpdateSqls = this.getCostInEntryUpdateSqls(map);
                for (int j = 0; j < costInEntryUpdateSqls.length; ++j) {
                    if (StringUtils.isEmpty((String)costInEntryUpdateSqls[j])) continue;
                    stmt.execute(costInEntryUpdateSqls[j]);
                }
                stmt.execute(this.getCostInHeadSql(map));
                String[] costInHeadUpdateSqls = this.getCostInHeadUpdateSqls(map);
                for (int j = 0; j < costInHeadUpdateSqls.length; ++j) {
                    if (StringUtils.isEmpty((String)costInHeadUpdateSqls[j])) continue;
                    stmt.execute(costInHeadUpdateSqls[j]);
                }
                stmt.execute(this.getCostOutEntrySql(map));
                String[] costOutEntryUpdateSqls = this.getCostOutEntryUpdateSqls(map);
                for (int j = 0; j < costOutEntryUpdateSqls.length; ++j) {
                    if (StringUtils.isEmpty((String)costOutEntryUpdateSqls[j])) continue;
                    stmt.execute(costOutEntryUpdateSqls[j]);
                }
                stmt.execute(this.getCostOutHeadSql(map));
                String[] costOutHeadUpdateSqls = this.getCostOutHeadUpdateSqls(map);
                for (int j = 0; j < costOutHeadUpdateSqls.length; ++j) {
                    if (StringUtils.isEmpty((String)costOutHeadUpdateSqls[j])) continue;
                    stmt.execute(costOutHeadUpdateSqls[j]);
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    protected String getCostOutHeadSql() {
        return "";
    }

    protected String getCostOutEntrySql() {
        return "";
    }
}

