/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.InvException;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.AbstractInvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.DischargeTypeEnum;
import com.kingdee.eas.scm.im.inv.IInvBillBase;
import com.kingdee.eas.scm.im.inv.IInventoryUpdate;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.InventoryUpdateFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillPriceInfoEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillPriceInfoEntryInfo;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.MoveIssueBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MoveIssueBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MoveIssueBillFactory;
import com.kingdee.eas.scm.im.inv.MoveIssueBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.app.AutoCreatePurInBill4VMIHandler;
import com.kingdee.eas.scm.im.inv.app.CreateVirtualBillForMaterialReq;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.inv.app.PurInAlgorithmForInfo;
import com.kingdee.eas.scm.im.inv.app.SaleIssueAlgorithmForInfo;
import com.kingdee.eas.scm.im.inv.util.AccountViewUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class CreateVirtualBillForMaterialReqViaBotp
extends CreateVirtualBillForMaterialReq {
    @Override
    protected void createVirtualBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaterialReqBillInfo info = (MaterialReqBillInfo)model;
        BizTypeInfo bizType = info.getBizType();
        if (bizType == null || bizType.getId() == null) {
            return;
        }
        String bizTypeID = bizType.getId().toString();
        if (bizTypeID.equals("nhvcdx82RzuTw48FSlV79CQHQ1w=")) {
            this.createInvVirtualBill(ctx, model, PurInWarehsBillFactory.getLocalInstance(ctx), this.getInBOTPName(ctx, model, bizTypeID));
            this.createInvVirtualBill(ctx, model, SaleIssueBillFactory.getLocalInstance(ctx), this.getOutBOTPName(ctx, model, bizTypeID));
        }
        if (bizTypeID.equals("YJN9V65PSkutQxeUH6F72SQHQ1w=") || bizTypeID.equals("i6DbShN4SLaNlFkX90UXOiQHQ1w=")) {
            this.createInvVirtualBill(ctx, model, MoveInWarehsBillFactory.getLocalInstance(ctx), this.getInBOTPName(ctx, model, bizTypeID));
            this.createInvVirtualBill(ctx, model, MoveIssueBillFactory.getLocalInstance(ctx), this.getOutBOTPName(ctx, model, bizTypeID));
        }
    }

    private void createInvVirtualBill(Context ctx, IObjectValue model, IInvBillBase invBillBase, String botpName) throws BOSException, EASBizException {
        int i;
        CoreBillBaseCollection coreBillBaseColl = new CoreBillBaseCollection();
        coreBillBaseColl.add((CoreBillBaseInfo)model);
        BOTMappingInfo botMappingInfo = null;
        try {
            botMappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo("where name ='" + botpName + "'");
        }
        catch (Exception e) {
            throw new InvException(InvException.BOTPERROR, (Object[])new String[]{botpName});
        }
        if (!botMappingInfo.getExtRule().isIsEffected()) {
            throw new InvException(InvException.BOTPERROR, (Object[])new String[]{botpName});
        }
        BTPTransformResult transformResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform(coreBillBaseColl, botMappingInfo);
        IObjectCollection infos = transformResult.getBills();
        String bizType = "";
        if (model instanceof MaterialReqBillInfo) {
            MaterialReqBillInfo tempInfo = (MaterialReqBillInfo)model;
            bizType = tempInfo.getBizType().getId().toString();
        }
        int size = infos.size();
        for (i = 0; i < size; ++i) {
            boolean hasLot;
            InvBillBaseInfo info = (InvBillBaseInfo)infos.getObject(i);
            info.setIsInitBill(false);
            info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
            info.setAuditTime(new Timestamp(new Date().getTime()));
            info.setBaseStatus(BillBaseStatusEnum.AUDITED);
            info.setIsReversed(false);
            info.put("isSysBill", Boolean.TRUE);
            CompanyOrgUnitInfo company = InvServerUtils.getCompanyInfoForStorage(ctx, info.getStorageOrgUnit());
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)info.getBizDate(), (CompanyOrgUnitInfo)company);
            if (period != null) {
                info.setYear(period.getPeriodYear());
                info.setPeriod(period.getPeriodNumber());
            }
            info.setMonth(model.getInt("month"));
            info.setDay(model.getInt("day"));
            if (info instanceof PurInWarehsBillInfo) {
                IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
                int paramValue = Integer.parseInt(ipc.getParamValue((IObjectPK)new ObjectUuidPK(company.getId()), "SCM_CAL_001"));
                ((PurInWarehsBillInfo)info).setDischargeType(DischargeTypeEnum.getEnum(paramValue));
            }
            if (model.get("entry") != null) {
                InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)((IObjectCollection)model.get("entry")).getObject(0);
                info.put("VT_StorageOrgUnitID", entry.getStorageOrgUnit().getId().toString());
                info.put("VT_CompanyOrgUnitID", entry.getCompanyOrgUnit().getId().toString());
            }
            this.setEntryValue(info, model, ctx);
            if (info instanceof SaleIssueBillInfo && !(hasLot = this.hasLot(info))) {
                SaleIssueBillFactory.getLocalInstance(ctx).matchLotInfo(info);
            }
            if (!(info instanceof MoveIssueBillInfo) || (hasLot = this.hasLot(info))) continue;
            MoveIssueBillFactory.getLocalInstance(ctx).matchLotInfo(info);
        }
        for (i = 0; i < infos.size(); ++i) {
            InvBillBaseInfo info = (InvBillBaseInfo)infos.getObject(i);
            if (info != null && info.getTransactionType() == null) {
                throw new InvBizException(InvBizException.TRANSACTION_CHECK_ERROR);
            }
            String billTypeID = null;
            if (null != info.getBillType()) {
                billTypeID = info.getBillType().getId().toString();
            }
            IObjectCollection entries = info.getEntries();
            InvBillBaseEntryInfo entry = null;
            CoreBaseCollection coll = InvCommonUtils.getSourceBillCollection(ctx, entries);
            if (!CollectionUtil.isEmpty((IObjectCollection)entries)) {
                EntityViewInfo view = null;
                InvUpdateTypeInfo invUpdateType = null;
                int size2 = entries.size();
                for (int index = 0; index < size2; ++index) {
                    entry = (InvBillBaseEntryInfo)entries.getObject(index);
                    view = InvCommonUtils.buildInvUpdateTypeEntityView(ctx, info, index, false, coll);
                    invUpdateType = InvCommonUtils.getDefaultInvUpdateTypeInfo(ctx, view);
                    if (invUpdateType == null) {
                        AbstractInvBillBaseEntryInfo srcEntry = null;
                        if (model.get("entry") != null && !CollectionUtil.isEmpty((IObjectCollection)((IObjectCollection)model.get("entry")))) {
                            IObjectCollection col = (IObjectCollection)model.get("entry");
                            for (int mm = 0; mm < col.size(); ++mm) {
                                if (!col.getObject(mm).get("id").toString().equals(entry.getSourceBillEntryId())) continue;
                                srcEntry = (InvBillBaseEntryInfo)col.getObject(mm);
                                break;
                            }
                        }
                        if (srcEntry.getInvUpdateType() != null) {
                            InvUpdateTypeInfo srcInvUpdateType = srcEntry.getInvUpdateType();
                            SelectorItemCollection selector = new SelectorItemCollection();
                            selector.add(new SelectorItemInfo("id"));
                            selector.add(new SelectorItemInfo("number"));
                            selector.add(new SelectorItemInfo("name"));
                            selector.add(new SelectorItemInfo("existingQty"));
                            selector.add(new SelectorItemInfo("existingQtyPre"));
                            selector.add(new SelectorItemInfo("isNotUpdateInv"));
                            selector.add(new SelectorItemInfo("scheduled"));
                            selector.add(new SelectorItemInfo("status"));
                            selector.add(new SelectorItemInfo("storeType.id"));
                            selector.add(new SelectorItemInfo("storeType.number"));
                            selector.add(new SelectorItemInfo("storeType.name"));
                            selector.add(new SelectorItemInfo("storeType.storeFlag"));
                            selector.add(new SelectorItemInfo("storeType.isForwardAmt"));
                            selector.add(new SelectorItemInfo("storeState.id"));
                            selector.add(new SelectorItemInfo("storeState.number"));
                            selector.add(new SelectorItemInfo("storeState.name"));
                            selector.add(new SelectorItemInfo("storeTypePre.id"));
                            selector.add(new SelectorItemInfo("storeTypePre.number"));
                            selector.add(new SelectorItemInfo("storeTypePre.name"));
                            selector.add(new SelectorItemInfo("storeTypePre.storeFlag"));
                            selector.add(new SelectorItemInfo("storeTypePre.isForwardAmt"));
                            selector.add(new SelectorItemInfo("storeStatePre.id"));
                            selector.add(new SelectorItemInfo("storeStatePre.number"));
                            selector.add(new SelectorItemInfo("storeStatePre.name"));
                            srcInvUpdateType = InvUpdateTypeFactory.getLocalInstance((Context)ctx).getInvUpdateTypeInfo((IObjectPK)new ObjectUuidPK(srcInvUpdateType.getId()), selector);
                            StoreTypeInfo storeType = srcInvUpdateType.getStoreType();
                            StoreStateInfo storeState = srcInvUpdateType.getStoreState();
                            StoreTypeInfo storeTypePre = srcInvUpdateType.getStoreTypePre();
                            StoreStateInfo storeStatePre = srcInvUpdateType.getStoreStatePre();
                            String storeTypeName = "";
                            String storeStateName = "";
                            if (storeType != null && storeState != null) {
                                storeTypeName = storeType.getName();
                                storeStateName = storeState.getName();
                            } else if (storeTypePre != null && storeStatePre != null) {
                                storeTypeName = storeTypePre.getName();
                                storeStateName = storeStatePre.getName();
                            }
                            if (SCMBaseCommonUtil.isInWarehsBill((String)billTypeID)) {
                                throw new InvBizException(InvBizException.IN_INVUPDATETYPE_ISNOT_EXIST, new String[]{storeTypeName, storeStateName});
                            }
                            if (SCMBaseCommonUtil.isOutWarehsBill((String)billTypeID)) {
                                throw new InvBizException(InvBizException.ISSUE_INVUPDATETYPE_ISNOT_EXIST, new String[]{storeTypeName, storeStateName});
                            }
                        }
                    } else {
                        entry.setInvUpdateType(invUpdateType);
                    }
                    entry.setUnVmiSettleBaseQty(entry.getBaseQty());
                    entry.setTotalVmiSettleBaseQty(BigDecimal.ZERO);
                }
            }
            this.updateAssisQty(ctx, info);
            IObjectPK pk = invBillBase.addnew((CoreBaseInfo)info);
            if (info.getBillType() != null && (info.getBillType().getId().toString().equals("50957179-0105-1000-e000-016ec0a812fd463ED552") || info.getBillType().getId().toString().equals("50957179-0105-1000-e000-015bc0a812fd463ED552"))) {
                new AutoCreatePurInBill4VMIHandler(ctx, pk.toString(), BizActionEnum.AUDIT).execute();
            }
            IInventoryUpdate iInventoryUpdate = InventoryUpdateFactory.getLocalInstance((Context)ctx);
            String transTypeID = null;
            if (info.getTransactionType() != null) {
                transTypeID = info.getTransactionType().getId().toString();
                iInventoryUpdate.updateInventory(BizActionEnum.AUDIT, pk.toString(), transTypeID);
            }
            this.afterVirtualBill(ctx, (CoreBillBaseInfo)model, (CoreBillBaseInfo)info);
            if (info.getBillType() != null && (info.getBillType().getId().toString().equals("50957179-0105-1000-e000-016ec0a812fd463ED552") || info.getBillType().getId().toString().equals("50957179-0105-1000-e000-015bc0a812fd463ED552"))) {
                this.calculateBill(ctx, info);
            }
            if (bizType.equals("YJN9V65PSkutQxeUH6F72SQHQ1w=")) {
                this.writeBackActualCost((IObjectValue)info, ctx);
                this.writeBack4MoveIssue((IObjectValue)info, ctx);
            }
            if (bizType.equals("i6DbShN4SLaNlFkX90UXOiQHQ1w=")) {
                this.writeBack4JumpStorage(model, ctx);
                this.writeBack4MoveIssue((IObjectValue)info, ctx);
            }
            if (bizType.equals("nhvcdx82RzuTw48FSlV79CQHQ1w=")) {
                this.writeBack4JumpCompany(model, ctx);
            }
            AccountViewUtil.updateAccountView(ctx, infos);
        }
    }

    private boolean hasLot(InvBillBaseInfo info) {
        IObjectCollection entrys = info.getEntries();
        boolean hasLot = false;
        for (int j = 0; j < entrys.size(); ++j) {
            if (StringUtils.isEmpty((String)entrys.getObject(j).getString("lot"))) continue;
            hasLot = true;
            break;
        }
        return hasLot;
    }

    private void writeBack4MoveIssue(IObjectValue model, Context ctx) throws BOSException, EASBizException {
        int precision;
        CurrencyInfo baseCurrency;
        CompanyOrgUnitInfo comp;
        InvBillBaseInfo info;
        String[] sqls = new String[1];
        StringBuffer sb = new StringBuffer();
        String companyId = null;
        if (model instanceof MoveIssueBillInfo) {
            info = (MoveIssueBillInfo)model;
            comp = InvServerUtils.getCompanyInfoForStorage(ctx, info.getStorageOrgUnit());
            if (comp == null) {
                return;
            }
            companyId = comp.getId().toString();
            baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(comp.getBaseCurrency().getId().toString()));
            precision = baseCurrency.getPrecision();
            sb.append(" update T_IM_MoveIssueBillEntry t10 set (FUnitStandardCost,fstandardCost) =  (");
            sb.append(" select decimal(company.fstandardcost*b.FBaseConvsRate,21,8),");
            sb.append("decimal(TO_DECIMAL(company.fstandardcost*Entry.fqty,17,4)*b.FBaseConvsRate,21," + precision + ")  ");
            sb.append(" from T_IM_MoveIssueBill bill inner join T_IM_MoveIssueBillEntry entry on bill.fid = entry.fparentid ");
            sb.append(" inner join t_bd_multimeasureunit b on entry.FMaterialID = b.FMaterialID and entry.FUnitID = b.fmeasureunitid ");
            sb.append(" inner join t_bd_materialcompanyinfo company on company.fmaterialid = entry.fmaterialid ");
            sb.append(" and company.fcompanyid ='" + companyId + "' and company.fstatus = 1 and company.fstandardcost is not null ");
            sb.append("  and company.faccounttype = 2 and bill.fid = '" + info.getId().toString() + "' where entry.fid = t10.fid  )");
            sqls[0] = sb.toString();
            DBUtil.executeBatch((Context)ctx, (String[])sqls);
        }
        if (model instanceof MoveInWarehsBillInfo) {
            info = (MoveInWarehsBillInfo)model;
            comp = InvServerUtils.getCompanyInfoForStorage(ctx, info.getStorageOrgUnit());
            if (comp == null) {
                return;
            }
            companyId = comp.getId().toString();
            baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(comp.getBaseCurrency().getId().toString()));
            precision = baseCurrency.getPrecision();
            sb.setLength(0);
            sb.append(" update T_IM_MoveInWarehsBillEntry as t10 set (FUnitStandardCost,fstandardCost) =  (");
            sb.append(" select decimal(company.fstandardcost*b.FBaseConvsRate,21,8),");
            sb.append("decimal(TO_DECIMAL(company.fstandardcost*Entry.fqty,17,4)*b.FBaseConvsRate,21," + precision + ") ");
            sb.append(" from  T_IM_MoveInWarehsBill as bill ");
            sb.append(" inner join T_IM_MoveInWarehsBillEntry as entry on bill.fid = entry.fparentid ");
            sb.append(" inner join t_bd_multimeasureunit b on entry.FMaterialID = b.FMaterialID and entry.FUnitID = b.fmeasureunitid ");
            sb.append(" inner join t_bd_materialcompanyinfo as company on company.fmaterialid = entry.fmaterialid ");
            sb.append(" and company.fcompanyid ='" + companyId + "' and company.fstatus = 1 and company.fstandardcost is not null ");
            sb.append(" and company.faccounttype = 2 and bill.fid = '" + info.getId().toString() + "' ");
            sb.append(" where entry.fid = t10.fid )");
            sqls[0] = sb.toString();
            DBUtil.executeBatch((Context)ctx, (String[])sqls);
        }
    }

    private void writeBack4JumpStorage(IObjectValue model, Context ctx) throws BOSException, EASBizException {
        MaterialReqBillInfo info = (MaterialReqBillInfo)model;
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)info.get("demandcompanyorgunit");
        int precision = 4;
        if (cou.getBaseCurrency().getId() != null) {
            CurrencyInfo baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cou.getBaseCurrency().getId().toString()));
            precision = baseCurrency.getPrecision();
        }
        BizTypeInfo bizTypeInfo = info.getBizType();
        String materilaReqID = info.getId().toString();
        if (bizTypeInfo.getNumber().equals("348")) {
            StringBuffer updateIssue = new StringBuffer();
            updateIssue.append(" update T_IM_MaterialReqBillEntry as t10 ");
            updateIssue.append(" set (FUnitActualCost,FActualCost)  ");
            updateIssue.append(" = ( ");
            updateIssue.append(" select t2.Fsettleprice,TO_DECIMAL(t2.Fsettleprice*t2.fqty,17," + precision + ")");
            updateIssue.append(" from T_IM_MaterialReqBillEntry as t2 where t2.FParentID = '" + materilaReqID + "' ");
            updateIssue.append("  and t10.fid = t2.fid  ) ");
            StringBuffer updateIssueStandardCost = new StringBuffer();
            updateIssueStandardCost.append(" update T_IM_MaterialReqBillEntry as t10 ");
            updateIssueStandardCost.append(" set (FUnitActualCost,FActualCost) ");
            updateIssueStandardCost.append(" = ( ");
            updateIssueStandardCost.append(" select company.fstandardcost, TO_DECIMAL(company.fstandardcost*Entry.fqty,17," + precision + ")  ");
            updateIssueStandardCost.append(" from T_IM_MaterialReqBillEntry entry inner join t_bd_materialcompanyinfo company on company.fmaterialid = entry.fmaterialid ");
            updateIssueStandardCost.append(" and company.fcompanyid = entry.FCOMPANYORGUNITID and company.faccounttype = 2 ");
            updateIssueStandardCost.append(" and  entry.fparentid =  '" + materilaReqID + "' ");
            updateIssueStandardCost.append("  where entry.fid = t10.fid   ) ");
            StringBuffer updateMoveIn = new StringBuffer();
            updateMoveIn.append(" update T_IM_MoveInWarehsBillEntry as t10 ");
            updateMoveIn.append(" set (FActualCost,FUnitActualCost) = ( ");
            updateMoveIn.append(" select t1.FActualCost,t1.FUnitActualCost");
            updateMoveIn.append("  from T_IM_MaterialReqBillEntry as t1 inner join  T_IM_MoveInWarehsBillEntry as t2 ");
            updateMoveIn.append("  on t2.FSourceBillEntryID = t1.FID ");
            updateMoveIn.append("  and t1.FParentID  = '" + materilaReqID + "' ");
            updateMoveIn.append("  where t10.fid = t2.fid  )");
            StringBuffer updateMoveInwarehouse = new StringBuffer();
            updateMoveInwarehouse.append(" update T_IM_MoveInWarehsBillEntry as t10 ");
            updateMoveInwarehouse.append(" set (FActualCost,FUnitActualCost) = ( ");
            updateMoveInwarehouse.append(" select TO_DECIMAL(t1.FSettlePrice*t1.fqty,17," + precision + "),t1.FSettlePrice");
            updateMoveInwarehouse.append("  from T_IM_MaterialReqBillEntry as t1 inner join  T_IM_MoveInWarehsBillEntry as t2 ");
            updateMoveInwarehouse.append("  on t2.FSourceBillEntryID = t1.FID ");
            updateMoveInwarehouse.append("  and t1.FParentID  = '" + materilaReqID + "' ");
            updateMoveInwarehouse.append("inner join t_bd_materialcompanyinfo company on company.fmaterialid = t1.fmaterialid");
            updateMoveInwarehouse.append(" and company.fcompanyid = t1.FCOMPANYORGUNITID and company.faccounttype = 2 ");
            updateMoveInwarehouse.append("  where t10.fid = t2.fid  )");
            DBUtil.executeBatch((Context)ctx, (String[])new String[]{updateIssue.toString(), updateIssueStandardCost.toString(), updateMoveIn.toString(), updateMoveInwarehouse.toString()});
        }
    }

    private void writeBack4JumpCompany(IObjectValue model, Context ctx) throws BOSException, EASBizException {
        MaterialReqBillInfo info = (MaterialReqBillInfo)model;
        BizTypeInfo bizTypeInfo = info.getBizType();
        String materilaReqID = info.getId().toString();
        if (bizTypeInfo.getId().toString().equals("nhvcdx82RzuTw48FSlV79CQHQ1w=")) {
            StringBuffer updateIssue = new StringBuffer();
            updateIssue.append(" update T_IM_MaterialReqBillEntry as t10 ");
            updateIssue.append(" set (FUnitActualCost,FActualCost)  ");
            updateIssue.append(" = ( ");
            updateIssue.append(" select TO_DECIMAL(isnull(t1.FRealPrice,0),21,8),TO_DECIMAL(isnull(t1.FRealPrice,0) * isnull(t2.fqty,0),17,4)");
            updateIssue.append(" from T_IM_MaterialReqBillPriceInfo as t1 inner join  T_IM_MaterialReqBillEntry as t2 ");
            updateIssue.append("  on t2.Fid = t1.FMaterialReqEntryID ");
            updateIssue.append("  and t2.FParentID = '" + materilaReqID + "' ");
            updateIssue.append("  where t10.fid = t2.fid  ) ");
            StringBuffer updateMoveIn = new StringBuffer();
            updateMoveIn.append(" update T_IM_MaterialReqBillEntry as t10 ");
            updateMoveIn.append(" set (FActualCost) = ( ");
            updateMoveIn.append(" select TO_DECIMAL(isnull(t2.FActualCost,0),17,4) ");
            updateMoveIn.append("  from T_IM_MaterialReqBillEntry as t1 inner join  T_IM_PurinwarehsEntry as t2 ");
            updateMoveIn.append("   on t2.FSourceBillEntryID = t1.FID ");
            updateMoveIn.append("  and t1.FParentID  = '" + materilaReqID + "' ");
            updateMoveIn.append("  where t10.fid = t1.fid  )");
            DBUtil.executeBatch((Context)ctx, (String[])new String[]{updateIssue.toString(), updateMoveIn.toString()});
        }
    }

    private String getInBOTPName(Context ctx, IObjectValue model, String bizTypeID) {
        String botpName = null;
        if (bizTypeID.equals("i6DbShN4SLaNlFkX90UXOiQHQ1w=")) {
            botpName = "MaterialReq_MoveInBill_VirtualBill";
        } else if (bizTypeID.equals("YJN9V65PSkutQxeUH6F72SQHQ1w=")) {
            botpName = "MaterialReq_MoveInBill_VirtualBill";
        } else if (bizTypeID.equals("nhvcdx82RzuTw48FSlV79CQHQ1w=")) {
            botpName = "MaterialReq_PurInwarehs_VirtualBill";
        }
        return botpName;
    }

    private String getOutBOTPName(Context ctx, IObjectValue model, String bizTypeID) {
        String botpName = null;
        if (bizTypeID.equals("i6DbShN4SLaNlFkX90UXOiQHQ1w=")) {
            botpName = "MaterialReq_MoveIssueBill_VirtualBill";
        } else if (bizTypeID.equals("YJN9V65PSkutQxeUH6F72SQHQ1w=")) {
            botpName = "MaterialReq_MoveIssueBill_VirtualBill";
        } else if (bizTypeID.equals("nhvcdx82RzuTw48FSlV79CQHQ1w=")) {
            botpName = "MaterialReq_SaleIssue_VirtualBill";
        }
        return botpName;
    }

    private void afterVirtualBill(Context ctx, CoreBillBaseInfo srcBillInfo, CoreBillBaseInfo destBillBaseInfo) throws BOSException, EASBizException {
        SCMServerUtils.traceUpAndDown((Context)ctx, (String)srcBillInfo.getId().toString(), (String)destBillBaseInfo.getId().toString(), (String)srcBillInfo.getBOSType().toString(), (String)destBillBaseInfo.getBOSType().toString());
    }

    private BigDecimal getExchangeRate(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        CompanyOrgUnitInfo CompanyInfo;
        MaterialReqBillInfo materialReqBillInfo = (MaterialReqBillInfo)model;
        StorageOrgUnitInfo supplyStoreOrgUnit = materialReqBillInfo.getSupplyStoreOrgUnit();
        StorageOrgUnitInfo StoreOrgUnit = materialReqBillInfo.getStorageOrgUnit();
        CompanyOrgUnitInfo supplyCompanyInfo = InvServerUtils.getCompanyInfoForStorage(ctx, supplyStoreOrgUnit);
        CurrencyInfo supplyCurrencyInfo = null;
        CurrencyInfo currencyInfo = null;
        if (supplyCompanyInfo != null) {
            supplyCurrencyInfo = supplyCompanyInfo.getBaseCurrency();
        }
        if ((CompanyInfo = InvServerUtils.getCompanyInfoForStorage(ctx, StoreOrgUnit)) != null) {
            currencyInfo = CompanyInfo.getBaseCurrency();
        }
        if (supplyCurrencyInfo != null && currencyInfo != null && supplyCurrencyInfo.getId() != null && currencyInfo.getId() != null) {
            if (supplyCurrencyInfo.getId().equals((Object)currencyInfo.getId())) {
                return new BigDecimal("1.00");
            }
            ObjectUuidPK sourceCurrPK = null;
            ObjectUuidPK destCurrPK = null;
            sourceCurrPK = new ObjectUuidPK(currencyInfo.getId());
            ExchangeRateInfo tempexrateinfo = SCMServerUtils.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)supplyCompanyInfo, (IObjectPK)sourceCurrPK, (IObjectPK)(destCurrPK = new ObjectUuidPK(supplyCurrencyInfo.getId())));
            if (tempexrateinfo != null) {
                return tempexrateinfo.getConvertRate();
            }
            throw new InvException(InvException.SALEISSUENOTFOUNDEXCHANGERATE);
        }
        return new BigDecimal("0.00");
    }

    private SupplierInfo getBalanceSupplier(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        MaterialReqBillInfo materialReqBillInfo = (MaterialReqBillInfo)model;
        StorageOrgUnitInfo supplyStoreOrgUnit = materialReqBillInfo.getSupplyStoreOrgUnit();
        CompanyOrgUnitInfo CompanyInfo = InvServerUtils.getCompanyInfoForStorage(ctx, supplyStoreOrgUnit);
        SupplierInfo supplier = null;
        if (CompanyInfo != null && CompanyInfo.getId() != null) {
            String id = null;
            StringBuffer sb = new StringBuffer();
            sb.append("Select Top 1 sp.Fid From T_BD_SUPPLIER as sp Where sp.FInternalCompanyID = '").append(CompanyInfo.getId().toString()).append("'");
            sb.append("  and sp.FIsInternalCompany = ").append("1");
            sb.append(" and FUsedStatus = ").append(1);
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            try {
                if (result.next()) {
                    id = result.getString("Fid");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)result);
            }
            if (id != null) {
                ObjectUuidPK pk = new ObjectUuidPK(id);
                supplier = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)pk);
                return supplier;
            }
        }
        return null;
    }

    private void setEntryValue(InvBillBaseInfo info, IObjectValue model, Context ctx) throws EASBizException, BOSException {
        BigDecimal zero = new BigDecimal("0.00");
        if (info instanceof PurInWarehsBillInfo) {
            PurInWarehsBillInfo purInfo = (PurInWarehsBillInfo)info;
            PurInWarehsEntryCollection purEntrys = purInfo.getEntry();
            PurInWarehsEntryInfo purEntry = null;
            MaterialReqBillPriceInfoEntryInfo priceInfo = null;
            int count = purEntrys.size();
            SupplierInfo supplier = null;
            supplier = this.getBalanceSupplier(ctx, model);
            if (supplier == null && info.getBizType() != null && "nhvcdx82RzuTw48FSlV79CQHQ1w=".equals(info.getBizType().getId().toString())) {
                throw new InvBizException(InvBizException.HAS_NO_INNER_SUPPLIER, new String[0]);
            }
            purInfo.setSupplier(supplier);
            for (int i = 0; i < count; ++i) {
                purEntry = purEntrys.get(i);
                purEntry.setBalanceSupplier(supplier);
                if (purEntry.getActualCost() == null) {
                    purEntry.setActualCost(zero);
                }
                if (purEntry.getUnitActualCost() == null) {
                    purEntry.setUnitActualCost(zero);
                }
                if (purEntry.getAmount() == null) {
                    purEntry.setAmount(zero);
                }
                if (purEntry.getTaxAmount() == null) {
                    purEntry.setTaxAmount(zero);
                }
                if ((priceInfo = this.getEntryByID(model, purEntry.getSourceBillEntryId())) == null) continue;
                purEntry.setPrice(priceInfo.getPrice());
                purEntry.setActualPrice(priceInfo.getRealPrice());
                purEntry.setActualTaxPrice(priceInfo.getRealTaxPrice());
                purEntry.setDiscountRate(priceInfo.getDiscount());
                purEntry.setTaxPrice(priceInfo.getTaxPrice());
                purEntry.setTaxRate(priceInfo.getTaxRate());
            }
            try {
                ctx.put((Object)"createVirtualBillForMatReq", (Object)true);
                new PurInAlgorithmForInfo(purInfo, ctx).revalue();
                ctx.remove((Object)"createVirtualBillForMatReq");
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (info instanceof SaleIssueBillInfo) {
            SaleIssueBillInfo saleIssueInfo = (SaleIssueBillInfo)info;
            saleIssueInfo.setExchangeRate(this.getExchangeRate(ctx, model));
            SaleIssueEntryCollection saleIssueEntrys = saleIssueInfo.getEntry();
            SaleIssueEntryInfo saleIssueEntry = null;
            MaterialReqBillPriceInfoEntryInfo priceInfo = null;
            CustomerInfo innerBalanceCustomer = null;
            int count = saleIssueEntrys.size();
            if (saleIssueInfo.getCustomer() == null) {
                String couID = saleIssueInfo.getDescription();
                saleIssueInfo.setDescription(null);
                if (couID != null && couID.length() > 1) {
                    innerBalanceCustomer = CustomerFactory.getLocalInstance((Context)ctx).getInterCustomerCollection(couID, null).get(0);
                }
                if (innerBalanceCustomer == null && info.getBizType() != null && "nhvcdx82RzuTw48FSlV79CQHQ1w=".equals(info.getBizType().getId().toString())) {
                    throw new InvBizException(InvBizException.HAS_NO_INNER_CUSTOMER);
                }
                saleIssueInfo.setCustomer(innerBalanceCustomer);
            } else {
                innerBalanceCustomer = saleIssueInfo.getCustomer();
            }
            BigDecimal price = zero;
            BigDecimal realPrice = zero;
            BigDecimal realTaxPrice = zero;
            BigDecimal taxPrice = zero;
            for (int i = 0; i < count; ++i) {
                saleIssueEntry = saleIssueEntrys.get(i);
                saleIssueEntry.setBalanceCustomer(innerBalanceCustomer);
                saleIssueEntry.setOrderCustomer(innerBalanceCustomer);
                saleIssueEntry.setPaymentCustomer(innerBalanceCustomer);
                priceInfo = this.getEntryByID(model, saleIssueEntry.getSourceBillEntryId());
                if (priceInfo == null) continue;
                price = priceInfo.getPrice() == null ? zero : priceInfo.getPrice();
                realPrice = priceInfo.getRealPrice() == null ? zero : priceInfo.getRealPrice();
                realTaxPrice = priceInfo.getRealTaxPrice() == null ? zero : priceInfo.getRealTaxPrice();
                taxPrice = priceInfo.getTaxPrice() == null ? zero : priceInfo.getTaxPrice();
                saleIssueEntry.setSalePrice(price);
                saleIssueEntry.setLocalPrice(price);
                saleIssueEntry.setDiscountType(priceInfo.getDiscountType());
                saleIssueEntry.setActualPrice(realPrice);
                saleIssueEntry.setPrice(realTaxPrice);
                saleIssueEntry.setDiscount(priceInfo.getDiscount());
                saleIssueEntry.setTaxPrice(taxPrice);
                saleIssueEntry.setTaxRate(priceInfo.getTaxRate());
                if (saleIssueEntry.getActualCost() == null) {
                    saleIssueEntry.setActualCost(zero);
                }
                if (saleIssueEntry.getUnitActualCost() == null) {
                    saleIssueEntry.setUnitActualCost(zero);
                }
                if (saleIssueEntry.getAmount() == null) {
                    saleIssueEntry.setAmount(zero);
                }
                if (saleIssueEntry.getNonTaxAmount() != null) continue;
                saleIssueEntry.setNonTaxAmount(zero);
            }
            try {
                new SaleIssueAlgorithmForInfo(saleIssueInfo, ctx).revalue();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private MaterialReqBillPriceInfoEntryInfo getEntryByID(IObjectValue model, String materialReqEntryID) {
        MaterialReqBillInfo materialReqBillInfo = (MaterialReqBillInfo)model;
        MaterialReqBillPriceInfoEntryInfo priceInfo = null;
        MaterialReqBillPriceInfoEntryCollection priceInfos = materialReqBillInfo.getPriceInfo();
        int count = priceInfos.size();
        for (int i = 0; i < count; ++i) {
            MaterialReqBillPriceInfoEntryInfo entry = priceInfos.get(i);
            String id = entry.getMaterialReqEntryID();
            if (id == null || !id.equals(materialReqEntryID)) continue;
            priceInfo = entry;
            break;
        }
        return priceInfo;
    }

    private void writeBackActualCost(IObjectValue model, Context ctx) throws BOSException, EASBizException {
        if (model instanceof MoveIssueBillInfo) {
            MoveIssueBillInfo info = (MoveIssueBillInfo)model;
            BizTypeInfo bizTypeInfo = info.getBizType();
            String materilaReqID = info.getSourceBillId();
            if (bizTypeInfo.getNumber().equals("349")) {
                CompanyOrgUnitInfo comp = InvServerUtils.getCompanyInfoForStorage(ctx, info.getStorageOrgUnit());
                if (comp == null) {
                    return;
                }
                String companyId = comp.getId().toString();
                StringBuffer updateIssue = new StringBuffer();
                updateIssue.append(" update T_IM_MaterialReqBillEntry as t10 ");
                updateIssue.append(" set (FActualCost,FUnitActualCost) = ( ");
                updateIssue.append(" select t.FActualCost,t.FUnitActualCost from ( ");
                updateIssue.append(" \tselect t2.fid as fid, sum(isnull(t1.FActualCost,0)) as FActualCost,");
                updateIssue.append(" \tround(decimal(sum(isnull(t1.FActualCost,0)),21,8)/decimal(sum(t1.fqty),21,8),8) as FUnitActualCost");
                updateIssue.append(" \tfrom T_IM_MoveIssueBillentry as t1 ");
                updateIssue.append(" \tinner join T_IM_MaterialReqBillEntry as t2 on t2.Fid = t1.FSourceBillEntryID and t1.FSourceBIllID = '" + materilaReqID + "' ");
                updateIssue.append(" \tinner join t_bd_materialcompanyinfo as mci on mci.fmaterialid = t2.fmaterialid ");
                updateIssue.append(" \tand mci.fcompanyid ='" + companyId + "' and mci.fstatus = 1 and mci.FAccountType = 1 ");
                updateIssue.append(" \tgroup by t2.Fid ");
                updateIssue.append(" ) as t where t10.fid = t.fid )");
                StringBuffer sb = new StringBuffer();
                sb.append(" update T_IM_MoveInWarehsBillEntry as t10 ");
                sb.append(" set (FActualCost,FUnitActualCost) = ( ");
                sb.append(" select t.FActualCost,t.FUnitActualCost from ( ");
                sb.append(" \tselect t2.FID as fid, ");
                sb.append(" \tsum(isnull(t1.FActualCost,0)) as FActualCost, ");
                sb.append(" \tround(decimal(sum(isnull(t1.FActualCost,0)),21,8)/decimal(sum(t1.fqty),21,8),8) as FUnitActualCost");
                sb.append(" \tfrom T_IM_MoveIssueBillentry as t1 ");
                sb.append(" \tinner join T_IM_MoveInWarehsBillEntry as t2 on t2.FSourceBillEntryID = t1.FSourceBillEntryID and t2.FSourceBIllID = '" + materilaReqID + "' ");
                sb.append(" \tinner join t_bd_materialcompanyinfo as mci on mci.fmaterialid = t2.fmaterialid ");
                sb.append(" \tand mci.fcompanyid ='" + companyId + "' and mci.fstatus = 1 and mci.FAccountType = 1 ");
                sb.append(" \tgroup by t2.FID ");
                sb.append(" ) as t where t10.fid = t.fid) ");
                DBUtil.executeBatch((Context)ctx, (String[])new String[]{updateIssue.toString(), sb.toString()});
            }
        }
    }

    private MaterialCompanyInfoInfo getMaterialCompanyInfo(Context ctx, String materialID, String couID) throws BOSException {
        IMaterialCompanyInfo imaterialCompany = null;
        imaterialCompany = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)materialID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)couID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        ev.setSelector(sic);
        ev.setFilter(filter);
        MaterialCompanyInfoCollection coll = imaterialCompany.getMaterialCompanyInfoCollection(ev);
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    private void updateAssisQty(Context ctx, InvBillBaseInfo info) throws EASBizException, BOSException {
        block3: {
            block2: {
                if (!(info instanceof MoveIssueBillInfo)) break block2;
                MoveIssueBillInfo purInfo = (MoveIssueBillInfo)info;
                MoveIssueBillEntryCollection purEntrys = purInfo.getEntry();
                HashMap map = this.reCalByQty(ctx, info);
                MoveIssueBillEntryInfo purEntry = null;
                int count = purEntrys.size();
                for (int j = 0; j < count; ++j) {
                    purEntry = purEntrys.get(j);
                    if (purEntry.getAssistQty() != null || map.get(j) == null) continue;
                    purEntry.setAssistQty((BigDecimal)map.get(j));
                }
                break block3;
            }
            if (!(info instanceof MoveInWarehsBillInfo)) break block3;
            HashMap map = this.reCalByQty(ctx, info);
            MoveInWarehsBillInfo purInfo = (MoveInWarehsBillInfo)info;
            MoveInWarehsBillEntryCollection purEntrys = purInfo.getEntry();
            MoveInWarehsBillEntryInfo purEntry = null;
            int count = purEntrys.size();
            for (int j = 0; j < count; ++j) {
                purEntry = purEntrys.get(j);
                if (purEntry.getAssistQty() != null || map.get(j) == null) continue;
                purEntry.setAssistQty((BigDecimal)map.get(j));
            }
        }
    }

    protected HashMap reCalByQty(Context ctx, InvBillBaseInfo info) throws EASBizException, BOSException {
        HashSet<String> unitSet = new HashSet<String>();
        HashMap<Integer, BigDecimal> map = new HashMap<Integer, BigDecimal>();
        IObjectCollection entryColl = (IObjectCollection)info.get("entry");
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entryColl.getObject(i);
            if (entry.getUnit() == null || entry.getBaseUnit() == null) continue;
            unitSet.add(entry.getMaterial().getId().toString() + "," + entry.getUnit().getId().toString());
            if (entry.getAssistUnit() == null) continue;
            unitSet.add(entry.getMaterial().getId().toString() + "," + entry.getAssistUnit().getId().toString());
        }
        Map mulUnitMap = InvServerUtils.getMultiUnitMap(ctx, unitSet);
        Map<String, MultiMeasureUnitInfo> mulUnitAllMap = InvServerUtils.getMultiMeasureUnitMap(ctx, info);
        BigDecimal assUnitConv = null;
        int assUnitPricision = 0;
        Map entryMulAssUnitMap = null;
        MultiMeasureUnitInfo mmUnitInfo = null;
        int baseQtyPrecision = 8;
        int size2 = entryColl.size();
        for (int i = 0; i < size2; ++i) {
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entryColl.getObject(i);
            if (entry.getMaterial() == null || entry.getUnit() == null || entry.getBaseUnit() == null) continue;
            mmUnitInfo = mulUnitAllMap.get(entry.getMaterial().getId().toString() + entry.getUnit().getId().toString());
            baseQtyPrecision = 8;
            if (mulUnitAllMap.get(entry.getMaterial().getId().toString() + entry.getBaseUnit().getId().toString()) != null) {
                baseQtyPrecision = mulUnitAllMap.get(entry.getMaterial().getId().toString() + entry.getBaseUnit().getId().toString()).getQtyPrecision();
            }
            if (mmUnitInfo != null) {
                BigDecimal baseQty = entry.getQty().multiply(mmUnitInfo.getBaseConvsRate()).setScale(baseQtyPrecision, 4);
                entry.setBaseQty(baseQty);
            }
            if (entry.getAssistQty() != null && entry.getAssistQty().compareTo(BigDecimal.ZERO) != 0) continue;
            entryMulAssUnitMap = null;
            if (entry.getAssistUnit() != null) {
                entryMulAssUnitMap = (Map)mulUnitMap.get(entry.getMaterial().getId().toString() + entry.getAssistUnit().getId().toString());
            }
            if (entryMulAssUnitMap == null) continue;
            assUnitConv = new BigDecimal((String)entryMulAssUnitMap.get("fbaseconvsrate"));
            assUnitPricision = Integer.parseInt((String)entryMulAssUnitMap.get("fqtyprecision"));
            map.put(i, entry.getBaseQty().divide(assUnitConv, assUnitPricision, 4));
        }
        return map;
    }
}

