/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.im.inv.ITransferOrderBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.app.CreateVirtualBill;
import com.kingdee.eas.scm.sm.pur.IPurOrder;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class CreateVirtualBillForPurIn
extends CreateVirtualBill {
    protected static final String PARAM_TRANSFER_ISSUECOMPANYORGUNIT = "transferSupplyCompanyOrgUnit";

    @Override
    protected boolean checkCreateVirtualBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.checkIsValid(ctx, model);
    }

    @Override
    protected boolean checkUpdateVirtualBillForReversed(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.checkIsValid(ctx, model);
    }

    @Override
    protected void initBillMap(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super.initBillMap(ctx, model);
        PurInWarehsBillInfo pi = (PurInWarehsBillInfo)model;
        PurInWarehsEntryInfo pie = pi.getEntry().get(0);
        if ("510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(pie.getCoreBillType().getId().toString())) {
            this.initBillMapForPurOrder(ctx, model);
        } else if ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(pie.getCoreBillType().getId().toString())) {
            this.initBillMapForTransferOrder(ctx, model);
        }
    }

    protected void initBillMapForPurOrder(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurInWarehsBillInfo pi = (PurInWarehsBillInfo)model;
        BigDecimal exchangeRate = pi.getExchangeRate().setScale(8, 4);
        this.billMap.put("exchangeRate", exchangeRate);
        this.billMap.put("sourceBillTable", "t_im_purinwarehsbill");
        this.billMap.put("sourceEntryTable", "t_im_purinwarehsentry");
        this.billMap.put("coreBillTable", "t_sm_purorder");
        this.billMap.put("coreBillEntryTable", "t_sm_purorderentry");
        this.billMap.put("coreBillIDField", "FPurOrderID");
        this.billMap.put("coreBillEntryIDField", "FPurOrderEntryID");
        this.billMap.put("coreBillNumber", "FPurOrderNumber");
        this.billMap.put("coreBillSeqNo", "FPurOrderEntrySeq");
        this.billMap.put("supplierSql", "FSupplierID");
        this.billMap.put("customerSql", "(SELECT TOP 1 FID FROM T_BD_Customer WHERE FInternalCompanyID = '" + (String)this.billMap.get("invCompanyOrgUnit") + "')");
        this.billMap.put("balanceSupplierSql", this.getBalanceSupplierSql(this.billMap));
        this.billMap.put("balanceCustomerSql", this.getBalanceCustomerSql(this.billMap));
        this.billMap.put("storageField", "FStorageOrgUnitID");
        this.billMap.put("virtualReceiveOrgUnit", "b.FStorageOrgUnitID");
        StringBuffer sb = new StringBuffer();
        sb.append("round((decimal(isnull(b.FPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)),c.FPricePrecision) ");
        this.billMap.put("costInPrice", sb.toString());
        sb = new StringBuffer();
        sb.append("round((decimal(isnull(b.FTaxPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)),c.FPricePrecision) ");
        this.billMap.put("costInTaxPrice", sb.toString());
        this.billMap.put("costInTaxRate", "decimal(b.FTaxRate,21,8)");
        this.billMap.put("costInDiscountRate", "decimal(b.FDiscountRate,21,8)");
        this.billMap.put("costInPurchaseFee", "decimal(a.FPurchaseFee,21,8)");
        this.billMap.put("costInMaterialCost", "decimal(a.FMaterialCost,21,8)");
        this.billMap.put("costInQty", "decimal(a.fqty,21,8)");
        this.billMap.put("costInConvertMode", "d.FConvertMode");
        this.billMap.put("costInExchangeRate", "decimal(d.FExchangeRate,21,8)");
        if (pi.isIsInTax() && pi.isIsPriceInTax()) {
            this.billMap.put("costInDiscountAmount", "round(decimal((" + this.billMap.get("costInTaxPrice") + " * decimal(" + this.billMap.get("costInDiscountRate") + "/100,21,8) * " + this.billMap.get("costInQty") + "),21,8),cur.FPrecision)");
            this.billMap.put("costInPrice", "round(decimal((" + this.billMap.get("costInTaxPrice") + "/(1+decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8))),21,8),c.FPricePrecision)");
            this.billMap.put("costInTaxAmount", "round(decimal((" + this.billMap.get("costInQty") + "*" + this.billMap.get("costInTaxPrice") + "-" + this.billMap.get("costInDiscountAmount") + "),21,8),cur.FPrecision)");
            this.billMap.put("costInTax", "round(decimal((" + this.billMap.get("costInTaxAmount") + "/(1+decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8))*decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8)),21,8),cur.FPrecision)");
            this.billMap.put("costInLocalTaxAmount", "round(decimal((case " + this.billMap.get("costInConvertMode") + " when 0 then " + this.billMap.get("costInTaxAmount") + "*" + this.billMap.get("costInExchangeRate") + " else " + this.billMap.get("costInTaxAmount") + "/" + this.billMap.get("costInExchangeRate") + " end),21,8),lcur.FPrecision)");
            this.billMap.put("costInAmount", "round(decimal((" + this.billMap.get("costInTaxAmount") + "-" + this.billMap.get("costInTax") + "),21,8),cur.FPrecision)");
            this.billMap.put("costInLocalTax", "round(decimal((case " + this.billMap.get("costInConvertMode") + " when 0 then " + this.billMap.get("costInTax") + "*" + this.billMap.get("costInExchangeRate") + " else " + this.billMap.get("costInTax") + "/" + this.billMap.get("costInExchangeRate") + " end),21,8),lcur.FPrecision)");
            this.billMap.put("costInActualTaxPrice", "round(decimal((" + this.billMap.get("costInTaxAmount") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
            this.billMap.put("costInActualPrice", "round(decimal((" + this.billMap.get("costInAmount") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
            this.billMap.put("costInPurchaseCost", "round(decimal((" + this.billMap.get("costInLocalTaxAmount") + "-" + this.billMap.get("costInLocalTax") + "),21,8),lcur.FPrecision)");
            this.billMap.put("costInUnitPurchaseCost", "round(decimal((" + this.billMap.get("costInPurchaseCost") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
            this.billMap.put("costInActualCost", "round(decimal((" + this.billMap.get("costInPurchaseCost") + "+" + this.billMap.get("costInPurchaseFee") + "+" + this.billMap.get("costInMaterialCost") + "),21,8),lcur.FPrecision)");
            this.billMap.put("costInUnitActualCost", "round(decimal((" + this.billMap.get("costInActualCost") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
        } else if (pi.isIsInTax() && !pi.isIsPriceInTax()) {
            this.billMap.put("costInDiscountAmount", "round(decimal((" + this.billMap.get("costInTaxPrice") + " * decimal(" + this.billMap.get("costInDiscountRate") + "/100,21,8) * " + this.billMap.get("costInQty") + "),21,8),cur.FPrecision)");
            this.billMap.put("costInPrice", "round(decimal((" + this.billMap.get("costInTaxPrice") + "*(1-decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8))),21,8),c.FPricePrecision)");
            this.billMap.put("costInTaxAmount", "round(decimal((" + this.billMap.get("costInQty") + "*" + this.billMap.get("costInTaxPrice") + "-" + this.billMap.get("costInDiscountAmount") + "),21,8),cur.FPrecision)");
            this.billMap.put("costInTax", "round(decimal((" + this.billMap.get("costInTaxAmount") + "* decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8)),21,8),cur.FPrecision)");
            this.billMap.put("costInLocalTaxAmount", "round(decimal((case " + this.billMap.get("costInConvertMode") + " when 0 then " + this.billMap.get("costInTaxAmount") + "*" + this.billMap.get("costInExchangeRate") + " else " + this.billMap.get("costInTaxAmount") + "/" + this.billMap.get("costInExchangeRate") + " end),21,8),lcur.FPrecision)");
            this.billMap.put("costInAmount", "round(decimal((" + this.billMap.get("costInTaxAmount") + "-" + this.billMap.get("costInTax") + "),21,8),cur.FPrecision)");
            this.billMap.put("costInLocalTax", "round(decimal((case " + this.billMap.get("costInConvertMode") + " when 0 then " + this.billMap.get("costInTax") + "*" + this.billMap.get("costInExchangeRate") + " else " + this.billMap.get("costInTax") + "/" + this.billMap.get("costInExchangeRate") + " end),21,8),lcur.FPrecision)");
            this.billMap.put("costInActualTaxPrice", "round(decimal((" + this.billMap.get("costInTaxAmount") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
            this.billMap.put("costInActualPrice", "round(decimal((" + this.billMap.get("costInAmount") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
            this.billMap.put("costInPurchaseCost", "round(decimal((" + this.billMap.get("costInLocalTaxAmount") + "-" + this.billMap.get("costInLocalTax") + "),21,8),lcur.FPrecision)");
            this.billMap.put("costInUnitPurchaseCost", "round(decimal((" + this.billMap.get("costInPurchaseCost") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
            this.billMap.put("costInActualCost", "round(decimal((" + this.billMap.get("costInPurchaseCost") + "+" + this.billMap.get("costInPurchaseFee") + "+" + this.billMap.get("costInMaterialCost") + "),21,8),lcur.FPrecision)");
            this.billMap.put("costInUnitActualCost", "round(decimal((" + this.billMap.get("costInActualCost") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
        } else {
            this.billMap.put("costInAmount", "round(decimal((" + this.billMap.get("costInQty") + "*" + this.billMap.get("costInPrice") + "*(1-decimal(" + this.billMap.get("costInDiscountRate") + "/100,21,8))),21,8),cur.FPrecision)");
            this.billMap.put("costInTaxPrice", "round(decimal((" + this.billMap.get("costInPrice") + "*(1+decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8))),21,8),c.FPricePrecision)");
            this.billMap.put("costInTax", "round(decimal((" + this.billMap.get("costInAmount") + "* decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8)),21,8),cur.FPrecision)");
            this.billMap.put("costInActualPrice", "round(decimal((" + this.billMap.get("costInAmount") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
            this.billMap.put("costInLocalTax", "round(decimal((case " + this.billMap.get("costInConvertMode") + " when 0 then " + this.billMap.get("costInTax") + "*" + this.billMap.get("costInExchangeRate") + " else " + this.billMap.get("costInTax") + "/" + this.billMap.get("costInExchangeRate") + " end),21,8),lcur.FPrecision)");
            this.billMap.put("costInTaxAmount", "round(decimal((" + this.billMap.get("costInAmount") + "+" + this.billMap.get("costInTax") + "),21,8),cur.FPrecision)");
            this.billMap.put("costInDiscountAmount", "round(decimal((" + this.billMap.get("costInTaxPrice") + " * decimal(" + this.billMap.get("costInDiscountRate") + "/100,21,8) * " + this.billMap.get("costInQty") + "),21,8),cur.FPrecision)");
            this.billMap.put("costInActualTaxPrice", "round(decimal((" + this.billMap.get("costInTaxAmount") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
            this.billMap.put("costInLocalTaxAmount", "round(decimal((case " + this.billMap.get("costInConvertMode") + " when 0 then " + this.billMap.get("costInTaxAmount") + "*" + this.billMap.get("costInExchangeRate") + " else " + this.billMap.get("costInTaxAmount") + "/" + this.billMap.get("costInExchangeRate") + " end),21,8),lcur.FPrecision)");
            this.billMap.put("costInPurchaseCost", "round(decimal((" + this.billMap.get("costInLocalTaxAmount") + "-" + this.billMap.get("costInLocalTax") + "),21,8),lcur.FPrecision)");
            this.billMap.put("costInUnitPurchaseCost", "round(decimal((" + this.billMap.get("costInPurchaseCost") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
            this.billMap.put("costInActualCost", "round(decimal((" + this.billMap.get("costInPurchaseCost") + "+" + this.billMap.get("costInPurchaseFee") + "+" + this.billMap.get("costInMaterialCost") + "),21,8),lcur.FPrecision)");
            this.billMap.put("costInUnitActualCost", "round(decimal((" + this.billMap.get("costInActualCost") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
        }
        this.billMap.put("costInUnWriteOffAmount", this.billMap.get("costInPurchaseCost"));
        sb = new StringBuffer();
        sb.append("(decimal(isnull((select top 1 FActualTaxPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(" from T_SM_PurInnerDealPrice pidp where pidp.FPurOrderEntryID = b.FID),0),21,8)) ");
        this.billMap.put("costOutPrice", sb.toString());
        sb = new StringBuffer();
        sb.append("(decimal(isnull((select top 1 FActualTaxPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(" from T_SM_PurInnerDealPrice pidp where pidp.FPurOrderEntryID = b.FID),0),21,8) * decimal(a.FQty,21,8)) ");
        this.billMap.put("costOutAmount", sb.toString());
        sb = new StringBuffer();
        sb.append("((decimal(isnull(b.FActualPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)) * ");
        sb.append(exchangeRate).append(")");
        this.billMap.put("costOutUnitActualCost", sb.toString());
        sb = new StringBuffer();
        sb.append("((decimal(isnull(b.FActualPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)) * decimal(a.FQty,21,8) * ");
        sb.append(exchangeRate).append(")");
        this.billMap.put("costOutActualCost", sb.toString());
        sb = new StringBuffer();
        sb.append("((decimal(isnull(b.FActualPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)) * decimal(a.FQty,21,8) * ");
        sb.append(exchangeRate).append(")");
        this.billMap.put("costOutUnWriteOffAmount", sb.toString());
    }

    protected void initBillMapForTransferOrder(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurInWarehsBillInfo pi = (PurInWarehsBillInfo)model;
        BigDecimal exchangeRate = pi.getExchangeRate().setScale(8, 4);
        this.billMap.put("exchangeRate", exchangeRate);
        this.billMap.put("sourceBillTable", "t_im_purinwarehsbill");
        this.billMap.put("sourceEntryTable", "t_im_purinwarehsentry");
        this.billMap.put("coreBillTable", "t_im_transferorderbill");
        this.billMap.put("coreBillEntryTable", "t_im_transferorderbillentry");
        this.billMap.put("coreBillIDField", "FPurOrderID");
        this.billMap.put("coreBillEntryIDField", "FPurOrderEntryID");
        this.billMap.put("coreBillNumber", "FPurOrderNumber");
        this.billMap.put("coreBillSeqNo", "FPurOrderEntrySeq");
        this.billMap.put("supplierSql", "FSupplierID");
        this.billMap.put("customerSql", "(SELECT TOP 1 FID FROM T_BD_Customer WHERE FInternalCompanyID = '" + (String)this.billMap.get("invCompanyOrgUnit") + "')");
        this.billMap.put("balanceSupplierSql", this.getBalanceSupplierSql(this.billMap));
        this.billMap.put("balanceCustomerSql", this.getBalanceCustomerSql(this.billMap));
        this.billMap.put("storageField", "FReceiptStorageOrgUnitID");
        this.billMap.put("virtualReceiveOrgUnit", "b.FReceiveStorageOrgUnitID");
        StringBuffer sb = new StringBuffer();
        sb.append("round((decimal(isnull(b.FPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)),c.FPricePrecision) ");
        this.billMap.put("costInPrice", sb.toString());
        sb = new StringBuffer();
        sb.append("round((decimal(isnull(b.FTaxPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)),c.FPricePrecision) ");
        this.billMap.put("costInTaxPrice", sb.toString());
        this.billMap.put("costInTaxRate", "decimal(b.FTaxRate,21,8)");
        this.billMap.put("costInDiscountRate", "decimal(b.FDiscountRate,21,8)");
        this.billMap.put("costInPurchaseFee", "decimal(a.FPurchaseFee,21,8)");
        this.billMap.put("costInMaterialCost", "decimal(a.FMaterialCost,21,8)");
        this.billMap.put("costInQty", "decimal(a.fqty,21,8)");
        this.billMap.put("costInConvertMode", " 0 ");
        this.billMap.put("costInExchangeRate", "decimal(d.FExchangeRate,21,8)");
        if (pi.isIsInTax() && pi.isIsPriceInTax()) {
            this.billMap.put("costInDiscountAmount", "round(decimal((" + this.billMap.get("costInTaxPrice") + " * decimal(" + this.billMap.get("costInDiscountRate") + "/100 ,21,8)* " + this.billMap.get("costInQty") + "),21,8),cur.FPrecision)");
            this.billMap.put("costInPrice", "round(decimal((" + this.billMap.get("costInTaxPrice") + "/(1+decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8))),21,8),c.FPricePrecision)");
            this.billMap.put("costInTaxAmount", "round(decimal((" + this.billMap.get("costInQty") + "*" + this.billMap.get("costInTaxPrice") + "-" + this.billMap.get("costInDiscountAmount") + "),21,8),cur.FPrecision)");
            this.billMap.put("costInTax", "round(decimal((" + this.billMap.get("costInTaxAmount") + "/(1+decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8))* decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8)),21,8),cur.FPrecision)");
            this.billMap.put("costInLocalTaxAmount", "round(decimal((case " + this.billMap.get("costInConvertMode") + " when 0 then " + this.billMap.get("costInTaxAmount") + "*" + this.billMap.get("costInExchangeRate") + " else " + this.billMap.get("costInTaxAmount") + "/" + this.billMap.get("costInExchangeRate") + " end),21,8),lcur.FPrecision)");
            this.billMap.put("costInAmount", "round(decimal((" + this.billMap.get("costInTaxAmount") + "-" + this.billMap.get("costInTax") + "),21,8),cur.FPrecision)");
            this.billMap.put("costInLocalTax", "round(decimal((case " + this.billMap.get("costInConvertMode") + " when 0 then " + this.billMap.get("costInTax") + "*" + this.billMap.get("costInExchangeRate") + " else " + this.billMap.get("costInTax") + "/" + this.billMap.get("costInExchangeRate") + " end),21,8),lcur.FPrecision)");
            this.billMap.put("costInActualTaxPrice", "round(decimal((" + this.billMap.get("costInTaxAmount") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
            this.billMap.put("costInActualPrice", "round(decimal((" + this.billMap.get("costInAmount") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
            this.billMap.put("costInPurchaseCost", "round(decimal((" + this.billMap.get("costInLocalTaxAmount") + "-" + this.billMap.get("costInLocalTax") + "),21,8),lcur.FPrecision)");
            this.billMap.put("costInUnitPurchaseCost", "round(decimal((" + this.billMap.get("costInPurchaseCost") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
            this.billMap.put("costInActualCost", "round(decimal((" + this.billMap.get("costInPurchaseCost") + "+" + this.billMap.get("costInPurchaseFee") + "+" + this.billMap.get("costInMaterialCost") + "),21,8),lcur.FPrecision)");
            this.billMap.put("costInUnitActualCost", "round(decimal((" + this.billMap.get("costInActualCost") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
        } else if (pi.isIsInTax() && !pi.isIsPriceInTax()) {
            this.billMap.put("costInDiscountAmount", "round(decimal((" + this.billMap.get("costInTaxPrice") + " * decimal(" + this.billMap.get("costInDiscountRate") + "/100 ,21,8)* " + this.billMap.get("costInQty") + "),21,8),cur.FPrecision)");
            this.billMap.put("costInPrice", "round(decimal((" + this.billMap.get("costInTaxPrice") + "*(1-decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8))),21,8),c.FPricePrecision)");
            this.billMap.put("costInTaxAmount", "round(decimal((" + this.billMap.get("costInQty") + "*" + this.billMap.get("costInTaxPrice") + "-" + this.billMap.get("costInDiscountAmount") + "),21,8),cur.FPrecision)");
            this.billMap.put("costInTax", "round(decimal((" + this.billMap.get("costInTaxAmount") + "*decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8)),21,8),cur.FPrecision)");
            this.billMap.put("costInLocalTaxAmount", "round(decimal((case " + this.billMap.get("costInConvertMode") + " when 0 then " + this.billMap.get("costInTaxAmount") + "*" + this.billMap.get("costInExchangeRate") + " else " + this.billMap.get("costInTaxAmount") + "/" + this.billMap.get("costInExchangeRate") + " end),21,8),lcur.FPrecision)");
            this.billMap.put("costInAmount", "round(decimal((" + this.billMap.get("costInTaxAmount") + "-" + this.billMap.get("costInTax") + "),21,8),cur.FPrecision)");
            this.billMap.put("costInLocalTax", "round(decimal((case " + this.billMap.get("costInConvertMode") + " when 0 then " + this.billMap.get("costInTax") + "*" + this.billMap.get("costInExchangeRate") + " else " + this.billMap.get("costInTax") + "/" + this.billMap.get("costInExchangeRate") + " end),21,8),lcur.FPrecision)");
            this.billMap.put("costInActualTaxPrice", "round(decimal((" + this.billMap.get("costInTaxAmount") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
            this.billMap.put("costInActualPrice", "round(decimal((" + this.billMap.get("costInAmount") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
            this.billMap.put("costInPurchaseCost", "round(decimal((" + this.billMap.get("costInLocalTaxAmount") + "-" + this.billMap.get("costInLocalTax") + "),21,8),lcur.FPrecision)");
            this.billMap.put("costInUnitPurchaseCost", "round(decimal((" + this.billMap.get("costInPurchaseCost") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
            this.billMap.put("costInActualCost", "round(decimal((" + this.billMap.get("costInPurchaseCost") + "+" + this.billMap.get("costInPurchaseFee") + "+" + this.billMap.get("costInMaterialCost") + "),21,8),lcur.FPrecision)");
            this.billMap.put("costInUnitActualCost", "round(decimal((" + this.billMap.get("costInActualCost") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
        } else {
            this.billMap.put("costInAmount", "round(decimal((" + this.billMap.get("costInQty") + "*" + this.billMap.get("costInPrice") + "*(1-decimal(" + this.billMap.get("costInDiscountRate") + "/100,21,8))),21,8),cur.FPrecision)");
            this.billMap.put("costInTaxPrice", "round(decimal((" + this.billMap.get("costInPrice") + "*(1+decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8))),21,8),c.FPricePrecision)");
            this.billMap.put("costInTax", "round(decimal((" + this.billMap.get("costInAmount") + "*decimal(" + this.billMap.get("costInTaxRate") + "/100,21,8)),21,8),cur.FPrecision)");
            this.billMap.put("costInActualPrice", "round(decimal((" + this.billMap.get("costInAmount") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
            this.billMap.put("costInLocalTax", "round(decimal((case " + this.billMap.get("costInConvertMode") + " when 0 then " + this.billMap.get("costInTax") + "*" + this.billMap.get("costInExchangeRate") + " else " + this.billMap.get("costInTax") + "/" + this.billMap.get("costInExchangeRate") + " end),21,8),lcur.FPrecision)");
            this.billMap.put("costInTaxAmount", "round(decimal((" + this.billMap.get("costInAmount") + "+" + this.billMap.get("costInTax") + "),21,8),cur.FPrecision)");
            this.billMap.put("costInDiscountAmount", "round(decimal((" + this.billMap.get("costInTaxPrice") + " * decimal(" + this.billMap.get("costInDiscountRate") + "/100 ,21,8)* " + this.billMap.get("costInQty") + "),21,8),cur.FPrecision)");
            this.billMap.put("costInActualTaxPrice", "round(decimal((" + this.billMap.get("costInTaxAmount") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
            this.billMap.put("costInLocalTaxAmount", "round(decimal((case " + this.billMap.get("costInConvertMode") + " when 0 then " + this.billMap.get("costInTaxAmount") + "*" + this.billMap.get("costInExchangeRate") + " else " + this.billMap.get("costInTaxAmount") + "/" + this.billMap.get("costInExchangeRate") + " end),21,8),lcur.FPrecision)");
            this.billMap.put("costInPurchaseCost", "round(decimal((" + this.billMap.get("costInLocalTaxAmount") + "-" + this.billMap.get("costInLocalTax") + "),21,8),lcur.FPrecision)");
            this.billMap.put("costInUnitPurchaseCost", "round(decimal((" + this.billMap.get("costInPurchaseCost") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
            this.billMap.put("costInActualCost", "round(decimal((" + this.billMap.get("costInPurchaseCost") + "+" + this.billMap.get("costInPurchaseFee") + "+" + this.billMap.get("costInMaterialCost") + "),21,8),lcur.FPrecision)");
            this.billMap.put("costInUnitActualCost", "round(decimal((" + this.billMap.get("costInActualCost") + "/" + this.billMap.get("costInQty") + "),21,8),c.FPricePrecision)");
        }
        this.billMap.put("costInUnWriteOffAmount", this.billMap.get("costInPurchaseCost"));
        String selectActualPrice = "isnull((SELECT TOP 1 decimal(FActualTaxPrice,21,8) FROM T_IM_MultiSidesTransferPrices WHERE FTransferBillEntryID = b.FID AND FBizRole = 1),0)";
        sb = new StringBuffer();
        sb.append("(decimal(isnull(");
        sb.append("(").append(selectActualPrice).append(")");
        sb.append("* (select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)) ");
        this.billMap.put("costOutPrice", sb.toString());
        sb = new StringBuffer();
        sb.append("(decimal(isnull(");
        sb.append("(").append(selectActualPrice).append(")");
        sb.append("* (select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)) * decimal(a.FQty,21,8)");
        this.billMap.put("costOutAmount", sb.toString());
        sb = new StringBuffer();
        sb.append("((decimal(isnull(b.FActualPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)) * ");
        sb.append(exchangeRate).append(")");
        this.billMap.put("costOutUnitActualCost", sb.toString());
        sb = new StringBuffer();
        sb.append("((decimal(isnull(b.FActualPrice * ");
        sb.append("(select TOP 1 FBaseConvsRate from T_BD_MultiMeasureUnit immua ");
        sb.append(" where immua.FMeasureUnitID = a.FUnitID and immua.FMaterialID = a.FMaterialID) ");
        sb.append(" / (select TOP 1 FBaseConvsRate as FUnitID from T_BD_MultiMeasureUnit immub ");
        sb.append(" where immub.FMeasureUnitID = b.FUnitID and immub.FMaterialID = b.FMaterialID) ");
        sb.append(",0),21,8)) * ");
        sb.append(exchangeRate).append(") * decimal(a.FQty,21,8)");
        this.billMap.put("costOutActualCost", sb.toString());
        this.billMap.put("costOutUnWriteOffAmount", this.billMap.get("costOutActualCost"));
    }

    private boolean checkIsValid(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurInWarehsBillInfo pi = (PurInWarehsBillInfo)model;
        PurInWarehsEntryInfo pie = pi.getEntry().get(0);
        if (pie.getCoreBillType() == null) {
            return false;
        }
        if ("510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(pie.getCoreBillType().getId().toString())) {
            return this.checkIsValidForPurOrder(ctx, model);
        }
        if ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(pie.getCoreBillType().getId().toString())) {
            return this.checkIsValidForTransferOrder(ctx, model);
        }
        return false;
    }

    private boolean checkIsValidForPurOrder(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurInWarehsBillInfo pi = (PurInWarehsBillInfo)model;
        PurInWarehsEntryInfo pie = pi.getEntry().get(0);
        if (!(pie.getCoreBillType() != null && "510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(pie.getCoreBillType().getId().toString()) || pi.isIsReversed())) {
            return false;
        }
        IPurOrder is = PurOrderFactory.getLocalInstance((Context)ctx);
        PurOrderInfo po = null;
        boolean val = false;
        Vector<StorageOrgUnitInfo> vector = new Vector<StorageOrgUnitInfo>();
        ISCMBillCommonFacade iScmFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx);
        String souId = null;
        for (int i = 0; i < pi.getEntry().size(); ++i) {
            pie = pi.getEntry().get(i);
            if (!pie.isIsCenterBalance() || !pie.isIsBetweenCompanySend() || pie.getPurOrder() == null || !is.exists((IObjectPK)new ObjectUuidPK(pie.getPurOrder()))) continue;
            val = true;
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("storageOrgUnit.id"));
            sc.add(new SelectorItemInfo("companyOrgUnit.id"));
            sc.add(new SelectorItemInfo("purchaseOrgUnit.id"));
            sc.add(new SelectorItemInfo("currency"));
            sc.add(new SelectorItemInfo("currency.precision"));
            po = is.getPurOrderInfo((IObjectPK)new ObjectUuidPK(pie.getPurOrder()), sc);
            if (vector.contains(po.getStorageOrgUnit())) continue;
            souId = po.getStorageOrgUnit().getId().toString();
            SaleOrgUnitInfo saleOuInfo = iScmFacade.getSaleOrgByStorageOrg(souId);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("orderStorageOrgUnit", souId);
            map.put("orderCompanyOrgUnit", po.getCompanyOrgUnit().getId().toString());
            map.put("currency", po.getCurrency());
            map.put("amountPrecision", new Integer(po.getCurrency().getPrecision()));
            map.put("virtualPurOrgUnit", po.getPurchaseOrgUnit().getId().toString());
            map.put("virtualSaleOrgUnit", saleOuInfo == null ? null : saleOuInfo.getId().toString());
            this.sepBillArray.add(map);
            vector.add(po.getStorageOrgUnit());
        }
        this.checkVirtualBizDateValid(ctx, pi, pie, val);
        return val;
    }

    private boolean checkIsValidForTransferOrder(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurInWarehsBillInfo pi = (PurInWarehsBillInfo)model;
        PurInWarehsEntryInfo pie = pi.getEntry().get(0);
        if (pie.getCoreBillType() == null) {
            return false;
        }
        if (!"LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(pi.getBizType().getId().toString()) && !"ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(pi.getBizType().getId().toString())) {
            return false;
        }
        ITransferOrderBill is = TransferOrderBillFactory.getLocalInstance(ctx);
        TransferOrderBillInfo to = null;
        boolean val = false;
        Vector<StorageOrgUnitInfo> vector = new Vector<StorageOrgUnitInfo>();
        for (int i = 0; i < pi.getEntry().size(); ++i) {
            pie = pi.getEntry().get(i);
            if (pie.getPurOrder() == null || !is.exists((IObjectPK)new ObjectUuidPK(pie.getPurOrder()))) continue;
            val = true;
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("receiptStorageOrgUnit.id"));
            sc.add(new SelectorItemInfo("receiptCompanyOrgUnit.id"));
            sc.add(new SelectorItemInfo("currency"));
            sc.add(new SelectorItemInfo("currency.precision"));
            to = is.getTransferOrderBillInfo((IObjectPK)new ObjectUuidPK(pie.getPurOrder()), sc);
            if (vector.contains(to.getReceiptStorageOrgUnit())) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("orderStorageOrgUnit", to.getReceiptStorageOrgUnit().getId().toString());
            map.put("orderCompanyOrgUnit", to.getReceiptCompanyOrgUnit().getId().toString());
            map.put("currency", to.getCurrency());
            map.put("amountPrecision", new Integer(to.getCurrency().getPrecision()));
            this.sepBillArray.add(map);
            vector.add(to.getReceiptStorageOrgUnit());
        }
        this.checkVirtualBizDateValid(ctx, pi, pie, val);
        return val;
    }

    @Override
    protected String getBalanceSupplierSql(Map map) {
        String bizTypeID = (String)map.get("bizTypeID");
        String sql = null;
        if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID)) {
            sql = "(SELECT TOP 1 FID FROM T_BD_Supplier WHERE FInternalCompanyID = (SELECT FIssueCompanyOrgUnitID FROM T_IM_TransferOrderBill WHERE FID = d.FID))";
        }
        return sql;
    }

    @Override
    protected String getBalanceCustomerSql(Map map) {
        String bizTypeID = (String)map.get("bizTypeID");
        String sql = null;
        if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID)) {
            sql = "(SELECT TOP 1 FID FROM T_BD_Customer WHERE FInternalCompanyID = (SELECT FReceiveCompanyOrgUnitID FROM T_IM_TransferOrderBillEntry WHERE FID = b.FID))";
        }
        return sql;
    }

    protected void checkVirtualBizDateValid(Context ctx, InvBillBaseInfo bill, InvBillBaseEntryInfo entry, boolean isOK) throws BOSException, EASBizException {
        if (isOK) {
            SelectorItemCollection sc;
            PurInWarehsBillInfo pi = (PurInWarehsBillInfo)bill;
            PurInWarehsEntryInfo pie = pi.getEntry().get(0);
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = entry.getCompanyOrgUnit();
            if ("510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(pie.getCoreBillType().getId().toString())) {
                if (pie.getPurOrder() != null) {
                    sc = new SelectorItemCollection();
                    sc.add(new SelectorItemInfo("companyOrgUnit.id"));
                    sc.add(new SelectorItemInfo("companyOrgUnit.number"));
                    PurOrderInfo purOrder = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderInfo((IObjectPK)new ObjectUuidPK(pie.getPurOrder()), sc);
                    if (purOrder != null) {
                        aCompanyOrgUnitInfo = purOrder.getCompanyOrgUnit();
                    }
                }
            } else if ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(pie.getCoreBillType().getId().toString()) && pie.getPurOrder() != null) {
                sc = new SelectorItemCollection();
                sc.add(new SelectorItemInfo("id"));
                sc.add(new SelectorItemInfo("bizType.id"));
                sc.add(new SelectorItemInfo("issueCompanyOrgUnit.id"));
                sc.add(new SelectorItemInfo("issueCompanyOrgUnit.number"));
                sc.add(new SelectorItemInfo("receiptCompanyOrgUnit.id"));
                sc.add(new SelectorItemInfo("receiptCompanyOrgUnit.number"));
                TransferOrderBillInfo transferOrder = TransferOrderBillFactory.getLocalInstance(ctx).getTransferOrderBillInfo((IObjectPK)new ObjectUuidPK(pie.getPurOrder()), sc);
                if (transferOrder != null) {
                    if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".endsWith(transferOrder.getBizType().getId().toString())) {
                        aCompanyOrgUnitInfo = transferOrder.getIssueCompanyOrgUnit();
                    } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".endsWith(transferOrder.getBizType().getId().toString())) {
                        aCompanyOrgUnitInfo = transferOrder.getReceiptCompanyOrgUnit();
                    }
                }
            }
            if (aCompanyOrgUnitInfo != null && aCompanyOrgUnitInfo.getId() != null) {
                sc = new SelectorItemCollection();
                sc.add(new SelectorItemInfo("id"));
                sc.add(new SelectorItemInfo("number"));
                aCompanyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(aCompanyOrgUnitInfo.getId()), sc);
            }
            if (aCompanyOrgUnitInfo != null && aCompanyOrgUnitInfo.getId() != null) {
                Object[] temp;
                PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
                if (currentPeriodInfo == null) {
                    temp = new String[]{aCompanyOrgUnitInfo.getNumber()};
                    throw new SCMBillException(SCMBillException.CURRENTPERIODISNULL_VIRTUAL, temp);
                }
                if (bill.getBizDate() == null) {
                    throw new SCMBillException(SCMBillException.BIZDATEISNULL_VIRTUAL);
                }
                if (bill.getBizDate().before(currentPeriodInfo.getBeginDate())) {
                    temp = new String[2];
                    StringBuffer sb = new StringBuffer();
                    sb.append(currentPeriodInfo.getBeginDate().getYear() + 1900);
                    sb.append("-");
                    int month = currentPeriodInfo.getBeginDate().getMonth() + 1;
                    if (month < 10) {
                        sb.append("0");
                    }
                    sb.append(month);
                    sb.append("-");
                    int date = currentPeriodInfo.getBeginDate().getDate();
                    if (date < 10) {
                        sb.append("0");
                    }
                    sb.append(date);
                    temp[0] = aCompanyOrgUnitInfo.getNumber();
                    temp[1] = sb.toString();
                    throw new SCMBillException(SCMBillException.BIZDATEAFTERPERIOD_VIRTUAL, temp);
                }
                if (!bill.getBizDate().before(currentPeriodInfo.getBeginDate()) && !bill.getBizDate().after(currentPeriodInfo.getEndDate()) && SystemStatusCtrolUtils.isClose((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo)) {
                    temp = new String[]{aCompanyOrgUnitInfo.getNumber()};
                    throw new SCMBillException(SCMBillException.CURRENT_PERIOD_COLSED_VIRTUAL, temp);
                }
            }
        }
    }
}

