/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.DecomposeBillInfo;
import com.kingdee.eas.scm.im.inv.DecomposeEntryCollection;
import com.kingdee.eas.scm.im.inv.DecomposeEntryDetailCollection;
import com.kingdee.eas.scm.im.inv.DecomposeEntryDetailInfo;
import com.kingdee.eas.scm.im.inv.DecomposeEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InventoryUpdateFactory;
import com.kingdee.eas.scm.im.inv.app.AbstractDecomposeBillControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;

public class DecomposeBillControllerBean
extends AbstractDecomposeBillControllerBean {
    private static final long serialVersionUID = 1L;
    private static final String INV_ADD_RESOURCE = "com.kingdee.eas.scm.im.inv.InvAddResource";

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DecomposeBillInfo dbi = (DecomposeBillInfo)model;
        this.checkCloseAccount(ctx, dbi);
        DecomposeEntryCollection dec = dbi.getEntries();
        DecomposeEntryInfo dei = null;
        BigDecimal zero = new BigDecimal("0.00");
        int size = dbi.getEntries().size();
        Object[] msg = new String[2];
        msg[0] = "";
        if (dbi.getNumber() != null) {
            msg[0] = dbi.getNumber();
        }
        DecomposeEntryDetailCollection dedc = null;
        DecomposeEntryDetailInfo dedi = null;
        for (int i = 0; i < size; ++i) {
            msg[1] = "" + (i + 1);
            dei = dbi.getEntries().get(i);
            if (dei == null) continue;
            if (dei.getBaseQty().compareTo(zero) <= 0) {
                dec.removeObject((IObjectValue)dei);
                throw new InvBizException(InvBizException.BASEQTYNULL, msg);
            }
            dedc = dei.getEntries();
            for (int j = dedc.size() - 1; j >= 0; --j) {
                dedi = dedc.get(j);
                if (null != dedi.getQty() && dedi.getQty().compareTo(zero) != 0 && null != dedi.getUnit()) continue;
                dedc.remove(dedi);
            }
        }
        return super._submit(ctx, model);
    }

    @Override
    protected void updateInventory(Context ctx, IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo, BizActionEnum bizAction) throws EASBizException, BOSException {
        InventoryUpdateFactory.getLocalInstance((Context)ctx).updateInventory(pk.toString(), bizAction);
    }

    protected String getBillTypeId() {
        return "50957179-0105-1000-e002-2152c0a812fd463ED552";
    }

    @Override
    protected boolean isCheckBaseData() {
        return false;
    }

    @Override
    protected boolean isCheckEntrySourceBillInfo() {
        return false;
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            selector.add("entries.companyOrgUnit.name");
            model = this.getDecomposeBillInfo(ctx, pk, selector);
        }
        this.checkDecomposeMaterialIsSNManager(ctx, pk, (IObjectValue)model);
        InvBillBaseInfo invBillBaseInfo = (InvBillBaseInfo)model;
        this.checkCloseAccount(ctx, invBillBaseInfo);
        super._passAudit(ctx, pk, (IObjectValue)model);
    }

    private void checkDecomposeMaterialIsSNManager(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        InvBillBaseInfo invBillBaseInfo = (InvBillBaseInfo)model;
        StringBuffer sql = new StringBuffer();
        sql.append("select entry.FSeq").append("\r\n");
        sql.append("from T_IM_DecomposeBill bill").append("\r\n");
        sql.append("inner join T_IM_DecomposeEntry entry on entry.FParentId = bill.FId").append("\r\n");
        sql.append("inner join T_IM_DecomposeEntryDetail detail on detail.FDecompEntryID = entry.FId").append("\r\n");
        sql.append("left join T_BD_Material material on material.FId = entry.FMaterialId").append("\r\n");
        sql.append("left join T_BD_MaterialInventory materialInventory on materialInventory.FMaterialId = entry.FMaterialId ").append("\r\n");
        sql.append("    and materialInventory.FOrgUnit = bill.FStorageOrgUnitId").append("\r\n");
        sql.append("where (entry.FUnitId = material.FSeqUnitId or detail.FUnitId = material.FSeqUnitId) ").append("\r\n");
        sql.append("    and materialInventory.FIsSequenceNo = '1'").append("\r\n");
        sql.append("    and bill.FId = ?");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{invBillBaseInfo.getId().toString()});
        StringBuffer lineNum = new StringBuffer();
        String comma = SCMUtils.getResource((String)INV_ADD_RESOURCE, (String)"Comma", (Context)ctx);
        try {
            while (rowSet.next()) {
                lineNum.append(rowSet.getInt("FSeq")).append(comma);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (lineNum.length() > 0) {
            StringBuffer msg = new StringBuffer();
            msg.append(SCMUtils.getResource((String)INV_ADD_RESOURCE, (String)"NUMBER", (Context)ctx)).append(" ").append(invBillBaseInfo.getNumber());
            msg.append(" ").append(SCMUtils.getResource((String)INV_ADD_RESOURCE, (String)"Line", (String[])new String[]{lineNum.toString().substring(0, lineNum.length() - 1)}, (Context)ctx));
            msg.append(" ").append(SCMUtils.getResource((String)INV_ADD_RESOURCE, (String)"MATERIAL_HAS_SN_NOT_ALLOW_DECOMPOSE", (Context)ctx));
            throw new InvBizException(InvBizException.COMMON, new String[]{msg.toString()});
        }
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        InvBillBaseInfo invBillBaseInfo = (InvBillBaseInfo)model;
        this.checkCloseAccount(ctx, invBillBaseInfo);
        super._unpassAudit(ctx, pk, model);
    }
}

