/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryCollection;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;

public abstract class InvBillDataImport
extends AbstractDataTransmission {
    protected InvBillBaseInfo invBill = null;
    protected StorageOrgUnitInfo sou = null;
    protected CompanyOrgUnitInfo cou = null;
    protected String[] PROPERTY_DATE = new String[]{"bizDate"};
    protected String[] PROPERTY_DATE_ENTRY = new String[]{"mfg", "exp"};

    public final CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        this.invBill = null;
        for (int i = 0; i < hsData.size(); ++i) {
            Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
            if (i == 0) {
                this.invBill = this.transmitHead(lineData, ctx);
                if (this.invBill == null) {
                    return null;
                }
                this.transmitHeadCommon(this.invBill, lineData, ctx);
            }
            InvBillBaseEntryInfo entry = this.transmitEntry(lineData, ctx);
            this.transmitEntryCommon(entry, lineData, ctx);
        }
        return this.invBill;
    }

    protected abstract InvBillBaseInfo transmitHead(Hashtable var1, Context var2) throws TaskExternalException;

    protected abstract InvBillBaseEntryInfo transmitEntry(Hashtable var1, Context var2) throws TaskExternalException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void transmitHeadCommon(InvBillBaseInfo invBill, Hashtable lineData, Context ctx) throws TaskExternalException {
        boolean noNumber = false;
        Object numberData = ((DataToken)lineData.get((Object)"number")).data;
        if (numberData != null && numberData.toString().trim().length() > 0) {
            invBill.setNumber(numberData.toString().trim());
            String existId = this.getIdFromNumber(numberData.toString().trim(), ctx);
            boolean isCover = this.isSltImportUpdate();
            if (!isCover && !StringUtil.isEmptyString((String)existId)) {
                throw new TaskExternalException(numberData.toString().trim() + InvBillDataImport.getResource(ctx, "NumberExists"));
            }
            if (isCover && !StringUtil.isEmptyString((String)existId)) {
                try {
                    InvBillBaseInfo existInfo = (InvBillBaseInfo)this.getController(ctx).getValue((IObjectPK)new ObjectUuidPK(existId));
                    if (!BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)existInfo.getBaseStatus())) {
                        throw new TaskExternalException(numberData.toString().trim() + InvBillDataImport.getResource(ctx, "BillNotTmpSaved"));
                    }
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
            }
        } else {
            noNumber = true;
        }
        try {
            Object souData = ((DataToken)lineData.get((Object)"storageOrgUnit")).data;
            if (souData == null || souData.toString().trim().length() <= 0) throw new TaskExternalException(InvBillDataImport.getResource(ctx, "StorageOrgUnitNotNull"));
            IStorageOrgUnit isou = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
            StorageOrgUnitCollection collection = isou.getStorageOrgUnitCollection(this.getEntityViewByNumber(souData.toString().trim()));
            if (collection == null || collection.size() <= 0) throw new TaskExternalException(souData.toString().trim() + " " + InvBillDataImport.getResource(ctx, "StorageOrgUnitNotExists"));
            this.sou = collection.get(0);
            if (!this.sou.isIsBizUnit()) {
                throw new TaskExternalException(InvBillDataImport.getResource(ctx, "StorageOrgUnitIsNotBizUnit"));
            }
            invBill.setStorageOrgUnit(this.sou);
            if (noNumber) {
                String souID = this.sou.getId().toString().trim();
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                if (iCodingRuleManager.isExist((IObjectValue)invBill, souID)) {
                    invBill.setNumber(iCodingRuleManager.getNumber((IObjectValue)invBill, souID, ""));
                } else {
                    IMetaDataLoader iMetaDataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                    EntityObjectInfo entityObjectInfo = iMetaDataLoader.getEntity(this.sou.getBOSType());
                    Object[] materialNames = new String[]{entityObjectInfo.getAlias()};
                    throw new SCMBillException(SCMBillException.NOCORDRULE, materialNames);
                }
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            for (int i = 0; i < this.PROPERTY_DATE.length; ++i) {
                Object date = ((DataToken)lineData.get((Object)this.PROPERTY_DATE[i])).data;
                if (date == null || date.toString().length() <= 0) continue;
                try {
                    date = df.parse(date.toString());
                }
                catch (ParseException e) {
                    throw new TaskExternalException(this.PROPERTY_DATE[i] + InvBillDataImport.getResource(ctx, "InvalidDateFormat") + date.toString());
                }
                if (date == null || !(date instanceof Date)) continue;
                invBill.setDate(this.PROPERTY_DATE[i], (Date)date);
            }
            invBill.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection orgCol = iUnitRel.getToUnit(this.sou.getId().toString(), 4, 1);
            if (orgCol == null || orgCol.get(0) == null) {
                throw new TaskExternalException(InvBillDataImport.getResource(ctx, "StorageOrgUnitNotDelegateCompanyOrgUnit"));
            }
            this.cou = (CompanyOrgUnitInfo)orgCol.get(0);
            invBill.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            invBill.setCreateTime(new Timestamp(new Date().getTime()));
            invBill.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            return;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private void transmitEntryCommon(InvBillBaseEntryInfo entry, Hashtable lineData, Context ctx) throws TaskExternalException {
        InvBillBaseEntryCollection entrys = (InvBillBaseEntryCollection)((Object)this.invBill.get("entry"));
        entry.setSeq(entrys.size() + 1);
        entry.setStorageOrgUnit(this.sou);
        entry.setCompanyOrgUnit(this.cou);
        entrys.add(entry);
    }

    public String getMainField() {
        return "number";
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        return firstNumber != null && (currentNumber.data == null || currentNumber.data.toString().length() == 0 || firstNumber.data.equals(currentNumber.data));
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null || !(coreBaseInfo instanceof CoreBillBaseInfo)) {
            return;
        }
        try {
            CoreBillBaseInfo billBase = (CoreBillBaseInfo)coreBaseInfo;
            String id = this.getIdFromNumber(billBase.getNumber(), ctx);
            if (StringUtil.isEmptyString((String)id)) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                coreBaseInfo.setId(BOSUuid.read((String)id));
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(id), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    protected String getIdFromNumber(String number, Context ctx) throws TaskExternalException {
        CoreBaseCollection collection;
        try {
            collection = this.getController(ctx).getCollection("where number ='" + number + "'");
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        if (collection != null && collection.size() > 0) {
            return collection.get(0).getId().toString();
        }
        return null;
    }

    private EntityViewInfo getEntityViewByNumber(String number) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        return view;
    }

    protected static String getResource(Context ctx, String strKey) {
        if (StringUtil.isEmptyString((String)strKey)) {
            return null;
        }
        return SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvBillDataImportResource", (String)strKey, (Context)ctx);
    }
}

