/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EqualsUtil;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.ILocation;
import com.kingdee.eas.basedata.scm.im.inv.IStoreState;
import com.kingdee.eas.basedata.scm.im.inv.IStoreType;
import com.kingdee.eas.basedata.scm.im.inv.ITransactionInvUpdateType;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationCollection;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateCollection;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.WHStateEnum;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BDStatusEnum;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.ProductLineCollection;
import com.kingdee.eas.mm.basedata.ProductLineFactory;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.IProject;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.app.SCMDataImport;
import com.kingdee.eas.scm.common.app.ScmImportDataCache;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityCollection;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvImportException;
import com.kingdee.eas.scm.im.inv.app.ImportDataCache;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.rpt.app.ImRptAppUtils;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class InvDataImport
extends SCMDataImport {
    public ImportDataCache dataPool = null;
    private static String resources = "com.kingdee.eas.scm.im.inv.app.OtherBillDataImportResource";

    public InvDataImport() {
        this.setDataPool(new ImportDataCache());
    }

    public void setDataPool(ImportDataCache importDataCache) {
        super.setDataPool((ScmImportDataCache)importDataCache);
        this.dataPool = importDataCache;
    }

    public void afterBuildHead(Context ctx, InvBillBaseInfo info, Map lineData) throws TaskExternalException {
        CostCenterOrgUnitInfo costCenter = this.getCostCenter(ctx, lineData, "FCostCenterOrgUnit_number");
        info.setCostCenterOrgUnit(costCenter);
        if (this.isCheckCompany4CostCenter().booleanValue()) {
            this.checkCompanyForOrgs(ctx, costCenter, info.getStorageOrgUnit());
        }
        super.afterBuildHead(ctx, (SCMBillBaseInfo)info, lineData);
    }

    private void checkCompanyForOrgs(Context ctx, CostCenterOrgUnitInfo costCenter, StorageOrgUnitInfo org) throws TaskExternalException {
        if (costCenter == null) {
            return;
        }
        String costCenterNumber = costCenter.getNumber();
        CompanyOrgUnitInfo sCompany = this.dataPool.getCompanyFromStorage(org.getNumber());
        CompanyOrgUnitInfo cCompany = this.dataPool.getCompanyFromCostCenter(costCenterNumber);
        try {
            if (sCompany == null) {
                sCompany = InvServerUtils.getCompanyInfoForStorage(ctx, org);
                this.dataPool.setCompanyFromStorage(org.getNumber(), sCompany);
            }
            if (cCompany == null) {
                cCompany = InvServerUtils.getCompanyInfoForCostCenter(ctx, costCenter);
                this.dataPool.setCompanyFromCostCenter(costCenterNumber, cCompany);
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage());
        }
        if (sCompany == null || cCompany == null || !EqualsUtil.equals((Object)sCompany, (Object)cCompany)) {
            throw new TaskExternalException(costCenterNumber + "  " + InvDataImport.getResources((Context)ctx, (String)"CompanyNotSameForCostCenterAndStorage", (String)resources));
        }
    }

    public void afterBuildEntry(Context ctx, InvBillBaseInfo info, InvBillBaseEntryInfo entry, Map lineData) throws TaskExternalException {
        super.afterBuildEntry(ctx, (SCMBillBaseInfo)info, (SCMBillEntryBaseInfo)entry, lineData);
        CostCenterOrgUnitInfo costCenter = this.getCostCenter(ctx, lineData, "FEntry$CostCenterOrgUnit1_number");
        entry.put("costCenterOrgUnit", costCenter);
        if (this.isCheckCompany4CostCenter().booleanValue()) {
            this.checkCompanyForOrgs(ctx, costCenter, info.getStorageOrgUnit());
        }
        Date mfg = entry.getMfg();
        Date exp = entry.getExp();
        if (mfg == null || exp == null) {
            return;
        }
        if (!exp.after(mfg)) {
            throw new TaskExternalException(InvDataImport.getResources((Context)ctx, (String)"EXPBEFOREMFG", (String)resources));
        }
    }

    protected CostCenterOrgUnitInfo getCostCenter(Context ctx, Map lineData, String fieldNumber) throws TaskExternalException {
        return this.getCostCenterOrgUnit(lineData, ctx, "number", fieldNumber);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CostCenterOrgUnitInfo getCostCenterOrgUnit(Map lineData, Context ctx, String byProperty, String propertyName) throws TaskExternalException {
        if (lineData.get(propertyName) == null) {
            return null;
        }
        Object data = ((DataToken)lineData.get((Object)propertyName)).data;
        CostCenterOrgUnitInfo info = null;
        if (this.isEmpty(data)) {
            return null;
        }
        String costCenterNumber = data.toString().trim();
        if (this.dataPool.getCostCenterOrgUnitInfo(costCenterNumber) != null) return this.dataPool.getCostCenterOrgUnitInfo(costCenterNumber);
        if (costCenterNumber == null) return info;
        if (costCenterNumber.length() <= 0) return info;
        CostCenterOrgUnitCollection collection = null;
        try {
            ICostCenterOrgUnit icostCenter = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
            collection = icostCenter.getCostCenterOrgUnitCollection(this.getOrgFilter(costCenterNumber, byProperty));
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        if (CollectionUtil.isEmpty((AbstractObjectCollection)collection)) throw new TaskExternalException(data.toString() + "  " + InvDataImport.getResources((Context)ctx, (String)"CostCenterOrgUnitNotExists", (String)resources));
        info = collection.get(0);
        if (!info.isIsBizUnit()) {
            throw new TaskExternalException(data.toString() + "  " + InvDataImport.getResources((Context)ctx, (String)"currentUnitIsNotBizUnit", (String)resources));
        }
        this.dataPool.setCostCenterOrgUnitInfo(costCenterNumber, info);
        return info;
    }

    private EntityViewInfo getOrgFilter(String value, String byProperty) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("number");
        selector.add("name");
        selector.add("id");
        selector.add("isBizUnit");
        selector.add("CU.id");
        filter.getFilterItems().add(new FilterItemInfo(byProperty, (Object)value, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        viewInfo.setSelector(selector);
        return viewInfo;
    }

    public Boolean isCheckCompany4CostCenter() {
        return true;
    }

    public void checkQtyPrecision(Context ctx, InvBillBaseEntryInfo invEntryInfo) throws EASBizException, BOSException {
        MultiMeasureUnitInfo multiAssistUnitInfo;
        MultiMeasureUnitInfo multiUnitInfo;
        MaterialInfo materialInfo = invEntryInfo.getMaterial();
        MeasureUnitInfo unitInfo = invEntryInfo.getUnit();
        MeasureUnitInfo baseUnitInfo = invEntryInfo.getBaseUnit();
        MeasureUnitInfo assistUnitInfo = invEntryInfo.getAssistUnit();
        if (materialInfo == null || unitInfo == null) {
            return;
        }
        if (this.dataPool.getMultiMeasureUnitInfo(materialInfo.getId().toString() + unitInfo.getId().toString()) == null) {
            HashSet<String> materialIdSet = new HashSet<String>();
            HashSet<String> unitIdSet = new HashSet<String>();
            materialIdSet.add(materialInfo.getId().toString());
            unitIdSet.add(unitInfo.getId().toString());
            if (baseUnitInfo != null) {
                unitIdSet.add(baseUnitInfo.getId().toString());
            }
            if (assistUnitInfo != null) {
                unitIdSet.add(assistUnitInfo.getId().toString());
            }
            if (materialIdSet.size() > 0 && unitIdSet.size() > 0) {
                Map<String, MultiMeasureUnitInfo> multiUnitMap = InvServerUtils.getMultiMeasureUnitMap(ctx, materialIdSet, unitIdSet);
                this.dataPool.putMultiMeasureUnitMap(multiUnitMap);
            }
        }
        if ((multiUnitInfo = this.dataPool.getMultiMeasureUnitInfo(materialInfo.getId().toString() + unitInfo.getId().toString())) != null) {
            int nowPrecision;
            int qtyPrecision = multiUnitInfo.getQtyPrecision();
            BigDecimal qty = invEntryInfo.getQty();
            if (qty != null && qtyPrecision < (nowPrecision = qty.scale())) {
                throw new InvImportException(InvImportException.QTY_PRECISION_INVALID, new String[]{materialInfo.getName(), unitInfo.getName(), qtyPrecision + ""});
            }
        }
        if (assistUnitInfo != null && (multiAssistUnitInfo = this.dataPool.getMultiMeasureUnitInfo(materialInfo.getId().toString() + assistUnitInfo.getId().toString())) != null) {
            int nowPrecision;
            int assistQtyPrecision = multiAssistUnitInfo.getQtyPrecision();
            BigDecimal assistQty = invEntryInfo.getAssistQty();
            if (assistQty != null && assistQtyPrecision < (nowPrecision = assistQty.scale())) {
                throw new InvImportException(InvImportException.ASSISTQTY_PRECISION_INVALID, new String[]{materialInfo.getName(), assistQtyPrecision + ""});
            }
        }
    }

    public CostObjectInfo getCostObject(Context ctx, CompanyOrgUnitInfo companyOrgUnit, Object data) throws TaskExternalException {
        CostObjectInfo costObjectInfo = null;
        if (companyOrgUnit == null) {
            return null;
        }
        if (null != data && data.toString() != null && 0 < data.toString().trim().length()) {
            String costObjectNumber = data.toString().trim();
            String companyOrgUnitId = companyOrgUnit.getId().toString();
            String key = costObjectNumber + companyOrgUnitId;
            costObjectInfo = this.dataPool.getCostObject(key);
            if (costObjectInfo == null) {
                CostObjectCollection coll;
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                FilterItemCollection filterItems = filterInfo.getFilterItems();
                filterItems.add(new FilterItemInfo("company.id", (Object)companyOrgUnit.getId().toString(), CompareType.EQUALS));
                filterItems.add(new FilterItemInfo("number", (Object)costObjectNumber, CompareType.EQUALS));
                viewInfo.setFilter(filterInfo);
                try {
                    ICostObject ic = CostObjectFactory.getLocalInstance((Context)ctx);
                    coll = ic.getCostObjectCollection(viewInfo);
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                if (null != coll && 0 < coll.size() && coll.get(0) != null) {
                    costObjectInfo = coll.get(0);
                    this.dataPool.setCostObject(key, costObjectInfo);
                } else {
                    throw new TaskExternalException(data.toString() + " " + InvDataImport.getResource((Context)ctx, (String)"costObjectNotExist", (String)resources));
                }
            }
        }
        return costObjectInfo;
    }

    public WarehouseInfo getWarehouse(Context ctx, OrgUnitInfo storageOrgUnit, Object data) throws TaskExternalException {
        return this.getWarehouse(ctx, "number", storageOrgUnit, data, resources, "WarehouseNotActive", "WarehouseNotExists", "warehouseIsNull", "RelationNotExists");
    }

    public WarehouseInfo getWarehouse(Context ctx, String filterPropertyName, OrgUnitInfo storageOrgUnit, Object data, String resources, String warehouseNotEnabledResCode, String warehouseNotExistentResCode, String warehouseNotNullResCode, String warehouseRelationNotExistsResCode) throws TaskExternalException {
        WarehouseInfo warehouseInfo = null;
        if (!this.isEmpty(data)) {
            String warehouseData = data.toString().trim();
            String storageOrgUnitId = storageOrgUnit.getId().toString();
            String key = warehouseData + storageOrgUnitId;
            warehouseInfo = this.dataPool.getWarehouseInfo(key);
            if (warehouseInfo == null) {
                WarehouseCollection collection;
                try {
                    collection = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseCollection(this.getFilter(warehouseData, filterPropertyName));
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                if ((CollectionUtil.isEmpty((AbstractObjectCollection)collection) || collection.get(0) == null) && !StringUtil.isEmpty((String)warehouseNotExistentResCode)) {
                    throw new TaskExternalException(data.toString() + " " + InvDataImport.getResource((Context)ctx, (String)warehouseNotExistentResCode, (String)resources));
                }
                if (!CollectionUtil.isEmpty((AbstractObjectCollection)collection)) {
                    warehouseInfo = collection.get(0);
                }
                if (warehouseInfo != null && !warehouseInfo.getWhState().equals((Object)WHStateEnum.ACTIVE) && !StringUtil.isEmpty((String)warehouseNotExistentResCode)) {
                    throw new TaskExternalException(warehouseInfo.getNumber() + " " + InvDataImport.getResource((Context)ctx, (String)warehouseNotEnabledResCode, (String)resources));
                }
                if (warehouseInfo != null) {
                    this.checkWarehouse(ctx, warehouseInfo, storageOrgUnit, resources, warehouseRelationNotExistsResCode);
                }
                this.dataPool.setWarehouseInfo(key, warehouseInfo);
            }
        } else if (!StringUtil.isEmpty((String)warehouseNotNullResCode)) {
            throw new TaskExternalException(InvDataImport.getResource((Context)ctx, (String)warehouseNotNullResCode, (String)resources));
        }
        return warehouseInfo;
    }

    private EntityViewInfo getWarehouseFilter(String filterPropertyName, String warehouseData) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo(filterPropertyName, (Object)warehouseData, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    private void checkWarehouse(Context ctx, WarehouseInfo warehouseInfo, OrgUnitInfo storageOrgUnit, String resources, String warehouseRelationNotExistsResCode) throws TaskExternalException {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("WAREHOUSE", (Object)warehouseInfo.getId().toString(), CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("STORAGEORG", (Object)storageOrgUnit.getId().toString(), CompareType.EQUALS));
        try {
            if (!SOAccreditWHFactory.getLocalInstance((Context)ctx).exists(filterInfo) && !StringUtil.isEmpty((String)warehouseRelationNotExistsResCode)) {
                throw new TaskExternalException(warehouseInfo.getNumber() + "," + storageOrgUnit.getNumber() + " " + InvDataImport.getResource((Context)ctx, (String)warehouseRelationNotExistsResCode, (String)resources));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public LocationInfo getLocation(Context ctx, Object data, WarehouseInfo warehouseInfo) throws TaskExternalException {
        return this.getLocation(ctx, "number", data, warehouseInfo, resources, "LocationNotActive", "LocationNotExists", "locationIsNull", "LocationMustBeNull");
    }

    public LocationInfo getLocation(Context ctx, String filterPropertyName, Object data, WarehouseInfo warehouseInfo, String resources, String locationNotEnabledResCode, String locationNotExistentResCode, String locationNotBeNullResCode, String locationMustBeNullResCode) throws TaskExternalException {
        if (warehouseInfo == null) {
            return null;
        }
        LocationInfo info = null;
        if (data != null && data.toString() != null && data.toString().trim().length() > 0) {
            if (!warehouseInfo.isHasLocation() && !StringUtil.isEmpty((String)locationMustBeNullResCode)) {
                throw new TaskExternalException(data.toString() + " " + InvDataImport.getResource((Context)ctx, (String)locationMustBeNullResCode, (String)resources));
            }
            if (!warehouseInfo.isHasLocation()) {
                return null;
            }
            String locationData = data.toString().trim();
            String warehouseId = warehouseInfo.getId().toString().trim();
            String key = locationData + warehouseId;
            info = this.dataPool.getLocation(key);
            if (info == null) {
                LocationCollection collection;
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                FilterItemCollection filterItems = filter.getFilterItems();
                filterItems.add(new FilterItemInfo(filterPropertyName, (Object)locationData, CompareType.EQUALS));
                filterItems.add(new FilterItemInfo("warehouse.id", (Object)warehouseId, CompareType.EQUALS));
                viewInfo.setFilter(filter);
                try {
                    ILocation il = LocationFactory.getLocalInstance((Context)ctx);
                    collection = il.getLocationCollection(viewInfo);
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                if ((CollectionUtil.isEmpty((AbstractObjectCollection)collection) || collection.get(0) == null) && !StringUtil.isEmpty((String)locationNotExistentResCode)) {
                    throw new TaskExternalException(data.toString() + " " + InvDataImport.getResource((Context)ctx, (String)locationNotExistentResCode, (String)resources));
                }
                if (!CollectionUtil.isEmpty((AbstractObjectCollection)collection)) {
                    info = collection.get(0);
                }
                if (info != null && !info.getState().equals((Object)WHStateEnum.ACTIVE) && !StringUtil.isEmpty((String)locationNotEnabledResCode)) {
                    throw new TaskExternalException(info.getNumber() + " " + InvDataImport.getResource((Context)ctx, (String)locationNotEnabledResCode, (String)resources));
                }
                this.dataPool.setLocation(key, info);
            }
        }
        if (warehouseInfo.isHasLocation() && info == null && !StringUtil.isEmpty((String)locationNotBeNullResCode)) {
            throw new TaskExternalException(warehouseInfo.getNumber() + InvDataImport.getResource((Context)ctx, (String)locationNotBeNullResCode, (String)resources));
        }
        return info;
    }

    public StoreTypeInfo getStoreType(Context ctx, Object data) throws TaskExternalException {
        StoreTypeInfo info = null;
        if (data != null && data.toString().trim().length() > 0) {
            String number = data.toString().trim();
            info = this.dataPool.getStoreType(data.toString());
            if (info == null) {
                IStoreType is = null;
                StoreTypeCollection collection = null;
                try {
                    is = StoreTypeFactory.getLocalInstance((Context)ctx);
                    collection = is.getStoreTypeCollection(this.getFilter(number));
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                if (collection != null && collection.size() > 0) {
                    info = collection.get(0);
                    this.dataPool.setStoreType(number, info);
                } else {
                    throw new TaskExternalException(number + " " + InvDataImport.getResource((Context)ctx, (String)"storeTypeNotExist", (String)resources));
                }
            }
        }
        return info;
    }

    public StoreStateInfo getStoreState(Context ctx, Object data) throws TaskExternalException {
        String number;
        StoreStateInfo info = null;
        if (data != null && data.toString().trim().length() > 0 && (info = this.dataPool.getStoreState(number = data.toString().trim())) == null) {
            IStoreState is = null;
            StoreStateCollection collection = null;
            try {
                is = StoreStateFactory.getLocalInstance((Context)ctx);
                collection = is.getStoreStateCollection(this.getFilter(number));
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            if (collection != null && collection.size() > 0) {
                info = collection.get(0);
                this.dataPool.setStoreState(number, info);
            } else {
                throw new TaskExternalException(number + " " + InvDataImport.getResource((Context)ctx, (String)"storeStatusNotExist", (String)resources));
            }
        }
        return info;
    }

    public DateOfMinDurabilityInfo transmitEntryDateOfMinDurability(Context ctx, String storageId, String mid, String lot) throws TaskExternalException, BOSException {
        DateOfMinDurabilityInfo info = null;
        if (this.dataPool.getDateOfMinDurabilityInfo(mid + lot) == null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("lot", (Object)lot, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)mid, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageId, CompareType.EQUALS));
            view.setFilter(filterInfo);
            DateOfMinDurabilityCollection dateCol = null;
            dateCol = DateOfMinDurabilityFactory.getLocalInstance(ctx).getDateOfMinDurabilityCollection(view);
            if (dateCol != null && dateCol.size() > 0) {
                info = dateCol.get(0);
                this.dataPool.setDateOfMinDurabilityInfo(mid + lot, info);
            }
        } else {
            info = this.dataPool.getDateOfMinDurabilityInfo(mid + lot);
        }
        return info;
    }

    public PersonInfo getStocker(Context ctx, Object data) throws TaskExternalException {
        return this.getPerson(ctx, data, resources, "stockerNotExists");
    }

    public void transmitEntryProjectNumber(Context ctx, InvBillBaseEntryInfo invEntryInfo, StorageOrgUnitInfo sou, Object data, String resources, String resCode) throws TaskExternalException, BOSException {
        String number = data.toString().trim();
        IProject iProject = ProjectFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(4));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", status, CompareType.INCLUDE));
        FilterInfo filter2 = new FilterInfo();
        CtrlUnitInfo cu = null;
        if (sou != null) {
            cu = sou.getCU();
        }
        ObjectUuidPK cuPK = null;
        cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
        try {
            filter2 = iProject.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (filter2 != null) {
            filter.mergeFilter(filter2, "and");
        }
        viewInfo.setFilter(filter);
        ProjectCollection coll = iProject.getProjectCollection(viewInfo);
        if (CollectionUtil.isEmpty((AbstractObjectCollection)coll)) {
            throw new TaskExternalException(data.toString() + " " + InvDataImport.getResource((Context)ctx, (String)resCode, (String)resources));
        }
        ProjectInfo projectInfo = coll.get(0);
        invEntryInfo.setProject(projectInfo);
    }

    public void transmitEntryTrackNumber(Context ctx, InvBillBaseEntryInfo invEntryInfo, StorageOrgUnitInfo sou, Object data, String resources, String resCode) throws TaskExternalException, BOSException {
        String number = data.toString().trim();
        ITrackNumber iTrackNumber = TrackNumberFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(10);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", status, CompareType.INCLUDE));
        FilterInfo filter2 = new FilterInfo();
        CtrlUnitInfo cu = null;
        if (sou != null) {
            cu = sou.getCU();
        }
        ObjectUuidPK cuPK = null;
        cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
        try {
            filter2 = iTrackNumber.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (filter2 != null) {
            filter.mergeFilter(filter2, "and");
        }
        viewInfo.setFilter(filter);
        TrackNumberCollection coll = iTrackNumber.getTrackNumberCollection(viewInfo);
        if (CollectionUtil.isEmpty((AbstractObjectCollection)coll)) {
            throw new TaskExternalException(data.toString() + " " + InvDataImport.getResource((Context)ctx, (String)resCode, (String)resources));
        }
        TrackNumberInfo trackNumberInfo = coll.get(0);
        invEntryInfo.setTrackNumber(trackNumberInfo);
    }

    protected StorageOrgUnitInfo getStorageOrgUnit(Context ctx, String propertyName, Object data) throws TaskExternalException {
        return this.getStorageOrgUnit(ctx, propertyName, data, resources, new String[]{"StorageOrgUnitNotNull", "StorageOrgUnitIsNotBizUnit", "StorageOrgUnitNotExists"});
    }

    protected StorageOrgUnitInfo getStorageOrgUnit(Context ctx, String propertyName, Object data, String sourceFile, String[] sourceItems) throws TaskExternalException {
        if (this.isEmpty(data)) {
            throw new TaskExternalException(InvDataImport.getResource((Context)ctx, (String)sourceItems[0], (String)sourceFile));
        }
        String key = data.toString().trim();
        StorageOrgUnitInfo sou = this.dataPool.getStorageOrgUnitInfo(key);
        if (sou != null) {
            return sou;
        }
        sou = (StorageOrgUnitInfo)this.getOrgUnit(ctx, this.getFilter(key, propertyName), StorageOrgUnitInfo.class);
        if (sou == null) {
            throw new TaskExternalException(InvDataImport.getResource((Context)ctx, (String)sourceItems[2], (String)sourceFile));
        }
        if (!sou.isIsBizUnit()) {
            throw new TaskExternalException(InvDataImport.getResource((Context)ctx, (String)sourceItems[1], (String)sourceFile));
        }
        this.dataPool.setStorageOrgUnitInfo(key, sou);
        return sou;
    }

    protected CompanyOrgUnitInfo getCompanyOrgFromStorageOrg(Context ctx, StorageOrgUnitInfo sou) throws TaskExternalException {
        CompanyOrgUnitInfo companyOrg = this.dataPool.getCompanyFromStorage(sou.getNumber());
        if (companyOrg != null) {
            return companyOrg;
        }
        try {
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection orgCol = iUnitRel.getToUnit(sou.getId().toString(), 4, 1);
            if (orgCol.get(0) == null) {
                throw new TaskExternalException(InvDataImport.getResource((Context)ctx, (String)"NoCompanyOrgUnit", (String)resources));
            }
            companyOrg = (CompanyOrgUnitInfo)orgCol.get(0);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("name");
            selector.add("baseCurrency.precision");
            selector.add("baseCurrency.id");
            selector.add("baseCurrency.name");
            selector.add("baseCurrency.number");
            selector.add("baseExchangeTable.id");
            companyOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrg.getId()), selector);
            this.dataPool.setCompanyFromStorage(sou.getNumber(), companyOrg);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return companyOrg;
    }

    protected boolean checkLotInfo(Context ctx, MaterialInfo materialInfo, StorageOrgUnitInfo sou) throws TaskExternalException {
        MaterialInventoryInfo materialInventoryInfo = this.getMaterialInventory(ctx, materialInfo, sou);
        if (materialInventoryInfo == null) {
            return false;
        }
        return materialInventoryInfo.isIsLotNumber();
    }

    protected Date[] getMfgAndExp(Context ctx, MaterialInfo material, String lot, StorageOrgUnitInfo sou, Object mfg, Object exp) throws TaskExternalException {
        return this.getMfgAndExp(ctx, material, lot, sou, mfg, exp, true);
    }

    protected Date[] getMfgAndExp(Context ctx, MaterialInfo material, String lot, StorageOrgUnitInfo sou, Object mfg, Object exp, Boolean isNeed) throws TaskExternalException {
        MaterialInventoryInfo materialInventory = this.getMaterialInventory(ctx, material, sou);
        Date[] dateArray = this.getMfgAndExp(ctx, material, lot, sou);
        if (materialInventory != null && materialInventory.isIsPeriodValid()) {
            Date expDate;
            Date mfgDate;
            if (mfg != null && mfg.toString().trim().length() > 0 && (mfgDate = ImRptAppUtils.formatNationalDate(ctx, mfg.toString().trim())) != null && materialInventory.isIsPeriodValid()) {
                dateArray[0] = mfgDate;
            }
            if (exp != null && exp.toString().trim().length() > 0 && (expDate = ImRptAppUtils.formatNationalDate(ctx, exp.toString().trim())) != null && materialInventory.isIsPeriodValid()) {
                dateArray[1] = expDate;
            }
            if ((dateArray[0] == null || dateArray[1] == null) && isNeed.booleanValue()) {
                throw new TaskExternalException(InvDataImport.getResource((Context)ctx, (String)"IsPeriodValidNoExpandMfg", (String)resources));
            }
        }
        return dateArray;
    }

    protected Date[] getMfgAndExp(Context ctx, MaterialInfo material, String lot, StorageOrgUnitInfo sou) throws TaskExternalException {
        MaterialInventoryInfo materialInventory = this.getMaterialInventory(ctx, material, sou);
        Date[] dateArray = null;
        if (materialInventory != null && materialInventory.isIsPeriodValid()) {
            dateArray = new Date[2];
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("lot", (Object)lot, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)sou.getId().toString(), CompareType.EQUALS));
            view.setFilter(filterInfo);
            DateOfMinDurabilityCollection dateCol = null;
            try {
                dateCol = DateOfMinDurabilityFactory.getLocalInstance(ctx).getDateOfMinDurabilityCollection(view);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            if (dateCol != null && dateCol.size() > 0) {
                DateOfMinDurabilityInfo dateInfo = dateCol.get(0);
                dateArray[0] = dateInfo.getMfg();
                dateArray[1] = dateInfo.getExp();
            }
        }
        return dateArray;
    }

    protected boolean checkSupplierLotInfo(Context ctx, MaterialInfo materialInfo, StorageOrgUnitInfo storageOrgUnitInfo) throws TaskExternalException {
        MaterialInventoryInfo materialInventoryInfo = this.getMaterialInventory(ctx, materialInfo, storageOrgUnitInfo);
        if (materialInventoryInfo == null) {
            return false;
        }
        return materialInventoryInfo.isIsBatchNo();
    }

    public InvUpdateTypeInfo getInvUpdateType(Context ctx, String filterPropertyName, TransactionTypeInfo transactionTypeInfo, Object data) throws TaskExternalException {
        if (transactionTypeInfo == null) {
            return null;
        }
        String transactionTypeId = transactionTypeInfo.getId().toString();
        String filterData = data.toString().trim();
        String key = filterData + transactionTypeId;
        InvUpdateTypeInfo updateTypeInfo = this.dataPool.getInvUpdateTypeInfo(key);
        if (updateTypeInfo == null) {
            ITransactionInvUpdateType iTransactionInvUpdateType;
            try {
                iTransactionInvUpdateType = TransactionInvUpdateTypeFactory.getLocalInstance((Context)ctx);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            if (!this.isEmpty(filterData)) {
                TransactionInvUpdateTypeCollection coll;
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                FilterItemCollection filterItems = filterInfo.getFilterItems();
                filterItems.add(new FilterItemInfo("transactiontype.id", (Object)transactionTypeId, CompareType.EQUALS));
                filterItems.add(new FilterItemInfo("invUpdateType." + filterPropertyName, (Object)filterData, CompareType.EQUALS));
                viewInfo.setFilter(filterInfo);
                try {
                    coll = iTransactionInvUpdateType.getTransactionInvUpdateTypeCollection(viewInfo);
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                if (!CollectionUtil.isEmpty((AbstractObjectCollection)coll) && coll.get(0) != null && coll.get(0).getInvUpdateType() != null) {
                    updateTypeInfo = coll.get(0).getInvUpdateType();
                    this.dataPool.setInvUpdateTypeMapInfo(key, updateTypeInfo);
                } else {
                    throw new TaskExternalException(InvDataImport.getResource((Context)ctx, (String)"InvUpdateType_NOT_EXIST", (String)resources));
                }
            }
        }
        if (updateTypeInfo == null) {
            throw new TaskExternalException(InvDataImport.getResource((Context)ctx, (String)"InvUpdateType_isNull", (String)resources));
        }
        return updateTypeInfo;
    }

    public ProductLineInfo getProductLineByNumber(Context ctx, String number) throws TaskExternalException {
        if (StringUtils.isBlank((String)number)) {
            return null;
        }
        ProductLineInfo productLineInfo = null;
        ProductLineInfo productLine = this.dataPool.getProductLine(number);
        if (productLine != null) {
            return productLine;
        }
        try {
            ProductLineCollection collectionProductLine = ProductLineFactory.getLocalInstance((Context)ctx).getProductLineCollection(this.getFilter(number));
            if (collectionProductLine != null && collectionProductLine.size() > 0) {
                productLineInfo = collectionProductLine.get(0);
                this.dataPool.setProductLine(number, productLineInfo);
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return productLineInfo;
    }

    public ProductLineInfo getProductLineByNumberAndCheck(Context ctx, String number, String resources) throws TaskExternalException {
        ProductLineInfo productLine = this.getProductLineByNumber(ctx, number);
        if (productLine == null) {
            throw new TaskExternalException(number + " " + InvDataImport.getResource((Context)ctx, (String)"ProductLineNotExists", (String)resources));
        }
        if (!productLine.getStatus().equals((Object)BDStatusEnum.APPROVE)) {
            throw new TaskExternalException(number + " " + InvDataImport.getResource((Context)ctx, (String)"ProductLineNotActive", (String)resources));
        }
        return productLine;
    }
}

