/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.scm.im.inv.app.AbstractInvMaterialPlanFacadeControllerBean;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class InvMaterialPlanFacadeControllerBean
extends AbstractInvMaterialPlanFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.InvMaterialPlanFacadeControllerBean");

    @Override
    protected IObjectCollection _getMaterialPlanCollection(Context ctx, String orgUnitId, Set queryMatIDs) throws BOSException {
        MaterialPlanCollection collection = new MaterialPlanCollection();
        try {
            String sql = "select mp.fid as fid, mp.fproductunitid as fproductunitid, mu.fnumber as fmuNumber, mu.fname_" + this.getLoc(ctx) + " as fmuName, mp.fisolatedrule as fisolatedrule, mp.fmaterialid as fmaterialid, mm.fnumber as fmaterialNum ,mm.fname_" + this.getLoc(ctx) + " as fmaterialName, mm.flongnumber as fmaterialLongNum, mm.fshortname as fmaterialShortName, mp.forgunit as forgunit, baseunit.fnumber as forgNum, baseunit.fname_" + this.getLoc(ctx) + " as forgName ,mp.feffectedstatus as feffectedstatus, mp.ffreezeorgunit as ffreezeorgunit, bu.fname_" + this.getLoc(ctx) + " as forgName2, mp.fstatus as fstatus, mp.fcreatorid as fcreatorid, user1.fname_" + this.getLoc(ctx) + " as fcreator, mp.flastupdateuserid as flastupdateuserid, user2.fname_" + this.getLoc(ctx) + " as flastupdateuser, mp.fcreatetime as fcreatetime, mp.flastupdatetime as flastupdatetime, mp.fmanufacturestrategyid as fmanufacturestrategyid, ms.fnumber as fmanuNum, ms.fname_" + this.getLoc(ctx) + " as fmanuName from t_bd_materialplan mp left outer join t_bd_measureunit mu on mp.fproductunitid = mu.fid left outer join t_bd_material mm on mp.fmaterialid = mm.fid left outer join t_org_baseunit baseunit on baseunit.fid = mp.forgunit left outer join t_org_baseunit bu on bu.fid = mp.ffreezeorgunit left outer join t_bd_manufacturestrategy ms on ms.fid = mp.fmanufacturestrategyid left outer join t_pm_user user1 on mp.fcreatorid = user1.fid left outer join t_pm_user user2 on mp.flastupdateuserid = user2.fid where mp.forgunit = '" + orgUnitId + "' and mp.fmaterialid in (" + this.getMatIdString(queryMatIDs) + ")";
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql, null);
            while (rs.next()) {
                MaterialPlanInfo planInfo = new MaterialPlanInfo();
                planInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                MeasureUnitInfo measureUnitInfo = new MeasureUnitInfo();
                if (rs.getString("fproductunitid") != null) {
                    measureUnitInfo.setId(BOSUuid.read((String)rs.getString("fproductunitid")));
                    measureUnitInfo.setNumber(rs.getString("fmuNumber"));
                    measureUnitInfo.setName(rs.getString("fmuName"));
                }
                planInfo.setProductUnit(measureUnitInfo);
                MaterialInfo materialInfo = new MaterialInfo();
                if (rs.getString("fmaterialid") != null) {
                    materialInfo.setId(BOSUuid.read((String)rs.getString("fmaterialid")));
                    materialInfo.setNumber(rs.getString("fmaterialNum"));
                    materialInfo.setName(rs.getString("fmaterialName"));
                    materialInfo.setLongNumber(rs.getString("fmaterialLongNum"));
                    materialInfo.setShortName(rs.getString("fmaterialShortName"));
                }
                planInfo.setMaterial(materialInfo);
                FullOrgUnitInfo orgUnitInfo = new FullOrgUnitInfo();
                if (rs.getString("forgunit") != null) {
                    orgUnitInfo.setId(BOSUuid.read((String)rs.getString("forgunit")));
                    orgUnitInfo.setNumber(rs.getString("forgNum"));
                    orgUnitInfo.setName(rs.getString("forgName"));
                }
                planInfo.setOrgUnit(orgUnitInfo);
                planInfo.setEffectedStatus(rs.getInt("feffectedstatus"));
                FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                if (rs.getString("ffreezeorgunit") != null) {
                    fullOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("ffreezeorgunit")));
                    fullOrgUnitInfo.setName(rs.getString("forgName2"));
                }
                planInfo.setFreezeOrgUnit(fullOrgUnitInfo);
                planInfo.setStatus(UsedStatusEnum.getEnum((int)rs.getInt("fstatus")));
                UserInfo creator = new UserInfo();
                if (rs.getString("fcreatorid") != null) {
                    creator.setId(BOSUuid.read((String)rs.getString("fcreatorid")));
                    creator.setName(rs.getString("fcreator"));
                }
                planInfo.setCreator(creator);
                UserInfo updateUser = new UserInfo();
                if (rs.getString("flastupdateuserid") != null) {
                    updateUser.setId(BOSUuid.read((String)rs.getString("flastupdateuserid")));
                    updateUser.setName(rs.getString("flastupdateuser"));
                }
                planInfo.setLastUpdateUser(updateUser);
                planInfo.setCreateTime(rs.getTimestamp("fcreatetime"));
                planInfo.setLastUpdateTime(rs.getTimestamp("flastupdatetime"));
                planInfo.setIsolatedRule(IsolatedRuleEnum.getEnum((String)rs.getString("fisolatedrule")));
                ManufactureStrategyInfo msInfo = new ManufactureStrategyInfo();
                if (rs.getString("fmanufacturestrategyid") != null) {
                    msInfo.setId(BOSUuid.read((String)rs.getString("fmanufacturestrategyid")));
                    msInfo.setNumber(rs.getString("fmanuNum"));
                    msInfo.setName(rs.getString("fmanuName"));
                }
                planInfo.setManufactureStrategy(msInfo);
                collection.add(planInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException("sql Execute Error :", (Throwable)e);
        }
        return collection;
    }

    @Override
    protected MaterialPlanInfo _getMaterialPlanInfo(Context ctx, String matid, String ouid) throws BOSException {
        HashSet<String> queryMatIDs = new HashSet<String>();
        queryMatIDs.add(matid);
        MaterialPlanInfo planInfo = new MaterialPlanInfo();
        MaterialPlanCollection con = (MaterialPlanCollection)this._getMaterialPlanCollection(ctx, ouid, queryMatIDs);
        if (con != null && con.size() >= 1) {
            for (int i = 0; i < con.size(); ++i) {
                planInfo = con.get(i);
                if (!planInfo.getOrgUnit().getId().toString().equals(ouid)) continue;
                return planInfo;
            }
            return con.get(0);
        }
        planInfo = null;
        return planInfo;
    }

    private String getMatIdString(Set queryMatIDs) {
        String matIdStr = "";
        for (Object matId : queryMatIDs) {
            matIdStr = matIdStr + "'" + matId.toString() + "',";
        }
        matIdStr = matIdStr.substring(0, matIdStr.lastIndexOf(","));
        return matIdStr;
    }

    private String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }
}

