/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreFlagEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.framework.util.CommonUtils;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractInvMaterialQueryFacadeControllerBean;
import com.kingdee.eas.scm.im.inv.app.InventorySumPageHelper;
import com.kingdee.eas.scm.im.inv.app.MaterialQueryPageHelper;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.scm.util.entity.EntityObjectInfoHelp;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class InvMaterialQueryFacadeControllerBean
extends AbstractInvMaterialQueryFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.InvMaterialQueryFacadeControllerBean");

    @Override
    protected Map _queryInventoryByMaterial(Context ctx, Map paramMap) throws BOSException {
        Map<String, Object> condition = this.getFilterData(ctx, paramMap);
        MaterialQueryPageHelper helper = new MaterialQueryPageHelper(ctx, condition);
        TransactionTypeInfo tti = null;
        if (paramMap.get("transactionType") != null) {
            tti = (TransactionTypeInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)paramMap.get("transactionType").toString(), TransactionTypeInfo.class);
        }
        try {
            String bosType = JSONUtils.convertJsonToObject((Context)ctx, (String)paramMap.get("model").toString()).get("bosType").toString();
            IObjectValue billInfo = this.getModelByJson(ctx, bosType, paramMap.get("model").toString());
            String entryBosType = JSONUtils.convertJsonToObject((Context)ctx, (String)paramMap.get("rowModel").toString()).get("bosType").toString();
            IObjectValue billEntryInfo = this.getModelByJson(ctx, entryBosType, paramMap.get("rowModel").toString());
            StorageOrgUnitInfo storageOrgUnit = null;
            if (paramMap.get("storageOrgUnit") instanceof Map) {
                JSONObject souJson = JSONObject.fromObject(paramMap.get("storageOrgUnit"));
                storageOrgUnit = (StorageOrgUnitInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)souJson.toString(), StorageOrgUnitInfo.class);
            } else {
                storageOrgUnit = (StorageOrgUnitInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)paramMap.get("storageOrgUnit").toString(), StorageOrgUnitInfo.class);
            }
            String entryName = paramMap.get("entryName").toString();
            return helper.getData(tti, billInfo, billEntryInfo, entryName, storageOrgUnit);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _queryinventoryGeneralDetail(Context ctx, Map param) throws BOSException, EASBizException {
        MaterialQueryPageHelper helper = new MaterialQueryPageHelper(ctx, null);
        return helper.getInventoryGeneralDetail(param);
    }

    private Map<String, Object> getFilterData(Context ctx, Map paramMap) throws BOSException {
        String lot = paramMap.get("lot").toString();
        String assistProperty = paramMap.get("assistProperty").toString();
        boolean isLikeQuery = (Boolean)paramMap.get("isLikeQuery");
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("lot", lot);
        condition.put("assistProperty", assistProperty);
        condition.put("isLikeQuery", isLikeQuery);
        if (paramMap.get("fieldJson") != null) {
            Map fieldMap = (Map)paramMap.get("fieldJson");
            Map invFieldMap = (Map)paramMap.get("invFieldMap");
            Map<String, Object> resultMap = this.getFieldMap(ctx, fieldMap, invFieldMap);
            condition.put("fieldMap", resultMap.get("dataMap"));
            condition.put("nullValueFieldSet", resultMap.get("nullValueFieldSet"));
        }
        return condition;
    }

    private Map<String, Object> getFieldMap(Context ctx, Map fieldMap, Map invFieldMap) throws BOSException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        HashSet nullValueFieldSet = new HashSet();
        resultMap.put("dataMap", dataMap);
        resultMap.put("nullValueFieldSet", nullValueFieldSet);
        Set keySet = fieldMap.keySet();
        Iterator it = keySet.iterator();
        dataMap.put("FStoreTypeID", null);
        dataMap.put("FStoreStatusID", null);
        dataMap.put("FSupplierID", null);
        dataMap.put("FCustomerID", null);
        dataMap.put("FAssistPropertyID", null);
        dataMap.put("FProjectID", null);
        dataMap.put("FTrackNumberID", null);
        dataMap.put("FLocationID", null);
        dataMap.put("FWarehouseID", null);
        dataMap.put("FUnitID", null);
        dataMap.put("FLot", null);
        try {
            while (it.hasNext()) {
                String key = it.next().toString();
                Object value = fieldMap.get(key);
                if (key.endsWith("ID")) continue;
                if (value == null || "".equals(value)) {
                    if (key.equals("FWarehouseIDpk_hide")) continue;
                    nullValueFieldSet.add(invFieldMap.get(key));
                    continue;
                }
                if (key.endsWith("pk_hide")) {
                    if (key.equals("FStorageOrgUnitIDpk_hide")) {
                        StorageOrgUnitInfo orgInfo = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(value.toString()));
                        dataMap.put((String)invFieldMap.get(key), orgInfo);
                        continue;
                    }
                    BOSObjectType billBosType = BOSUuid.getBOSObjectType((String)value.toString(), (boolean)true);
                    EntityObjectInfo entityObj = EntityObjectInfoHelp.getEntity((BOSObjectType)billBosType);
                    Class infoClass = entityObj.getObjectValueClazzRuntime();
                    IObjectValue info = (IObjectValue)infoClass.newInstance();
                    info.setBOSUuid("id", BOSUuid.read((String)value.toString()));
                    dataMap.put((String)invFieldMap.get(key), info);
                    continue;
                }
                dataMap.put(key, value);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return resultMap;
    }

    protected StringBuilder getSupCustomerWhereSQL(StringBuilder sup, StringBuilder cust, JSONObject jsonObject) {
        StringBuilder sb = new StringBuilder();
        if (jsonObject.get("invUpdateType") != null) {
            JSONObject json = JSONObject.fromObject((Object)jsonObject.get("invUpdateType").toString());
            if (json.get("storeType") == null || ((JSONObject)json.get("storeType")).isNullObject() || sup.length() == 0 && cust.length() == 0) {
                return sb;
            }
            JSONObject storeTypeInfo = JSONObject.fromObject((Object)json.get("storeType").toString());
            if (StoreFlagEnum.SUPPLIER.equals(storeTypeInfo.get("storeFlag")) || StoreFlagEnum.TOSUPPLIER.equals(storeTypeInfo.get("storeFlag"))) {
                sb.append((CharSequence)sup);
            }
            if (StoreFlagEnum.CUSTOMER.equals(storeTypeInfo.get("storeFlag")) || StoreFlagEnum.TOCUSTOMER.equals(storeTypeInfo.get("storeFlag"))) {
                sb.append((CharSequence)cust);
            }
        } else {
            return sb;
        }
        return sb;
    }

    protected String getPropStringValue(Object propValue) {
        if (propValue == null) {
            return null;
        }
        String propStr = "";
        propStr = propValue instanceof IObjectValue ? ((IObjectValue)propValue).get("id").toString() : (propValue instanceof Boolean ? ((Boolean)propValue != false ? "1" : "0") : (propValue instanceof Date ? DateTimeUtil.getFmtDate((Date)((Date)propValue)) : propValue.toString()));
        return propStr;
    }

    @Override
    protected Map _queryInvRelationInfo(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        HashMap<String, String> billPropertys = new HashMap<String, String>();
        List results = (List)paramMap.get("selectDataArr");
        boolean isIssue = (Boolean)paramMap.get("isIssue");
        boolean isStockTransferBill = (Boolean)paramMap.get("isStockTransferBill");
        String entryBosType = JSONUtils.convertJsonToObject((Context)ctx, (String)paramMap.get("rowModel").toString()).get("bosType").toString();
        IObjectValue entryInfo = this.getModelByJson(ctx, entryBosType, paramMap.get("rowModel").toString());
        String bosType = JSONUtils.convertJsonToObject((Context)ctx, (String)paramMap.get("model").toString()).get("bosType").toString();
        IObjectValue billInfo = this.getModelByJson(ctx, bosType, paramMap.get("model").toString());
        String entryName = paramMap.get("entryName").toString();
        int rowIndex = Integer.parseInt(entryInfo.get("rowIndex").toString());
        IObjectValue billEntryInfo = ((AbstractObjectCollection)billInfo.get(entryName)).getObject(rowIndex);
        String materialID = paramMap.get("materialID").toString();
        String transactionTypeID = paramMap.get("transactionTypeID").toString();
        HashMap mapping = JSONUtils.convertJsonToObject((Context)ctx, (String)paramMap.get("mapping").toString());
        HashMap linkPropBosTypeMap = JSONUtils.convertJsonToObject((Context)ctx, (String)paramMap.get("linkPropBosTypeMap").toString());
        ArrayList tableHeadKeyList = (ArrayList)paramMap.get("tableHeadKeyList");
        HashMap fieldTypeMap = JSONUtils.convertJsonToObject((Context)ctx, (String)paramMap.get("fieldTypeMap").toString());
        ArrayList<CoreBillEntryBaseInfo> entryList = new ArrayList<CoreBillEntryBaseInfo>();
        Map hmResult = null;
        CoreBillEntryBaseInfo value = (CoreBillEntryBaseInfo)billEntryInfo;
        String qtyProperty = mapping.get("FCurStoreQty").toString();
        String baseQtyProperty = mapping.get("FBaseQty").toString();
        String materialProperty = mapping.get("FMaterialID").toString();
        String assistQtyProperty = mapping.get("FCurStoreAssistQty").toString();
        String realBaseQtyProperty = "";
        String realQtyProperty = "";
        String realUnitProperty = "";
        String realMaterialProperty = "";
        String realAssistQtyProperty = "";
        if (!StringUtil.isEmpty((String)baseQtyProperty) && baseQtyProperty.indexOf(".") > -1) {
            realBaseQtyProperty = baseQtyProperty.substring(baseQtyProperty.lastIndexOf(".") + 1);
        }
        if (!StringUtil.isEmpty((String)qtyProperty) && qtyProperty.indexOf(".") > -1) {
            realQtyProperty = qtyProperty.substring(qtyProperty.lastIndexOf(".") + 1);
        }
        if (!StringUtil.isEmpty((String)materialProperty) && materialProperty.indexOf(".") > -1) {
            realMaterialProperty = materialProperty.substring(materialProperty.lastIndexOf(".") + 1);
        }
        if (!StringUtil.isEmpty((String)assistQtyProperty) && assistQtyProperty.indexOf(".") > -1) {
            realAssistQtyProperty = assistQtyProperty.substring(qtyProperty.lastIndexOf(".") + 1);
        }
        if (StringUtil.isEmpty((String)realBaseQtyProperty) || StringUtil.isEmpty((String)realQtyProperty)) {
            dataMap.put("entryList", entryList);
            return dataMap;
        }
        boolean isQtyEnough = false;
        BigDecimal totalBaseQty = BigDecimal.ZERO;
        BigDecimal totalQty = BigDecimal.ZERO;
        BigDecimal curRowBaseQty = BigDecimal.ZERO;
        BigDecimal curRowQty = BigDecimal.ZERO;
        BigDecimal curRowAssistQty = BigDecimal.ZERO;
        BigDecimal baseQty = billEntryInfo.getBigDecimal(realBaseQtyProperty) == null ? BigDecimal.ZERO : billEntryInfo.getBigDecimal(realBaseQtyProperty);
        boolean isQtyRemain = !isIssue && baseQty.compareTo(BigDecimal.ZERO) != 0;
        baseQty = baseQty.abs();
        BigDecimal qty = billEntryInfo.getBigDecimal(realQtyProperty) == null ? BigDecimal.ZERO : billEntryInfo.getBigDecimal(realQtyProperty).abs();
        BigDecimal realBaseQty = BigDecimal.ZERO;
        BigDecimal realQty = BigDecimal.ZERO;
        int size = results.size();
        for (int index = 0; index < size; ++index) {
            if (index == 0) {
                value = (CoreBillEntryBaseInfo)billEntryInfo;
            } else {
                value = (CoreBillEntryBaseInfo)((CoreBillEntryBaseInfo)billEntryInfo).clone();
                if (billEntryInfo.getBOSType() != null) {
                    BOSUuid id = BOSUuid.create((String)billEntryInfo.getBOSType().toString());
                    value.put("id", (Object)id);
                }
            }
            hmResult = (Map)results.get(index);
            curRowBaseQty = BigDecimal.ZERO;
            if (hmResult.get("FBaseQty") != null && hmResult.get("FBaseQty").toString().length() > 0) {
                curRowBaseQty = new BigDecimal(hmResult.get("FBaseQty").toString());
            }
            if (curRowBaseQty.compareTo(BigDecimal.ZERO) < 0) {
                curRowBaseQty = BigDecimal.ZERO;
            }
            curRowQty = BigDecimal.ZERO;
            if (hmResult.get("FCurStoreQty") != null && hmResult.get("FCurStoreQty").toString().length() > 0) {
                curRowQty = new BigDecimal(hmResult.get("FCurStoreQty").toString());
            }
            if (curRowQty.compareTo(BigDecimal.ZERO) < 0) {
                curRowQty = BigDecimal.ZERO;
            }
            if (baseQty.compareTo(BigDecimal.ZERO) > 0 && totalBaseQty.add(curRowBaseQty).compareTo(baseQty) >= 0) {
                isQtyEnough = true;
                curRowBaseQty = baseQty.subtract(totalBaseQty);
                curRowQty = this.getQtyFromBaseQty(materialID, (String)hmResult.get("FUnitIDpk_hide"), curRowBaseQty);
            } else {
                realBaseQty = baseQty.subtract(totalBaseQty);
                totalBaseQty = totalBaseQty.add(curRowBaseQty);
                realQty = this.getQtyFromBaseQty(materialID, (String)hmResult.get("FUnitIDpk_hide"), realBaseQty);
            }
            curRowQty = this.getQtyFromBaseQty(materialID, (String)hmResult.get("FUnitIDpk_hide"), curRowBaseQty);
            if (hmResult.get("FCurStoreAssistQty") != null && hmResult.get("FCurStoreAssistQty").toString().length() > 0) {
                MeasureUnitInfo assistUnit;
                BigDecimal curAssistQty = BigDecimal.ZERO;
                if (billEntryInfo.get("assistqty") != null) {
                    curAssistQty = (BigDecimal)billEntryInfo.get("assistqty");
                }
                if ((assistUnit = (MeasureUnitInfo)billEntryInfo.get("assistunit")) != null) {
                    if (curRowAssistQty.compareTo(BigDecimal.ZERO) > 0) {
                        curRowAssistQty = this.getQtyFromBaseQty(materialID, assistUnit.getId().toString(), curRowBaseQty);
                    } else if (baseQty.compareTo(BigDecimal.ZERO) == 0) {
                        curRowAssistQty = curAssistQty.compareTo(BigDecimal.ZERO) == 1 ? (BigDecimal)billEntryInfo.get("assistqty") : ((curRowBaseQty = new BigDecimal(hmResult.get("FBaseQty").toString())).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : new BigDecimal(hmResult.get("FCurStoreAssistQty").toString()));
                    } else if (curRowBaseQty.compareTo(baseQty) >= 0) {
                        if (curAssistQty.compareTo(BigDecimal.ZERO) == 0) {
                            if (assistUnit != null) {
                                curRowAssistQty = this.getQtyFromBaseQty(materialID, assistUnit.getId().toString(), curRowBaseQty);
                            }
                        } else {
                            curRowAssistQty = curAssistQty;
                        }
                    } else {
                        curRowAssistQty = new BigDecimal(hmResult.get("FCurStoreAssistQty").toString());
                    }
                }
            }
            Set<String> f12InvFileds = this.getNotReturnValueFileds();
            String invField = null;
            String billProperty = null;
            int hsize = tableHeadKeyList.size();
            for (int i = 0; i < hsize; ++i) {
                invField = (String)tableHeadKeyList.get(i);
                billProperty = (String)mapping.get(invField);
                if (f12InvFileds.contains(invField) && index == 0) {
                    value.put("f12Inv", (Object)hmResult);
                    billPropertys.put(invField, billProperty);
                    continue;
                }
                this.putData(billProperty, invField, hmResult, (IObjectValue)value, entryName, mapping, linkPropBosTypeMap, fieldTypeMap);
            }
            this.setInvUpdateType((IObjectValue)value, transactionTypeID);
            value.put(realBaseQtyProperty, (Object)curRowBaseQty);
            value.put(realQtyProperty, (Object)curRowQty);
            value.put(realAssistQtyProperty, (Object)curRowAssistQty);
            if (isQtyRemain) {
                value.put(realBaseQtyProperty, (Object)baseQty);
                value.put(realQtyProperty, (Object)qty);
            }
            entryList.add(value);
            if (isQtyEnough || isQtyRemain || !isIssue && !isStockTransferBill) break;
        }
        if (isIssue) {
            if (baseQty.compareTo(BigDecimal.ZERO) <= 0) {
                isQtyEnough = true;
            }
            dataMap.put("isQtyEnough", isQtyEnough);
            if (!isQtyEnough) {
                dataMap.put("entryList", entryList);
                dataMap.put("realBaseQty", realBaseQty);
                dataMap.put("realQty", realQty);
                dataMap.put("realBaseQtyProperty", realBaseQtyProperty);
                dataMap.put("realQtyProperty", realQtyProperty);
                dataMap.put("billPropertys", billPropertys);
                dataMap.put("rowIndex", rowIndex);
                dataMap.put("oldModel", ((CoreBillBaseInfo)billInfo).clone());
            }
        }
        CoreBillEntryBaseInfo coreEntryInfo = null;
        if (entryName == null) {
            return null;
        }
        AbstractObjectCollection coreEntryCol = (AbstractObjectCollection)billInfo.get(entryName);
        int size2 = entryList.size();
        for (int i = 1; i < size2; ++i) {
            coreEntryInfo = (CoreBillEntryBaseInfo)entryList.get(i);
            coreEntryCol.insertObject(rowIndex++, (IObjectValue)coreEntryInfo);
        }
        if (!isIssue) {
            dataMap.put("isQtyEnough", true);
        }
        billInfo.put("tempEntryList", entryList);
        dataMap.put("model", billInfo);
        return dataMap;
    }

    @Override
    protected Map _querySumInventoryByMaterial(Context ctx, Map paramMap) throws BOSException {
        String type = (String)paramMap.get("type");
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (type.equals("list")) {
            List IDs = (List)paramMap.get("IDs");
            Map IDMap = (Map)paramMap.get("IDMap");
            String entryName = (String)paramMap.get("billEntryName");
            HashSet<String> billIDs = new HashSet<String>();
            for (int i = 0; i < IDs.size(); ++i) {
                billIDs.add(IDs.get(i).toString());
            }
            InventorySumPageHelper helper = new InventorySumPageHelper(ctx, entryName, billIDs, IDMap, null);
            try {
                dataMap.put("gridData", helper.doProcess());
            }
            catch (Exception e) {
                throw new BOSException(e.getMessage());
            }
        }
        InventorySumPageHelper helper = new InventorySumPageHelper(ctx, this.getInventorySumConditions(ctx, paramMap));
        try {
            dataMap.put("gridData", helper.doProcess());
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return dataMap;
    }

    protected Map<String, Object> getInventorySumConditions(Context ctx, Map paramMap) throws BOSException {
        HashMap<String, Object> defaultConditionMap = new HashMap<String, Object>();
        defaultConditionMap.put("billEntryName", (String)paramMap.get("billEntryName"));
        String bosType = (String)paramMap.get("bosType");
        IObjectValue model = this.getModelByJson(ctx, bosType, paramMap.get("currentModel").toString());
        defaultConditionMap.put("model", model);
        defaultConditionMap.put("parentModel", model);
        defaultConditionMap.put("length", (String)paramMap.get("length"));
        if ("500AB75E".equals(bosType)) {
            HashMap<String, String> billIdAndStorageIdMap = new HashMap<String, String>();
            StorageOrgUnitInfo storageOrgUnitInfo = ((MaterialReqBillInfo)model).getSupplyStoreOrgUnit();
            String id = ((MaterialReqBillInfo)model).getId().toString();
            billIdAndStorageIdMap.put(id, storageOrgUnitInfo.getId().toString());
            defaultConditionMap.put("billIdAndStorageOrgUnitIdMap", billIdAndStorageIdMap);
        }
        return defaultConditionMap;
    }

    private IObjectValue getModelByJson(Context ctx, String bosType, String json) throws BOSException {
        Class<?> clz;
        EntityObjectInfo entityInfo = CommonUtils.getEntityByBosType((String)bosType);
        try {
            clz = Class.forName(entityInfo.getObjectValueClass());
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        Object obj = JSONUtils.convertJsonToObject((Context)ctx, (String)json, clz);
        return (IObjectValue)obj;
    }

    protected BigDecimal getQtyFromBaseQty(String materialID, String unitID, BigDecimal baseQty) throws EASBizException, BOSException {
        BigDecimal qty = baseQty != null ? baseQty : new BigDecimal("0.00000");
        MultiMeasureUnitInfo mmu = null;
        if (!StringUtil.isEmpty((String)materialID) && !StringUtil.isEmpty((String)unitID)) {
            mmu = MultiMeasureUnitFactory.getRemoteInstance().getMultiUnit(materialID, unitID);
        }
        if (mmu != null) {
            BigDecimal coefficient = mmu.getBaseConvsRate();
            int precision = mmu.getQtyPrecision();
            qty = baseQty.divide(coefficient, precision, 4);
        }
        return qty;
    }

    private Set<String> getNotReturnValueFileds() {
        String[] fields = new String[]{"FCurStoreAssistQty"};
        return new HashSet<String>(Arrays.asList(fields));
    }

    public void setInvUpdateType(IObjectValue billEntryInfo, String transactionTypeID) throws EASBizException, BOSException {
        Object storeType = billEntryInfo.get("FStoreTypeID");
        Object storeState = billEntryInfo.get("FStoreStatusID");
        if (storeType == null || storeState == null) {
            return;
        }
        String storeTypeId = storeType.toString();
        String storestateId = storeState.toString();
        InvUpdateTypeInfo invUpdateType = SCMBaseCommonUtil.getInvUpdateType(null, (String)transactionTypeID, (String)storeTypeId, (String)storestateId);
        InvUpdateTypeInfo defalutInvUpdateType = (InvUpdateTypeInfo)billEntryInfo.get("invUpdateType");
        if (invUpdateType != null || defalutInvUpdateType == null || !defalutInvUpdateType.isIsNotUpdateInv()) {
            billEntryInfo.put("invUpdateType", (Object)invUpdateType);
        }
    }

    private void confirmSetAndBack(boolean isQtyEnough, List<IObjectValue> entryList, BigDecimal realBaseQty, BigDecimal realQty, String baseQtyProperty, String qtyProperty, Map<String, String> billPropertys) {
        HashMap hmResult;
        if (CollectionUtil.isEmpty(entryList)) {
            return;
        }
        if (isQtyEnough) {
            return;
        }
        int index = entryList.size() - 1;
        IObjectValue entryInfo = entryList.get(index);
        entryInfo.put(baseQtyProperty, (Object)realBaseQty);
        entryInfo.put(qtyProperty, (Object)realQty);
        Object hmResultO = entryInfo.get("f12Inv");
        HashMap hashMap = hmResult = hmResultO == null ? null : (HashMap)hmResultO;
        if (hmResult != null) {
            Set<String> fieldsSet = this.getNotReturnValueFileds();
            Iterator<String> it = fieldsSet.iterator();
            String f12Filed = null;
            while (it.hasNext()) {
                f12Filed = it.next();
                entryInfo.put(billPropertys.get(f12Filed), hmResult.get(f12Filed));
            }
        }
    }

    @Override
    protected Map _getInvDataForInvNotEnough(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, IObjectValue> dataMap = new HashMap<String, IObjectValue>();
        boolean isQtyEnough = (Boolean)paramMap.get("isQtyEnough");
        String entryBosType = (String)paramMap.get("entryBosType");
        ArrayList<IObjectValue> entryList = new ArrayList<IObjectValue>();
        try {
            JSONArray entryArray = new JSONArray(paramMap.get("entryList").toString());
            for (int i = 0; i < entryArray.length(); ++i) {
                Object o = entryArray.get(i);
                entryList.add(this.getModelByJson(ctx, entryBosType, o.toString()));
            }
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
        BigDecimal realBaseQty = new BigDecimal(paramMap.get("realBaseQty").toString());
        BigDecimal realQty = new BigDecimal(paramMap.get("realQty").toString());
        String realBaseQtyProperty = (String)paramMap.get("realBaseQtyProperty");
        String realQtyProperty = (String)paramMap.get("realQtyProperty");
        String entryName = (String)paramMap.get("entryName");
        HashMap billPropertys = JSONUtils.convertJsonToObject((Context)ctx, (String)paramMap.get("billPropertys").toString());
        String bosType = JSONUtils.convertJsonToObject((Context)ctx, (String)paramMap.get("model").toString()).get("bosType").toString();
        IObjectValue billInfo = this.getModelByJson(ctx, bosType, paramMap.get("model").toString());
        int rowIndex = new Double(paramMap.get("rowIndex").toString()).intValue();
        this.confirmSetAndBack(isQtyEnough, entryList, realBaseQty, realQty, realBaseQtyProperty, realQtyProperty, billPropertys);
        CoreBillEntryBaseInfo coreEntryInfo = null;
        if (entryName == null) {
            return null;
        }
        AbstractObjectCollection coreEntryCol = (AbstractObjectCollection)billInfo.get(entryName);
        coreEntryCol.setObject(rowIndex, (IObjectValue)entryList.get(0));
        int size = entryList.size();
        for (int i = 1; i < size; ++i) {
            coreEntryInfo = (CoreBillEntryBaseInfo)entryList.get(i);
            coreEntryCol.insertObject(rowIndex++, (IObjectValue)coreEntryInfo);
        }
        billInfo.put("tempEntryList", entryList);
        dataMap.put("model", billInfo);
        return dataMap;
    }

    private void putData(String billProperty, String invField, Map<String, Object> hmResult, IObjectValue billEntryInfo, String entryName, Map mapping, Map<String, String> linkPropBosTypeMap, Map fieldTypeMap) throws BOSException, EASBizException {
        if (billProperty == null || billProperty.indexOf(".") == -1 || invField == null) {
            return;
        }
        boolean isInvUpdateType = this.isInvUpdateType(mapping);
        Object obj = null;
        String key = invField + "pk_hide";
        if (!StringUtil.isEmpty((String)((String)hmResult.get(key)))) {
            if (isInvUpdateType && (invField.equals("FStoreTypeID") || invField.equals("FStoreStatusID"))) {
                billEntryInfo.put(invField, hmResult.get(key));
            } else {
                String id = hmResult.get(key).toString();
                ICoreBase coreBase = this.getICoreBase(invField, id, linkPropBosTypeMap);
                obj = coreBase.getValue((IObjectPK)new ObjectUuidPK(id));
            }
        } else {
            BigDecimal qty;
            obj = hmResult.get(invField);
            if ((DataTypeEnum.Amount.getValue().equals(fieldTypeMap.get(invField)) || DataTypeEnum.Price.getValue().equals(fieldTypeMap.get(invField)) || DataTypeEnum.Qty.getValue().equals(fieldTypeMap.get(invField))) && obj instanceof Double) {
                obj = new BigDecimal((Double)obj);
            }
            if (invField.equals("FCurStoreQty") && obj instanceof BigDecimal && BigDecimal.ZERO.compareTo(qty = (BigDecimal)obj) > 0) {
                obj = BigDecimal.ZERO;
            }
            if (DataTypeEnum.Boolean.getValue().equals(fieldTypeMap.get(invField))) {
                if (obj instanceof Double) {
                    obj = new BigDecimal((Double)obj);
                }
                obj = "1".equals(obj.toString()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
        }
        if (billProperty.startsWith("__src")) {
            billProperty = billProperty.substring(billProperty.indexOf(".") + 1);
        }
        String[] str = billProperty.split("\\.");
        if (entryName == null) {
            entryName = str[0];
        }
        if (str.length > 2) {
            if (!"invUpdateType".equals(str[str.length - 1]) && obj != null && !"".equals(obj)) {
                billEntryInfo.put(str[str.length - 1], obj);
            }
        } else if (!"invUpdateType".equals(str[1]) && obj != null && !"".equals(obj)) {
            billEntryInfo.put(str[1], obj);
        }
    }

    protected boolean isInvUpdateType(Map mapping) {
        String storeType = (String)mapping.get("FStoreTypeID");
        String storeState = (String)mapping.get("FStoreStatusID");
        if (storeType != null && storeType.indexOf("invUpdateType") > -1) {
            return true;
        }
        return storeState != null && storeState.indexOf("invUpdateType") > -1;
    }

    protected ICoreBase getICoreBase(String invField, String id, Map<String, String> linkPropBosTypeMap) throws BOSException {
        BOSObjectType bosObjectType = null;
        bosObjectType = linkPropBosTypeMap.get(invField) != null ? BOSObjectType.create((String)linkPropBosTypeMap.get(invField)) : BOSUuid.read((String)id).getType();
        ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bosObjectType, ICoreBase.class);
        return iCoreBase;
    }
}

