/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.im.inv.IMaterialSerialNumber;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvStateAdjustBillInfo;
import com.kingdee.eas.scm.im.inv.InventoryUpdateFactory;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.app.AbstractInvStateAdjustBillControllerBean;
import java.math.BigDecimal;

public class InvStateAdjustBillControllerBean
extends AbstractInvStateAdjustBillControllerBean {
    private static final long serialVersionUID = 80638339866567897L;

    @Override
    protected void updateInventory(Context ctx, IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo, BizActionEnum bizAction) throws EASBizException, BOSException {
        InventoryUpdateFactory.getLocalInstance((Context)ctx).updateInventory(pk.toString(), bizAction);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkCloseAccount(ctx, (InvBillBaseInfo)model);
        IObjectCollection entryColl = ((InvStateAdjustBillInfo)model).getEntries();
        IObjectValue entry = null;
        MaterialInfo material = null;
        MeasureUnitInfo assistUnit = null;
        for (int j = 0; j < entryColl.size(); ++j) {
            entry = entryColl.getObject(j);
            material = (MaterialInfo)entry.getObjectValue("material");
            if (material == null || (assistUnit = material.getAssistUnit()) == null) continue;
            if (entry.get("assistUnit") == null) {
                entry.put("assistUnit", (Object)assistUnit);
            }
            if (entry.get("assistQty") != null) continue;
            entry.put("assistQty", (Object)BigDecimal.ZERO);
        }
        return super._submit(ctx, model);
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        if (pk == null && model == null) {
            return;
        }
        InvBillBaseInfo invBillBaseInfo = (InvBillBaseInfo)model;
        this.checkCloseAccount(ctx, invBillBaseInfo);
        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance(ctx);
        iMaterialSerialNumber.checkSerialNumberIsNull((SCMBillBaseInfo)model);
        super._passAudit(ctx, pk, model);
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        InvBillBaseInfo invBillBaseInfo = (InvBillBaseInfo)model;
        this.checkCloseAccount(ctx, invBillBaseInfo);
        super._unpassAudit(ctx, pk, model);
    }
}

