/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.inv.app.AbstractInventoryBalanceControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class InventoryBalanceControllerBean
extends AbstractInventoryBalanceControllerBean {
    private static final long serialVersionUID = 1L;
    private static BigDecimal ZERO = new BigDecimal("0.00");

    private String getUpdateSql(String tableName, String companyOrgUnitID, String materialID, BigDecimal priceDiff, int precision) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE " + tableName + " SET FPeriodAdjustDiff = FPeriodAdjustDiff + ");
        stringBuffer.append("Round(FPeriodBeginQty * " + priceDiff + ", " + precision + ") ");
        stringBuffer.append("WHERE FCompanyOrgUnitID = '" + companyOrgUnitID + "' ");
        stringBuffer.append("AND FMaterialID = '" + materialID + "'");
        return stringBuffer.toString();
    }

    @Override
    protected void _adjustStandardCost(Context ctx, String companyOrgUnitID, String[] materialID, BigDecimal[] priceDiff) throws BOSException, EASBizException {
        Connection conn = null;
        Statement stmt = null;
        try {
            if (priceDiff != null) {
                conn = EJBFactory.getConnection((Context)ctx);
                stmt = conn.createStatement();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("*"));
                selector.add(new SelectorItemInfo("baseCurrency.*"));
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(companyOrgUnitID), selector);
                int precision = company.getBaseCurrency().getPrecision();
                int recs = materialID.length;
                if (recs > 0) {
                    for (int i = 0; i < recs; ++i) {
                        stmt.addBatch(this.getUpdateSql("T_IM_InventoryBalance", companyOrgUnitID, materialID[i], priceDiff[i], precision));
                        stmt.addBatch(this.getUpdateSql("T_IM_CalulateBalance", companyOrgUnitID, materialID[i], priceDiff[i], precision));
                    }
                    stmt.executeBatch();
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(stmt, (Connection)conn);
        }
    }

    @Override
    protected BigDecimal _getPeriodBeginQty(Context ctx, String materialID, String companyID, String storageID, String warehouseID, PeriodInfo periodInfo) throws BOSException, EASBizException {
        if (periodInfo == null) {
            return ZERO;
        }
        IRowSet rs = null;
        StringBuffer sqlBuffer = new StringBuffer();
        String companyWhere = "";
        String storageWhere = "";
        String warehouseWhere = "";
        String locationWhere = "";
        String itemWhere = "";
        companyWhere = companyID != null ? " AND A.FCompanyOrgUnitID = '" + companyID + "' " : "";
        storageWhere = storageID != null ? " AND A.FStorageOrgUnitID = '" + storageID + "' " : "";
        warehouseWhere = warehouseID != null ? " AND A.FWarehouseID = '" + warehouseID + "' " : "";
        itemWhere = materialID != null ? " AND A.FMaterialID = '" + materialID + "' " : "";
        sqlBuffer.append("SELECT ISNULL(SUM(A.FPeriodBeginQty),0) AS Qty FROM T_IM_InventoryBalance A ");
        sqlBuffer.append("INNER JOIN T_IM_StoreType B ON A.FStoreTypeID = B.FID ");
        sqlBuffer.append("\n WHERE A.FISCALCULATE = 1 " + companyWhere + storageWhere + warehouseWhere + locationWhere + itemWhere);
        sqlBuffer.append("\n AND B.FIsForwardAmt = 1 ");
        sqlBuffer.append("\n AND A.FPeriod = " + periodInfo.getPeriodNumber() + " AND A.FYear = " + periodInfo.getPeriodYear());
        String sql = sqlBuffer.toString();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            rs.next();
            if (rs.getBigDecimal("Qty") == null) {
                return ZERO;
            }
            return rs.getBigDecimal("Qty");
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    @Override
    protected Map _getPeriodBeginQtyAndAmount(Context ctx, String materialId, String companyId, String storageId, String warehouseId, PeriodInfo periodInfo) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        if (periodInfo == null) {
            return result;
        }
        IRowSet rs = null;
        StringBuffer sqlBuffer = new StringBuffer();
        String companyWhere = "";
        String storageWhere = "";
        String warehouseWhere = "";
        String locationWhere = "";
        String itemWhere = "";
        companyWhere = companyId != null ? " AND A.FCompanyOrgUnitID = '" + companyId + "' " : "";
        storageWhere = storageId != null ? " AND A.FStorageOrgUnitID = '" + storageId + "' " : "";
        warehouseWhere = warehouseId != null ? " AND A.FWarehouseID = '" + warehouseId + "' " : "";
        itemWhere = materialId != null ? " AND A.FMaterialID = '" + materialId + "' " : "";
        sqlBuffer.append("SELECT ISNULL(SUM(A.FPeriodBeginQty),0) AS Qty, ISNULL(SUM(FPeriodBeginBalance),0) AS Amount ");
        sqlBuffer.append("FROM T_IM_InventoryBalance A ");
        sqlBuffer.append("INNER JOIN T_IM_StoreType B ON A.FStoreTypeID = B.FID ");
        sqlBuffer.append("\n WHERE A.FISCALCULATE = 1 " + companyWhere + storageWhere + warehouseWhere + locationWhere + itemWhere);
        sqlBuffer.append("\n AND B.FIsForwardAmt = 1 ");
        sqlBuffer.append("\n AND A.FPeriod = " + periodInfo.getPeriodNumber() + " AND A.FYear = " + periodInfo.getPeriodYear());
        String sql = sqlBuffer.toString();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            rs.next();
            BigDecimal qty = ZERO;
            BigDecimal amount = ZERO;
            if (rs.getBigDecimal("Qty") != null) {
                qty = rs.getBigDecimal("Qty");
            }
            if (rs.getBigDecimal("Amount") != null) {
                amount = rs.getBigDecimal("Amount");
            }
            result.put("beginQty", qty);
            result.put("beginBalance", amount);
            return result;
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }
}

