/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.app.AbstractInventoryCheckAccountControllerBean;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InventoryCheckAccountControllerBean
extends AbstractInventoryCheckAccountControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.InventoryCheckAccountControllerBean");

    protected String getLocName(Context ctx) throws BOSException {
        return "FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    @Override
    protected List _getInventoryAccount(Context ctx, RptParams rptParas) throws BOSException, EASBizException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList list = new ArrayList();
        String selectSql = this.getSelectSql(rptParas);
        try {
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectSql);
            while (rs.next()) {
                Vector<Object> v = new Vector<Object>();
                v.add(rs.getString("FCompanyOrgUnitID"));
                v.add(rs.getString("FYear"));
                v.add(rs.getString("FPeriod"));
                v.add(rs.getString("FYear"));
                v.add(rs.getString("FNumber"));
                v.add(rs.getString(this.getLocName(ctx)));
                v.add(rs.getString("FYear"));
                v.add(rs.getBigDecimal("FInAmount"));
                list.add(v);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return null;
    }

    @Override
    protected Vector _getAccountBalance(Context ctx, String accountID, String periodID, String companyOrgUnitID) throws BOSException, EASBizException {
        return null;
    }

    private String getSelectSql(RptParams rptParas) throws EASBizException, BOSException {
        StringBuffer sqlBuff = new StringBuffer();
        String[] tableNos = new String[]{"102", "410"};
        sqlBuff.append("SELECT ");
        sqlBuff.append("T2.FCompanyOrgUnitID AS FCompanyOrgUnitID,");
        sqlBuff.append("T2.FYear AS FYear,");
        sqlBuff.append("T2.FPeriod AS FPeriod,");
        sqlBuff.append("T6.FID AS FID,");
        sqlBuff.append("T6.FNumber AS FNumber,");
        sqlBuff.append("T6.FName_L2 AS FName_L2,");
        sqlBuff.append("SUM(CASE T3.FAccountType WHEN 1 THEN T2.FActualCostIn WHEN 2 THEN T2.FStandardCostIn END) as FInAmount,");
        sqlBuff.append("SUM(CASE T3.FAccountType WHEN 1 THEN T2.FActualCostOut WHEN 2 THEN T2.FStandardCostOut END) as FOutAmount ");
        sqlBuff.append("FROM ");
        sqlBuff.append("(SELECT ");
        sqlBuff.append("FMaterialID AS FMaterialID,");
        sqlBuff.append("FCompanyOrgUnitID AS FCompanyOrgUnitID,");
        sqlBuff.append("FYear AS FYear,");
        sqlBuff.append("FPeriod AS FPeriod,");
        sqlBuff.append("SUM(FActualCostIn) AS FActualCostIn,");
        sqlBuff.append("SUM(FStandardCostIn) AS FStandardCostIn,");
        sqlBuff.append("SUM(FActualCostOut) AS FActualCostOut,");
        sqlBuff.append("SUM(FStandardCostOut) AS FStandardCostOut ");
        sqlBuff.append("FROM ");
        sqlBuff.append("(");
        for (int i = 0; i < tableNos.length; ++i) {
            if (i > 0) {
                sqlBuff.append("UNION ALL ");
            }
            sqlBuff.append(this.getBaseSql(rptParas, tableNos[i]));
            sqlBuff.append(" ");
        }
        sqlBuff.append(") T");
        sqlBuff.append(" GROUP BY ");
        sqlBuff.append("FMaterialID,");
        sqlBuff.append("FCompanyOrgUnitID,");
        sqlBuff.append("FYear,");
        sqlBuff.append("FPeriod");
        sqlBuff.append(") T2 ");
        sqlBuff.append("INNER JOIN T_BD_MaterialCompanyInfo T3 ON T2.FMaterialID = T3.FMaterial AND T2.FCompanyOrgUnitID = T3.FCompanyID ");
        sqlBuff.append("INNER JOIN T_BD_KAClassificationDetail T4 ON T3.FKAClassID = T4.FKaclassficlink ");
        sqlBuff.append("INNER JOIN T_BD_KAccountItem T5 ON T4.FAccountitemlinkID = T5.FID ");
        sqlBuff.append("INNER JOIN T_BD_AccountView T6  ON T4.FAccountlinkID = T6.FID  ");
        sqlBuff.append("LEFT JOIN T_IM_InventoryBalance T7  ON T2.FCompanyOrgUnitID = T7.FCompanyOrgUnitID AND ");
        sqlBuff.append("T2.FMaterialID = T7.fMaterialid AND  T2.FYear = T7.FYear AND T2.FPeriod = T7.FPeriod ");
        sqlBuff.append("WHERE ");
        sqlBuff.append("T5.FNumber = '1001' ");
        sqlBuff.append(" GROUP BY ");
        sqlBuff.append("T2.FMaterialID,");
        sqlBuff.append("T2.FCompanyOrgUnitID,");
        sqlBuff.append("T2.FYear,");
        sqlBuff.append("T2.FPeriod,");
        sqlBuff.append("T6.FID,");
        sqlBuff.append("T6.FNumber,");
        sqlBuff.append("T6.FName_L2");
        return sqlBuff.toString();
    }

    private String getBaseSql(RptParams rptParas, String billNO) throws EASBizException, BOSException {
        String billTableName = InvCommonUtils.getBillTableName(billNO);
        String billEntryName = InvCommonUtils.getBillEntryTableName(billNO);
        StringBuffer sqlBuff = new StringBuffer();
        String companyOrgUnitID = rptParas.getString("companyOrgUnitID");
        if (billNO.equals("103") || billNO.equals("109") || billNO.equals("107") || billNO.equals("105")) {
            sqlBuff.append("SELECT ");
            sqlBuff.append("B.FMaterialID AS FMaterialID,");
            sqlBuff.append("B.FCompanyOrgUnitID AS FCompanyOrgUnitID,");
            sqlBuff.append("B.FActualCost AS FActualCostIn,");
            sqlBuff.append("B.FStandardCost AS FStandardCostIn,");
            sqlBuff.append("0 AS FActualCostOut,");
            sqlBuff.append("0 AS FStandardCostOut,");
            sqlBuff.append("A.FYear AS FYear,");
            sqlBuff.append("A.FPeriod AS FPeriod ");
            sqlBuff.append("FROM  ");
            sqlBuff.append(billTableName + " A,");
            sqlBuff.append(billEntryName + " B ");
            sqlBuff.append("WHERE A.FID = B.FParentID ");
        } else if (billNO.equals("102") || billNO.equals("104") || billNO.equals("108") || billNO.equals("106")) {
            sqlBuff.append("SELECT ");
            sqlBuff.append("B.FMaterialID AS FMaterialID,");
            sqlBuff.append("B.FCompanyOrgUnitID AS FCompanyOrgUnitID,");
            sqlBuff.append("0 AS FActualCostIn,");
            sqlBuff.append("0 AS FStandardCostIn,");
            sqlBuff.append("B.FActualCost AS FActualCostOut,");
            sqlBuff.append("B.FStandardCost AS FStandardCostOut,");
            sqlBuff.append("A.FYear AS FYear,");
            sqlBuff.append("A.FPeriod AS FPeriod ");
            sqlBuff.append("FROM  ");
            sqlBuff.append(billTableName + " A,");
            sqlBuff.append(billEntryName + " B ");
            sqlBuff.append("WHERE A.FID = B.FParentID ");
            sqlBuff.append("AND B.FCompanyOrgUnitID = '" + companyOrgUnitID + "' ");
        } else if (billNO.equals("410")) {
            sqlBuff.append("SELECT ");
            sqlBuff.append("B.FMaterialID AS FMaterialID,");
            sqlBuff.append("B.FCompanyOrgUnitID AS FCompanyOrgUnitID,");
            sqlBuff.append("(CASE A.FCalculateKind  WHEN 0 THEN B.FActualCost ELSE 0 END) AS FActualCostIn,");
            sqlBuff.append("(CASE A.FCalculateKind  WHEN 0 THEN B.FStandardCost ELSE 0 END) AS FStandardCostIn,");
            sqlBuff.append("(CASE A.FCalculateKind  WHEN 1 THEN B.FActualCost ELSE 0 END) AS FActualCostOut,");
            sqlBuff.append("(CASE A.FCalculateKind WHEN 1 THEN B.FStandardCost ELSE 0 END) AS FStandardCostOut,");
            sqlBuff.append("A.FYear AS FYear,");
            sqlBuff.append("A.FPeriod AS FPeriod ");
            sqlBuff.append("FROM  ");
            sqlBuff.append(billTableName + " A,");
            sqlBuff.append(billEntryName + " B ");
        } else if (billNO.equals("420")) {
            sqlBuff.append("SELECT ");
            sqlBuff.append("B.FMaterialID AS FMaterialID,");
            sqlBuff.append("B.FCompanyOrgUnitID AS FCompanyOrgUnitID,");
            sqlBuff.append("FDiffAmount AS FActualCostIn");
            sqlBuff.append("FDiffAmount AS FStandardCostIn");
            sqlBuff.append("0 AS FActualCostOut");
            sqlBuff.append("0 AS FStandardCostOut");
            sqlBuff.append("A.FYear AS FYear,");
            sqlBuff.append("A.FPeriod AS FPeriod ");
            sqlBuff.append("FROM  ");
            sqlBuff.append(billTableName + " A,");
            sqlBuff.append(billEntryName + " B ");
        }
        return sqlBuff.toString();
    }
}

