/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.app.service.FunctionPermissionService;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMLockInvDataVO;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InventoryCollection;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.LockInventoryInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractInventoryControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class InventoryControllerBean
extends AbstractInventoryControllerBean {
    private static final long serialVersionUID = -6823308681014103800L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.InventoryControllerBean");
    private static BigDecimal ZERO = new BigDecimal("0.00");
    public static final String BILLID = "FBillID";
    public static final String BILLENTRYID = "FBillEntryID";
    public static final String INVENTORYID = "FInventoryID";
    public static final String BILLNUMBER = "FBillNumber";
    public static final String BILLTYPEID = "FBillTypeID";
    public static final String WAREHOUSEID = "FWarehouseID";
    public static final String LOCATIONID = "FLocationID";
    public static final String LOT = "Flot";
    public static final String STORETYPEID = "FStoreTypeID";
    public static final String STORESTATEID = "FStoreStateID";
    public static final String LOCKQTY = "FLockQty";
    public static final String LOCKORDERQTY = "FLockOrderQty";
    public static final String LOCKBASEQTY = "FLockBaseQty";
    public static final String LOCKASSISTQTY = "FLockAssistQty";
    public static final String UNLOCKDATE = "FUnLockDate";
    public static final String PROJECTID = "FProjectID";
    public static final String TRACKNUMBER = "FTrackNumberID";
    private static final String Property_warehouse = "warehouse.id";
    private static final String Property_location = "location.id";
    private static final String Property_supplier = "supplier.id";
    private static final String Property_customer = "customer.id";
    private static final String Property_lot = "lot";
    private static final String Property_project = "project.id";
    private static final String Property_trackNumber = "trackNumber.id";
    private static final String Property_assistUnit = "assistUnit.id";
    private static final String Property_assistProperty = "assistProperty.id";
    private static HashMap LockMap = new HashMap();

    @Override
    protected BigDecimal _getQty(Context ctx, String materialID, String companyID, String storageOrgID, String warehouseID, String locationID) throws BOSException, EASBizException {
        IRowSet rs = null;
        StringBuffer sqlBuffer = new StringBuffer();
        String companyWhere = "";
        String storageWhere = "";
        String warehouseWhere = "";
        String locationWhere = "";
        String itemWhere = "";
        companyWhere = companyID != null ? " AND FCompanyOrgUnitID = '" + companyID + "' " : "";
        storageWhere = storageOrgID != null ? " AND FStorageOrgUnitID = '" + storageOrgID + "' " : "";
        warehouseWhere = warehouseID != null ? " AND FWarehouseID = '" + warehouseID + "' " : "";
        locationWhere = locationID != null ? " AND FLocationID = '" + locationID + "' " : "";
        itemWhere = materialID != null ? " AND FMaterialID = '" + materialID + "' " : "";
        sqlBuffer.append("SELECT SUM(FBaseQty) AS Qty FROM T_IM_INVENTORY ");
        sqlBuffer.append("WHERE 1=1 " + companyWhere + storageWhere + warehouseWhere + locationWhere + itemWhere);
        String sql = sqlBuffer.toString();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            rs.next();
            if (rs.getBigDecimal("Qty") == null) {
                return ZERO;
            }
            return rs.getBigDecimal("Qty");
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _isInvMaterialNegative(Context ctx, String storageOrgUnitID, String materialID) throws BOSException, EASBizException {
        block8: {
            conn = null;
            preStmt = null;
            rs = null;
            if (storageOrgUnitID == null || storageOrgUnitID.trim().length() == 0) {
                throw new InvBizException(InvBizException.STOREORG_IS_NULL);
            }
            if (materialID == null || materialID.trim().length() == 0) {
                throw new InvBizException(InvBizException.MATERIAL_IS_NULL);
            }
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                preStmt = conn.prepareStatement("SELECT FCurStoreQty,FBaseQty FROM T_IM_Inventory WHERE FStorageOrgUnitID = ? AND FMaterialID = ?");
                preStmt.setString(1, storageOrgUnitID);
                preStmt.setString(2, materialID);
                rs = preStmt.executeQuery();
                while (rs.next()) {
                    if (rs.getBigDecimal(1) == null || rs.getBigDecimal(1).signum() != -1 && rs.getBigDecimal(2).signum() != -1) continue;
                    var7_7 = true;
                    break block8;
                }
                ** GOTO lbl-1000
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable var8_10) {
                    SQLUtils.cleanup(rs, preStmt, (Connection)conn);
                    throw var8_10;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)preStmt, (Connection)conn);
        return var7_7;
lbl-1000:
        // 1 sources

        {
            var7_8 = false;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)preStmt, (Connection)conn);
        return var7_8;
    }

    @Override
    protected int _clearZeroDate(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement preStmt = null;
        ResultSet rs = null;
        StringBuffer sb = new StringBuffer();
        sb.append("select count(1) as count from T_IM_Inventory where FBaseQty = 0 and FLockBaseQty = 0");
        int count = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            preStmt = conn.prepareStatement(sb.toString());
            rs = preStmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt("count");
            }
            if (count > 0) {
                sb = new StringBuffer();
                sb.append("Delete T_IM_Inventory where FBaseQty = 0 and FLockBaseQty = 0");
                preStmt = conn.prepareStatement(sb.toString());
                preStmt.execute();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, preStmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)preStmt, (Connection)conn);
        return count;
    }

    private String getLockInventoryBOSType(Context ctx) throws InvalidDAOMetaDataException {
        return new LockInventoryInfo().getBOSType().toString();
    }

    @Override
    protected void _lockInventory(Context ctx, HashMap[] params) throws BOSException, EASBizException {
    }

    @Override
    protected void _unLockInventory(Context ctx, HashMap[] params) throws BOSException, EASBizException {
    }

    @Override
    protected void _unLockInventory(Context ctx, IObjectPK[] entryPks) throws BOSException, EASBizException {
    }

    private StringBuffer saveCurLockInfo(IRowSet rs) throws BOSException {
        StringBuffer unlockids = new StringBuffer();
        try {
            while (rs.next()) {
                HashMap<String, Object> hm = new HashMap<String, Object>();
                String billentryid = rs.getString("FBILLENTRYID");
                String invID = rs.getString("FINVENTORYID");
                hm.put(BILLID, rs.getString("FBILLID"));
                hm.put(BILLENTRYID, rs.getString("FBILLENTRYID"));
                hm.put(INVENTORYID, rs.getString("FINVENTORYID"));
                hm.put(BILLNUMBER, rs.getString("FBILLNUMBER"));
                hm.put(BILLTYPEID, "510b6503-0105-1000-e000-0113c0a812fd463ED552");
                hm.put(WAREHOUSEID, rs.getString("FWAREHOUSEID"));
                hm.put(LOCATIONID, rs.getString("FLOCATIONID"));
                hm.put(LOT, rs.getString("FLOT"));
                hm.put(STORETYPEID, rs.getString("FSTORETYPEID"));
                hm.put(STORESTATEID, rs.getString("FSTORESTATEID"));
                hm.put(LOCKQTY, rs.getBigDecimal("FLOCKQTY"));
                hm.put(LOCKBASEQTY, rs.getBigDecimal("FLOCKBASEQTY"));
                hm.put(LOCKASSISTQTY, rs.getBigDecimal("FLOCKASSISTQTY"));
                hm.put(PROJECTID, rs.getString(PROJECTID));
                hm.put(TRACKNUMBER, rs.getString(TRACKNUMBER));
                unlockids.append("'").append(billentryid).append("'").append(",");
                if (LockMap.containsKey(billentryid + invID)) continue;
                LockMap.put(billentryid + invID, hm);
            }
            unlockids.append("''");
        }
        catch (SQLException e) {
            throw new BOSException("set salesorder lockQty exception : ", (Throwable)e);
        }
        return unlockids;
    }

    private void query(Context ctx, IObjectPK[] entryPks) throws BOSException {
    }

    private String makeEntryIDsBy(IObjectPK[] entryPks) {
        StringBuffer entryIDs = new StringBuffer();
        for (int i = 0; i < entryPks.length; ++i) {
            if (i == 0) {
                entryIDs.append("'").append(entryPks[i].toString()).append("'");
                continue;
            }
            entryIDs.append(",").append("'").append(entryPks[i].toString()).append("'");
        }
        return entryIDs.toString();
    }

    @Override
    protected void _refreshInventory(Context ctx, String storageOrgNumbers) throws BOSException, EASBizException {
    }

    public List getMaterialGroupLongNumber(Object materialGroupFrom, Object materialGroupTo, String standardId) {
        return null;
    }

    @Override
    protected void _lockInventoryBatch(Context ctx, ArrayList orderEntryList) throws BOSException, EASBizException {
        Iterator it = orderEntryList.iterator();
        HashMap orderEntryItemMap = null;
        MaterialInfo materialInfo = null;
        AsstAttrValueInfo asstAttrValueInfo = null;
        Object storageOrgUnit = null;
        BigDecimal canLockOrderBaseQty = null;
        String orderEntryId = null;
        String orderId = null;
        String orderNumber = null;
        MeasureUnitInfo orderEntryUnitInfo = null;
        while (it.hasNext()) {
            HashMap LockMap = new HashMap();
            HashMap[] hms = null;
            orderEntryItemMap = (HashMap)it.next();
            materialInfo = (MaterialInfo)orderEntryItemMap.get("materialInfo");
            asstAttrValueInfo = (AsstAttrValueInfo)orderEntryItemMap.get("asstAttrValueInfo");
            storageOrgUnit = orderEntryItemMap.get("storageOrgUnit");
            canLockOrderBaseQty = (BigDecimal)orderEntryItemMap.get("canLockOrderBaseQty");
            orderEntryId = (String)orderEntryItemMap.get("orderEntryId");
            orderId = (String)orderEntryItemMap.get("orderId");
            orderNumber = (String)orderEntryItemMap.get("orderNumber");
            orderEntryUnitInfo = (MeasureUnitInfo)orderEntryItemMap.get("orderEntryUnitInfo");
            WarehouseInfo wareHouseInfo = (WarehouseInfo)orderEntryItemMap.get("warehouseInfo");
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemInfo companyFilter = new FilterItemInfo("STORAGEORGUNIT.ID", storageOrgUnit, CompareType.EQUALS);
            FilterItemInfo materialFilter = new FilterItemInfo("MATERIAL.ID", (Object)materialInfo.getId().toString(), CompareType.EQUALS);
            FilterItemInfo storeTypeFilter = new FilterItemInfo("STORETYPE.ID", (Object)"181875d5-0105-1000-e000-0111c0a812fd97D461A6", CompareType.EQUALS);
            FilterItemInfo storeStatusFilter = new FilterItemInfo("STORESTATUS.ID", (Object)"181875d5-0105-1000-e000-012ec0a812fd62A73FA5", CompareType.EQUALS);
            filter.getFilterItems().add(companyFilter);
            filter.getFilterItems().add(materialFilter);
            filter.getFilterItems().add(storeTypeFilter);
            filter.getFilterItems().add(storeStatusFilter);
            if (asstAttrValueInfo != null) {
                FilterItemInfo assistFilter = new FilterItemInfo("assistProperty.ID", (Object)asstAttrValueInfo.getId().toString(), CompareType.EQUALS);
                filter.getFilterItems().add(assistFilter);
            }
            if (wareHouseInfo != null) {
                FilterItemInfo wareHouseFilter = new FilterItemInfo("WAREHOUSE.ID", (Object)wareHouseInfo.getId().toString(), CompareType.EQUALS);
                filter.getFilterItems().add(wareHouseFilter);
            }
            ev.setFilter(filter);
            SCMLockInvDataVO vo = new SCMLockInvDataVO();
            vo.setTableNether(true);
            vo.setViewInfo(ev);
            vo.setType("bottom");
            SCMLockInvDataVO tblLockVO = SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadSaleLockInvData(vo);
            IObjectPK[] invIdList = tblLockVO.getInvIdList();
            String invID = null;
            InventoryInfo aInventoryInfo = null;
            MeasureUnitInfo unit = null;
            MeasureUnitInfo baseUnit = null;
            MeasureUnitInfo assistUnit = null;
            WarehouseInfo wareHouse = null;
            LocationInfo location = null;
            BigDecimal curStoreBaseQty = null;
            BigDecimal curLockStoreQty = null;
            BigDecimal curLockStoreBaseQty = null;
            BigDecimal curLockStoreAssitQty = null;
            StringBuffer ids = new StringBuffer("(");
            int tt = invIdList.length;
            for (int t = 0; t < tt; ++t) {
                ids.append("'");
                ids.append(invIdList[t].toString());
                ids.append("'");
                if (t >= tt - 1) continue;
                ids.append(",");
            }
            ids.append(")");
            InventoryCollection invCol = InventoryFactory.getLocalInstance(ctx).getInventoryCollection(" where id in " + ids.toString() + " order by lot asc , baseQty desc");
            int n = invCol.size();
            for (int j = 0; j < n && canLockOrderBaseQty.compareTo(ZERO) > 0; ++j) {
                aInventoryInfo = invCol.get(j);
                invID = aInventoryInfo.getId().toString();
                unit = aInventoryInfo.getUnit();
                assistUnit = aInventoryInfo.getAssistUnit();
                baseUnit = materialInfo.getBaseUnit();
                wareHouse = aInventoryInfo.getWarehouse();
                location = aInventoryInfo.getLocation();
                String lot = aInventoryInfo.getLot();
                curStoreBaseQty = aInventoryInfo.getBaseQty();
                if (curStoreBaseQty.compareTo(ZERO) == 0) continue;
                HashMap<String, Object> hm = new HashMap<String, Object>();
                if (canLockOrderBaseQty.compareTo(curStoreBaseQty) <= 0) {
                    curLockStoreBaseQty = canLockOrderBaseQty;
                    curStoreBaseQty = curStoreBaseQty.subtract(canLockOrderBaseQty);
                    canLockOrderBaseQty = ZERO;
                } else {
                    curLockStoreBaseQty = curStoreBaseQty;
                    curStoreBaseQty = ZERO;
                    canLockOrderBaseQty = canLockOrderBaseQty.subtract(curLockStoreBaseQty);
                }
                if (assistUnit != null) {
                    curLockStoreAssitQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)materialInfo.getId().toString(), (String)baseUnit.getId().toString(), (BigDecimal)curLockStoreBaseQty, (String)assistUnit.getId().toString());
                    hm.put(LOCKASSISTQTY, curLockStoreAssitQty);
                }
                curLockStoreQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)materialInfo.getId().toString(), (String)baseUnit.getId().toString(), (BigDecimal)curLockStoreBaseQty, (String)unit.getId().toString());
                hm.put(LOCKQTY, curLockStoreQty);
                hm.put(LOCKBASEQTY, curLockStoreBaseQty);
                BigDecimal orderEntryUnitQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)materialInfo.getId().toString(), (String)baseUnit.getId().toString(), (BigDecimal)curLockStoreBaseQty, (String)orderEntryUnitInfo.getId().toString());
                hm.put(LOCKORDERQTY, orderEntryUnitQty);
                hm.put(BILLID, orderId);
                hm.put(BILLENTRYID, orderEntryId);
                hm.put(INVENTORYID, invID);
                hm.put(BILLNUMBER, orderNumber);
                hm.put(BILLTYPEID, "510b6503-0105-1000-e000-0113c0a812fd463ED552");
                hm.put(WAREHOUSEID, wareHouse.getId().toString());
                if (location != null) {
                    hm.put(LOCATIONID, location.getId().toString());
                } else {
                    hm.put(LOCATIONID, null);
                }
                if (lot != null) {
                    hm.put(LOT, lot);
                } else {
                    hm.put(LOT, null);
                }
                hm.put(STORETYPEID, "181875d5-0105-1000-e000-0111c0a812fd97D461A6");
                hm.put(STORESTATEID, "181875d5-0105-1000-e000-012ec0a812fd62A73FA5");
                LockMap.put(orderEntryId + invID, hm);
                if (LockMap.size() == 0) {
                    return;
                }
                hms = new HashMap[LockMap.size()];
                Iterator keyValuePairs1 = LockMap.entrySet().iterator();
                for (int i = 0; i < LockMap.size(); ++i) {
                    HashMap mm;
                    Map.Entry entry = keyValuePairs1.next();
                    Object value = entry.getValue();
                    hms[i] = mm = (HashMap)value;
                }
            }
            this._lockInventory(ctx, hms);
        }
    }

    @Override
    public IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InventoryInfo info = (InventoryInfo)super._getValue(ctx, pk);
        this.setInventoryInfo(info);
        return info;
    }

    @Override
    public IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        InventoryInfo info = (InventoryInfo)super._getValue(ctx, pk, selector);
        this.setInventoryInfo(info);
        return info;
    }

    @Override
    public IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        InventoryInfo info = (InventoryInfo)this.innerGetValueForInventory(ctx, oql);
        this.setInventoryInfo(info);
        return info;
    }

    @Override
    public IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx) throws BOSException {
        InventoryCollection col = (InventoryCollection)super._getCollection(ctx, svcCtx);
        return this.setInventoryCollection(col);
    }

    @Override
    public IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx, EntityViewInfo view) throws BOSException {
        this.parseEntityViewInfo(view);
        InventoryCollection col = (InventoryCollection)super._getCollection(ctx, svcCtx, view);
        return this.setInventoryCollection(col);
    }

    @Override
    public IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx, String oql) throws BOSException {
        InventoryCollection col = (InventoryCollection)this.innerGetCollection4Inventory(ctx, svcCtx, oql);
        return this.setInventoryCollection(col);
    }

    private InventoryCollection setInventoryCollection(InventoryCollection col) {
        if (col == null || col.size() == 0) {
            return col;
        }
        InventoryCollection retCol = new InventoryCollection();
        InventoryInfo info = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            info = col.get(i);
            this.setInventoryInfo(info);
            retCol.add(info);
        }
        return retCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectValue innerGetValueForInventory(Context ctx, String oql) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            EntityViewInfo view = null;
            Object[] params = new Object[]{oql};
            try {
                view = new EntityViewInfo(oql);
            }
            catch (ParserException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage());
            }
            this.handleParamEntityView(ctx, null, view, "getValue", params, false);
            this.parseEntityViewInfo(view);
            IObjectValue iObjectValue = this.getDAO(ctx, cn).getValue(view);
            return iObjectValue;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    private void parseEntityViewInfo(EntityViewInfo view) {
        FilterInfo filter = view.getFilter();
        if (filter == null) {
            return;
        }
        FilterItemCollection col = filter.getFilterItems();
        FilterItemInfo itemInfo = null;
        String propertyName = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            itemInfo = col.get(i);
            if (itemInfo.getCompareValue() != null) continue;
            propertyName = itemInfo.getPropertyName();
            if (Property_assistProperty.equals(propertyName)) {
                itemInfo.setCompareValue((Object)"EgkAAAA5EWALxvQu");
                continue;
            }
            if (Property_assistUnit.equals(propertyName)) {
                itemInfo.setCompareValue((Object)"EgkAAAA5EWFbglxX");
                continue;
            }
            if (Property_customer.equals(propertyName)) {
                itemInfo.setCompareValue((Object)"EgkAAABc3Xu/DAQO");
                continue;
            }
            if (Property_location.equals(propertyName)) {
                itemInfo.setCompareValue((Object)"EgkAAABc3XMgX/hq");
                continue;
            }
            if (Property_lot.equals(propertyName)) {
                itemInfo.setCompareValue((Object)"YNi0IQEOEADgBT3mfwAAAcznrtQ=");
                continue;
            }
            if (Property_project.equals(propertyName)) {
                itemInfo.setCompareValue((Object)"EgkAAABc3Xza3gXu");
                continue;
            }
            if (Property_supplier.equals(propertyName)) {
                itemInfo.setCompareValue((Object)"EgkAAABc3Xo3xn38");
                continue;
            }
            if (Property_warehouse.equals(propertyName)) {
                itemInfo.setCompareValue((Object)"EgkAAABc3XG76fiu");
                continue;
            }
            if (!Property_trackNumber.equals(propertyName)) continue;
            itemInfo.setCompareValue((Object)"EgkAAABc3X0Ibpg9");
        }
    }

    private void handleParamEntityView(Context ctx, IObjectPK pk, EntityViewInfo view, String MethodName, Object[] params, boolean isSetDefaultSelector) throws BOSException {
        String key;
        EntityViewInfo vInfo;
        if (pk != null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo bo = null;
            bo = this instanceof ICommonBOSType && ((ICommonBOSType)this).getPK() != null ? loader.getEntity(((ICommonBOSType)this).getPK()) : loader.getEntity(this.getBOSType());
            FilterInfo filterData = ImplUtils.createFilter((EntityObjectInfo)bo, (IObjectPK)pk);
            view.setFilter(filterData);
            if (isSetDefaultSelector && bo.getDefaultView() != null) {
                SelectorItemCollection selector = bo.getDefaultView().getSelector();
                view.setSelector(selector);
            }
        }
        if ((vInfo = this.getPermissionViewInfo(ctx, key = ImplUtils.buildPermissionServiceKey((BOSObjectType)this.getBOSType(), (String)"getValue", (Object[])params))) != null) {
            view.getFilter().mergeFilter(vInfo.getFilter(), "and");
            view.getEntryFilters().addObjectCollection((IObjectCollection)vInfo.getEntryFilters());
            boolean flag = true;
            int n = view.getEntryFilters().size();
            for (int i = 0; i < n; ++i) {
                FilterInfo filter = view.getEntryFilters().get(i);
                EntryFilterType type = filter.getEntryFilterType();
                if (EntryFilterType.NORMAL.equals((Object)type)) continue;
                flag = false;
                break;
            }
            view.setEntryPermCol(flag);
        }
    }

    private EntityViewInfo getPermissionViewInfo(Context ctx, String key) throws BOSException {
        EntityViewInfo view = null;
        Object permissionSrvRtn = ctx.get((Object)key);
        if (permissionSrvRtn != null) {
            if (permissionSrvRtn instanceof EntityViewInfo) {
                view = (EntityViewInfo)permissionSrvRtn;
            } else {
                logger.error((Object)("Illegal Object type error, expected: <EntityViewInfo>, but was : <" + permissionSrvRtn.getClass().getName() + ">"));
            }
            ctx.remove((Object)key);
        }
        return view;
    }

    private void setInventoryInfo(InventoryInfo info) {
        if (info == null) {
            return;
        }
        if (info.getWarehouse() != null && "EgkAAABc3XG76fiu".equals(info.getWarehouse().getId().toString())) {
            info.setWarehouse(null);
        }
        if (info.getLocation() != null && "EgkAAABc3XMgX/hq".equals(info.getLocation().getId().toString())) {
            info.setLocation(null);
        }
        if (info.getSupplier() != null && "EgkAAABc3Xo3xn38".equals(info.getSupplier().getId().toString())) {
            info.setSupplier(null);
        }
        if (info.getCustomer() != null && "EgkAAABc3Xu/DAQO".equals(info.getCustomer().getId().toString())) {
            info.setCustomer(null);
        }
        if ("YNi0IQEOEADgBT3mfwAAAcznrtQ=".equals(info.getLot())) {
            info.setLot(null);
        }
        if (info.getAssistProperty() != null && "EgkAAAA5EWALxvQu".equals(info.getAssistProperty().getId().toString())) {
            info.setAssistProperty(null);
        }
        if (info.getAssistUnit() != null && "EgkAAAA5EWFbglxX".equals(info.getAssistUnit().getId().toString())) {
            info.setAssistUnit(null);
        }
        if (info.getProject() != null && "EgkAAABc3Xza3gXu".equals(info.getProject().getId().toString())) {
            info.setProject(null);
        }
        if (info.getTrackNumber() != null && "EgkAAABc3X0Ibpg9".equals(info.getTrackNumber().getId().toString())) {
            info.setTrackNumber(null);
        }
    }

    protected IObjectCollection innerGetCollection4Inventory(Context ctx, IServiceContext svCtx, String oql) throws BOSException {
        EntityViewInfo view;
        try {
            view = new EntityViewInfo(oql);
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        return this.innerGetCollection4Inventory(ctx, svCtx, view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectCollection innerGetCollection4Inventory(Context ctx, IServiceContext svCtx, EntityViewInfo view) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            FilterInfo filter = (FilterInfo)svCtx.getServiceResult("PERMISSION_SERVICE");
            FilterCollection fc = (FilterCollection)svCtx.getServiceResult("PERMISSION_ENTRYS_SERVICE");
            if (view == null) {
                view = new EntityViewInfo();
            }
            if (filter != null) {
                if (view.getFilter() == null) {
                    view.setFilter(filter);
                } else {
                    view.getFilter().mergeFilter(filter, "and");
                }
            }
            if (fc != null) {
                if (view.getEntryFilters().size() == 0) {
                    view.getEntryFilters().addObjectCollection((IObjectCollection)fc);
                } else {
                    view.getEntryFilters().merge(fc, "and");
                }
            }
            this.parseEntityViewInfo(view);
            IObjectCollection iObjectCollection = this.getDAO(ctx, cn).getCollection(view);
            return iObjectCollection;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    @Override
    protected HashSet _getexsitInorIssueId(Context ctx, String ids) throws BOSException, EASBizException {
        String inWareSql = "select entry.FSOURCEBILLENTRYID as entryid from T_IM_OtherInWarehsBill bill inner join T_IM_OtherInWarehsBillentry entry on bill.fid = entry.fparentid  where bill.FBASESTATUS not in (4,3) and entry.FSOURCEBILLENTRYID in " + ids;
        String issueSql = "select entry.FSOURCEBILLENTRYID as entryid from T_IM_OtherIssueBill bill inner join T_IM_OtherIssueBillentry entry on bill.fid = entry.fparentid  where bill.FBASESTATUS not in (4,3) and entry.FSOURCEBILLENTRYID in " + ids;
        HashSet<String> exitsIds = new HashSet<String>();
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            RowSet rsInware = SQLUtils.getJdbcRowSet((Connection)conn, (String)inWareSql.toString());
            while (rsInware.next()) {
                exitsIds.add(rsInware.getString("entryid"));
            }
            RowSet rsIssue = SQLUtils.getJdbcRowSet((Connection)conn, (String)issueSql.toString());
            while (rsIssue.next()) {
                exitsIds.add(rsIssue.getString("entryid"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return exitsIds;
    }

    @Override
    protected void _updateMaterialinfo(Context ctx, String ids, String inwareOrIssueIds) throws BOSException, EASBizException {
        String updateSql = null;
        updateSql = inwareOrIssueIds.equals("inware") ? "update T_IM_OtherInWarehsBillEntry t1 set (FMaterialID,Flot,FAssistPropertyID,FMfg,FExp,FUnitID,FBaseUnitID,FAssistUnitID, FStoreTypeID,FStoreStatusID,FWarehouseID,FLocationID,FSupplierID,FCustomerID,FProjectID,FTrackNumberID) =  (select inventory.FMaterialID,case when inventory.Flot='YNi0IQEOEADgBT3mfwAAAcznrtQ=' then null else inventory.Flot end,case when inventory.FAssistPropertyID='EgkAAAA5EWALxvQu' then null else inventory.FAssistPropertyID end,dateOfMin.FMfg,dateOfMin.FExp,inventory.FUnitID,inventory.FBaseUnitID,case when inventory.FAssistUnitID='EgkAAAA5EWFbglxX' then null else inventory.FAssistUnitID end, inventory.FStoreTypeID,inventory.FStoreStatusID,case when inventory.FWarehouseID='EgkAAABc3XG76fiu' then null else inventory.FWarehouseID end,case when inventory.FLocationID='EgkAAABc3XMgX/hq' then null else inventory.FLocationID end,case when inventory.FSupplierID='EgkAAABc3Xo3xn38' then null else inventory.FSupplierID end,case when inventory.FCustomerID='EgkAAABc3Xu/DAQO' then null else inventory.FCustomerID end, case when inventory.FProjectID = 'EgkAAABc3Xza3gXu' then null else inventory.FProjectID end,case when inventory.FTrackNumberID = 'EgkAAABc3X0Ibpg9' then null else inventory.FTrackNumberID end  from  T_IM_OtherInWarehsBill bill inner join  T_IM_OtherInWarehsBillEntry entry on bill.fid = entry.fparentid inner join t_im_inventory inventory on entry.FSourceBillEntryID = inventory.fid  inner join T_BD_Material material on inventory.FMaterialID = material.fid  left  join T_IM_DateOfMinDurability dateOfMin on inventory.FStorageOrgUnitID = dateOfMin.FStorageOrgUnitID  and inventory.FMaterialID = dateOfMin.FMaterialID and inventory.FLot = dateOfMin.FLot where bill.fid in " + ids + " and t1.fid = entry.fid )" : "update T_IM_OtherIssueBillEntry t1 set (FMaterialID,Flot,FAssistPropertyID,FMfg,FExp,FUnitID,FBaseUnitID,FAssistUnitID, FStoreTypeID,FStoreStatusID,FWarehouseID,FLocationID,FSupplierID,FCustomerID,FProjectID,FTrackNumberID) =  (select inventory.FMaterialID,case when inventory.Flot='YNi0IQEOEADgBT3mfwAAAcznrtQ=' then null else inventory.Flot end,case when inventory.FAssistPropertyID='EgkAAAA5EWALxvQu' then null else inventory.FAssistPropertyID end,dateOfMin.FMfg,dateOfMin.FExp,inventory.FUnitID,inventory.FBaseUnitID,case when inventory.FAssistUnitID='EgkAAAA5EWFbglxX' then null else inventory.FAssistUnitID end,inventory.FStoreTypeID,inventory.FStoreStatusID,case when inventory.FWarehouseID='EgkAAABc3XG76fiu' then null else inventory.FWarehouseID end,case when inventory.FLocationID='EgkAAABc3XMgX/hq' then null else inventory.FLocationID end,case when inventory.FSupplierID='EgkAAABc3Xo3xn38' then null else inventory.FSupplierID end,case when inventory.FCustomerID='EgkAAABc3Xu/DAQO' then null else inventory.FCustomerID end, case when inventory.FProjectID = 'EgkAAABc3Xza3gXu' then null else inventory.FProjectID end,case when inventory.FTrackNumberID = 'EgkAAABc3X0Ibpg9' then null else inventory.FTrackNumberID end  from  T_IM_OtherIssueBill bill inner join  T_IM_OtherIssueBillEntry entry on bill.fid = entry.fparentid inner join t_im_inventory inventory on entry.FSourceBillEntryID = inventory.fid  inner join T_BD_Material material on inventory.FMaterialID = material.fid  left  join T_IM_DateOfMinDurability dateOfMin on inventory.FStorageOrgUnitID = dateOfMin.FStorageOrgUnitID  and inventory.FMaterialID = dateOfMin.FMaterialID and inventory.FLot = dateOfMin.FLot where bill.fid in " + ids + " and t1.fid = entry.fid )";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    @Override
    protected void _checkAdjustPermission(Context ctx, Set orgUnitSet, String btnName) throws BOSException, EASBizException {
        FunctionPermissionService fps = new FunctionPermissionService(ctx);
        IObjectPK userPK = ctx.getCaller();
        ObjectUuidPK orgPk = null;
        if (orgUnitSet.size() > 0) {
            Iterator it = orgUnitSet.iterator();
            String orgId = null;
            while (it.hasNext()) {
                orgId = (String)it.next();
                orgPk = new ObjectUuidPK(orgId);
                boolean ba = fps.hasPermission(userPK, (IObjectPK)orgPk, "inventoryAdjust", true);
                if (ba) continue;
                IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("ID", (Object)orgPk, CompareType.EQUALS));
                ev.setFilter(fi);
                FullOrgUnitCollection orgUnitCollection = iFullOrgUnit.getFullOrgUnitCollection(ev);
                FullOrgUnitInfo oui = orgUnitCollection.get(0);
                throw new InvBizException(InvBizException.HAVE_NO_PERMISSION, new Object[]{oui.getName(), btnName});
            }
        }
    }

    @Override
    protected Map _getBillReservationMap(Context ctx, Map reqEntryMatchFilter) throws BOSException {
        HashMap rs = new HashMap();
        for (Map.Entry entry : reqEntryMatchFilter.entrySet()) {
            String billEntryId = (String)entry.getKey();
            String oql = (String)entry.getValue();
            InventoryCollection collection = InventoryFactory.getLocalInstance(ctx).getInventoryCollection(oql);
            if (collection == null || collection.size() <= 0) continue;
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < collection.size(); ++i) {
                list.add(collection.get(i).getId().toString());
            }
            rs.put(billEntryId, list);
        }
        return rs;
    }
}

