/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelFactory;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.im.inv.IInventory;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.inv.app.AbstractInventoryFacadeControllerBean;
import com.kingdee.eas.scm.im.inv.invconfig.SQLDataAccessFacadeFactory;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InventoryFacadeControllerBean
extends AbstractInventoryFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.InventoryFacadeControllerBean");
    public static final String resClassName = "com.kingdee.eas.scm.im.inv.invconfig.BillInventoryResource";
    public static final String suffix = "pk_hide";
    public static final String CRTL = "\r\n";
    public static final String companyOrgUnit = "FCompanyOrgUnitID";
    public static final String PERM_SQL = "permissionSQL";
    public static final String PERM_JOIN_SQL = "permissionJoinSQL";
    public static Map<String, String> qtyPrecisionMap = new HashMap<String, String>();
    public static final int MAX_PRECISION = 8;

    @Override
    protected boolean _isDataInInventory(Context ctx, String lot, BOSUuid materialID) throws BOSException, EASBizException {
        return this._isDataInInventory(ctx, null, lot, materialID);
    }

    @Override
    protected boolean _isDataInInventory(Context ctx, BOSUuid storageOrgUnitId, String lot, BOSUuid materialID) throws BOSException, EASBizException {
        if (lot == null || lot.length() == 0 || materialID == null) {
            return false;
        }
        FilterInfo filter = new FilterInfo();
        if (storageOrgUnitId != null) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit", (Object)storageOrgUnitId, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("lot", (Object)lot, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("curStoreQty", (Object)new BigDecimal("0.00"), CompareType.NOTEQUALS));
        IInventory iInventory = InventoryFactory.getLocalInstance(ctx);
        return iInventory.exists(filter);
    }

    @Override
    protected Set _getMessageUser(Context ctx, String lot, BOSUuid materialID) throws BOSException, EASBizException {
        HashSet<String> receiversHashSet = new HashSet<String>();
        if (lot == null || lot.length() == 0 || materialID == null) {
            return receiversHashSet;
        }
        Connection conn = null;
        PreparedStatement preStmt = null;
        ResultSet rs = null;
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("select fid from T_PM_User where FPersonId in(");
            sb.append("select DISTINCT B.FwhmanID from ");
            sb.append("T_IM_Inventory A LEFT OUTER JOIN T_DB_WAREHOUSE B ON A.FWarehouseID = B.FID ");
            sb.append("where A.FLot = ? and A.FMaterialID = ? and A.FCurStoreQty <> 0 and A.FCurStoreQty is Not NULL ");
            sb.append(")");
            conn = EJBFactory.getConnection((Context)ctx);
            preStmt = conn.prepareStatement(sb.toString());
            preStmt.setString(1, lot);
            preStmt.setString(2, materialID.toString());
            rs = preStmt.executeQuery();
            String userID = "";
            while (rs.next()) {
                userID = rs.getString("fid");
                if (receiversHashSet.contains(userID)) continue;
                receiversHashSet.add(userID);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, preStmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)preStmt, (Connection)conn);
        return receiversHashSet;
    }

    @Override
    protected int _clearZERODate(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement preStmt = null;
        ResultSet rs = null;
        StringBuffer sb = new StringBuffer();
        sb.append("select count(1) as count from T_IM_Inventory where FBaseQty = 0 ");
        int count = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            preStmt = conn.prepareStatement(sb.toString());
            rs = preStmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt("count");
            }
            if (count > 0) {
                sb = new StringBuffer();
                sb.append("Delete T_IM_Inventory where FBaseQty = 0 ");
                preStmt = conn.prepareStatement(sb.toString());
                preStmt.execute();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, preStmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)preStmt, (Connection)conn);
        return count;
    }

    @Override
    protected BigDecimal _getInstanceStorageByDate(Context ctx, String materialID, String souID, String unitID, java.util.Date date) throws BOSException, EASBizException {
        BigDecimal bigDecimal;
        if (StringUtils.isEmpty((String)materialID) || StringUtils.isEmpty((String)souID) || StringUtils.isEmpty((String)unitID) || date == null) {
            return null;
        }
        OrgUnitCollection orgColl = SCMGroupServerUtils.getOrgsByRelation((Context)ctx, (OrgType)OrgType.Storage, (OrgType)OrgType.Company, (String)souID);
        if (orgColl.size() == 0) {
            return new BigDecimal("0");
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)orgColl.get(0);
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (IObjectPK)companyPK);
        if (currentPeriodInfo == null) {
            return new BigDecimal("0");
        }
        java.util.Date curPeriodBegin = currentPeriodInfo.getBeginDate();
        Calendar calendar = Calendar.getInstance();
        if (date.after(curPeriodBegin)) {
            calendar.setTime(curPeriodBegin);
        } else {
            calendar.setTime(date);
        }
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        StringBuffer sb1 = new StringBuffer();
        sb1.append(" (SELECT SUM(FPeriodBeginQty) AS FBASEQTY FROM T_IM_InventoryBalance WHERE FYear = ? AND FPeriod = ? ");
        sb1.append(" AND FMaterialID = ? AND FStorageOrgUnitID = ?) ");
        StringBuffer sb2 = new StringBuffer();
        sb2.append(" (SELECT SUM(FBaseQty) AS FBASEQTY FROM T_IM_InventoryLog WHERE ");
        sb2.append("  FMaterialID = ? AND FStorageOrgUnitID = ? AND FBizDate < ? AND FBizDate >= ?) ");
        StringBuffer sbAll = new StringBuffer();
        sbAll.append(" (SELECT SUM(FBaseQty) AS FBASEQTY FROM (").append(sb1).append(" UNION ALL ").append(sb2).append(") T1 ) T2");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FBASEQTY * ");
        sql.append(" (SELECT TOP 1 FBaseConvsRate FROM T_BD_MultiMeasureUnit mmu WHERE MMU.FMeasureUnitID = ? AND mmu.FMaterialID = ?) ");
        sql.append(" FROM ").append(sbAll);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, unitID);
            stmt.setString(2, materialID);
            stmt.setInt(3, calendar.get(1));
            stmt.setInt(4, calendar.get(2) + 1);
            stmt.setString(5, materialID);
            stmt.setString(6, souID);
            stmt.setString(7, materialID);
            stmt.setString(8, souID);
            stmt.setDate(9, TypeConversionUtils.objToDate((Object)date));
            stmt.setDate(10, TypeConversionUtils.objToDate((Object)calendar.getTime()));
            rs = stmt.executeQuery();
            BigDecimal retValue = null;
            if (rs.next()) {
                retValue = rs.getBigDecimal(1);
            }
            bigDecimal = retValue;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getMaterialGroupLongNumber(Context ctx, IObjectValue materialTypeFrom, IObjectValue materialTypeTo, String materialStanderd) throws BOSException {
        boolean matFromIsLeaf = false;
        boolean matToIsLeaf = false;
        String from = null;
        String to = null;
        if (materialTypeFrom != null) {
            from = ((MaterialGroupInfo)materialTypeFrom).getNumber();
            matFromIsLeaf = ((MaterialGroupInfo)materialTypeFrom).isIsLeaf();
        }
        if (materialTypeTo != null) {
            to = ((MaterialGroupInfo)materialTypeTo).getNumber();
            matToIsLeaf = ((MaterialGroupInfo)materialTypeTo).isIsLeaf();
        }
        if (materialTypeFrom != null || materialTypeTo != null) {
            StringBuffer sql2 = new StringBuffer();
            sql2.append("select distinct flongnumber from t_bd_materialGroup as mt  where mt.FGroupStandard='");
            sql2.append(materialStanderd).append("'");
            if (materialTypeFrom != null) {
                sql2.append(" and mt.fnumber >= '").append(from).append("' ");
            }
            if (materialTypeTo != null) {
                sql2.append(" and  mt.fnumber <= '").append(to).append("' ");
            }
            ArrayList<String> list = new ArrayList<String>();
            Connection conn = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                RptRowSet rs = DBUtil.executeQuery((String)sql2.toString(), null, (int)0, (int)-1, (Connection)conn);
                int i = 0;
                while (rs.next()) {
                    ++i;
                    list.add(rs.getString("flongnumber"));
                }
                ArrayList<String> arrayList = list;
                return arrayList;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        return null;
    }

    protected Set<String> initDefaultProperty() {
        String[] fields = new String[]{"FID", companyOrgUnit, "FStorageOrgUnitID", "FWarehouseID", "FLocationID", "FLot", "FStoreTypeID", "FStoreStatusID", "FSupplierID", "FCustomerID", "FMaterialID", "FProjectID", "FTrackNumberID", "FUnitID", "FCurStoreQty", "FAssistUnitID", "FCurStoreAssistQty", "FBaseQty", "FAmount", "FBaseUnitID", "FExp", "FAssistPropertyID"};
        return new HashSet<String>(Arrays.asList(fields));
    }

    private static SelectorItemCollection getBalanceModelSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entry.*"));
        return selector;
    }

    public static BalanceModelInfo getBalanceModelInfo(Context ctx) throws Exception {
        BalanceModelInfo balanceModelInfo = BalanceModelFactory.getLocalInstance((Context)ctx).getBalanceModelInfo((IObjectPK)new ObjectUuidPK("SOYjDrxMRamtGGENYUm98SPUYjI="), InventoryFacadeControllerBean.getBalanceModelSelector());
        return balanceModelInfo;
    }

    public static BalanceFieldModelCollection getBalanceFieldModelColl(Context ctx) throws Exception {
        BalanceModelInfo balanceModelInfo = InventoryFacadeControllerBean.getBalanceModelInfo(ctx);
        BalanceFieldModelCollection coll = balanceModelInfo.getEntry();
        coll.sort("seq");
        return coll;
    }

    protected String[] getOrderFields() {
        String[] orderFields = new String[]{"FID", "FControlUnitID", "FMaterialID", "FLot", "FUnitID", "FCurStoreQty", "FBaseUnitID", "FBaseQty", "FAssistUnitID", "FCurStoreAssistQty", "FAssistPropertyID", "FWarehouseID", "FLocationID", "FStoreTypeID", "FStoreStatusID", "FCustomerID", "FSupplierID", "FProjectID", "FTrackNumberID", "FStorageOrgUnitID", "FLastUpdateUserID", "FCreatorID", "FLastUpdateTime", "FCreateTime", "FExp", "FAmount", companyOrgUnit};
        return orderFields;
    }

    private BalanceFieldModelInfo getBalanceFieldModelInfo(BalanceFieldModelCollection coll, String fieldName) {
        BalanceFieldModelInfo fieldInfo = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            fieldInfo = coll.get(i);
            if (!fieldName.equals(fieldInfo.getFieldName())) continue;
            return fieldInfo;
        }
        return null;
    }

    protected BalanceFieldModelCollection getBalanceFieldModelCollInOrder(Context ctx) throws Exception {
        BalanceFieldModelCollection coll = InventoryFacadeControllerBean.getBalanceFieldModelColl(ctx);
        BalanceFieldModelCollection orderColl = new BalanceFieldModelCollection();
        String[] orderFields = this.getOrderFields();
        String field2 = null;
        BalanceFieldModelInfo fieldInfo = null;
        for (String field2 : orderFields) {
            fieldInfo = this.getBalanceFieldModelInfo(coll, field2);
            if (fieldInfo == null) continue;
            orderColl.add(fieldInfo);
            coll.remove(fieldInfo);
        }
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)coll)) {
            orderColl.addCollection(coll);
        }
        return orderColl;
    }

    protected StringBuilder getDefaultSelectSQL(String loc) {
        StringBuilder sb = new StringBuilder(1000);
        sb.append(" SELECT MATERIAL.FName_").append(loc).append(" AS MaterialName, ").append(CRTL);
        sb.append(" MATERIAL.FNumber AS MaterialNumber, ").append(CRTL);
        sb.append(" MATERIAL.FModel AS MaterialModel, ").append(CRTL);
        sb.append(" MATERIAL.FHelpCode AS materialHelpCode, ").append(CRTL);
        sb.append(" INVENTORY.FMaterialID AS FMaterialID, ").append(CRTL);
        sb.append(" INVENTORY.FWarehouseID AS FWarehouseID, ").append(CRTL);
        sb.append(" STORAGEORGUNIT.FName_").append(loc).append(" AS FStorageOrgUnitIDpk_hide, ").append(CRTL);
        sb.append(" STORAGEORGUNIT.FNumber AS STORAGEORGUNITNUMBER,  ").append(CRTL);
        sb.append(" ASSISTPROPERTY.FName_").append(loc).append(" AS FAssistPropertyIDpk_hide, ").append(CRTL);
        sb.append(" CASE WHEN INVENTORY.FLot = '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' THEN NULL ELSE INVENTORY.FLot END AS FLOT, ").append(CRTL);
        sb.append(" UNIT.FID AS FUnitID, ").append(CRTL);
        sb.append(" UNIT.FName_").append(loc).append(" AS FUnitIDpk_hide, ").append(CRTL);
        sb.append(" BASEUNIT.FName_").append(loc).append(" AS FBaseUnitIDpk_hide,  ").append(CRTL);
        sb.append(" ISNULL(INVENTORY.FBaseQty, 0) AS FBaseQty,  ").append(CRTL);
        sb.append(" ISNULL(INVENTORY.FCurStoreQty, 0) AS FCurStoreQty,  ").append(CRTL);
        sb.append(" ISNULL(INVENTORY.FCurStoreAssistQty, 0) AS FCurStoreAssistQty,  ").append(CRTL);
        sb.append(" ISNULL(INVENTORY.FBaseQty, 0) - ISNULL(RESERVATION.FReservationBaseQty, 0) AS FRealBaseQty,  ").append(CRTL);
        sb.append(" ISNULL(INVENTORY.FCurStoreQty, 0) ");
        sb.append(" - ");
        sb.append(" ISNULL(DECIMAL((RESERVATION.FReservationBaseQty / MULTIUNIT.FBaseConvsRate), 21, 8), 0) ");
        sb.append(" AS FRealQty,  ").append(CRTL);
        sb.append(" ISNULL(INVENTORY.FCurStoreAssistQty, 0) - ISNULL(RESERVATION.FReservationAssistQty, 0) AS FRealAssistQty,  ").append(CRTL);
        sb.append(" INVENTORY.FID AS ID,  ").append(CRTL);
        sb.append(" SUPPLIER.FName_").append(loc).append(" AS FSupplierIDpk_hide,  ").append(CRTL);
        sb.append(" CUSTOMER.FName_").append(loc).append(" AS FCustomerIDpk_hide,  ").append(CRTL);
        sb.append(" STORESTATUS.FName_").append(loc).append(" AS FStoreStatusIDpk_hide,  ").append(CRTL);
        sb.append(" STORETYPE.FName_").append(loc).append(" AS FStoreTypeIDpk_hide, ").append(CRTL);
        sb.append(" WAREHOUSE.FName_").append(loc).append(" AS FWarehouseIDpk_hide, ").append(CRTL);
        sb.append(" LOCATION.FName_").append(loc).append(" AS FLocationIDpk_hide,  ").append(CRTL);
        sb.append(" PROJECT.FNumber AS FProjectIDpk_hide, ").append(CRTL);
        sb.append(" PROJECT.FName_").append(loc).append(" AS FProjectName, ").append(CRTL);
        sb.append(" TRACKNUMBER.FNumber AS FTrackNumberIDpk_hide,  ").append(CRTL);
        sb.append(" MULTIUNIT.FQtyPrecision AS MULTIUNITQTYPRECISION,  ").append(CRTL);
        sb.append(" MULTIBASEUNIT.FQtyPrecision AS MULTIBASEUNITQTYPRECISION,  ").append(CRTL);
        sb.append(" COMPANYORGUNIT.FName_").append(loc).append(" AS COMPANYORGUNITNAME, ").append(CRTL);
        sb.append(" ASSISTUNIT.FName_").append(loc).append(" AS FAssistUnitIDpk_hide,  ").append(CRTL);
        sb.append(" INVENTORY.FStorageOrgUnitID AS FStorageOrgUnitID,  ").append(CRTL);
        sb.append(" ISNULL(DECIMAL((RESERVATION.FReservationBaseQty / MULTIUNIT.FBaseConvsRate), 21, 8), 0) AS FReservationQty, ").append(CRTL);
        sb.append(" ISNULL(RESERVATION.FReservationBaseQty,0) AS FReservationBaseQty,  ").append(CRTL);
        sb.append(" ISNULL(RESERVATION.FReservationAssistQty,0) AS FReservationAssistQty, ").append(CRTL);
        sb.append(" INVENTORYUNIT.FName_").append(loc).append(" AS INVENTORYUNITNAME, ").append(CRTL);
        sb.append(" ISNULL(ROUND(DECIMAL((INVENTORY.FBaseQty / MULTIINVENTORYUNIT.FBaseConvsRate), 21, 8), MULTIINVENTORYUNIT.FQtyPrecision), 0) AS CURMATSTOREQTY, ").append(CRTL);
        sb.append(" MULTIINVENTORYUNIT.FQtyPrecision AS MULTIINVENTORYUNITQTYPRECIS32,  ").append(CRTL);
        sb.append(" ISNULL(MULTIBASEUNIT.FBaseConvsRate, 1) AS MULTIBASEUNITBASECONVSRATE,  ").append(CRTL);
        sb.append(" INVENTORY.FStoreTypeID AS FStoreTypeID,  ").append(CRTL);
        sb.append(" INVENTORY.FStoreStatusID AS FStoreStatusID, ").append(CRTL);
        sb.append(" ISNULL(MULTIUNIT.FBaseConvsRate, 1) AS MULTIUNITBASECONVSRATE,  ").append(CRTL);
        sb.append(" MULTIASSITUNIT.FQtyPrecision AS MULTIASSITUNITQTYPRECISION,  ").append(CRTL);
        sb.append(" DATEOFMINDURABILITY.FMfg AS MFG,  ").append(CRTL);
        sb.append(" DATEOFMINDURABILITY.FExp AS EXP  ").append(CRTL);
        return sb;
    }

    protected StringBuilder getReservationSQL() {
        StringBuilder sql = new StringBuilder(200);
        sql.append(" LEFT OUTER JOIN (");
        sql.append(" SELECT FInventoryID, ");
        sql.append(" ISNULL(SUM(FReservationQty), 0) AS FReservationQty, ").append(" ISNULL(SUM(FReservationBaseQty), 0) AS FReservationBaseQty, ").append(" ISNULL(SUM(FReservationAssistQty), 0) AS FReservationAssistQty ");
        sql.append(" FROM T_IM_Reservation ");
        sql.append(" GROUP BY FInventoryID) AS RESERVATION ");
        sql.append(" ON RESERVATION.FInventoryID = INVENTORY.FID ").append(CRTL);
        return sql;
    }

    protected StringBuilder getDefaultFromSQL() {
        StringBuilder sb = new StringBuilder(1000);
        sb.append(" FROM T_IM_Inventory AS INVENTORY ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_BD_Supplier AS SUPPLIER ON INVENTORY.FSupplierID = SUPPLIER.FID ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_IM_STORESTATE AS STORESTATUS ON INVENTORY.FStoreStatusID = STORESTATUS.FID ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_IM_STORETYPE AS STORETYPE ON INVENTORY.FStoreTypeID = STORETYPE.FID ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_DB_LOCATION AS LOCATION ON INVENTORY.FLocationID = LOCATION.FID ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_DB_WAREHOUSE AS WAREHOUSE ON INVENTORY.FWarehouseID = WAREHOUSE.FID ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_ORG_Storage AS STORAGEORGUNIT ON INVENTORY.FStorageOrgUnitID = STORAGEORGUNIT.FID ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANYORGUNIT ON INVENTORY.FCompanyOrgUnitID = COMPANYORGUNIT.FID ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_BD_Material AS MATERIAL ON INVENTORY.FMaterialID = MATERIAL.FID ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ON INVENTORY.FUnitID = UNIT.FID ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS ASSISTUNIT ON INVENTORY.FAssistUnitID = ASSISTUNIT.FID ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ON INVENTORY.FCustomerID = CUSTOMER.FID ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIUNIT ON INVENTORY.FMaterialID = MULTIUNIT.FMaterialID AND INVENTORY.FUnitID = MULTIUNIT.FMeasureUnitID ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIBASEUNIT ON INVENTORY.FMaterialID = MULTIBASEUNIT.FMaterialID AND INVENTORY.FBaseUnitID = MULTIBASEUNIT.FMeasureUnitID ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIASSITUNIT ON INVENTORY.FMaterialID = MULTIASSITUNIT.FMaterialID AND INVENTORY.FAssistUnitID = MULTIASSITUNIT.FMeasureUnitID ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_BD_AsstAttrValue AS ASSISTPROPERTY ON INVENTORY.FAssistPropertyID = ASSISTPROPERTY.FID ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS BASEUNIT ON INVENTORY.FBaseUnitID = BASEUNIT.FID ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_BD_MaterialCost AS MATERIALCOST ON INVENTORY.FCompanyOrgUnitID = MATERIALCOST.FOrgUnit AND INVENTORY.FMaterialID = MATERIALCOST.FMaterialID ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_MM_TrackNumber AS TRACKNUMBER ON INVENTORY.FTrackNumberID = TRACKNUMBER.FID ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_MM_Project AS PROJECT ON INVENTORY.FProjectID = PROJECT.FID ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_BD_MaterialInventory AS MATERIALINVENTORY ON INVENTORY.FStorageOrgUnitID = MATERIALINVENTORY.FOrgUnit AND INVENTORY.FMaterialID = MATERIALINVENTORY.FMaterialID ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_IM_DateOfMinDurability AS DATEOFMINDURABILITY ON INVENTORY.FStorageOrgUnitID = DATEOFMINDURABILITY.FStorageOrgUnitID AND INVENTORY.FMaterialID = DATEOFMINDURABILITY.FMaterialID AND INVENTORY.FLot = DATEOFMINDURABILITY.FLot ").append(CRTL);
        sb.append(" INNER JOIN T_BD_MaterialGroupDetial AS MATERIALGROUPDETAILS ON INVENTORY.FMaterialID = MATERIALGROUPDETAILS.FMaterialID ").append(CRTL);
        sb.append(" INNER JOIN T_BD_MaterialGroup AS MATERIALGROUP ON MATERIALGROUPDETAILS.FMaterialGroupID = MATERIALGROUP.FID ").append(CRTL);
        sb.append(" INNER JOIN T_BD_MaterialGroupStandard AS GROUPSTANDARD ON MATERIALGROUP.FGroupStandard = GROUPSTANDARD.FID ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS INVENTORYUNIT ON MATERIALINVENTORY.FUnitID = INVENTORYUNIT.FID ").append(CRTL);
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIINVENTORYUNIT ON MATERIALINVENTORY.FMaterialID = MULTIINVENTORYUNIT.FMaterialID AND MATERIALINVENTORY.FUnitID = MULTIINVENTORYUNIT.FMeasureUnitID ").append(CRTL);
        sb.append((CharSequence)this.getReservationSQL());
        return sb;
    }

    protected StringBuilder getDefaultWhereSQL() {
        StringBuilder sb = new StringBuilder(50);
        sb.append(" WHERE ((INVENTORY.FBaseQty <> 0) OR (INVENTORY.FCurStoreQty <> 0) OR (INVENTORY.FCurStoreAssistQty <> 0)) ").append(CRTL);
        return sb;
    }

    protected StringBuilder getDiffAdjustWhereSQL() {
        StringBuilder buf = new StringBuilder(200);
        buf.append(" WHERE (((ISNULL(INVENTORY.FCurStoreQty,0) * ISNULL(INVENTORY.FBaseQty,0)) <= 0)  ").append(CRTL).append(" AND ((ISNULL(INVENTORY.FCurStoreQty,0) - ISNULL(INVENTORY.FBaseQty,0)) <> 0)  ").append(CRTL).append(" OR (ISNULL(INVENTORY.FCurStoreQty,0) = 0  ").append(CRTL).append(" AND ISNULL(INVENTORY.FBaseQty,0) = 0  ").append(CRTL).append(" AND (ISNULL(INVENTORY.FCurStoreAssistQty,0) <> 0)))  ").append(CRTL);
        return buf;
    }

    protected StringBuilder initCreateTempTableSQL() {
        StringBuilder createTempTableSQL = new StringBuilder(500);
        createTempTableSQL.append(" create table temp_table(");
        createTempTableSQL.append(" MaterialName nvarchar(255),");
        createTempTableSQL.append(" MaterialNumber nvarchar(80),");
        createTempTableSQL.append(" FStorageOrgUnitIDpk_hide nvarchar(255),");
        createTempTableSQL.append(" MaterialModel nvarchar(255),");
        createTempTableSQL.append(" materialHelpCode nvarchar(80),");
        createTempTableSQL.append(" FMaterialID varchar(44),");
        createTempTableSQL.append(" FWarehouseID varchar(44),");
        createTempTableSQL.append(" STORAGEORGUNITNUMBER nvarchar(80),");
        createTempTableSQL.append(" FAssistPropertyIDpk_hide nvarchar(2000),");
        createTempTableSQL.append(" FLOT nvarchar(1000),");
        createTempTableSQL.append(" FUnitID varchar(44),");
        createTempTableSQL.append(" FUnitIDpk_hide nvarchar(255),");
        createTempTableSQL.append(" FBaseUnitIDpk_hide nvarchar(255),");
        createTempTableSQL.append(" FBaseQty Decimal(28,10) not null default 0,");
        createTempTableSQL.append(" FRealBaseQty Decimal(28,10) not null default 0,");
        createTempTableSQL.append(" FCurStoreQty Decimal(28,10) not null default 0,");
        createTempTableSQL.append(" FRealQty Decimal(28,10) not null default 0,");
        createTempTableSQL.append(" FCurStoreAssistQty Decimal(28,10) not null default 0,");
        createTempTableSQL.append(" FRealAssistQty Decimal(28,10) not null default 0,");
        createTempTableSQL.append(" ID varchar(44),");
        createTempTableSQL.append(" FSupplierIDpk_hide nvarchar(255),");
        createTempTableSQL.append(" FCustomerIDpk_hide nvarchar(255),");
        createTempTableSQL.append(" FStoreStatusIDpk_hide nvarchar(255),");
        createTempTableSQL.append(" FStoreTypeIDpk_hide nvarchar(255),");
        createTempTableSQL.append(" FWarehouseIDpk_hide nvarchar(255),");
        createTempTableSQL.append(" FLocationIDpk_hide nvarchar(255),");
        createTempTableSQL.append(" FProjectIDpk_hide nvarchar(80),");
        createTempTableSQL.append(" FProjectName nvarchar(255),");
        createTempTableSQL.append(" FTrackNumberIDpk_hide nvarchar(80),");
        createTempTableSQL.append(" MULTIUNITQTYPRECISION int,");
        createTempTableSQL.append(" MULTIBASEUNITQTYPRECISION int,");
        createTempTableSQL.append(" COMPANYORGUNITNAME nvarchar(255),");
        createTempTableSQL.append(" FAssistUnitIDpk_hide nvarchar(255),");
        createTempTableSQL.append(" FStorageOrgUnitID varchar(44),");
        createTempTableSQL.append(" FReservationQty Decimal(28,10) not null default 0,");
        createTempTableSQL.append(" FReservationBaseQty Decimal(28,10) not null default 0,");
        createTempTableSQL.append(" FReservationAssistQty Decimal(28,10) not null default 0,");
        createTempTableSQL.append(" INVENTORYUNITNAME nvarchar(255),");
        createTempTableSQL.append(" CURMATSTOREQTY Decimal(28,10) not null default 0,");
        createTempTableSQL.append(" MULTIINVENTORYUNITQTYPRECIS32 int,");
        createTempTableSQL.append(" MULTIBASEUNITBASECONVSRATE Decimal(28,10) not null default 1,");
        createTempTableSQL.append(" FStoreTypeID varchar(44),");
        createTempTableSQL.append(" FStoreStatusID varchar(44),");
        createTempTableSQL.append(" MULTIUNITBASECONVSRATE Decimal(28,10) not null default 1,");
        createTempTableSQL.append(" MULTIASSITUNITQTYPRECISION int,");
        createTempTableSQL.append(" MFG datetime,");
        createTempTableSQL.append(" EXP datetime");
        return createTempTableSQL;
    }

    protected StringBuilder initFieldSQL() {
        StringBuilder fieldSQL = new StringBuilder(300);
        fieldSQL.append(" MaterialName, ");
        fieldSQL.append(" MaterialNumber, ");
        fieldSQL.append(" MaterialModel, ");
        fieldSQL.append(" materialHelpCode, ");
        fieldSQL.append(" FMaterialID, ");
        fieldSQL.append(" FWarehouseID, ");
        fieldSQL.append(" FStorageOrgUnitIDpk_hide, ");
        fieldSQL.append(" STORAGEORGUNITNUMBER, ");
        fieldSQL.append(" FAssistPropertyIDpk_hide, ");
        fieldSQL.append(" FLOT, ");
        fieldSQL.append(" FUnitID, ");
        fieldSQL.append(" FUnitIDpk_hide, ");
        fieldSQL.append(" FBaseUnitIDpk_hide, ");
        fieldSQL.append(" FBaseQty, ");
        fieldSQL.append(" FCurStoreQty, ");
        fieldSQL.append(" FCurStoreAssistQty, ");
        fieldSQL.append(" FRealBaseQty, ");
        fieldSQL.append(" FRealQty, ");
        fieldSQL.append(" FRealAssistQty, ");
        fieldSQL.append(" ID, ");
        fieldSQL.append(" FSupplierIDpk_hide, ");
        fieldSQL.append(" FCustomerIDpk_hide\t, ");
        fieldSQL.append(" FStoreStatusIDpk_hide, ");
        fieldSQL.append(" FStoreTypeIDpk_hide, ");
        fieldSQL.append(" FWarehouseIDpk_hide, ");
        fieldSQL.append(" FLocationIDpk_hide, ");
        fieldSQL.append(" FProjectIDpk_hide, ");
        fieldSQL.append(" FProjectName, ");
        fieldSQL.append(" FTrackNumberIDpk_hide, ");
        fieldSQL.append(" MULTIUNITQTYPRECISION, ");
        fieldSQL.append(" MULTIBASEUNITQTYPRECISION, ");
        fieldSQL.append(" COMPANYORGUNITNAME, ");
        fieldSQL.append(" FAssistUnitIDpk_hide, ");
        fieldSQL.append(" FStorageOrgUnitID, ");
        fieldSQL.append(" FReservationQty, ");
        fieldSQL.append(" FReservationBaseQty, ");
        fieldSQL.append(" FReservationAssistQty, ");
        fieldSQL.append(" INVENTORYUNITNAME, ");
        fieldSQL.append(" CURMATSTOREQTY, ");
        fieldSQL.append(" MULTIINVENTORYUNITQTYPRECIS32, ");
        fieldSQL.append(" MULTIBASEUNITBASECONVSRATE, ");
        fieldSQL.append(" FStoreTypeID, ");
        fieldSQL.append(" FStoreStatusID, ");
        fieldSQL.append(" MULTIUNITBASECONVSRATE, ");
        fieldSQL.append(" MULTIASSITUNITQTYPRECISION, ");
        fieldSQL.append(" MFG, ");
        fieldSQL.append(" EXP ");
        return fieldSQL;
    }

    public static String getResourceValue(Context ctx, String resClassName, String key) {
        return ResourceBase.getString((String)resClassName, (String)key, (Locale)ctx.getLocale());
    }

    public static String getBillInventoryResource(Context ctx, String key) {
        return InventoryFacadeControllerBean.getResourceValue(ctx, resClassName, key);
    }

    protected TableParam initTableParam(Context ctx, Map extendMap) throws Exception {
        TableParam tabParam = new TableParam();
        Set<String> defaultProperty = this.initDefaultProperty();
        BalanceFieldModelCollection balanceFieldModelCol = this.getBalanceFieldModelCollInOrder(ctx);
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String filedName = null;
        String tableAlias = null;
        String linkTable = null;
        StringBuilder sqlSelect = this.getDefaultSelectSQL(loc);
        StringBuilder sqlFrom = this.getDefaultFromSQL();
        StringBuilder createTempTableSQL = this.initCreateTempTableSQL();
        StringBuilder tmpTablefieldSQL = this.initFieldSQL();
        BalanceFieldModelInfo fieldModeInfo = null;
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        int size = balanceFieldModelCol.size();
        for (int i = 0; i < size; ++i) {
            fieldModeInfo = balanceFieldModelCol.get(i);
            if (fieldModeInfo.getBizDataType() == BizDataTypeEnum.AssistInfo && !fieldModeInfo.isIsSPvisible()) continue;
            filedName = fieldModeInfo.getFieldName();
            if (DataTypeEnum.Boolean.equals((Object)fieldModeInfo.getDataType())) {
                tabParam.addBoolColumn(filedName);
            }
            if (defaultProperty.contains(filedName)) {
                if (filedName.equalsIgnoreCase("FMaterialID")) {
                    tabParam.addColumn("MaterialNumber", InventoryFacadeControllerBean.getBillInventoryResource(ctx, "materialNumber")).addColumn("MaterialName", fieldModeInfo.getAlias()).addColumn("MaterialModel", InventoryFacadeControllerBean.getBillInventoryResource(ctx, "materialModel")).addColumn("materialHelpCode", InventoryFacadeControllerBean.getBillInventoryResource(ctx, "MaterialHelpCode")).addColumn("FMaterialID");
                    continue;
                }
                if (filedName.equalsIgnoreCase("FLot")) {
                    tabParam.addColumn(filedName, fieldModeInfo.getAlias()).addColumn("Mfg", InventoryFacadeControllerBean.getBillInventoryResource(ctx, "mfg")).addColumn("Exp", InventoryFacadeControllerBean.getBillInventoryResource(ctx, "exp"));
                    continue;
                }
                if (filedName.equalsIgnoreCase("FUnitID")) {
                    String unitName = filedName + suffix;
                    tabParam.addColumn("FUnitID");
                    tabParam.addColumn(unitName, fieldModeInfo.getAlias());
                    continue;
                }
                String key = filedName;
                if (DataTypeEnum.BOSUuid.equals((Object)fieldModeInfo.getDataType())) {
                    if (fieldModeInfo.getBaseDataBOSType() == null) {
                        tabParam.addColumn("id");
                        continue;
                    }
                    key = filedName + suffix;
                }
                tabParam.addColumn(key, fieldModeInfo.getAlias());
                continue;
            }
            DataTypeEnum tmp = fieldModeInfo.getDataType();
            fieldModeInfo.setDataType(DataTypeEnum.String);
            tableAlias = fieldModeInfo.getFieldName();
            fieldModeInfo.setDataType(tmp);
            if (DataTypeEnum.BOSUuid.equals((Object)fieldModeInfo.getDataType())) {
                sqlSelect.append(", ").append(tableAlias).append(".fname_").append(loc).append(" as ").append(filedName + suffix).append(" ").append(CRTL).append(", ").append(tableAlias).append(".fid as ").append(filedName).append(" ").append(CRTL);
                IMetaDataPK pk = imeataLoader.getEntityObjectPK(BOSObjectType.create((String)fieldModeInfo.getBaseDataBOSType()));
                EntityObjectInfo entityObjInfo = imeataLoader.getEntity(pk);
                linkTable = entityObjInfo.getTable().getName();
                sqlFrom.append(" left join ").append(linkTable).append(" as ").append(tableAlias).append(" on inventory.").append(filedName).append("=").append(tableAlias).append(".fid ").append(CRTL);
                String key = filedName + suffix;
                tabParam.addColumn(key, fieldModeInfo.getAlias());
                tabParam.addColumn(filedName);
                createTempTableSQL.append(", ").append(key).append(" nvarchar(255)");
                createTempTableSQL.append(", ").append(filedName).append(" varchar(44)");
                tmpTablefieldSQL.append(" , ").append(key).append(" , ").append(filedName);
                continue;
            }
            sqlSelect.append(", INVENTORY.").append(filedName).append(" as ").append(filedName);
            tabParam.addColumn(filedName, fieldModeInfo.getAlias());
            DataTypeEnum dataType = fieldModeInfo.getDataType();
            if (DataTypeEnum.String.equals((Object)dataType)) {
                createTempTableSQL.append(", ").append(filedName).append(" nvarchar(255)");
            } else if (DataTypeEnum.Integer.equals((Object)dataType) || DataTypeEnum.Boolean.equals((Object)dataType) || DataTypeEnum.Enum.equals((Object)dataType)) {
                createTempTableSQL.append(", ").append(filedName).append(" int");
            } else if (DataTypeEnum.Date.equals((Object)dataType)) {
                createTempTableSQL.append(", ").append(filedName).append(" datetime");
            } else if (DataTypeEnum.Qty.equals((Object)dataType) || DataTypeEnum.Amount.equals((Object)dataType) || DataTypeEnum.Price.equals((Object)dataType)) {
                createTempTableSQL.append(", ").append(filedName).append(" Decimal(28,10) default 0");
            }
            tmpTablefieldSQL.append(" , ").append(filedName);
        }
        tabParam.removeColumn(companyOrgUnit);
        tabParam.removeColumn("FCompanyOrgUnitIDpk_hide");
        tabParam.removeColumn("FAmount");
        tabParam.removeColumn("FID");
        tabParam.removeColumn("FEntrySeq");
        tabParam.addColumn("FStorageOrgUnitID");
        tabParam.addColumn("FStoreTypeID");
        tabParam.addColumn("FStoreStatusID");
        tabParam.addColumn("multiUnitbaseConvsRate", InventoryFacadeControllerBean.getBillInventoryResource(ctx, "multiUnitbaseConvsRate"));
        tabParam.addColumn("multiUnitqtyPrecision", InventoryFacadeControllerBean.getBillInventoryResource(ctx, "multiUnitqtyPrecision"));
        tabParam.addColumn("multiBaseUnitqtyPrecision", InventoryFacadeControllerBean.getBillInventoryResource(ctx, "multiBaseUnitqtyPrecision"));
        tabParam.addColumn("multiAssitUnitqtyPrecision", InventoryFacadeControllerBean.getBillInventoryResource(ctx, "multiAssitUnitqtyPrecision"));
        tabParam.addColumn("FReservationQty", InventoryFacadeControllerBean.getBillInventoryResource(ctx, "reservationQty"));
        tabParam.addColumn("FReservationBaseQty", InventoryFacadeControllerBean.getBillInventoryResource(ctx, "reservationBaseQty"));
        tabParam.addColumn("FReservationAssistQty", InventoryFacadeControllerBean.getBillInventoryResource(ctx, "reservationAssistQty"));
        int index = tabParam.getColumnIndex("FCurStoreQty");
        tabParam.addColumn(index + 1, "FRealQty", InventoryFacadeControllerBean.getBillInventoryResource(ctx, "realQty"));
        tabParam.addColumn(index + 4, "FRealBaseQty", InventoryFacadeControllerBean.getBillInventoryResource(ctx, "realBaseQty"));
        tabParam.addColumn(index + 7, "FRealAssistQty", InventoryFacadeControllerBean.getBillInventoryResource(ctx, "realAssistQty"));
        tabParam.addColumn(index + 2, "INVENTORYUNITNAME", InventoryFacadeControllerBean.getBillInventoryResource(ctx, "inventoryUnit"));
        tabParam.addColumn(index + 3, "CURMATSTOREQTY", InventoryFacadeControllerBean.getBillInventoryResource(ctx, "inventoryQty"));
        index = tabParam.getColumnIndex("FProjectIDpk_hide");
        tabParam.addColumn(index + 1, "FProjectName", InventoryFacadeControllerBean.getBillInventoryResource(ctx, "projectName"));
        StringBuilder sqlBuf = new StringBuilder(sqlSelect.length() + sqlFrom.length() + 300).append((CharSequence)sqlSelect).append((CharSequence)sqlFrom);
        if (null != extendMap && extendMap.containsKey("InvertoryDiffAdjust") && Boolean.valueOf(extendMap.get("InvertoryDiffAdjust").toString()).booleanValue()) {
            sqlBuf.append((CharSequence)this.getDiffAdjustWhereSQL());
        } else {
            sqlBuf.append((CharSequence)this.getDefaultWhereSQL());
        }
        tabParam.setQuerySQL(sqlBuf.toString()).setCreateTempTableSQL(createTempTableSQL.append(");").toString()).setTmpTablefieldSQL(tmpTablefieldSQL.toString());
        return tabParam;
    }

    private Map<String, String> initPermissionSQL(Context ctx, FilterInfo filterInfo) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>(2);
        if (null == filterInfo) {
            return map;
        }
        Set<String> ids = new HashSet();
        FilterItemInfo itemInfo = null;
        String propertyName = null;
        Object obj = null;
        FilterItemCollection filterItemCol = filterInfo.getFilterItems();
        int size = filterItemCol.size();
        for (int i = 0; i < size; ++i) {
            itemInfo = filterItemCol.get(i);
            propertyName = itemInfo.getPropertyName();
            if (!"storageOrgUnit.id".equals(propertyName)) continue;
            obj = itemInfo.getCompareValue();
            if (obj instanceof Set) {
                ids = (Set)obj;
            }
            if (!(obj instanceof String)) continue;
            ids.add(obj.toString());
        }
        if (CollectionUtil.isEmpty(ids)) {
            return map;
        }
        Map permMap = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getPermissionEntityViewMap(ids, null);
        String permissionSQL = (String)permMap.get("PERM_WHERE");
        permissionSQL = permissionSQL.replaceAll("\"T6\".\"FNUMBER\"", "warehouse.fnumber");
        permissionSQL = permissionSQL.replaceAll("\"T7\".\"FNUMBER\"", "location.fnumber");
        permissionSQL = permissionSQL.replaceAll("\"T12\".\"FNUMBER\"", "material.fnumber");
        map.put(PERM_SQL, permissionSQL);
        String permissionJoinSQL = (String)permMap.get("PERM_JOIN");
        map.put(PERM_JOIN_SQL, permissionJoinSQL);
        return map;
    }

    private String getFilterSQL(FilterInfo filterInfo, String loc) {
        if (null == filterInfo) {
            return "";
        }
        String sql = filterInfo.toString();
        sql = sql.replaceAll("\\.id", ".FId");
        sql = sql.replaceAll("\\.ID", ".FId");
        sql = sql.replaceAll("\\.name\\s+", ".FName_" + loc + " ");
        sql = sql.replaceAll("\\.name_" + loc, ".FName_" + loc);
        sql = sql.replaceAll("\\.number", ".FNumber");
        sql = sql.replaceAll("\\.longNumber", ".FLongNumber");
        sql = sql.replaceAll("\\.lot", ".FLot");
        sql = sql.replaceAll("\\.helpCode", ".FHelpCode");
        sql = sql.replaceAll("\\.model", ".FModel");
        sql = sql.replaceAll("\\.storeType", ".FStoreType");
        return sql;
    }

    private String getFinalSQL(Context ctx, String querySQL, FilterInfo filterInfo) throws BOSException {
        Map<String, String> permSQLMap;
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuilder resultSQL = new StringBuilder(querySQL.length() + 1000).append(querySQL);
        String filterSQL = this.getFilterSQL(filterInfo, loc);
        if (!StringUtils.isEmpty((String)filterSQL)) {
            resultSQL.append(" and ").append(filterSQL);
        }
        if (null != (permSQLMap = this.initPermissionSQL(ctx, filterInfo)) && permSQLMap.size() > 0) {
            if (!StringUtils.isEmpty((String)permSQLMap.get(PERM_SQL))) {
                resultSQL.append(" and ").append(permSQLMap.get(PERM_SQL));
            }
            if (!StringUtils.isEmpty((String)permSQLMap.get(PERM_JOIN_SQL))) {
                int offset = querySQL.indexOf("WHERE");
                resultSQL.insert(offset, permSQLMap.get(PERM_JOIN_SQL));
            }
        }
        resultSQL.append(" ORDER BY INVENTORY.FMaterialID ASC, STORAGEORGUNIT.FID ASC,");
        resultSQL.append(" CASE  WHEN INVENTORY.FWarehouseID = '");
        resultSQL.append("EgkAAABc3XG76fiu");
        resultSQL.append("' THEN NULL ELSE INVENTORY.FWarehouseID END ASC, ");
        resultSQL.append("INVENTORY.FID ASC ");
        return resultSQL.toString();
    }

    private int getTotalCount(String tempTable) throws BOSException, SQLException {
        int count = 0;
        String sql = "select count(1) as count from " + tempTable;
        IRowSet rs = new SQLExecutor(sql).executeSQL();
        while (rs.next()) {
            count = rs.getInt(1);
        }
        return count;
    }

    private IRowSet getRowSet(Context ctx, String tempTable, int start, int rows, String sortItems, boolean isPrintGrid, String filterSQL) throws EASBizException, BOSException {
        StringBuilder querySQL = new StringBuilder(200);
        querySQL.append(" select * from ").append(tempTable);
        if (isPrintGrid && !StringUtils.isEmpty((String)filterSQL)) {
            querySQL.append(" where ").append(filterSQL);
        }
        querySQL.append(" order by ");
        if (!StringUtils.isEmpty((String)sortItems)) {
            querySQL.append(sortItems).append(", ");
        }
        String[] defaultSortField = new String[]{"MaterialNumber", "FLot"};
        for (int i = 0; i < defaultSortField.length; ++i) {
            String fieldName = defaultSortField[i];
            if (null != sortItems && sortItems.indexOf(fieldName) != -1) continue;
            querySQL.append(fieldName).append(" ASC,");
        }
        querySQL.append(" FStorageOrgUnitID ASC, FWarehouseID ASC, ID ASC ");
        if (rows > 0) {
            return SQLDataAccessFacadeFactory.getLocalInstance(ctx).getRowSet(querySQL.toString(), start, rows);
        }
        return DbUtil.executeQuery((Context)ctx, (String)querySQL.toString());
    }

    private IRowSet getFootRowSet(Context ctx, String tempTable) throws EASBizException, BOSException {
        StringBuffer sumSQL = new StringBuffer(600);
        sumSQL.append("select sum(FBaseQty) as FBaseQty ").append(CRTL).append(", sum(FCurStoreQty) as FCurStoreQty ").append(CRTL).append(", sum(FCurStoreAssistQty) as FCurStoreAssistQty ").append(CRTL).append(", sum(FReservationQty) as FReservationQty ").append(CRTL).append(", sum(FReservationBaseQty) as FReservationBaseQty ").append(CRTL).append(", sum(FReservationAssistQty) as FReservationAssistQty ").append(CRTL).append(",sum(FRealQty) AS FRealQty, ").append(CRTL).append(" sum(CURMATSTOREQTY) AS CURMATSTOREQTY ").append(CRTL).append(" from ").append(tempTable);
        return DbUtil.executeQuery((Context)ctx, (String)sumSQL.toString());
    }

    public String formatDate(Date value) {
        if (null == value) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(new java.util.Date(value.getTime()));
    }

    public static BigDecimal formatDecimal(BigDecimal value, int scale) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return value.setScale(scale, 4);
    }

    private Map populateRowData(Vector<String> columnList, IRowSet rowSet) throws SQLException {
        HashMap<String, Object> rowData = new HashMap<String, Object>();
        String name = null;
        String precisionName = null;
        BigDecimal qty = null;
        int scale = 0;
        for (int i = 0; i < columnList.size(); ++i) {
            name = columnList.get(i);
            if ("Mfg".equalsIgnoreCase(name) || "Exp".equalsIgnoreCase(name)) {
                Date value = rowSet.getDate(name);
                rowData.put(name, this.formatDate(value));
                continue;
            }
            if (qtyPrecisionMap.containsKey(name)) {
                qty = rowSet.getBigDecimal(name);
                precisionName = qtyPrecisionMap.get(name);
                scale = rowSet.getInt(precisionName) > 8 ? 8 : rowSet.getInt(precisionName);
                rowData.put(name, InventoryFacadeControllerBean.formatDecimal(qty, scale));
                continue;
            }
            rowData.put(name, rowSet.getObject(name));
        }
        return rowData;
    }

    private Map populateFooterData(IRowSet rowSet) throws SQLException {
        HashMap<String, Object> rowData = new HashMap<String, Object>();
        rowData.put("FBaseQty", rowSet.getObject("FBaseQty"));
        rowData.put("FCurStoreQty", rowSet.getObject("FCurStoreQty"));
        rowData.put("FCurStoreAssistQty", rowSet.getObject("FCurStoreAssistQty"));
        rowData.put("FReservationQty", rowSet.getObject("FReservationQty"));
        rowData.put("FReservationBaseQty", rowSet.getObject("FReservationBaseQty"));
        rowData.put("FReservationAssistQty", rowSet.getObject("FReservationAssistQty"));
        rowData.put("FRealQty", rowSet.getObject("FRealQty"));
        rowData.put("CURMATSTOREQTY", rowSet.getObject("CURMATSTOREQTY"));
        return rowData;
    }

    @Override
    protected Map _getGridData(Context ctx, int page, int rows, String filterItems, String tempTable, Map extendMap) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            IRowSet rowSet;
            int size;
            TableParam param = this.initTableParam(ctx, extendMap);
            resultMap.put("columnList", param.getColumnList());
            resultMap.put("labelList", param.getLabelList());
            resultMap.put("boolColumnList", param.getBoolColumnList());
            boolean createNew = false;
            if (StringUtils.isEmpty((String)tempTable)) {
                FilterInfo filterInfo = null;
                if (!StringUtils.isEmpty((String)filterItems)) {
                    filterInfo = new FilterInfo(filterItems);
                }
                String finalSQL = this.getFinalSQL(ctx, param.getQuerySQL(), filterInfo);
                tempTable = SQLDataAccessFacadeFactory.getLocalInstance(ctx).createTempTable(param.getCreateTempTableSQL(), finalSQL, param.getTmpTablefieldSQL(), null);
                createNew = true;
            }
            resultMap.put("tempTable", tempTable);
            resultMap.put("rowCount", this.getTotalCount(tempTable));
            String sortItems = null == extendMap.get("sorterItems") ? null : extendMap.get("sorterItems").toString();
            int start = rows * (page - 1);
            Object obj = extendMap.get("isPrintGrid");
            boolean isPrintGrid = false;
            if (null != obj) {
                isPrintGrid = Boolean.valueOf(obj.toString());
            }
            obj = extendMap.get("isExportExcel");
            boolean isExportExcel = false;
            if (null != obj) {
                isExportExcel = Boolean.valueOf(obj.toString());
            }
            int n = size = null == (rowSet = this.getRowSet(ctx, tempTable, start, rows, sortItems, isPrintGrid, filterItems)) ? 0 : rowSet.size();
            if (isPrintGrid) {
                rowSet.beforeFirst();
                resultMap.put("rowSet", rowSet);
            } else {
                ArrayList<Map> rowList = new ArrayList<Map>(size);
                if (size > 0) {
                    while (rowSet.next()) {
                        rowList.add(this.populateRowData(param.getColumnList(), rowSet));
                    }
                }
                resultMap.put("rowSet", rowList);
            }
            if (createNew && !isPrintGrid && !isExportExcel) {
                IRowSet footRowSet = this.getFootRowSet(ctx, tempTable);
                size = null == footRowSet ? 0 : footRowSet.size();
                ArrayList<Map> footRowList = new ArrayList<Map>(size);
                if (size > 0) {
                    while (footRowSet.next()) {
                        footRowList.add(this.populateFooterData(footRowSet));
                    }
                }
                resultMap.put("footRowSet", footRowList);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return resultMap;
    }

    static {
        qtyPrecisionMap.put("CURMATSTOREQTY", "multiUnitqtyPrecision");
        qtyPrecisionMap.put("FCurStoreQty", "multiUnitqtyPrecision");
        qtyPrecisionMap.put("FReservationQty", "multiUnitqtyPrecision");
        qtyPrecisionMap.put("FRealQty", "multiUnitqtyPrecision");
        qtyPrecisionMap.put("FBaseQty", "multiBaseUnitqtyPrecision");
        qtyPrecisionMap.put("FReservationBaseQty", "multiBaseUnitqtyPrecision");
        qtyPrecisionMap.put("FRealBaseQty", "multiBaseUnitqtyPrecision");
        qtyPrecisionMap.put("FCurStoreAssistQty", "multiAssitUnitqtyPrecision");
        qtyPrecisionMap.put("FReservationAssistQty", "multiAssitUnitqtyPrecision");
        qtyPrecisionMap.put("FRealAssistQty", "multiAssitUnitqtyPrecision");
    }

    static class TableParam {
        private Vector<String> columnList = new Vector(20);
        private Vector<String> labelList = new Vector(20);
        private Vector<String> boolColumnList = new Vector();
        private String querySQL = null;
        private String createTempTableSQL = null;
        private String tmpTablefieldSQL = null;

        TableParam() {
        }

        public String getQuerySQL() {
            return this.querySQL;
        }

        public TableParam setQuerySQL(String querySQL) {
            this.querySQL = querySQL;
            return this;
        }

        public TableParam addColumn(int idx, String name, String label) {
            this.columnList.add(idx, name);
            this.labelList.add(idx, label);
            return this;
        }

        public TableParam addColumn(String name, String label) {
            this.columnList.add(name);
            this.labelList.add(label);
            return this;
        }

        public TableParam addColumn(String name) {
            this.columnList.add(name);
            this.labelList.add(name);
            return this;
        }

        public TableParam removeColumn(String name) {
            int idx = this.columnList.indexOf(name);
            if (idx > 0) {
                this.columnList.remove(idx);
                this.labelList.remove(idx);
            }
            return this;
        }

        public int getColumnIndex(String name) {
            return this.columnList.indexOf(name);
        }

        public String getCreateTempTableSQL() {
            return this.createTempTableSQL;
        }

        public TableParam setCreateTempTableSQL(String createTempTableSQL) {
            this.createTempTableSQL = createTempTableSQL;
            return this;
        }

        public String getTmpTablefieldSQL() {
            return this.tmpTablefieldSQL;
        }

        public TableParam setTmpTablefieldSQL(String tmpTablefieldSQL) {
            this.tmpTablefieldSQL = tmpTablefieldSQL;
            return this;
        }

        public Vector<String> getColumnList() {
            return this.columnList;
        }

        public Vector<String> getLabelList() {
            return this.labelList;
        }

        public Vector<String> getBoolColumnList() {
            return this.boolColumnList;
        }

        public TableParam addBoolColumn(String filedName) {
            this.boolColumnList.add(filedName);
            return this;
        }
    }
}

