/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.ISOAccreditWH;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.BillTypeUtils;
import com.kingdee.eas.scm.im.dt.DtTempFacadeFactory;
import com.kingdee.eas.scm.im.dt.IDtTempFacade;
import com.kingdee.eas.scm.im.inv.CalulateBalanceInfo;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.IDateOfMinDurability;
import com.kingdee.eas.scm.im.inv.IInventoryInitBill;
import com.kingdee.eas.scm.im.inv.IMaterialSerialNumber;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InvStartSystemException;
import com.kingdee.eas.scm.im.inv.InventoryBalanceInfo;
import com.kingdee.eas.scm.im.inv.InventoryInitBillFactory;
import com.kingdee.eas.scm.im.inv.InventoryInitBillInfo;
import com.kingdee.eas.scm.im.inv.InventoryInitEntryCollection;
import com.kingdee.eas.scm.im.inv.InventoryInitEntryInfo;
import com.kingdee.eas.scm.im.inv.InventoryUpdateFactory;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.app.AbstractInventoryInitBillControllerBean;
import com.kingdee.eas.scm.im.inv.util.RefreshInventoryUtil;
import com.kingdee.eas.scm.im.inv.vrule.app.CheckInvBizDate4PeriodVRule;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Vector;

public class InventoryInitBillControllerBean
extends AbstractInventoryInitBillControllerBean {
    private static final long serialVersionUID = 1L;

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._audit(ctx, pk);
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        Boolean isRefreshing;
        if (pk == null && model == null) {
            return;
        }
        InvBillBaseInfo invBillBaseInfo = (InvBillBaseInfo)model;
        if (invBillBaseInfo == null) {
            IInventoryInitBill iInventoryInitBill = InventoryInitBillFactory.getLocalInstance(ctx);
            invBillBaseInfo = iInventoryInitBill.getInventoryInitBillInfo(pk, this.getSelector());
        }
        if (pk == null && model != null) {
            pk = new ObjectUuidPK(((InvBillBaseInfo)model).getId());
        }
        if ((isRefreshing = RefreshInventoryUtil.isRefreshInventory(ctx, invBillBaseInfo.getStorageOrgUnit().getId().toString())).booleanValue()) {
            throw new InvBizException(InvBizException.REFRESH_CANNOTAUDIT);
        }
        invBillBaseInfo.setId(BOSUuid.read((String)pk.toString()));
        InvBillBaseInfo checkInfo = (InvBillBaseInfo)this.getDataNewStatus(ctx, (IObjectValue)invBillBaseInfo);
        this._checkAudit(ctx, (IObjectValue)checkInfo, true);
        this._checkSubmit(ctx, (IObjectValue)checkInfo, false);
        this.isSamePerson4Audit(ctx, invBillBaseInfo);
        Object[] os = this.getSOAccreditWHisStarted(ctx, (InventoryInitBillInfo)invBillBaseInfo);
        if (os != null && os.length > 0) {
            throw new InvStartSystemException(InvStartSystemException.IM_INV_CANTADUIT);
        }
        CheckInvBizDate4PeriodVRule bizDateVRule = new CheckInvBizDate4PeriodVRule(ctx);
        bizDateVRule.validate((IObjectValue)invBillBaseInfo);
        this.updateAuditStatus(ctx, model);
        if (paramMap.size() == 0) {
            IDtTempFacade fcd = DtTempFacadeFactory.getLocalInstance(ctx);
            String[] keys = new String[]{"isCloseInsertLot", "isCloseInvUpdate"};
            paramMap = fcd.getDtTempParams(keys);
        }
        if (paramMap.get("isCloseInsertLot") == null || !((Boolean)paramMap.get("isCloseInsertLot")).booleanValue()) {
            IDateOfMinDurability ido = DateOfMinDurabilityFactory.getLocalInstance(ctx);
            ido.insertData(pk, "528d806a-0106-1000-e000-0194c0a812e6463ED552");
        }
        if (paramMap.get("isCloseSerialNum") == null || !((Boolean)paramMap.get("isCloseSerialNum")).booleanValue()) {
            IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance(ctx);
            iMaterialSerialNumber.updateSerialInventory(invBillBaseInfo);
            invBillBaseInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
            MaterialSerialNumberFactory.getLocalInstance(ctx).updateMaterialSN(invBillBaseInfo);
        }
        if (!(ctx.get((Object)"isNeedUpdateInventory") != null || paramMap.get("isCloseInvUpdate") != null && ((Boolean)paramMap.get("isCloseInvUpdate")).booleanValue())) {
            InventoryUpdateFactory.getLocalInstance((Context)ctx).updateInventory(pk.toString(), BizActionEnum.AUDIT);
        }
        this.updateAccountView(ctx, model);
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        InventoryInitBillInfo iib = (InventoryInitBillInfo)model;
        if (model == null) {
            IInventoryInitBill iInventoryInitBill = InventoryInitBillFactory.getLocalInstance(ctx);
            iib = iInventoryInitBill.getInventoryInitBillInfo(pk, this.getSelector());
        }
        super.check4AccountClosed(ctx, pk);
        this._checkAudit(ctx, (IObjectValue)iib, false);
        this._checkUnAuditInParam(ctx, (IObjectValue)iib);
        if (iib.isIsReversed()) {
            throw new SCMBillException(SCMBillException.ISREVERSED_CANNOTUNAUDIT, new Object[]{iib.getNumber(), ""});
        }
        this._checkIsVouchered(ctx, (IObjectValue)iib, true);
        this._checkIsHaveDestBills(ctx, iib);
        if (iib.getStorageOrgUnit() == null) {
            return;
        }
        Boolean isRefreshing = RefreshInventoryUtil.isRefreshInventory(ctx, iib.getStorageOrgUnit().getId().toString());
        if (isRefreshing.booleanValue()) {
            throw new InvBizException(InvBizException.REFRESH_CANNOTAUDIT);
        }
        Object[] os = this.getSOAccreditWHisStarted(ctx, iib);
        if (os != null && os.length > 0) {
            throw new InvStartSystemException(InvStartSystemException.IM_INV_CANTUNADUIT);
        }
        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance(ctx);
        iMaterialSerialNumber.unAduitSerialInventory(iib);
        iib.setAuditor(null);
        iib.setAuditTime(null);
        this.updateUnAuditStatus(ctx, (IObjectValue)iib);
        InventoryUpdateFactory.getLocalInstance((Context)ctx).updateInventory(pk.toString(), BizActionEnum.UNAUDIT);
        this.clearAccountView(ctx, "T_IM_InventoryInitEntry", pk.toString());
        iib.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        iMaterialSerialNumber.updateMaterialSN(iib);
    }

    private Object[] getSOAccreditWHisStarted(Context ctx, InventoryInitBillInfo iib) throws BOSException, EASBizException {
        Vector<String> vecTemp = new Vector<String>();
        InventoryInitEntryCollection coll = iib.getEntry();
        if (coll != null && coll.size() > 0) {
            InventoryInitEntryInfo entryInfo = null;
            for (int i = 0; i < coll.size(); ++i) {
                entryInfo = coll.get(i);
                if (entryInfo.getWarehouse() == null) continue;
                vecTemp.add(entryInfo.getWarehouse().getId().toString());
            }
        }
        Object[] warehouseIDs = vecTemp.toArray();
        String storageOrgUnitID = iib.getStorageOrgUnit().getId().toString();
        ISOAccreditWH iSOAccreditWH = SOAccreditWHFactory.getLocalInstance((Context)ctx);
        Object[] os = iSOAccreditWH.isStarted(storageOrgUnitID, warehouseIDs, true);
        return os;
    }

    @Override
    protected boolean isCheckCloseAccount() throws EASBizException, BOSException {
        return true;
    }

    @Override
    protected SelectorItemCollection getSelector() {
        return SCMSelectorFactory.getInventoryInitBillSelector((boolean)true);
    }

    @Override
    protected boolean isCheckBizDate() throws EASBizException, BOSException {
        return false;
    }

    @Override
    protected boolean _startInvSystem(Context ctx) throws BOSException, EASBizException {
        return this.updateBalance(ctx);
    }

    private boolean updateBalance(Context ctx) throws BOSException, EASBizException {
        PeriodInfo startPeriodInfo = this.checkStartSystem(ctx);
        if (startPeriodInfo == null) {
            return false;
        }
        int startPeriod = startPeriodInfo.getPeriodNumber();
        int startYear = startPeriodInfo.getPeriodYear();
        this.insertInvBalTable(ctx, startPeriod, startYear);
        return true;
    }

    private PeriodInfo checkStartSystem(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        if (SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo)) {
            throw new InvStartSystemException(InvStartSystemException.IM_INV_SYSTEMSTARTED);
        }
        if (startPeriodInfo == null) {
            throw new InvStartSystemException(InvStartSystemException.IM_INV_NOTPERIOD);
        }
        if (!this.checkInvBillIsAudit(ctx)) {
            throw new InvStartSystemException(InvStartSystemException.IM_INV_BILLNOTAUDIT);
        }
        if (!this.checkInvBillHasZeroAmount(ctx)) {
            throw new InvStartSystemException(InvStartSystemException.IM_INV_AMOUNTPRICEERROR);
        }
        return startPeriodInfo;
    }

    private boolean checkInvBillIsAudit(Context ctx) throws EASBizException, BOSException {
        IRowSet rs = null;
        StringBuffer sqlBuffer = new StringBuffer();
        String sql = "";
        sqlBuffer.append("SELECT COUNT(FID) AS FROWS ");
        sqlBuffer.append("FROM T_IM_InventoryInitBill ");
        sqlBuffer.append("WHERE FBaseStatus <> 4 ");
        sqlBuffer.append("AND FBaseStatus <> 3; ");
        sql = sqlBuffer.toString();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            rs.next();
            return rs.getInt("FROWS") <= 0;
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private boolean checkInvBillHasZeroAmount(Context ctx) throws EASBizException, BOSException {
        IRowSet rs = null;
        StringBuffer sqlBuffer = new StringBuffer();
        String sql = "";
        sqlBuffer.append("SELECT COUNT(FID) AS FROWS FROM T_IM_InventoryInitEntry ");
        sqlBuffer.append("WHERE FAMOUNT = 0 OR FCOSTPRICE < 0; ");
        sql = sqlBuffer.toString();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            rs.next();
            return rs.getInt("FROWS") <= 0;
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    public String getCalBalBOSType(Context ctx) throws InvalidDAOMetaDataException {
        return new CalulateBalanceInfo().getBOSType().toString();
    }

    public String getInvBalBOSType(Context ctx) throws InvalidDAOMetaDataException {
        return new InventoryBalanceInfo().getBOSType().toString();
    }

    private void insertInvBalTable(Context ctx, int startPeriod, int startYear) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("INSERT INTO T_IM_InventoryBalance");
        sqlBuffer.append("( ");
        sqlBuffer.append("FStoreOrgUnitID, ");
        sqlBuffer.append("FWarehouseID, ");
        sqlBuffer.append("FLocationID, ");
        sqlBuffer.append("FStoreStateID, ");
        sqlBuffer.append("FAssistantAttrID, ");
        sqlBuffer.append(this.getShareWriteInertSql());
        sqlBuffer.append("SELECT ");
        sqlBuffer.append("ISNULL(b.FStorageOrgUnit,''), ");
        sqlBuffer.append("ISNULL(FWarehouse,''), ");
        sqlBuffer.append("ISNULL(FLocation,''), ");
        sqlBuffer.append("ISNULL(FStoreState,''), ");
        sqlBuffer.append("ISNULL(FAssistantAttr,''), ");
        sqlBuffer.append("NEWBOSID('" + this.getInvBalBOSType(ctx) + "'), ");
        sqlBuffer.append(this.getShareWriteSelectSql(startPeriod, startYear));
        sqlBuffer.append("GROUP BY b.FCompanyOrgID,FMaterialID,FBatch,FSeqInterID, ");
        sqlBuffer.append("b.FStorageOrgUnit,FWarehouse,FLocation,FStoreState,FAssistantAttr; ");
        String sql = sqlBuffer.toString();
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private String getShareWriteInertSql() throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        String sql = "";
        sqlBuffer.append("FID, ");
        sqlBuffer.append("FPeriod, ");
        sqlBuffer.append("FPeriodYear, ");
        sqlBuffer.append("FCompanyOrgUnitID, ");
        sqlBuffer.append("FMaterialID, ");
        sqlBuffer.append("FBatchNO, ");
        sqlBuffer.append("FSequenceID, ");
        sqlBuffer.append("FPeriodBeginQty, ");
        sqlBuffer.append("FPeriodEndQty, ");
        sqlBuffer.append("FPeriodReceiveQty, ");
        sqlBuffer.append("FPeriodIssueQty, ");
        sqlBuffer.append("FPeriodBeginAssitQty, ");
        sqlBuffer.append("FPeriodEndAssitQty, ");
        sqlBuffer.append("FPeriodReceiveAssitQty, ");
        sqlBuffer.append("FPeriodIssueAssitQty, ");
        sqlBuffer.append("FPeriodBeginBalance, ");
        sqlBuffer.append("FPeriodEndBalance, ");
        sqlBuffer.append("FPeriodReceiveAmount, ");
        sqlBuffer.append("FPeriodIssueAmount, ");
        sqlBuffer.append("FPeriodBeginCostDiff, ");
        sqlBuffer.append("FPeriodEndCostDiff, ");
        sqlBuffer.append("FPeriodReceiveCostDiff, ");
        sqlBuffer.append("FPeriodIssueCostDiff, ");
        sqlBuffer.append("FYearIssueAmount, ");
        sqlBuffer.append("FYearReceiveAmount, ");
        sqlBuffer.append("FYearReceiveQty, ");
        sqlBuffer.append("FYearIssueQty, ");
        sqlBuffer.append("FYearReceiveAssitQty, ");
        sqlBuffer.append("FYearIssueAssitQty, ");
        sqlBuffer.append("FYearReceiveCostDiff, ");
        sqlBuffer.append("FYearIssueCostDiff ");
        sqlBuffer.append(")");
        sql = sqlBuffer.toString();
        return sql;
    }

    private String getShareWriteSelectSql(int startPeriod, int startYear) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        String sql = "";
        sqlBuffer.append(startPeriod + ", ");
        sqlBuffer.append(startYear + ", ");
        sqlBuffer.append("b.FCompanyOrgID, ");
        sqlBuffer.append("FMaterialID, ");
        sqlBuffer.append("ISNULL(FBatch,''), ");
        sqlBuffer.append("FSeqInterID, ");
        sqlBuffer.append("SUM(ISNULL(FQty,0)), ");
        sqlBuffer.append("SUM(ISNULL(FQty,0)+ISNULL(FYearReceiveQty,0)-ISNULL(FYearIssueQty,0)) AS FPeriodEndQty, ");
        sqlBuffer.append("0 AS FPeriodReceiveQty, ");
        sqlBuffer.append("0 AS FPeriodIssueQty, ");
        sqlBuffer.append("SUM(ISNULL(FAssitQty,0)) as FPeriodBeginAssitQty, ");
        sqlBuffer.append("SUM(ISNULL(FAssitQty,0)+ISNULL(FYearReceiveAssitQty,0)-ISNULL(FYearIssueAssitQty,0)) AS FPeriodEndAssitQty, ");
        sqlBuffer.append("0 AS FPeriodReceiveAssitQty, ");
        sqlBuffer.append("0 AS FPeriodIssueAssitQty, ");
        sqlBuffer.append("SUM(FAmount) AS FPeriodBeginBalance, ");
        sqlBuffer.append("SUM(ISNULL(FAmount,0)+ISNULL(FYearReceiveAmount,0)-ISNULL(FYearIssueAmount,0)) AS FPeriodEndBalance, ");
        sqlBuffer.append("0 AS FPeriodReceiveAmount, ");
        sqlBuffer.append("0 AS FPeriodIssueAmount,");
        sqlBuffer.append("SUM(ISNULL(FDiffAmount,0)) AS FPeriodBeginCostDiff, ");
        sqlBuffer.append("SUM(ISNULL(FDiffAmount,0)+ISNULL(FYearReceiveCostDiff,0)-ISNULL(FYearIssueCostDiff,0)) AS FPeriodEndCostDiff, ");
        sqlBuffer.append("0 AS FPeriodReceiveCostDiff, ");
        sqlBuffer.append("0 AS FPeriodIssueCostDiff, ");
        sqlBuffer.append("SUM(ISNULL(FYearIssueAmount,0)) AS FYearReceiveAmount, ");
        sqlBuffer.append("SUM(ISNULL(FYearReceiveAmount,0)) AS FYearIssueAmount, ");
        sqlBuffer.append("SUM(ISNULL(FYearReceiveQty,0)) AS FYearReceiveQty, ");
        sqlBuffer.append("SUM(ISNULL(FYearIssueQty,0)) AS FYearIssueQty, ");
        sqlBuffer.append("SUM(ISNULL(FYearReceiveAssitQty,0)) AS FYearReceiveAssitQty, ");
        sqlBuffer.append("SUM(ISNULL(FYearIssueAssitQty,0)) AS FYearIssueAssitQty, ");
        sqlBuffer.append("SUM(ISNULL(FYearReceiveCostDiff,0)) AS FYearReceiveCostDiff, ");
        sqlBuffer.append("SUM(ISNULL(FYearIssueCostDiff,0)) AS FYearIssueCostDiff ");
        sqlBuffer.append("FROM ");
        sqlBuffer.append("T_IM_InventoryInitEntry a ");
        sqlBuffer.append("INNER JOIN ");
        sqlBuffer.append("T_IM_InventoryInitBill b ");
        sqlBuffer.append("ON a.FParentID = b.FID ");
        sql = sqlBuffer.toString();
        return sql;
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            IObjectPK pk = super.submitWithoutBusiness(ctx, model);
            return pk;
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSubmitRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    private void updateAccountView(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InventoryInitBillInfo billInfo = (InventoryInitBillInfo)model;
        String entryTableName = BillTypeUtils.getBillEntryTableName((Context)ctx, (String)billInfo.getBillType().getId().toString());
        StringBuffer sql = new StringBuffer();
        sql.append("update " + entryTableName + " T \r\n");
        sql.append("set (FAccountViewId) =\r\n");
        sql.append("(select T4.FID as faccount  from T_BD_MaterialCompanyInfo T1  \r\n");
        sql.append("INNER JOIN T_BD_KAClassificationDetail T2 on T1.FKAClassID = T2.FKaclassficlink \r\n");
        sql.append("INNER JOIN T_BD_KAccountItem T3 on T2.FAccountitemlinkID = T3.FID \r\n");
        sql.append("INNER JOIN T_BD_AccountView T4  ON T2.FAccountlinkID = T4.FID \r\n");
        sql.append("where T1.fmaterialId = T.FmaterialId and T.FCompanyOrgUnitID = T1.FcompanyId and T3.FNumber = '1001')\r\n");
        sql.append("where T.fparentid = '" + billInfo.getId().toString() + "'\r\n");
        sql.append(" and T.FAccountViewId is null \r\n");
        DBUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void clearAccountView(Context ctx, String entryTableName, String id) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append("update " + entryTableName + "\r\n");
        sqlBuff.append("set FaccountviewInId = null,FaccountviewOutId=null\r\n");
        sqlBuff.append("where FparentId = '" + id + "'");
        DBUtil.execute((Context)ctx, (String)sqlBuff.toString());
    }

    public BatchActionResults batchSubmitOrSave(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchAction) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, batchAction);
    }
}

