/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class LockInventoryUtils {
    public static final String BILLID = "FBillID";
    public static final String BILLENTRYID = "FBillEntryID";
    public static final String INVENTORYID = "FInventoryID";
    public static final String BILLNUMBER = "FBillNumber";
    public static final String BILLTYPEID = "FBillTypeID";
    public static final String WAREHOUSEID = "FWarehouseID";
    public static final String LOCATIONID = "FLocationID";
    public static final String LOT = "Flot";
    public static final String STORETYPEID = "FStoreTypeID";
    public static final String STORESTATEID = "FStoreStateID";
    public static final String LOCKQTY = "FLockQty";
    public static final String LOCKBASEQTY = "FLockBaseQty";
    public static final String LOCKASSISTQTY = "FLockAssistQty";
    public static final String EMPTYBOSTYPE = "11223344";
    public static final String LOGID = "FLogId";

    public static String getEntryIdsFromMap(Map[] maps) {
        StringBuffer ids = new StringBuffer();
        int length = maps.length;
        for (int i = 0; i < length; ++i) {
            if (maps[i] == null || maps[i].get(BILLENTRYID) == null) continue;
            ids.append(",'").append(maps[i].get(BILLENTRYID)).append("'");
        }
        if (ids.length() > 0) {
            return ids.substring(1);
        }
        return ids.toString();
    }

    public static String toPlainString(BigDecimal bd) {
        if (bd == null) {
            return null;
        }
        String subString = bd.abs().toString();
        if (subString.indexOf("-") == -1) {
            return bd.toString();
        }
        StringBuffer st = new StringBuffer();
        if (bd.signum() == -1) {
            st.append("-");
        }
        String[] nums = subString.split("-");
        int length = Integer.valueOf(nums[1]);
        for (int i = 0; i < length; ++i) {
            if (i == 1) {
                st.append(".");
            }
            st.append("0");
        }
        st.append(bd.unscaledValue().abs());
        return st.toString();
    }

    public static void checkOrderLockInventory(Context ctx, String entryIds) throws InvUpdateException, BOSException {
        Locale loc = ctx.getLocale();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct mat.FNumber,mat.FName_").append(loc).append(",inv.FId,so.FNumber from T_IM_INVENTORY inv ");
        sql.append("left join T_BD_MATERIAL mat on inv.FMaterialID = mat.FID ");
        sql.append("left join T_IM_LOCKINVENTORY lockInv on inv.FID = lockInv.FInventoryID ");
        sql.append("left join T_SD_SALEORDER so on so.FID = lockInv.FBillID ");
        sql.append("WHERE lockInv.FBillEntryID in (").append(entryIds).append(")");
        sql.append(" and (inv.FCurStoreQty < 0 or inv.FLockQty < 0 or lockInv.FLockQty < 0)");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            StringBuffer message = new StringBuffer();
            String temp = ResourceUtil.getMessage((Context)ctx, (String)"com.kingdee.eas.scm.im.SCM_IMResource", (String)"BillNum_MaterialNum_MaterialName", null);
            message.append(temp);
            boolean throwExp = false;
            while (rs.next()) {
                message.append(rs.getString(4)).append("   ");
                message.append(rs.getString(1)).append("            ");
                message.append(rs.getString(2)).append("\n");
                throwExp = true;
            }
            if (throwExp) {
                throw new InvUpdateException(InvUpdateException.INVENTORY_WILL_LESS_THAN_ZERO, new Object[]{message.toString()});
            }
        }
        catch (SQLException e) {
            Logger.error((Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void checkNegativeInventory(Context ctx, String inventoryIds, String tempTableName) throws BOSException, InvUpdateException {
        Locale loc = ctx.getLocale();
        StringBuffer sqlBuffer = null;
        StringBuffer message = null;
        sqlBuffer = new StringBuffer();
        sqlBuffer.append("select distinct mat.FNumber,mat.FName_").append(loc).append(",inv.FId,temp.FBillNumber from T_IM_INVENTORY inv ");
        sqlBuffer.append("left join T_BD_MATERIAL mat on inv.FMaterialID = mat.FID ");
        sqlBuffer.append("left join T_IM_LOCKINVENTORY lockInv on inv.FID = lockInv.FInventoryID ");
        sqlBuffer.append("left join  ").append(tempTableName).append(" temp on temp.FInventoryID = inv.FID ");
        sqlBuffer.append("WHERE inv.FID in (").append(inventoryIds).append(")");
        sqlBuffer.append(" and (inv.FCurStoreQty < 0 or inv.FLockQty < 0 or lockInv.FLockQty < 0)");
        boolean throwExp = false;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            message = new StringBuffer();
            String temp = ResourceUtil.getMessage((Context)ctx, (String)"com.kingdee.eas.scm.im.SCM_IMResource", (String)"BillNum_MaterialNum_MaterialName", null);
            message.append(temp);
            while (rs.next()) {
                message.append(rs.getString(4)).append("   ");
                message.append(rs.getString(1)).append("            ");
                message.append(rs.getString(2)).append("\n");
                throwExp = true;
            }
            if (throwExp) {
                throw new InvUpdateException(InvUpdateException.INVENTORY_WILL_LESS_THAN_ZERO, new Object[]{message.toString()});
            }
        }
        catch (SQLException e) {
            Logger.error((Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] logBeforeOpInventory4SaleOrder(Context ctx, HashMap[] params, String op) {
        StringBuffer insertSql = new StringBuffer();
        Connection conn = null;
        Statement statement = null;
        String[] logIds = new String[params.length];
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            StringBuffer sql = new StringBuffer();
            sql.append("insert into T_IM_LockInventoryLog(FId,FInventoryId,FBillEntryId,FOperation,FLockQty,FLockBaseQty,FLockAssistQty,");
            sql.append("FBillTypeId,FWarehouseId,FLocationId,FStoreTypeId,FStoreStateId,FBillNumber,FLot,FCompanyOrgUnitId,");
            sql.append("FStorageOrgUnitId,FMaterialId,FSeq,FQty,FBaseQty,FAssistQty,FPreQty,FPreBaseQty,FPreAssistQty,FInsertDate,FProjectID,FTrackNumberID) ");
            int length = params.length;
            for (int i = 0; i < length; ++i) {
                insertSql.setLength(0);
                logIds[i] = BOSUuid.create((String)EMPTYBOSTYPE).toString();
                insertSql.append(sql.toString());
                insertSql.append("select '").append(logIds[i]).append("' as FId,'");
                insertSql.append(params[i].get(INVENTORYID).toString()).append("' as FInventoryId,'");
                insertSql.append((String)params[i].get(BILLENTRYID)).append("' as FBillEntryId,'");
                insertSql.append(op).append("' as FOperation,");
                insertSql.append(params[i].get(LOCKQTY) == null ? Integer.valueOf(0) : (BigDecimal)params[i].get(LOCKQTY)).append(" as FLockQty,");
                insertSql.append(params[i].get(LOCKBASEQTY) == null ? Integer.valueOf(0) : (BigDecimal)params[i].get(LOCKBASEQTY)).append(" as FLockBaseQty,");
                insertSql.append(params[i].get(LOCKASSISTQTY) == null ? Integer.valueOf(0) : (BigDecimal)params[i].get(LOCKASSISTQTY)).append(" as FLockAssistQty,");
                insertSql.append("C.FBillTypeId,");
                insertSql.append("case when B.FWarehouseId = '").append("EgkAAABc3XG76fiu").append("' then null else B.FWarehouseId end,");
                insertSql.append("case when\tB.FLocationId = '").append("EgkAAABc3XMgX/hq").append("' then null else B.FLocationId end,");
                insertSql.append("B.FStoreTypeId,B.FStoreStatusId,C.FNumber,");
                insertSql.append("case when B.FLot = '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' then null else B.FLot end, ");
                insertSql.append("A.FCompanyOrgUnitId,A.FStorageOrgUnitId,A.FMaterialId,A.FSeq,A.FQty,A.FBaseQty,A.FAssistQty,");
                insertSql.append("B.FCurStoreQty,B.FBaseQty,B.FCurStoreAssistQty,now(),");
                insertSql.append("case when B.FProjectID = '").append("EgkAAABc3Xza3gXu").append("' then null else B.FProjectID end,");
                insertSql.append(" case when B.FTrackNumberID = '").append("EgkAAABc3X0Ibpg9").append("' then null else B.FTrackNumberID end ");
                insertSql.append("from T_SD_SaleOrderEntry A,T_IM_Inventory B,T_SD_SaleOrder C ");
                insertSql.append("where C.FId = A.FParentId and A.FId = '").append((String)params[i].get(BILLENTRYID)).append("'");
                insertSql.append(" and B.FId = '").append(params[i].get(INVENTORYID).toString()).append("'");
                statement.addBatch(insertSql.toString());
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            try {
                Logger.error((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)statement, (Connection)conn);
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
        return logIds;
    }

    public static String[] logBeforeAutoCloseInventory(Context ctx, IObjectPK[] entryPks, String op) throws BOSException {
        String ids = StringUtil.getKeyIdList((Object[])entryPks);
        StringBuffer dropSql = new StringBuffer();
        dropSql.append("SELECT 1 From KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_IM_LockInventoryLogTemp'");
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("select newBOSid('").append(EMPTYBOSTYPE).append("') as FId,d.FWarehouseId,d.FLocationId,d.FStoreTypeId,d.FStoreStatusId,d.FId as FInventoryId,b.FNumber,b.FBillTypeId,");
        insertSql.append("a.FId as FBillEntryId,");
        insertSql.append("case when d.FLot = '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' then null else d.FLot end as FLot,");
        insertSql.append("'" + op + "' as FOperation,a.FCompanyOrgUnitId,a.FStorageOrgUnitId,a.FMaterialId,a.FSeq,a.FQty,a.FBaseQty,");
        insertSql.append("isnull(a.FAssistQty,0) as FAssistQty,c.FLockQty,c.FLockBaseQty,c.FLockAssistQty,d.FCurStoreQty,d.FBaseQty as FPreBaseQty,d.FCurStoreAssistQty,now() as FInsertDate,c.FProjectID,c.FTrackNumberID ");
        insertSql.append("into T_IM_LockInventoryLogTemp from T_SD_SaleOrderEntry a left join T_SD_SaleOrder b on a.FParentId = b.FId ");
        insertSql.append("right join T_IM_LockInventory c on a.FId = c.FBillEntryId ");
        insertSql.append("left join T_IM_Inventory d on d.FId = c.FInventoryId ");
        insertSql.append("where a.FId in (").append(ids).append(")");
        String[] logIds = null;
        try {
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)dropSql.toString());
            if (result.next()) {
                DbUtil.execute((Context)ctx, (String)"drop table T_IM_LockInventoryLogTemp");
            }
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
            StringBuffer insert = new StringBuffer();
            insert.append("insert into T_IM_LockInventoryLog(FId,FWarehouseId,FLocationId,FStoreTypeId,FStoreStateId,FInventoryId,");
            insert.append("FBillNumber,FBillTypeId,FBillEntryId,FLot,FOperation,FCompanyOrgUnitId,FStorageOrgUnitId,FMaterialId,FSeq,");
            insert.append("FQty,FBaseQty,FAssistQty,FLockQty,FLockBaseQty,FLockAssistQty,FPreQty,FPreBaseQty,FPreAssistQty,FInsertDate,FProjectID,FTrackNumberID) ");
            insert.append("select * from T_IM_LockInventoryLogTemp");
            DbUtil.execute((Context)ctx, (String)insert.toString());
            StringBuffer selectSql = new StringBuffer();
            selectSql.append("select FId from T_IM_LockInventoryLogTemp");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            int i = 0;
            if (rs != null && rs.size() > 0) {
                logIds = new String[rs.size()];
                while (rs.next()) {
                    logIds[i] = rs.getString("FID");
                    ++i;
                }
            }
            DbUtil.execute((Context)ctx, (String)"drop table T_IM_LockInventoryLogTemp");
        }
        catch (SQLException e) {
            Logger.error((Throwable)e);
        }
        return logIds;
    }

    public static void logAfterOpInventory(Context ctx, String[] logIds) throws BOSException {
        if (logIds == null) {
            return;
        }
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_IM_LockInventoryLog set (FPostQty,FPostBaseQty,FPostAssistQty) = ");
        updateSql.append("(select ii.FCurStoreQty,ii.FBaseQty,ii.FCurStoreAssistQty from T_IM_Inventory ii where ii.FId = T_IM_LockInventoryLog.FInventoryId) ");
        updateSql.append("where T_IM_LockInventoryLog.FId = ? ");
        Connection conn = null;
        PreparedStatement psUpdate = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            psUpdate = conn.prepareStatement(updateSql.toString());
            int length = logIds.length;
            for (int i = 0; i < length; ++i) {
                psUpdate.setString(1, logIds[i]);
                psUpdate.addBatch();
            }
            psUpdate.executeBatch();
        }
        catch (SQLException e) {
            try {
                Logger.error((Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(psUpdate, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)psUpdate, (Connection)conn);
    }

    public static void log4SaleIssue(Context ctx, String tmpTable, String op) throws BOSException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into T_IM_LockInventoryLog(FId,FWarehouseId,FLocationId,FStoreTypeId,FStoreStateId,FInventoryId,");
        insertSql.append("FBillNumber,FBillTypeId,FBillEntryId,FLot,FOperation,FCompanyOrgUnitId,FStorageOrgUnitId,FMaterialId,FSeq,");
        insertSql.append("FQty,FBaseQty,FAssistQty,FLockQty,FLockBaseQty,FLockAssistQty,FPostQty,FPostBaseQty,FPostAssistQty,FInsertDate,");
        insertSql.append("FPreQty,FPreBaseQty,FPreAssistQty,FProjectID,FTrackNumberID) ");
        insertSql.append("select NewBosId('").append(EMPTYBOSTYPE).append("'),");
        insertSql.append("c.FWarehouseId,c.FLocationId,c.FStoreTypeId,c.FStoreStatusId,c.FId,a.FBillNumber,'");
        insertSql.append("50957179-0105-1000-e000-015bc0a812fd463ED552").append("',");
        insertSql.append("b.FId,a.FLot,'" + op + "',a.FCompanyOrgUnitId,a.FStorageOrgUnitId,a.FMaterialId,a.FSeq,a.FQty,a.FBaseQty,");
        insertSql.append("a.FAssistQty,a.FQty,a.FBaseQty,a.FAssistQty,c.FCurStoreQty,c.FBaseQty,c.FCurStoreAssistQty,now(),");
        insertSql.append("case a.FPreInvQty when 0 then a.FInvQty else FPreInvQty end,");
        insertSql.append("case a.FPreInvBaseQty when 0 then a.FInvBaseQty else FPreInvBaseQty end,");
        insertSql.append("case a.FPreInvAssistQty when 0 then a.FInvAssistQty else FPreInvAssistQty end, ");
        insertSql.append("a.FProjectID,a.FTrackNumberID ");
        insertSql.append("from ").append(tmpTable).append(" a left join T_IM_SaleIssueEntry b on a.FBillEntryID = b.FId ");
        insertSql.append("left join T_IM_Inventory c on c.FId = b.FInventoryId ");
        insertSql.append("where a.FIsLocked = 1");
        try {
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }
}

